/*  Prototype JavaScript framework, version 1.7
 *  (c) 2005-2010 Sam Stephenson
 *
 *  Prototype is freely distributable under the terms of an MIT-style license.
 *  For details, see the Prototype web site: http://www.prototypejs.org/
 *
 *--------------------------------------------------------------------------*/
/**
 * IMPORTANT: When upgrading this script you must fix the stack overflow error
 * It happens on the submissions page. In order to fix that error just change all "defer"s to "p_defer"
 * defer name is already used in Ext.js and it causes problems on Internet explorer
 */
var Prototype = {

  Version: '1.7',

  Browser: (function(){
    var ua = navigator.userAgent;
    var isOpera = Object.prototype.toString.call(window.opera) == '[object Opera]';
    return {
      IE:             !!window.attachEvent && !isOpera,
      IE9:            ('documentMode' in document) && document.documentMode == 9,
      IE10:            ('documentMode' in document) && document.documentMode == 10,
      Opera:          isOpera,
      WebKit:         ua.indexOf('AppleWebKit/') > -1,
      Gecko:          ua.indexOf('Gecko') > -1 && ua.indexOf('KHTML') === -1,
      MobileSafari:   /Apple.*Mobile/.test(ua)
    }
  })(),

  BrowserFeatures: {
    XPath: !!document.evaluate,

    SelectorsAPI: !!document.querySelector,

    ElementExtensions: (function() {
      var constructor = window.Element || window.HTMLElement;
      return !!(constructor && constructor.prototype);
    })(),
    SpecificElementExtensions: (function() {
      if (typeof window.HTMLDivElement !== 'undefined')
        return true;

      var div = document.createElement('div'),
          form = document.createElement('form'),
          isSupported = false;

      if (div['__proto__'] && (div['__proto__'] !== form['__proto__'])) {
        isSupported = true;
      }

      div = form = null;

      return isSupported;
    })()
  },
  jsInlineEvents : [
              'onabort', 'onactivate', 'onafterprint', 'onafterscriptexecute', 'onafterupdate', 'onbeforeactivate', 'onbeforecopy',
              'onbeforecut', 'onbeforedeactivate', 'onbeforeeditfocus', 'onbeforepaste', 'onbeforeprint', 'onbeforescriptexecute', 
              'onbeforeunload', 'onbeforeupdate', 'onbegin', 'onblur', 'onbounce', 'oncancel', 'oncanplay', 'oncanplaythrough',
              'oncellchange', 'onchange', 'onclick', 'onclose', 'oncontextmenu', 'oncontrolselect', 'oncopy', 'onctextmenu', 
              'oncuechange', 'oncut', 'ondataavailable', 'ondatasetchanged', 'ondatasetcomplete', 'ondblclick', 'ondeactivate',
              'ondrag', 'ondragdrop', 'ondragend', 'ondragenter', 'ondragleave', 'ondragover', 'ondragstart', 'ondrop', 'ondurationchange',
              'onemptied', 'onend', 'onended', 'onerror', 'onerrorupdate', 'onfilterchange', 'onfinish', 'onfocus', 'onfocusin', 'onfocusout',
              'onhashchange', 'onhelp', 'oninput', 'oninvalid', 'onkeydown', 'onkeypress', 'onkeyup', 'onlayoutcomplete', 'onload', 'onloadeddata',
              'onloadedmetadata', 'onloadstart', 'onlosecapture', 'onmediacomplete', 'onmediaerror', 'onmessage', 'onmousedown',
              'onmouseenter', 'onmouseleave', 'onmousemove', 'onmouseout', 'onmouseover', 'onmouseup', 'onmousewheel', 'onmove', 'onmoveend',
              'onmovestart', 'onoffline', 'ononline', 'onoutofsync', 'onpagehide', 'onpageshow', 'onpaste', 'onpause', 'onplay', 'onplaying',
              'onpopstate', 'onprogress', 'onpropertychange', 'onratechange', 'onreadystatechange', 'onredo', 'onrepeat', 'onreset', 'onresize', 
              'onresizeend', 'onresizestart', 'onresume', 'onreverse', 'onrowdelete', 'onrowexit', 'onrowinserted', 'onrowsenter', 'onscroll',
              'onsearch', 'onseek', 'onseeked', 'onseeking', 'onselect', 'onselectionchange', 'onselectstart', 'onshow', 'onstalled', 'onstart',
              'onstop', 'onstorage', 'onsubmit', 'onsuspend', 'onsyncrestored', 'ontimeerror', 'ontimeupdate', 'ontoggle', 'ontouchcancel',
              'ontouchend', 'ontouchmove', 'ontouchstart', 'ontrackchange', 'onundo', 'onunload', 'onurlflip', 'onvolumechange',
              'onwaiting', 'onwheel'
            ],
  ScriptFragment: '<script[^>]*>([\\S\\s]*?)<\/script>|prompt\s*[(]|alert\s*[(]|',
  JSONFilter: /^\/\*-secure-([\s\S]*)\*\/\s*$/,

  emptyFunction: function() { },

  K: function(x) { return x }
};

if (Prototype.Browser.MobileSafari)
  Prototype.BrowserFeatures.SpecificElementExtensions = false;

NodeList.prototype.filter = Array.prototype.filter;
var Abstract = { };


var Try = {
  these: function() {
    var returnValue;

    for (var i = 0, length = arguments.length; i < length; i++) {
      var lambda = arguments[i];
      try {
        returnValue = lambda();
        break;
      } catch (e) { }
    }

    return returnValue;
  }
};

/* Based on Alex Arnell's inheritance implementation. */

var Class = (function() {

  var IS_DONTENUM_BUGGY = (function(){
    for (var p in { toString: 1 }) {
      if (p === 'toString') return false;
    }
    return true;
  })();

  function subclass() {};
  function create() {
    var parent = null, properties = $A(arguments);
    if (Object.isFunction(properties[0]))
      parent = properties.shift();

    function klass() {
      this.initialize.apply(this, arguments);
    }

    Object.extend(klass, Class.Methods);
    klass.superclass = parent;
    klass.subclasses = [];

    if (parent) {
      subclass.prototype = parent.prototype;
      klass.prototype = new subclass;
      parent.subclasses.push(klass);
    }

    for (var i = 0, length = properties.length; i < length; i++)
      klass.addMethods(properties[i]);

    if (!klass.prototype.initialize)
      klass.prototype.initialize = Prototype.emptyFunction;

    klass.prototype.constructor = klass;
    return klass;
  }

  function addMethods(source) {
    var ancestor   = this.superclass && this.superclass.prototype,
        properties = Object.keys(source);

    if (IS_DONTENUM_BUGGY) {
      if (source.toString != Object.prototype.toString)
        properties.push("toString");
      if (source.valueOf != Object.prototype.valueOf)
        properties.push("valueOf");
    }

    for (var i = 0, length = properties.length; i < length; i++) {
      var property = properties[i], value = source[property];
      if (ancestor && Object.isFunction(value) &&
          value.argumentNames()[0] == "$super") {
        var method = value;
        value = (function(m) {
          return function() { return ancestor[m].apply(this, arguments); };
        })(property).wrap(method);

        value.valueOf = method.valueOf.bind(method);
        value.toString = method.toString.bind(method);
      }
      this.prototype[property] = value;
    }

    return this;
  }

  return {
    create: create,
    Methods: {
      addMethods: addMethods
    }
  };
})();
(function() {

  var _toString = Object.prototype.toString,
      NULL_TYPE = 'Null',
      UNDEFINED_TYPE = 'Undefined',
      BOOLEAN_TYPE = 'Boolean',
      NUMBER_TYPE = 'Number',
      STRING_TYPE = 'String',
      OBJECT_TYPE = 'Object',
      FUNCTION_CLASS = '[object Function]',
      BOOLEAN_CLASS = '[object Boolean]',
      NUMBER_CLASS = '[object Number]',
      STRING_CLASS = '[object String]',
      ARRAY_CLASS = '[object Array]',
      DATE_CLASS = '[object Date]',
      NATIVE_JSON_STRINGIFY_SUPPORT = window.JSON &&
        typeof JSON.stringify === 'function' &&
        JSON.stringify(0) === '0' &&
        typeof JSON.stringify(Prototype.K) === 'undefined';

  function Type(o) {
    switch(o) {
      case null: return NULL_TYPE;
      case (void 0): return UNDEFINED_TYPE;
    }
    var type = typeof o;
    switch(type) {
      case 'boolean': return BOOLEAN_TYPE;
      case 'number':  return NUMBER_TYPE;
      case 'string':  return STRING_TYPE;
    }
    return OBJECT_TYPE;
  }

  function extend(destination, source) {
    for (var property in source)
      destination[property] = source[property];
    return destination;
  }

  function inspect(object) {
    try {
      if (isUndefined(object)) return 'undefined';
      if (object === null) return 'null';
      return object.inspect ? object.inspect() : String(object);
    } catch (e) {
      if (e instanceof RangeError) return '...';
      throw e;
    }
  }

  function toJSON(value) {
    return Str('', { '': value }, []);
  }

  function Str(key, holder, stack) {
    var value = holder[key],
        type = typeof value;

    if (Type(value) === OBJECT_TYPE && typeof value.toJSON === 'function') {
      value = value.toJSON(key);
    }

    var _class = _toString.call(value);

    switch (_class) {
      case NUMBER_CLASS:
      case BOOLEAN_CLASS:
      case STRING_CLASS:
        value = value.valueOf();
    }

    switch (value) {
      case null: return 'null';
      case true: return 'true';
      case false: return 'false';
    }

    type = typeof value;
    switch (type) {
      case 'string':
        return value.inspect(true);
      case 'number':
        return isFinite(value) ? String(value) : 'null';
      case 'object':

        for (var i = 0, length = stack.length; i < length; i++) {
          if (stack[i] === value) { throw new TypeError(); }
        }
        stack.push(value);

        var partial = [];
        if (_class === ARRAY_CLASS) {
          for (var i = 0, length = value.length; i < length; i++) {
            var str = Str(i, value, stack);
            partial.push(typeof str === 'undefined' ? 'null' : str);
          }
          partial = '[' + partial.join(',') + ']';
        } else {
          var keys = Object.keys(value);
          for (var i = 0, length = keys.length; i < length; i++) {
            var key = keys[i], str = Str(key, value, stack);
            if (typeof str !== "undefined") {
               partial.push(key.inspect(true)+ ':' + str);
             }
          }
          partial = '{' + partial.join(',') + '}';
        }
        stack.pop();
        return partial;
    }
  }

  function stringify(object) {
    return JSON.stringify(object);
  }

  function toQueryString(object) {
    return $H(object).toQueryString();
  }

  function toHTML(object) {
    return object && object.toHTML ? object.toHTML() : String.interpret(object);
  }

  function keys(object) {
    if (Type(object) !== OBJECT_TYPE) { throw new TypeError(); }
    var results = [];
    for (var property in object) {
      if (object.hasOwnProperty(property)) {
        results.push(property);
      }
    }
    return results;
  }

  function values(object) {
    var results = [];
    for (var property in object)
      results.push(object[property]);
    return results;
  }

  function clone(object) {
    return extend({ }, object);
  }

  function isElement(object) {
    return !!(object && object.nodeType == 1);
  }

  function isArray(object) {
    return _toString.call(object) === ARRAY_CLASS;
  }

  var hasNativeIsArray = (typeof Array.isArray == 'function')
    && Array.isArray([]) && !Array.isArray({});

  if (hasNativeIsArray) {
    isArray = Array.isArray;
  }

  function isHash(object) {
    return object instanceof Hash;
  }

  function isFunction(object) {
    return _toString.call(object) === FUNCTION_CLASS;
  }

  function isString(object) {
    return _toString.call(object) === STRING_CLASS;
  }

  function isNumber(object) {
    return _toString.call(object) === NUMBER_CLASS;
  }

  function isDate(object) {
    return _toString.call(object) === DATE_CLASS;
  }

  function isUndefined(object) {
    return typeof object === "undefined";
  }

  extend(Object, {
    extend:        extend,
    inspect:       inspect,
    toJSON:        NATIVE_JSON_STRINGIFY_SUPPORT ? stringify : toJSON,
    toQueryString: toQueryString,
    toHTML:        toHTML,
    keys:          Object.keys || keys,
    values:        values,
    clone:         clone,
    isElement:     isElement,
    isArray:       isArray,
    isHash:        isHash,
    isFunction:    isFunction,
    isString:      isString,
    isNumber:      isNumber,
    isDate:        isDate,
    isUndefined:   isUndefined
  });
})();
Object.extend(Function.prototype, (function() {
  var slice = Array.prototype.slice;

  function update(array, args) {
    var arrayLength = array.length, length = args.length;
    while (length--) array[arrayLength + length] = args[length];
    return array;
  }

  function merge(array, args) {
    array = slice.call(array, 0);
    return update(array, args);
  }

  function argumentNames() {
    var names = this.toString().match(/^[\s\(]*function[^(]*\(([^)]*)\)/)[1]
      .replace(/\/\/.*?[\r\n]|\/\*(?:.|[\r\n])*?\*\//g, '')
      .replace(/\s+/g, '').split(',');
    return names.length == 1 && !names[0] ? [] : names;
  }

  function bind(context) {
    if (arguments.length < 2 && Object.isUndefined(arguments[0])) return this;
    var __method = this, args = slice.call(arguments, 1);
    return function() {
      var a = merge(args, arguments);
      return __method.apply(context, a);
    }
  }

  function bindAsEventListener(context) {
    var __method = this, args = slice.call(arguments, 1);
    return function(event) {
      var a = update([event || window.event], args);
      return __method.apply(context, a);
    }
  }

  function curry() {
    if (!arguments.length) return this;
    var __method = this, args = slice.call(arguments, 0);
    return function() {
      var a = merge(args, arguments);
      return __method.apply(this, a);
    }
  }

  function delay(timeout) {
    var __method = this, args = slice.call(arguments, 1);
    timeout = timeout * 1000;
    return window.setTimeout(function() {
      return __method.apply(__method, args);
    }, timeout);
  }

  function defer() {
    var args = update([0.01], arguments);
    return this.delay.apply(this, args);
  }

  function wrap(wrapper) {
    var __method = this;
    return function() {
      var a = update([__method.bind(this)], arguments);
      return wrapper.apply(this, a);
    }
  }

  function methodize() {
    if (this._methodized) return this._methodized;
    var __method = this;
    return this._methodized = function() {
      var a = update([this], arguments);
      return __method.apply(null, a);
    };
  }

  return {
    argumentNames:       argumentNames,
    bind:                bind,
    bindAsEventListener: bindAsEventListener,
    curry:               curry,
    delay:               delay,
    p_defer:             defer,
    wrap:                wrap,
    methodize:           methodize
  }
})());



(function(proto) {


  function toISOString() {
    return this.getUTCFullYear() + '-' +
      (this.getUTCMonth() + 1).toPaddedString(2) + '-' +
      this.getUTCDate().toPaddedString(2) + 'T' +
      this.getUTCHours().toPaddedString(2) + ':' +
      this.getUTCMinutes().toPaddedString(2) + ':' +
      this.getUTCSeconds().toPaddedString(2) + 'Z';
  }


  function toJSON() {
    return this.toISOString();
  }

  if (!proto.toISOString) proto.toISOString = toISOString;
  if (!proto.toJSON) proto.toJSON = toJSON;

})(Date.prototype);


RegExp.prototype.match = RegExp.prototype.test;

RegExp.escape = function(str) {
  return String(str).replace(/([.*+?^=!:${}()|[\]\/\\])/g, '\\$1');
};
var PeriodicalExecuter = Class.create({
  initialize: function(callback, frequency) {
    this.callback = callback;
    this.frequency = frequency;
    this.currentlyExecuting = false;

    this.registerCallback();
  },

  registerCallback: function() {
    this.timer = setInterval(this.onTimerEvent.bind(this), this.frequency * 1000);
  },

  execute: function() {
    this.callback(this);
  },

  stop: function() {
    if (!this.timer) return;
    clearInterval(this.timer);
    this.timer = null;
  },

  onTimerEvent: function() {
    if (!this.currentlyExecuting) {
      try {
        this.currentlyExecuting = true;
        this.execute();
        this.currentlyExecuting = false;
      } catch(e) {
        this.currentlyExecuting = false;
        throw e;
      }
    }
  }
});
Object.extend(String, {
  interpret: function(value) {
    return value == null ? '' : String(value);
  },
  specialChar: {
    '\b': '\\b',
    '\t': '\\t',
    '\n': '\\n',
    '\f': '\\f',
    '\r': '\\r',
    '\\': '\\\\'
  }
});

Object.extend(String.prototype, (function() {
  var NATIVE_JSON_PARSE_SUPPORT = window.JSON &&
    typeof JSON.parse === 'function' &&
    JSON.parse('{"test": true}').test;

  function prepareReplacement(replacement) {
    if (Object.isFunction(replacement)) return replacement;
    var template = new Template(replacement);
    return function(match) { return template.evaluate(match) };
  }

  function gsub(pattern, replacement) {
    var result = '', source = this, match;
    replacement = prepareReplacement(replacement);

    if (Object.isString(pattern))
      pattern = RegExp.escape(pattern);

    if (!(pattern.length || pattern.source)) {
      replacement = replacement('');
      return replacement + source.split('').join(replacement) + replacement;
    }

    while (source.length > 0) {
      if (match = source.match(pattern)) {
        result += source.slice(0, match.index);
        result += String.interpret(replacement(match));
        source  = source.slice(match.index + match[0].length);
      } else {
        result += source, source = '';
      }
    }
    return result;
  }

  function sub(pattern, replacement, count) {
    replacement = prepareReplacement(replacement);
    count = Object.isUndefined(count) ? 1 : count;

    return this.gsub(pattern, function(match) {
      if (--count < 0) return match[0];
      return replacement(match);
    });
  }

  function scan(pattern, iterator) {
    this.gsub(pattern, iterator);
    return String(this);
  }

  function truncate(length, truncation) {
    length = length || 30;
    truncation = Object.isUndefined(truncation) ? '...' : truncation;
    return this.length > length ?
      this.slice(0, length - truncation.length) + truncation : String(this);
  }

  function strip() {
    return this.replace(/^\s+/, '').replace(/\s+$/, '');
  }

  function stripTags(separator) {
    return this.replace(/<\w+(\s+("[^"]*"|'[^']*'|[^>])+)?>|<\/\w+>/gi, separator || '');
  }

  function stripScripts() {
    return this.replace(new RegExp(Prototype.ScriptFragment , 'img'), '');
  }

  function stripEvents() {
    return this.replace(new RegExp(Prototype.jsInlineEvents.join('|') , 'img'), '');
  }

  function extractScripts() {
    var matchAll = new RegExp(Prototype.ScriptFragment, 'img'),
        matchOne = new RegExp(Prototype.ScriptFragment, 'im');
    return (this.match(matchAll) || []).map(function(scriptTag) {
      return (scriptTag.match(matchOne) || ['', ''])[1];
    });
  }

  function evalScripts() {
    return this.extractScripts().map(function(script) { return eval(script) });
  }

  function escapeHTML() {
    return this.replace(/&/g,'&amp;').replace(/&amp;amp;/g,'&amp;').replace(/</g,'&lt;').replace(/>/g,'&gt;');
  }

  function unescapeHTML() {
    return this.stripTags().replace(/&lt;/g,'<').replace(/&gt;/g,'>').replace(/&amp;/g,'&');
  }


  function toQueryParams(separator) {
    var match = this.strip().match(/([^?#]*)(#.*)?$/);
    if (!match) return { };

    return match[1].split(separator || '&').inject({ }, function(hash, pair) {
      if ((pair = pair.split('='))[0]) {
        var key = decodeURIComponent(pair.shift()),
            value = pair.length > 1 ? pair.join('=') : pair[0];

        if (value != undefined) try { value = decodeURIComponent(value) } catch(e) { value = unescape(value) } // temporary fix (80746)
        
        if (key in hash) {
          if (!Object.isArray(hash[key])) hash[key] = [hash[key]];
          hash[key].push(value);
        }
        else hash[key] = value;
      }
      return hash;
    });
  }

  function toArray() {
    return this.split('');
  }

  function succ() {
    return this.slice(0, this.length - 1) +
      String.fromCharCode(this.charCodeAt(this.length - 1) + 1);
  }

  function times(count) {
    return count < 1 ? '' : new Array(count + 1).join(this);
  }

  function camelize() {
    return this.replace(/-+(.)?/g, function(match, chr) {
      return chr ? chr.toUpperCase() : '';
    });
  }

  function capitalize() {
    return this.charAt(0).toUpperCase() + this.substring(1).toLowerCase();
  }

  function underscore() {
    return this.replace(/::/g, '/')
               .replace(/([A-Z]+)([A-Z][a-z])/g, '$1_$2')
               .replace(/([a-z\d])([A-Z])/g, '$1_$2')
               .replace(/-/g, '_')
               .toLowerCase();
  }

  function dasherize() {
    return this.replace(/_/g, '-');
  }

  function inspect(useDoubleQuotes) {
    var escapedString = this.replace(/[\x00-\x1f\\]/g, function(character) {
      if (character in String.specialChar) {
        return String.specialChar[character];
      }
      return '\\u00' + character.charCodeAt().toPaddedString(2, 16);
    });
    if (useDoubleQuotes) return '"' + escapedString.replace(/"/g, '\\"') + '"';
    return "'" + escapedString.replace(/'/g, '\\\'') + "'";
  }

  function unfilterJSON(filter) {
    return this.replace(filter || Prototype.JSONFilter, '$1');
  }

  function isJSON() {
    var str = this;
    if (str.blank()) return false;
    str = str.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@');
    str = str.replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']');
    str = str.replace(/(?:^|:|,)(?:\s*\[)+/g, '');
    return (/^[\],:{}\s]*$/).test(str);
  }

  function evalJSON(sanitize) {
    var json = this.unfilterJSON(),
        cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g;
    if (cx.test(json)) {
      json = json.replace(cx, function (a) {
        return '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
      });
    }
    try {
      if (!sanitize || json.isJSON()) return eval('(' + json + ')');
    } catch (e) { }
    throw new SyntaxError('Badly formed JSON string: ' + this.inspect());
  }

  function parseJSON() {
    var json = this.unfilterJSON();
    return JSON.parse(json);
  }

  function include(pattern) {
    return this.indexOf(pattern) > -1;
  }

  function startsWith(pattern) {
    return this.lastIndexOf(pattern, 0) === 0;
  }

  function endsWith(pattern) {
    var d = this.length - pattern.length;
    return d >= 0 && this.indexOf(pattern, d) === d;
  }

  function empty() {
    return this == '';
  }

  function blank() {
    return /^\s*$/.test(this);
  }

  function interpolate(object, pattern) {
    return new Template(this, pattern).evaluate(object);
  }

  return {
    gsub:           gsub,
    sub:            sub,
    scan:           scan,
    truncate:       truncate,
    strip:          String.prototype.trim || strip,
    stripTags:      stripTags,
    stripScripts:   stripScripts,
    stripEvents:    stripEvents, 
    extractScripts: extractScripts,
    evalScripts:    evalScripts,
    escapeHTML:     escapeHTML,
    unescapeHTML:   unescapeHTML,
    toQueryParams:  toQueryParams,
    parseQuery:     toQueryParams,
    toArray:        toArray,
    succ:           succ,
    times:          times,
    camelize:       camelize,
    capitalize:     capitalize,
    underscore:     underscore,
    dasherize:      dasherize,
    inspect:        inspect,
    unfilterJSON:   unfilterJSON,
    isJSON:         isJSON,
    evalJSON:       NATIVE_JSON_PARSE_SUPPORT ? parseJSON : evalJSON,
    include:        include,
    startsWith:     startsWith,
    endsWith:       endsWith,
    empty:          empty,
    blank:          blank,
    interpolate:    interpolate
  };
})());

var Template = Class.create({
  initialize: function(template, pattern) {
    this.template = template.toString();
    this.pattern = pattern || Template.Pattern;
  },

  evaluate: function(object) {
    if (object && Object.isFunction(object.toTemplateReplacements))
      object = object.toTemplateReplacements();

    return this.template.gsub(this.pattern, function(match) {
      if (object == null) return (match[1] + '');

      var before = match[1] || '';
      if (before == '\\') return match[2];

      var ctx = object, expr = match[3],
          pattern = /^([^.[]+|\[((?:.*?[^\\])?)\])(\.|\[|$)/;

      match = pattern.exec(expr);
      if (match == null) return before;

      while (match != null) {
        var comp = match[1].startsWith('[') ? match[2].replace(/\\\\]/g, ']') : match[1];
        ctx = ctx[comp];
        if (null == ctx || '' == match[3]) break;
        expr = expr.substring('[' == match[3] ? match[1].length : match[0].length);
        match = pattern.exec(expr);
      }

      return before + String.interpret(ctx);
    });
  }
});
Template.Pattern = /(^|.|\r|\n)(#\{(.*?)\})/;

var $break = { };

var Enumerable = (function() {
  function each(iterator, context) {
    var index = 0;
    try {
      this._each(function(value) {
        iterator.call(context, value, index++);
      });
    } catch (e) {
      if (e != $break) throw e;
    }
    return this;
  }

  function eachSlice(number, iterator, context) {
    var index = -number, slices = [], array = this.toArray();
    if (number < 1) return array;
    while ((index += number) < array.length)
      slices.push(array.slice(index, index+number));
    return slices.collect(iterator, context);
  }

  function all(iterator, context) {
    iterator = iterator || Prototype.K;
    var result = true;
    this.each(function(value, index) {
      result = result && !!iterator.call(context, value, index);
      if (!result) throw $break;
    });
    return result;
  }

  function any(iterator, context) {
    iterator = iterator || Prototype.K;
    var result = false;
    this.each(function(value, index) {
      if (result = !!iterator.call(context, value, index))
        throw $break;
    });
    return result;
  }

  function collect(iterator, context) {
    iterator = iterator || Prototype.K;
    var results = [];
    this.each(function(value, index) {
      results.push(iterator.call(context, value, index));
    });
    return results;
  }

  function detect(iterator, context) {
    var result;
    this.each(function(value, index) {
      if (iterator.call(context, value, index)) {
        result = value;
        throw $break;
      }
    });
    return result;
  }

  function findAll(iterator, context) {
    var results = [];
    this.each(function(value, index) {
      if (iterator.call(context, value, index))
        results.push(value);
    });
    return results;
  }

  function grep(filter, iterator, context) {
    iterator = iterator || Prototype.K;
    var results = [];

    if (Object.isString(filter))
      filter = new RegExp(RegExp.escape(filter));

    this.each(function(value, index) {
      if (filter.match(value))
        results.push(iterator.call(context, value, index));
    });
    return results;
  }

  function include(object) {
    if (Object.isFunction(this.indexOf))
      if (this.indexOf(object) != -1) return true;

    var found = false;
    this.each(function(value) {
      if (value == object) {
        found = true;
        throw $break;
      }
    });
    return found;
  }

  function inGroupsOf(number, fillWith) {
    fillWith = Object.isUndefined(fillWith) ? null : fillWith;
    return this.eachSlice(number, function(slice) {
      while(slice.length < number) slice.push(fillWith);
      return slice;
    });
  }

  function inject(memo, iterator, context) {
    this.each(function(value, index) {
      memo = iterator.call(context, memo, value, index);
    });
    return memo;
  }

  function invoke(method) {
    var args = $A(arguments).slice(1);
    return this.map(function(value) {
      return value[method].apply(value, args);
    });
  }

  function max(iterator, context) {
    iterator = iterator || Prototype.K;
    var result;
    this.each(function(value, index) {
      value = iterator.call(context, value, index);
      if (result == null || value >= result)
        result = value;
    });
    return result;
  }

  function min(iterator, context) {
    iterator = iterator || Prototype.K;
    var result;
    this.each(function(value, index) {
      value = iterator.call(context, value, index);
      if (result == null || value < result)
        result = value;
    });
    return result;
  }

  function partition(iterator, context) {
    iterator = iterator || Prototype.K;
    var trues = [], falses = [];
    this.each(function(value, index) {
      (iterator.call(context, value, index) ?
        trues : falses).push(value);
    });
    return [trues, falses];
  }

  function pluck(property) {
    var results = [];
    this.each(function(value) {
      results.push(value[property]);
    });
    return results;
  }

  function reject(iterator, context) {
    var results = [];
    this.each(function(value, index) {
      if (!iterator.call(context, value, index))
        results.push(value);
    });
    return results;
  }

  function sortBy(iterator, context) {
    return this.map(function(value, index) {
      return {
        value: value,
        criteria: iterator.call(context, value, index)
      };
    }).sort(function(left, right) {
      var a = left.criteria, b = right.criteria;
      return a < b ? -1 : a > b ? 1 : 0;
    }).pluck('value');
  }

  function toArray() {
    return this.map();
  }

  function zip() {
    var iterator = Prototype.K, args = $A(arguments);
    if (Object.isFunction(args.last()))
      iterator = args.pop();

    var collections = [this].concat(args).map($A);
    return this.map(function(value, index) {
      return iterator(collections.pluck(index));
    });
  }

  function size() {
    return this.toArray().length;
  }

  function inspect() {
    return '#<Enumerable:' + this.toArray().inspect() + '>';
  }









  return {
    each:       each,
    eachSlice:  eachSlice,
    all:        all,
    every:      all,
    any:        any,
    some:       any,
    collect:    collect,
    map:        collect,
    detect:     detect,
    findAll:    findAll,
    select:     findAll,
    filter:     findAll,
    grep:       grep,
    include:    include,
    member:     include,
    inGroupsOf: inGroupsOf,
    inject:     inject,
    invoke:     invoke,
    max:        max,
    min:        min,
    partition:  partition,
    pluck:      pluck,
    reject:     reject,
    sortBy:     sortBy,
    toArray:    toArray,
   // entries:    toArray,
    zip:        zip,
    size:       size,
    inspect:    inspect,
    find:       detect
  };
})();

function $A(iterable) {
  if (typeof window.Set !== 'undefined' && iterable instanceof window.Set){
    var arr = [];
    iterable.forEach(function (x) {
      arr.push(x);
    });
    return arr;
  }
  if (!iterable) return [];
  if ('toArray' in Object(iterable)) return iterable.toArray();
  var length = iterable.length || 0, results = new Array(length);
  while (length--) results[length] = iterable[length];
  return results;
}


function $w(string) {
  if (!Object.isString(string)) return [];
  string = string.strip();
  return string ? string.split(/\s+/) : [];
}

if (!Array.from) {
  Array.from = $A;
}


(function() {
  var arrayProto = Array.prototype,
      slice = arrayProto.slice,
      _each = arrayProto.forEach; // use native browser JS 1.6 implementation if available

  function each(iterator, context) {
    for (var i = 0, length = this.length >>> 0; i < length; i++) {
      if (i in this) iterator.call(context, this[i], i, this);
    }
  }
  if (!_each) _each = each;

  function clear() {
    this.length = 0;
    return this;
  }

  function first() {
    return this[0];
  }

  function last() {
    return this[this.length - 1];
  }

  function compact() {
    return this.select(function(value) {
      return value != null;
    });
  }

  function flatten() {
    return this.inject([], function(array, value) {
      if (Object.isArray(value))
        return array.concat(value.flatten());
      array.push(value);
      return array;
    });
  }

  function without() {
    var values = slice.call(arguments, 0);
    return this.select(function(value) {
      return !values.include(value);
    });
  }

  function reverse(inline) {
    return (inline === false ? this.toArray() : this)._reverse();
  }

  function uniq(sorted) {
    return this.inject([], function(array, value, index) {
      if (0 == index || (sorted ? array.last() != value : !array.include(value)))
        array.push(value);
      return array;
    });
  }

  function intersect(array) {
    return this.uniq().findAll(function(item) {
      return array.indexOf(item) !== -1;
    });
  }


  function clone() {
    return slice.call(this, 0);
  }

  function size() {
    return this.length;
  }

  function inspect() {
    return '[' + this.map(Object.inspect).join(', ') + ']';
  }

  function indexOf(item, i) {
    if (this == null) throw new TypeError();

    var array = Object(this), length = array.length >>> 0;
    if (length === 0) return -1;

    // The rules for the `fromIndex` argument are tricky. Let's follow the
    // spec line-by-line.
    i = Number(i);
    if (isNaN(i)) {
      i = 0;
    } else if (i !== 0 && isFinite(i)) {
      // Equivalent to ES5's `ToInteger` operation.
      i = (i > 0 ? 1 : -1) * Math.floor(Math.abs(i));
    }

    // If the search index is greater than the length of the array,
    // return -1.
    if (i > length) return -1;

    // If the search index is negative, take its absolute value, subtract it
    // from the length, and make that the new search index. If it's still
    // negative, make it 0.
    var k = i >= 0 ? i : Math.max(length - Math.abs(i), 0);
    for (; k < length; k++)
      if (k in array && array[k] === item) return k;
    return -1;
  }

  function lastIndexOf(item, i) {
    if (this == null) throw new TypeError();

    var array = Object(this), length = array.length >>> 0;
    if (length === 0) return -1;

    // The rules for the `fromIndex` argument are tricky. Let's follow the
    // spec line-by-line.
    if (!Object.isUndefined(i)) {
      i = Number(i);
      if (isNaN(i)) {
        i = 0;
      } else if (i !== 0 && isFinite(i)) {
        // Equivalent to ES5's `ToInteger` operation.
        i = (i > 0 ? 1 : -1) * Math.floor(Math.abs(i));
      }
    } else {
      i = length;
    }

    // If fromIndex is positive, clamp it to the last index in the array;
    // if it's negative, subtract its absolute value from the array's length.
    var k = i >= 0 ? Math.min(i, length - 1) :
     length - Math.abs(i);

    // (If fromIndex is still negative, it'll bypass this loop altogether and
    // return -1.)
    for (; k >= 0; k--)
      if (k in array && array[k] === item) return k;
    return -1;
  }

  // Replaces a built-in function. No PDoc needed.
  //
  // Used instead of the broken version of Array#concat in some versions of
  // Opera. Made to be ES5-compliant.
  function concat(_) {
    var array = [], items = slice.call(arguments, 0), item, n = 0;
    items.unshift(this);
    for (var i = 0, length = items.length; i < length; i++) {
      item = items[i];
      if (Object.isArray(item) && !('callee' in item)) {
        for (var j = 0, arrayLength = item.length; j < arrayLength; j++) {
          if (j in item) array[n] = item[j];
          n++;
        }
      } else {
        array[n++] = item;
      }
    }
    array.length = n;
    return array;
  }

  function wrapNative(method) {
    return function() {
      if (arguments.length === 0) {
        // No iterator was given. Instead of throwing a `TypeError`, use
        // `Prototype.K` as the default iterator.
        return method.call(this, Prototype.K);
      } else if (arguments[0] === undefined) {
        // Same as above.
        var args = slice.call(arguments, 1);
        args.unshift(Prototype.K);
        return method.apply(this, args);
      } else {
        // Pass straight through to the native method.
        return method.apply(this, arguments);
      }
    };
  }

  function map(iterator) {
    if (this == null) throw new TypeError();
    iterator = iterator || Prototype.K;

    var object = Object(this);
    var results = [], context = arguments[1], n = 0;

    for (var i = 0, length = object.length >>> 0; i < length; i++) {
      if (i in object) {
        results[n] = iterator.call(context, object[i], i, object);
      }
      n++;
    }
    results.length = n;
    return results;
  }

  if (arrayProto.map) {
    map = wrapNative(Array.prototype.map);
  }

  function filter(iterator) {
    if (this == null || !Object.isFunction(iterator))
      throw new TypeError();

    var object = Object(this);
    var results = [], context = arguments[1], value;

    for (var i = 0, length = object.length >>> 0; i < length; i++) {
      if (i in object) {
        value = object[i];
        if (iterator.call(context, value, i, object)) {
          results.push(value);
        }
      }
    }
    return results;
  }

  if (arrayProto.filter) {
    // `Array#filter` requires an iterator by nature, so we don't need to
    // wrap it.
    filter = Array.prototype.filter;
  }

  function some(iterator) {
    if (this == null) throw new TypeError();
    iterator = iterator || Prototype.K;
    var context = arguments[1];

    var object = Object(this);
    for (var i = 0, length = object.length >>> 0; i < length; i++) {
      if (i in object && iterator.call(context, object[i], i, object)) {
        return true;
      }
    }

    return false;
  }

  if (arrayProto.some) {
    some = wrapNative(Array.prototype.some);
  }

  function every(iterator) {
    if (this == null) throw new TypeError();
    iterator = iterator || Prototype.K;
    var context = arguments[1];

    var object = Object(this);
    for (var i = 0, length = object.length >>> 0; i < length; i++) {
      if (i in object && !iterator.call(context, object[i], i, object)) {
        return false;
      }
    }

    return true;
  }

  if (arrayProto.every) {
    /*
      Native `Array.prototype.every` impl. requires a parameter, otherwise throws error.
      However in Prototype version there's a convenience to presume iterator fn as an "identity function" if not provided.
      Since that usage may have been spreaded over the codebase, we need to provide such convenience in native usage too.
    */
    var unsafeEvery = wrapNative(Array.prototype.every);
    var safeEvery = function () {
      // Safe call
      if (arguments.length === 0) return unsafeEvery(Prototype.K);

      // Regular call
      return unsafeEvery.apply(this, arguments);
    }
    every = safeEvery;
  }

  // We used to define an `inject` method here that relied on ES5's
  // `Array#reduce` (if present), but using `reduce` prevents us from
  // catching a thrown `$break`. So arrays now use the standard
  // `Enumerable.inject` like they did previously.

  Object.extend(arrayProto, Enumerable);

  // Enumerable's `entries` method is no longer safe to mixin to arrays, as
  // it conflicts with an ES6 method. But it can still be mixed into other
  // things.
  // if (arrayProto.entries === Enumerable.entries) {
    // delete arrayProto.entries;
  // }

  if (!arrayProto._reverse)
    arrayProto._reverse = arrayProto.reverse;

  Object.extend(arrayProto, {
    _each:     _each,

    map:       map,
    collect:   map,
    select:    filter,
    filter:    filter,
    findAll:   filter,
    some:      some,
    any:       some,
    every:     every,
    all:       every,

    clear:     clear,
    first:     first,
    last:      last,
    compact:   compact,
    flatten:   flatten,
    without:   without,
    reverse:   reverse,
    uniq:      uniq,
    intersect: intersect,
    clone:     clone,
    toArray:   clone,
    size:      size,
    inspect:   inspect
  });

  var CONCAT_ARGUMENTS_BUGGY = (function() {
    return [].concat(arguments)[0][0] !== 1;
  })(1,2);

  if (CONCAT_ARGUMENTS_BUGGY) arrayProto.concat = concat;

  if (!arrayProto.indexOf) arrayProto.indexOf = indexOf;
  if (!arrayProto.lastIndexOf) arrayProto.lastIndexOf = lastIndexOf;
})();
function $H(object) {
  return new Hash(object);
};

var Hash = Class.create(Enumerable, (function() {
  function initialize(object) {
    this._object = Object.isHash(object) ? object.toObject() : Object.clone(object);
  }


  function _each(iterator) {
    for (var key in this._object) {
      var value = this._object[key], pair = [key, value];
      pair.key = key;
      pair.value = value;
      iterator(pair);
    }
  }

  function set(key, value) {
    return this._object[key] = value;
  }

  function get(key) {
    if (this._object[key] !== Object.prototype[key])
      return this._object[key];
  }

  function unset(key) {
    var value = this._object[key];
    delete this._object[key];
    return value;
  }

  function toObject() {
    return Object.clone(this._object);
  }



  function keys() {
    return this.pluck('key');
  }

  function values() {
    return this.pluck('value');
  }

  function index(value) {
    var match = this.detect(function(pair) {
      return pair.value === value;
    });
    return match && match.key;
  }

  function merge(object) {
    return this.clone().update(object);
  }

  function update(object) {
    return new Hash(object).inject(this, function(result, pair) {
      result.set(pair.key, pair.value);
      return result;
    });
  }

  function toQueryPair(key, value) {
    if (Object.isUndefined(value)) return key;
    return key + '=' + encodeURIComponent(String.interpret(value));
  }

  function toQueryString() {
    return this.inject([], function(results, pair) {
      var key = encodeURIComponent(pair.key), values = pair.value;

      if (values && typeof values == 'object') {
        if (Object.isArray(values)) {
          var queryValues = [];
          for (var i = 0, len = values.length, value; i < len; i++) {
            value = values[i];
            queryValues.push(toQueryPair(key, value));
          }
          return results.concat(queryValues);
        }
      } else results.push(toQueryPair(key, values));
      return results;
    }).join('&');
  }

  function inspect() {
    return '#<Hash:{' + this.map(function(pair) {
      return pair.map(Object.inspect).join(': ');
    }).join(', ') + '}>';
  }

  function clone() {
    return new Hash(this);
  }

  return {
    initialize:             initialize,
    _each:                  _each,
    set:                    set,
    get:                    get,
    unset:                  unset,
    toObject:               toObject,
    toTemplateReplacements: toObject,
    keys:                   keys,
    values:                 values,
    index:                  index,
    merge:                  merge,
    update:                 update,
    toQueryString:          toQueryString,
    inspect:                inspect,
    toJSON:                 toObject,
    clone:                  clone
  };
})());

Hash.from = $H;
Object.extend(Number.prototype, (function() {
  function toColorPart() {
    return this.toPaddedString(2, 16);
  }

  function succ() {
    return this + 1;
  }

  function times(iterator, context) {
    $R(0, this, true).each(iterator, context);
    return this;
  }

  function toPaddedString(length, radix) {
    var string = this.toString(radix || 10);
    return '0'.times(length - string.length) + string;
  }

  function abs() {
    return Math.abs(this);
  }

  function round() {
    return Math.round(this);
  }

  function ceil() {
    return Math.ceil(this);
  }

  function floor() {
    return Math.floor(this);
  }

  return {
    toColorPart:    toColorPart,
    succ:           succ,
    times:          times,
    toPaddedString: toPaddedString,
    abs:            abs,
    round:          round,
    ceil:           ceil,
    floor:          floor
  };
})());

function $R(start, end, exclusive) {
  return new ObjectRange(start, end, exclusive);
}

var ObjectRange = Class.create(Enumerable, (function() {
  function initialize(start, end, exclusive) {
    this.start = start;
    this.end = end;
    this.exclusive = exclusive;
  }

  function _each(iterator) {
    var value = this.start;
    while (this.include(value)) {
      iterator(value);
      value = value.succ();
    }
  }

  function include(value) {
    if (value < this.start)
      return false;
    if (this.exclusive)
      return value < this.end;
    return value <= this.end;
  }

  return {
    initialize: initialize,
    _each:      _each,
    include:    include
  };
})());



var Ajax = {
  getTransport: function() {
    return Try.these(
      function() {return new XMLHttpRequest()},
      function() {return new ActiveXObject('Msxml2.XMLHTTP')},
      function() {return new ActiveXObject('Microsoft.XMLHTTP')}
    ) || false;
  },

  activeRequestCount: 0
};

Ajax.Responders = {
  responders: [],

  _each: function(iterator) {
    this.responders._each(iterator);
  },

  register: function(responder) {
    if (!this.include(responder))
      this.responders.push(responder);
  },

  unregister: function(responder) {
    this.responders = this.responders.without(responder);
  },

  dispatch: function(callback, request, transport, json) {
    this.each(function(responder) {
      if (Object.isFunction(responder[callback])) {
        try {
          responder[callback].apply(responder, [request, transport, json]);
        } catch (e) { }
      }
    });
  }
};

Object.extend(Ajax.Responders, Enumerable);

Ajax.Responders.register({
  onCreate:   function() { Ajax.activeRequestCount++ },
  onComplete: function() { Ajax.activeRequestCount-- }
});
Ajax.Base = Class.create({
  initialize: function(options) {
    this.options = {
      method:       'post',
      asynchronous: true,
      contentType:  'application/x-www-form-urlencoded',
      encoding:     'UTF-8',
      parameters:   '',
      evalJSON:     true,
      evalJS:       true
    };
    Object.extend(this.options, options || { });

    this.options.method = this.options.method.toLowerCase();

    if (Object.isHash(this.options.parameters))
      this.options.parameters = this.options.parameters.toObject();
  }
});
Ajax.Request = Class.create(Ajax.Base, {
  _complete: false,

  initialize: function($super, url, options) {
    $super(options);
    this.transport = Ajax.getTransport();
    this.request(url);
  },

  request: function(url) {
    this.url = url;
    this.method = this.options.method;
    var params = Object.isString(this.options.parameters) ?
          this.options.parameters :
          Object.toQueryString(this.options.parameters);

    if (!['get', 'post'].include(this.method)) {
      params += (params ? '&' : '') + "_method=" + this.method;
      this.method = 'post';
    }

    if (params && this.method === 'get') {
      this.url += (this.url.include('?') ? '&' : '?') + params;
    }

    this.parameters = params.toQueryParams();

    try {
      var response = new Ajax.Response(this);
      if (this.options.onCreate) this.options.onCreate(response);
      Ajax.Responders.dispatch('onCreate', this, response);

      this.transport.open(this.method.toUpperCase(), this.url,
        this.options.asynchronous);

      if (this.options.asynchronous) this.respondToReadyState.bind(this).p_defer(1);

      this.transport.onreadystatechange = this.onStateChange.bind(this);
      this.setRequestHeaders();

      this.body = this.method == 'post' ? (this.options.postBody || params) : null;
      this.transport.send(this.body);

      /* Force Firefox to handle ready state 4 for synchronous requests */
      if (!this.options.asynchronous && this.transport.overrideMimeType)
        this.onStateChange();

    }
    catch (e) {
      this.dispatchException(e);
    }
  },

  onStateChange: function() {
    var readyState = this.transport.readyState;
    if (readyState > 1 && !((readyState == 4) && this._complete))
      this.respondToReadyState(this.transport.readyState);
  },

  setRequestHeaders: function() {
    var headers = {
      'X-Requested-With': 'XMLHttpRequest',
      'X-Prototype-Version': Prototype.Version,
      'Accept': 'text/javascript, text/html, application/xml, text/xml, */*'
    };

    if (this.method == 'post') {
      headers['Content-type'] = this.options.contentType +
        (this.options.encoding ? '; charset=' + this.options.encoding : '');

      /* Force "Connection: close" for older Mozilla browsers to work
       * around a bug where XMLHttpRequest sends an incorrect
       * Content-length header. See Mozilla Bugzilla #246651.
       */
      if (this.transport.overrideMimeType &&
          (navigator.userAgent.match(/Gecko\/(\d{4})/) || [0,2005])[1] < 2005)
            headers['Connection'] = 'close';
    }

    if (typeof this.options.requestHeaders == 'object') {
      var extras = this.options.requestHeaders;

      if (Object.isFunction(extras.push))
        for (var i = 0, length = extras.length; i < length; i += 2)
          headers[extras[i]] = extras[i+1];
      else
        $H(extras).each(function(pair) { headers[pair.key] = pair.value });
    }

    for (var name in headers)
      this.transport.setRequestHeader(name, headers[name]);
  },

  success: function() {
    var status = this.getStatus();
    return !status || (status >= 200 && status < 300) || status == 304;
  },

  getStatus: function() {
    try {
      if (this.transport.status === 1223) return 204;
      return this.transport.status || 0;
    } catch (e) { return 0 }
  },

  respondToReadyState: function(readyState) {
    var state = Ajax.Request.Events[readyState], response = new Ajax.Response(this);

    if (state == 'Complete') {
      try {
        this._complete = true;
        (this.options['on' + response.status]
         || this.options['on' + (this.success() ? 'Success' : 'Failure')]
         || Prototype.emptyFunction)(response, response.headerJSON);
      } catch (e) {
        this.dispatchException(e);
      }

      var contentType = response.getHeader('Content-type');
      if (this.options.evalJS == 'force'
          || (this.options.evalJS && this.isSameOrigin() && contentType
          && contentType.match(/^\s*(text|application)\/(x-)?(java|ecma)script(;.*)?\s*$/i)))
        this.evalResponse();
    }

    try {
      (this.options['on' + state] || Prototype.emptyFunction)(response, response.headerJSON);
      Ajax.Responders.dispatch('on' + state, this, response, response.headerJSON);
    } catch (e) {
      this.dispatchException(e);
    }

    if (state == 'Complete') {
      this.transport.onreadystatechange = Prototype.emptyFunction;
    }
  },

  isSameOrigin: function() {
    var m = this.url.match(/^\s*https?:\/\/[^\/]*/);
    return !m || (m[0] == '#{protocol}//#{domain}#{port}'.interpolate({
      protocol: location.protocol,
      domain: document.domain,
      port: location.port ? ':' + location.port : ''
    }));
  },

  getHeader: function(name) {
    try {
      return this.transport.getResponseHeader(name) || null;
    } catch (e) { return null; }
  },

  evalResponse: function() {
    try {
      return eval((this.transport.responseText || '').unfilterJSON());
    } catch (e) {
      this.dispatchException(e);
    }
  },

  dispatchException: function(exception) {
    (this.options.onException || Prototype.emptyFunction)(this, exception);
    Ajax.Responders.dispatch('onException', this, exception);
  }
});

Ajax.Request.Events =
  ['Uninitialized', 'Loading', 'Loaded', 'Interactive', 'Complete'];








Ajax.Response = Class.create({
  initialize: function(request){
    this.request = request;
    var transport  = this.transport  = request.transport,
        readyState = this.readyState = transport.readyState;

    if ((readyState > 2 && !Prototype.Browser.IE) || readyState == 4) {
      this.status       = this.getStatus();
      this.statusText   = this.getStatusText();
      this.responseText = String.interpret(transport.responseText);
      this.headerJSON   = this._getHeaderJSON();
    }

    if (readyState == 4) {
      var xml = transport.responseXML;
      this.responseXML  = Object.isUndefined(xml) ? null : xml;
      this.responseJSON = this._getResponseJSON();
    }
  },

  status:      0,

  statusText: '',

  getStatus: Ajax.Request.prototype.getStatus,

  getStatusText: function() {
    try {
      return this.transport.statusText || '';
    } catch (e) { return '' }
  },

  getHeader: Ajax.Request.prototype.getHeader,

  getAllHeaders: function() {
    try {
      return this.getAllResponseHeaders();
    } catch (e) { return null }
  },

  getResponseHeader: function(name) {
    return this.transport.getResponseHeader(name);
  },

  getAllResponseHeaders: function() {
    return this.transport.getAllResponseHeaders();
  },

  _getHeaderJSON: function() {
    var json = this.getHeader('X-JSON');
    if (!json) return null;
    json = decodeURIComponent(escape(json));
    try {
      return json.evalJSON(this.request.options.sanitizeJSON ||
        !this.request.isSameOrigin());
    } catch (e) {
      this.request.dispatchException(e);
    }
  },

  _getResponseJSON: function() {
    var options = this.request.options;
    if (!options.evalJSON || (options.evalJSON != 'force' &&
      !(this.getHeader('Content-type') || '').include('application/json')) ||
        this.responseText.blank())
          return null;
    try {
      return this.responseText.evalJSON(options.sanitizeJSON ||
        !this.request.isSameOrigin());
    } catch (e) {
      this.request.dispatchException(e);
    }
  }
});

Ajax.Updater = Class.create(Ajax.Request, {
  initialize: function($super, container, url, options) {
    this.container = {
      success: (container.success || container),
      failure: (container.failure || (container.success ? null : container))
    };

    options = Object.clone(options);
    var onComplete = options.onComplete;
    options.onComplete = (function(response, json) {
      this.updateContent(response.responseText);
      if (Object.isFunction(onComplete)) onComplete(response, json);
    }).bind(this);

    $super(url, options);
  },

  updateContent: function(responseText) {
    var receiver = this.container[this.success() ? 'success' : 'failure'],
        options = this.options;

    if (!options.evalScripts) responseText = responseText.stripScripts();

    if (receiver = $(receiver)) {
      if (options.insertion) {
        if (Object.isString(options.insertion)) {
          var insertion = { }; insertion[options.insertion] = responseText;
          receiver.insert(insertion);
        }
        else options.insertion(receiver, responseText);
      }
      else receiver.update(responseText);
    }
  }
});

Ajax.PeriodicalUpdater = Class.create(Ajax.Base, {
  initialize: function($super, container, url, options) {
    $super(options);
    this.onComplete = this.options.onComplete;

    this.frequency = (this.options.frequency || 2);
    this.decay = (this.options.decay || 1);

    this.updater = { };
    this.container = container;
    this.url = url;

    this.start();
  },

  start: function() {
    this.options.onComplete = this.updateComplete.bind(this);
    this.onTimerEvent();
  },

  stop: function() {
    this.updater.options.onComplete = undefined;
    clearTimeout(this.timer);
    (this.onComplete || Prototype.emptyFunction).apply(this, arguments);
  },

  updateComplete: function(response) {
    if (this.options.decay) {
      this.decay = (response.responseText == this.lastText ?
        this.decay * this.options.decay : 1);

      this.lastText = response.responseText;
    }
    this.timer = this.onTimerEvent.bind(this).delay(this.decay * this.frequency);
  },

  onTimerEvent: function() {
    this.updater = new Ajax.Updater(this.container, this.url, this.options);
  }
});


function $(element) {
  if (arguments.length > 1) {
    for (var i = 0, elements = [], length = arguments.length; i < length; i++)
      elements.push($(arguments[i]));
    return elements;
  }
  if (Object.isString(element))
    element = document.getElementById(element);
  return Element.extend(element);
}

if (Prototype.BrowserFeatures.XPath) {
  document._getElementsByXPath = function(expression, parentElement) {
    var results = [];
    var query = document.evaluate(expression, $(parentElement) || document,
      null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
    for (var i = 0, length = query.snapshotLength; i < length; i++)
      results.push(Element.extend(query.snapshotItem(i)));
    return results;
  };
}

/*--------------------------------------------------------------------------*/

if (!Node) var Node = { };

if (!Node.ELEMENT_NODE) {
  Object.extend(Node, {
    ELEMENT_NODE: 1,
    ATTRIBUTE_NODE: 2,
    TEXT_NODE: 3,
    CDATA_SECTION_NODE: 4,
    ENTITY_REFERENCE_NODE: 5,
    ENTITY_NODE: 6,
    PROCESSING_INSTRUCTION_NODE: 7,
    COMMENT_NODE: 8,
    DOCUMENT_NODE: 9,
    DOCUMENT_TYPE_NODE: 10,
    DOCUMENT_FRAGMENT_NODE: 11,
    NOTATION_NODE: 12
  });
}



(function(global) {
  function shouldUseCache(tagName, attributes) {
    if (tagName === 'select') return false;
    if ('type' in attributes) return false;
    return true;
  }

  var HAS_EXTENDED_CREATE_ELEMENT_SYNTAX = (function(){
    try {
      var el = document.createElement('<input name="x">');
      return el.tagName.toLowerCase() === 'input' && el.name === 'x';
    }
    catch(err) {
      return false;
    }
  })();

  var element = global.Element;

  global.Element = function(tagName, attributes) {
    attributes = attributes || { };
    tagName = tagName.toLowerCase();
    var cache = Element.cache;

    if (HAS_EXTENDED_CREATE_ELEMENT_SYNTAX && attributes.name) {
      tagName = '<' + tagName + ' name="' + attributes.name + '">';
      delete attributes.name;
      return Element.writeAttribute(document.createElement(tagName), attributes);
    }

    if (!cache[tagName]) cache[tagName] = Element.extend(document.createElement(tagName));

    var node = shouldUseCache(tagName, attributes) ?
     cache[tagName].cloneNode(false) : document.createElement(tagName);

    return Element.writeAttribute(node, attributes);
  };

  Object.extend(global.Element, element || { });
  if (element) global.Element.prototype = element.prototype;

})(this);

Element.idCounter = 1;
Element.cache = { };

Element._purgeElement = function(element) {
  var uid = element._prototypeUID;
  if (uid) {
    Element.stopObserving(element);
    element._prototypeUID = void 0;
    delete Element.Storage[uid];
  }
}

Element.Methods = {
  visible: function(element) {
    return $(element).style.display != 'none';
  },

  toggle: function(element) {
    element = $(element);
    Element[Element.visible(element) ? 'hide' : 'show'](element);
    return element;
  },

  hide: function(element) {
    element = $(element);
    element.style.display = 'none';
    return element;
  },

  show: function(element) {
    element = $(element);
    element.style.display = '';
    return element;
  },

  remove: function(element) {
    element = $(element);
    element.parentNode.removeChild(element);
    return element;
  },

  update: (function(){

    var SELECT_ELEMENT_INNERHTML_BUGGY = (function(){
      var el = document.createElement("select"),
          isBuggy = true;
      el.innerHTML = "<option value=\"test\">test</option>";
      if (el.options && el.options[0]) {
        isBuggy = el.options[0].nodeName.toUpperCase() !== "OPTION";
      }
      el = null;
      return isBuggy;
    })();

    var TABLE_ELEMENT_INNERHTML_BUGGY = (function(){
      try {
        var el = document.createElement("table");
        if (el && el.tBodies) {
          el.innerHTML = "<tbody><tr><td>test</td></tr></tbody>";
          var isBuggy = typeof el.tBodies[0] == "undefined";
          el = null;
          return isBuggy;
        }
      } catch (e) {
        return true;
      }
    })();

    var LINK_ELEMENT_INNERHTML_BUGGY = (function() {
      try {
        var el = document.createElement('div');
        el.innerHTML = "<link>";
        var isBuggy = (el.childNodes.length === 0);
        el = null;
        return isBuggy;
      } catch(e) {
        return true;
      }
    })();

    var ANY_INNERHTML_BUGGY = SELECT_ELEMENT_INNERHTML_BUGGY ||
     TABLE_ELEMENT_INNERHTML_BUGGY || LINK_ELEMENT_INNERHTML_BUGGY;

    var SCRIPT_ELEMENT_REJECTS_TEXTNODE_APPENDING = (function () {
      var s = document.createElement("script"),
          isBuggy = false;
      try {
        s.appendChild(document.createTextNode(""));
        isBuggy = !s.firstChild ||
          s.firstChild && s.firstChild.nodeType !== 3;
      } catch (e) {
        isBuggy = true;
      }
      s = null;
      return isBuggy;
    })();

    function htmlEncode(str) {
      return String(str).replace(/[^\w. ]/gi, function (c) {
        return '&#' + c.charCodeAt(0) + ';';
      });
    };

    function update(element, content) {
      element = $(element);
      var purgeElement = Element._purgeElement;

      var descendants = element.getElementsByTagName('*'),
       i = descendants.length;
      while (i--) purgeElement(descendants[i]);

      if (content && content.toElement)
        content = content.toElement();

      if (Object.isElement(content))
        return element.update().insert(content);

      content = Object.toHTML(content);

      var tagName = element.tagName.toUpperCase();

      if (tagName === 'SCRIPT' && SCRIPT_ELEMENT_REJECTS_TEXTNODE_APPENDING) {
        element.text = content;
        return element;
      }

      if (ANY_INNERHTML_BUGGY) {
        if (tagName in Element._insertionTranslations.tags) {
          while (element.firstChild) {
            element.removeChild(element.firstChild);
          }
          Element._getContentFromAnonymousElement(tagName, content.stripScripts())
            .each(function(node) {
              element.appendChild(node)
            });
        } else if (LINK_ELEMENT_INNERHTML_BUGGY && Object.isString(content) && content.indexOf('<link') > -1) {
          while (element.firstChild) {
            element.removeChild(element.firstChild);
          }
          var nodes = Element._getContentFromAnonymousElement(tagName, content.stripScripts(), true);
          nodes.each(function(node) { element.appendChild(node) });
        }
        else {
          element.innerHTML = content.stripScripts();
        }
      } else {
        var isOldReportFormTitle = tagName === 'H2' && document.get && document.get.p === 'reports';
        element.innerHTML = isOldReportFormTitle ? htmlEncode(content.stripScripts()) : content.stripScripts();
      }

      content.innerText;
      return element;
    }

    return update;
  })(),

  replace: function(element, content) {
    element = $(element);
    if (content && content.toElement) content = content.toElement();
    else if (!Object.isElement(content)) {
      content = Object.toHTML(content);
      var range = element.ownerDocument.createRange();
      range.selectNode(element);
      content.evalScripts.bind(content).p_defer();
      content = range.createContextualFragment(content.stripScripts());
    }
    element.parentNode.replaceChild(content, element);
    return element;
  },

  insert: function(element, insertions) {
    element = $(element);

    if (Object.isString(insertions) || Object.isNumber(insertions) ||
        Object.isElement(insertions) || (insertions && (insertions.toElement || insertions.toHTML)))
          insertions = {bottom:insertions};

    var content, insert, tagName, childNodes;

    for (var position in insertions) {
      content  = insertions[position];
      position = position.toLowerCase();
      insert = Element._insertionTranslations[position];

      if (content && content.toElement) content = content.toElement();
      if (Object.isElement(content)) {
        insert(element, content);
        continue;
      }

      content = Object.toHTML(content);

      tagName = ((position == 'before' || position == 'after')
        ? element.parentNode : element).tagName.toUpperCase();

      childNodes = Element._getContentFromAnonymousElement(tagName, content.stripScripts());

      if (position == 'top' || position == 'after') childNodes.reverse();
      childNodes.each(insert.curry(element));

      content.evalScripts.bind(content).p_defer();
    }

    return element;
  },

  wrap: function(element, wrapper, attributes) {
    element = $(element);
    if (Object.isElement(wrapper))
      $(wrapper).writeAttribute(attributes || { });
    else if (Object.isString(wrapper)) wrapper = new Element(wrapper, attributes);
    else wrapper = new Element('div', wrapper);
    if (element.parentNode)
      element.parentNode.replaceChild(wrapper, element);
    wrapper.appendChild(element);
    return wrapper;
  },

  inspect: function(element) {
    element = $(element);
    var result = '<' + element.tagName.toLowerCase();
    $H({'id': 'id', 'className': 'class'}).each(function(pair) {
      var property = pair.first(),
          attribute = pair.last(),
          value = (element[property] || '').toString();
      if (value) result += ' ' + attribute + '=' + value.inspect(true);
    });
    return result + '>';
  },

  recursivelyCollect: function(element, property, maximumLength) {
    element = $(element);
    maximumLength = maximumLength || -1;
    var elements = [];

    while (element = element[property]) {
      if (element.nodeType == 1)
        elements.push(Element.extend(element));
      if (elements.length == maximumLength)
        break;
    }

    return elements;
  },

  ancestors: function(element) {
    return Element.recursivelyCollect(element, 'parentNode');
  },

  descendants: function(element) {
    return Element.select(element, "*");
  },

  firstDescendant: function(element) {
    element = $(element).firstChild;
    while (element && element.nodeType != 1) element = element.nextSibling;
    return $(element);
  },

  immediateDescendants: function(element) {
    var results = [], child = $(element).firstChild;
    while (child) {
      if (child.nodeType === 1) {
        results.push(Element.extend(child));
      }
      child = child.nextSibling;
    }
    return results;
  },

  previousSiblings: function(element, maximumLength) {
    return Element.recursivelyCollect(element, 'previousSibling');
  },

  nextSiblings: function(element) {
    return Element.recursivelyCollect(element, 'nextSibling');
  },

  siblings: function(element) {
    element = $(element);
    return Element.previousSiblings(element).reverse()
      .concat(Element.nextSiblings(element));
  },

  match: function(element, selector) {
    element = $(element);
    if (Object.isString(selector))
      return Prototype.Selector.match(element, selector);
    return selector.match(element);
  },

  up: function(element, expression, index) {
    element = $(element);
    if (arguments.length == 1) return $(element.parentNode);
    var ancestors = Element.ancestors(element);
    return Object.isNumber(expression) ? ancestors[expression] :
      Prototype.Selector.find(ancestors, expression, index);
  },

  down: function(element, expression, index) {
    element = $(element);
    if (arguments.length == 1) return Element.firstDescendant(element);
    return Object.isNumber(expression) ? Element.descendants(element)[expression] :
      Element.select(element, expression)[index || 0];
  },

  previous: function(element, expression, index) {
    element = $(element);
    if (Object.isNumber(expression)) index = expression, expression = false;
    if (!Object.isNumber(index)) index = 0;

    if (expression) {
      return Prototype.Selector.find(element.previousSiblings(), expression, index);
    } else {
      return element.recursivelyCollect("previousSibling", index + 1)[index];
    }
  },

  next: function(element, expression, index) {
    element = $(element);
    if (Object.isNumber(expression)) index = expression, expression = false;
    if (!Object.isNumber(index)) index = 0;

    if (expression) {
      return Prototype.Selector.find(element.nextSiblings(), expression, index);
    } else {
      var maximumLength = Object.isNumber(index) ? index + 1 : 1;
      return element.recursivelyCollect("nextSibling", index + 1)[index];
    }
  },


  select: function(element) {
    element = $(element);
    var expressions = Array.prototype.slice.call(arguments, 1).join(', ');
    return Prototype.Selector.select(expressions, element);
  },

  adjacent: function(element) {
    element = $(element);
    var expressions = Array.prototype.slice.call(arguments, 1).join(', ');
    return Prototype.Selector.select(expressions, element.parentNode).without(element);
  },

  identify: function(element) {
    element = $(element);
    var id = Element.readAttribute(element, 'id');
    if (id) return id;
    do { id = 'anonymous_element_' + Element.idCounter++ } while ($(id));
    Element.writeAttribute(element, 'id', id);
    return id;
  },

  readAttribute: function(element, name) {
    element = $(element);
    if (Prototype.Browser.IE) {
      var t = Element._attributeTranslations.read;
      if (t.values[name]) return t.values[name](element, name);
      if (t.names[name]) name = t.names[name];
      if (name.include(':')) {
        return (!element.attributes || !element.attributes[name]) ? null :
         element.attributes[name].value;
      }
    }
    return element.getAttribute(name);
  },

  writeAttribute: function(element, name, value) {
    element = $(element);
    var attributes = { }, t = Element._attributeTranslations.write;

    if (typeof name == 'object') attributes = name;
    else attributes[name] = Object.isUndefined(value) ? true : value;

    for (var attr in attributes) {
      name = t.names[attr] || attr;
      value = attributes[attr];
      if (t.values[attr]) name = t.values[attr](element, value);
      if (value === false || value === null)
        element.removeAttribute(name);
      else if (value === true)
        element.setAttribute(name, name);
      else element.setAttribute(name, value);
    }
    return element;
  },

  getHeight: function(element) {
    return Element.getDimensions(element).height;
  },

  getWidth: function(element) {
    return Element.getDimensions(element).width;
  },

  classNames: function(element) {
    return new Element.ClassNames(element);
  },

  hasClassName: function(element, className) {
    if (!(element = $(element))) return;
    var elementClassName = element.className;
    return (elementClassName && elementClassName.length > 0 && (elementClassName == className ||
      new RegExp("(^|\\s)" + className + "(\\s|$)").test(elementClassName)));
  },

  addClassName: function(element, className) {
    if (!(element = $(element))) return;
    if (!Element.hasClassName(element, className))
      element.className += (element.className ? ' ' : '') + className;
    return element;
  },

  removeClassName: function(element, className) {
    if (!(element = $(element))) return;
    element.className = element.className.replace(
      new RegExp("(^|\\s+)" + className + "(\\s+|$)"), ' ').strip();
    return element;
  },

  toggleClassName: function(element, className) {
    if (!(element = $(element))) return;
    return Element[Element.hasClassName(element, className) ?
      'removeClassName' : 'addClassName'](element, className);
  },

  cleanWhitespace: function(element) {
    element = $(element);
    var node = element.firstChild;
    while (node) {
      var nextNode = node.nextSibling;
      if (node.nodeType == 3 && !/\S/.test(node.nodeValue))
        element.removeChild(node);
      node = nextNode;
    }
    return element;
  },

  empty: function(element) {
    return $(element).innerHTML.blank();
  },

  descendantOf: function(element, ancestor) {
    element = $(element), ancestor = $(ancestor);

    if (element.compareDocumentPosition)
      return (element.compareDocumentPosition(ancestor) & 8) === 8;

    if (ancestor.contains)
      return ancestor.contains(element) && ancestor !== element;

    while (element = element.parentNode)
      if (element == ancestor) return true;

    return false;
  },

  scrollTo: function(element) {
    element = $(element);
    var pos = Element.cumulativeOffset(element);
    window.scrollTo(pos[0], pos[1]);
    return element;
  },

  getStyle: function(element, style) {
    element = $(element);
    style = style == 'float' ? 'cssFloat' : style.camelize();
    var value = element.style[style];
    if (!value || value == 'auto') {
      var css = document.defaultView.getComputedStyle(element, null);
      value = css ? css[style] : null;
    }
    if (style == 'opacity') return value ? parseFloat(value) : 1.0;
    return value == 'auto' ? null : value;
  },

  getOpacity: function(element) {
    return $(element).getStyle('opacity');
  },

  setStyle: function(element, styles) {
    element = $(element);
    var elementStyle = element.style, match;
    if (Object.isString(styles)) {
      element.style.cssText += ';' + styles;
      return styles.include('opacity') ?
        element.setOpacity(styles.match(/opacity:\s*(\d?\.?\d*)/)[1]) : element;
    }
    for (var property in styles)
      if (property == 'opacity') element.setOpacity(styles[property]);
      else
        elementStyle[(property == 'float' || property == 'cssFloat') ?
          (Object.isUndefined(elementStyle.styleFloat) ? 'cssFloat' : 'styleFloat') :
            property] = styles[property];

    return element;
  },

  setOpacity: function(element, value) {
    element = $(element);
    element.style.opacity = (value == 1 || value === '') ? '' :
      (value < 0.00001) ? 0 : value;
    return element;
  },

  makePositioned: function(element) {
    element = $(element);
    var pos = Element.getStyle(element, 'position');
    if (pos == 'static' || !pos) {
      element._madePositioned = true;
      element.style.position = 'relative';
      if (Prototype.Browser.Opera) {
        element.style.top = 0;
        element.style.left = 0;
      }
    }
    return element;
  },

  undoPositioned: function(element) {
    element = $(element);
    if (element._madePositioned) {
      element._madePositioned = undefined;
      element.style.position =
        element.style.top =
        element.style.left =
        element.style.bottom =
        element.style.right = '';
    }
    return element;
  },

  makeClipping: function(element) {
    element = $(element);
    if (element._overflow) return element;
    element._overflow = Element.getStyle(element, 'overflow') || 'auto';
    if (element._overflow !== 'hidden')
      element.style.overflow = 'hidden';
    return element;
  },

  undoClipping: function(element) {
    element = $(element);
    if (!element._overflow) return element;
    element.style.overflow = element._overflow == 'auto' ? '' : element._overflow;
    element._overflow = null;
    return element;
  },

  clonePosition: function(element, source) {
    var options = Object.extend({
      setLeft:    true,
      setTop:     true,
      setWidth:   true,
      setHeight:  true,
      offsetTop:  0,
      offsetLeft: 0
    }, arguments[2] || { });

    source = $(source);
    var p = Element.viewportOffset(source), delta = [0, 0], parent = null;

    element = $(element);

    if (Element.getStyle(element, 'position') == 'absolute') {
      parent = Element.getOffsetParent(element);
      delta = Element.viewportOffset(parent);
    }

    if (parent == document.body) {
      delta[0] -= document.body.offsetLeft;
      delta[1] -= document.body.offsetTop;
    }

    if (options.setLeft)   element.style.left  = (p[0] - delta[0] + options.offsetLeft) + 'px';
    if (options.setTop)    element.style.top   = (p[1] - delta[1] + options.offsetTop) + 'px';
    if (options.setWidth)  element.style.width = source.offsetWidth + 'px';
    if (options.setHeight) element.style.height = source.offsetHeight + 'px';
    return element;
  }
};

Object.extend(Element.Methods, {
  getElementsBySelector: Element.Methods.select,

  childElements: Element.Methods.immediateDescendants
});

Element._attributeTranslations = {
  write: {
    names: {
      className: 'class',
      htmlFor:   'for'
    },
    values: { }
  }
};

if (Prototype.Browser.Opera) {
  Element.Methods.getStyle = Element.Methods.getStyle.wrap(
    function(proceed, element, style) {
      switch (style) {
        case 'height': case 'width':
          if (!Element.visible(element)) return null;

          var dim = parseInt(proceed(element, style), 10);

          if (dim !== element['offset' + style.capitalize()])
            return dim + 'px';

          var properties;
          if (style === 'height') {
            properties = ['border-top-width', 'padding-top',
             'padding-bottom', 'border-bottom-width'];
          }
          else {
            properties = ['border-left-width', 'padding-left',
             'padding-right', 'border-right-width'];
          }
          return properties.inject(dim, function(memo, property) {
            var val = proceed(element, property);
            return val === null ? memo : memo - parseInt(val, 10);
          }) + 'px';
        default: return proceed(element, style);
      }
    }
  );

  Element.Methods.readAttribute = Element.Methods.readAttribute.wrap(
    function(proceed, element, attribute) {
      if (attribute === 'title') return element.title;
      return proceed(element, attribute);
    }
  );
}

else if (Prototype.Browser.IE) {
  Element.Methods.getStyle = function(element, style) {
    element = $(element);
    style = (style == 'float' || style == 'cssFloat') ? 'styleFloat' : style.camelize();
    var value = element.style[style];
    if (!value && element.currentStyle) value = element.currentStyle[style];

    if (style == 'opacity') {
      if (value = (element.getStyle('filter') || '').match(/alpha\(opacity=(.*)\)/))
        if (value[1]) return parseFloat(value[1]) / 100;
      return 1.0;
    }

    if (value == 'auto') {
      if ((style == 'width' || style == 'height') && (element.getStyle('display') != 'none'))
        return element['offset' + style.capitalize()] + 'px';
      return null;
    }
    return value;
  };

  Element.Methods.setOpacity = function(element, value) {
    function stripAlpha(filter){
      return filter.replace(/alpha\([^\)]*\)/gi,'');
    }
    element = $(element);
    var currentStyle = element.currentStyle;
    if ((currentStyle && !currentStyle.hasLayout) ||
      (!currentStyle && element.style.zoom == 'normal'))
        element.style.zoom = 1;

    var filter = element.getStyle('filter'), style = element.style;
    if (value == 1 || value === '') {
      (filter = stripAlpha(filter)) ?
        style.filter = filter : style.removeAttribute('filter');
      return element;
    } else if (value < 0.00001) value = 0;
    style.filter = stripAlpha(filter) +
      'alpha(opacity=' + (value * 100) + ')';
    return element;
  };

  Element._attributeTranslations = (function(){

    var classProp = 'className',
        forProp = 'for',
        el = document.createElement('div');

    el.setAttribute(classProp, 'x');

    if (el.className !== 'x') {
      el.setAttribute('class', 'x');
      if (el.className === 'x') {
        classProp = 'class';
      }
    }
    el = null;

    el = document.createElement('label');
    el.setAttribute(forProp, 'x');
    if (el.htmlFor !== 'x') {
      el.setAttribute('htmlFor', 'x');
      if (el.htmlFor === 'x') {
        forProp = 'htmlFor';
      }
    }
    el = null;

    return {
      read: {
        names: {
          'class':      classProp,
          'className':  classProp,
          'for':        forProp,
          'htmlFor':    forProp
        },
        values: {
          _getAttr: function(element, attribute) {
            return element.getAttribute(attribute);
          },
          _getAttr2: function(element, attribute) {
            return element.getAttribute(attribute, 2);
          },
          _getAttrNode: function(element, attribute) {
            var node = element.getAttributeNode(attribute);
            return node ? node.value : "";
          },
          _getEv: (function(){

            var el = document.createElement('div'), f;
            el.onclick = Prototype.emptyFunction;
            var value = el.getAttribute('onclick');

            if (String(value).indexOf('{') > -1) {
              f = function(element, attribute) {
                attribute = element.getAttribute(attribute);
                if (!attribute) return null;
                attribute = attribute.toString();
                attribute = attribute.split('{')[1];
                attribute = attribute.split('}')[0];
                return attribute.strip();
              };
            }
            else if (value === '') {
              f = function(element, attribute) {
                attribute = element.getAttribute(attribute);
                if (!attribute) return null;
                return attribute.strip();
              };
            }
            el = null;
            return f;
          })(),
          _flag: function(element, attribute) {
            return $(element).hasAttribute(attribute) ? attribute : null;
          },
          style: function(element) {
            return element.style.cssText.toLowerCase();
          },
          title: function(element) {
            return element.title;
          }
        }
      }
    }
  })();

  Element._attributeTranslations.write = {
    names: Object.extend({
      cellpadding: 'cellPadding',
      cellspacing: 'cellSpacing'
    }, Element._attributeTranslations.read.names),
    values: {
      checked: function(element, value) {
        element.checked = !!value;
      },

      style: function(element, value) {
        element.style.cssText = value ? value : '';
      }
    }
  };

  Element._attributeTranslations.has = {};

  $w('colSpan rowSpan vAlign dateTime accessKey tabIndex ' +
      'encType maxLength readOnly longDesc frameBorder').each(function(attr) {
    Element._attributeTranslations.write.names[attr.toLowerCase()] = attr;
    Element._attributeTranslations.has[attr.toLowerCase()] = attr;
  });

  (function(v) {
    Object.extend(v, {
      href:        v._getAttr2,
      src:         v._getAttr2,
      type:        v._getAttr,
      action:      v._getAttrNode,
      disabled:    v._flag,
      checked:     v._flag,
      readonly:    v._flag,
      multiple:    v._flag,
      onload:      v._getEv,
      onunload:    v._getEv,
      onclick:     v._getEv,
      ondblclick:  v._getEv,
      onmousedown: v._getEv,
      onmouseup:   v._getEv,
      onmouseover: v._getEv,
      onmousemove: v._getEv,
      onmouseout:  v._getEv,
      onfocus:     v._getEv,
      onblur:      v._getEv,
      onkeypress:  v._getEv,
      onkeydown:   v._getEv,
      onkeyup:     v._getEv,
      onsubmit:    v._getEv,
      onreset:     v._getEv,
      onselect:    v._getEv,
      onchange:    v._getEv
    });
  })(Element._attributeTranslations.read.values);

  if (Prototype.BrowserFeatures.ElementExtensions) {
    (function() {
      function _descendants(element) {
        var nodes = element.getElementsByTagName('*'), results = [];
        for (var i = 0, node; node = nodes[i]; i++)
          if (node.tagName !== "!") // Filter out comment nodes.
            results.push(node);
        return results;
      }

      Element.Methods.down = function(element, expression, index) {
        element = $(element);
        if (arguments.length == 1) return element.firstDescendant();
        return Object.isNumber(expression) ? _descendants(element)[expression] :
          Element.select(element, expression)[index || 0];
      }
    })();
  }

}

else if (Prototype.Browser.Gecko && /rv:1\.8\.0/.test(navigator.userAgent)) {
  Element.Methods.setOpacity = function(element, value) {
    element = $(element);
    element.style.opacity = (value == 1) ? 0.999999 :
      (value === '') ? '' : (value < 0.00001) ? 0 : value;
    return element;
  };
}

else if (Prototype.Browser.WebKit) {
  Element.Methods.setOpacity = function(element, value) {
    element = $(element);
    element.style.opacity = (value == 1 || value === '') ? '' :
      (value < 0.00001) ? 0 : value;

    if (value == 1)
      if (element.tagName.toUpperCase() == 'IMG' && element.width) {
        element.width++; element.width--;
      } else try {
        var n = document.createTextNode(' ');
        element.appendChild(n);
        element.removeChild(n);
      } catch (e) { }

    return element;
  };
}

if ('outerHTML' in document.documentElement) {
  Element.Methods.replace = function(element, content) {
    element = $(element);

    if (content && content.toElement) content = content.toElement();
    if (Object.isElement(content)) {
      element.parentNode.replaceChild(content, element);
      return element;
    }

    content = Object.toHTML(content);
    var parent = element.parentNode, tagName = parent.tagName.toUpperCase();

    if (Element._insertionTranslations.tags[tagName]) {
      var nextSibling = element.next(),
          fragments = Element._getContentFromAnonymousElement(tagName, content.stripScripts());
      parent.removeChild(element);
      if (nextSibling)
        fragments.each(function(node) { parent.insertBefore(node, nextSibling) });
      else
        fragments.each(function(node) { parent.appendChild(node) });
    }
    else element.outerHTML = content.stripScripts();

    content.evalScripts.bind(content).p_defer();
    return element;
  };
}

Element._returnOffset = function(l, t) {
  var result = [l, t];
  result.left = l;
  result.top = t;
  return result;
};

Element._getContentFromAnonymousElement = function(tagName, html, force) {
  var div = new Element('div'),
      t = Element._insertionTranslations.tags[tagName];

  var workaround = false;
  if (t) workaround = true;
  else if (force) {
    workaround = true;
    t = ['', '', 0];
  }

  if (workaround) {
    div.innerHTML = '&nbsp;' + t[0] + html + t[1];
    div.removeChild(div.firstChild);
    for (var i = t[2]; i--; ) {
      div = div.firstChild;
    }
  }
  else {
    div.innerHTML = html;
  }
  return $A(div.childNodes);
};

Element._insertionTranslations = {
  before: function(element, node) {
    element.parentNode.insertBefore(node, element);
  },
  top: function(element, node) {
    element.insertBefore(node, element.firstChild);
  },
  bottom: function(element, node) {
    element.appendChild(node);
  },
  after: function(element, node) {
    element.parentNode.insertBefore(node, element.nextSibling);
  },
  tags: {
    TABLE:  ['<table>',                '</table>',                   1],
    TBODY:  ['<table><tbody>',         '</tbody></table>',           2],
    TR:     ['<table><tbody><tr>',     '</tr></tbody></table>',      3],
    TD:     ['<table><tbody><tr><td>', '</td></tr></tbody></table>', 4],
    SELECT: ['<select>',               '</select>',                  1]
  }
};

(function() {
  var tags = Element._insertionTranslations.tags;
  Object.extend(tags, {
    THEAD: tags.TBODY,
    TFOOT: tags.TBODY,
    TH:    tags.TD
  });
})();

Element.Methods.Simulated = {
  hasAttribute: function(element, attribute) {
    attribute = Element._attributeTranslations.has[attribute] || attribute;
    var node = $(element).getAttributeNode(attribute);
    return !!(node && node.specified);
  }
};

Element.Methods.ByTag = { };

Object.extend(Element, Element.Methods);

(function(div) {

  if (!Prototype.BrowserFeatures.ElementExtensions && div['__proto__']) {
    window.HTMLElement = { };
    window.HTMLElement.prototype = div['__proto__'];
    Prototype.BrowserFeatures.ElementExtensions = true;
  }

  div = null;

})(document.createElement('div'));

Element.extend = (function() {

  function checkDeficiency(tagName) {
    if (typeof window.Element != 'undefined') {
      var proto = window.Element.prototype;
      if (proto) {
        var id = '_' + (Math.random()+'').slice(2),
            el = document.createElement(tagName);
        proto[id] = 'x';
        var isBuggy = (el[id] !== 'x');
        delete proto[id];
        el = null;
        return isBuggy;
      }
    }
    return false;
  }

  function extendElementWith(element, methods) {
    for (var property in methods) {
      var value = methods[property];
      if (Object.isFunction(value) && !(property in element))
        element[property] = value.methodize();
    }
  }

  var HTMLOBJECTELEMENT_PROTOTYPE_BUGGY = checkDeficiency('object');

  if (Prototype.BrowserFeatures.SpecificElementExtensions) {
    if (HTMLOBJECTELEMENT_PROTOTYPE_BUGGY) {
      return function(element) {
        if (element && typeof element._extendedByPrototype == 'undefined') {
          var t = element.tagName;
          if (t && (/^(?:object|applet|embed)$/i.test(t))) {
            extendElementWith(element, Element.Methods);
            extendElementWith(element, Element.Methods.Simulated);
            extendElementWith(element, Element.Methods.ByTag[t.toUpperCase()]);
          }
        }
        return element;
      }
    }
    return Prototype.K;
  }

  var Methods = { }, ByTag = Element.Methods.ByTag;

  var extend = Object.extend(function(element) {
    if (!element || typeof element._extendedByPrototype != 'undefined' ||
        element.nodeType != 1 || element == window) return element;

    var methods = Object.clone(Methods),
        tagName = element.tagName.toUpperCase();

    if (ByTag[tagName]) Object.extend(methods, ByTag[tagName]);

    extendElementWith(element, methods);

    element._extendedByPrototype = Prototype.emptyFunction;
    return element;

  }, {
    refresh: function() {
      if (!Prototype.BrowserFeatures.ElementExtensions) {
        Object.extend(Methods, Element.Methods);
        Object.extend(Methods, Element.Methods.Simulated);
      }
    }
  });

  extend.refresh();
  return extend;
})();

if (document.documentElement.hasAttribute) {
  Element.hasAttribute = function(element, attribute) {
    return element.hasAttribute(attribute);
  };
}
else {
  Element.hasAttribute = Element.Methods.Simulated.hasAttribute;
}

Element.addMethods = function(methods) {
  var F = Prototype.BrowserFeatures, T = Element.Methods.ByTag;

  if (!methods) {
    Object.extend(Form, Form.Methods);
    Object.extend(Form.Element, Form.Element.Methods);
    Object.extend(Element.Methods.ByTag, {
      "FORM":     Object.clone(Form.Methods),
      "INPUT":    Object.clone(Form.Element.Methods),
      "SELECT":   Object.clone(Form.Element.Methods),
      "TEXTAREA": Object.clone(Form.Element.Methods),
      "BUTTON":   Object.clone(Form.Element.Methods)
    });
  }

  if (arguments.length == 2) {
    var tagName = methods;
    methods = arguments[1];
  }

  if (!tagName) Object.extend(Element.Methods, methods || { });
  else {
    if (Object.isArray(tagName)) tagName.each(extend);
    else extend(tagName);
  }

  function extend(tagName) {
    tagName = tagName.toUpperCase();
    if (!Element.Methods.ByTag[tagName])
      Element.Methods.ByTag[tagName] = { };
    Object.extend(Element.Methods.ByTag[tagName], methods);
  }

  function copy(methods, destination, onlyIfAbsent) {
    onlyIfAbsent = onlyIfAbsent || false;
    for (var property in methods) {
      var value = methods[property];
      if (!Object.isFunction(value)) continue;
      if (!onlyIfAbsent || !(property in destination))
        destination[property] = value.methodize();
    }
  }

  function findDOMClass(tagName) {
    var klass;
    var trans = {
      "OPTGROUP": "OptGroup", "TEXTAREA": "TextArea", "P": "Paragraph",
      "FIELDSET": "FieldSet", "UL": "UList", "OL": "OList", "DL": "DList",
      "DIR": "Directory", "H1": "Heading", "H2": "Heading", "H3": "Heading",
      "H4": "Heading", "H5": "Heading", "H6": "Heading", "Q": "Quote",
      "INS": "Mod", "DEL": "Mod", "A": "Anchor", "IMG": "Image", "CAPTION":
      "TableCaption", "COL": "TableCol", "COLGROUP": "TableCol", "THEAD":
      "TableSection", "TFOOT": "TableSection", "TBODY": "TableSection", "TR":
      "TableRow", "TH": "TableCell", "TD": "TableCell", "FRAMESET":
      "FrameSet", "IFRAME": "IFrame"
    };
    if (trans[tagName]) klass = 'HTML' + trans[tagName] + 'Element';
    if (window[klass]) return window[klass];
    klass = 'HTML' + tagName + 'Element';
    if (window[klass]) return window[klass];
    klass = 'HTML' + tagName.capitalize() + 'Element';
    if (window[klass]) return window[klass];

    var element = document.createElement(tagName),
        proto = element['__proto__'] || element.constructor.prototype;

    element = null;
    return proto;
  }

  var elementPrototype = window.HTMLElement ? HTMLElement.prototype :
   Element.prototype;

  if (F.ElementExtensions) {
    copy(Element.Methods, elementPrototype);
    copy(Element.Methods.Simulated, elementPrototype, true);
  }

  if (F.SpecificElementExtensions) {
    for (var tag in Element.Methods.ByTag) {
      var klass = findDOMClass(tag);
      if (Object.isUndefined(klass)) continue;
      copy(T[tag], klass.prototype);
    }
  }

  Object.extend(Element, Element.Methods);
  delete Element.ByTag;

  if (Element.extend.refresh) Element.extend.refresh();
  Element.cache = { };
};


document.viewport = {

  getDimensions: function() {
    return { width: this.getWidth(), height: this.getHeight() };
  },

  getScrollOffsets: function() {
    return Element._returnOffset(
      window.pageXOffset || document.documentElement.scrollLeft || document.body.scrollLeft,
      window.pageYOffset || document.documentElement.scrollTop  || document.body.scrollTop);
  }
};

(function(viewport) {
  var B = Prototype.Browser, doc = document, element, property = {};

  function getRootElement() {
    if (B.WebKit && !doc.evaluate)
      return document;

    if (B.Opera && window.parseFloat(window.opera.version()) < 9.5)
      return document.body;

    return document.documentElement;
  }

  function define(D) {
    if (!element) element = getRootElement();

    property[D] = 'client' + D;

    viewport['get' + D] = function() { return element[property[D]] };
    return viewport['get' + D]();
  }

  viewport.getWidth  = define.curry('Width');

  viewport.getHeight = define.curry('Height');
})(document.viewport);


Element.Storage = {
  UID: 1
};

Element.addMethods({
  getStorage: function(element) {
    if (!(element = $(element))) return;

    var uid;
    if (element === window) {
      uid = 0;
    } else {
      if (typeof element._prototypeUID === "undefined")
        element._prototypeUID = Element.Storage.UID++;
      uid = element._prototypeUID;
    }

    if (!Element.Storage[uid])
      Element.Storage[uid] = $H();

    return Element.Storage[uid];
  },

  store: function(element, key, value) {
    if (!(element = $(element))) return;

    if (arguments.length === 2) {
      Element.getStorage(element).update(key);
    } else {
      Element.getStorage(element).set(key, value);
    }

    return element;
  },

  retrieve: function(element, key, defaultValue) {
    if (!(element = $(element))) return;
    var hash = Element.getStorage(element), value = hash.get(key);

    if (Object.isUndefined(value)) {
      hash.set(key, defaultValue);
      value = defaultValue;
    }

    return value;
  },

  clone: function(element, deep) {
    if (!(element = $(element))) return;
    var clone = element.cloneNode(deep);
    clone._prototypeUID = void 0;
    if (deep) {
      var descendants = Element.select(clone, '*'),
          i = descendants.length;
      while (i--) {
        descendants[i]._prototypeUID = void 0;
      }
    }
    return Element.extend(clone);
  },

  purge: function(element) {
    if (!(element = $(element))) return;
    var purgeElement = Element._purgeElement;

    purgeElement(element);

    var descendants = element.getElementsByTagName('*'),
     i = descendants.length;

    while (i--) purgeElement(descendants[i]);

    return null;
  }
});

(function() {

  function toDecimal(pctString) {
    var match = pctString.match(/^(\d+)%?$/i);
    if (!match) return null;
    return (Number(match[1]) / 100);
  }

  function getPixelValue(value, property, context) {
    var element = null;
    if (Object.isElement(value)) {
      element = value;
      value = element.getStyle(property);
    }

    if (value === null) {
      return null;
    }

    if ((/^(?:-)?\d+(\.\d+)?(px)?$/i).test(value)) {
      return window.parseFloat(value);
    }

    var isPercentage = value.include('%'), isViewport = (context === document.viewport);

    if (/\d/.test(value) && element && element.runtimeStyle && !(isPercentage && isViewport)) {
      var style = element.style.left, rStyle = element.runtimeStyle.left;
      element.runtimeStyle.left = element.currentStyle.left;
      element.style.left = value || 0;
      value = element.style.pixelLeft;
      element.style.left = style;
      element.runtimeStyle.left = rStyle;

      return value;
    }

    if (element && isPercentage) {
      context = context || element.parentNode;
      var decimal = toDecimal(value);
      var whole = null;
      var position = element.getStyle('position');

      var isHorizontal = property.include('left') || property.include('right') ||
       property.include('width');

      var isVertical =  property.include('top') || property.include('bottom') ||
        property.include('height');

      if (context === document.viewport) {
        if (isHorizontal) {
          whole = document.viewport.getWidth();
        } else if (isVertical) {
          whole = document.viewport.getHeight();
        }
      } else {
        if (isHorizontal) {
          whole = $(context).measure('width');
        } else if (isVertical) {
          whole = $(context).measure('height');
        }
      }

      return (whole === null) ? 0 : whole * decimal;
    }

    return 0;
  }

  function toCSSPixels(number) {
    if (Object.isString(number) && number.endsWith('px')) {
      return number;
    }
    return number + 'px';
  }

  function isDisplayed(element) {
    var originalElement = element;
    while (element && element.parentNode) {
      var display = element.getStyle('display');
      if (display === 'none') {
        return false;
      }
      element = $(element.parentNode);
    }
    return true;
  }

  var hasLayout = Prototype.K;
  if ('currentStyle' in document.documentElement) {
    hasLayout = function(element) {
      if (!element.currentStyle.hasLayout) {
        element.style.zoom = 1;
      }
      return element;
    };
  }

  function cssNameFor(key) {
    if (key.include('border')) key = key + '-width';
    return key.camelize();
  }

  Element.Layout = Class.create(Hash, {
    initialize: function($super, element, preCompute) {
      $super();
      this.element = $(element);

      Element.Layout.PROPERTIES.each( function(property) {
        this._set(property, null);
      }, this);

      if (preCompute) {
        this._preComputing = true;
        this._begin();
        Element.Layout.PROPERTIES.each( this._compute, this );
        this._end();
        this._preComputing = false;
      }
    },

    _set: function(property, value) {
      return Hash.prototype.set.call(this, property, value);
    },

    set: function(property, value) {
      throw "Properties of Element.Layout are read-only.";
    },

    get: function($super, property) {
      var value = $super(property);
      return value === null ? this._compute(property) : value;
    },

    _begin: function() {
      if (this._prepared) return;

      var element = this.element;
      if (isDisplayed(element)) {
        this._prepared = true;
        return;
      }

      var originalStyles = {
        position:   element.style.position   || '',
        width:      element.style.width      || '',
        visibility: element.style.visibility || '',
        display:    element.style.display    || ''
      };

      element.store('prototype_original_styles', originalStyles);

      var position = element.getStyle('position'),
       width = element.getStyle('width');

      if (width === "0px" || width === null) {
        element.style.display = 'block';
        width = element.getStyle('width');
      }

      var context = (position === 'fixed') ? document.viewport :
       element.parentNode;

      element.setStyle({
        position:   'absolute',
        visibility: 'hidden',
        display:    'block'
      });

      var positionedWidth = element.getStyle('width');

      var newWidth;
      if (width && (positionedWidth === width)) {
        newWidth = getPixelValue(element, 'width', context);
      } else if (position === 'absolute' || position === 'fixed') {
        newWidth = getPixelValue(element, 'width', context);
      } else {
        var parent = element.parentNode, pLayout = $(parent).getLayout();

        newWidth = pLayout.get('width') -
         this.get('margin-left') -
         this.get('border-left') -
         this.get('padding-left') -
         this.get('padding-right') -
         this.get('border-right') -
         this.get('margin-right');
      }

      element.setStyle({ width: newWidth + 'px' });

      this._prepared = true;
    },

    _end: function() {
      var element = this.element;
      var originalStyles = element.retrieve('prototype_original_styles');
      element.store('prototype_original_styles', null);
      element.setStyle(originalStyles);
      this._prepared = false;
    },

    _compute: function(property) {
      var COMPUTATIONS = Element.Layout.COMPUTATIONS;
      if (!(property in COMPUTATIONS)) {
        throw "Property not found.";
      }

      return this._set(property, COMPUTATIONS[property].call(this, this.element));
    },

    toObject: function() {
      var args = $A(arguments);
      var keys = (args.length === 0) ? Element.Layout.PROPERTIES :
       args.join(' ').split(' ');
      var obj = {};
      keys.each( function(key) {
        if (!Element.Layout.PROPERTIES.include(key)) return;
        var value = this.get(key);
        if (value != null) obj[key] = value;
      }, this);
      return obj;
    },

    toHash: function() {
      var obj = this.toObject.apply(this, arguments);
      return new Hash(obj);
    },

    toCSS: function() {
      var args = $A(arguments);
      var keys = (args.length === 0) ? Element.Layout.PROPERTIES :
       args.join(' ').split(' ');
      var css = {};

      keys.each( function(key) {
        if (!Element.Layout.PROPERTIES.include(key)) return;
        if (Element.Layout.COMPOSITE_PROPERTIES.include(key)) return;

        var value = this.get(key);
        if (value != null) css[cssNameFor(key)] = value + 'px';
      }, this);
      return css;
    },

    inspect: function() {
      return "#<Element.Layout>";
    }
  });

  Object.extend(Element.Layout, {
    PROPERTIES: $w('height width top left right bottom border-left border-right border-top border-bottom padding-left padding-right padding-top padding-bottom margin-top margin-bottom margin-left margin-right padding-box-width padding-box-height border-box-width border-box-height margin-box-width margin-box-height cumulative-left cumulative-top'),

    COMPOSITE_PROPERTIES: $w('padding-box-width padding-box-height margin-box-width margin-box-height border-box-width border-box-height'),

    COMPUTATIONS: {
      'height': function(element) {
        if (!this._preComputing) this._begin();

        var bHeight = this.get('border-box-height');
        if (bHeight <= 0) {
          if (!this._preComputing) this._end();
          return 0;
        }

        var bTop = this.get('border-top'),
         bBottom = this.get('border-bottom');

        var pTop = this.get('padding-top'),
         pBottom = this.get('padding-bottom');

        if (!this._preComputing) this._end();

        return bHeight - bTop - bBottom - pTop - pBottom;
      },

      'width': function(element) {
        if (!this._preComputing) this._begin();

        var bWidth = this.get('border-box-width');
        if (bWidth <= 0) {
          if (!this._preComputing) this._end();
          return 0;
        }

        var bLeft = this.get('border-left'),
         bRight = this.get('border-right');

        var pLeft = this.get('padding-left'),
         pRight = this.get('padding-right');

        if (!this._preComputing) this._end();

        return bWidth - bLeft - bRight - pLeft - pRight;
      },

      'padding-box-height': function(element) {
        var height = this.get('height'),
         pTop = this.get('padding-top'),
         pBottom = this.get('padding-bottom');

        return height + pTop + pBottom;
      },

      'padding-box-width': function(element) {
        var width = this.get('width'),
         pLeft = this.get('padding-left'),
         pRight = this.get('padding-right');

        return width + pLeft + pRight;
      },

      'border-box-height': function(element) {
        if (!this._preComputing) this._begin();
        var height = element.offsetHeight;
        if (!this._preComputing) this._end();
        return height;
      },
      
      'cumulative-left': function(element){
          return element.cumulativeOffset().left;
      },
      
      'cumulative-top': function(element){
          return element.cumulativeOffset().top;
      },
      
      'border-box-width': function(element) {
        if (!this._preComputing) this._begin();
        var width = element.offsetWidth;
        if (!this._preComputing) this._end();
        return width;
      },

      'margin-box-height': function(element) {
        var bHeight = this.get('border-box-height'),
         mTop = this.get('margin-top'),
         mBottom = this.get('margin-bottom');

        if (bHeight <= 0) return 0;

        return bHeight + mTop + mBottom;
      },

      'margin-box-width': function(element) {
        var bWidth = this.get('border-box-width'),
         mLeft = this.get('margin-left'),
         mRight = this.get('margin-right');

        if (bWidth <= 0) return 0;

        return bWidth + mLeft + mRight;
      },

      'top': function(element) {
        var offset = element.positionedOffset();
        return offset.top;
      },

      'bottom': function(element) {
        var offset = element.positionedOffset(),
         parent = element.getOffsetParent(),
         pHeight = parent.measure('height');

        var mHeight = this.get('border-box-height');

        return pHeight - mHeight - offset.top;
      },

      'left': function(element) {
        var offset = element.positionedOffset();
        return offset.left;
      },

      'right': function(element) {
        var offset = element.positionedOffset(),
         parent = element.getOffsetParent(),
         pWidth = parent.measure('width');

        var mWidth = this.get('border-box-width');

        return pWidth - mWidth - offset.left;
      },

      'padding-top': function(element) {
        return getPixelValue(element, 'paddingTop');
      },

      'padding-bottom': function(element) {
        return getPixelValue(element, 'paddingBottom');
      },

      'padding-left': function(element) {
        return getPixelValue(element, 'paddingLeft');
      },

      'padding-right': function(element) {
        return getPixelValue(element, 'paddingRight');
      },

      'border-top': function(element) {
        return getPixelValue(element, 'borderTopWidth');
      },

      'border-bottom': function(element) {
        return getPixelValue(element, 'borderBottomWidth');
      },

      'border-left': function(element) {
        return getPixelValue(element, 'borderLeftWidth');
      },

      'border-right': function(element) {
        return getPixelValue(element, 'borderRightWidth');
      },

      'margin-top': function(element) {
        return getPixelValue(element, 'marginTop');
      },

      'margin-bottom': function(element) {
        return getPixelValue(element, 'marginBottom');
      },

      'margin-left': function(element) {
        return getPixelValue(element, 'marginLeft');
      },

      'margin-right': function(element) {
        return getPixelValue(element, 'marginRight');
      }
    }
  });

  if ('getBoundingClientRect' in document.documentElement) {
    Object.extend(Element.Layout.COMPUTATIONS, {
      'right': function(element) {
        var parent = hasLayout(element.getOffsetParent());
        var rect = element.getBoundingClientRect(),
         pRect = parent.getBoundingClientRect();

        return (pRect.right - rect.right).round();
      },

      'bottom': function(element) {
        var parent = hasLayout(element.getOffsetParent());
        var rect = element.getBoundingClientRect(),
         pRect = parent.getBoundingClientRect();

        return (pRect.bottom - rect.bottom).round();
      }
    });
  }

  Element.Offset = Class.create({
    initialize: function(left, top) {
      this.left = left.round();
      this.top  = top.round();

      this[0] = this.left;
      this[1] = this.top;
    },

    relativeTo: function(offset) {
      return new Element.Offset(
        this.left - offset.left,
        this.top  - offset.top
      );
    },

    inspect: function() {
      return "#<Element.Offset left: #{left} top: #{top}>".interpolate(this);
    },

    toString: function() {
      return "[#{left}, #{top}]".interpolate(this);
    },

    toArray: function() {
      return [this.left, this.top];
    }
  });

  function getLayout(element, preCompute) {
    return new Element.Layout(element, preCompute);
  }

  function measure(element, property) {
    return $(element).getLayout().get(property);
  }

  function getDimensions(element) {
    element = $(element);
    var display = Element.getStyle(element, 'display');

    if (display && display !== 'none') {
      return { width: element.offsetWidth, height: element.offsetHeight };
    }

    var style = element.style;
    var originalStyles = {
      visibility: style.visibility,
      position:   style.position,
      display:    style.display
    };

    var newStyles = {
      visibility: 'hidden',
      display:    'block'
    };

    if (originalStyles.position !== 'fixed')
      newStyles.position = 'absolute';

    Element.setStyle(element, newStyles);

    var dimensions = {
      width:  element.offsetWidth,
      height: element.offsetHeight
    };

    Element.setStyle(element, originalStyles);

    return dimensions;
  }

  function getOffsetParent(element) {
    element = $(element);

    if (isDocument(element) || isDetached(element) || isBody(element) || isHtml(element))
      return $(document.body);

    var isInline = (Element.getStyle(element, 'display') === 'inline');
    if (!isInline && element.offsetParent) return $(element.offsetParent);

    while ((element = element.parentNode) && element !== document.body) {
      if (Element.getStyle(element, 'position') !== 'static') {
        return isHtml(element) ? $(document.body) : $(element);
      }
    }

    return $(document.body);
  }


  function cumulativeOffset(element) {
    element = $(element);
    var valueT = 0, valueL = 0;
    if (element.parentNode) {
      do {
        valueT += element.offsetTop  || 0;
        valueL += element.offsetLeft || 0;
        element = element.offsetParent;
      } while (element);
    }
    return new Element.Offset(valueL, valueT);
  }

  function positionedOffset(element) {
    element = $(element);

    var layout = element.getLayout();

    var valueT = 0, valueL = 0;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      element = element.offsetParent;
      if (element) {
        if (isBody(element)) break;
        var p = Element.getStyle(element, 'position');
        if (p !== 'static') break;
      }
    } while (element);

    valueL -= layout.get('margin-top');
    valueT -= layout.get('margin-left');

    return new Element.Offset(valueL, valueT);
  }

  function cumulativeScrollOffset(element) {
    var valueT = 0, valueL = 0;
    if (isBody(element) && navigator.userAgent.indexOf('Chrome/32') > -1) {element = document.documentElement};
    do {
      valueT += element.scrollTop  || 0;
      valueL += element.scrollLeft || 0;
      element = element.parentNode;
    } while (element);
    return new Element.Offset(valueL, valueT);
  }

  function viewportOffset(forElement) {
    element = $(element);
    var valueT = 0, valueL = 0, docBody = document.body;

    var element = forElement;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      if (element.offsetParent == docBody &&
        Element.getStyle(element, 'position') == 'absolute') break;
    } while (element = element.offsetParent);

    element = forElement;
    do {
      if (element != docBody) {
        valueT -= element.scrollTop  || 0;
        valueL -= element.scrollLeft || 0;
      }
    } while (element = element.parentNode);
    return new Element.Offset(valueL, valueT);
  }

  function absolutize(element) {
    element = $(element);

    if (Element.getStyle(element, 'position') === 'absolute') {
      return element;
    }

    var offsetParent = getOffsetParent(element);
    var eOffset = element.viewportOffset(),
     pOffset = offsetParent.viewportOffset();

    var offset = eOffset.relativeTo(pOffset);
    var layout = element.getLayout();

    element.store('prototype_absolutize_original_styles', {
      left:   element.getStyle('left'),
      top:    element.getStyle('top'),
      width:  element.getStyle('width'),
      height: element.getStyle('height')
    });

    element.setStyle({
      position: 'absolute',
      top:    offset.top + 'px',
      left:   offset.left + 'px',
      width:  layout.get('width') + 'px',
      height: layout.get('height') + 'px'
    });

    return element;
  }

  function relativize(element) {
    element = $(element);
    if (Element.getStyle(element, 'position') === 'relative') {
      return element;
    }

    var originalStyles =
     element.retrieve('prototype_absolutize_original_styles');

    if (originalStyles) element.setStyle(originalStyles);
    return element;
  }

  if (Prototype.Browser.IE) {
    getOffsetParent = getOffsetParent.wrap(
      function(proceed, element) {
        element = $(element);

        if (isDocument(element) || isDetached(element) || isBody(element) || isHtml(element))
          return $(document.body);

        var position = element.getStyle('position');
        if (position !== 'static') return proceed(element);

        element.setStyle({ position: 'relative' });
        var value = proceed(element);
        element.setStyle({ position: position });
        return value;
      }
    );

    positionedOffset = positionedOffset.wrap(function(proceed, element) {
      element = $(element);
      if (!element.parentNode) return new Element.Offset(0, 0);
      var position = element.getStyle('position');
      if (position !== 'static') return proceed(element);

      var offsetParent = element.getOffsetParent();
      if (offsetParent && offsetParent.getStyle('position') === 'fixed')
        hasLayout(offsetParent);

      element.setStyle({ position: 'relative' });
      var value = proceed(element);
      element.setStyle({ position: position });
      return value;
    });
  } else if (Prototype.Browser.Webkit) {
    cumulativeOffset = function(element) {
      element = $(element);
      var valueT = 0, valueL = 0;
      do {
        valueT += element.offsetTop  || 0;
        valueL += element.offsetLeft || 0;
        if (element.offsetParent == document.body)
          if (Element.getStyle(element, 'position') == 'absolute') break;

        element = element.offsetParent;
      } while (element);

      return new Element.Offset(valueL, valueT);
    };
  }


  Element.addMethods({
    getLayout:              getLayout,
    measure:                measure,
    getDimensions:          getDimensions,
    getOffsetParent:        getOffsetParent,
    cumulativeOffset:       cumulativeOffset,
    positionedOffset:       positionedOffset,
    cumulativeScrollOffset: cumulativeScrollOffset,
    viewportOffset:         viewportOffset,
    absolutize:             absolutize,
    relativize:             relativize
  });

  function isBody(element) {
    return element.nodeName.toUpperCase() === 'BODY';
  }

  function isHtml(element) {
    return element.nodeName.toUpperCase() === 'HTML';
  }

  function isDocument(element) {
    return element.nodeType === Node.DOCUMENT_NODE;
  }

  function isDetached(element) {
    return element !== document.body &&
     !Element.descendantOf(element, document.body);
  }

  if ('getBoundingClientRect' in document.documentElement) {
    Element.addMethods({
      viewportOffset: function(element) {
        element = $(element);
        if (isDetached(element)) return new Element.Offset(0, 0);

        var rect = element.getBoundingClientRect(),
         docEl = document.documentElement;
        return new Element.Offset(rect.left - docEl.clientLeft,
         rect.top - docEl.clientTop);
      }
    });
  }
})();
window.$$ = function() {
  var expression = $A(arguments).join(', ');
  return Prototype.Selector.select(expression, document);
};

Prototype.Selector = (function() {

  function select() {
    throw new Error('Method "Prototype.Selector.select" must be defined.');
  }

  function match() {
    throw new Error('Method "Prototype.Selector.match" must be defined.');
  }

  function find(elements, expression, index) {
    index = index || 0;
    var match = Prototype.Selector.match, length = elements.length, matchIndex = 0, i;

    for (i = 0; i < length; i++) {
      if (match(elements[i], expression) && index == matchIndex++) {
        return Element.extend(elements[i]);
      }
    }
  }

  function extendElements(elements) {
    for (var i = 0, length = elements.length; i < length; i++) {
      Element.extend(elements[i]);
    }
    return elements;
  }


  var K = Prototype.K;

  return {
    select: select,
    match: match,
    find: find,
    extendElements: (Element.extend === K) ? K : extendElements,
    extendElement: Element.extend
  };
})();
Prototype._original_property = window.Sizzle;
/*!
 * Sizzle CSS Selector Engine - v1.0
 *  Copyright 2009, The Dojo Foundation
 *  Released under the MIT, BSD, and GPL Licenses.
 *  More information: http://sizzlejs.com/
 */
(function(){

var chunker = /((?:\((?:\([^()]+\)|[^()]+)+\)|\[(?:\[[^[\]]*\]|['"][^'"]*['"]|[^[\]'"]+)+\]|\\.|[^ >+~,(\[\\]+)+|[>+~])(\s*,\s*)?((?:.|\r|\n)*)/g,
    done = 0,
    toString = Object.prototype.toString,
    hasDuplicate = false,
    baseHasDuplicate = true;

[0, 0].sort(function(){
    baseHasDuplicate = false;
    return 0;
});

var Sizzle = function(selector, context, results, seed) {
    results = results || [];
    var origContext = context = context || document;

    if ( context.nodeType !== 1 && context.nodeType !== 9 ) {
        return [];
    }

    if ( !selector || typeof selector !== "string" ) {
        return results;
    }

    var parts = [], m, set, checkSet, check, mode, extra, prune = true, contextXML = isXML(context),
        soFar = selector;

    while ( (chunker.exec(""), m = chunker.exec(soFar)) !== null ) {
        soFar = m[3];

        parts.push( m[1] );

        if ( m[2] ) {
            extra = m[3];
            break;
        }
    }

    if ( parts.length > 1 && origPOS.exec( selector ) ) {
        if ( parts.length === 2 && Expr.relative[ parts[0] ] ) {
            set = posProcess( parts[0] + parts[1], context );
        } else {
            set = Expr.relative[ parts[0] ] ?
                [ context ] :
                Sizzle( parts.shift(), context );

            while ( parts.length ) {
                selector = parts.shift();

                if ( Expr.relative[ selector ] )
                    selector += parts.shift();

                set = posProcess( selector, set );
            }
        }
    } else {
        if ( !seed && parts.length > 1 && context.nodeType === 9 && !contextXML &&
                Expr.match.ID.test(parts[0]) && !Expr.match.ID.test(parts[parts.length - 1]) ) {
            var ret = Sizzle.find( parts.shift(), context, contextXML );
            context = ret.expr ? Sizzle.filter( ret.expr, ret.set )[0] : ret.set[0];
        }

        if ( context ) {
            var ret = seed ?
                { expr: parts.pop(), set: makeArray(seed) } :
                Sizzle.find( parts.pop(), parts.length === 1 && (parts[0] === "~" || parts[0] === "+") && context.parentNode ? context.parentNode : context, contextXML );
            set = ret.expr ? Sizzle.filter( ret.expr, ret.set ) : ret.set;

            if ( parts.length > 0 ) {
                checkSet = makeArray(set);
            } else {
                prune = false;
            }

            while ( parts.length ) {
                var cur = parts.pop(), pop = cur;

                if ( !Expr.relative[ cur ] ) {
                    cur = "";
                } else {
                    pop = parts.pop();
                }

                if ( pop == null ) {
                    pop = context;
                }

                Expr.relative[ cur ]( checkSet, pop, contextXML );
            }
        } else {
            checkSet = parts = [];
        }
    }

    if ( !checkSet ) {
        checkSet = set;
    }

    if ( !checkSet ) {
        throw "Syntax error, unrecognized expression: " + (cur || selector);
    }

    if ( toString.call(checkSet) === "[object Array]" ) {
        if ( !prune ) {
            results.push.apply( results, checkSet );
        } else if ( context && context.nodeType === 1 ) {
            for ( var i = 0; checkSet[i] != null; i++ ) {
                if ( checkSet[i] && (checkSet[i] === true || checkSet[i].nodeType === 1 && contains(context, checkSet[i])) ) {
                    results.push( set[i] );
                }
            }
        } else {
            for ( var i = 0; checkSet[i] != null; i++ ) {
                if ( checkSet[i] && checkSet[i].nodeType === 1 ) {
                    results.push( set[i] );
                }
            }
        }
    } else {
        makeArray( checkSet, results );
    }

    if ( extra ) {
        Sizzle( extra, origContext, results, seed );
        Sizzle.uniqueSort( results );
    }

    return results;
};

Sizzle.uniqueSort = function(results){
    if ( sortOrder ) {
        hasDuplicate = baseHasDuplicate;
        results.sort(sortOrder);

        if ( hasDuplicate ) {
            for ( var i = 1; i < results.length; i++ ) {
                if ( results[i] === results[i-1] ) {
                    results.splice(i--, 1);
                }
            }
        }
    }

    return results;
};

Sizzle.matches = function(expr, set){
    return Sizzle(expr, null, null, set);
};

Sizzle.find = function(expr, context, isXML){
    var set, match;

    if ( !expr ) {
        return [];
    }

    for ( var i = 0, l = Expr.order.length; i < l; i++ ) {
        var type = Expr.order[i], match;

        if ( (match = Expr.leftMatch[ type ].exec( expr )) ) {
            var left = match[1];
            match.splice(1,1);

            if ( left.substr( left.length - 1 ) !== "\\" ) {
                match[1] = (match[1] || "").replace(/\\/g, "");
                set = Expr.find[ type ]( match, context, isXML );
                if ( set != null ) {
                    expr = expr.replace( Expr.match[ type ], "" );
                    break;
                }
            }
        }
    }

    if ( !set ) {
        set = context.getElementsByTagName("*");
    }

    return {set: set, expr: expr};
};

Sizzle.filter = function(expr, set, inplace, not){
    var old = expr, result = [], curLoop = set, match, anyFound,
        isXMLFilter = set && set[0] && isXML(set[0]);

    while ( expr && set.length ) {
        for ( var type in Expr.filter ) {
            if ( (match = Expr.match[ type ].exec( expr )) != null ) {
                var filter = Expr.filter[ type ], found, item;
                anyFound = false;

                if ( curLoop == result ) {
                    result = [];
                }

                if ( Expr.preFilter[ type ] ) {
                    match = Expr.preFilter[ type ]( match, curLoop, inplace, result, not, isXMLFilter );

                    if ( !match ) {
                        anyFound = found = true;
                    } else if ( match === true ) {
                        continue;
                    }
                }

                if ( match ) {
                    for ( var i = 0; (item = curLoop[i]) != null; i++ ) {
                        if ( item ) {
                            found = filter( item, match, i, curLoop );
                            var pass = not ^ !!found;

                            if ( inplace && found != null ) {
                                if ( pass ) {
                                    anyFound = true;
                                } else {
                                    curLoop[i] = false;
                                }
                            } else if ( pass ) {
                                result.push( item );
                                anyFound = true;
                            }
                        }
                    }
                }

                if ( found !== undefined ) {
                    if ( !inplace ) {
                        curLoop = result;
                    }

                    expr = expr.replace( Expr.match[ type ], "" );

                    if ( !anyFound ) {
                        return [];
                    }

                    break;
                }
            }
        }

        if ( expr == old ) {
            if ( anyFound == null ) {
                throw "Syntax error, unrecognized expression: " + expr;
            } else {
                break;
            }
        }

        old = expr;
    }

    return curLoop;
};

var Expr = Sizzle.selectors = {
    order: [ "ID", "NAME", "TAG" ],
    match: {
        ID: /#((?:[\w\u00c0-\uFFFF-]|\\.)+)/,
        CLASS: /\.((?:[\w\u00c0-\uFFFF-]|\\.)+)/,
        NAME: /\[name=['"]*((?:[\w\u00c0-\uFFFF-]|\\.)+)['"]*\]/,
        ATTR: /\[\s*((?:[\w\u00c0-\uFFFF-]|\\.)+)\s*(?:(\S?=)\s*(['"]*)(.*?)\3|)\s*\]/,
        TAG: /^((?:[\w\u00c0-\uFFFF\*-]|\\.)+)/,
        CHILD: /:(only|nth|last|first)-child(?:\((even|odd|[\dn+-]*)\))?/,
        POS: /:(nth|eq|gt|lt|first|last|even|odd)(?:\((\d*)\))?(?=[^-]|$)/,
        PSEUDO: /:((?:[\w\u00c0-\uFFFF-]|\\.)+)(?:\((['"]*)((?:\([^\)]+\)|[^\2\(\)]*)+)\2\))?/
    },
    leftMatch: {},
    attrMap: {
        "class": "className",
        "for": "htmlFor"
    },
    attrHandle: {
        href: function(elem){
            return elem.getAttribute("href");
        }
    },
    relative: {
        "+": function(checkSet, part, isXML){
            var isPartStr = typeof part === "string",
                isTag = isPartStr && !/\W/.test(part),
                isPartStrNotTag = isPartStr && !isTag;

            if ( isTag && !isXML ) {
                part = part.toUpperCase();
            }

            for ( var i = 0, l = checkSet.length, elem; i < l; i++ ) {
                if ( (elem = checkSet[i]) ) {
                    while ( (elem = elem.previousSibling) && elem.nodeType !== 1 ) {}

                    checkSet[i] = isPartStrNotTag || elem && elem.nodeName === part ?
                        elem || false :
                        elem === part;
                }
            }

            if ( isPartStrNotTag ) {
                Sizzle.filter( part, checkSet, true );
            }
        },
        ">": function(checkSet, part, isXML){
            var isPartStr = typeof part === "string";

            if ( isPartStr && !/\W/.test(part) ) {
                part = isXML ? part : part.toUpperCase();

                for ( var i = 0, l = checkSet.length; i < l; i++ ) {
                    var elem = checkSet[i];
                    if ( elem ) {
                        var parent = elem.parentNode;
                        checkSet[i] = parent.nodeName === part ? parent : false;
                    }
                }
            } else {
                for ( var i = 0, l = checkSet.length; i < l; i++ ) {
                    var elem = checkSet[i];
                    if ( elem ) {
                        checkSet[i] = isPartStr ?
                            elem.parentNode :
                            elem.parentNode === part;
                    }
                }

                if ( isPartStr ) {
                    Sizzle.filter( part, checkSet, true );
                }
            }
        },
        "": function(checkSet, part, isXML){
            var doneName = done++, checkFn = dirCheck;

            if ( !/\W/.test(part) ) {
                var nodeCheck = part = isXML ? part : part.toUpperCase();
                checkFn = dirNodeCheck;
            }

            checkFn("parentNode", part, doneName, checkSet, nodeCheck, isXML);
        },
        "~": function(checkSet, part, isXML){
            var doneName = done++, checkFn = dirCheck;

            if ( typeof part === "string" && !/\W/.test(part) ) {
                var nodeCheck = part = isXML ? part : part.toUpperCase();
                checkFn = dirNodeCheck;
            }

            checkFn("previousSibling", part, doneName, checkSet, nodeCheck, isXML);
        }
    },
    find: {
        ID: function(match, context, isXML){
            if ( typeof context.getElementById !== "undefined" && !isXML ) {
                var m = context.getElementById(match[1]);
                return m ? [m] : [];
            }
        },
        NAME: function(match, context, isXML){
            if ( typeof context.getElementsByName !== "undefined" ) {
                var ret = [], results = context.getElementsByName(match[1]);

                for ( var i = 0, l = results.length; i < l; i++ ) {
                    if ( results[i].getAttribute("name") === match[1] ) {
                        ret.push( results[i] );
                    }
                }

                return ret.length === 0 ? null : ret;
            }
        },
        TAG: function(match, context){
            return context.getElementsByTagName(match[1]);
        }
    },
    preFilter: {
        CLASS: function(match, curLoop, inplace, result, not, isXML){
            match = " " + match[1].replace(/\\/g, "") + " ";

            if ( isXML ) {
                return match;
            }

            for ( var i = 0, elem; (elem = curLoop[i]) != null; i++ ) {
                if ( elem ) {
                    if ( not ^ (elem.className && (" " + elem.className + " ").indexOf(match) >= 0) ) {
                        if ( !inplace )
                            result.push( elem );
                    } else if ( inplace ) {
                        curLoop[i] = false;
                    }
                }
            }

            return false;
        },
        ID: function(match){
            return match[1].replace(/\\/g, "");
        },
        TAG: function(match, curLoop){
            for ( var i = 0; curLoop[i] === false; i++ ){}
            return curLoop[i] && isXML(curLoop[i]) ? match[1] : match[1].toUpperCase();
        },
        CHILD: function(match){
            if ( match[1] == "nth" ) {
                var test = /(-?)(\d*)n((?:\+|-)?\d*)/.exec(
                    match[2] == "even" && "2n" || match[2] == "odd" && "2n+1" ||
                    !/\D/.test( match[2] ) && "0n+" + match[2] || match[2]);

                match[2] = (test[1] + (test[2] || 1)) - 0;
                match[3] = test[3] - 0;
            }

            match[0] = done++;

            return match;
        },
        ATTR: function(match, curLoop, inplace, result, not, isXML){
            var name = match[1].replace(/\\/g, "");

            if ( !isXML && Expr.attrMap[name] ) {
                match[1] = Expr.attrMap[name];
            }

            if ( match[2] === "~=" ) {
                match[4] = " " + match[4] + " ";
            }

            return match;
        },
        PSEUDO: function(match, curLoop, inplace, result, not){
            if ( match[1] === "not" ) {
                if ( ( chunker.exec(match[3]) || "" ).length > 1 || /^\w/.test(match[3]) ) {
                    match[3] = Sizzle(match[3], null, null, curLoop);
                } else {
                    var ret = Sizzle.filter(match[3], curLoop, inplace, true ^ not);
                    if ( !inplace ) {
                        result.push.apply( result, ret );
                    }
                    return false;
                }
            } else if ( Expr.match.POS.test( match[0] ) || Expr.match.CHILD.test( match[0] ) ) {
                return true;
            }

            return match;
        },
        POS: function(match){
            match.unshift( true );
            return match;
        }
    },
    filters: {
        enabled: function(elem){
            return elem.disabled === false && elem.type !== "hidden";
        },
        disabled: function(elem){
            return elem.disabled === true;
        },
        checked: function(elem){
            return elem.checked === true;
        },
        selected: function(elem){
            elem.parentNode.selectedIndex;
            return elem.selected === true;
        },
        parent: function(elem){
            return !!elem.firstChild;
        },
        empty: function(elem){
            return !elem.firstChild;
        },
        has: function(elem, i, match){
            return !!Sizzle( match[3], elem ).length;
        },
        header: function(elem){
            return /h\d/i.test( elem.nodeName );
        },
        text: function(elem){
            return "text" === elem.type;
        },
        radio: function(elem){
            return "radio" === elem.type;
        },
        checkbox: function(elem){
            return "checkbox" === elem.type;
        },
        file: function(elem){
            return "file" === elem.type;
        },
        password: function(elem){
            return "password" === elem.type;
        },
        submit: function(elem){
            return "submit" === elem.type;
        },
        image: function(elem){
            return "image" === elem.type;
        },
        reset: function(elem){
            return "reset" === elem.type;
        },
        button: function(elem){
            return "button" === elem.type || elem.nodeName.toUpperCase() === "BUTTON";
        },
        input: function(elem){
            return /input|select|textarea|button/i.test(elem.nodeName);
        }
    },
    setFilters: {
        first: function(elem, i){
            return i === 0;
        },
        last: function(elem, i, match, array){
            return i === array.length - 1;
        },
        even: function(elem, i){
            return i % 2 === 0;
        },
        odd: function(elem, i){
            return i % 2 === 1;
        },
        lt: function(elem, i, match){
            return i < match[3] - 0;
        },
        gt: function(elem, i, match){
            return i > match[3] - 0;
        },
        nth: function(elem, i, match){
            return match[3] - 0 == i;
        },
        eq: function(elem, i, match){
            return match[3] - 0 == i;
        }
    },
    filter: {
        PSEUDO: function(elem, match, i, array){
            var name = match[1], filter = Expr.filters[ name ];

            if ( filter ) {
                return filter( elem, i, match, array );
            } else if ( name === "contains" ) {
                return (elem.textContent || elem.innerText || "").indexOf(match[3]) >= 0;
            } else if ( name === "not" ) {
                var not = match[3];

                for ( var i = 0, l = not.length; i < l; i++ ) {
                    if ( not[i] === elem ) {
                        return false;
                    }
                }

                return true;
            }
        },
        CHILD: function(elem, match){
            var type = match[1], node = elem;
            switch (type) {
                case 'only':
                case 'first':
                    while ( (node = node.previousSibling) )  {
                        if ( node.nodeType === 1 ) return false;
                    }
                    if ( type == 'first') return true;
                    node = elem;
                case 'last':
                    while ( (node = node.nextSibling) )  {
                        if ( node.nodeType === 1 ) return false;
                    }
                    return true;
                case 'nth':
                    var first = match[2], last = match[3];

                    if ( first == 1 && last == 0 ) {
                        return true;
                    }

                    var doneName = match[0],
                        parent = elem.parentNode;

                    if ( parent && (parent.sizcache !== doneName || !elem.nodeIndex) ) {
                        var count = 0;
                        for ( node = parent.firstChild; node; node = node.nextSibling ) {
                            if ( node.nodeType === 1 ) {
                                node.nodeIndex = ++count;
                            }
                        }
                        parent.sizcache = doneName;
                    }

                    var diff = elem.nodeIndex - last;
                    if ( first == 0 ) {
                        return diff == 0;
                    } else {
                        return ( diff % first == 0 && diff / first >= 0 );
                    }
            }
        },
        ID: function(elem, match){
            return elem.nodeType === 1 && elem.getAttribute("id") === match;
        },
        TAG: function(elem, match){
            return (match === "*" && elem.nodeType === 1) || elem.nodeName === match;
        },
        CLASS: function(elem, match){
            return (" " + (elem.className || elem.getAttribute("class")) + " ")
                .indexOf( match ) > -1;
        },
        ATTR: function(elem, match){
            var name = match[1],
                result = Expr.attrHandle[ name ] ?
                    Expr.attrHandle[ name ]( elem ) :
                    elem[ name ] != null ?
                        elem[ name ] :
                        elem.getAttribute( name ),
                value = result + "",
                type = match[2],
                check = match[4];

            return result == null ?
                type === "!=" :
                type === "=" ?
                value === check :
                type === "*=" ?
                value.indexOf(check) >= 0 :
                type === "~=" ?
                (" " + value + " ").indexOf(check) >= 0 :
                !check ?
                value && result !== false :
                type === "!=" ?
                value != check :
                type === "^=" ?
                value.indexOf(check) === 0 :
                type === "$=" ?
                value.substr(value.length - check.length) === check :
                type === "|=" ?
                value === check || value.substr(0, check.length + 1) === check + "-" :
                false;
        },
        POS: function(elem, match, i, array){
            var name = match[2], filter = Expr.setFilters[ name ];

            if ( filter ) {
                return filter( elem, i, match, array );
            }
        }
    }
};

var origPOS = Expr.match.POS;

for ( var type in Expr.match ) {
    Expr.match[ type ] = new RegExp( Expr.match[ type ].source + /(?![^\[]*\])(?![^\(]*\))/.source );
    Expr.leftMatch[ type ] = new RegExp( /(^(?:.|\r|\n)*?)/.source + Expr.match[ type ].source );
}

var makeArray = function(array, results) {
    array = Array.prototype.slice.call( array, 0 );

    if ( results ) {
        results.push.apply( results, array );
        return results;
    }

    return array;
};

try {
    Array.prototype.slice.call( document.documentElement.childNodes, 0 );

} catch(e){
    makeArray = function(array, results) {
        var ret = results || [];

        if ( toString.call(array) === "[object Array]" ) {
            Array.prototype.push.apply( ret, array );
        } else {
            if ( typeof array.length === "number" ) {
                for ( var i = 0, l = array.length; i < l; i++ ) {
                    ret.push( array[i] );
                }
            } else {
                for ( var i = 0; array[i]; i++ ) {
                    ret.push( array[i] );
                }
            }
        }

        return ret;
    };
}

var sortOrder;

if ( document.documentElement.compareDocumentPosition ) {
    sortOrder = function( a, b ) {
        if ( !a.compareDocumentPosition || !b.compareDocumentPosition ) {
            if ( a == b ) {
                hasDuplicate = true;
            }
            return 0;
        }

        var ret = a.compareDocumentPosition(b) & 4 ? -1 : a === b ? 0 : 1;
        if ( ret === 0 ) {
            hasDuplicate = true;
        }
        return ret;
    };
} else if ( "sourceIndex" in document.documentElement ) {
    sortOrder = function( a, b ) {
        if ( !a.sourceIndex || !b.sourceIndex ) {
            if ( a == b ) {
                hasDuplicate = true;
            }
            return 0;
        }

        var ret = a.sourceIndex - b.sourceIndex;
        if ( ret === 0 ) {
            hasDuplicate = true;
        }
        return ret;
    };
} else if ( document.createRange ) {
    sortOrder = function( a, b ) {
        if ( !a.ownerDocument || !b.ownerDocument ) {
            if ( a == b ) {
                hasDuplicate = true;
            }
            return 0;
        }

        var aRange = a.ownerDocument.createRange(), bRange = b.ownerDocument.createRange();
        aRange.setStart(a, 0);
        aRange.setEnd(a, 0);
        bRange.setStart(b, 0);
        bRange.setEnd(b, 0);
        var ret = aRange.compareBoundaryPoints(Range.START_TO_END, bRange);
        if ( ret === 0 ) {
            hasDuplicate = true;
        }
        return ret;
    };
}

(function(){
    var form = document.createElement("div"),
        id = "script" + (new Date).getTime();
    form.innerHTML = "<a name='" + id + "'/>";

    var root = document.documentElement;
    root.insertBefore( form, root.firstChild );

    if ( !!document.getElementById( id ) ) {
        Expr.find.ID = function(match, context, isXML){
            if ( typeof context.getElementById !== "undefined" && !isXML ) {
                var m = context.getElementById(match[1]);
                return m ? m.id === match[1] || typeof m.getAttributeNode !== "undefined" && m.getAttributeNode("id").nodeValue === match[1] ? [m] : undefined : [];
            }
        };

        Expr.filter.ID = function(elem, match){
            var node = typeof elem.getAttributeNode !== "undefined" && elem.getAttributeNode("id");
            return elem.nodeType === 1 && node && node.nodeValue === match;
        };
    }

    root.removeChild( form );
    root = form = null; // release memory in IE
})();

(function(){

    var div = document.createElement("div");
    div.appendChild( document.createComment("") );

    if ( div.getElementsByTagName("*").length > 0 ) {
        Expr.find.TAG = function(match, context){
            var results = context.getElementsByTagName(match[1]);

            if ( match[1] === "*" ) {
                var tmp = [];

                for ( var i = 0; results[i]; i++ ) {
                    if ( results[i].nodeType === 1 ) {
                        tmp.push( results[i] );
                    }
                }

                results = tmp;
            }

            return results;
        };
    }

    div.innerHTML = "<a href='#'></a>";
    if ( div.firstChild && typeof div.firstChild.getAttribute !== "undefined" &&
            div.firstChild.getAttribute("href") !== "#" ) {
        Expr.attrHandle.href = function(elem){
            return elem.getAttribute("href", 2);
        };
    }

    div = null; // release memory in IE
})();

if ( document.querySelectorAll ) (function(){
    var oldSizzle = Sizzle, div = document.createElement("div");
    div.innerHTML = "<p class='TEST'></p>";

    if ( div.querySelectorAll && div.querySelectorAll(".TEST").length === 0 ) {
        return;
    }

    Sizzle = function(query, context, extra, seed){
        context = context || document;

        if ( !seed && context.nodeType === 9 && !isXML(context) ) {
            try {
                return makeArray( context.querySelectorAll(query), extra );
            } catch(e){}
        }

        return oldSizzle(query, context, extra, seed);
    };

    for ( var prop in oldSizzle ) {
        Sizzle[ prop ] = oldSizzle[ prop ];
    }

    div = null; // release memory in IE
})();

if ( document.getElementsByClassName && document.documentElement.getElementsByClassName ) (function(){
    var div = document.createElement("div");
    div.innerHTML = "<div class='test e'></div><div class='test'></div>";

    if ( div.getElementsByClassName("e").length === 0 )
        return;

    div.lastChild.className = "e";

    if ( div.getElementsByClassName("e").length === 1 )
        return;

    Expr.order.splice(1, 0, "CLASS");
    Expr.find.CLASS = function(match, context, isXML) {
        if ( typeof context.getElementsByClassName !== "undefined" && !isXML ) {
            return context.getElementsByClassName(match[1]);
        }
    };

    div = null; // release memory in IE
})();

function dirNodeCheck( dir, cur, doneName, checkSet, nodeCheck, isXML ) {
    var sibDir = dir == "previousSibling" && !isXML;
    for ( var i = 0, l = checkSet.length; i < l; i++ ) {
        var elem = checkSet[i];
        if ( elem ) {
            if ( sibDir && elem.nodeType === 1 ){
                elem.sizcache = doneName;
                elem.sizset = i;
            }
            elem = elem[dir];
            var match = false;

            while ( elem ) {
                if ( elem.sizcache === doneName ) {
                    match = checkSet[elem.sizset];
                    break;
                }

                if ( elem.nodeType === 1 && !isXML ){
                    elem.sizcache = doneName;
                    elem.sizset = i;
                }

                if ( elem.nodeName === cur ) {
                    match = elem;
                    break;
                }

                elem = elem[dir];
            }

            checkSet[i] = match;
        }
    }
}

function dirCheck( dir, cur, doneName, checkSet, nodeCheck, isXML ) {
    var sibDir = dir == "previousSibling" && !isXML;
    for ( var i = 0, l = checkSet.length; i < l; i++ ) {
        var elem = checkSet[i];
        if ( elem ) {
            if ( sibDir && elem.nodeType === 1 ) {
                elem.sizcache = doneName;
                elem.sizset = i;
            }
            elem = elem[dir];
            var match = false;

            while ( elem ) {
                if ( elem.sizcache === doneName ) {
                    match = checkSet[elem.sizset];
                    break;
                }

                if ( elem.nodeType === 1 ) {
                    if ( !isXML ) {
                        elem.sizcache = doneName;
                        elem.sizset = i;
                    }
                    if ( typeof cur !== "string" ) {
                        if ( elem === cur ) {
                            match = true;
                            break;
                        }

                    } else if ( Sizzle.filter( cur, [elem] ).length > 0 ) {
                        match = elem;
                        break;
                    }
                }

                elem = elem[dir];
            }

            checkSet[i] = match;
        }
    }
}

var contains = document.compareDocumentPosition ?  function(a, b){
    return a.compareDocumentPosition(b) & 16;
} : function(a, b){
    return a !== b && (a.contains ? a.contains(b) : true);
};

var isXML = function(elem){
    return elem.nodeType === 9 && elem.documentElement.nodeName !== "HTML" ||
        !!elem.ownerDocument && elem.ownerDocument.documentElement.nodeName !== "HTML";
};

var posProcess = function(selector, context){
    var tmpSet = [], later = "", match,
        root = context.nodeType ? [context] : context;

    while ( (match = Expr.match.PSEUDO.exec( selector )) ) {
        later += match[0];
        selector = selector.replace( Expr.match.PSEUDO, "" );
    }

    selector = Expr.relative[selector] ? selector + "*" : selector;

    for ( var i = 0, l = root.length; i < l; i++ ) {
        Sizzle( selector, root[i], tmpSet );
    }

    return Sizzle.filter( later, tmpSet );
};


window.Sizzle = Sizzle;

})();

;(function(engine) {
  var extendElements = Prototype.Selector.extendElements;

  function select(selector, scope) {
    return extendElements(engine(selector, scope || document));
  }

  function match(element, selector) {
    return engine.matches(selector, [element]).length == 1;
  }

  Prototype.Selector.engine = engine;
  Prototype.Selector.select = select;
  Prototype.Selector.match = match;
})(Sizzle);

window.Sizzle = Prototype._original_property;
delete Prototype._original_property;

var Form = {
  reset: function(form) {
    form = $(form);
    form.reset();
    return form;
  },

  serializeElements: function(elements, options) {
    if (typeof options != 'object') options = { hash: !!options };
    else if (Object.isUndefined(options.hash)) options.hash = true;
    var key, value, submitted = false, submit = options.submit, accumulator, initial;

    if (options.hash) {
      initial = {};
      accumulator = function(result, key, value) {
        if (key in result) {
          if (!Object.isArray(result[key])) result[key] = [result[key]];
          result[key].push(value);
        } else result[key] = value;
        return result;
      };
    } else {
      initial = '';
      accumulator = function(result, key, value) {
        return result + (result ? '&' : '') + encodeURIComponent(key) + '=' + encodeURIComponent(value);
      }
    }

    return elements.inject(initial, function(result, element) {
      if (!element.disabled && element.name) {
        key = element.name; value = $(element).getValue();
        if (value != null && element.type != 'file' && (element.type != 'submit' || (!submitted &&
            submit !== false && (!submit || key == submit) && (submitted = true)))) {
          result = accumulator(result, key, value);
        }
      }
      return result;
    });
  }
};

Form.Methods = {
  serialize: function(form, options) {
    return Form.serializeElements(Form.getElements(form), options);
  },

  getElements: function(form) {
    var elements = $(form).getElementsByTagName('*'),
        element,
        arr = [ ],
        serializers = Form.Element.Serializers;
    for (var i = 0; element = elements[i]; i++) {
      arr.push(element);
    }
    return arr.inject([], function(elements, child) {
      if (serializers[child.tagName.toLowerCase()])
        elements.push(Element.extend(child));
      return elements;
    })
  },

  getInputs: function(form, typeName, name) {
    form = $(form);
    var inputs = form.getElementsByTagName('input');

    if (!typeName && !name) return $A(inputs).map(Element.extend);

    for (var i = 0, matchingInputs = [], length = inputs.length; i < length; i++) {
      var input = inputs[i];
      if ((typeName && input.type != typeName) || (name && input.name != name))
        continue;
      matchingInputs.push(Element.extend(input));
    }

    return matchingInputs;
  },

  disable: function(form) {
    form = $(form);
    Form.getElements(form).invoke('disable');
    return form;
  },

  enable: function(form) {
    form = $(form);
    Form.getElements(form).invoke('enable');
    return form;
  },

  findFirstElement: function(form) {
    var elements = $(form).getElements().findAll(function(element) {
      return 'hidden' != element.type && !element.disabled;
    });
    var firstByIndex = elements.findAll(function(element) {
      return element.hasAttribute('tabIndex') && element.tabIndex >= 0;
    }).sortBy(function(element) { return element.tabIndex }).first();

    return firstByIndex ? firstByIndex : elements.find(function(element) {
      return /^(?:input|select|textarea)$/i.test(element.tagName);
    });
  },

  focusFirstElement: function(form) {
    form = $(form);
    var element = form.findFirstElement();
    if (element) element.activate();
    return form;
  },

  request: function(form, options) {
    form = $(form), options = Object.clone(options || { });

    var params = options.parameters, action = form.readAttribute('action') || '';
    if (action.blank()) action = window.location.href;
    options.parameters = form.serialize(true);

    if (params) {
      if (Object.isString(params)) params = params.toQueryParams();
      Object.extend(options.parameters, params);
    }

    if (form.hasAttribute('method') && !options.method)
      options.method = form.method;

    return new Ajax.Request(action, options);
  }
};

/*--------------------------------------------------------------------------*/


Form.Element = {
  focus: function(element) {
    $(element).focus();
    return element;
  },

  select: function(element) {
    $(element).select();
    return element;
  }
};

Form.Element.Methods = {

  serialize: function(element) {
    element = $(element);
    if (!element.disabled && element.name) {
      var value = element.getValue();
      if (value != undefined) {
        var pair = { };
        pair[element.name] = value;
        return Object.toQueryString(pair);
      }
    }
    return '';
  },

  getValue: function(element) {
    element = $(element);
    var method = element.tagName.toLowerCase();
    return Form.Element.Serializers[method](element);
  },

  setValue: function(element, value) {
    element = $(element);
    var method = element.tagName.toLowerCase();
    Form.Element.Serializers[method](element, value);
    return element;
  },

  clear: function(element) {
    $(element).value = '';
    return element;
  },

  present: function(element) {
    return $(element).value != '';
  },

  activate: function(element) {
    element = $(element);
    try {
      element.focus();
      if (element.select && (element.tagName.toLowerCase() != 'input' ||
          !(/^(?:button|reset|submit)$/i.test(element.type))))
        element.select();
    } catch (e) { }
    return element;
  },

  disable: function(element) {
    element = $(element);
    element.disabled = true;
    // to disable delete buttons on uploaded files in file upload widget
    if (element.type === 'file') {
      var deleteUploadBtns = $$('#' + element.closest('li').id + ' .qq-upload-delete');
      deleteUploadBtns.each(function (btn) {
          btn.style.visibility = 'hidden';
      });
    }
    return element;
  },

  enable: function(element) {
    element = $(element);
    element.disabled = false;
    // to enable delete buttons on uploaded files in file upload widget
    if (element.type === 'file') {
      var deleteUploadBtns = $$('#' + element.closest('li').id + ' .qq-upload-delete');
      deleteUploadBtns.each(function (btn) {
          btn.style.visibility = '';
      });
    }
    return element;
  }
};

/*--------------------------------------------------------------------------*/

var Field = Form.Element;

var $F = Form.Element.Methods.getValue;

/*--------------------------------------------------------------------------*/

Form.Element.Serializers = (function() {
  function input(element, value) {
    switch (element.type.toLowerCase()) {
      case 'checkbox':
      case 'radio':
        return inputSelector(element, value);
      default:
        return valueSelector(element, value);
    }
  }

  function inputSelector(element, value) {
    if (Object.isUndefined(value))
      return element.checked ? element.value : null;
    else element.checked = !!value;
  }

  function valueSelector(element, value) {
    if (Object.isUndefined(value)) return element.value;
    else element.value = value;
  }

  function select(element, value) {
    if (Object.isUndefined(value))
      return (element.type === 'select-one' ? selectOne : selectMany)(element);

    var opt, currentValue, single = !Object.isArray(value);
    for (var i = 0, length = element.length; i < length; i++) {
      opt = element.options[i];
      currentValue = this.optionValue(opt);
      if (single) {
        if (currentValue == value) {
          opt.selected = true;
          return;
        }
      }
      else opt.selected = value.include(currentValue);
    }
  }

  function selectOne(element) {
    var index = element.selectedIndex;
    return index >= 0 ? optionValue(element.options[index]) : null;
  }

  function selectMany(element) {
    var values, length = element.length;
    if (!length) return null;

    for (var i = 0, values = []; i < length; i++) {
      var opt = element.options[i];
      if (opt.selected) values.push(optionValue(opt));
    }
    return values;
  }

  function optionValue(opt) {
    return Element.hasAttribute(opt, 'value') ? opt.value : opt.text;
  }

  return {
    input:         input,
    inputSelector: inputSelector,
    textarea:      valueSelector,
    select:        select,
    selectOne:     selectOne,
    selectMany:    selectMany,
    optionValue:   optionValue,
    button:        valueSelector
  };
})();

/*--------------------------------------------------------------------------*/


Abstract.TimedObserver = Class.create(PeriodicalExecuter, {
  initialize: function($super, element, frequency, callback) {
    $super(callback, frequency);
    this.element   = $(element);
    this.lastValue = this.getValue();
  },

  execute: function() {
    var value = this.getValue();
    if (Object.isString(this.lastValue) && Object.isString(value) ?
        this.lastValue != value : String(this.lastValue) != String(value)) {
      this.callback(this.element, value);
      this.lastValue = value;
    }
  }
});

Form.Element.Observer = Class.create(Abstract.TimedObserver, {
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.Observer = Class.create(Abstract.TimedObserver, {
  getValue: function() {
    return Form.serialize(this.element);
  }
});

/*--------------------------------------------------------------------------*/

Abstract.EventObserver = Class.create({
  initialize: function(element, callback) {
    this.element  = $(element);
    this.callback = callback;

    this.lastValue = this.getValue();
    if (this.element.tagName.toLowerCase() == 'form')
      this.registerFormCallbacks();
    else
      this.registerCallback(this.element);
  },

  onElementEvent: function() {
    var value = this.getValue();
    if (this.lastValue != value) {
      this.callback(this.element, value);
      this.lastValue = value;
    }
  },

  registerFormCallbacks: function() {
    Form.getElements(this.element).each(this.registerCallback, this);
  },

  registerCallback: function(element) {
    if (element.type) {
      switch (element.type.toLowerCase()) {
        case 'checkbox':
        case 'radio':
          Event.observe(element, 'click', this.onElementEvent.bind(this));
          break;
        default:
          Event.observe(element, 'change', this.onElementEvent.bind(this));
          break;
      }
    }
  }
});

Form.Element.EventObserver = Class.create(Abstract.EventObserver, {
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.EventObserver = Class.create(Abstract.EventObserver, {
  getValue: function() {
    return Form.serialize(this.element);
  }
});
(function() {

  var Event = {
    KEY_BACKSPACE: 8,
    KEY_TAB:       9,
    KEY_RETURN:   13,
    KEY_ESC:      27,
    KEY_LEFT:     37,
    KEY_UP:       38,
    KEY_RIGHT:    39,
    KEY_DOWN:     40,
    KEY_DELETE:   46,
    KEY_HOME:     36,
    KEY_END:      35,
    KEY_PAGEUP:   33,
    KEY_PAGEDOWN: 34,
    KEY_INSERT:   45,

    cache: {}
  };

  var docEl = document.documentElement;
  var MOUSEENTER_MOUSELEAVE_EVENTS_SUPPORTED = 'onmouseenter' in docEl
    && 'onmouseleave' in docEl;



  var isIELegacyEvent = function(event) { return false; };

  if (window.attachEvent) {
    if (window.addEventListener) {
      isIELegacyEvent = function(event) {
        return !(event instanceof window.Event);
      };
    } else {
      isIELegacyEvent = function(event) { return true; };
    }
  }

  var _isButton;

  function _isButtonForDOMEvents(event, code) {
    return event.which ? (event.which === code + 1) : (event.button === code);
  }

  var legacyButtonMap = { 0: 1, 1: 4, 2: 2 };
  function _isButtonForLegacyEvents(event, code) {
    return event.button === legacyButtonMap[code];
  }

  function _isButtonForWebKit(event, code) {
    switch (code) {
      case 0: return event.which == 1 && !event.metaKey;
      case 1: return event.which == 2 || (event.which == 1 && event.metaKey);
      case 2: return event.which == 3;
      default: return false;
    }
  }

  if (window.attachEvent) {
    if (!window.addEventListener) {
      _isButton = _isButtonForLegacyEvents;
    } else {
      _isButton = function(event, code) {
        return isIELegacyEvent(event) ? _isButtonForLegacyEvents(event, code) :
         _isButtonForDOMEvents(event, code);
      }
    }
  } else if (Prototype.Browser.WebKit) {
    _isButton = _isButtonForWebKit;
  } else {
    _isButton = _isButtonForDOMEvents;
  }

  function isLeftClick(event)   { return _isButton(event, 0) }

  function isMiddleClick(event) { return _isButton(event, 1) }

  function isRightClick(event)  { return _isButton(event, 2) }

  function element(event) {
    event = Event.extend(event);

    var node = event.target, type = event.type,
     currentTarget = event.currentTarget;

    if (currentTarget && currentTarget.tagName) {
      if (type === 'load' || type === 'error' ||
        (type === 'click' && currentTarget.tagName.toLowerCase() === 'input'
          && currentTarget.type === 'radio'))
            node = currentTarget;
    }

    if (node.nodeType == Node.TEXT_NODE)
      node = node.parentNode;

    return Element.extend(node);
  }

  function findElement(event, expression) {
    var element = Event.element(event);

    if (!expression) return element;
    while (element) {
      if (Object.isElement(element) && Prototype.Selector.match(element, expression)) {
        return Element.extend(element);
      }
      element = element.parentNode;
    }
  }

  function pointer(event) {
    return { x: pointerX(event), y: pointerY(event) };
  }

  function pointerX(event) {
    var docElement = document.documentElement,
     body = document.body || { scrollLeft: 0 };
    
    // JotForm Touch events fix  
    if (('createTouch' in document) && event.touches) {
      if (event.touches[0]) { return event.touches[0].pageX; } 
      else { return event.pageX; }
    }

    return event.pageX || (event.clientX +
      (docElement.scrollLeft || body.scrollLeft) -
      (docElement.clientLeft || 0));
  }

  function pointerY(event) {
    var docElement = document.documentElement,
     body = document.body || { scrollTop: 0 };
     if (('createTouch' in document) && event.touches) {
       if (event.touches[0]) { return event.touches[0].pageY; } 
       else { return event.pageY; }
     }

    return  event.pageY || (event.clientY +
       (docElement.scrollTop || body.scrollTop) -
       (docElement.clientTop || 0));
  }


  function stop(event) {
    Event.extend(event);
    event.preventDefault();
    event.stopPropagation();

    event.stopped = true;
  }


  Event.Methods = {
    isLeftClick:   isLeftClick,
    isMiddleClick: isMiddleClick,
    isRightClick:  isRightClick,

    element:     element,
    findElement: findElement,

    pointer:  pointer,
    pointerX: pointerX,
    pointerY: pointerY,

    stop: stop
  };

  var methods = Object.keys(Event.Methods).inject({ }, function(m, name) {
    m[name] = Event.Methods[name].methodize();
    return m;
  });

  if (window.attachEvent) {
    function _relatedTarget(event) {
      var element;
      switch (event.type) {
        case 'mouseover':
        case 'mouseenter':
          element = event.fromElement;
          break;
        case 'mouseout':
        case 'mouseleave':
          element = event.toElement;
          break;
        default:
          return null;
      }
      return Element.extend(element);
    }

    var additionalMethods = {
      stopPropagation: function() { this.cancelBubble = true },
      preventDefault:  function() { this.returnValue = false },
      inspect: function() { return '[object Event]' }
    };

    Event.extend = function(event, element) {
      if (!event) return false;

      if (!isIELegacyEvent(event)) return event;

      if (event._extendedByPrototype) return event;
      event._extendedByPrototype = Prototype.emptyFunction;

      var pointer = Event.pointer(event);

      Object.extend(event, {
        target: event.srcElement || element,
        relatedTarget: _relatedTarget(event),
        pageX:  pointer.x,
        pageY:  pointer.y
      });

      Object.extend(event, methods);
      Object.extend(event, additionalMethods);

      return event;
    };
  } else {
    Event.extend = Prototype.K;
  }

  if (window.addEventListener) {
    Event.prototype = window.Event.prototype || document.createEvent('HTMLEvents').__proto__;
    Object.extend(Event.prototype, methods);
  }

  function _createResponder(element, eventName, handler) {
    var registry = Element.retrieve(element, 'prototype_event_registry');

    if (Object.isUndefined(registry)) {
      CACHE.push(element);
      registry = Element.retrieve(element, 'prototype_event_registry', $H());
    }

    var respondersForEvent;
	try{
    respondersForEvent = registry.get(eventName);
    }catch(e){return false;}
    if (Object.isUndefined(respondersForEvent)) {
      respondersForEvent = [];
      registry.set(eventName, respondersForEvent);
    }

    if (respondersForEvent.pluck('handler').include(handler)) return false;

    var responder;
    if (eventName.include(":")) {
      responder = function(event) {
        if (Object.isUndefined(event.eventName))
          return false;

        if (event.eventName !== eventName)
          return false;

        Event.extend(event, element);
        if (handler) handler.call(element, event);
      };
    } else {
      if (!MOUSEENTER_MOUSELEAVE_EVENTS_SUPPORTED &&
       (eventName === "mouseenter" || eventName === "mouseleave")) {
        if (eventName === "mouseenter" || eventName === "mouseleave") {
          responder = function(event) {
            Event.extend(event, element);

            var parent = event.relatedTarget;
            while (parent && parent !== element) {
              try { parent = parent.parentNode; }
              catch(e) { parent = element; }
            }

            if (parent === element) return;

            handler.call(element, event);
          };
        }
      } else {
        responder = function(event) {
          Event.extend(event, element);
          handler.call(element, event);
        };
      }
    }

    responder.handler = handler;
    respondersForEvent.push(responder);
    return responder;
  }

  function _destroyCache() {
    for (var i = 0, length = CACHE.length; i < length; i++) {
      Event.stopObserving(CACHE[i]);
      CACHE[i] = null;
    }
  }

  var CACHE = [];

  if (Prototype.Browser.IE)
    window.attachEvent('onunload', _destroyCache);

  if (Prototype.Browser.WebKit)
    window.addEventListener('unload', Prototype.emptyFunction, false);


  var _getDOMEventName = Prototype.K,
      translations = { mouseenter: "mouseover", mouseleave: "mouseout" };

  if (!MOUSEENTER_MOUSELEAVE_EVENTS_SUPPORTED) {
    _getDOMEventName = function(eventName) {
      return (translations[eventName] || eventName);
    };
  }

  function observe(element, eventName, handler) {
    element = $(element);

    var responder = _createResponder(element, eventName, handler);

    if (!responder) return element;

    if (eventName.include(':')) {
      if (element.addEventListener)
        element.addEventListener("dataavailable", responder, false);
      else {
        element.attachEvent("ondataavailable", responder);
        element.attachEvent("onlosecapture", responder);
      }
    } else {
      var actualEventName = _getDOMEventName(eventName);

      if (element.addEventListener)
        element.addEventListener(actualEventName, responder, false);
      else
        element.attachEvent("on" + actualEventName, responder);
    }

    return element;
  }

  function stopObserving(element, eventName, handler) {
    element = $(element);

    var registry = Element.retrieve(element, 'prototype_event_registry');
    if (!registry) return element;

    if (!eventName) {
      try{
        registry.each( function(pair) {
          var eventName = pair.key;
          stopObserving(element, eventName);
        });
        return element;

      }catch(err){
        //donothing
        return element;
      }
    }

    var responders = registry.get(eventName);
    if (!responders) return element;

    if (!handler) {
      responders.each(function(r) {
        stopObserving(element, eventName, r.handler);
      });
      return element;
    }

    var i = responders.length, responder;
    while (i--) {
      if (responders[i].handler === handler) {
        responder = responders[i];
        break;
      }
    }
    if (!responder) return element;

    if (eventName.include(':')) {
      if (element.removeEventListener)
        element.removeEventListener("dataavailable", responder, false);
      else {
        element.detachEvent("ondataavailable", responder);
        element.detachEvent("onlosecapture", responder);
      }
    } else {
      var actualEventName = _getDOMEventName(eventName);
      if (element.removeEventListener)
        element.removeEventListener(actualEventName, responder, false);
      else
        element.detachEvent('on' + actualEventName, responder);
    }

    registry.set(eventName, responders.without(responder));

    return element;
  }

  function fire(element, eventName, memo, bubble) {
    element = $(element);

    if (Object.isUndefined(bubble))
      bubble = true;

    if (element == document && document.createEvent && !element.dispatchEvent)
      element = document.documentElement;

    var event;
    if (document.createEvent) {
      event = document.createEvent('HTMLEvents');
      event.initEvent('dataavailable', bubble, true);
    } else {
      event = document.createEventObject();
      event.eventType = bubble ? 'ondataavailable' : 'onlosecapture';
    }

    event.eventName = eventName;
    event.memo = memo || { };

    if (document.createEvent)
      element.dispatchEvent(event);
    else
      element.fireEvent(event.eventType, event);

    return Event.extend(event);
  }

  Event.Handler = Class.create({
    initialize: function(element, eventName, selector, callback) {
      this.element   = $(element);
      this.eventName = eventName;
      this.selector  = selector;
      this.callback  = callback;
      this.handler   = this.handleEvent.bind(this);
    },

    start: function() {
      Event.observe(this.element, this.eventName, this.handler);
      return this;
    },

    stop: function() {
      Event.stopObserving(this.element, this.eventName, this.handler);
      return this;
    },

    handleEvent: function(event) {
      var element = Event.findElement(event, this.selector);
      if (element) this.callback.call(this.element, event, element);
    }
  });

  function on(element, eventName, selector, callback) {
    element = $(element);
    if (Object.isFunction(selector) && Object.isUndefined(callback)) {
      callback = selector, selector = null;
    }

    return new Event.Handler(element, eventName, selector, callback).start();
  }

  Object.extend(Event, Event.Methods);

  Object.extend(Event, {
    fire:          fire,
    observe:       observe,
    stopObserving: stopObserving,
    on:            on
  });

  Element.addMethods({
    fire:          fire,

    observe:       observe,

    stopObserving: stopObserving,

    on:            on
  });

  Object.extend(document, {
    fire:          fire.methodize(),

    observe:       observe.methodize(),

    stopObserving: stopObserving.methodize(),

    on:            on.methodize(),

    loaded:        false
  });

  if (window.Event) Object.extend(window.Event, Event);
  else window.Event = Event;
})();

(function() {
  /* Support for the DOMContentLoaded event is based on work by Dan Webb,
     Matthias Miller, Dean Edwards, John Resig, and Diego Perini. */

  var timer;

  function fireContentLoadedEvent() {
    if (document.loaded) return;
    if (timer) window.clearTimeout(timer);
    document.loaded = true;
    document.fire('dom:loaded');
  }

  function checkReadyState() {
    if (document.readyState === 'complete') {
      document.stopObserving('readystatechange', checkReadyState);
      fireContentLoadedEvent();
    }
  }

  function pollDoScroll() {
    try { document.documentElement.doScroll('left'); }
    catch(e) {
      timer = pollDoScroll.p_defer();
      return;
    }
    fireContentLoadedEvent();
  }

  if (document.addEventListener) {
    document.addEventListener('DOMContentLoaded', fireContentLoadedEvent, false);
  } else {
    document.observe('readystatechange', checkReadyState);
    if (window == top)
      timer = pollDoScroll.p_defer();
  }

  Event.observe(window, 'load', fireContentLoadedEvent);
})();

Element.addMethods();

/*------------------------------- DEPRECATED -------------------------------*/

Hash.toQueryString = Object.toQueryString;

var Toggle = { display: Element.toggle };

Element.Methods.childOf = Element.Methods.descendantOf;

var Insertion = {
  Before: function(element, content) {
    return Element.insert(element, {before:content});
  },

  Top: function(element, content) {
    return Element.insert(element, {top:content});
  },

  Bottom: function(element, content) {
    return Element.insert(element, {bottom:content});
  },

  After: function(element, content) {
    return Element.insert(element, {after:content});
  }
};

var $continue = new Error('"throw $continue" is deprecated, use "return" instead');

var Position = {
  includeScrollOffsets: false,

  prepare: function() {
    this.deltaX =  window.pageXOffset
                || document.documentElement.scrollLeft
                || document.body.scrollLeft
                || 0;
    this.deltaY =  window.pageYOffset
                || document.documentElement.scrollTop
                || document.body.scrollTop
                || 0;
  },

  within: function(element, x, y) {
    if (this.includeScrollOffsets)
      return this.withinIncludingScrolloffsets(element, x, y);
    this.xcomp = x;
    this.ycomp = y;
    this.offset = Element.cumulativeOffset(element);

    return (y >= this.offset[1] &&
            y <  this.offset[1] + element.offsetHeight &&
            x >= this.offset[0] &&
            x <  this.offset[0] + element.offsetWidth);
  },

  withinIncludingScrolloffsets: function(element, x, y) {
    var offsetcache = Element.cumulativeScrollOffset(element);

    this.xcomp = x + offsetcache[0] - this.deltaX;
    this.ycomp = y + offsetcache[1] - this.deltaY;
    this.offset = Element.cumulativeOffset(element);

    return (this.ycomp >= this.offset[1] &&
            this.ycomp <  this.offset[1] + element.offsetHeight &&
            this.xcomp >= this.offset[0] &&
            this.xcomp <  this.offset[0] + element.offsetWidth);
  },

  overlap: function(mode, element) {
    if (!mode) return 0;
    if (mode == 'vertical')
      return ((this.offset[1] + element.offsetHeight) - this.ycomp) /
        element.offsetHeight;
    if (mode == 'horizontal')
      return ((this.offset[0] + element.offsetWidth) - this.xcomp) /
        element.offsetWidth;
  },


  cumulativeOffset: Element.Methods.cumulativeOffset,

  positionedOffset: Element.Methods.positionedOffset,

  absolutize: function(element) {
    Position.prepare();
    return Element.absolutize(element);
  },

  relativize: function(element) {
    Position.prepare();
    return Element.relativize(element);
  },

  realOffset: Element.Methods.cumulativeScrollOffset,

  offsetParent: Element.Methods.getOffsetParent,

  page: Element.Methods.viewportOffset,

  clone: function(source, target, options) {
    options = options || { };
    return Element.clonePosition(target, source, options);
  }
};

/*--------------------------------------------------------------------------*/

if (!document.getElementsByClassName) document.getElementsByClassName = function(instanceMethods){
  function iter(name) {
    return name.blank() ? null : "[contains(concat(' ', @class, ' '), ' " + name + " ')]";
  }

  instanceMethods.getElementsByClassName = Prototype.BrowserFeatures.XPath ?
  function(element, className) {
    className = className.toString().strip();
    var cond = /\s/.test(className) ? $w(className).map(iter).join('') : iter(className);
    return cond ? document._getElementsByXPath('.//*' + cond, element) : [];
  } : function(element, className) {
    className = className.toString().strip();
    var elements = [], classNames = (/\s/.test(className) ? $w(className) : null);
    if (!classNames && !className) return elements;

    var nodes = $(element).getElementsByTagName('*');
    className = ' ' + className + ' ';

    for (var i = 0, child, cn; child = nodes[i]; i++) {
      if (child.className && (cn = ' ' + child.className + ' ') && (cn.include(className) ||
          (classNames && classNames.all(function(name) {
            return !name.toString().blank() && cn.include(' ' + name + ' ');
          }))))
        elements.push(Element.extend(child));
    }
    return elements;
  };

  return function(className, parentElement) {
    return $(parentElement || document.body).getElementsByClassName(className);
  };
}(Element.Methods);

/*--------------------------------------------------------------------------*/

Element.ClassNames = Class.create();
Element.ClassNames.prototype = {
  initialize: function(element) {
    this.element = $(element);
  },

  _each: function(iterator) {
    this.element.className.split(/\s+/).select(function(name) {
      return name.length > 0;
    })._each(iterator);
  },

  set: function(className) {
    this.element.className = className;
  },

  add: function(classNameToAdd) {
    if (this.include(classNameToAdd)) return;
    this.set($A(this).concat(classNameToAdd).join(' '));
  },

  remove: function(classNameToRemove) {
    if (!this.include(classNameToRemove)) return;
    this.set($A(this).without(classNameToRemove).join(' '));
  },

  toString: function() {
    return $A(this).join(' ');
  }
};

Object.extend(Element.ClassNames.prototype, Enumerable);

/*--------------------------------------------------------------------------*/

(function() {
  window.Selector = Class.create({
    initialize: function(expression) {
      this.expression = expression.strip();
    },

    findElements: function(rootElement) {
      return Prototype.Selector.select(this.expression, rootElement);
    },

    match: function(element) {
      return Prototype.Selector.match(element, this.expression);
    },

    toString: function() {
      return this.expression;
    },

    inspect: function() {
      return "#<Selector: " + this.expression + ">";
    }
  });

  Object.extend(Selector, {
    matchElements: function(elements, expression) {
      var match = Prototype.Selector.match,
          results = [];

      for (var i = 0, length = elements.length; i < length; i++) {
        var element = elements[i];
        if (match(element, expression)) {
          results.push(Element.extend(element));
        }
      }
      return results;
    },

    findElement: function(elements, expression, index) {
      index = index || 0;
      var matchIndex = 0, element;
      for (var i = 0, length = elements.length; i < length; i++) {
        element = elements[i];
        if (Prototype.Selector.match(element, expression) && index === matchIndex++) {
          return Element.extend(element);
        }
      }
    },

    findChildElements: function(element, expressions) {
      var selector = expressions.toArray().join(', ');
      return Prototype.Selector.select(selector, element || document);
    }
  });
})();

if (window.location.search.indexOf('debugPrototype') > -1) {
  Prototype = new Proxy(Prototype, {
    get(target, prop, receiver) {
      console.count('Prototype Call Detected');
      console.trace({ target, prop, receiver });
      return target[prop];
    }
  });
}

/**
 * @file    protoplus.js
 * @title   Prototype Plus Extensions Library
 * @author  Serkan Yersen
 * @company Interlogy LLC
 * @version 0.9.9
 * @todo Perform a complete test for all CSS values for shift
 * @todo Read CSS classes and add Morping
 * @todo Write a complete documentation
 * @todo Add droppables
 * @todo Add resizables
 */
if(window.console === undefined){
    if (!window.console || !console.firebug) {
        (function (m, i) {
            window.console = {};
            var e = function () {};
            while (i--) { window.console[m[i]] = e; }
        })('log debug info warn error assert dir dirxml trace group groupEnd time timeEnd profile profileEnd count'.split(' '), 16);
    }
    window.console.error = function(e){ throw(e); };
}
window.requestAnimFrame = (function(){
  return  window.requestAnimationFrame       ||
          window.webkitRequestAnimationFrame ||
          window.mozRequestAnimationFrame    ||
          window.oRequestAnimationFrame      ||
          window.msRequestAnimationFrame     ||
          function( callback ){
            window.setTimeout(callback, 1000 / 60);
          };
})();
if(window.Prototype === undefined){
    throw("Error:prototype.js is required by protoplus.js. Go to prototypejs.org and download lates version.");
}

Protoplus = {
    Version: "0.9.9",
    exec: function(code){
        return eval(code); // I have had this 'eval is evil' message
    },
    REFIDCOUNT: 100, // Reference ID
    references:{}, // Hold references
    /**
     * Returns the Internet explorer version
     */
    getIEVersion: function(){
      var rv = -1; // Return value assumes failure.
      if (navigator.appName == 'Microsoft Internet Explorer')
      {
        var ua = navigator.userAgent;
        var re  = new RegExp("MSIE ([0-9]{1,}[\\.0-9]{0,})");
        if (re.exec(ua) !== null){
          rv = parseFloat( RegExp.$1 );
        }
      }
      return rv;
    },
    /**
     * Easing functions for animation effects
     * @param {Object} x
     */
    Transitions: {
        linear:     function(x){ return x; },
        sineIn:     function(x){ return 1 - Math.cos(x * Math.PI / 2); },
        sineOut:    function(x){ return Math.sin(x * Math.PI / 2); },
        sineInOut:  function(x){ return 0.5 - Math.cos(x * Math.PI) / 2; },
        backIn:     function(b){ var a = 1.70158;return (b) * b * ((a + 1) * b - a);},
        backOut:    function(b){ var a = 1.70158;return (b = b - 1) * b * ((a + 1) * b + a) + 1;},
        backInOut:  function(b){ var a = 1.70158;if ((b /= 0.5) < 1) {return 0.5 * (b * b * (((a *= (1.525)) + 1) * b - a));}return 0.5 * ((b -= 2) * b * (((a *= (1.525)) + 1) * b + a) + 2);},
        cubicIn:    function(x){ return Math.pow(x, 3); },
        cubicOut:   function(x){ return 1 + Math.pow(x - 1, 3); },
        cubicInOut: function(x){ return x < 0.5 ? 4 * Math.pow(x, 3) : 1 + 4 * Math.pow(x - 1, 3); },
        quadIn:     function(x){ return Math.pow(x, 2); },
        quadOut:    function(x){ return 1 - Math.pow(x - 1, 2); },
        quadInOut:  function(x){ return x < 0.5 ? 2 * Math.pow(x, 2) : 1 - 2 * Math.pow(x - 1, 2); },
        quartIn:    function(x){ return Math.pow(x, 4); },
        quartOut:   function(x){ return 1 - Math.pow(x - 1, 4); },
        quartInOut: function(x){ return x < 0.5 ? 8 * Math.pow(x, 4) : 1 - 8 * Math.pow(x - 1, 4); },
        quintIn:    function(x){ return Math.pow(x, 5); },
        quintOut:   function(x){ return 1 + Math.pow(x - 1, 5); },
        quintInOut: function(x){ return x < 0.5 ? 16 * Math.pow(x, 5) : 1 + 16 * Math.pow(x - 1, 5); },
        circIn:     function(x){ return 1 - Math.sqrt(1 - Math.pow(x, 2)); },
        circOut:    function(x){ return Math.sqrt(1 - Math.pow(x - 1, 2)); },
        circInOut:  function(x){ return x < 0.5 ? 0.5 - Math.sqrt(1 - Math.pow(2 * x, 2)) * 0.5 : 0.5 + Math.sqrt(1 - Math.pow(2 * x - 2, 2)) * 0.5; },
        expoIn:     function(x){ return Math.pow(2, 10 * (x - 1)); },
        expoOut:    function(x){ return 1 - Math.pow(2, -10 * x); },
        expoInOut:  function(x){ x = 2 * x - 1; return x < 0 ? Math.pow(2, 10 * x) / 2 : 1 - Math.pow(2, -10 * x) / 2; },
        swingFrom:  function(b){ var a = 1.70158;return b * b * ((a + 1) * b - a);},
        swingTo:    function(b){ var a = 1.70158;return (b -= 1) * b * ((a + 1) * b + a) + 1;},
        swingFromTo:function(b){ var a = 1.70158;return ((b /= 0.5) < 1) ? 0.5 * (b * b * (((a *= (1.525)) + 1) * b - a)) : 0.5 * ((b -= 2) * b * (((a *= (1.525)) + 1) * b + a) + 2);},
        easeFrom:   function(a){ return Math.pow(a, 4);},
        easeTo:     function(a){ return Math.pow(a, 0.25);},
        easeFromTo: function(a){ if ((a /= 0.5) < 1) {return 0.5 * Math.pow(a, 4);}return -0.5 * ((a -= 2) * Math.pow(a, 3) - 2);},
        pulse:      function(x, n){ if (!n) { n = 1; } return 0.5 - Math.cos(x * n * 2 * Math.PI) / 2; },
        wobble:     function(x, n){ if (!n) { n = 3; } return 0.5 - Math.cos((2 * n - 1) * x * x * Math.PI) / 2; },
        elastic:    function(x, e){ var a; if (!e) { a = 30; } else { e = Math.round(Math.max(1, Math.min(10, e))); a = (11 - e) * 5; } return 1 - Math.cos(x * 8 * Math.PI) / (a * x + 1) * (1 - x); },
        bounce:     function(x, n){ n = n ? Math.round(n) : 4; var c = 3 - Math.pow(2, 2 - n); var m = -1, d = 0, i = 0; while (m / c < x) { d = Math.pow(2, 1 - i++); m += d; } if (m - d > 0) { x -= ((m - d) + d / 2) / c; } return c * c * Math.pow(x, 2) + (1 - Math.pow(0.25, i - 1)); },
        bouncePast: function(a){ if (a < (1 / 2.75)) {return (7.5625 * a * a);}else {if (a < (2 / 2.75)) {return 2 - (7.5625 * (a -= (1.5 / 2.75)) * a + 0.75);}else {if (a < (2.5 / 2.75)) {return 2 - (7.5625 * (a -= (2.25 / 2.75)) * a + 0.9375);}else {return 2 - (7.5625 * (a -= (2.625 / 2.75)) * a + 0.984375);}}}}
    },
    Colors: {
        /**
         * Valid CSS color names
         */
        colorNames: {"Black": "#000000", "MidnightBlue": "#191970", "Navy": "#000080", "DarkBlue": "#00008B", "MediumBlue": "#0000CD", "Blue": "#0000FF", "DodgerBlue": "#1E90FF", "RoyalBlue": "#4169E1", "SlateBlue": "#6A5ACD", "SteelBlue": "#4682B4", "CornflowerBlue": "#6495ED", "Teal": "#008080", "DarkCyan": "#008B8B", "MediumSlateBlue": "#7B68EE", "CadetBlue": "#5F9EA0", "DeepSkyBlue": "#00BFFF", "DarkTurquoise": "#00CED1", "MediumAquaMarine": "#66CDAA", "MediumTurquoise": "#48D1CC", "Turquoise": "#40E0D0", "LightSkyBlue": "#87CEFA", "SkyBlue": "#87CEEB", "Aqua": "#00FFFF", "Cyan": "#00FFFF", "Aquamarine": "#7FFFD4", "PaleTurquoise": "#AFEEEE", "PowderBlue": "#B0E0E6", "LightBlue": "#ADD8E6", "LightSteelBlue": "#B0C4DE", "Salmon": "#FA8072", "LightSalmon": "#FFA07A", "Coral": "#FF7F50", "Brown": "#A52A2A", "Sienna": "#A0522D", "Tomato": "#FF6347", "Maroon": "#800000", "DarkRed": "#8B0000", "Red": "#FF0000", "OrangeRed": "#FF4500", "Darkorange": "#FF8C00", "DarkGoldenRod": "#B8860B", "GoldenRod": "#DAA520", "Orange": "#FFA500", "Gold": "#FFD700", "Yellow": "#FFFF00", "LemonChiffon": "#FFFACD", "LightGoldenRodYellow": "#FAFAD2", "LightYellow": "#FFFFE0", "DarkOliveGreen": "#556B2F", "DarkSeaGreen": "#8FBC8F", "DarkGreen": "#006400", "MediumSeaGreen": "#3CB371", "DarkKhaki": "#BDB76B", "Green": "#008000", "Olive": "#808000", "OliveDrab": "#6B8E23", "ForestGreen": "#228B22", "LawnGreen": "#7CFC00", "Lime": "#00FF00", "YellowGreen": "#9ACD32", "LimeGreen": "#32CD32", "Chartreuse": "#7FFF00", "GreenYellow": "#ADFF2F", "LightSeaGreen": "#20B2AA", "SeaGreen": "#2E8B57", "SandyBrown": "#F4A460", "DarkSlateGray": "#2F4F4F", "DimGray": "#696969", "Gray": "#808080", "SlateGray": "#708090", "LightSlateGray": "#778899", "DarkGray": "#A9A9A9", "Silver": "#C0C0C0", "Indigo": "#4B0082", "Purple": "#800080", "DarkMagenta": "#8B008B", "BlueViolet": "#8A2BE2", "DarkOrchid": "#9932CC", "DarkViolet": "#9400D3", "DarkSlateBlue": "#483D8B", "MediumPurple": "#9370D8", "MediumOrchid": "#BA55D3", "Fuchsia": "#FF00FF", "Magenta": "#FF00FF", "Orchid": "#DA70D6", "Violet": "#EE82EE", "DeepPink": "#FF1493", "Pink": "#FFC0CB", "MistyRose": "#FFE4E1", "LightPink": "#FFB6C1", "Plum": "#DDA0DD", "HotPink": "#FF69B4", "SpringGreen": "#00FF7F", "MediumSpringGreen": "#00FA9A", "LightGreen": "#90EE90", "PaleGreen": "#98FB98", "RosyBrown": "#BC8F8F", "MediumVioletRed": "#C71585", "IndianRed": "#CD5C5C", "SaddleBrown": "#8B4513", "Peru": "#CD853F", "Chocolate": "#D2691E", "Tan": "#D2B48C", "LightGrey": "#D3D3D3", "PaleVioletRed": "#D87093", "Thistle": "#D8BFD8", "Crimson": "#DC143C", "FireBrick": "#B22222", "Gainsboro": "#DCDCDC", "BurlyWood": "#DEB887", "LightCoral": "#F08080", "DarkSalmon": "#E9967A", "Lavender": "#E6E6FA", "LavenderBlush": "#FFF0F5", "SeaShell": "#FFF5EE", "Linen": "#FAF0E6", "Khaki": "#F0E68C", "PaleGoldenRod": "#EEE8AA", "Wheat": "#F5DEB3", "NavajoWhite": "#FFDEAD", "Moccasin": "#FFE4B5", "PeachPuff": "#FFDAB9", "Bisque": "#FFE4C4", "BlanchedAlmond": "#FFEBCD", "AntiqueWhite": "#FAEBD7", "PapayaWhip": "#FFEFD5", "Beige": "#F5F5DC", "OldLace": "#FDF5E6", "Cornsilk": "#FFF8DC", "Ivory": "#FFFFF0", "FloralWhite": "#FFFAF0", "HoneyDew": "#F0FFF0", "WhiteSmoke": "#F5F5F5", "AliceBlue": "#F0F8FF", "LightCyan": "#E0FFFF", "GhostWhite": "#F8F8FF", "MintCream": "#F5FFFA", "Azure": "#F0FFFF", "Snow": "#FFFAFA", "White": "#FFFFFF"},
        /**
         * Creates a color palette
         */
        getPalette: function(){
            var generated = {};
            var cr = ['00', '44', '77', '99', 'BB', 'EE', 'FF'];
            var i = 0;
            for(var r = 0;  r < cr.length; r++){
                for(var g = 0;  g < cr.length; g++){
                    for(var b = 0;  b < cr.length; b++){
                        generated[(i++)+"_"] = '#'+cr[r]+cr[g]+cr[b];
                    }
                }
            }
            return generated;
        },
        /**
         * Parses the color string and returns rgb codes in array
         * @param {Object} color
         */
        getRGBarray: function (color){
            if(typeof color == "string"){
                if(color.indexOf("rgb") > -1){
                    color = color.replace(/rgb\(|\).*?$/g, "").split(/,\s*/, 3);
                }else{
                    color = color.replace("#", "");
                    if(color.length == 3){ // Handle 3 letter colors #CCC
                        color = color.replace(/(.)/g, function(n){ return parseInt(n+n, 16)+", "; }).replace(/,\s*$/, "").split(/,\s+/);
                    }else{ 
                        color = color.replace(/(..)/g, function(n){ return parseInt(n, 16)+", "; }).replace(/,\s*$/, "").split(/,\s+/);
                    }
                }
            }
            for(var x=0; x<color.length; x++){ color[x] = Number(color[x]); }
            return color;
        },
        /**
         * gets rgb values as parameters and returns HEX color string
         */
        rgbToHex: function (){
            var ret = [];
            var ret2 = [];
            for ( var i = 0; i < arguments.length; i++ ){ 
                ret.push((arguments[i] < 16 ? "0" : "") + Math.round(arguments[i]).toString(16));
                //ret.push((arguments[i] < 16 ? "0" : "") + arguments[i].toString(16).replace(/^(\w+)\.\w+$/g, '$1'));
            }
            return "#"+ret.join('').toUpperCase();
        },
        /**
         * Gets HEX color string an returns rgb array
         * @param {Object} str
         */
        hexToRgb: function (str){
            str = str.replace("#", "");
            var ret = [];
            if(str.length == 3){
                str.replace(/(.)/g, function(str){
                    ret.push(parseInt(str+str, 16));
                });
            }else{
                str.replace(/(..)/g, function(str){
                    ret.push(parseInt(str, 16));
                });
            }
            return ret;
        },
        /**
         * Inverts the given hex color
         * @param {Object} hex
         */
        invert: function(hex){
            var rgb = Protoplus.Colors.hexToRgb(hex);
            return Protoplus.Colors.rgbToHex(255-rgb[0], 255-rgb[1], 255-rgb[2]);
        }
    },
    /**
     * Profiler. Calculates the time of the process
     * @param {Object} title
     */
    Profiler: {
        stimes:{},
        /**
         * Start the profile
         * @param {Object} title Title of the process in order to recognize later
         */
        start: function(title){
            Protoplus.Profiler.stimes[title] = (new Date()).getTime();
                        
            //console.profile(Protoplus.Profiler.title);
        },
        /**
         * Finish and print the result of the profiler
         */
        end:function(title, ret){
            var res = ( ( (new Date()).getTime() - Protoplus.Profiler.stimes[title])/1000).toFixed(3);
            if(ret){
                return res;
            }
            msg = title+' took '+res;
            
            if('console' in window){
                console.log(msg);
            }
        }
    }
};

/**
 * @extends Hash class
 */
Object.extend(Hash.prototype, {
    /**
     * Debug: Object.debug(); Alerts each array element in a confirm box. Click ok to stop loop.
     * @param {Object} options
     * -- showFunction: if true show the appanded functions of an object.
     * -- skipBlanks: if true skips the blank values.
     */
    debug: function(opts){
        opts = opts? opts : {};
        node = this._object;
        text = opts.text? opts.text+"\n" : "";
        for(var e in node){
            if(typeof node[e] == "function" && !opts.showFunctions){ continue; }
            if(opts.skipBlanks && (node[e] === "" || node[e] === undefined)){ continue; }

            var stophere = confirm(text+e+" => "+node[e]);
            if(stophere){
                return node[e];
            }
        }
    }
});

Object.extend(Object, {
    deepClone: function(obj){
        if (typeof obj !== 'object' || obj === null) {
            return obj;
        }
        var clone = Object.isArray(obj)? [] : {};
        for (var i in obj) {
            var node = obj[i];
            if (typeof node == 'object') {
                if (Object.isArray(node)) {
                    clone[i] = [];
                    for (var j = 0; j < node.length; j++) {
                        if (typeof node[j] != 'object') {
                            clone[i].push(node[j]);
                        } else {
                            clone[i].push(this.deepClone(node[j]));
                        }
                    }
                } else {
                    clone[i] = this.deepClone(node);
                }
            } else {
                clone[i] = node;
            }
        }
        return clone;
    },
    /**
     * Checks if the given object is boolean or not
     * @param {Object} bool
     */
    isBoolean: function(bool){
        return (bool === true || bool === false);
    },
    /**
     * Checks if the given element is regular expression or not
     */
    isRegExp: function(obj){
        return !!(obj && obj.test && obj.exec && (obj.ignoreCase || obj.ignoreCase === false));
    }

});


/**
 * Extend the string
 */
Object.extend(String.prototype, {
    /**
     * Remove unnecessary white spaces and compress the json string
     */
    cleanJSON: function (){
        return this.replace(/(\"?)(\:|\,)\s+(\"?)/g, '$1$2$3');
    },
    /**
     * Shortens the string
     * @param {Object} length
     * @param {Object} closure
     */
    shorten: function(length, closure){
        length = length? length : "30";
        closure = closure? closure : "...";
        var sh = this.substr(0, length);
        sh += (this.length > length)? closure : "";
        return sh;
    },
    /**
     * Squezes the long texts
     * Keeps the start end end of the string to make it more readable
     * @param {Object} length
     */
    squeeze: function(length){
        length = length? length : "30";
        var join = "...";
        
        if((length - join.length) >= this.length){ return this; }
        
        var l = Math.floor((length -join.length) / 2);
        var start = this.substr(0, l+1);
        var end = this.substr(-(l), l);
        return start+join+end;
    },
    
    /**
     * A simple printf
     */
    printf: function(){
        var args = arguments;
        var word = this.toString(),
        i = 0;
         
        return word.replace(/(\%(\w))/gim, function(word, match, tag, count){
            var s = args[i] !== undefined? args[i] : '' ;
            i++;
            switch(tag){
                case "f":
                    return parseFloat(s).toFixed(2);
                case "d":
                    return parseInt(s, 10);
                case "x":
                    return s.toString(16);
                case "X":
                    return s.toString(16).toUpperCase();
                case "s":
                    return s;
                default:
                    return match;
            }
        });
    },
    
    /**
     * Add slashes
     */
    sanitize: function(){
        var str = this;
        return (str+'').replace(/[\\"']/g, '\\$&').replace(/\u0000/g, '\\0');
    },
    
    nl2br: function(is_xhtml){
        var str = this;
        var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';
        return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1'+ breakTag +'');// +'\n'); Removed trailing new line
    },
    
    /**
     * Strip slashes
     */
    stripslashes: function(){
        var str = this;
        return (str+'').replace(/\\(.?)/g, function (s, n1) {
            switch (n1) {
                case '\\':
                    return '\\';
                case '0':
                    return '\u0000';
                case '':
                    return '';
                default:
                    return n1;
            }
        });
    },
    
    /**
     * Turkish to lowercase
     */
    turkishToUpper: function(){
        var string = this;
        var letters = { "i": "İ", "ş": "Ş", "ğ": "Ğ", "ü": "Ü", "ö": "Ö", "ç": "Ç", "ı": "I" };
        string = string.replace(/([iışğüçö])+/g, function(letter){ return letters[letter]; });
        return string.toUpperCase();
    },
    /**
     * Turkish to uppper case
     */
    turkishToLower: function(){
        var string = this;
        var letters = { "İ": "i", "I": "ı", "Ş": "ş", "Ğ": "ğ", "Ü": "ü", "Ö": "ö", "Ç": "ç" };
        string = string.replace(/([İIŞĞÜÇÖ])+/g, function(letter){ return letters[letter]; });
        return string.toLowerCase();
    },
    /**
     * Convert to camelCase
     */
    toCamelCase: function() {
        var str = this;
        newStr = str.replace(/\s+/g, '_');
        strArr = newStr.split('_');
        if (strArr.length === 0) {
            return newStr;
        }
        newStr = "";
        for (var i = 0; i < strArr.length; i++) {
            newStr += strArr[i][0].toUpperCase();
            newStr += strArr[i].substr(1);
        }
        return newStr;
    },
    /**
     * @see http://www.conlang.info/cgi/dia.cgi
     */
    fixUTF: function(){
        var lowerCase={"a":"00E1:0103:01CE:00E2:00E4:0227:1EA1:0201:00E0:1EA3:0203:0101:0105:1D8F:1E9A:00E5:1E01:2C65:00E3:0251:1D90","b":"1E03:1E05:0253:1E07:1D6C:1D80:0180:0183","c":"0107:010D:00E7:0109:0255:010B:0188:023C","d":"010F:1E11:1E13:0221:1E0B:1E0D:0257:1E0F:1D6D:1D81:0111:0256:018C","e":"00E9:0115:011B:0229:00EA:1E19:00EB:0117:1EB9:0205:00E8:1EBB:0207:0113:2C78:0119:1D92:0247:1EBD:1E1B","f":"1E1F:0192:1D6E:1D82","g":"01F5:011F:01E7:0123:011D:0121:0260:1E21:1D83:01E5","h":"1E2B:021F:1E29:0125:2C68:1E27:1E23:1E25:0266:1E96:0127","i":"0131:00ED:012D:01D0:00EE:00EF:1ECB:0209:00EC:1EC9:020B:012B:012F:1D96:0268:0129:1E2D","j":"01F0:0135:029D:0249","k":"1E31:01E9:0137:2C6A:A743:1E33:0199:1E35:1D84:A741","l":"013A:019A:026C:013E:013C:1E3D:0234:1E37:2C61:A749:1E3B:0140:026B:1D85:026D:0142:0269:1D7C","m":"1E3F:1E41:1E43:0271:1D6F:1D86","n":"0144:0148:0146:1E4B:0235:1E45:1E47:01F9:0272:1E49:019E:1D70:1D87:0273:00F1","o":"00F3:014F:01D2:00F4:00F6:022F:1ECD:0151:020D:00F2:1ECF:01A1:020F:A74B:A74D:2C7A:014D:01EB:00F8:00F5","p":"1E55:1E57:A753:01A5:1D71:1D88:A755:1D7D:A751","q":"A759:02A0:024B:A757","r":"0155:0159:0157:1E59:1E5B:0211:027E:0213:1E5F:027C:1D72:1D89:024D:027D","s":"015B:0161:015F:015D:0219:1E61:1E63:0282:1D74:1D8A:023F","t":"0165:0163:1E71:021B:0236:1E97:2C66:1E6B:1E6D:01AD:1E6F:1D75:01AB:0288:0167","u":"00FA:016D:01D4:00FB:1E77:00FC:1E73:1EE5:0171:0215:00F9:1EE7:01B0:0217:016B:0173:1D99:016F:0169:1E75:1D1C:1D7E","v":"2C74:A75F:1E7F:028B:1D8C:2C71:1E7D","w":"1E83:0175:1E85:1E87:1E89:1E81:2C73:1E98","x":"1E8D:1E8B:1D8D","y":"00FD:0177:00FF:1E8F:1EF5:1EF3:01B4:1EF7:1EFF:0233:1E99:024F:1EF9","z":"017A:017E:1E91:0291:2C6C:017C:1E93:0225:1E95:1D76:1D8E:0290:01B6:0240","ae":"00E6:01FD:01E3","dz":"01F3:01C6","3":"0292:01EF:0293:1D9A:01BA:01B7:01EE"};
        var upperCase={"A":"00C1:0102:01CD:00C2:00C4:0226:1EA0:0200:00C0:1EA2:0202:0100:0104:00C5:1E00:023A:00C3","B":"1E02:1E04:0181:1E06:0243:0182","C":"0106:010C:00C7:0108:010A:0187:023B","D":"010E:1E10:1E12:1E0A:1E0C:018A:1E0E:0110:018B","E":"00C9:0114:011A:0228:00CA:1E18:00CB:0116:1EB8:0204:00C8:1EBA:0206:0112:0118:0246:1EBC:1E1A","F":"1E1E:0191","G":"01F4:011E:01E6:0122:011C:0120:0193:1E20:01E4:0262:029B","H":"1E2A:021E:1E28:0124:2C67:1E26:1E22:1E24:0126","I":"00CD:012C:01CF:00CE:00CF:0130:1ECA:0208:00CC:1EC8:020A:012A:012E:0197:0128:1E2C:026A:1D7B","J":"0134:0248","K":"1E30:01E8:0136:2C69:A742:1E32:0198:1E34:A740","L":"0139:023D:013D:013B:1E3C:1E36:2C60:A748:1E3A:013F:2C62:0141:029F:1D0C","M":"1E3E:1E40:1E42:2C6E","N":"0143:0147:0145:1E4A:1E44:1E46:01F8:019D:1E48:0220:00D1","O":"00D3:014E:01D1:00D4:00D6:022E:1ECC:0150:020C:00D2:1ECE:01A0:020E:A74A:A74C:014C:019F:01EA:00D8:00D5","P":"1E54:1E56:A752:01A4:A754:2C63:A750","Q":"A758:A756","R":"0154:0158:0156:1E58:1E5A:0210:0212:1E5E:024C:2C64","S":"015A:0160:015E:015C:0218:1E60:1E62","T":"0164:0162:1E70:021A:023E:1E6A:1E6C:01AC:1E6E:01AE:0166","U":"00DA:016C:01D3:00DB:1E76:00DC:1E72:1EE4:0170:0214:00D9:1EE6:01AF:0216:016A:0172:016E:0168:1E74","V":"A75E:1E7E:01B2:1E7C","W":"1E82:0174:1E84:1E86:1E88:1E80:2C72","X":"1E8C:1E8A","Y":"00DD:0176:0178:1E8E:1EF4:1EF2:01B3:1EF6:1EFE:0232:024E:1EF8","Z":"0179:017D:1E90:2C6B:017B:1E92:0224:1E94:01B5","AE":"00C6:01FC:01E2","DZ":"01F1:01C4"};
        var str = this.toString();
        
        for(var lk in lowerCase){
            var lvalue = '\\u'+lowerCase[lk].split(':').join('|\\u');
            str = str.replace(new RegExp(lvalue, 'gm'), lk);
        }
        
        for(var uk in upperCase){
            var uvalue = '\\u'+upperCase[uk].split(':').join('|\\u');
            str = str.replace(new RegExp(uvalue, 'gm'), uk);
        }
        
        return str;
    },
    /**
     * Makes the first letter of a word uppercase
     */
    ucFirst: function(){
        return this.charAt(0).toUpperCase() + this.substr(1, this.length + 1);
    }
    
});

/**
 * php's $_GET equivalent 
 * @example "http://www.example.com?name=serkan" to document.get.name => "serkan"
 */
var __result = document.URL.toQueryParams();

/**
 * @extends document
 */
Object.extend(document, {
    createCSS: function (selector, declaration) {
        var id = "style-"+selector.replace(/\W/gim, '');
        if($(id)){
           $(id).remove();
        }
        // test for IE
        var ua = navigator.userAgent.toLowerCase();
        var isIE = (/msie/.test(ua)) && !(/opera/.test(ua)) && (/win/.test(ua));
    
        // create the style node for all browsers
        var style_node = document.createElement("style");
        style_node.id = id;
        style_node.setAttribute("type", "text/css");
        style_node.setAttribute("media", "screen");
    
        // append a rule for good browsers
        if (!isIE) {
            style_node.appendChild(document.createTextNode(selector + " {" + declaration + "}"));
        }
    
        // append the style node
        document.getElementsByTagName("head")[0].appendChild(style_node);
    
        // use alternative methods for IE
        if (isIE && document.styleSheets && document.styleSheets.length > 0) {
            var last_style_node = document.styleSheets[document.styleSheets.length - 1];
            if (typeof(last_style_node.addRule) == "object") {
                last_style_node.addRule(selector, declaration);
            }
        }
    },
    selectRadioOption: function (options, value){
        options.each(function(ele){
           if( ele.value === value )
           {
               ele.checked = true;
           }
        });
    },
    
    preloadImages: function(images){
        var args = arguments;
        if(Object.isArray(images)){
            args = images;
        }
        var i=0; // Stupid lint :(
        for(i=0, images=[]; (src=args[i]); i++){
            images.push(new Image());
            images.last().src = src;
        }
    },

    readRadioOption: function (options){
        for (var i=0; i<options.length; i++){
            var ele = options[i];
            if( ele.checked === true )
            {
                return ele.value;
            }
        }
        return false;
    },
    getEvent: function(ev){
        
        if(!ev){ ev = window.event; }
        
        if(!ev.keyCode && ev.keyCode !== 0){
            ev.keyCode = ev.which;
        }
        
        return ev;
    },
    
    parameters: __result,
    get: __result,
    /**
     * Short hand for dom:loaded.
     * @param {Object} func
     */
    ready: function(func){
        document.observe("dom:loaded", func);
    },
    /**
     * Returns the element underneath the mouse, should have the event object
     * @param {Event} e 
     */
    getUnderneathElement: function(e){
        var pointX = (Prototype.Browser.WebKit)? Event.pointerX(e) : e.clientX;
        var pointY = (Prototype.Browser.WebKit)? Event.pointerY(e) : e.clientY;
        return document.elementFromPoint(pointX, pointY);
    },
    /**
     * Creates Cookie
     * @param {Object} name
     * @param {Object} value
     * @param {Object} days
     * @param {Object} path
     */
    createCookie: function(name, value, days, path){
        path = path? path : "/";
        path = path === "/" ? "/; SameSite=None; Secure" : path;
        var expires = "";
        if (days) {
            var date = new Date();
            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
            expires = ";expires=" + date.toGMTString();
        }
        document.cookie = name + "=" + escape(value) + expires + ";path="+path;
    },
    /**
     * Reads the cookie
     * @param {Object} name
     */
    readCookie: function(name){
        var nameEQ = name + "=";
        var ca = document.cookie.split(';');
        for (var i = 0; i < ca.length; i++) {
            var c = ca[i];
            while (c.charAt(0) == ' ') {
                c = c.substring(1, c.length);
            }
            if (c.indexOf(nameEQ) === 0) {
                return decodeURIComponent(c.substring(nameEQ.length, c.length));
            }
        }
        return null;
    },
    /**
     * Removes cookie
     * @param {String} name
     */
    eraseCookie: function(name){
        document.createCookie(name, "", -1);
    },
    /**
     * Converts value to a json string and stores in the cookie.
     * @param {String} name
     * @param {Object} value
     * @param {Number} days
     */
    storeJsonCookie:function(name, value, days){
        var val = Object.toJSON(value).cleanJSON();
        document.createCookie(name, val, days);
    },
    /**
     * Reads and parses Jsoncookie.
     * @param {String} name
     * @return {Object} Hash
     */
    readJsonCookie:function(name){
        if(document.readCookie(name)){
            return document.readCookie(name).toString().evalJSON();
        }else{
            return {};
        }
    },
    /**
     * simple mesarument for window size
     */
    getClientDimensions: function(){
        var head = document.body.parentNode;
        return { height: head.scrollHeight, width: head.scrollWidth };
    },
    /**
     * Wrapper for keyboard shortcut script of OpenJS
     * @link http://www.openjs.com/scripts/events/keyboard_shortcuts/
     * @param {Object} map
     */
    keyboardMap: function(map){ document.keyMap = map; var shortcut = { 'all_shortcuts': {}, 'add': function(shortcut_combination, callback, opt){ var default_options = { 'type': 'keydown', 'propagate': false, 'disable_in_input': false, 'target': document, 'keycode': false }; if (!opt) { opt = default_options; } else { for (var dfo in default_options) { if (typeof opt[dfo] == 'undefined') { opt[dfo] = default_options[dfo]; } } } var ele = opt.target; if (typeof opt.target == 'string') { ele = document.getElementById(opt.target);  } var ths = this; shortcut_combination = shortcut_combination.toLowerCase(); var func = function(e){ e = e || window.event; if (opt.disable_in_input) { var element; if (e.target) { element = e.target;  } else if (e.srcElement) { element = e.srcElement;  } if (element.nodeType == 3) { element = element.parentNode;  } if (element.tagName == 'INPUT' || element.tagName == 'TEXTAREA' || element.readAttribute('contenteditable') || document._onedit) { return;  } } if (e.keyCode) { code = e.keyCode;  } else if (e.which) { code = e.which;  } var character = String.fromCharCode(code).toLowerCase(); if (code == 188) { character = ",";  } if (code == 190) { character = ".";  } var keys = shortcut_combination.split("+"); var kp = 0; var shift_nums = { "`": "~", "1": "!", "2": "@", "3": "#", "4": "$", "5": "%", "6": "^", "7": "&", "8": "*", "9": "(", "0": ")", "-": "_", "=": "+", ";": ":", "'": "\"", ",": "<", ".": ">", "/": "?", "\\": "|" }; var special_keys = { 'esc': 27, 'escape': 27, 'tab': 9, 'space': 32, 'return': 13, 'enter': 13, 'backspace': 8, 'scrolllock': 145, 'scroll_lock': 145, 'scroll': 145, 'capslock': 20, 'caps_lock': 20, 'caps': 20, 'numlock': 144, 'num_lock': 144, 'num': 144, 'pause': 19, 'break': 19, 'insert': 45, 'home': 36, 'delete': 46, 'end': 35, 'pageup': 33, 'page_up': 33, 'pu': 33, 'pagedown': 34, 'page_down': 34, 'pd': 34, 'left': 37, 'up': 38, 'right': 39, 'down': 40, 'f1': 112, 'f2': 113, 'f3': 114, 'f4': 115, 'f5': 116, 'f6': 117, 'f7': 118, 'f8': 119, 'f9': 120, 'f10': 121, 'f11': 122, 'f12': 123 }; var modifiers = { shift: { wanted: false, pressed: false }, ctrl: { wanted: false, pressed: false }, alt: { wanted: false, pressed: false }, meta: { wanted: false, pressed: false } }; if (e.ctrlKey) { modifiers.ctrl.pressed = true;  } if (e.shiftKey) { modifiers.shift.pressed = true;  } if (e.altKey) { modifiers.alt.pressed = true;  } if (e.metaKey) { modifiers.meta.pressed = true;  } for (var i = 0; i < keys.length; i++) { k = keys[i]; if (k == 'ctrl' || k == 'control') { kp++; modifiers.ctrl.wanted = true; } else if (k == 'shift') { kp++; modifiers.shift.wanted = true; } else if (k == 'alt') { kp++; modifiers.alt.wanted = true; } else if (k == 'meta') { kp++; modifiers.meta.wanted = true; } else if (k.length > 1) { if (special_keys[k] == code) { kp++;  } } else if (opt.keycode) { if (opt.keycode == code) { kp++;  } } else { if (character == k) { kp++;  } else { if (shift_nums[character] && e.shiftKey) { character = shift_nums[character]; if (character == k) { kp++;  } } } } } if (kp == keys.length && modifiers.ctrl.pressed == modifiers.ctrl.wanted && modifiers.shift.pressed == modifiers.shift.wanted && modifiers.alt.pressed == modifiers.alt.wanted && modifiers.meta.pressed == modifiers.meta.wanted) { callback(e); if (!opt.propagate) { e.cancelBubble = true; e.returnValue = false; if (e.stopPropagation) { e.stopPropagation(); e.preventDefault(); } return false; } } }; this.all_shortcuts[shortcut_combination] = { 'callback': func, 'target': ele, 'event': opt.type }; if (ele.addEventListener) { ele.addEventListener(opt.type, func, false);  } else if (ele.attachEvent) { ele.attachEvent('on' + opt.type, func);  } else { ele['on' + opt.type] = func;  } }, 'remove': function(shortcut_combination){ shortcut_combination = shortcut_combination.toLowerCase(); var binding = this.all_shortcuts[shortcut_combination]; delete (this.all_shortcuts[shortcut_combination]); if (!binding) { return; } var type = binding.event; var ele = binding.target; var callback = binding.callback; if (ele.detachEvent) { ele.detachEvent('on' + type, callback);  } else if (ele.removeEventListener) { ele.removeEventListener(type, callback, false);  } else { ele['on' + type] = false;  } } }; $H(map).each(function(pair){ var key = pair.key; var opts = pair.value; shortcut.add(key, opts.handler, { disable_in_input: opts.disableOnInputs }); }); },
    checkDocType: function (){
        if (document.doctype === null){ return false; }
        var publicId = document.doctype.publicId.toLowerCase();
        return (publicId.indexOf("html 4") > 0) || (publicId.indexOf("xhtml") > 0);
    }
});

/**
 * @link http://adomas.org/javascript-mouse-wheel/ prototype extension by "Frank Monnerjahn" themonnie @gmail.com
 * @link http://www.ogonek.net/mousewheel/demo.html
 * @usage $('wheel-div').observe(Event.mousewheel, function(e){ Event.wheel(e); });
 */
Object.extend(Event, {
    mousewheel: Prototype.Browser.Gecko? 'DOMMouseScroll' : 'mousewheel',
    wheel:function (event){
        var delta = 0;
        if (!event) { event = window.event; }
        if (event.wheelDelta) {
            delta = event.wheelDelta/120;
            if (window.opera) { delta = -delta; }
        } else if (event.detail) { delta = -event.detail/3; }
        return Math.round(delta); //Safari Round
    },
    isInput: function(e){
        var element;
        if (e.target) {
            element = e.target;
        } else if (e.srcElement) {
            element = e.srcElement;
        }
        if (element.nodeType == 3) {
            element = element.parentNode;
        }
        
        if (element.tagName == 'INPUT' || element.tagName == 'TEXTAREA') { return true; }
        return false;
    },
    isRightClick: function(event){
        
        var _isButton;
        if (Prototype.Browser.IE) {
          var buttonMap = { 0: 1, 1: 4, 2: 2 };
          _isButton = function(event, code) {
            return event.button === buttonMap[code];
          };
        } else if (Prototype.Browser.WebKit) {
          _isButton = function(event, code) {
            switch (code) {
              case 0: return event.which == 1 && !event.metaKey;
              case 1: return event.which == 1 && event.metaKey;
              case 2: return event.which == 3 && !event.metaKey; // Safari and chrome right click fix
              default: return false;
            }
          };
        } else {
          _isButton = function(event, code) {
            return event.which ? (event.which === code + 1) : (event.button === code);
          };
        }
        
        return _isButton(event, 2);
    }
});

Protoplus.utils = {
    
    cloneElem: function(element){
        if(Prototype.Browser.IE){
            var div = document.createElement('div');
            div.innerHTML = element.outerHTML;
            return $(div.firstChild);
        }
        return element.cloneNode(true);
    },
    
    /**
     * Simulates the link effect on any HTML element. and defeats the pop up blockers
     * @param {Object} element
     * @param {Object} link
     */
    openInNewTab: function(element, link){
        element.observe('mouseover', function(e){
            if(!element.tabLink){
                var a = new Element('a', {href:link, target:'_blank'}).insert('&nbsp;&nbsp;');
                a.setStyle('opacity:0; z-index:100000; height:5px; width:5px; position:absolute; top:'+(Event.pointerY(e)-2.5)+'px;left:'+(Event.pointerX(e)-2.5)+'px');
                a.observe('click', function(){ element.tabLinked = false; a.remove(); });
                $(document.body).insert(a);
                element.tabLink = a;
                element.observe('mousemove', function(e){
                    element.tabLink.setStyle('top:'+(Event.pointerY(e)-2.5)+'px;left:'+(Event.pointerX(e)-2.5)+'px');
                });
            }
        });
        return element;
    },
    
    /**
     * Checks if the element has a fixed container or not
     * @param {Object} element
     */
    hasFixedContainer: function(element){
        var result = false;
        element.ancestors().each(function(el){
            if(result){ return; }
            if(el.style.position == "fixed"){
                result = true;
            }
        });
        return result;
    },
    
    getCurrentStyle: function(element, name){
        if (element.style[name]) {
            return element.style[name];
        } else if (element.currentStyle) {
            return element.currentStyle[name];
        }
        else if (document.defaultView && document.defaultView.getComputedStyle) {
            name = name.replace(/([A-Z])/g, "-$1");
            name = name.toLowerCase();
            s = document.defaultView.getComputedStyle(element, "");
            return s && s.getPropertyValue(name);
        } else {
            return null;
        }
    },
    /**
     * Determines if the passed element is overflowing its bounds,
     * either vertically or horizontally.
     * Will temporarily modify the "overflow" style to detect this
     * if necessary.
     * @param {Object} element
     */
    isOverflow: function(element){
        if(element.resized){
            element.hideHandlers();
        }
        var curOverflow = element.style.overflow;
        if (!curOverflow || curOverflow === "visible"){
            element.style.overflow = "hidden";
        }
        
        var leftOverflowing = element.clientWidth < element.scrollWidth;
        var topOverflowing = element.clientHeight < element.scrollHeight;
        var isOverflowing = leftOverflowing || topOverflowing;
        
        element.style.overflow = curOverflow;
        
        if(element.resized){
            element.showHandlers();
        }
                
        return isOverflowing? {
            top: topOverflowing? element.scrollHeight: false ,
            left: leftOverflowing? element.scrollWidth: false,
            both: leftOverflowing && topOverflowing
        } : false;
    },
    /**
     * Makes element unselectable. Disable cursor select
     * @param {Object} target
     */
    setUnselectable: function(target){
        
        //Emre: to prevent cursor not to move except when you use the arrow keys under "form-section" (46518)
        if (typeof target.style.MozUserSelect != "undefined" && target.className == "form-section-closed") {target.style.MozUserSelect = "normal";}
        else if (typeof target.onselectstart != "undefined") {target.onselectstart = function(){return false;};}
        else if (typeof target.style.MozUserSelect != "undefined") { target.style.MozUserSelect = "none";}
        else {target.onmousedown = function(){ return false;}; }
        target.__oldCursor = target.style.cursor;
        target.style.cursor = 'default';
        return target;
    },
    /**
     * Reverts unselectable effect, enables cursor select
     * @param {Object} target
     */
    setSelectable: function(target){
        if (typeof target.onselectstart != "undefined") { target.onselectstart = document.createElement("div").onselectstart; }
        else if (typeof target.style.MozUserSelect != "undefined") { target.style.MozUserSelect = document.createElement("div").style.MozUserSelect; }
        else { target.onmousedown = ""; }
        if(target.__oldCursor){
            target.style.cursor = target.__oldCursor;
        }else{
            target.style.cursor = '';
        }
        return target;
    },
    /**
     * Selects all text in any element
     * @param {Object} element
     */
    selectText: function(element){
        var r1 = "";
        if (document.selection) {
            r1 = document.body.createTextRange();
            r1.moveToElementText(element);
            r1.setEndPoint("EndToEnd", r1);
            r1.moveStart('character', 4);
            r1.moveEnd('character', 8);
            r1.select();
        }
        else {
            s = window.getSelection();
            r1 = document.createRange();
            r1.setStartBefore(element);
            r1.setEndAfter(element);
            s.addRange(r1);
        }
        
        return element;
    },
    
    /**
     * Mimics the mouseenter, mouseleave effect on browsers.
     * @param {Object} elem
     * @param {Object} over
     * @param {Object} out
     */
    hover: function(elem, over, out){
        $(elem).observe("mouseover", function(evt){
            if(typeof over == "function"){
                if(elem.innerHTML){
                    if(elem.descendants().include(evt.relatedTarget)){ return true; } // Mimic the mouseenter event
                }
                over(elem, evt);
            }else if(typeof over == "string"){
                $(elem).addClassName(over);
            }
        });
        $(elem).observe("mouseout", function(evt){
            if (typeof out == "function") {
                if(elem.innerHTML){
                    if(elem.descendants().include(evt.relatedTarget)){ return true; } // Mimic the mouseleave event
                }
                out(elem, evt);
            }else if(typeof over == "string"){
                $(elem).removeClassName(over);
            }
        });
        return elem;
    },
    
    mouseEnter: function(elem, over, out){
        $(elem).observe("mouseenter", function(evt){
            if(typeof over == "function"){
                over(elem, evt);
            }else if(typeof over == "string"){
                $(elem).addClassName(over);
            }
        });
        $(elem).observe("mouseleave", function(evt){
            if (typeof out == "function") {
                
                out(elem, evt);
            }else if(typeof over == "string"){
                $(elem).removeClassName(over);
            }
        });
        return elem;
    },

    /**
     * Sets the scroll amount for an element
     * @param {Object} element
     * @param {Object} amounts
     */
    setScroll: function(element, amounts){
        if(amounts.x !== undefined){
            element.scrollLeft = amounts.x;
        }
        if(amounts.y !== undefined){
            element.scrollTop = amounts.y;
        }
    },
    /**
     * Scroll window to keep element in viewport
     * @param {Object} element
     * @param {Object} options
     */
    scrollInto: function(element, options) {
        options = Object.extend({
            offset:[100, 100],
            direction:'bottom' // top, left, right
        }, options || {});
        
        element = $(element);
        var pos = Element.cumulativeOffset(element);
        var vp  = document.viewport.getDimensions();
        var ed  = Element.getDimensions(element);
        
        switch(options.direction){
            case 'bottom':
                if(pos[1]+options.offset[1] >= vp.height + window.scrollY){
                    window.scrollTo(window.scrollX, (pos[1]+options.offset[1]) - vp.height);
                }else if(window.scrollY !== 0 && (pos[1]+options.offset[1] <= Math.abs(vp.height - window.scrollY))){
                    window.scrollTo(window.scrollX, (pos[1]+options.offset[1]) - vp.height);
                }
            break;
            
            case "top":
                var height = element.getHeight();
                if(window.scrollY !== 0 && pos[1] <= window.scrollY + options.offset[1]){
                    window.scrollTo(window.scrollX, pos[1] - options.offset[1]);
                }else if(window.scrollY !== 0 && (pos[1]+options.offset[1] <= Math.abs(vp.height - window.scrollY))){
                    window.scrollTo(window.scrollX, pos[1] - options.offset[1]);
                }
            break;
        }
        
        return element;
    },
    /**
     * Returns the scroll offset of an element
     * @param {Object} element
     */
    getScroll: function(element){
        return {x: parseFloat(element.scrollLeft), y:parseFloat(element.scrollTop) };
    },
    /**
     * Sets the innerHTML of an element;
     * @param {Object} element
     * @param {Object} value
     */
    setText: function(element, value){
        element.innerHTML = value;
        return element;
    },
    /**
     * Sets value and returns the element for chaining
     * @param {Object} element
     * @param {Object} value
     */
    putValue: function(element, value){
        if(element.clearHint){
            element.clearHint();
        }
        element.value = value;
        return element;
    },
    /**
     * Resets the value of an upload field
     * @todo find a way to clone events attached by javascript jquery is doing it
     * @param {Object} element
     */
    resetUpload: function(element){
        // Only IE needs a hack to do this
        if(Prototype.Browser.IE){
            var p = element.parentNode;
            var c = element.cloneNode(true);
            p.replaceChild(c, element);
            return c;
        }
        // All new browsers can set empty value to file input
        element.value='';
        return element;
    },
    /**
     * Fires native events oberseved by element
     * @param {Object} element
     * @param {Object} event
     */
    run: function(element, event){
        
        if(event.include(':')){
            element.fire(event);
        }else{
            var evt;

            var disabled = element.hasClassName('form-dropdown') && element.disabled ? !!(element.enable()) : false;

            if (document.createEventObject && !Prototype.Browser.IE9 && !Prototype.Browser.IE10){ // dispatch for IE
                evt = document.createEventObject();
                element.fireEvent('on'+event,evt);
            }else{ // dispatch for firefox + others
                evt = document.createEvent("HTMLEvents");
                evt.initEvent(event, true, true ); // event type,bubbling,cancelable
                
                if(disabled) {
                    setTimeout(function() {
                        element.dispatchEvent(evt);
                        element.disable();
                    }, 0);
                } else {
                    element.dispatchEvent(evt);
                }
            }
        }
        
        return element;
    },
    /**
     * Sett CSS border radius for all supported browsers
     * @param {Object} element
     * @param {Object} value
     */
    setCSSBorderRadius: function(element, value){
        return element.setStyle({MozBorderRadius: value, borderRadius: value, '-webkit-border-radius': value});
    },
    /**
     * Returns the selected value of the element
     * @param {Object} element
     */
    getSelected: function(element){
        if(!element.options){
            if(element.innerHTML){ return element.innerHTML; }
            else{ return element.value; }
        }
            var selected =  element.selectedIndex >= 0? element.options[element.selectedIndex] : element;
            return selected;
    },
    /**
     * Selects the option of an element
     * @param {Object} element
     * @param {Object} val
     */
    selectOption: function(element, val){
        if(!val){ return element; }
        

        /*
          bug fix:161160 if option.text is numerical, it could be detected later checks, 
          so I duplicated this check, first one always check in values, if not found then check texts

        */

        var match_found =false;

      
        $A(element.options).each(function(option){
            // Regular expression Check
            if(Object.isRegExp(val) && (val.test(option.value) )){ option.selected = true;throw $break; }
            if(val == option.value){ option.selected = true; match_found = true; }
        });
        
        if(match_found == false){
          $A(element.options).each(function(option){
              // Regular expression Check
              if(Object.isRegExp(val) && ( val.test(option.text))){ option.selected = true; throw $break; }
              if(val == option.text){  option.selected = true;  }
          });  
        }
        
        


        /* old code
        $A(element.options).each(function(option){
            // Regular expression Check
            if(Object.isRegExp(val) && (val.test(option.value) || val.test(option.text))){ option.selected = true; throw $break; }
            if(val == option.value || val == option.text){ option.selected = true;  }
        });
        */
        element.run('change');
        return element;
    },
    /**
     * İmmediatelly stops shift animation without calling an event
     * @param {Object} element
     */
    stopAnimation: function(element){
        element.__stopAnimation = true;
        return element;
    },
    
    /**
     * Makes animation for given attribute. This function can animate every attribute with the numeric values it can also animate color values and scroll amounts.
     * @param {Object} element
     * @param {Object} options
     * Profile (51.4ms, 3576 calls)
     * Profile (43.127ms, 3604 calls)
     * Profile (42.651ms, 3568 calls)
     */
    shift: function(element, options){
        options = Object.extend({
            duration: 1,
            onEnd: Prototype.K,
            onStart: Prototype.K,
            onStep: Prototype.K,
            onCreate: Prototype.K,
            delay: 0,
            link:'cancel',
            transparentColor:'#ffffff',
            remove: false,
            easingCustom:false,
            propertyEasings:{},
            easing: Protoplus.Transitions.sineOut
        }, options || {});

        // Queuing the animation
        if(!element.queue){
            element.queue = [];
        }
        options.onCreate(element, options);
        // Linking the animations like mootools.
        if(options.link == "ignore" && element.timer){
            return element;
        }else if((options.link == "chain" || options.link == "queue") && element.timer){
            element.queue.push(options);
            return element;
        }

        if (element.timer){ // cancel the old animation
            clearInterval(element.timer); 
        }
        if (element.delayTime){
            clearTimeout(element.delayTime);
        }

        if(typeof options.easing == 'string'){
            if(options.easing in Protoplus.Transitions){
                options.easing = Protoplus.Transitions[options.easing];
            }else{
                options.easing = Protoplus.Transitions.sineOut;
            }
        } else if(typeof options.easing == 'object'){
            options.propertyEasings = options.easing; 
            options.easing = Protoplus.Transitions.sineOut;
        }else if(typeof options.easing != 'function'){
            options.easing = Protoplus.Transitions.sineOut;
        }

        options.duration *= 1000; // convert to milliseconds
        options.delay *= 1000; // convert to milliseconds
        element.timer = false;
        
        var properties = {}, begin, end, 
        
        /*
         * initiates the duration and call on start event
         */
        init = function(){
            begin = new Date().getTime();
            end = begin + options.duration;
            options.onStart(element);
        };
        
        /*
         * Remove the default options 
         */
        for(var x in options){
            if (!["duration", "onStart", "onStep", "transparentColor", "onEnd", "onCreate", "remove", "easing", "link", "delay", "easingCustom", "propertyEasings"].include(x) && options[x] !== false) {
                properties[x] = options[x];
            }            
        }
        // Get the unit value
        var unitRex=/\d+([a-zA-Z%]+)$/;
        
        // Prepare and define values for animation.
        for(var i in properties){
            var okey = i, oval=properties[i];
            var to, from, key, unit, s = [], easing=options.easing;
            
            if (["scrollX", "scrollLeft", "scrollY", "scrollTop"].include(okey)) {
                to = parseFloat(oval);
                key = (okey == "scrollX")? "scrollLeft" : (okey == "scrollY")? "scrollTop" : okey;
                if(element.tagName == "BODY"){
                    from = (okey == "scrollX" || okey == "scrollLeft")? window.scrollX : window.scrollY; // Read the window scroll
                }else{
                    from = (okey == "scrollX" || okey == "scrollLeft")? element.scrollLeft : element.scrollTop;
                }
                unit = '';
            } else if (okey == "rotate"){
                to = parseFloat(oval);
                key = "-webkit-transform";
                from = Element.getStyle(element, '-webkit-transform')? parseInt(Element.getStyle(element, '-webkit-transform').replace(/rotate\(|\)/gim, ""), 10) : 0;
                unit = 'deg';
            } else if (["background", "color", "borderColor", "backgroundColor"].include(okey)) {
                if(oval == 'transparent'){
                    oval = options.transparentColor;
                }
                to = Protoplus.Colors.hexToRgb(oval);
                key = okey == "background" ? "backgroundColor" : okey;
                var bgcolor = Element.getStyle(element, key);
                if(!bgcolor || bgcolor == 'transparent'){
                    bgcolor = options.transparentColor;
                }
                
                from = Protoplus.Colors.getRGBarray(bgcolor);
                unit = '';
            } else if(okey == "opacity"){
                to = (typeof oval == "string") ? parseInt(oval, 10) : oval;
                key = okey;
                from = Element.getStyle(element, okey);
                unit = '';
                from = parseFloat(from);
            
            } else {
                to = (typeof oval == "string") ? parseInt(oval, 10) : oval;
                key = okey;
                from = Element.getStyle(element, okey.replace("-webkit-", "").replace("-moz-", "")) || "0px";
                unit = okey == 'opacity' ? '' : (unitRex.test(from))? from.match(unitRex)[1] : 'px';
                from = parseFloat(from);
            }
            
            // If there is a different easing for this item
            if(okey in options.propertyEasings){
                easing = Protoplus.Transitions[options.propertyEasings[okey]];
            }
            
            if(!to && to !== 0){
                try {
                    s[key] = oval;
                    element.style[key] = oval;
                }catch(e){  }
            }else{
                properties[okey] = { key: key, to: to, from: from, unit: unit, easing: easing };
            }
        }
        
        /**
         * Calculate animation amount
         * @param {Object} ease
         * @param {Object} option
         * @param {Object} arr
         */
        var fn = function(ease, option, arr){
            var val = 0;
            if(arr !== false){ 
                return Math.round(option.from[arr] + ease * (option.to[arr] - option.from[arr]));
                
            }
            // begin + ease * change
            // console.log("%s + %s * (%s - %s) = %s", option.from, ease, option.to, option.from, (option.from + ease * (option.to - option.from)))
            return (option.from + ease * (option.to - option.from));
        };
        
        element.__stopAnimation = false;
        
        var step = function(){
            var time = new Date().getTime(), okey, oval, rgb;
            
            if(element.__stopAnimation === true){
                clearInterval(element.timer);
                element.timer = false;
                element.__stopAnimation = false;
                return;
            }
            
            if (time >= end) { // If duration is done. Complete the animation
                clearInterval(element.timer);
                element.timer = false;
                
                var valTo = (options.easing == "pulse" || options.easing == Protoplus.Transitions.pulse)? "from" : "to";
                // This will end the animation with the correct values.
                // if easing is pulse then set values to from.
                for(okey in properties){
                    oval=properties[okey];
                    
                    if(["scrollX", "scrollLeft", "scrollY", "scrollTop"].include(okey)){
                        if (element.tagName.toUpperCase() == "BODY") { // In order to scroll the document
                            if (oval.key == "scrollLeft") {
                                window.scrollTo(oval[valTo], window.scrollY);
                            }else {
                                window.scrollTo(window.scrollX, oval[valTo]);
                            }
                        }else {
                            element[oval.key] = oval[valTo] + oval.unit;
                        }
                    }else if (["background", "color", "borderColor", "backgroundColor"].include(okey)) {
                        element.style[oval.key] = 'rgb('+oval[valTo].join(', ')+")";
                    }else if(okey == "opacity"){
                        Element.setOpacity(element, oval[valTo]);
                    }else if(okey == "rotate"){
                        element.style[okey] = "rotate("+oval[valTo] + oval.unit+")";
                    }else{
                        element.style[okey] = oval[valTo] + oval.unit;
                    }
                }
                
                if(options.onEnd){ options.onEnd(element); }
                if(options.remove){
                    element.remove();
                }
                if(element.queue.length > 0){
                    var que = element.queue.splice(0, 1);
                    element.shift(que[0]);
                }

                return element;
            }
            
            if(options.onStep){ options.onStep(element); }
            
            for(okey in properties){
                oval = properties[okey];
                if(oval.key == "scrollLeft" || oval.key == "scrollTop"){
                    if (element.tagName.toUpperCase() == "BODY") { // In order to scroll the document
                        var scroll = parseInt(fn(oval.easing((time - begin) / options.duration, options.easingCustom), oval, false), 10) + oval.unit;
                        if(oval.key == "scrollLeft"){
                            window.scrollTo(scroll, window.scrollY);
                        }else{
                            window.scrollTo(window.scrollX, scroll);
                        }
                    }else{
                        element[oval.key] = parseInt(fn(oval.easing((time - begin) / options.duration, options.easingCustom), oval, false), 10) + oval.unit;
                    }
                }else if (okey == "background" || okey == "color" || okey == "borderColor" || okey == "backgroundColor") {
                    rgb = [];
                    for (var x = 0; x < 3; x++) {
                         
                         rgb[x] = fn(oval.easing((time - begin) / options.duration, options.easingCustom), oval, x);
                    }
                    
                    element.style[oval.key] = 'rgb('+rgb.join(', ')+')';
                }else if(okey == "opacity"){
                    Element.setOpacity(element, fn(oval.easing((time - begin) / options.duration, options.easingCustom), oval, false));
                }else if(okey == "rotate"){
                    element.style[oval.key] = "rotate("+fn(oval.easing((time - begin) / options.duration, options.easingCustom), oval, false) + oval.unit+")";
                } else {
                    element.style[okey] = fn(oval.easing((time - begin) / options.duration, options.easingCustom), oval, false) + oval.unit;
                }
            }
        };
        
        if(options.delay){
            element.delayTime = setTimeout(function(){
                init();
                element.timer = setInterval(step, 10);
            }, options.delay);
        }else{
            init();
            element.timer = setInterval(step, 10);
        }
        
        return element;
    },
    /**
     * Makes fade out effect for given element
     * @param {Object} element
     * @param {Object} options
     */
    fade: function(element, options){
        options = Object.extend({
            duration: 0.5,
            onEnd: function(e){ e.setStyle({display:"none"}); },
            onStart: Prototype.K,
            opacity: 0
        }, options || {});

        element.shift(options);
    },
    /**
     * Makes faded element appear again
     * @param {Object} element
     * @param {Object} options
     */
    appear: function(element, options){
        options = Object.extend({
            duration: 0.5,
            onEnd: Prototype.K,
            onStart: Prototype.K,
            opacity: 1
        }, options || {});
        element.setStyle({opacity:0, display:"block"});
        element.shift(options);
    },
    /**
     * Enable / Disable for all elements
     * @param {Object} element
     */
    disable: function(element) {
        element = $(element);
        element.disabled = true;
        return element;
    },
    enable: function(element) {
        element = $(element);
        element.disabled = false;
        return element;
    },    
    /**
     * Solution for circular reference problem. Hopefully it will solve memorry leaks
     * Sets an element with the with the given name as a reference
     * @param {Object} element
     * @param {Object} name
     * @param {Object} reference
     */
    setReference: function(element, name, reference){
        if(!element.REFID){ element.REFID = Protoplus.REFIDCOUNT++; }
        
        if(!Protoplus.references[element.REFID]){
            Protoplus.references[element.REFID] = {};
        }
        Protoplus.references[element.REFID][name] = $(reference);
        return element;
    },
    /**
     * Returns the given name
     * @param {Object} element
     * @param {Object} name
     */
    getReference: function(element, name){
        if(!element.REFID){
            return false;
        }
        return Protoplus.references[element.REFID][name];
    },
    /**
     * Safe remove function, Also removes the references 
     * @param {Object} element
     */
    remove: function(element){
        if(element.REFID){ // Clean unnecessary garbage
            delete Protoplus.references[element.REFID];
        }
        if(element.parentNode){            
            element.parentNode.removeChild(element);
        }
        return element;
    }
};
// emile.js (c) 2009 Thomas Fuchs
// Licensed under the terms of the MIT license.

(function(emile, container){
  var parseEl = document.createElement('div'),
    props = ('backgroundColor borderBottomColor borderBottomWidth borderLeftColor borderLeftWidth '+
    'borderRightColor borderRightWidth borderSpacing borderTopColor borderTopWidth bottom color fontSize '+
    'fontWeight height left letterSpacing lineHeight marginBottom marginLeft marginRight marginTop maxHeight '+
    'maxWidth minHeight minWidth opacity outlineColor outlineOffset outlineWidth paddingBottom paddingLeft '+
    'paddingRight paddingTop right textIndent top width wordSpacing zIndex').split(' ');

  function interpolate(source,target,pos){ return (source+(target-source)*pos).toFixed(3); }
  function s(str, p, c){ return str.substr(p,c||1); }
  function color(source,target,pos){
    var i = 2, j = 3, c, tmp, v = [], r = [];
    j=3; c=arguments[i-1];
    while(i--){
      if(s(c,0)=='r') { 
          c = c.match(/\d+/g);
          while(j--){ v.push(~~c[j]); }
      } else {
        if(c.length==4){ c='#'+s(c,1)+s(c,1)+s(c,2)+s(c,2)+s(c,3)+s(c,3); }
        while(j--){ v.push(parseInt(s(c,1+j*2,2), 16)); }
      }
      j=3;
      c=arguments[i-1]; 
    }
    
    while(j--) { tmp = ~~(v[j+3]+(v[j]-v[j+3])*pos); r.push(tmp<0?0:tmp>255?255:tmp); }
    return 'rgb('+r.join(',')+')';
  }
  
  function parse(prop){
    var p = parseFloat(prop), q = prop.replace(/^[\-\d\.]+/,'');
    return isNaN(p) ? { v: q, f: color, u: ''} : { v: p, f: interpolate, u: q };
  }
  
  function normalize(style){
    var css, rules = {}, i = props.length, v;
    parseEl.innerHTML = '<div style="'+style+'"></div>';
    css = parseEl.childNodes[0].style;
    while(i--){ v = css[props[i]]; if(v){ rules[props[i]] = parse(v); } }
    return rules;
  }  
  
  container[emile] = function(el, style, opts){
    el = typeof el == 'string' ? document.getElementById(el) : el;
    opts = opts || {};
    var target = normalize(style), comp = el.currentStyle ? el.currentStyle : getComputedStyle(el, null),
      prop, current = {}, start = +new Date(), dur = opts.duration||200, finish = start+dur, interval,
      easing = opts.easing || function(pos){ return (-Math.cos(pos*Math.PI)/2) + 0.5; };
      
    for(prop in target){ current[prop] = parse(comp[prop]); }
    interval = setInterval(function(){
      var time = +new Date(), pos = time>finish ? 1 : (time-start)/dur;
      for(var prop in target){
        el.style[prop] = target[prop].f(current[prop].v,target[prop].v,easing(pos)) + target[prop].u;
      }
      if(time>finish) { clearInterval(interval); if(opts.after){ opts.after(); } }
    },10);
  };
})('emile', Protoplus.utils);

/**
 * @extends DOM
 */
Element.addMethods(Protoplus.utils);

/**
 * Memmory leak prevention
 */
Event.observe(window, 'unload', function(){
    Protoplus = null;
});

/**
 * JSONP implementation
 * @param {Object} transport
 */
Ajax = Object.extend(Ajax, {
    /**
     * JsonP implementation.
     * This is basically the same as Ajax.Request, If url is on same domain then switches to regular Ajax.Request
     * @param {Object} url
     * @param {Object} options
     */
    Jsonp: function(url, options){
        /**
         * Extend the options
         */
        this.options = Object.extend({
            method: 'post',
            timeout: 60, // seconds
            parameters:'',
            force:false,
            onComplete: Prototype.K,
            onSuccess: Prototype.K,
            onFail: Prototype.K
        }, options || {});
        
        var parameterString = url.match(/\?/)? '&' : '?';
        
        this.response = false;

        var callback_id = new Date().getTime();
        Ajax["callback_"+callback_id] = function(response){
            this.response = response;
        }.bind(this);
        
        this.callback = Ajax.callback;
        
        
        if(typeof this.options.parameters == "string"){
            parameterString += this.options.parameters;
        }else{
            $H(this.options.parameters).each(function(p){
                parameterString += p.key+'='+ encodeURIComponent(p.value) +'&';
            });
        }
        
        // Get request domain
            var matches = /^(\w+:)?\/\/([^\/?#]+)/.exec(url);   
            var sameDomain = (matches && ( matches[1] && matches[1] != location.protocol || matches[2] != location.host ));
        
        if(!sameDomain && this.options.force === false){ // If url is not external then convert it to Ajax.Request
            return new Ajax.Request(url, this.options);
        }
        
        this.url = url + parameterString + 'callbackName=Ajax.callback_'+callback_id+'&nocache=' + new Date().getTime(); // In order to prevent cacheing
        this.script = new Element('script', { type:'text/javascript', src: this.url });
        
        var errored = false;
        
        /**
         * Catch script load errors
         * @param {Object} e
         * @param {Object} b
         * @param {Object} c
         */
        this.onError = function(e, b, c){
            errored = true;
            this.options.onComplete({success:false, error: e || "Not Found"});
            this.options.onFail({success:false, error: e || "Not Found", args: [e, b, c]});
            this.script.remove();
            window.onerror = null;
            this.response = false;
            
        }.bind(this);
        
        /**
         * Run when script loaded
         * @param {Object} e
         */
        this.onLoad = function(e){
            if(errored){ return; }
            clearTimeout(timer);
            this.script.onreadystatechange = null;
            this.script.onload = null;
            var res = this.script;
            this.script.remove();
            window.onerror = null;
            
            if(this.response){
                setTimeout(function(){
                    this.options.onComplete({responseJSON: this.response});
                    this.options.onSuccess({responseJSON: this.response});
                }.bind(this), 20);
            }else{
                this.onError({error:'Callback error'});
            }
        }.bind(this);
        
        /**
         * Check ready state for internet explorer.
         * @param {Object} e
         */ 
        this.readyState = function(e){
            var rs = this.script.readyState;
            if (rs == 'loaded' || rs == 'complete') {
                this.onLoad();
            }
        }.bind(this);
        
        // If nothing happens then timeout
        var timer = setTimeout(this.onError, this.options.timeout * 1000);
        
        // set events
        this.script.onreadystatechange = this.readyState;
        this.script.onload = this.onLoad;
        window.onerror = function(e, b, c){
            clearTimeout(timer);
            this.onError(e, b, c);
            return true;
        }.bind(this);
        
        // Append script
        $$('head')[0].appendChild(this.script);
        return this;
    }
});

var _alert = window.alert;
/**
 * Super Alert.
 * Usage: alert("Hello %s, welcome to %s", name, location); -> Hello serkan welcome to Ankara
 */
if(!location.pathname.match(/^\/answers\/.+/)){
  window.alert = function(){
      var args = arguments;
      var i = 1;
      var first = args[0];
      if(typeof first == "object"){
          $H(first).debug();
          return first;
      }else if(typeof first == "string"){
          var msg = first.replace(/(\%s)/gim, function(e){
              return args[i++] || "";
          });
          _alert(msg);
          return true;
      }
      _alert(first);
  };
}

var rand = function (min, max){
    return Math.floor(Math.random()*(max-min))+min;
};

/**
 * With protoinit you can define functions before loading protoplus.
 * USAGE: 
 * var __protoinit = [];
 * __protoinit.push(function(){ alert("here"); })
 */
if("__protoinit" in window){
    document.ready(function(e){
        $A(__protoinit).each(function(f){
            f(e);
        });
    });
}

// The End... Thank you for listening

/**
 * UI Elements
 * document.createNewWindow => Creates a new floating window
 * Element.editable => Make the element instant editable
 * Element.tooltip => show a floating tooltip when mouse overed
 * Element.setDraggable => Make the element draggable
 * Element.makeSearchBox => convert normal input to a apple search box
 * Element.slider => Custom input slider
 * Element.spinner => Custom input spinner
 * Element.textshadow => Mimics CSS textshadow
 * Element.rating => Prints rating stars
 * Element.colorPicker => Prints a colorPicker tool
 * Element.miniLabel => Places a mini label at the bottom or top of the input fields
 * Element.hint => Places hint texts into text boxs
 */

if(window.Protoplus === undefined){
    throw("Error: ProtoPlus is required by ProtoPlus-UI.js");
}
Object.extend(document, {
    getViewPortDimensions: function (){
        // the more standards compliant browsers (mozilla/netscape/opera/IE7) use window.innerWidth and window.innerHeight
        var height;
        var width;
        if (typeof window.innerWidth != 'undefined')
        {
            width = window.innerWidth;
            height = window.innerHeight;
        } else if (typeof document.documentElement != 'undefined' && typeof document.documentElement.clientWidth != 'undefined' && document.documentElement.clientWidth !== 0) {
            width = document.documentElement.clientWidth;
            height = document.documentElement.clientHeight;
        } else { // older IE
            width = document.getElementsByTagName('body')[0].clientWidth;
            height = document.getElementsByTagName('body')[0].clientHeight;
        }
        return {height: height, width: width};
    },
    /**
     * Stops and destroys all tooltips
     */
    stopTooltips: function(){
        document.stopTooltip = true;
        $$(".pp_tooltip_").each(function(t){ t.remove(); });
        return true;
    },
    /**
     * Resumes tooltips
     */
    startTooltips: function(){
        document.stopTooltip = false;
    },
    /**
     * Over All defaults for all windows
     */
    windowDefaults: { // Default options
        height:false,    // Height of the window
        width:400,    // Width of the window
        title:'&nbsp;',    // Title of the window
        titleBackground:'#F5F5F5',
        buttonsBackground: '#F5F5F5',
        background:'#FFFFFF',
        top:'25%',        // Top location
        left:'25%',       // Left location
        position : 'absolute',
        winZindex: 10001,
        borderWidth:10,   // Width of the surrounding transparent border
        borderColor:'#000', // Color of the surrounding transparent border
        titleTextColor: '#777',
        resizable:false,
        borderOpacity:0.3, // Opacity of the surrounding transparent border
        borderRadius: "5px", // Corner radius of the surrounding transparent border
        titleClass:false, // CSS class of the title box
        contentClass:false, // CSS class of the content box
        buttonsClass:false, // CSS class of the buttons box
        closeButton:'X', // Close button content, can be replaced with an image
        fullScreenButton: '<img src="images/wizard-fullscreen.png" style="width:18px; height:18px;" class="fullscreen-wiz" title="Full Screen">',
        allowFullScreen:false, //allow the wizard to be fullscreened
        defaultFullScreen:false, //open in fullscreen
        openEffect:true, // Enable/Disable the effect on opening
        closeEffect:true, // Enable/Disable the effect on closing
        dim:true,  // Make it modal window, disable background
        modal:true, // Same as dim
        dimColor:'#fff', // color of the dimming surface
        dimOpacity:0.8, // opacity of the dimming surface
        dimZindex: 10000,
        dynamic: true, // Update the window dynamically while dragging
        contentPadding: '8',
        closeTo:false,
        buttons:false, // [ { text:'', name:'', icon:'', className:'', handler:function(){} } ]
        buttonsAlign: 'right',
        hideTitle:false // Hides the title and stuff
    },
    /**
     * Creates a floating window
     * <li>onClose:Prototype.K,    // Event will run when the window is closed</li>
     * <li>height:false,    // Height of the window </li>
     * <li>width:400,    // Width of the window
     * <li>title:'&nbsp;',    // Title of the window
     * <li>titleBackground:'#F5F5F5',
     * <li>buttonsBackground: '#F5F5F5',
     * <li>background:'#FFFFFF',
     * <li>top:'25%',        // Top location
     * <li>left:'25%',       // Left location
     * <li>borderWidth:10,   // Width of the surrounding transparent border
     * <li>borderColor:'#000', // Color of the surrounding transparent border
     * <li>borderOpacity:0.3, // Opacity of the surrounding transparent border
     * <li>borderRadius: "5px", // Corner radius of the surrounding transparent border
     * <li>titleClass:false, // CSS class of the title box
     * <li>contentClass:false, // CSS class of the content box
     * <li>closeButton:'X', // Close button content, can be replaced with an image
     * <li>openEffect:true, // Enable/Disable the effect on opening
     * @param {Object} options
     */
    window: function(options){

        var topOverridden = ("top" in options); //If user supplied top in options

        options = Object.extend( Object.deepClone(document.windowDefaults), options || {});
        options = Object.extend({
            onClose:Prototype.K,    // Event will run when the window is closed
            onInsert:Prototype.K,   // When the window inserted to document but not yet displayed
            onDisplay:Prototype.K,  // When the window displayed on the screen
            onFullScreen:Prototype.K,
            onUnFullScreen:Prototype.K
        }, options, {});

        options.dim = (options.modal !== true)? false : options.dim;
        options.width = options.width? parseInt(options.width, 10) : '';
        options.height = (options.height)? parseInt(options.height, 10) : false;
        options.borderWidth = parseInt(options.borderWidth, 10);

        var winWidth     =    (options.width? (options.width == 'auto'? 'auto' : options.width + 'px' ): '');
        var titleStyle   =    { background: options.titleBackground, zIndex:1000, position:'relative', padding: '2px', borderBottom: '1px solid #C27A00', height:'35px', MozBorderRadius: '3px 3px 0px 0px', WebkitBorderRadius: '3px 3px 0px 0px', borderRadius:'3px 3px 0px 0px'};
        var dimmerStyle  =    { background:options.dimColor, height:'100%', width:'100%', position:'fixed', top:'0px', left:'0px', opacity:options.dimOpacity, zIndex:options.dimZindex };
        var windowStyle  =    { top:options.top,left: options.left,position: options.position, padding: options.borderWidth+'px',height: "auto", width: winWidth, zIndex: options.winZindex };
        var buttonsStyle =    { padding: '0px', display:'inline-block', width:'100%', borderTop: '1px solid #ffffff', background:options.buttonsBackground, zIndex:999, position:'relative', textAlign:options.buttonsAlign, MozBorderRadius:'0 0 3px 3px', WebkitBorderRadius: '0px 0px 3px 3px', borderRadius:'0px 0px 3px 3px' };
        var contentStyle =    { zIndex: 1000, height: options.height !== false? options.height+'px' : "auto", position: 'relative', display: 'inline-block', width: '100%'};
        var wrapperStyle =    { zIndex:600, MozBorderRadius:'3px', WebkitBorderRadius:'3px', borderRadius:'3px' };
        var titleTextStyle  = { fontWeight:'bold', color:options.titleTextColor, textShadow:'0 1px 1px rgba(0, 0, 0, 0.5)', paddingLeft:'10px', fontSize:'13px' };
        var backgroundStyle = { height: '100%',width: '100%',background: options.borderColor,position: 'absolute',top: '0px',left: '0px',zIndex: -1,opacity: options.borderOpacity };
        var titleCloseStyle = { fontFamily:'Arial, Helvetica, sans-serif', color:'#aaa', cursor:'default' };
        var contentWrapperStyle = {padding: options.contentPadding + 'px', background: options.background };
        var dimmer;
        var fullScreened = false;
        if (options.dim/* && !document.dimmed*/) {// Dimm the window background
            dimmer = new Element('div', {className:'protoplus-dim'});
            dimmer.observe('click', function(){
                closebox();
            })
            dimmer.onmousedown = function(){return false;}; // Disable browser's default drag and paste functionality
            dimmer.setStyle(dimmerStyle);
            //$(document.body).setStyle({overflow:'hidden'});
        }

        // Create window structure
        var win, tbody, tr, wrapper, background, title, title_table, title_text, title_fullscreen, title_close, content, buttons, contentWrapper, block = {};
        win = new Element('div');
        win.insert(background = new Element('div'));
        win.insert(wrapper = new Element('div'));
        wrapper.insert(title = new Element('div'));
        title.insert(title_table = new Element('table', { width:'100%', height:'100%' }).insert(tbody = new Element('tbody').insert(tr = new Element('tr'))));
        tr.insert(title_text = new Element('td', {valign:'middle'}).setStyle('vertical-align: middle;'));
        tr.insert(title_fullscreen = new Element('td', {width:20, align:'center'}).setStyle('vertical-align: middle;'));
        tr.insert(title_close = new Element('td', {width:20, align:'center'}).setStyle('vertical-align: middle;'));
        wrapper.insert(contentWrapper = new Element('div', {className:'window-content-wrapper'}).insert(content = new Element('div')).setStyle(contentWrapperStyle));


        win.setTitle = function(title){
            title_text.update(title);
            return win;
        };

        /**
         * Puts an overlaying div on top of window
         */
        win.blockWindow = function(){
            wrapper.insert(block = new Element('div').setStyle('position:absolute; top:0px; left:0px; height:100%; width:100%; opacity:0.5; background:#000; z-index:10000'));
            block.onclick = block.onmousedown = block.onmousemove = function(){return false;};
            return block;
        };

        /**
         * Removes the blocking div from window
         */
        win.unblockWindow = function(){
            block.remove();
            return win;
        };

        if(options.hideTitle){
            title.hide();
            title_close = new Element('div').setStyle('text-align:center;');
            wrapper.insert(title_close.setStyle('position:absolute;z-index:1111000; right:15px; top:15px;'));
            contentWrapper.setStyle({MozBorderRadius:titleStyle.MozBorderRadius, WebkitBorderRadius: titleStyle.WebkitBorderRadius, borderRadius:titleStyle.borderRadius});
        }

        win.buttons = {};
        var buttonsDiv;
        if(options.buttons && options.buttons.length > 0){
            wrapper.insert(buttons = new Element('div', {className: 'window-buttons-wrapper'}));

            if(!options.buttonsClass){
                buttons.setStyle(buttonsStyle);
            }else{
                buttons.addClassName(options.buttonsClass);
            }
            buttons.insert(buttonsDiv = new Element('div').setStyle('padding:12px;height:23px;'));
            $A(options.buttons).each(function(button, i){
                var color = button.color || 'grey';

                var but = new Element('button', {
                    className: 'big-button buttons buttons-' + color,
                    type: 'button',
                    name: button.name || "button-" + i,
                    id: button.id || "button-" + i
                }).observe('click', function(){
                    button.handler(win, but);
                });

                if(button.className){
                    but.addClassName(button.className);
                }

                /*if(button.link){
                    // Disable link feature for now
                    but = new Element('a', {href:'javascript:void(0)'}).observe('click', function(){
                        button.handler(win, but);
                    }).setStyle('margin:7px;font-size:11px;');

                }*/

                var butTitle = new Element('span').insert(button.title);
                if(button.icon){
                    button.iconAlign = button.iconAlign || 'left';
                    var butIcon = new Element('img', {
                        src: button.icon,
                        align: button.iconAlign == 'right' ? 'absmiddle' : 'left'
                    }).addClassName("icon-"+button.iconAlign);

                    if(button.iconAlign == 'left'){
                        but.insert(butIcon);
                    }

                    but.insert(butTitle);

                    if(button.iconAlign == 'right'){
                        but.insert(butIcon);
                    }

                }else{
                    but.insert(butTitle);
                }

                if(button.align == 'left'){
                    but.setStyle('float:left');
                }

                but.changeTitle = function(title){
                    butTitle.update(title);
                    return but;
                };

                but.updateImage = function (options){
                    butIcon.src = options.icon;
                    options.iconAlign = options.iconAlign || button.iconAlign;
                    if(options.iconAlign == 'right'){
                        butIcon.removeClassName('icon-left');
                        butIcon.addClassName('icon-right');
                    }else{
                        butIcon.removeClassName('icon-right');
                        butIcon.addClassName('icon-left');
                    }
                };

                win.buttons[button.name] = but;

                if(button.hidden === true){ but.hide(); }
                if(button.disabled === true){ but.disable(); }

                if(button.style){
                    but.setStyle(button.style);
                }

                //buttons.insert('&nbsp;');
                buttonsDiv.insert(but);
                //buttons.insert('&nbsp;');
            });
        }else{
            contentWrapper.setStyle({MozBorderRadius:buttonsStyle.MozBorderRadius, WebkitBorderRadius: buttonsStyle.WebkitBorderRadius, borderRadius:buttonsStyle.borderRadius});
        }

        // set styles
        win.setStyle(windowStyle);
        background.setStyle(backgroundStyle).setCSSBorderRadius(options.borderRadius);

        if(!options.titleClass){
            title.setStyle(titleStyle);
        }else{
            title.addClassName(options.titleClass);
        }

        if(!options.contentClass){
            content.setStyle(contentStyle).addClassName('window-content');
        }else{
            content.addClassName(options.contentClass);
        }

        wrapper.setStyle(wrapperStyle);
        title_text.setStyle(titleTextStyle);
        title_close.setStyle(titleCloseStyle);

        var closebox = function(key){ // Close function
            document._onedit = false; // re activate keymap

            if(options.onClose(win, key) !== false){
                var close = function(){

                    if(dimmer){ dimmer.remove(); document.dimmed = false; }
                    win.remove();
                    $(document.body).setStyle({overflow:''});

                    if(fullScreened) {
                        window.onresize = null;
                        document.documentElement.style.overflow = 'visible';
                        document.body.scroll = "yes";
                    }
                };
                if(options.closeEffect === true){
                    win.shift({opacity:0, duration:0.3, onEnd: close});
                }else{
                    close();
                }
                Event.stopObserving(window, 'resize', win.reCenter);
                document.openWindows = $A(document.openWindows).collect(function(w){ if(w !== win){ return w; } }).compact();
                // document.stopObserving('keyup', escClose);
            }
        };
        // var escClose = function(e){e = document.getEvent(e); if(e.keyCode == 27){ closebox('ESC'); } };
        // Insert box onto screen
        if (options.dim /*&& !document.dimmed*/) {
            $(document.body).insert(dimmer);
            document.dimmed = true;
        }

        // Set the content
        title_text.insert(options.title);
        title_close.insert(options.closeButton);
        title_close.onclick = function(){ closebox("CROSS"); };
        content.insert(options.content);

        var fullScreenGeneric = function() {
            win.setStyle({width: '100%',height: '100%',position: 'fixed',left: '-5px',top: '-8px'});
            win.down('.window-content').setStyle({
                height: parseInt(document.viewport.getHeight()) - (parseInt($$('.window-buttons-wrapper')[0].getHeight())+40)+'px'
            });
            document.documentElement.style.overflow = 'hidden';
            document.body.scroll = "no";
            window.onresize = function(e) {
                options.onFullScreen();
            }

            options.onFullScreen();
        };

        var unFullScreenGeneric = function() {
            var width =  options.width? options.width + 'px' : 'auto';
            win.setStyle({width: width, height: 'auto', position: 'absolute'});
            win.down('.window-content').setStyle({
                height: 'auto',
                position: 'relative'
            });
            win.reCenter();
            window.onresize = null;
            document.documentElement.style.overflow = 'visible';
            document.body.scroll = "yes";

            options.onUnFullScreen();  //call passed function
        };

        if(options.allowFullScreen) {
            title_fullscreen.insert(options.fullScreenButton);
            title_fullscreen.onclick = function() {
                if(fullScreened) {
                    unFullScreenGeneric();
                } else {
                    fullScreenGeneric();
                }
                fullScreened = !fullScreened;
            }
            
        }

        $(document.body).insert(win);
        if(options.openEffect === true){
            win.setStyle({opacity:0});
            win.shift({opacity:1, duration:0.5});
        }

        /*
         * Seyhun:  removed this before calculations of window position because first calculating then scrolling
         *          makes window disapear.
         */
        try{
            document._onedit = true; // Stop editables and keyboard events on windows
            options.onInsert(win);
        }catch(e){
//            console.error(e);
        }

        // Center the box on screen
        win.reCenter = function(){
            var vp = document.viewport.getDimensions();
            var vso = $(document.body).cumulativeScrollOffset();
            var bvp = win.getDimensions();
            var top = ((vp.height - bvp.height) / 2) + vso.top;
            if(top < 0) top = 0;
            var left = ((vp.width - bvp.width) / 2) + vso.left;

            //if top is given by user, use that value instead
            if(topOverridden){
                top = options.top.toString();
                if(top.indexOf('%') === -1 && top.indexOf('px') === -1){
                    top += "px";
                }
            }else{
                top += "px";
            }
            win.setStyle({top:top, left:left+"px"});
            if (dimmer){
                dimmer.setStyle({height:vp.height+'px', width:vp.width+'px'/*, top:vso.top+'px', left:vso.left+'px'  */});
            }
        };
        win.reCenter();

        options.onDisplay(win);

        Event.observe(window, 'resize', win.reCenter);

        if(options.resizable){
            wrapper.resizable({
                constrainViewport:true,
                element:content,
                sensitivity:20,
                onResize:function(h, w, type){
                    if(type != 'vertical'){
                        win.setStyle({ width: (w + ( options.borderWidth * 2 ) - 10) +'px'});
                    }

                    if(content.isOverflow()){
                        content.setStyle({overflow:'auto'});
                    }else{
                        content.setStyle({overflow:''});
                    }
                }
            });
        }
        // document.observe('keyup', escClose); // Close the window when ESC is pressed
        // Make it draggable
        win.setDraggable({handler:title_text, constrainViewport:true, dynamic:options.dynamic, dragEffect:false});
        win.close = closebox;
        document.openWindows.push(win);

        if(options.defaultFullScreen) {
            fullScreenGeneric();
        }

        return win;
    }
});

/**
 * For closing windows
 */
document.observe('keyup', function(e){
    e = document.getEvent(e);
    if(Event.isInput(e)){ return; } // Don't run this on inputs
    if(document.openWindows.length > 0){
        if (e.keyCode == 27) {
            document.openWindows.pop().close('ESC');
        }
    }
});

document.openWindows = [];
document.createNewWindow = document.window;

Protoplus.ui = {

    /**
     * Recursively check if the given element is visible or not
     */
    isVisible: function(element){
        element = $(element);
        if (!element.parentNode) {
            return false;
        }

        if (element && element.tagName == "BODY") {
            return true;
        }

        if (element.style.display == "none" || element.style.visibility == "hidden") {
            return false;
        }

        return Protoplus.ui.isVisible(element.parentNode);
    },

    /**
     * Convers element to a editable area.
     * @param {Object} elem
     * @param {Object} options
        defaultText: Default text of the element. appears in the edit area
        onStart: Event fires when edit area created
        onEnd: Event fires when edit area closed,
        processBefore: Event fires before content of the edit area is placed,
        processAfter: Event fires after new content of the edit area is placed,
        escapeHTML: true,
        doubleClick: false,
        className: false,
        options: ,
        style:,
        type: "text"
     */
    editable: function(elem, options){
        elem = $(elem);
        options = Object.extend({
            defaultText: " ",
            onStart:Prototype.K,
            onEnd:Prototype.K,
            processAfter: Prototype.K,
            processBefore: Prototype.K,
            onBeforeStart: Prototype.K,
            escapeHTML: false,
            doubleClick: false,
            onKeyUp: Prototype.K,
            className: false,
            options: [{text:"Please Select", value:"0"}],
            style:{background:"none", border:"none",color:"#333", fontStyle:"italic", width:"99%"},
            type: "text"
        }, options || {});

        elem.onStart = options.onStart;
        elem.onEnd = options.onEnd;
        elem.defaultText = options.defaultText;
        elem.processAfter = options.processAfter;
        elem.cleanWhitespace();
        try{
            elem.innerHTML = elem.innerHTML || elem.defaultText;
        }catch(e){}

        // End of initialize
        var clickareas = [elem];
        if(options.labelEl){
            clickareas.push($(options.labelEl));
        }

        $A(clickareas).invoke('observe', options.doubleClick? "dblclick" : "click", function(e){

            if(options.onBeforeStart(elem) === false){ return; }

            if(elem.onedit){ return; }
            elem.onedit = true;
            //if(document._onedit){ return true; }
            if(document.stopEditables){ return true; }
            document._onedit = true;
            document.stopTooltips();


            var currentValue = elem.innerHTML.replace(/^\s+|\s+$/gim, "");
            var type = options.type;
            var op = $A(options.options);

            var blur = function(e){

                if(elem.keyEventFired){
                    elem.keyEventFired = false;
                    return;
                }
                if(input.colorPickerEnabled){
                    return;
                }

                input.stopObserving("blur", blur);
                elem.stopObserving("keypress", keypress);

                finish(e, currentValue);
            };

            var input ="";
            var keypress = function(e){
                if(type == "textarea"){ return true; } // Users may want to press enter in the text area
                if(e.shiftKey){ return true; }
                if(input.colorPickerEnabled){
                    return;
                }
                e = document.getEvent(e);
                if(e.keyCode == 13 || e.keyCode == 3) {
                    elem.keyEventFired = true;
                    elem.stopObserving("keypress", keypress);
                    input.stopObserving("blur", blur);
                    finish(e, currentValue);
                }
            };

            //Emre: this function remove "<br>" so this cause problem on textarea (52980)
            if(type.toLowerCase() == "textarea"){
                currentValue = currentValue.replace(/<br>/gi,"&lt;br&gt;");
            }

            /**
                This if statement guarantees not to clean
                HTML from checkbox and radio options.
                Fix: 758000 - Erhan
            */
            if (options.className !== "edit-option") {
                currentValue = currentValue.unescapeHTML();
            }
            
            currentValue = (currentValue == options.defaultText)? "" : currentValue;
            //currentValue = options.escapeHTML? currentValue.escapeHTML() : currentValue;
            currentValue = options.processBefore(currentValue, elem);


            if(type.toLowerCase() == "textarea"){
                input = new Element("textarea");
                input.value = currentValue;
                input.observe("blur", blur);
                input.observe('keyup', options.onKeyUp);
                //Emre: ie9 gives "Incorrect Function" error (56877)
                try{
                    input.select();
                }catch(e){}
            }else if(["select", "dropdown", "combo", "combobox"].include(type.toLowerCase())){
                input = new Element("select").observe("change", function(e){ elem.keyEventFired = true; finish(e, currentValue); });
                if(typeof op[0] == "string"){
                    op.each(function(text){ input.insert(new Element("option").insert(text)); });
                }else{
                    op.each(function(pair, i){
                        input.insert(new Element("option", {value:pair.value? pair.value : i}).insert(pair.text));
                    });
                }
                input.selectOption(currentValue);
                input.observe("blur", blur);
            } else if(["radio", "checkbox"].include(type.toLowerCase())){
                input = new Element("div");
                if(typeof op[0] == "string"){
                    op.each(function(text, i){ input.insert(new Element("input", {type:type,name:"pp", id:"pl_"+i})).insert(new Element("label", {htmlFor:"pl_"+i, id:"lb_"+i}).insert(text)).insert("<br>"); });
                }else{
                    op.each(function(pair, i){ input.insert(new Element("input", {type:type,name:"pp", value:pair.value? pair.value : i, id:"pl_"+i})).insert(new Element("label", {htmlFor:"pl_"+i,id:"lb_"+i}).insert(pair.text)).insert("<br>"); });
                }
            } else{
                input = new Element("input", { type:type, value:currentValue });
                input.observe("blur", blur);
                input.observe('keyup', options.onKeyUp);
                input.select();
            }

            //Emre: call finish function when blur does not work (48049)
            /* there occurs problem in Chrome 14 when click sub-label (43762)
            var allClick = document.on('click',function(e){
                if(e.target != input && e.target != elem){
                    finish({target:input},currentValue);
                    allClick.stop();
                }
            }); */


            if(options.className !== false){
                input.addClassName(options.className);
            }else{
                input.setStyle(options.style);
            }

            elem.update(input);
            elem.finishEdit = function(){ blur({target:input}); };
            document._stopEdit = function(){ elem.keyEventFired = true; finish({target: input}, currentValue); };
            elem.onStart(elem, currentValue, input);
            setTimeout(function(){
                input.select();
            }, 100);
            elem.observe("keypress", keypress);
        });

        var finish = function(e, oldValue){
            document._stopEdit = false;
            var elem = $(e.target);
            var val = "";
            if (!elem.parentNode) { return true; }
            var outer = $(elem.parentNode);
            outer.onedit = false;
            if ("select" == elem.nodeName.toLowerCase()) {
                val = elem.options[elem.selectedIndex].text;
            } else if(["checkbox", "radio"].include(elem.type && elem.type.toLowerCase())) {
                outer = $(elem.parentNode.parentNode);
                val = "";
                $(elem.parentNode).descendants().findAll(function(el){ return el.checked === true; }).each(function(ch){
                    if($(ch.id.replace("pl_", "lb_"))){
                        val += $(ch.id.replace("pl_", "lb_")).innerHTML+"<br>";
                    }
                });
            } else {
                val = elem.value;
            }
            if(options.escapeHTML === true){
                val = val.escapeHTML();
            }

            try{
                var selected = elem.getSelected();
                if (val === "" && outer.defaultText) {
                outer.update(outer.defaultText);
                } else {
                    outer.update(outer.processAfter(val, outer, elem.getSelected() || val, oldValue));
                }
                document._onedit = false;
                document.startTooltips();
                setTimeout(function(){
                     if($(outer.parentNode.parentNode).__drag_just_after_add !== true){
                        //console.log("direct save call");
                        outer.onEnd(outer, outer.innerHTML, oldValue, selected || val);
                     }else{
                        //console.log("will try to call value = ",$(outer.parentNode.parentNode).__drag_just_after_add);
                        $(outer.parentNode.parentNode).__drag_just_after_add_on_end_relay = function(){
                             //console.log("drag is ended properly now data will be saved");
                             outer.onEnd(outer, outer.innerHTML, oldValue, elem.getSelected() || val);
                        };
                     }
                },1);

            }catch(err){
                //do nothind
            }
        };
        return elem;
    },
    /**
     * Sets the same color value for each child of the element. for use of textshadow function
     */
    setShadowColor: function(elem, color){
        elem = $(elem);
        $A(elem.descendants()).each(function(node){
            if (node.nodeType == Node.ELEMENT_NODE) {
                node.setStyle({color: color});
            }
        });
        return elem;
    },
    /**
     * removes the shadow from element
     * @param {Object} elem
     */
    cleanShadow: function(elem){
        elem = $(elem);
        elem.descendants().each(function(e){
            if(e.className == "pp_shadow"){
                e.remove();
            }
        });
        return elem;
    },
    /**
     * Gets the elements context or closest parents context menu
     * @param {Object} element
     */
    getParentContext: function(element){
        element = $(element);
        try{
            if(!element.parentNode){
                return false;
            }

            if(element._contextMenuEnabled){
                return element;
            }

            if(element.tagName == 'BODY'){
                return false;
            }

            return $(element.parentNode).getParentContext();

        }catch(e){
            alert(e);
        }
    },
    /**
     * Check if the element has a context menu or not
     * @param {Object} element
     */
    hasContextMenu: function(element){
        return !!element._contextMenuEnabled;
    },
    /**
     * Set a context menu for an element
     * @param {Object} element
     * @param {Object} options
     */
    setContextMenu: function(element, options){

        element = $(element);
        options = Object.extend({
            others:[]
        }, options || {});

        element._contextMenuEnabled = true;
        element.items={};

        $A(options.menuItems).each(function(item, i){
            if(item == '-'){
                element.items["seperator_"+i] = item;
            }else{
                if(!item.name){
                    element.items["item_"+i] = item;
                }else{
                    element.items[item.name] = item;
                }
            }
        });

        element.changeButtonText = function(button, text){
            element.items[button].title = text;
            return $(element.items[button].elem).select('.context-menu-item-text')[0].update(text);
        };
        element.getButton       = function(button){ return element.items[button].elem; };
        element.showButton      = function(button){ element.items[button].hidden = false; };
        element.hideButton      = function(button){ element.items[button].hidden = true; };
        element.enableButton    = function(button){ element.items[button].disabled = false; };
        element.disableButton   = function(button){ element.items[button].disabled = true; };
        element.options         = options;

        options.others.push(element);

        var createListItem = function(context, item){
            var liItem = new Element('li').observe('contextmenu', Event.stop);

            if (Object.isString(item) && item == "-") {
                liItem.insert("<hr>");
                liItem.addClassName('context-menu-separator');
                context.insert(liItem);
            }else{
                if(item.icon){
                    var img = new Element('img', {src:item.icon, className:(item.iconClassName || ''), align:'left'}).setStyle('margin:0 4px 0 0;');
                    liItem.insert(img);
                }else{
                    liItem.setStyle('padding-left:24px');
                }
                item.handler = item.handler || Prototype.K;
                if(!item.disabled){
                    liItem.addClassName('context-menu-item');
                    liItem.observe('click', function(e){
                        Event.stop(e);
                        item.handler.bind(element)();
                        $$('.context-menu-all').invoke('remove'); // When clicked destroy all windows
                    });
                }else{
                    liItem.addClassName('context-menu-item-disabled');
                }
                if(item.items){
                    liItem.insert('<img align="right" src="images/right-handle.png" style="margin-top:2px;" />');
                    createInnerList(liItem, item);
                }

                if(item.hidden){
                    liItem.hide();
                }

                liItem.insert(new Element('span', { className:'context-menu-item-text' }).update(item.title.shorten(26)));
                context.insert(liItem);
            }
            return liItem;
        };

        var getContPosition = function(container){
            var w = document.viewport.getWidth();
            var l = container.getLayout();
            var p = container.up('.context-menu-all');
            var isNotFit = (l.get('width')+l.get('cumulative-left')) > (w - 200);

            if (!isNotFit && p && p.__pos) {
                pos = p.__pos;
            }else if(isNotFit){
                pos = "left";
            }else{
                pos = "right";
            }
            container.__pos = pos;
            return pos;
        };

        var createInnerList = function(cont, itemConf){

            var container = new Element('div', { className: 'context-menu-all' }).setStyle('z-index:1000000');
            var backPanel = new Element('div', { className: 'context-menu-back' }).setOpacity(0.98);
            var context   = new Element('div', { className: 'context-menu' });
            container.insert(backPanel).insert(context);

            var title = new Element('div', {className:'context-menu-title'}).observe('contextmenu', Event.stop);
            title.insert(itemConf.title.shorten(26));
            context.insert(title);
            var it = itemConf.items;
            if(Object.isFunction(itemConf.items)){
                it = itemConf.items();
            }

            $A(it).each(function(item){
                var liItem = createListItem(context, item);
                //element.items[pair.key].elem = liItem;
            });
            cont.insert(container.hide());
            container.setStyle({ position: 'absolute', top: '0px' });
            var t;
            var listopen = false;
            cont.mouseEnter(function(){
                if(itemConf.disabled){return;}
                if(listopen){return;}
                clearTimeout(t);
                //t = setTimeout(function(){
                    // Decide here if the menu will pop on the right or left
                    container.show();
                    listopen = true;
                    var pos = getContPosition(container);
                    container.style[pos] = '-'+(container.getWidth()-5)+'px';
                //}, 200);
            }, function(){
                clearTimeout(t);
                //t = setTimeout(function(){
                    container.style.left = container.style.right = "";
                    container.hide();
                    listopen = false;
                //}, 200);
            });
        };


        var openMenu = function(e, local, opt){
            // Stop the default Event
            opt = opt || {};
            Event.stop(e);
            if(local || (Prototype.Browser.Opera && e.ctrlKey) || Event.isRightClick(e) || Prototype.Browser.IE){
                $$('.context-menu-all').invoke('remove');
                var element = e.target;
                element = element.getParentContext();
                if (element !== false) {
                    if(element.options.onStart){ element.options.onStart(); }
                    var menuItems = element.menuItems;

                    var container = new Element('div', { className: 'context-menu-all' }).setStyle('z-index:1000000');
                    var backPanel = new Element('div', { className: 'context-menu-back' }).setOpacity(0.98);
                    var context   = new Element('div', { className: 'context-menu' });

                    container.insert(backPanel).insert(context);

                    if(element.options.title){
                        var title = new Element('div', {className:'context-menu-title'}).observe('contextmenu', Event.stop);
                        title.insert(element.options.title);
                        context.insert(title);
                    }

                    $H(element.items).each(function(pair){
                        var item = pair.value;
                        var liItem = createListItem(context, item);
                        element.items[pair.key].elem = liItem;
                    });

                    $(document.body).insert(container.hide());
                    var x = Event.pointer(e).x;
                    var y = Event.pointer(e).y;

                    var dim  = document.viewport.getDimensions();
                    var cDim = context.getDimensions();
                    var sOff = document.viewport.getScrollOffsets();

                    var top  = (y - sOff.top + cDim.height) > dim.height && (y - sOff.top) > cDim.height ? (y - cDim.height) - 20 : y;
                    var left = (x + cDim.width) > dim.width ? (dim.width - cDim.width) - 20 : x;

                    container.setStyle({
                        position: 'absolute',
                        top  : (opt.top? opt.top : top)  + 'px',
                        left : (opt.left? opt.left : left)  + 'px'
                    });

                    if(element.options.onOpen){ element.options.onOpen(context); }

                    container.show();
                }

            }
        };

        element.openMenu = openMenu;

        $A(options.others).invoke('observe', Prototype.Browser.Opera? 'click' : 'contextmenu', function(e){
            e.stop();
            var ev={};
            if(Prototype.Browser.IE){
                // To fix IE's Member Not Found error
                // When you pass event object as a parameter in setTimeout IE removes it from the memory
                // In order to prevent this error we should create a clone and use it instead
                for(var k in e){ ev[k] = e[k]; }
            }else{
                ev = e;
            }

            setTimeout(function(){ openMenu(ev);}, 0);
        });

        if(!document.contextMenuHandlerSet){
            document.contextMenuHandlerSet = true;

            $(document).observe('click', function(e){
                $$('.context-menu-all').invoke('remove');
            });
        }

        return element;
    },

    /**
     * Creates a text shadow for element
     * @param {Object} element
     * @param {Object} options
     */
    textshadow: function(element, options){
        element  = $(element);
        options = Object.extend({
            light: "upleft",
            color: "#666",
            offset: 1,
            opacity: 1,
            padding: 0,
            glowOpacity: 0.1,
            align:undefined,
            imageLike: false
        }, options || {});

        var light = options.light;
        var color = options.color;
        var dist  = options.offset;
        var opacity = options.opacity;
        var textalign = (options.align)? options.align : $(elem).getStyle("textAlign");
        var padding = (options.padding)? options.padding+"px" : $(elem).getStyle("padding");
        var text =  /* elem.innerHTML.replace(/\s+([^\n])/gim, '&nbsp;$1'); // */ elem.innerHTML;
        var container = new Element("div");
        var textdiv = new Element("div");

        var style = {
            color: color,
            height:element.getStyle("height"),
            width:element.getStyle("width"),
            "text-align":textalign,
            padding:padding,
            position: "absolute",
            "z-index": 100,
            opacity: opacity
        };
        elem.innerValue = text;
        elem.update("");
        container.setStyle({position: "relative"});
        textdiv.update(text);
        container.appendChild(textdiv);
        for (var i = 0; i < dist; i++) {
            var shadowdiv = new Element("div",{className: "pp_shadow"});
            shadowdiv.update(text);
            shadowdiv.setUnselectable();
            d = dist -i;
            shadowdiv.setStyle(style);
            switch (light) {
                case "down":
                    shadowdiv.setStyle({top: "-"+d+"px"});
                    break;
                case "up":
                    shadowdiv.setStyle({top: d+"px"});
                    break;
                case "left":
                    shadowdiv.setStyle({top: "0px", left: d+"px"});
                    break;
                case "right":
                    shadowdiv.setStyle({top: "0px", left: "-"+d+"px" });
                    break;
                case "upright":
                    shadowdiv.setStyle({top: d+"px", left: "-"+d+"px" });
                    break;
                case "downleft":
                    shadowdiv.setStyle({top: "-"+d+"px", left: d+"px"});
                    break;
                case "downright":
                    shadowdiv.setStyle({top: "-"+d+"px", left: "-"+d+"px" });
                    break;
                case "wide":
                    shadowdiv.setStyle({top: "0px", left: "0px" });
                    container.appendChild(new Element("div").setStyle(Object.extend(style,{top: "0px", left: "-"+d+"px" })).update(text).setShadowColor(color).setUnselectable());
                    container.appendChild(new Element("div").setStyle(Object.extend(style,{top: "0px", left: d+"px"})).update(text).setShadowColor(color).setUnselectable());
                    break;
                case "glow":
                    shadowdiv.setStyle({top: "0px", left: "0px" });
                    container.appendChild(new Element("div").setStyle(Object.extend(style,{top: d+"px", opacity: options.glowOpacity})).update(text).setShadowColor(color).setUnselectable()); // up
                    container.appendChild(new Element("div").setStyle(Object.extend(style,{top: "-"+d+"px", opacity: options.glowOpacity})).update(text).setShadowColor(color).setUnselectable()); // down
                    container.appendChild(new Element("div").setStyle(Object.extend(style,{top: d+"px", left: "-"+d+"px", opacity: options.glowOpacity})).update(text).setShadowColor(color).setUnselectable()); // upright
                    container.appendChild(new Element("div").setStyle(Object.extend(style,{top: d+"px", left: d+"px", opacity: options.glowOpacity})).update(text).setShadowColor(color).setUnselectable()); // upleft
                    container.appendChild(new Element("div").setStyle(Object.extend(style,{top: "-"+d+"px", left: "-"+d+"px", opacity: options.glowOpacity})).update(text).setShadowColor(color).setUnselectable()); // downright
                    container.appendChild(new Element("div").setStyle(Object.extend(style,{top: "-"+d+"px", left: d+"px", opacity: options.glowOpacity})).update(text).setShadowColor(color).setUnselectable()); // downleft
                    break;
                default: // upleft
                    shadowdiv.setStyle({top: d+"px", left: d+"px"});
            }
            shadowdiv.setShadowColor(color).setUnselectable();
            container.appendChild(shadowdiv);
        }
        textdiv.setStyle({position: "relative", zIndex: "120"});
        elem.appendChild(container);
        if (options.imageLike) {
           elem.setUnselectable().setStyle({cursor: "default"});
        }
        return element;
    },
    /**
     * Creates a tooltion on an element
     * @param {Object} element
     * @param {Object} text
     * @param {Object} options
     */
    tooltip: function(element, text, options){
        element = $(element);
        // If prototip is included use it instead
        if('Prototip' in window){

            options = Object.extend({
                delay: 0.01
            }, options || {});

            var T = new Tip(element, text, options);
            return element;
        }


        // removed for whatever..
        // return element;
        if(typeof text != "string"){ return element; }
        options = Object.extend({
            className: false,
            fixed:false,
            opacity:1,
            title:false,
            width:200,
            height:100,
            offset:false,
            zIndex:100000,
            delay:false,
            duration:false,
            fadeIn:false,
            fadeOut:false,
            shadow:false
        }, options || {});
        text = (options.title)? "<b>"+options.title+"</b><br>"+text : text;
        element.hover(function(el, evt){
            var vpd = document.viewport.getDimensions();
            var getBoxLocation = function(e){

                var offTop = options.offset.top? options.offset.top : 15;
                var offLeft = options.offset.left? options.offset.left : 15;
                var top = (Event.pointerY(e)+offTop);
                var left = (Event.pointerX(e)+offLeft);

                var dim = tooldiv.getDimensions();

                // Keep the box in viewport
                if(left + dim.width > (vpd.width - 20)) { left -= dim.width  + 20 + offLeft; }
                if(top + dim.height > (vpd.height - 20)){ top  -= dim.height + offTop; }
                return {top:top, left:left};
            };

            if(document.stopTooltip){
                $$(".pp_tooltip_").each(function(t){ t.remove(); });
                return true;
            }

            outer = new Element("div", {className:'pp_tooltip_'}).setStyle({ opacity:options.opacity, position:"absolute", zIndex:options.zIndex});
            if(options.className){
                tooldiv = new Element("div", {className:options.className}).setStyle({position:"relative", top:"0px", left:"0px", zIndex:10}).update(text);
            }else{
                tooldiv = new Element("div").setStyle({padding:"4px", background: "#eee", width:(options.width == "auto"? "auto" : options.width+"px"), border:"1px solid #333", position:"absolute", top:"0px", left:"0px", zIndex:10}).update(text);
                tooldiv.setCSSBorderRadius('5px');
            }
            if(options.shadow){
                shadTop = options.shadow.top? parseInt(options.shadow.top, 10) : 4;
                shadLeft = options.shadow.left? parseInt(options.shadow.left, 10) : 4;
                shadBack = options.shadow.back? options.shadow.back : "#000";
                shadOp = options.shadow.opacity? options.shadow.opacity : 0.2;
                if (options.className) {
                    shadow = new Element("div", {className: options.className || ""}).setStyle({position:"absolute", borderColor:"#000", color:"#000", top:shadTop+"px", left:shadLeft+"px", zIndex:9, background:shadBack, opacity:shadOp});
                    shadow.update(text);
                }else{
                    shadow = new Element("div", {className: options.className || ""}).setStyle({padding:"4px", border:"1px solid black",  color:"#000", width:options.width+"px", position:"absolute", top:shadTop+"px", left:shadLeft+"px", zIndex:9, background:shadBack, opacity:shadOp});
                    shadow.setCSSBorderRadius('5px');
                    shadow.update(text);
                }

                outer.appendChild(shadow);
            }
            outer.appendChild(tooldiv);
            /*
            var removeButton = new Element('div');
            removeButton.innerHTML = 'X';
            removeButton.setStyle({ cursor:'pointer', border:'1px solid #666', background:'#cecece', textAlign:'center', top:'1px', width:'15px', position:'absolute', right:'1px', zIndex:1000 });
            removeButton.setCSSBorderRadius('4px');
            tooldiv.appendChild(removeButton);
            removeButton.observe('click', function(){
                outer.parentNode.removeChild(outer);
            });
            */
            var makeItAppear = function(){
                if (options.fixed) {
                    var fixTop = options.fixed.top? parseInt(options.fixed.top, 10) : element.getHeight();
                    var fixLeft = options.fixed.left? parseInt(options.fixed.left, 10) : element.getWidth()-50;
                    outer.setStyle({ top: fixTop+"px", left: fixLeft+"px"});
                }else{
                    element.observe("mousemove", function(e){
                        if(document.stopTooltip){
                            $$(".pp_tooltip_").each(function(t){ t.remove(); });
                            return true;
                        }
                        var loc = getBoxLocation(e);
                        // Keep the box in viewport
                        outer.setStyle({ top: loc.top+"px", left: loc.left+"px"});
                    });
                }
            };

            outer.delay = setTimeout(function(){
                if(options.fadeIn){
                    document.body.appendChild(outer);
                    var fl = getBoxLocation(evt);
                    outer.setStyle({opacity: 0, top:fl.top+"px", left:fl.left+"px"});
                    dur = options.fadeIn.duration? options.fadeIn.duration : 1;
                    outer.appear({duration:dur, onEnd:makeItAppear()});
                }else{
                    document.body.appendChild(outer);
                    var l = getBoxLocation(evt);
                    outer.setStyle({top:l.top+"px", left:l.left+"px"});
                    setTimeout(makeItAppear, 100);
                }

                if (options.duration) {
                    outer.duration = setTimeout(function(){
                        if (options.fadeOut) {
                            dur = options.fadeOut.duration ? options.fadeOut.duration : 1;
                            outer.fade({duration: dur, onEnd: function(){ if(outer.parentNode){  outer.remove(); } }});
                        }else{
                            if(outer.parentNode){ outer.remove(); }
                        }
                    }, options.duration * 1000 || 0);
                }
            }, options.delay*1000 || 0);
        },function(){

            if(document.stopTooltip){
                $$(".pp_tooltip_").each(function(t){ t.remove(); });
                return true;
            }
            if(outer){
                clearTimeout(outer.delay);
                clearTimeout(outer.duration);
            }
            if(options.fadeOut){
                dur = options.fadeOut.duration? options.fadeOut.duration : 0.2;
                outer.fade({duration:dur, onEnd:function(){ if(outer.parentNode){  outer.remove(); } }});
            }else{
                if(outer.parentNode){ outer.remove(); }
            }
        });
        return element;
    },
    /**
     * Simulates the scroll bars
     * @param {Object} element
     * @param {Object} options
     */
    softScroll: function(element, options){

        options = Object.extend({
            scrollSpeed:50
        }, options || {});


        var scroll = new Element('div', { className: 'scroll-bar' });
        var scrollStyle = new Element('div', {className:'scroll-style'});
        var table = new Element('table', {cellpadding:0, cellspacing:0, height:'100%'}).insert(new Element('tbody').insert(new Element('tr').insert(new Element('td', {valign:'top'}).setStyle('height:100%;padding:5px;').insert(scrollStyle))));
        scroll.insert(table);
        element.setStyle('overflow:hidden;');
        scroll.setStyle('position:absolute; top:0px; right:1px; width:16px; opacity:0; height:50%;');
        var container = element.wrap('div');

        element.updateScrollSize = function(){

            var ch;
            try{
                ch = container.measure('margin-box-height');
            }catch(e){
                ch = container.getHeight()+
                     (parseInt(container.getStyle('padding-top'), 10)||0)+
                     (parseInt(container.getStyle('padding-bottom'), 10)||0)+
                     (parseInt(container.getStyle('margin-top'), 10)||0)+
                     (parseInt(container.getStyle('margin-bottom'), 10)||0);
            }
            var sh = element.scrollHeight;
            if (sh <= 0 ){ return; }
            var per = ch * 100 / sh;
            // If scroll
            if(per > 100){
                scroll.hide();
            }else{
                scroll.show();
            }

            scroll.style.height = per+"%";
        };
        element.updateScrollSize();

        scroll.setDraggable({
            constraint: 'vertical',
            dragClass:'scroll-onpress',
            onDrag: function(el){
                var top = parseInt(el.style.top, 10);
                if (top < 0) {
                    el.style.top = "0px";
                    return false;
                }
                var h = container.getHeight();
                var sh = scroll.getHeight();
                if ((top + sh) > h) {
                    el.style.top = (h - (sh)) + "px";
                    return false;
                }
                scrollArea(top);
            }
        });

        function scrollArea(pos){
            var ch = container.getHeight();
            var sh = element.scrollHeight;
            var per = ch * 100 / sh;

            var posPer = pos * 100 / ch;
            var position = sh * posPer / 100;

            element.scrollTop = Math.round(position);
        }

        function updateScrollBar(pos){
            var sh = element.scrollHeight;
            var ch = container.getHeight();
            var per = pos * 100 / sh;
            var position = ch * per / 100;

            scroll.style.top = Math.round(position) + "px";
        }

        container.hover(function(){
            element.updateScrollSize(); // Re calculate scroll size on each focus
            scroll.shift({opacity: 1,duration: 0.5});
        }, function(){
            if (scroll.__dragging === true) { return; }
            scroll.shift({opacity: 0,duration: 0.5});
        });
        container.setStyle('position:relative; display:inline-block;');
        container.insert(scroll);

        var stime;
        element.observe(Event.mousewheel, function(e){
            e.stop();
            var w = Event.wheel(e);
            // clearTimeout(stime);
            // element.stopAnimation();
            if (w > 0) {
                element.scrollTop = element.scrollTop - options.scrollSpeed; // If scroll up then move to the right

                /*
                stime = setTimeout(function(){
                    element.shift({scrollTop:element.scrollTop - 100, easing:'quadOut',onStep:function(){
                        updateScrollBar(element.scrollTop);
                    }, duration:0.5})
                }, 50);
                // */
            } else if (w < 0) {
                element.scrollTop = element.scrollTop + options.scrollSpeed;

                /*
                stime = setTimeout(function(){
                    element.shift({scrollTop:element.scrollTop + 100, easing:'quadOut', onStep:function(){
                        updateScrollBar(element.scrollTop);
                    }, duration:0.5})
                }, 50);
                // */
            }

            updateScrollBar(element.scrollTop);
        });
    },
    /**
     * Makes element draggable
     * @param {Object} element
     * @param {Object} options
     */
    setDraggable:function(element, options){
        options = Object.extend({
            dragClass: "",
            handler: false,
            dragFromOriginal: false, // Disabled drag event on child elements
            onStart: Prototype.K,
            changeClone: Prototype.K,
            onDrag:  Prototype.K,
            onDragEnd:  Prototype.K,
            onEnd:   Prototype.K,
            dragEffect: false,
            revert: false,
            clone:  false,
            snap:   false,
            cursor: "move",
            offset: false,
            // Constraints are somewhat buggy in internet explorer
            constraint: false,
            constrainLeft:false,
            constrainRight:false,
            constrainTop:false,
            constrainBottom:false,
            constrainOffset:false, // [top, right, bottom, left]
            constrainViewport:false,
            constrainParent: false,
            dynamic:true
        }, options || {});

        if(options.snap && (typeof options.snap == "number" || typeof options.snap == "string")){
            options.snap = [options.snap, options.snap];
        }
        var mouseUp   = "mouseup",
            mouseDown = "mousedown",
            mouseMove = "mousemove";

        /*
        if(Prototype.Browser.MobileSafari){
            // It's nice and all but There is a problem with finishing the event
            // Until it's fixed we cannot use this
            mouseUp   = "touchend";
            mouseDown = "touchstart";
            mouseMove = "touchmove";
        }
        */

        if(options.constrainOffset){
            if(options.constrainOffset.length == 4){
                options.constrainTop = options.constrainTop? options.constrainTop : options.constrainOffset[0];
                options.constrainRight = options.constrainRight? options.constrainRight : options.constrainOffset[1];
                options.constrainBottom = options.constrainBottom? options.constrainBottom : options.constrainOffset[2];
                options.constrainLeft = options.constrainLeft? options.constrainLeft : options.constrainOffset[3];
            }
        }

        var handler;
        var stopDragTimer = false;

        var drag = function (e){
            Event.stop(e);
            if(mouseMove == "touchmove"){
                e = e.touches[0];
            }

            if(options.onDrag(drag_element, handler, e) === false){
                return;
            }

            var top   = startY+(Number(Event.pointerY(e)-mouseY));
            var left  = startX+(Number(Event.pointerX(e)-mouseX));

            if(options.offset){
                top   = options.offset[1]+ Event.pointerY(e);
                left  = options.offset[0]+ Event.pointerX(e);
            }

            if(options.snap){
                top = (top/options.snap[1]).round()*options.snap[1];
                left = (left/options.snap[0]).round()*options.snap[0];
            }
            top  = (options.constrainBottom !== false && top >= options.constrainBottom)? options.constrainBottom : top; // Check for max top
            top  = (options.constrainTop !== false && top <= options.constrainTop)? options.constrainTop : top; // Check for min top
            left = (options.constrainRight !== false && left >= options.constrainRight)? options.constrainRight : left; // Check for max left
            left = (options.constrainLeft !== false && left <= options.constrainLeft)? options.constrainLeft : left; // Check for min left

            if(options.constraint == "vertical"){
                drag_element.setStyle({top: top+"px"});
            }else if(options.constraint == "horizontal"){
                drag_element.setStyle({left: left+"px"});
            }else{
                drag_element.setStyle({top: top+"px", left: left+"px"});
            }

            if(stopDragTimer){
                clearTimeout(stopDragTimer);
            }
            options.onDrag(drag_element, handler, e);
            stopDragTimer = setTimeout(function(){
                options.onDragEnd(drag_element, handler, e);
            }, 50);
        };

        var mouseup = function (ev){
            Event.stop(ev);
            if(mouseUp == "touchend"){
                ev = e.touches[0];
            }
            if(options.dynamic !== true){
                document.temp.setStyle({top:element.getStyle('top'), left:element.getStyle('left')});
                element.parentNode.replaceChild(document.temp, element);
                document.temp.oldZIndex = element.oldZIndex;
                element = document.temp;
            }

            if(options.onEnd(drag_element, handler, ev) !== false){
                if(element.oldZIndex){
                    drag_element.setStyle({zIndex: element.oldZIndex});
                }else{
                    drag_element.setStyle({zIndex: ''});
                }

                if(options.revert){
                    if(options.revert === true){
                        options.revert = {
                            easing: "sineIn",
                            duration: 0.5
                        };
                    }
                    options.revert = Object.extend({
                        left:drag_element.startX,
                        top:drag_element.startY,
                        opacity:1,
                        duration:0.5,
                        easing:'sineIn'
                    }, options.revert || {});
                    drag_element.shift(options.revert);
                    drag_element.startX = false;
                    drag_element.startY = false;
                }else{
                    if(options.dragEffect){
                        drag_element.shift({opacity: 1, duration:0.2});
                    }
                }
            }
            element.__dragging = false;
            drag_element.removeClassName(options.dragClass);
            handler.setSelectable();
            drag_element.setSelectable();
            $(document.body).setSelectable();
            document.stopObserving(mouseMove, drag);
            document.stopObserving(mouseUp, mouseup);
        };

        if (options.handler) {
            if (typeof options.handler == "string") {
                handler = (options.handler.startsWith(".")) ? element.descendants().find(function(h){
                    return h.className == options.handler.replace(/^\./, "");
                }) : $(options.handler);
            } else {
                handler = $(options.handler);
            }
        }else{
            handler = element;
        }

        handler.setStyle({cursor:options.cursor});
        handler.observe(mouseDown, function(e){
            Event.stop(e);
            var evt = e;
            if(mouseDown == "touchstart"){
                e = e.touches[0];
            }
            element.__dragging = true;
            if(document.stopDrag){ return true; }
            if(options.dragFromOriginal && e.target != handler) { return false; }

            var vdim = false, voff = false;

            if(options.constrainElement) {
                voff = (Prototype.Browser.IE)? {top:0, left:0} : $(options.constrainElement).cumulativeOffset();
                vdim = $(options.constrainElement).getDimensions();
            }

            if(options.constrainParent)  {
                if($(element.parentNode).getStyle('position') == "relative" || $(element.parentNode).getStyle('position') == "absolute"){
                    voff = {top:0, left:0};
                }else{
                    voff = (Prototype.Browser.IE)? {top:0, left:0} : $(element.parentNode).cumulativeOffset();
                }

                vdim = $(element.parentNode).getDimensions();
            }

            if(options.constrainViewport){
                voff = $(document.body).cumulativeScrollOffset(); //{top:0, left:0};
                vdim = document.viewport.getDimensions();
            }

            if(vdim){
                vdim.height+=voff.top;
                vdim.width+=voff.left;
                options.constrainTop = voff.top+1;
                options.constrainBottom = vdim.height-(element.getHeight()+3);
                options.constrainRight = vdim.width-(element.getWidth()+3);
                options.constrainLeft = voff.left+1;
            }
            var temp_div;
            if(options.dynamic !== true){
                try{
                document.temp = element;
                temp_div = new Element('div').setStyle({
                        height: element.getHeight()+"px", width:element.getWidth()+"px", border:'1px dashed black',
                        top: element.getStyle('top') || 0,
                        left: element.getStyle('left') || 0,
                        zIndex: element.getStyle('zIndex')||0,
                        position:element.getStyle('position'), background:'#f5f5f5', opacity:0.3 });
                }catch(err){}
                element.parentNode.replaceChild(temp_div, element);
                element = temp_div;
            }
            if(["relative", "absolute"].include($(element.parentNode).getStyle('position'))){
                startX = element.getStyle("left")? parseInt(element.getStyle("left"), 10) : element.offsetLeft;
                startY = element.getStyle("top")? parseInt(element.getStyle("top"), 10) : element.offsetTop;
            }else{
                var eloff = element.cumulativeOffset();
                startX = eloff.left;
                startY = eloff.top;
            }
            mouseX = Number(Event.pointerX(e));
            mouseY = Number(Event.pointerY(e));
            if (options.clone) {
                drag_element = options.changeClone(element.cloneNode({deep: true}), startX, startY);
                $(document.body).insert(drag_element);
            }else{
                drag_element = element;
            }

            options.onStart(drag_element, handler, e);
            drag_element.addClassName(options.dragClass);

            element.oldZIndex = element.getStyle("z-index")||0;
            if(options.dragEffect){
                drag_element.shift({opacity: 0.7, duration:0.2});
            }

            drag_element.setStyle({position: "absolute", zIndex:99998});
            if(options.revert && !drag_element.startX && !drag_element.startY){
                drag_element.startX = startX;
                drag_element.startY = startY;
            }
            drag_element.setUnselectable();
            handler.setUnselectable();
            $(document.body).setUnselectable();
            document.observe(mouseMove, drag);
            document.observe(mouseUp, mouseup);

        });
        return element;
    },
    /**
     * Creates Star rating element. Requires stars.png
     * @param {Object} element
     * @param {Object} options
     */
    rating: function(element, options){

        element = $(element);

        options = Object.extend({
            imagePath: "stars.png",
            onRate: Prototype.K,
            resetButtonImage:false,
            resetButtonTitle: 'Cancel Your Rating',
            resetButton:true,
            inputClassName:'',
            titles: [], // Give an array of titles for corresponding stars
            disable:false, // Disable element just after user gives a rating.
            disabled: element.getAttribute("disabled")? element.getAttribute("disabled") : false,
            stars: element.getAttribute("stars")? element.getAttribute("stars") : 5,
            name: element.getAttribute("name")? element.getAttribute("name") : "rating",
            value: element.getAttribute("value")? element.getAttribute("value") : 0,
            cleanFirst: false,
            selectedRating: element.getAttribute("value") ? (element.getAttribute("value") - element.dataset.lowest + 1) : 0
        }, options || {});

        // Don't allow element to be starred again
        if(element.converted){ return element; }

        element.converted = true;
        element.addClassName('form-star-rating');
        var image = { blank: "0px 0px", over: "-16px 0px", clicked: "-32px 0px", half: "-48px 0px" };
        var hidden = new Element("input", {type:"hidden", name:options.name, className:options.inputClassName});
        var stardivs = $A([]);

        // Make Element Disabled
        element.disabled = (options.disabled=="true" || options.disabled === true)? true : false;
        element.setStyle({
            display:'inline-block',
            width: ((parseInt(options.stars, 10) + ( /* add place for reset button */ options.resetButton ? 1 : 0)) * 20) + "px",
            cursor: options.disabled ? "default" : "pointer" /*, clear:"left"*/
        });
        element.setUnselectable();
        if(options.cleanFirst){
            element.update();
        }
        var setStar = function(i){
            var elval = i;
            i = i || 0;
            var desc = $A(element.descendants());
            desc.each(function(e){ e.setStyle({ backgroundPosition:image.blank}).removeClassName("rated"); });
            desc.each(function(e, c){ if(c < i){ e.setStyle({backgroundPosition:image.clicked}).addClassName("rated"); } });
            hidden.value = i || "";
            if(options.disable){
                element.disabled = true;
                element.setStyle({cursor:"default"});
            }
            element.value = elval;
            options.onRate(element, options.name, i);
            element.run('keyup');
            hidden.run('change');
            if(options.resetButton){
                cross[ (i === 0)? "hide" : "show" ](); // Show or hide the resetButton
            }
        };
        /**
         * External method for setting the rating manually
         */
        element.setRating = setStar;

        $A($R(1, options.stars)).each(function(i){
            var star = new Element("div").setStyle({height:"16px", width:"16px", margin:"0.5px", cssFloat:"left", backgroundImage:"url("+options.imagePath+")"});
            star.observe("mouseover", function(){
                if(!element.disabled){
                    var desc = $A(element.descendants());
                    desc.each(function(e, c){ if(c < i){ e.setStyle({ backgroundPosition: e.hasClassName("rated")? image.clicked : image.over }); } });
                }
            }).observe("click", function(){
                if (!element.disabled) {
                    setStar(i);
                }
            });
            if(options.titles && options.titles[i-1]){
                star.title = options.titles[i-1];
            }
            stardivs.push(star);
        });

        if (!options.disabled) {
            element.observe("mouseout", function(){
                element.descendants().each(function(e){
                    e.setStyle({
                        backgroundPosition: e.hasClassName("rated") ? image.clicked : image.blank
                    });
                });
            });
        }

        if(options.resetButton){
            var cross = new Element("div").setStyle({height:"16px", width:"16px", margin:"0.5px", cssFloat:"left", color:'#999', fontSize:'12px', textAlign:'center'});
            if(options.resetButtonImage){
                cross.insert(new Element('img', {src:options.resetButtonImage, align:'absmiddle'}));
            }else{
                cross.insert(' x ');
            }
            cross.title = options.resetButtonTitle;
            cross.hide();
            cross.observe('click', function(){
                setStar(undefined);
            });
            stardivs.push(cross);
        }

        stardivs.each(function(star){ element.insert(star); });
        element.insert(hidden);
        if(options.selectedRating > 0){
            element.descendants().each(function(e, c){
                 c++;
                 if(c <= options.selectedRating){
                     e.setStyle({backgroundPosition:image.clicked }).addClassName("rated");
                 }

                 if(options.selectedRating > c-1 && options.selectedRating < c){
                     e.setStyle({backgroundPosition:image.half }).addClassName("rated");
                 }
             });
            hidden.value = options.value;
        }
        return element;
    },
    /**
     * Makes an apple style search box. Requires apple_search.png
     * @param {Object} element
     * @param {Object} options
     */
    makeSearchBox: function (element, options){

        element = $(element);

        // Was already converted
        if(element.up('.searchbox')){
            return element;
        }

        options = Object.extend({
            defaultText:"Search",
            onWrite:Prototype.K,
            onClear:Prototype.K,
            imagePath:"images/apple_search.png"
        }, options || {});

        element.observe("keyup", function(e){
            if (cross) {
                cross.setStyle({
                    backgroundPosition: element.value !== "" ? "0 -57px" : "0 -38px"
                });
            }
            options.onWrite(element.value, e);
        }).observe("focus", function(){
            if(element.value == options.defaultText){
                element.value="";
                element.setStyle({color:"#666"});
            }
        }).observe("blur", function(){
            if(element.value === ""){
                element.setStyle({color:"#999"});
                element.value = options.defaultText;
                if (cross) {
                    cross.setStyle({
                        backgroundPosition: element.value !== "" ? "0 -57px" : "0 -38px"
                    });
                }
            }
        });
        element.value = options.defaultText;
        element.setStyle({color:"#999"});

        if(element.type !== 'text'){
            element.addClassName("searchbox");
            element.observe('search', function(){
                element.run('keyup');
            });
            return element;
        }

        element.setStyle({
            border:"none",
            background:"none",
            height:"14px",
            outline:'none',
            width: (parseInt(element.getStyle("width"), 10)-32)+"px"
        });
        var tbody;
        var table = new Element("table", { cellpadding: 0, cellspacing: 0, className:"searchbox"}).setStyle({
            height:"19px",
            fontFamily:"Verdana, Geneva, Arial, Helvetica, sans-serif",
            fontSize:"12px"
        }).insert(tbody = new Element("tbody"));

        var tr = new Element("tr");
        var cont = new Element("td").setStyle({
            backgroundImage:"url("+options.imagePath+")",
            backgroundPosition:"0 -19px"
        });

        var cross = new Element("td").insert("&nbsp;").setStyle({cursor:'default'});
        tbody.insert(tr.insert(new Element("td").setStyle({
            backgroundImage:"url("+options.imagePath+")",
            backgroundPosition:"0 0",
            width:"10px"
        }).insert("&nbsp;")).insert(cont).insert(cross));

        cross.setStyle({
            backgroundImage:"url("+options.imagePath+")",
            backgroundPosition:element.value !== ""? "0 -57px" : "0 -38px",
            width:"17px"
        });

        cross.observe("click", function(){
            element.value="";
            element.focus();
            element.setStyle({color:"#333"});
            cross.setStyle({
                backgroundPosition:"0 -38px"
            });
            options.onClear(element);
            element.run('keyup');
        });
        element.parentNode.replaceChild(table, element);
        cont.insert(element);
        return element;
    },
    /**
     * Slider tool
     * @param {Object} element
     * @param {Object} options
     */
    slider:function(element, options){
        element = $(element);
        options = Object.extend({
            width:100,
            onUpdate:Prototype.K,
            maxValue:100,
            value:0,
            buttonBack:'url("../images/ball.png") no-repeat scroll 0px 0px transparent'
        }, options || {});

        if("JotForm" in window && "url" in JotForm){
            options.buttonBack = 'url("'+JotForm.url+'images/ball.png") no-repeat scroll 0px 0px transparent';
        }

        var valueToPixel = function(value){
            var val = (value*100/options.maxValue)*barWidth/100;
            val = val < 3? 3 : val;
            return Math.round(val);
        };

        var sliderOut    = new Element('div', {tabindex:1});
        var sliderBar    = new Element('div');
        var sliderButton = new Element('div', {id:new Date().getTime()});
        var sliderTable  = new Element('table', {cellpadding:0, cellspacing:1, border:0, width:options.width, className:element.className});
        var tbody        = new Element('tbody');
        var tr           = new Element('tr');
        var tr2          = new Element('tr');
        var sliderTD     = new Element('td', {colspan:3});
        var startTD      = new Element('td', {align:'center', width:20}).insert('0');
        var statTD       = new Element('td', {align:'center', width:options.width-40}).insert(options.value).setStyle('font-weight:bold');
        var endTD        = new Element('td', {align:'center', width:20}).insert(options.maxValue);
        var barWidth     = options.width-18;
        var defaultValue = options.value;

        options.value = valueToPixel(options.value);

        /**
         * Moves the button left side by given value
         * @param {Object} amount
         */
        var moveLEFT = function(amount){
            var l = parseInt(sliderButton.getStyle('left'),10)-amount;
            l = (l <= 3)? 3 : l;
            sliderButton.setStyle({left:l+"px"});
            updateValue(l);
        };
        /**
         * Moves the button right side by given value
         * @param {Object} amount
         */
        var moveRIGTH = function(amount){
            var l = parseInt(sliderButton.getStyle('left'),10)+amount;
            l = (l >= barWidth)? barWidth : l;
            sliderButton.setStyle({left:l+"px"});
            updateValue(l);
        };
        /**
         * Handle key events
         * @param {Object} e
         */
        var sliderKeys = function(e){
            e = document.getEvent(e);
            if(e.keyCode == 37){
                moveLEFT(5);
            }else if(e.keyCode == 39){
                moveRIGTH(5);
            }
        };
        /**
         * Handle wheel events
         * @param {Object} e
         */
        var sliderWheel = function(e){
            if(!sliderOut.__hasFocus){ return true; }
            e.stop();
            sliderOut.focus();
            var w = Event.wheel(e);
            if(w > 0){ moveRIGTH(5); // If scroll up then move to the right
            }else if(w < 0){ moveLEFT(5); } // else move to the left
        };

        /**
         * Calculate the selected value ove 100
         * @param {Object} pos
         * @param {Object} start
         * @param {Object} end
         */
        var updateValue = function(pos){

            var total = barWidth;

            if(parseInt(pos, 10) <= 3){
                element.value = 0;
            }else{
                var a = Math.round( (parseInt(pos, 10) * options.maxValue) / total );
                element.value =  parseInt(a, 10);
            }
            sliderOut.value = element.value === 0? "" : element.value;
            sliderTable.value = sliderOut.value;
            options.onUpdate(element.value);
            statTD.innerHTML = element.value;
            element.run('keyup');
            return element.value;
        };

        // Set styles
        sliderOut.setStyle({
            //border: '1px solid #ccc',
            //background: '#f5f5f5',
            width: options.width + 'px',
            position: 'relative',
            overflow:'hidden',
            outline:'none'
        });

        sliderBar.setStyle({
            border: '1px solid #999',
            background: '#eee',
            margin: '8px',
            overflow:'hidden',
            height: '3px'
        }).setCSSBorderRadius('4px');

        sliderButton.setStyle({
            position: 'absolute',
            height: '13px',
            width: '13px',
            background: options.buttonBack,
            overflow:'hidden',
            border: '1px solid transparent',
            top: '3px',
            left: options.value + 'px'
        }).setCSSBorderRadius('8px');

        startTD.setStyle({fontFamily:'Verdana', fontSize:'9px'});
        statTD.setStyle({fontFamily:'Verdana', fontSize:'9px'});
        endTD.setStyle({fontFamily:'Verdana', fontSize:'9px'});

        sliderOut.insert(sliderBar).insert(sliderButton);
        sliderTable.insert(tbody.insert(tr).insert(tr2));
        sliderTD.insert(sliderOut);
        tr.insert(sliderTD);
        tr2.insert(startTD).insert(statTD).insert(endTD);

        // Set button draggable
        sliderButton.setDraggable({constraint:'horizontal', /*snap:10,*/ dragEffect:false, cursor:'default', constrainLeft:3, constrainRight:barWidth, onDrag:function(i){
            updateValue(i.getStyle('left')); // Calculate the amount while dragging
        }});

        sliderOut.observe('focus', function(){
            sliderOut.__hasFocus = true;
            sliderOut.setStyle({borderColor:'#333'});
        }).observe('blur', function(){
            sliderOut.__hasFocus = false;
            sliderOut.setStyle({borderColor:'#ccc'});
        });

        // Set key and mousewheel events
        sliderOut.observe('keypress', sliderKeys).observe(Event.mousewheel, sliderWheel);

        sliderOut.observe('click', function(e){ // Set bar click event
            if(e.target.id == sliderButton.id){ return false; }
            var l = (Event.pointerX(e)-sliderBar.cumulativeOffset().left);
            l = l < 3? 3 : l;
            l = l > barWidth? barWidth : l;
            sliderButton.shift({left:l, duration:0.5}); // move the button where it's clicked
            updateValue(l);
        });

        // Create an hidden field

        var hidden = new Element('input', {type:'hidden', className: 'form-slider', name:element.name, value:defaultValue, id:element.id});
        element.parentNode.replaceChild(hidden, element); // replace the hidden with original box

        element = hidden;



        $(hidden.parentNode).insert(sliderTable.setUnselectable()); // add slider to the page

        hidden.setSliderValue = function(val){
            var v =valueToPixel(val);
            sliderButton.shift({left:v, duration:0.5});
            updateValue(v);
        };

        return hidden;
    },
    /**
     * Spinner input box
     * @param {Object} element
     * @param {Object} options
     */
    spinner: function(element, options){

        element = $(element);

        options = Object.extend({
            width:60,
            cssFloat:false,
            allowNegative:false,
            addAmount:1,
            maxValue:false,
            minValue:false,
            readonly:false,
            value:false,
            allowEmpty:false,
            size: 5,
            imgPath: 'images/',
            onChange: Prototype.K
        }, options || {});

        element.size = options.size; // Set a size to make it look good
        if(options.value === false){
            if(!(options.allowEmpty && element.value === "")) {
                element.value = parseFloat(element.value) || '0';
            }
        }else{
            element.value = options.value;
        }
        //set to minimum if smaller
        if(options.minValue)
        {
            if(parseFloat(element.value) < parseFloat(options.minValue))
            {
                element.value = options.minValue;
            }
        }
        //check negative if minimum is not set
        else if (!options.allowNegative && parseFloat(element.value) < 0) 
        {
            element.value = '0';
        }

        element.writeAttribute('autocomplete', 'off');
        // button Styles
        var buttonStyles = { height:'10px', cursor:'default', textAlign:'center', width:'7px', fontSize:'9px', paddingLeft:'4px', paddingRight:'2px', border:'1px solid #ccc', background:'#f5f5f5'};
        var spinnerContainer = new Element('div', {tabindex:'1'});
        if(options.cssFloat){
            spinnerContainer.setStyle({cssFloat:options.cssFloat, marginRight:'5px'});
        }

        spinnerContainer.setStyle({width:options.width+"px"});


        var spinnerTable, tbody, tr, tr2, inputTD, upTD, downTD; // define values

        spinnerTable = new Element('table', {className: 'form-spinner', cellpadding:0, cellspacing:0, border:0, height:20, width:options.width});
        tbody = new Element('tbody').insert(tr = new Element('tr'));

        spinnerContainer.insert(spinnerTable);
        spinnerTable.insert(tbody);

        element.parentNode.replaceChild(spinnerContainer, element);
        // Construcy the up button
        tr.insert(inputTD = new Element('td', {className: 'form-spinner-input-td', rowspan:2}).insert(element)).insert(upTD = new Element('td', {className: 'form-spinner-up'}).insert(new Element('img', {src:options.imgPath+'bullet_arrow_up.png', align:'right'})));
        // Construct the down button
        tbody.insert(tr2 = new Element('tr').insert(downTD = new Element('td', {className: 'form-spinner-down'}).insert(new Element('img', {src:options.imgPath+'bullet_arrow_down.png', align:'right'}))));

        spinnerTable.setStyle({border:'1px solid #ccc', borderCollapse:'collapse', background:'#fff' /*, width:'100%'*/ });
        upTD.setStyle(buttonStyles);
        downTD.setStyle(buttonStyles);
        inputTD.setStyle({paddingRight:'2px'});
        element.setStyle({height:'100%', width:'100%', border:'none', padding:'0px', fontSize:'14px', textAlign:'right', outline:'none'});

        /**
         * Up click handler
         */
        var numberUP = function(e){
            if(!parseFloat(element.value)){
                element.value = 0;
            }
            if(options.maxValue && Number(element.value) >= Number(options.maxValue)){ return; } // Don't go up to maxValue
            element.value = parseFloat(element.value)+parseFloat(options.addAmount);
            options.onChange(element.value);
        };
        /**
         * Down click handler
         */
        var numberDOWN = function(e){
            if(!parseFloat(element.value)){
                element.value = 0;
            }
            var newValue = parseFloat(element.value)-parseFloat(options.addAmount);
            if(options.minValue) { // Don't go below to minValue
                if(Number(newValue) < Number(options.minValue)){ return; }
            }  
            else if(!options.allowNegative && newValue < 0){ return; } // Don't go negative
            element.value = newValue;
            options.onChange(element.value);
        };
        /**
         * Handle key events
         * @param {Object} e
         * @param {Object} mode
         */
        var spinnerKeys = function(e, mode){
            if(e.target.tagName == "INPUT" && mode == 2){ return; }
            e = document.getEvent(e);
            if(e.keyCode == 38){
                numberUP(e);
            }else if(e.keyCode == 40){
                numberDOWN(e);
            }
        };

        upTD.observe('click', function(e){
            numberUP(e);
            element.run('keyup');
        }).setUnselectable();

        downTD.observe('click', function(e){
            numberDOWN(e);
            element.run('keyup');
        }).setUnselectable();

        element.observe(Prototype.Browser.Gecko? 'keypress' : 'keydown', function(e){ spinnerKeys(e, 1); });
        spinnerContainer.observe(Prototype.Browser.Gecko? 'keypress' : 'keydown', function(e){ spinnerKeys(e, 2); });
        if(options.readonly){
            element.writeAttribute('readonly', "readonly");
        }

        element.observe('change', function(){
            options.onChange(element.value);
        });

        return element;
    },
    /**
     * Adds color picker to an input filed
     * @param {Object} element
     * @param {Object} options
     */
    colorPicker:function(element, options){
        options = Object.extend({
            title:'Pick a Color',
            background:'#eee',
            trigger: false,
            onPicked: Prototype.K, // Run when user clicked on a color
            onComplete: Prototype.K, // Run when user clicked OK button
            onStart: Prototype.K,
            onEnd: Prototype.K
        }, options || {});

        /**
         * Sort color by their values
         * @param {Object} cols
         */
        function sortColors(cols){
            var obj = {};
            $H(cols).sortBy(function(p){
                var rgb = Protoplus.Colors.hexToRgb(p.value);
                return rgb[0] + rgb[1] + rgb[2];
            }).each(function(item){obj[item[0]] = item[1];});
            return obj;
        }

        $(options.trigger || element).observe('click', function(){

            if(options.onStart() === false){ // User may want to check before open the box
                element.colorPickerEnabled = false;
                return element;
            }

            var validCSSColors =  Protoplus.Colors.getPalette(); // */ sortColors(Protoplus.Colors.colorNames);
            //$R(1, 7).each(function(i){ validCSSColors['blank'+i] = false; }); // Add blank colors
            if(element.colorPickerEnabled){ return false; }
            var colorTD, colorTD2, selectTD, tr, colorTR, selectTR, tbody;
            var table = new Element('table', { cellpadding:4, cellspacing:0, border:0, width:140 }).setStyle({zIndex:100000}).insert(tbody = new Element('tbody'));
            if(options.className){
                table.addClassName(options.className);
            }else{
                table.setStyle({background:options.background,outline:'1px solid #aaa',border:'1px solid #fff'});
            }

            tbody.insert(tr = new Element('tr').insert(new Element('th', {className:'titleHandler', colspan:'2', height: '10'}).setText(options.title).setStyle({paddingTop:'2px', paddingBottom:'0px', color:'#333', fontSize:'14px'})))
                 .insert(colorTR = new Element('tr')).insert(selectTR = new Element('tr'));

            colorTR.insert(colorTD = new Element('td'));
            colorTR.insert(colorTD2 = new Element('td'));
            selectTR.insert(selectTD = new Element('td', {colspan:2}));
            var box = new Element('input', {type:'text'}).setStyle({width:'48px', margin:'1px'});
            box.observe('keyup', function(){
                box.setStyle({background:box.value, color:Protoplus.Colors.invert(box.value)});
            });

            var flip = new Element('input', {type:'button', value:'Flip'});
            flip.observe('click', function(){
                var sc = overFlowDiv.getScroll();
                scr = 0;
                if(sc.y >= 0)  { scr = 140; }
                if(sc.y >= colorTable.getHeight()-140){
                    scr = 0;
                }else{
                    scr = sc.y + 140;
                }
                overFlowDiv.shift({scrollTop:scr, link:'ignore', duration:0.3});
            });

            var OK = new Element('input', {type:'button', value:'OK'}).observe('click', function(){
                if(element.tagName == "INPUT"){
                    element.value = box.value;
                    element.focus();
                }
                table.remove();
                setTimeout(function(){
                    element.colorPickerEnabled = false;
                    options.onComplete(box.value, element, table);
                }, 100);
            });

            if(options.buttonClass){
                 $(flip, OK).invoke('addClassName', options.buttonClass);
            }else{
                 $(flip, OK).invoke('setStyle', {padding:'1px', margin:'1px', background:'#f5f5f5', border:'1px solid #ccc'});
            }

            element.closeColorPicker = function(){
                OK.run('click');
            };

            selectTD.insert(box).insert(flip).insert(OK);
            var colorTable = new Element('table', { cellpadding:0, cellspacing:0, border:0, width:140 });
            var colorTbody = new Element('tbody'), colCount = 0, colTR;

            $H(validCSSColors).each(function(color){
                if(colCount == 7){ colCount = 0; }
                if(colCount++ === 0){
                    colTR = new Element('tr');
                    colorTbody.insert(colTR);
                }
                var tdSize = 20;

                var pick = function(e){
                    box.value = color.value;
                    box.setStyle({background:box.value, color:Protoplus.Colors.invert(box.value)});
                    options.onPicked(box.value, element, table);
                };

                if(color.value === false){
                    colTR.insert(new Element('td', {width:tdSize, height:tdSize}).setStyle({background:'#fff'}).setStyle({/*borderRight:'1px solid #999', borderBottom:'1px solid #999'*/}));
                }else{
                    colTR.insert(new Element('td', {width:tdSize, height:tdSize}).setStyle({background:color.value}).observe('click', pick).tooltip(color.value, {delay:0.6, width:'auto'}));
                }
            });
            colorTable.insert(colorTbody);

            var overFlowDiv = new Element('div').setStyle({outline:'1px solid #fff', border:'1px solid #666', overflow:'hidden', height:'140px'});
            var preTable = new Element('table', {cellPadding:0, cellspacing:0, width:40}).setStyle({outline:'1px solid #fff', border:'1px solid #666', overflow:'hidden', height:'140px'});
            var preTbody = new Element('tbody');
            preTable.insert(preTbody);
            colorTD2.insert(preTable);
            colorTD.insert(overFlowDiv.insert(colorTable));
            var preColors = [
                ["Black:#000000", "Navy:#000080"],
                ["Blue:#0000FF", "Magenta:#FF00FF"],
                ["Red:#FF0000", "Brown:#A52A2A"],
                ["Pink:#FFC0CB", "Orange:#FFA500"],
                ["Green:#008000", "Yellow:#FFFF00"],
                ["Gray:#808080", "Turquoise:#40E0D0"],
                ["Cyan:#00FFFF", "White:#FFFFFF"]
            ];
            $R(0, 6).each(function(i){
                var tr = new Element('tr');
                preTbody.insert(tr);
                tr.insert(new Element('td', {height:20, width:20}).setText('&nbsp;').setStyle({background:preColors[i][0].split(':')[1]}).tooltip(preColors[i][0].split(':')[0], {delay:0.6, width:'auto'}).observe('click', function(){
                    box.value = preColors[i][0].split(':')[1];
                    box.setStyle({background:box.value, color:Protoplus.Colors.invert(box.value)});
                    options.onPicked(box.value, element, table);
                }));
                tr.insert(new Element('td', {height:20, width:20}).setText('&nbsp;').setStyle({background:preColors[i][1].split(':')[1]}).tooltip(preColors[i][1].split(':')[0], {delay:0.6, width:'auto'}).observe('click', function(){
                    box.value = preColors[i][1].split(':')[1];
                    box.setStyle({background:box.value, color:Protoplus.Colors.invert(box.value)});
                    options.onPicked(box.value, element, table);
                }));
            });

            var top = element.cumulativeOffset().top+element.getHeight();
            var left = element.cumulativeOffset().left;
            table.setStyle({position:'absolute', top:top + 3 +"px", left:left + 2 +'px'});

            table.setDraggable({handler: table.select('.titleHandler')[0] , dragEffect:false});

            $(document.body).insert(table);

            options.onEnd(element, table);

            overFlowDiv.setScroll({y:'0'});
            element.colorPickerEnabled = true;
        });
        return element;
    },

    /**
     * New Version of color picker
     * @param {Object} element
     * @param {Object} options
     */
    colorPicker2: function(element, options){

        options = Object.extend({
            onStart: Prototype.K,
            onEnd: Prototype.K,
            trigger: false,
            onPicked: Prototype.K,
            onComplete: Prototype.K,
            hideOnBlur: false,
            buttonClass:'big-button buttons'
        }, options || {});
        
        var customColorHex;
        
        $(options.trigger || element).observe('click', function(){
            var docEvent = false;

            if(element.colorPickerEnabled){ return element; }

            if (options.onStart() === false) {
                return element;
            }

            if(options.hideOnBlur){
                setTimeout(function(){
                    docEvent = Element.on(document, 'click', function(e){
                        var el = Event.findElement(e, '.plugin, ');
                        if(!el){ element.closeColorPicker(); }
                    });
                }, 0);
            }

            element.colorPickerEnabled = true;

            var scrollOffset = element.cumulativeScrollOffset();

            var stop = 1;
            var top  = element.measure('cumulative-top')+2;
            var left = element.measure('cumulative-left')+1 - scrollOffset.left ;
            var height = element.measure('border-box-height');

            // Create elements
            var plugin      = new Element('div',    {className:'plugin edit-box'});
            var plugCUR     = new Element('div',    {className:'plugCUR'});
            var plugHEX     = new Element('input',  {type:'text', size:'10', className:'plugHEX'});
            var SV          = new Element('div',    {className:'SV'}).setUnselectable();
            var SVslide     = new Element('div',    {className:'SVslide'});
            var H           = new Element('form',   {className:'H'}).setUnselectable();
            var Hslide      = new Element('div',    {className:'Hslide'});
            var Hmodel      = new Element('div',    {className:'Hmodel'});
            var complete    = new Element('button', {type:'button', className:''});

            // Insert them into positions
            plugin.insert('<br>').insert(SV).insert(H);
            plugin.insert(plugCUR).insert(plugHEX.setValue('#FFFFFF')).insert(complete.update('OK'));
            SV.insert(SVslide.update('<br>'));
            H.insert(Hslide.update('<br>')).insert(Hmodel);

            // Set Styles
            plugin.setStyle({position:'absolute', top:(top+height)+'px', left:left+'px', zIndex:'10000000'});
            SVslide.setStyle('top:-4px; left:-4px;');
            Hslide.setStyle('top:0px; left:-8px;');
            complete.setStyle('float:right;margin-top:8px;').addClassName(options.buttonClass);

            // Set Events
            plugin.observe('mousedown', function(e){ HSVslide('drag', plugin, e); });
            plugHEX.observe('mousedown', function(e){ stop=0; setTimeout(function(){ stop=1; },100); });
            plugHEX.observe('keyup', function(){ // Neil: Allow saving custom HEX values
                if (plugHEX.value.length >= 7) {
                    setValue(plugHEX.value);
                }
            });
            plugHEX.observe('click', function(){
                Form.Element.select(this);
            });
            SV.observe('mousedown', function(e){ HSVslide(SVslide, plugin, e);});
            H.observe('mousedown', function(e){  HSVslide(Hslide, plugin, e);});

            complete.observe('click', function(){
                plugin.remove();
                element.colorPickerEnabled=false;
                if(docEvent){
                    docEvent.stop();
                }
                customColorHex = plugHEX.value;
                options.onComplete(plugHEX.value);
            });

            element.closeColorPicker = function(){
                complete.run('click');
            };

            function abPos(o){
                o = (typeof(o) == 'object' ? o : $(o));
                var z = { X: 0, Y: 0};
                while (o !== null) {
                    z.X += o.offsetLeft;
                    z.Y += o.offsetTop;
                    o = o.offsetParent;
                }
                return (z);
            }

            function within(v, a, z){
                return ((v >= a && v <= z) ? true : false);
            }

            function XY(e, v){
                /* var z = Prototype.Browser.IE?
                          [event.clientX + document.body.scrollLeft, event.clientY + document.body.scrollTop] :
                          [e.pageX, e.pageY];*/

                var evt = e || window.event;
                var z = [Event.pointerX(evt), Event.pointerY(evt)];
                v = parseInt(v, 10);
                return (z[!isNaN(v) ? v : 0]);
            }

            /* COLOR PICKER */

            var maxValue = {'H': 360,'S': 100,'V': 100};
            var HSV = { H: 360, S: 100, V: 100};
            var slideHSV = { H: 360, S: 100, V: 100 };

            function HSVslide(d, o, e){

                function tXY(e){
                    tY = XY(e, 1) - ab.Y;
                    tX = XY(e) - ab.X;
                }
                function mkHSV(a, b, c){
                    return (Math.min(a, Math.max(0, Math.ceil((parseInt(c, 10) / b) * a))));
                }

                function ckHSV(a, b){
                    if (within(a, 0, b)) { return (a); }
                    else if (a > b) { return (b); }
                    else if (a < 0) { return ('-' + oo); }
                }

                function drag(e){
                    if (!stop) {

                        if (d != 'drag') {
                            tXY(e);
                        }

                        if (d == SVslide) {
                            ds.left = ckHSV(tX - oo, 162) + 'px';
                            ds.top  = ckHSV(tY - oo, 162) + 'px';
                            slideHSV.S = mkHSV(100, 162, ds.left);
                            slideHSV.V = 100 - mkHSV(100, 162, ds.top);

                            HSVupdate();

                        } else if (d == Hslide) {
                            var ck = ckHSV(tY - oo, 163), r = 'HSV', z = {};

                            ds.top = (ck) + 'px';
                            slideHSV.H = mkHSV(360, 163, ck);
                            z.H = maxValue.H - mkHSV(maxValue.H, 163, ck);
                            z.S = HSV.S;
                            z.V = HSV.V;

                            HSVupdate(z);
                            SV.style.backgroundColor = '#' + color.HSV_HEX({
                                H: HSV.H,
                                S: 100,
                                V: 100
                            });

                        } else if (d == 'drag') {
                            ds.left = XY(e) + oX - eX + 'px';
                            ds.top = XY(e, 1) + oY - eY + 'px';
                        }
                    }
                }

                if (stop) {
                    stop = '';
                    var ds = $(d != 'drag' ? d : o).style;

                    if (d == 'drag') {
                        var oX = parseInt(ds.left, 10), oY = parseInt(ds.top, 10), eX = XY(e), eY = XY(e, 1);
                    } else {
                        var ab = abPos($(o)), tX, tY, oo = (d == Hslide) ? 0 : 4;
                        ab.X += 10;
                        ab.Y += 22;
                        if (d == SVslide) {
                            slideHSV.H = HSV.H;
                        }
                    }

                    document.onmousemove = drag;
                    document.onmouseup = function(){
                        stop = 1;
                        document.onmousemove = '';
                        document.onmouseup = '';
                    };
                    drag(e);

                }
            }

            function HSVupdate(v){
                v = HSV = v ? v : slideHSV;
                v = color.HSV_HEX(v);
                plugHEX.value = '#' + v;
                plugCUR.style.background = '#' + v;
                if(element.tagName == 'BUTTON'){
                    element.__colorvalue = '#' + v;
                }else{
                    element.value = '#' + v;
                }
                options.onPicked('#' + v, element, plugin);
                return (v);

            }

            function setValue(colorcode){
                if("transparent".search(colorcode) == -1) { //Neil: do not update color palette if user is typing "transparent"
                    var rgb = Protoplus.Colors.getRGBarray(colorcode);
                    var hsv = color.RGB_HSV(rgb[0], rgb[1], rgb[2]);

                    SV.style.backgroundColor = '#' + color.HSV_HEX({H:hsv.H, S:100, V:100});
                    Hslide.style.top = Math.abs(Math.ceil((hsv.H * 163) / 360) - 163)+"px";

                    var t = Math.abs((Math.floor((hsv.V * 162) / 100)) -162);
                    var l = Math.abs((Math.floor((hsv.S * 162) / 100)));
                    if(t <= 0){ t = t-4; }
                    if(l <= 0){ l = l-4; }

                    SVslide.style.top  = t+"px";
                    SVslide.style.left = l+"px";

                    HSVupdate(hsv);
                }
            }

            element.setColorPickerValue = setValue;

            function loadSV(){
                var z = '';

                for (var i = 165; i >= 0; i--) {
                    z += "<div style=\"BACKGROUND: #" + color.HSV_HEX({
                        H: Math.round((360 / 165) * i),
                        S: 100,
                        V: 100
                    }) + ";\"><br /><\/div>";
                }
                Hmodel.innerHTML = z;
            }

            /* COLOR LIBRARY */
            var color = {
                cords: function(W){
                    var W2 = W / 2, rad = (hsv.H / 360) * (Math.PI * 2), hyp = (hsv.S + (100 - hsv.V)) / 100 * (W2 / 2);
                    $('mCur').style.left = Math.round(Math.abs(Math.round(Math.sin(rad) * hyp) + W2 + 3)) + 'px';
                    $('mCur').style.top = Math.round(Math.abs(Math.round(Math.cos(rad) * hyp) - W2 - 21)) + 'px';

                },
                HEX: function(o){
                    o = Math.round(Math.min(Math.max(0, o), 255));
                    return ("0123456789ABCDEF".charAt((o - o % 16) / 16) + "0123456789ABCDEF".charAt(o % 16));
                },
                RGB_HSV: function (r, g, b){
                    r = r/255;
                    g = g/255;
                    b = b/255;
                    var max = Math.max(r, g, b), min = Math.min(r, g, b);
                    var h, s, v = max;

                    var d = max - min;
                    s = max === 0 ? 0 : d / max;

                    if(max == min){
                        h = 0; // achromatic
                    }else{
                        switch(max){
                            case r: h = (g - b) / d + (g < b ? 6 : 0); break;
                            case g: h = (b - r) / d + 2; break;
                            case b: h = (r - g) / d + 4; break;
                        }
                        h /= 6;
                    }

                    return {H:h*360, S:s*100, V:v*100};
                },
                RGB_HEX: function(o){
                    var fu = color.HEX;
                    return (fu(o.R) + fu(o.G) + fu(o.B));
                },
                HSV_RGB: function(o){

                    var R, G, A, B, C, S = o.S / 100, V = o.V / 100, H = o.H / 360;

                    if (S > 0) {
                        if (H >= 1) {
                            H = 0;
                        }

                        H = 6 * H;
                        F = H - Math.floor(H);
                        A = Math.round(255 * V * (1 - S));
                        B = Math.round(255 * V * (1 - (S * F)));
                        C = Math.round(255 * V * (1 - (S * (1 - F))));
                        V = Math.round(255 * V);

                        switch (Math.floor(H)) {
                            case 0: R = V; G = C; B = A; break;
                            case 1: R = B; G = V; B = A; break;
                            case 2: R = A; G = V; B = C; break;
                            case 3: R = A; G = B; B = V; break;
                            case 4: R = C; G = A; B = V;break;
                            case 5: R = V;G = A;B = B;break;
                        }

                        return ({
                            'R': R ? R : 0,
                            'G': G ? G : 0,
                            'B': B ? B : 0,
                            'A': 1
                        });

                    } else {
                        return ({ 'R': (V = Math.round(V * 255)), 'G': V, 'B': V, 'A': 1 });
                    }
                },
                HSV_HEX: function(o){
                    return (color.RGB_HEX(color.HSV_RGB(o)));
                }
            };

            $(document.body).insert(plugin);
            loadSV();
            if(customColorHex == 'transparent'){ //Neil:  if user entered transparent, do not execute setValue
                plugHEX.value = customColorHex;
            }
            else {
            setValue(element.__colorvalue || element.value || "#FFFFFF");
            }
            options.onEnd(element, plugin);
            return element;
        });
    },
    /**
     * Places a small label boz at the specified position on an input box
     * @param {Object} element
     * @param {Object} label
     * @param {Object} options
     */
    miniLabel:function(element, label, options){
        options = Object.extend({
            position: 'bottom',
            color: '#666',
            size: 9,
            text:'',
            nobr: false
        }, options || {});
        element.wrap('span');
        span = $(element.parentNode);
        span.setStyle({whiteSpace:'nowrap', cssFloat:'left', marginRight:'5px'});
        var labelStyle = {paddingLeft:'1px', fontSize:options.size+"px", color:options.color, cursor:'default'};
        var labelClick = function(){
            element.focus();
        };
        var br = '<br>';

        if(options.nobr){
            br = '';
        }

        if(options.position == "top"){
            element.insert({before:new Element('span').setText(label+br).setStyle(labelStyle).observe('click', labelClick)}).insert({after:options.text});
        }else{
            element.insert({after:new Element('span').setText(br+label).setStyle(labelStyle).observe('click', labelClick)}).insert({after:options.text});
        }

        return span;
    },
    /**
     * Places hint texts into input boxes
     * @param {Object} element
     * @param {Object} value
     */
    hint: function(element, value, options){
        element = $(element);

        if("placeholder" in element){
            element.writeAttribute('placeholder', value);
            return element;
        }

        if(element.type == 'number'){ element.value="0"; return element; }

        if(element.removeHint){
            return element.hintClear();
        }

        options = Object.extend({
            hintColor:'#bbb'
        }, options || {});

        var color = element.getStyle('color') || '#000';

        if (element.value === '') {
            element.setStyle({color:options.hintColor});
            element.value = value;
            element.hinted = true;
        }
        var focus = function(){
            if(element.value == value){
                element.value = "";
                element.setStyle({color:color}).hinted = false;
            }
        };

        var blur = function(){
            if(element.value === ""){
                element.value = value;
                element.setStyle({ color:options.hintColor }).hinted = true;
            }
        };

        var submit = function(){
            if(element.value == value){
                element.value = "";
                element.hinted = false;
            }
        };

        element.observe('focus', focus);
        element.observe('blur', blur);

        if(element.form){
            $(element.form).observe('submit', submit);
        }

        element.runHint = blur;

        element.clearHint = function(){
            element.value = "";
            element.setStyle({color:color}).hinted = false;
        };

        element.hintClear = function(){
            element.value = value;
            element.setStyle({ color:options.hintColor }).hinted = true;
            return element;
        };

        element.removeHint = function(){
            element.setStyle({color:color});

            if(element.value == value){
                element.value = "";
            }
            element.hintClear = undefined;
            element.hinted = undefined;
            element.removeHint = undefined;

            element.stopObserving('focus', focus);
            element.stopObserving('blur', blur);

            if(element.form){
                $(element.form).stopObserving('submit', submit);
            }
            return element;
        };

        return element;
    },
    /**
     * Makes element resizable
     * @param {Object} element
     * @param {Object} options
     */
    resizable:function(element, options){
        options = Object.extend({
            sensitivity: 10,
            overflow:0,
            onResize: Prototype.K,
            onResizeEnd: Prototype.K,
            imagePath:'images/resize.png',
            element:false,
            maxHeight:false,
            minHeight:false,
            maxWidth:false,
            minWidth:false,
            maxArea: false,
            autoAdjustOverflow: true,
            constrainViewport:true,
            constrainParent:false,
            keepAspectRatio:false,
            displayHandlers:true
        }, options, {});

        var handlerElem = $(element);

        if(options.element){
            element = $(options.element);
        }else{
            element = $(element);
        }

        element.resized = true;

        var elementPos = handlerElem.getStyle('position');
        if(!elementPos || elementPos == 'static'){
            handlerElem.setStyle({position:'relative'});
        }
        var ratio;

        var firstDim = element.getDimensions();

        var paddings = {
            top:  (parseInt(element.getStyle('padding-top'), 10) || 0) + (parseInt(element.getStyle('padding-bottom'), 10) || 0),
            left: (parseInt(element.getStyle('padding-left'), 10) || 0) + (parseInt(element.getStyle('padding-right'), 10) || 0)
        };

        // Handlers
        var handler = new Element('div'), rightHandler = new Element('div'), bottomHandler = new Element('div');

        handler.setStyle({ height:options.sensitivity+'px',width:options.sensitivity+'px', position:'absolute',bottom:'-'+options.overflow+'px',right:'-'+options.overflow+'px',cursor:'se-resize', zIndex:10000 });
        rightHandler.setStyle({ height: '100%', width:options.sensitivity+'px',position:'absolute',top:'0px',right:'-'+options.overflow+'px',cursor:'e-resize', zIndex:10000 });
        bottomHandler.setStyle({ height:options.sensitivity+'px', width: '100%', position:'absolute',bottom:'-'+options.overflow+'px', left:'0px', cursor:'s-resize', zIndex:10000 });

        handler.setStyle({ background: 'url('+options.imagePath+') no-repeat bottom right' });
        //rightHandler.setStyle({ background: 'url('+options.imagePath+') no-repeat right center' });
        //bottomHandler.setStyle({ background: 'url('+options.imagePath+') no-repeat center bottom ' });

        // Debugging styles
        // handler.setStyle({ borderBottom: '1px dashed #333', borderRight: '1px dashed #333', background: '' });
        // rightHandler.setStyle({ borderRight: '1px dashed #333', background: '' });
        // bottomHandler.setStyle({ borderBottom: '1px dashed #333', background: '' });

        var resize = function(e, type){
            e.stop();
            document.stopDrag = true;
            handlerElem.setUnselectable();
            $(document.body).setUnselectable();
            var sDim = $H(element.getDimensions()).map(function(d){
                if(d.key == "height"){
                    return d.value - paddings.top;
                }else if(d.key == "width"){
                    return d.value - paddings.left;
                }
                return d.value;
            });
            var startDim = {
                height: sDim[1],
                width: sDim[0]
            };

            if(options.keepAspectRatio){
                ratio = Math.abs(startDim.height / startDim.width);
            }

            var offs = element.cumulativeOffset();
            var pdim = $(element.parentNode).getDimensions();
            var poff = $(element.parentNode).cumulativeOffset();
            var mouseStart = { top:Event.pointerY(e), left:Event.pointerX(e) };
            var dim = document.viewport.getDimensions();
            var overflowHeight = "";
            var overflowWidth = "";

            switch(type){
                case "both":
                    handler.setStyle('height:100%; width:100%');
                break;
                case "horizontal":
                    rightHandler.setStyle({width:'100%'});
                break;
                case "vertical":
                    bottomHandler.setStyle({height:'100%'});
                break;
            }


            var setElementSize = function(dims){
                var height = dims.height;
                var width = dims.width;
                var type = dims.type || 'both';

                if(height){
                    height = (options.maxHeight && height >= options.maxHeight)? options.maxHeight : height;
                    height = (options.minHeight && height <= options.minHeight)? options.minHeight : height;
                    if(options.maxArea){
                        if(height * element.getWidth() >= options.maxArea){ return; }
                    }

                    element.setStyle({height:height+"px"});
                }

                if(width){
                    width = (options.maxWidth && width >= options.maxWidth)? options.maxWidth : width;
                    width = (options.minWidth && width <= options.minWidth)? options.minWidth : width;
                    if(options.maxArea){
                        if(element.getHeight()*width >= options.maxArea){ return; }
                    }

                    element.setStyle({width: width + "px"});
                }



                options.onResize((height || startDim.height) + paddings.top, (width || startDim.width) + paddings.left, type );
            };

            var mousemove = function(e){
                e.stop();
                if(type != "horizontal"){
                    var height = startDim.height + (Event.pointerY(e) - mouseStart.top);
                    var hskip = false;

                    if (options.constrainViewport) {
                        hskip = ((height + offs.top) >= (dim.height - 3));
                    }

                    if(options.constrainParent){
                        hskip = ((height + offs.top + paddings.top) >= (pdim.height+poff.top - 3));
                        if(hskip){
                            setElementSize({height: (pdim.height + poff.top - 3 ) - (offs.top + paddings.top + 3), type: type});
                        }
                    }

                    if(!hskip){
                        setElementSize({ height: height, type: type });
                        if(options.keepAspectRatio){
                            setElementSize({width: height / ratio, type: type });
                        }
                    }
                }

                if (type != "vertical") {
                    var width = startDim.width + (Event.pointerX(e) - mouseStart.left);
                    var wskip = false;
                    if (options.constrainViewport) {
                        wskip = ((width + offs.left) >= (dim.width - 3));
                    }

                    if(options.constrainParent){
                        wskip = ((width + offs.left + paddings.left) >= (pdim.width + poff.left - 3));
                        if(wskip){
                            setElementSize({width: (pdim.width + poff.left - 3 ) - (offs.left + paddings.left + 3), type: type});
                        }
                    }

                    if(!wskip){
                        setElementSize({width: width, type: type});
                        if(options.keepAspectRatio){
                            setElementSize({height: width * ratio, type: type });
                        }
                    }
                }

            };

            var mouseup = function(){

                handler.setStyle({height:options.sensitivity+'px',width:options.sensitivity+'px'});
                rightHandler.setStyle({width:options.sensitivity+'px'});
                bottomHandler.setStyle({height:options.sensitivity+'px'});

                document.stopObserving('mousemove', mousemove).stopObserving('mouseup', mouseup).stopDrag = false;
                handlerElem.setSelectable();
                options.onResizeEnd(element.getHeight(), element.getWidth());
                /*
                if(options.autoAdjustOverflow){

                    var o;
                    if(o = element.isOverflow()){
                        if(o.top){
                            element.setStyle('height:'+ (element.getHeight() + o.top) +"px");
                        }
                        if(o.left){
                            element.setStyle('width:'+(element.getWidth() + o.left)+"px");
                        }
                    }
                }
                */
                $(document.body).setSelectable();
            };

            document.observe('mousemove', mousemove).observe('mouseup', mouseup);
            return false;
        };

        handler.observe('mousedown', function(e){ resize(e, 'both'); });
        rightHandler.observe('mousedown', function(e){ resize(e, 'horizontal'); });
        bottomHandler.observe('mousedown', function(e){ resize(e, 'vertical'); });

        element.hideHandlers = function(){
            handler.hide();
            rightHandler.hide();
            bottomHandler.hide();
        };

        element.showHandlers = function(){
            handler.show();
            rightHandler.show();
            bottomHandler.show();
        };

        // Insert handlers
        handlerElem.insert(bottomHandler).insert(rightHandler).insert(handler);

        return handlerElem;
    },
    positionFixed: function(element, options){
        element = $(element);
        // Should check for IE6
        /*if(Prototype.Browser.IE){
            return element.keepInViewport(options);
        }*/
        options = Object.extend({
            offset: 10, // left, top
            onPinned: Prototype.K,
            onUnpinned: Prototype.K,
            onBeforeScroll: Prototype.K,
            onBeforeScrollFail: Prototype.K,
            onScroll: Prototype.K
        }, options || {});

        var off  = element.cumulativeOffset();
        var sOff = element.cumulativeScrollOffset();
        var top = off.top + sOff.top;
        var left = off.left + sOff.left;

        var onScroll = function(){
            if(element.pinned){ return true; }

            var style = {};
            var bodyOff = $(document.body).cumulativeScrollOffset();
            //if(sOff.top < options.offset){ options.offset = sOff.top; }

            if(top <= bodyOff.top + options.offset){
                style = {position:'fixed', top: options.offset+'px'};
            }else{
                style = {position:'absolute', top:top+'px'};
            }

            if(options.onBeforeScroll(element, parseInt(style.top, 10), bodyOff.top) !== false){
                element.setStyle(style);
                options.onScroll(element, bodyOff.top);
            }else{
                if(element.style.position == "fixed"){
                    element.setStyle({position:'absolute', top:bodyOff.top+options.offset+'px'});
                    options.onBeforeScrollFail(element, parseInt(style.top, 10), bodyOff.top);
                }
            }
        };

        // Pins the element where it is located
        element.pin = function(){
            var bodyOff = $(document.body).cumulativeScrollOffset();
            element.style.top = bodyOff.top + options.offset + 'px';
            element.style.position = 'absolute';
            options.onPinned(element);
            element.pinned = true;
        };

        // Check if the element is pinned
        element.isPinned = function(){ options.onPinned(element); return element.pinned; };

        // Sets the element free
        element.unpin = function(){
            element.pinned = false;
            // Run the scroll Event when unpinned
            onScroll();
            options.onUnpinned(element);
        };

        element.updateScroll = onScroll;

        /**
         * Updates the max and left limits. Suitable for draggable elements
         */
        element.updateTop = function(topLimit){
            top = topLimit;
            return element;
        };

        // Set the scroll Event
        Event.observe(window, 'scroll', onScroll);
        return element;
    },
    /**
     * Keeps the element in the position
     * @param {Object} element
     * @param {Object} options
     */
    positionFixedBottom: function(element, options){
        element = $(element);
        options = Object.extend({
            offset: 0, // left, top
            onPinned: Prototype.K,
            onUnpinned: Prototype.K,
            onBeforeScroll: Prototype.K,
            onScroll: Prototype.K
        }, options || {});

        var off  = element.cumulativeOffset();
        var sOff = element.cumulativeScrollOffset();
        var top = off.top + sOff.top;
        var h = element.getHeight();
        var left = off.left + sOff.left;

        var onScroll = function(){
            if(element.pinned){ return true; }

            var style = {};
            var bodyOff = $(document.body).cumulativeScrollOffset();
            //if(sOff.top < options.offset){ options.offset = sOff.top; }

            if(top + h >= bodyOff.top + options.offset){
                style = {position:'fixed', bottom: options.offset+'px'};
            }else{
                if(element.style.position == "fixed"){
                    element.setStyle({position:'absolute', top:bodyOff.top+options.offset+'px'});
                    options.onBeforeScrollFail(element, parseInt(style.top, 10), bodyOff.top);
                }
            }
        };
        onScroll();
        // Pins the element where it is located
        element.pin = function(){
            var bodyOff = $(document.body).cumulativeScrollOffset();
            element.style.top = bodyOff.top + options.offset + 'px';
            element.style.position = 'absolute';
            options.onPinned(element);
            element.pinned = true;
        };

        // Check if the element is pinned
        element.isPinned = function(){ options.onPinned(element); return element.pinned; };

        // Sets the element free
        element.unpin = function(){
            element.pinned = false;
            // Run the scroll Event when unpinned
            onScroll();
            options.onUnpinned(element);
        };

        element.updateScroll = onScroll;

        /**
         * Updates the max and left limits. Suitable for draggable elements
         */
        element.updateTop = function(topLimit){
            top = topLimit;
            return element;
        };

        // Set the scroll Event
        Event.observe(window, 'scroll', onScroll);
        return element;
    },
    /**
     * Keeps the element in viewport when the page is scrolled
     * @param {Object} element
     * @param {Object} options
     */
    keepInViewport: function(element, options){
        element = $(element);
        options = Object.extend({
            offset: [10, 10], // left, top
            offsetLeft: false,
            offsetTop: false,
            delay: 0.1,
            onPinned: Prototype.K,
            onUnpinned: Prototype.K,
            onBeforeScroll: Prototype.K,
            onScroll: Prototype.K,
            smooth: false,
            horzontal: false,
            vertical: true,
            animation: { duration: 0.2, easing:'sineOut' },
            topLimit: parseInt(element.getStyle('top') || 0, 10),
            leftLimit: parseInt(element.getStyle('left') || 0, 10)
        }, options || {});

        // Just in case, to protect the animation config
        options.animation = Object.extend({ duration: 0.4 }, options.animation || {});
        options.delay *= 1000;

        if(typeof options.offset == 'number'){
            options.offsetLeft = options.offset;
            options.offsetTop = options.offset;
        }else{
            options.offsetLeft = options.offset[0];
            options.offsetTop = options.offset[1];
        }

        var timer = false;
        var onScroll =  function(e) {

            if(element.pinned){ return true; }
            if(timer){ clearTimeout(timer); }

            var anim = options.animation;

            var doScroll = function(){

                var off  = /* {top: element.scrollTop || 0, left:element.scrollLeft || 0}; // */ element.cumulativeOffset();
                var sOff = /* {top:window.scrollY || 0, left:window.scrollX || 0}; // */ element.cumulativeScrollOffset();
                var toff = options.offsetTop;
                var loff = options.offsetLeft;

                if(sOff.top < toff){ toff = sOff.top; }
                if(sOff.left < loff){ loff = sOff.left; }

                if (options.vertical) {
                    if (sOff.top >= off.top - toff) {
                        if (sOff.top > 0) {
                            anim.top = sOff.top + toff + 'px';
                        }
                    }else {
                        if (off.top != options.topLimit) {
                            if (sOff.top + toff > options.topLimit) {
                                anim.top = sOff.top + toff + 'px';
                            }else {
                                anim.top = options.topLimit + 'px';
                            }
                        }
                    }
                }

                if(options.horizontal){
                    if(sOff.left >= off.left - loff){
                        if(sOff.left > 0){
                            anim.left = sOff.left  + loff + 'px';
                        }
                    }else{
                        if(off.left != options.leftLimit ){
                            if(sOff.left + loff > options.leftLimit){
                                anim.left = sOff.left + loff + 'px';
                            }else{
                                anim.left = options.leftLimit+'px';
                            }
                        }
                    }
                }

                if (options.onBeforeScroll(element, parseInt(anim.top, 10) || 0, parseInt(anim.left, 10) || 0) !== false) {
                    // Move the elements
                    if (options.smooth) {
                        anim.onEnd = function(){ options.onScroll(element, anim.top, anim.left); };
                        element.shift(anim);
                    }else {
                        element.style.left = anim.left;
                        element.style.top = anim.top;
                        options.onScroll(element, anim.top, anim.left);
                    }
                }
            };


            if (options.smooth === false) {
                doScroll();
            }else{
                timer = setTimeout(doScroll, options.delay);
            }
            return element;
        };

        // Pins the element where it is located
        element.pin = function(){ options.onPinned(element);  element.pinned = true; };
        // Check if the element is pinned
        element.isPinned = function(){ return element.pinned; };
        // Sets the element free
        element.unpin = function(){
            element.pinned = false;
            // Run the scroll Event when unpinned
            onScroll();
            options.onUnpinned(element);
        };

        element.update = onScroll;

        /**
         * Updates the max and left limits. Suitable for draggable elements
         */
        element.updateLimits = function(top, left){
            options.topLimit = top || parseInt(element.getStyle('top') || 0, 10);
            options.leftLimit = left || parseInt(element.getStyle('left') || 0, 10);
            return element;
        };
        // Set the scroll Event
        Event.observe(window, 'scroll', onScroll);

        return element;
    },
    /**
     * Converts dropdowns to a stylish boxes
     * @param {Object} element
     * @param {Object} options
     */
    bigSelect: function(element, options){
        element = $(element);
        // Internet Explorer 9 fix. Check back later
        // Disabled for all versions of IE because it's just stupid
        if(!Prototype.Browser.IE9 && !Prototype.Browser.IE10 && Prototype.Browser.IE /*&& Protoplus.getIEVersion() < 8 || Prototype.Browser.IE9*/){
            return element; // Disable this for older versions of IE until we find a solution for z-index bug
        }

        options = Object.extend({
            classpreFix: 'big-select',
            additionalClassName:'',
            onSelect: function(x){ return x; },
            onComplete:  function(x){ return x; }
        }, options || {});

        if (element.selectConverted) {
            element.selectConverted.remove();
        }

        var cont = new Element('div', {className: options.classpreFix+' '+options.additionalClassName, tabIndex:'1'}).setStyle({outline:'none', fontSize: element.getStyle('font-size')});
        var content = new Element('div', {className: options.classpreFix+'-content'});
        var list = new Element('div', {className: options.classpreFix+'-list'}).setStyle('z-index:2000000').hide();
        var arrow = new Element('div', {className: options.classpreFix+'-arrow'});
        var span = new Element('div', {className: options.classpreFix+'-content-span'});

        element.selectConverted = cont;
        cont.setUnselectable();
        if(options.width){
            cont.setStyle({width:options.width});
        }

        if(options.textfield) {
            var textfield;
            cont.insert(textfield = new Element("input", {type:"text", "class":"big-textfield"}).setStyle({width:'168px'}));
            arrow.setStyle({
                position:"absolute",
                top:"1px",
                right:"0px"
            });
            cont.setStyle({border: "none", boxShadow: "none", background : "transparent"});
        } else {
            content.update(span);
            cont.insert(content);
        }

        cont.insert(list).insert(arrow);

        element.insert({before:cont}).hide();
        element.observe('change', function(){
            if(options.textfield) {
                textfield.value = "{" + element.getSelected().value + "}";
            } else {
                span.update(options.onSelect(element.getSelected().text));
            }
        });

        var closeList = function(){
            cont.removeClassName(options.classpreFix+'-open');
            list.hide();
        };

        $A(element.options).each(function(opt){
            if(opt.selected){
                span.update(options.onSelect(opt.text));
            }
            //var li = new Element('li', {value:opt.value}).insert(opt.text);
            var li = document.createElement('li');
            li.setAttribute("value",opt.value.strip(opt.value.stripTags()));
            li.innerHTML = opt.text.escapeHTML();
            
            if(opt.hasClassName("bold")) {
                li.setStyle('color:#555; font-weight:bold;');
            }

            li.hover(function(){
                li.setStyle('background:#ccc');
            }, function(){
                li.setStyle({background: ''});
            });
            li.observe('click', function(){
                span.update(options.onSelect(li.innerHTML, li.readAttribute('value')));
                element.selectOption(li.readAttribute('value'));

                closeList();
            });
            list.appendChild(li);
        });

        cont.observe('blur', function(){
            closeList();
        });

        list.show();
        var currentTop = list.getStyle('top');
        list.hide();


        var toggleList = function(){
            if(list.visible()){
                closeList();
            }else{
                list.show();
                cont.addClassName(options.classpreFix+'-open');
                list.setStyle({height: '', top:currentTop, overflow:'', bottom:'' });
                var vh = document.viewport.getHeight();
                var lt = list.getBoundingClientRect().top;
                var lh = list.getHeight();

                if(vh < lt + lh){
                    if(vh-lt-20 < 150){
                        var h = 'auto';
                        if(lh > lt){
                            h = (lt -10 )+'px';
                        }
                        list.setStyle({bottom: content.getHeight()+'px', top:'auto', height: h, overflow:'auto' });
                    }else{
                        list.setStyle({height: (vh-lt-20)+'px', overflow:'auto' });
                    }
                }
            }
        };

        arrow.observe('click', toggleList);
        content.observe('click', toggleList);
        options.onComplete(cont, element);
        return element;
    },
    rotatingText: function(element, text, options) {
        element = $(element);
        options = Object.extend({
            delimiter: ' - ',
            duration: 150
        }, options || {});

        var orgText = element.innerHTML.strip();
        text += options.delimiter;

        var orgLength = orgText.length;
        var initialText = text.substr(0, orgLength);
        element.innerHTML = initialText;
        var current = 0;
        var interval = setInterval(function() {
            if (current == text.length) {
                current = 0;
                element.innerHTML = text.substr(current++, orgLength);
            }
            else if (current + orgLength > text.length) {
                var toInsert = text.substr(current, orgLength);
                // toInsert += "-" + text.substr(0, orgLength - (text.length - current - 1));
                toInsert += text.substr(0, orgLength - (text.length - current));
                element.innerHTML = toInsert;
                current++;
            }
            else { // current + orgLength
                element.innerHTML = text.substr(current++, orgLength);
            }
        }, options.duration);
        element.rotatingStop = function() {
            clearTimeout(interval);
            element.innerHTML = orgText;
        };
        return element;
    }
};
Element.addMethods(Protoplus.ui);
/// <reference path="../../types/types.d.ts" />
/**
 * JotForm Form object
 */
// eslint-disable-next-line no-var
var JotForm = {
    /**
     * JotForm domain
     * @var String
     */
    url: "//www.jotform.com/", // Will get the correct URL from this.getServerURL() method
    /**
     * JotForm request server location
     * @var String
     */
    server: "//www.jotform.com/server.php", // Will get the correct URL from this.getServerURL() method
    /**
     * JotForm api location
     * @var String
     */
    APIUrl: "//www.jotform.com/API", // Will get the correct URL from this.setAPIUrl() method
    /**
     * All conditions defined on the form
     * @var Object
     */
    conditions: {},
    /**
     * All calculations defined on the form
     * @var Object
     */
    calculations: [],
    /**
     * Condition Values
     * @var Object
     */
    condValues: {},
    /**
     * Coupon applied check to display discounted price
     */
    couponApplied: false,
    /**
     * Progress bar object above form
     * @var Object
     */
    progressBar: false,
    /**
     * All JotForm forms on the page
     * @var Array
     */
    forms: [],
    /**
     * Will this form be saved on page changes
     * @var Boolean
     */
    saveForm: false,
    /**
     * Array of extensions
     * @var Array
     */
    imageFiles: ["png", "jpg", "jpeg", "ico", "tiff", "bmp", "gif", "apng", "jp2", "jfif"],
    /**
     * array of autocomplete elements
     * @var Object
     */
    autoCompletes: {},
    /**
     * Array of default values associated with element IDs
     * @var Object
     */
    defaultValues: {},
    /**
     * Debug mode
     * @var Boolean
     */
    debug: false,
    /**
     * Check if the focused inputs must be highligted or not
     * @var Boolean
     */
    highlightInputs: true,
    /**
     * it will disable the automatic jump to top on form collapse
     * @var Boolean
     */
    noJump: false,
    /**
     * Indicates that form is still under initialization
     * @var Boolean
     */
    initializing: true,
    /**
     * Keeps the last focused input
     * @var Boolean
     */
    lastFocus: false,
    /**
     * Form's payment type, if any
     * @var String
     */
    payment: false,
    /**
     * Fields to preserve (or duplicate) prior to encryption
     * @var Array
     */
    fieldsToPreserve: [],
    /**
     * Status of multipage save
     * @var Boolean
     */
    saving: false,

    /**
     * Status of fetching pending submission data
     * @var Boolean
     */
    loadingPendingSubmission: false,

    /**
     * ID of current submission session
     * @var String
     */
    sessionID: null,

    /**
     * Unique token of current submission session
     * @var String
     */
    submissionToken: null,

    /**
     * UUID of draft
     * @var String
     */
    draftID: null,

    /**
     * Submission ID for edit mode
     * @var String
     */
    submissionID: null,
    /**
     * Texts used in the form
     * @var Object
     */
    texts: {},
    paymentTexts: {
        couponApply: 'Apply',
        couponChange: 'Change',
        couponEnter: 'Enter Coupon',
        couponExpired: 'Coupon is expired. Please try another one.',
        couponInvalid: 'Coupon is invalid. Please try another one.',
        couponRatelimiter: 'You have reached the rate limit. Please try again after one minute.',
        couponValid: 'Coupon is valid.',
        couponBlank: 'Please enter a coupon.',
        shippingShipping: 'Shipping',
        totalTotal: 'Total',
        totalSubtotal: 'Subtotal',
        taxTax: 'Tax',
    },
    validationRegexes: {
        email: /^(?:[\a-zA-Z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[\a-zA-Z0-9!#$%&'*+\/=?^_`{|}~-]+)*|"(?:[\s\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z](?:[a-zA-Z0-9-]*[a-zA-Z0-9]){1,}|\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-zA-Z0-9-]*[a-zA-Z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])$/,
        alphanumeric: /^[\u00C0-\u1FFF\u2C00-\uD7FFa-zA-Z0-9\s]+$/,
        numeric: /^(-?\d+[\.\,]?)+$/,
        numericDotStart: /^([\.]\d+)+$/,  //accept numbers starting with dot
        currency: /^-?[\$\£\€\₺]?\d*,?\d*,?\d*(\.\d\d)?¥?$/,
        alphabetic: /^[\u00C0-\u1FFF\u2C00-\uD7FFa-zA-Z\s]+$/,
        cyrillic: /^[абвгдеёжзийклмнопрстуфхцчшщьыъэюяАБВГДЕЁЖЗИЙКЛМНОПРСТУФХЦЧШЩЬЫЪЭЮЯ\s]*$/,
    },
    freeEmailAddresses: [
        'gmail.',
        'aim.com',
        'outlook.',
        'hotmail.',
        'yahoo.',
        'inbox.',
        'gmx.',
        'yandex.',
        'tutanota.',
        'ymail.',
        'mailfence.',
        'hushmail.',
        'protonmail.',
        'proton.',
        'privaterelay.appleid.com',
        'rediffmail.',
        'msn.',
        'live.',
        'aol.',
        'currently.',
        'att.',
        'mailinator.',
        'getnada.',
        'abyssmail.',
        'boximail.',
        'clrmail.',
        'dropjar.',
        'getairmail.',
        'givmail.',
        'inboxbear.',
        'tafmail.',
        'vomoto.',
        'zetmail.',
        'sharklasers.',
        'guerrillamail.',
        'grr.',
        'guerrillamailblock.',
        'pokemail.',
        'spam4.',
        'emailcu.',
        'mybx.',
        'fsmilitary.',
        'yopmail.',
        'cool.',
        'jetable.',
        'nospam.',
        'nomail.',
        'monmail.',
        'monemail.',
        'moncourrier.',
        'courriel.',
        'speed.',
        'mega.',
        'icloud.',
        'googlemail.',
        'qq.',
        'mac.',
        'email.com',
        'comcast.net',
        'mail.com',
        'usa.com',
        'myself.com',
        'consultant.com',
        'post.com',
        'europe.com',
        'asia.com',
        'iname.com',
        'writeme.com',
        'dr.com',
        'engineer.com',
        'cheerful.com',
        'mail.vu',
        'mail.ru',
        'mail.pt',
        'mail.pf',
        'mail.org.uk',
        'mail.nu',
        'mail.md',
        'mail.gr',
        'mail.az',
        'mail.be',
        'mail.bg',
        'mail.bulgaria.com',
        'mail.by',
        'mail.byte.it',
        'mail.co.za',
        'mail.com',
        'mail.com.tr',
        'mail.ee',
    ],

    paymentFields: [
      'control_2co',
      'control_authnet',
      'control_bluepay',
      'control_bluesnap',
      'control_boxpayment',
      'control_braintree',
      'control_cardconnect',
      'control_chargify',
      'control_clickbank',
      'control_dwolla',
      'control_echeck',
      'control_eway',
      'control_firstdata',
      'control_paypalInvoicing',
      'control_gocardless',
      'control_googleco',
      'control_moneris',
      'control_mollie',
      'control_onebip',
      'control_pagseguro',
      'control_payjunction',
      'control_payment',
      'control_paysafe',
      'control_iyzico',
      'control_paypal',
      'control_paypalexpress',
      'control_paypalpro',
      'control_paypalcomplete',
      'control_payu',
      'control_payuMoney',
      'control_sofort',
      'control_skrill',
      'control_square',
      'control_stripe',
      'control_stripeACH',
      'control_stripeACHManual',
      'control_worldpay',
      'control_sensepass',
      'control_paypalSPB',
      'control_cybersource',
      'control_stripeCheckout',
      'control_payfast'
    ],
    tempStripeCEForms: [
        '230024636370952',
        '230894369312966',
        '33361556326858',
        '230841251513446',
        '62366391795266',
        '220392206656353',
        '230923831008349',  // from here
        '73394165522963',
        '83003904243346',
        '90764025629360',
        '90831342951355',
        '90852034658360',
        '92226427822356',
        '92581787545371',
        '92762018229358',
        '92872381567368',
        '93091396563364',
        '200432081549348',
        '200524754914353',
        '200672628663358',
        '200714281980352',
        '201545466622353',
        '202666382145355',
        '203216090201336',
        '203594925705361',
        '210313694786360',
        '210373149515351',
        '210596520458357',
        '210705631271345',
        '210736300449349',
        '210804961245352',
        '211401327963349',
        '211424822700343',
        '211571514935354',
        '213042959945363',
        '213126472737355',
        '220167135758357',
        '220301706806345',
        '220724495641356',
        '220885098968375',
        '222471409754357',
        '222777403556360',
        '223413865360353',
        '223605826686364',
        '230012143712336',
        '230092900090344',
        '230274621472350',
        '230494425755360',
        '230923288296364',
        '230923831008349',
        '230952526252050'  // to here belongs to * lidingoslalom * user 44 forms
    ],
    prevEmbedFormHeight: 0,
    isEncrypted : false,
    /* Control to prevent injection of <input name="temp_upload_folder"> more than once. */
    tempUploadFolderInjected: false,
    disableSubmitButton: false,
    disableSubmitButtonMessage: '',
    isConditionDebugMode: false,
    totalLogCount: 0,
    firstUrlPrefillCondition: false,
    conditionCalculationDebugLogs: [],
    conditionCalculationDebugEnabledServers: ['data.reachplc.com'],
    isValidJotform(form) {
      if (!(form instanceof HTMLFormElement)) return false;
      if (!form.id) return false;
      if (!form.classList.contains("jotform-form")) return false;
      return true;
    },
    EventObserver: (function intitalizeFormEventObserver() {
        const searchParams = new URLSearchParams(window.location.search);
        const isDebugEnabled = searchParams.get('debug') === '1';
        const isObserverEnabledByUrlParam = searchParams.get('eventObserver') === '1';

        // feature flag --> window.enableEventObserver is set in buildsource.js
        if (!(window.enableEventObserver || isObserverEnabledByUrlParam)) return null;

        if(getQuerystring('offline_forms') === 'true') return null;

        const CONST = {
            SUBMIT_OBSERVER_NAME: 'submitObserverHandler'
        };

        // EventObserver will overwrite "addEventListener" & "submit". Save original methods
        const _originalFormAddEventListener = HTMLFormElement.prototype.addEventListener;
        const _originalFormSubmitMethod = HTMLFormElement.prototype.submit;

        // create EventObserver
        /** @type {observer.EventObserver} */
        const EventObserver = {
           [CONST.SUBMIT_OBSERVER_NAME]: null
        };

        /** @type {observer.extendedAddEventListener} */
        function extendedAddEventListner(eventKey, handler, options) {
            // only extend new addEventListner to JOTFORM forms
            // do not include CONST.SUBMIT_OBSERVER_NAME
            if (isDebugEnabled) console.log({ eventKey, handler, options });
            if (!JotForm.isValidJotform(this) || handler.name === CONST.SUBMIT_OBSERVER_NAME) {
                _originalFormAddEventListener.apply(this, arguments);
                return;
            }
            const newStack = new Error().stack;
            const stack = newStack ? newStack.split('    at ').splice(2).join('\n') : '';
            const name = (() => {
                // anon functions from prototype.js will be named "responder"
                if (handler.name && handler.name !== 'responder') return handler.name;
                if (!stack) return 'anon-noStack';
                if (stack.includes('for-widgets-server.js')) return 'forWidgetServer';
                if (stack.includes('jquery-3.7.1')) return 'jqueryEventWrapper';
                if (stack.includes('/vendor/maskedinput_')) return 'maskedInputWrapper';
                return 'anon';
            })();

            const order = (() => {
              if (!options || typeof options === 'boolean') return 0;
              if (typeof options === 'object' && typeof options.order === 'number') return options.order;
              return 0;
            })();

            const listener = {
                eventKey,
                name,
                handler,
                stack,
                order
            };

            if (!EventObserver[this.id]) {
                EventObserver[this.id] = {
                    form: this,
                    listeners: [],
                    submit: {},
                    submitDirect: {}
                };
            }

            // add addEventListeners to listeners array.
            EventObserver[this.id].listeners.push(listener);
        }

        // Prevent others from bypassing submit process, ie form.submit()
        /** @type {observer.preventFormSubmitMethod} */
        function preventFormSubmitMethod() {
            if (!JotForm.isValidJotform(this)) {
                _originalFormSubmitMethod.apply(this);
                return;
            }
            const stack = new Error().stack || '';
            const splitStack = stack.split('    at ');
            // Log methods calling form.submit()
            // to avoid possiblility of infinite loops, return void if form.submit() was called by the same function 4 times in a short timespan
            if (Array.isArray(splitStack) && splitStack.length > 2) {
                const handlerName = splitStack[3];
                const formId = this.id;
                const formObserver = EventObserver[formId];
                const submitDirect = formObserver.submitDirect[handlerName];
                const invokedCount = typeof submitDirect === 'number' ? submitDirect + 1 : 0;
                if (invokedCount > 4) {
                    if (isDebugEnabled) console.log(handlerName, 'Submit count is greater than 4 - returning void');
                    // reset error count and exit (to avoid inifinite loops)
                    window.JotForm.errorCatcherLog({ message: {
                        stack,
                        formId: formId,
                        handler: handlerName
                    }}, 'EventObserver: form.submit() exceeded call amount');
                    formObserver.submitDirect[handlerName] = 0;
                    return;
                }

                const submitted = formObserver.submit && Object.values(formObserver.submit).find(submitInstance => Boolean(submitInstance.submitted));
                if (isDebugEnabled) console.log({ handlerName, invokedCount });
                if (submitted) {
                    if (isDebugEnabled) console.log('Form submitted. Returning void.');
                    return;
                }
            }

            // form.submit() will now send a new submit event instead of directly submitting the form.
            if (isDebugEnabled) console.log('form.submit() was called on a jotform form', this, 'calling form.requestSubmit()');
            if (typeof window.HTMLFormElement.prototype.requestSubmit === 'function') {
                this.requestSubmit();
            } else {
                _originalFormSubmitMethod.call(this)
            }

        }

        // overwrite addEventListener + submit event
        HTMLFormElement.prototype.addEventListener = extendedAddEventListner;
        HTMLFormElement.prototype.submit = preventFormSubmitMethod;

        // util for submit logging
        /** @type {observer.addLogEvent} */
        function addLogEvent({ id, stack, info, observerSubmitEvent }) {
            observerSubmitEvent.log.push({
                timestamp: new Date().getTime(),
                id,
                info,
                ...(stack ? { stack } : {})
            });
        }

        /** @type {observer.validateSubmitEvent} */
        function validateObserverSubmitEvent({ id, observerSubmitEvent }) {
            addLogEvent({ id, observerSubmitEvent, info: 'Validation Started' });
            observerSubmitEvent.validationAttempts += 1;
            const formObserver = observerSubmitEvent.formObserver;

            const invalidEvents = Object.values(observerSubmitEvent.listeners).filter(listener => {
                if (listener.valid === null || listener.valid) return false;
                return true;
            });
            const noInvalidEvents = invalidEvents.length === 0;

            const noPreviousSubmits = Object.values(formObserver.submit).filter(submitEvent => {
                return submitEvent.submitted;
            }).length === 0;

            const validSubmit = noInvalidEvents && noPreviousSubmits;
            if (!validSubmit) {
                addLogEvent({ id, observerSubmitEvent, info: 'Validation Complete. Invalid Submit.\nNumber of invalid events: ' + invalidEvents.length + '.\nPreviously submitted: ' +  !noPreviousSubmits + '.'});
                return;
            }
            observerSubmitEvent.submitted = true;
            observerSubmitEvent.submittedAt = new Date().getTime().toString();
            trackExecution('observerSubmitHandler_validation-passed-submitting-form');
            trackSubmitDate();
            addLogEvent({ id, observerSubmitEvent, info: 'Validation Complete. Valid Submit.' });
            // form.submit() will be called directly.
            _originalFormSubmitMethod.apply(formObserver.form);
        }

        // this function will receieve the real submit event and dispatch local "validation" events to the listeners.
        /** @type {observer.handlerSubmitEvent} */
        function eventObserverSubmitHandler(originalEvent, formId) {
            const formObserver = EventObserver[formId];
            if (!formObserver) return;

            // stop submit event from invoking POST request
            originalEvent.preventDefault();
            const newStack = new Error().stack;
            const stackTrace = newStack ? newStack.split('    at ').splice(2).join('\n') : '';
            trackExecution('observerSubmitHandler_received-submit-event');
            // create Observer's Immutable SubmitEvent.
            const observerSubmitEvent = {
                id: generateUUID(formId),
                createdAt: new Date().getTime(),
                validationAttempts: 0,
                submitter: originalEvent.submitter || null,
                submitted: null,
                submittedAt: null,
                listeners: {},
                log: [],
                get stack() { return stackTrace },
                get formObserver() { return formObserver }
            };

            // add Observer's SubmitEvent to global EventObserver
            const eventIndex = Object.keys(formObserver.submit).length;
            formObserver.submit[eventIndex] = observerSubmitEvent;

            // get form submit listeners & add them to Observer's SubmitEvent
            formObserver.listeners.forEach(function addListener(listener, index) {
                if (listener.eventKey !== 'submit') return;
                const listenerName = listener.name + '_' + index;

                // copy global listener + create new "validation" event for each listener
                /** @type {observer.listenerInstance} */
                const createListenerInstance = () => {

                    // util to log methods called from listener
                    function logEventMethod(methodName) {
                        const newStack = new Error().stack;
                        const stack = newStack ? newStack.split('    at ').splice(2).join('\n') : '';
                        addLogEvent({ id: listenerName, observerSubmitEvent, info: `${methodName}() invoked`, stack });
                    }
                    let _valid = null;
                    return {
                        name: listenerName,
                        eventKey: listener.eventKey,
                        handler: listener.handler,
                        order: listener.order,
                        get valid() { return _valid },
                        event: {
                            stop() { logEventMethod('stop'); },
                            // add logs to see if listener is calling methods from original submit event
                            // listeners should only use "valid" property
                            preventDefault() { logEventMethod('preventDefault'); },
                            stopPropagation() { logEventMethod('stopPropagation'); },
                            stopImmediatePropagation() { logEventMethod('stopImmediatePropagation'); },
                            composedPath() { logEventMethod('composedPath'); },
                            get valid() { return _valid },
                            get submitter() { return observerSubmitEvent.submitter },
                            get eventId() { return observerSubmitEvent.id },
                            set valid(status) {
                                if (typeof status !== 'boolean' && status !== null) return;
                                const newStack = new Error().stack;
                                const stack = newStack ? newStack.split('    at ').splice(2).join('\n') : '';
                                if (_valid === status) {
                                    addLogEvent({ id: listenerName, stack, observerSubmitEvent, info: 'valid already set to: ' + status });
                                    return;
                                }
                                _valid = status;
                                addLogEvent({ id: listenerName, observerSubmitEvent, stack, info: 'valid: ' + status });

                                if (!observerSubmitEvent.validationAttempts) return;
                                if (observerSubmitEvent.submitted) return;
                                validateObserverSubmitEvent({ id: listenerName, observerSubmitEvent });
                            }
                        }
                    }
                };

                // add new listenerInstance to Oberserer's SubmitEvent
                observerSubmitEvent.listeners[listenerName] = createListenerInstance()
            });

            // sort listeners by order
            const orderedEventListeners = Object.values(observerSubmitEvent.listeners).sort((a, z) => {
                return a.order - z.order;
            });

            // Run all Observer's SubmitEvent listeners
            orderedEventListeners.forEach(listener => {
                if (typeof listener.handler !== 'function') return;

                addLogEvent({ id: listener.name, observerSubmitEvent, info: listener.name + ': start' });

                try {
                    // pass new validation event to listener
                    listener.handler.call(formObserver.form, listener.event);
                } catch (error) {
                    addLogEvent({ id: listener.name, observerSubmitEvent,  info: 'Error: Failed in try catch.', stack: String(error) });
                }
                addLogEvent({ id: listener.name, observerSubmitEvent, info: listener.name + ': end' });
            });

            // run validateObserverSubmitEvent after calling all listeners
            validateObserverSubmitEvent({ id: 'Observer', observerSubmitEvent });
        };

        // Rename 'submitEventHandler' function name to CONST.SUBMIT_OBSERVER_NAME.
        // CONST.SUBMIT_OBSERVER_NAME will be ignored by new "addEventListener" to recieve the form's original dispatched submit event.
        Object.defineProperty(eventObserverSubmitHandler, 'name', {
            enumerable: false,
            configurable: false,
            writable: false,
            value: CONST.SUBMIT_OBSERVER_NAME
        });

        EventObserver.getLatestSubmitLog = () => {
            const form = document.querySelector('form.jotform-form');
            if (!(form instanceof HTMLFormElement)) return null;

            const formObserver = JotForm.EventObserver[form.id];
            if (!formObserver || !formObserver.submit || !Object.keys(formObserver.submit).length) return null;
            const lastInstance = formObserver.submit[Object.keys(formObserver.submit).length - 1];
            if (!lastInstance) return null;
            return lastInstance.log;
        };

        EventObserver[CONST.SUBMIT_OBSERVER_NAME] = eventObserverSubmitHandler;
        return EventObserver;
    })(),
    encryptAll  : function(e, callback) {
        e.stop();
        e.valid = false;

        // eslint-disable-next-line no-var
        var fields = getFieldsToEncrypt();

        if (JotForm.encryptionProtocol === 'JF-CSE-V2') {
            if (JotForm.isEditMode()) {
                // eslint-disable-next-line no-var
                var form = document.querySelector('.jotform-form');
                // eslint-disable-next-line no-var
                var formID = form ? form.getAttribute('id') : '';
                // eslint-disable-next-line no-var
                var privateKey = JotCrypto.getEncryptionKey('JF-CSE-V2', formID);
                // eslint-disable-next-line no-var
                var encryptionKey = JotForm.submissionDecryptionKey;
                if (!privateKey) {
                    callback(false);
                    JotForm.error('Missing encryption key!');
                    return;
                }
                Promise.all(fields.map(function (field) {
                    setUnencryptedValueToForm(field);
                    return JotCrypto.reEncrypt(privateKey, encryptionKey)(field.value).then(function (encVal) {
                        return Promise.resolve({
                            field: field,
                            encryptedValue: encVal
                        });
                    });
                })).then(function (encFields) {
                    encFields.map(setEncryptedValue);
                    // eslint-disable-next-line no-var
                    var submitFormAfterEncrypt = shouldSubmitFormAfterEncrypt();
                    callback(submitFormAfterEncrypt);
                }).catch(function (err) {
                    console.log('Encryption v2 error ', err.message);
                })
            } else {
                JotCrypto.encrypt(
                    JotForm.encryptionPublicKey
                ).then(function (enc) {
                    addEncryptionKeyToForm(enc.encryptedAESKey);
                    return Promise.all(fields.map(function (field) {
                        setUnencryptedValueToForm(field);
                        return enc.run(field.value).then(function (encVal) {
                            return Promise.resolve({
                                field: field,
                                encryptedValue: encVal
                            });
                        });
                    }));
                }).then(function (encFields) {
                    encFields.map(setEncryptedValue);
                    // eslint-disable-next-line no-var
                    var submitFormAfterEncrypt = shouldSubmitFormAfterEncrypt();
                    callback(submitFormAfterEncrypt);
                }).catch(function (err) {
                    console.log('Encryption v2 error ', err.message);
                })
            };
        } else {
            fields.forEach(function (field) {
                setUnencryptedValueToForm(field);
                // eslint-disable-next-line no-var
                var encryptedField = {
                    field: field,
                    encryptedValue: JotEncrypted.encrypt(field.value)
                };
                setEncryptedValue(encryptedField);
            });
            // eslint-disable-next-line no-var
            var submitFormAfterEncrypt = shouldSubmitFormAfterEncrypt();
            callback(submitFormAfterEncrypt);
        }
    },
    /**
     * Find the correct server url from forms action url, if there is no form use the defaults
     */
    getServerURL: function () {

        const form = document.querySelector('.jotform-form');
        let action;
        const origin = window.location.origin || (window.location.protocol + '//' + window.location.hostname);
        if (form) {
            if (origin.includes('jotform.ooo') && typeof JotForm.hipaa !== 'undefined' && JotForm.hipaa) {
                this.server = "https://hipaa.jotform.ooo/server.php";
                this.url = "https://hipaa.jotform.ooo/";
                return;
            }
            if (origin.includes('.jotform.pro') || origin.includes('.jotform.ooo')) {
                this.server = origin + "/server.php";
                this.url = origin + '/';
                return;
            }

            if ((action = form.readAttribute('action'))) {
                if (action.includes('submit.php') || action.includes('server.php')) {
                    const n = !action.includes('server.php') ? "submit" : "server";
                    this.server = action.replace(n + '.php', 'server.php');
                    this.url = action.replace(n + '.php', '');
                } else {
                    let d = action.replace(/\/submit\/.*?$/, '/');

                    if (action.includes('pci.jotform.com')) {
                        d = d.replace('pci.','submit.');
                    }

                    if (typeof JotForm.enterprise !== 'undefined' && JotForm.enterprise) {
                        d = "https://"+ JotForm.enterprise + "/";
                    } else if (typeof JotForm.hipaa !== 'undefined' && JotForm.hipaa) {
                        d = "https://hipaa.jotform.com/";
                    }

                    this.server = d + 'server.php';
                    this.url = d;
                }
            }
        }
    },

    checkConditionDebugMode: function () {
        if (window && window.location.href.indexOf('conditionDebug') !== -1) {
            this.isConditionDebugMode = true;
        }
    },
    isAgentEmbed: function () {
        return (window.self !== window.top) && (window.location.href.indexOf("isAIAgentEmbed") > -1);
    },
    /**
     * Initializes sentry for classic forms
    */
    initEmbeddedAgent: function (fullStoryUrl = '') {
        if (window.AgentInitializer && !this.isAgentEmbed()) {
            const formQueryString = window.location.search;
            const formUrlParams = new URLSearchParams(formQueryString);
            const agentChatID = formUrlParams.get('agentChatID');
            const chatID = agentChatID ? `chatID=${agentChatID}` : '';
            const urlParams = new URLSearchParams(window.location.search);
            const isInitialOpenParam = urlParams.get('isAgentInitialOpen');

            const isInitialOpen =
              isInitialOpenParam === 'true' ? true :
              isInitialOpenParam === 'false' ? false :
              undefined;


            let helperAgentProps = {
                formID: this.getFormId(),
                queryParams: ['projectName=formHelperAgent', 'skipWelcome=1', chatID, fullStoryUrl ? `fullStoryUrl=${fullStoryUrl}` : '','maximizable=1', 'embedModeVariant=formHelper'],
                domain: window.location.origin,
                isInitialOpen,
                embedModeVariant: 'formHelper',
                isDraggable: window.location.href.includes('isAgentDraggable')
            }

            if (window.formHelperAgentProp) {
                const {agentHeaderBackgroundColor, avatarIconLink, agentRenderURL, ...rest} = JSON.parse(window.formHelperAgentProp);
                if (!rest.loggedInUser || (rest.loggedInUser && !rest.loggedInUser.name && !rest.loggedInUser.username)) {
                  nameInputListenerForAssistantTooltip();
                };

                putChatIDInForm(new URL(agentRenderURL).origin);
                helperAgentProps = {...helperAgentProps, background: agentHeaderBackgroundColor, avatarURL:avatarIconLink, agentRenderURL, ...rest}
            }

            window.agentInitialized = true;
            const isCardformWithWelcome = window.FORM_MODE === 'cardform' && document.querySelector('.welcomeMode') !== null;
            const isPDFFormWithWelcome = !!JotForm.importedPDF && document.querySelector('html').getAttribute('data-mode') === 'welcomeMode';

            if (isCardformWithWelcome || isPDFFormWithWelcome) {
                const startButtonQuery = isPDFFormWithWelcome ? '.js-pdfStartFilling' : '#jfCard-welcome-start';
                const startButton = document.querySelector(startButtonQuery);
                if (startButton) {
                    startButton.addEventListener('click', () => {
                        const agentMethods = window.AgentInitializer.init(helperAgentProps);
                        window.embeddedAgentMethods = agentMethods;
                    });
                }
            }
            else {
                const agentMethods = window.AgentInitializer.init(helperAgentProps);
                window.embeddedAgentMethods = agentMethods;
              }
        }
    },

    getAPIEndpoint: function() {
        if(!this.APIUrl){
            this.setAPIUrl();
        }
        return this.APIUrl;
    },
    /**
     * Changes only the given texsts
     * @param {Object} newTexts
     */
    alterTexts: function (newTexts, payment) {
        if (payment && !!newTexts) {
            Object.extend(this.paymentTexts, newTexts);
            this.changePaymentStrings(newTexts);
        } else {
            Object.extend(this.texts, newTexts || {});
        }
    },
    /**
     * A short snippet for detecting versions of IE in JavaScript
     * without resorting to user-agent sniffing
     */
    ie: function () {
        // eslint-disable-next-line no-var
        var undef,
            v = 3,
            div = document.createElement('div'),
            all = div.getElementsByTagName('i');

        while (
            div.innerHTML = '<!--[if gt IE ' + (++v) + ']><i></i><![endif]-->',
                all[0]
            );

        return v > 4 ? v : undef;
    },

    errorCatcherLog: function (err, logTitle) {
        const MAX_SAME_LOG_COUNT = 100;
        try {
            if (!location.href.includes('form-templates')) {
                // eslint-disable-next-line no-var
                var self = this;
                // eslint-disable-next-line no-var
                var currFormID = document.getElementsByName('formID')[0].value;
                // eslint-disable-next-line no-var
                var errorData = {
                    stack: err.stack || err.message, agent: navigator.userAgent, referrer: location.href
                }

                if (logTitle === 'VALIDATED_REQUIRED_FIELD_IDS') {
                    errorData = {
                        validatedRequiredFieldIDs: err.validatedRequiredFieldIDs,
                        agent: navigator.userAgent,
                        referrer: location.href
                    }

                    if (JotForm.isEditMode()) {
                        errorData['submissionID'] = document.querySelector('input[name="editSubmission"]').value;
                    } else {
                        errorData['eventID'] = document.querySelector('input[name="event_id"]').value;
                    }
                }

                // eslint-disable-next-line no-var
                var _payload = JSON.stringify({
                    data: errorData,
                    title: logTitle
                });

                if (self.totalLogCount > MAX_SAME_LOG_COUNT) {
                    return;
                }
                self.totalLogCount++;

                JotForm.createXHRRequest(JotForm.getAPIEndpoint() + '/formInitCatchLogger/' + currFormID, 'post', _payload, function cb(res) {
                    console.log(res)
                }, function errCb(err) {
                    self.totalLogCount--;
                    console.log(err)
                });
            }
        } catch (_err) {
            console.log(_err);
        }
    },

    /**
     * Creates the console arguments
     */
    createConsole: function () {
        // eslint-disable-next-line no-var
        var consoleFunc = ['log', 'info', 'warn', 'error'];
        consoleFunc.forEach(function (c) {
            this[c] = function () {
                if (JotForm.debug) {
                    if ('console' in window) {
                        try {
                            console[c].apply(this, arguments);
                        } catch (e) {
                            if (typeof arguments[0] == "string") {
                                console.log(c.toUpperCase() + ": " + arguments.join(', '));
                            } else {
                                if (JotForm.browserIs.ie8AndBelow()) {
                                    alert(c + ": " + arguments[0]);
                                } else {
                                    console[c](arguments[0]);
                                }
                            }
                        }
                    }
                }
            };
        }.bind(this));

        if (JotForm.debug) {
            JotForm.debugOptions = document.readJsonCookie('debug_options');
        }
    },

    /**
     * Set Transaction ID for Payment
     */
    generatePaymentTransactionId: function () {
        // eslint-disable-next-line no-var
        var paymentTransactionIdInput = document.getElementById('paymentTransactionId');
        if (typeof(paymentTransactionIdInput) != 'undefined' && paymentTransactionIdInput != null) {
            // eslint-disable-next-line no-var
            var msTransaction = Date.now();
            JotForm._xdr(JotForm.getAPIEndpoint() + '/payment/generateTransactionId?ms=' + msTransaction, 'GET', null, function (responseData) {
                if (responseData.content) {
                    paymentTransactionIdInput.value = responseData.content;
                }
            }, function (err) {
                console.log('err', err);
            });
        }
    },
    domObserver: ({resizeObserver: {resizeActive, resizeCallback, resizeElement },
        mutationObserver: { mutationActive, mutationCallback, mutationElement, mutationConfig}}) => {
        if (resizeActive) {
            const resize = new ResizeObserver(resizeCallback);
            resize.observe(resizeElement);
        }

        if (mutationActive) {
            const mutation = new MutationObserver(mutationCallback);
            mutation.observe(mutationElement, mutationConfig);
        }
    },

    /**
     * Initiates the form and all actions
     */
    init: function (callback) {
        // eslint-disable-next-line no-var
        var firstPerformancePoint = performance.now();
        // eslint-disable-next-line no-var
        var ready = function () {
            try {
                if (isIframeEmbedFormPure() && JotForm.isFormInNewIframeHeightCalculation()) {
                    JotForm.domObserver({
                        resizeObserver: {
                            resizeActive: true,
                            resizeCallback: JotForm.newHandleIframeHeight,
                            resizeElement: document.body
                        },
                        mutationObserver: {
                            mutationActive: true,
                            mutationCallback: JotForm.newHandleIframeHeight,
                            mutationElement: document.documentElement,
                            mutationConfig: {
                                attributes: true,
                                attributeFilter: ['data-mode'],
                                childList: true,
                                subtree: true
                            }
                        }
                    });
                }

                if ('IntersectionObserver' in window) {
                    const isSmallScreen = window.innerWidth < 600;
                    const observerOptions = {
                        root: null,
                        rootMargin: isSmallScreen ?  '0px 0px -5px 0px' : '0px 0px -10% 0px',
                        threshold: isSmallScreen
                          ?  [0.01, 0.05, 0.1]
                          : [0, 0.25, 0.5, 0.75, 0.90]
                    };

                    const oembedWidgets = [...document.querySelectorAll('[data-type="oembed"]')].filter(item => {
                        item.tempSrc = item.src;
                        item.src = '';
                        return item;
                    });

                    let isFirstIntersected = false;

                    if (oembedWidgets.length > 0) {
                        const oembedWidgetObserver = new IntersectionObserver((entries) => {
                            entries.forEach((widget) => {
                                const el = widget.target;
                                const welcomeWrapper = document.querySelector('.jfWelcome-wrapper');
                                const isCurrentCardWelcome = Boolean(welcomeWrapper && welcomeWrapper.classList.contains('hidden'));
                                const isCardForm = window.FORM_MODE === 'cardform';
                                if (widget.isIntersecting) {
                                  if (isCardForm && !isCurrentCardWelcome && isFirstIntersected) {
                                    return;
                                  }
                                  isFirstIntersected = true;
                                  el.src = el.tempSrc;
                                  oembedWidgetObserver.unobserve(el);
                                }
                            });
                        }, observerOptions);

                        oembedWidgets.forEach(widget => {
                            oembedWidgetObserver.observe(widget);
                        });
                    }
                }

                if (!this.jsForm && getQuerystring('jsForm') === 'true') {
                    this.jsForm = true;
                    if (window.CardForm) {
                        window.CardForm.jsForm = true;
                    }
                }

                trackExecution('init-started');

                // bugfix: If user goes back to form after submit, submit button may be stuck on please wait.
                // performance.getEntriesByType('navigation') can determine if page was loaded from cache
                const navigationPerformanceEntry =  performance && performance.getEntriesByType && performance.getEntriesByType('navigation')[0];
                const pageType = navigationPerformanceEntry && navigationPerformanceEntry.type;
                if (pageType === "back_forward") {
                    JotForm.enableButtons();
                }

                if (window.FS) {
                  window.onFSError = () => this.initEmbeddedAgent();
                  window._fs_ready = () => {
                    this.initEmbeddedAgent(window.FS.getCurrentSessionURL());
                  }
                  // eslint-disable-next-line no-var
                  var agentInitCount = 1;
                  // eslint-disable-next-line no-var
                  var agentIntervalID = setInterval(() => {
                    if (window.AgentInitializer && !window.agentInitialized && !this.isAgentEmbed()) {
                        clearInterval(agentIntervalID);
                        // eslint-disable-next-line no-var
                        var FSSession = window.FS && window.FS.getCurrentSessionURL && window.FS.getCurrentSessionURL();
                        this.initEmbeddedAgent(FSSession || '');
                    } else if (agentInitCount > 2) {
                        clearInterval(agentIntervalID);
                    }
                    agentInitCount++;
                  }, 3000)
                } else {
                  this.initEmbeddedAgent();
                }

                if (document.get.agentPhoneCall == 1 || document.get.chatID) {
                    appendHiddenInput("chatID", document.get.chatID);
                }

                if (typeof window.initializeSignaturePad === 'function') {
                    window.initializeSignaturePad();
                }

                // eslint-disable-next-line no-var
                var jotformForm = document.querySelector('.jotform-form');

                // eslint-disable-next-line no-var
                var isPreview = getQuerystring('preview') === 'true';
                // eslint-disable-next-line no-var
                var _formID = jotformForm.id;
                // eslint-disable-next-line no-var
                var _uuid = generateUUID(_formID);

                // event id generates from very top of the initialization to avoid being interrupted by a code break
                if (!isPreview) {
                    if (location && location.href && location.href.indexOf('&nofs') === -1 && location.href.indexOf('&sid') === -1) {
                        appendHiddenInput('event_id', _uuid);
                    }
                }

                if (JotForm.EventObserver) {
                  // add submitObserverHandler to the form's submit event.
                  // when the JotForm object initialized, we extended the addEventListener's prototype
                  // and added all submit listeners to "JotForm.EventObserver.listeners"
                  // the submitObserverHandler will be the only function that will receive the real submit event
                  // it will then call each submit handler, passing a new event object with additional functionality
                  // the handler can now set the event to e.valid = true / false
                  // see the validateAll example below

                  jotformForm.addEventListener("submit", function submitObserverHandler(e) {
                    // the "e" here will the original submit event.
                    // possibility of multiple forms - pass form id to to ensure correct form is submitted
                    JotForm.EventObserver.submitObserverHandler(e, jotformForm.id);
                  });

                  jotformForm.addEventListener("submit", function validateAll(e) {
                      e.valid = JotForm.validateAll(jotformForm);
                    },
                    { order: -1 }
                  );
                }

                // Extend the submit method to track the submit source. This helps with identifying empty/blank submissions.
                HTMLFormElement.prototype.submit = (function (originalSubmitFn) {
                    return function () {
                        try {
                            // Feature Flag for validating direct form submissions based on form id
                            // eslint-disable-next-line no-var
                            var directValidationFeatureFlag = !JotForm.payment;

                            // Validate form submissions from direct calls to submit
                            if (directValidationFeatureFlag && !JotForm.ignoreDirectValidation) {
                                if (JotForm.validateAll(this)) {
                                    trackExecution('direct-validation-passed');
                                } else {
                                    JotForm.enableButtons();
                                    JotForm.showButtonMessage();
                                    JotForm.updateErrorNavigation(true);
                                    // Validation failed -> prevent submission
                                    trackExecution('direct-validation-failed');
                                    return false;
                                }
                            }

                            trackSubmitSource('direct');
                        } catch (error) {
                            console.log(error);
                        }

                        if (JotForm.payment === 'stripeCheckout') {
                            // eslint-disable-next-line no-var
                            var inputSimpleFpc = document.querySelector('input[name="simple_fpc"]');
                            // eslint-disable-next-line no-var
                            var paymentFieldId = inputSimpleFpc && inputSimpleFpc.value;
                            $$('#id_' + paymentFieldId + ' .form-checkbox, .form-radio').each(function (el) {
                                if (el.disabled && el.checked) {
                                    el.enable();
                                }
                            });
                        }

                        JotForm.ignoreDirectValidation = false;

                        return originalSubmitFn.apply(this, arguments);
                    };
                })(HTMLFormElement.prototype.submit);

                if (jotformForm.reset && jotformForm.autocomplete && jotformForm.autocomplete === 'off') {
                    if ( window.navigator.userAgent.indexOf('MSIE ') !== -1 || window.navigator.userAgent.indexOf('Trident/') !== -1 ) {
                        jotformForm.reset();
                    }
                }

                window.onpageshow = function (e) {
                    // User navigated back to form with Back-Forward Cache
                    if (e.persisted) {
                        JotForm.fromBFCache = true;

                        // refresh the page upon browser back button on iOS devices. #2584491
                        if (JotForm.browserIs.ios()) {
                            window.location.reload();
                        }

                        // For safari browsers, remove files from file upload to prevent missing files in submissions
                        else if (JotForm.browserIs.safari()) {
                            document.querySelectorAll('.qq-upload-success').forEach(function (fileElement) {
                                // eslint-disable-next-line no-var
                                var fileElementParent = fileElement.parentElement;

                                // Locally remove file from form and run cleanup/validation
                                JotForm.removeFile({
                                    fileElement: fileElement,
                                    fileName: fileElement.getAttribute('actual-filename'),
                                    hiddenTempUploadInput: document.querySelector('[name^="temp_upload["]')
                                });

                                // fire change event -> cardForm needs change event to validate card
                                if (fileElementParent) {
                                    fileElementParent.dispatchEvent(new Event('change', {bubbles: true}));
                                }
                            });
                        }
                    }
                };

                this.populateGet();

                this.debug = document.get.debug === '1';

                this.createConsole();

                this.getServerURL();

                this.checkConditionDebugMode();

                this.checkJSON();

                if (callback) {
                    /**
                     * When callback function threw an error
                     * all init function stopped to functioning.
                     * To avoid this behaviour,
                     * callback function has been wrapped by a try/catch block
                     */
                    try {
                        callback();
                    } catch (error) {
                        console.log(error);
                    }
                }

                Array.from(document.forms).forEach(function (form) {
                    if (form.name === 'form_' + form.id || form.name === 'q_form_' + form.id) {
                        JotForm.forms.push(form);
                    }
                });

                /**
                 * If the form is iframe embedded form, recalculate
                 * the height of the iframe after the form is fully loaded.
                 */
                if (isIframeEmbedFormPure()) {
                    window.addEventListener('load', function() {
                        JotForm.handleIFrameHeight();
                    });

                    /**
                     * for smart pdf forms, recalculate the height of the iframe
                     * after data-mode attribute is changed on the html tag
                     */
                    if (
                        typeof JotForm.importedPDF !== 'undefined'
                        && typeof MutationObserver !== 'undefined'
                        && typeof ResizeObserver !== 'undefined'
                        && JotForm.importedPDF
                    ) {
                        const iframeObserver = new MutationObserver(() => JotForm.handleIFrameHeight());
                        iframeObserver.observe(document.documentElement, {
                            attributes: true,
                            attributeFilter: ['data-mode']
                        });
                        const welcomeViewObserver = new MutationObserver(() => {
                            const welcomeView = document.querySelector('#pdfimporter-root .pdff-welcomeView');
                            if (!welcomeView) {
                                return;
                            }

                            const resizeObserver = new ResizeObserver(() => JotForm.handleIFrameHeight());
                            resizeObserver.observe(welcomeView);

                            welcomeViewObserver.disconnect();
                        });
                        welcomeViewObserver.observe(document.documentElement, {
                            childList: true,
                            subtree: true
                        });
                    }
                }

                if (window.location.pathname.indexOf("/edit/") !== -1) {
                   // eslint-disable-next-line no-var
                   var urlParts = window.location.href.split("/");
                   //  Submission ID should be given after "edit"
                   document.get.sid = urlParts[urlParts.indexOf('edit') + 1];
                   this.editMode();
               }

                //will load editMode script dynamically
                if (document.get.sid && (['edit', 'inlineEdit', 'submissionToPDF'].indexOf(document.get.mode) > -1 || document.get.offline_forms === 'true')) {
                    this.editMode();
                }

                if (window.JFForm && window.JFForm.draftID) {
                    this.draftID = window.JFForm.draftID;
                }

                this.noJump = ("nojump" in document.get);
                this.uniqueID = this.uniqid();
                this.sessionID = JotForm.validateSessionID(document.get.session) ? document.get.session : false;
                this.submissionToken = document.get.stoken || false;
                this.submissionID = document.get.sid || false;
                this.handleSavedForm();
                this.setHTMLClass();
                this.getDefaults();
                if(this.noJump) {
                    window.parent.postMessage("removeIframeOnloadAttr", '*');
                }

                if(getQuerystring('itemCatalog') === '1') {
                    const hasPaymentInLegacy = Boolean(document.querySelector('[data-payment="true"]'));
                    const hasPaymentInCard = Boolean(document.querySelector('[data-payment="newpayment"]'));
                    if (hasPaymentInLegacy || hasPaymentInCard) {
                        this.loadStyleSheet('../css/styles/payment/payment_ai_catalog.css');
                    }
                }

                // eslint-disable-next-line no-var
                var inputSimpleFpc = document.querySelector('input[name="simple_fpc"]');
                if (inputSimpleFpc) {
                    this.payment = inputSimpleFpc.getAttribute('data-payment_type');
                }
                if (!!document.querySelector('.form-product-custom_price')) {
                    this.handleSubscriptionPrice();
                }

                if (!!document.querySelector('#payment-category-dropdown')) {
                    this.handleProductCategoryDropdown();
                }

                if (this.payment === "paypalpro") {
                    this.handlePaypalPro();
                }

                if (this.payment === "cybersource") {
                    this.handleCybersource();
                }

                if (this.payment === "braintree") {
                    this.handleBraintree();
                }

                if (this.payment === "pagseguro") {
                  this.handlePagseguro();
                }

                if (this.payment === "square") {
                    this.handleSquare();
                }

                if (this.payment === "mollie") {
                  this.handleMollie();
                }

                if (this.payment === "sensepass") {
                    this.handleSensepass();
                }

                if (this.payment === "stripeACH") {
                    this.handleStripeACH();
                }
                if (this.payment === "authnet") {
                    this.handleAuthNet();
                }

                if (this.payment === "bluepay") {
                  this.handleBluepay();
                }

                if (this.payment === "bluesnap") {
                    this.handleBluesnap();
                }

                if (['cardconnect', 'paysafe', 'chargify', 'payjunction'].indexOf(this.payment) > -1) {
                    this.PCIGatewaysCardInputValidate();
                }

                if (this.payment === "paypalexpress") {
                    this.handlePaypalExpress();
                }

                if (this.payment === 'echeck') {
                    this.handleEcheck();
                }

                if (this.payment === "paypalSPB") {
                    if (typeof JotForm.browserInformations === 'function') {
                        appendHiddenInput('browserDetails', JotForm.browserInformations());
                    }
                    // eslint-disable-next-line no-var
                    var interval = setInterval(function() {
                        if (typeof __paypalSPB !== "undefined" && typeof paypal !== "undefined") {
                          clearInterval(interval);
                          this.handlePaypalSPB();
                        }
                    }.bind(this), 100);
                }

                // If coupon button exists, load checkCoupon
                if (document.getElementById('coupon-button')) {
                    this.handleCoupon();
                }

                if (typeof PaymentStock !== 'undefined') {
                    // var _pStock = new PaymentStock();
                    // Settimeout is needed to get correct api url.
                    // eslint-disable-next-line no-undef
                    setTimeout(function() { PaymentStock.initialize(); }, 0);
                }

                if (document.querySelector('.paypal-button') && document.getElementById('use_paypal_button')) {
                    this.handlePaypalButtons();
                }
                this.handleFormCollapse();
                this.handlePages();
                this.checkEmbed();
                this.checkPwa();


                if (document.querySelector('.form-product-has-subproducts')) {
                    if (JotForm.newPaymentUI) {
                        this.handlePaymentSubProductsV1();
                    } else {
                        this.handlePaymentSubProducts();
                    }
                }

                // If form is hosted in an iframe, calculate the iframe height
                if (window.parent && window.parent !== window) {
                    // eslint-disable-next-line no-var
                    var queryString =  document.referrer && document.referrer.split('?')[1] || '';

                    // Disable smart embed on forcing action or iframe embed forms
                    if(queryString.indexOf('disableSmartEmbed') > -1 || !this.jsForm) {
                        // Remove smart embed class to prevent applying embed styling
                        document.querySelectorAll('.isSmartEmbed').forEach(el => el.classList.remove('isSmartEmbed'));
                    }
                    this.setIFrameDeviceType();
                    this.handleIFrameHeight();

                    // if there is a recaptcha
                    // eslint-disable-next-line no-var
                    var visibleCaptcha = document.querySelector('li[data-type="control_captcha"]:not(.always-hidden)');

                    if (visibleCaptcha) {
                        // eslint-disable-next-line no-var
                        var count = 0;
                        // eslint-disable-next-line no-var
                        var captchaInterval = setInterval(function () {
                            if (count > 5) {
                                clearInterval(captchaInterval);
                            }

                            if (visibleCaptcha.querySelectorAll('iframe').length) {
                                JotForm.handleIFrameHeight();
                                clearInterval(captchaInterval);
                            }
                            count++;
                        }, 1000);
                    }
                } else {
                    // Remove smart embed class to prevent applying embed styling
                    document.querySelectorAll('.isSmartEmbed').forEach(el => el.classList.remove('isSmartEmbed'));
                }

                // set triggerEvent function for elements
                Element.prototype.triggerEvent = function (eventName) {
                    // eslint-disable-next-line no-var
                    var disabled = this.hasClassName('form-dropdown') && this.disabled ? !!(this.enable()) : false;

                    if (document.createEvent) {
                        // eslint-disable-next-line no-var
                        var evt = document.createEvent('HTMLEvents');
                        evt.initEvent(eventName, true, true);
                        this.dispatchEvent(evt);
                    } else if (this.fireEvent) {
                        this.fireEvent('on' + eventName);
                    }

                    if (disabled) {
                        this.disable();
                    }
                }

                this.jumpToPage();

                if (!JotForm.getPrefillToken()) { // if prefill token is empty, not wait the 'PrefillCompleted' event
                    this.highLightLines();
                } else { // if token is available, wait the event
                    document.addEventListener('PrefillCompleted', this.highLightLines);
                }
                this.handleHighlightMatchedQuestions();
                this.handleWidgetMessage();
                this.setButtonActions();
                this.initGradingInputs();
                this.initSpinnerInputs();
                this.initNumberInputs();
                this.handleZeroQuantityProducts();
                this.initTextboxValidation();
                this.setAPIUrl();
                this.initPrefills();
                this.createManualPrefill();
                if(document.querySelector('.js-new-sacl-button, .jfFormUser-header-saveAndContinueLater-button') && !window.JotForm.isNewSACL){
                    JotForm.isNewSACL = true;
                }

                if (this.payment === "paypalcomplete") {
                    this.handlePaypalComplete();
                }
                // if (JotForm.jsForm !== true) {
                //     this.setJotFormUserInfo();
                // }

                // Enable autofill if a form is opened from an App
                if (getQuerystring('jotform_pwa') === '1') {
                    this.setJotFormUserInfo();
                }

                if (getQuerystring('asanaTaskID', false)) {
                    this.setAsanaTaskID();
                }

                this.setConditionEvents();
                this.setCalculationEvents();
                this.runAllCalculations();
                this.setCalculationResultReadOnly();
                this.prePopulations();

                JotForm.onTranslationsFetch(function () {
                    if (document.createEvent) {
                        try {
                            // eslint-disable-next-line no-var
                            var event = new CustomEvent('PrepopulationCompleted');
                            document.dispatchEvent(event);
                        } catch (error) {
                            console.log(error);
                        }
                    }
                });

                this.handleSSOPrefill();
                this.handleAutoCompletes();
                this.handleTextareaLimits();
                this.handleDateTimeChecks();
                this.handleTimeChecks();
                this.handleOtherOptions(); // renamed from handleRadioButtons
                this.setFocusEvents();
                // this.setBirthDateEvents();
                this.disableAcceptonChrome();
                this.handleSignatureEvents();
                this.handleSignSignatureInputs();
                this.handleFITBInputs();
                this.setupFormSettledEvent();
                if (JotForm.newDefaultTheme || JotForm.extendsNewTheme) {
                    // createNewComponent(data-type, function).render()
                    // createNewComponent({ selector: '.form-radio + label', type: 'field' }, this.initRadioInputV2).render();
                    // createNewComponent({ selector: '.form-section.page-section', type: 'element' }, this.initHeaderSection).render();
                    this.initTestEnvForNewDefaultTheme();
                    this.initTimev2Inputs();
                    this.initDateV2Inputs();
                    this.getMessageFormTermsAndCondition();
                    this.initOtherV2Options();
                    this.dropDownColorChange();
                }

                // this.handleChinaCensorship();

                this.validator();
                this.fixIESubmitURL();
                this.disableHTML5FormValidation();
                this.adjustWorkflowFeatures();
                this.handleWorkflowInternalForm();
                this.generatePaymentTransactionId();
                // eslint-disable-next-line no-undef
                calculateTimeToSubmit();
                this.setDataCSSSelector();

                if (document.getElementById('progressBar')) {
                    this.setupProgressBar();
                }

                // if there is a donation field
                if (document.querySelector('input[id*="_donation"]')) {
                    this.handleDonationAmount();
                }
                // if there is a custom price field for subscription
                if (document.querySelector('input[id*="_custom_price"]')
                    && window.paymentType === 'subscription'
                    && typeof this.validateCustomPriceField !== 'undefined'
                ) {
                    this.validateCustomPriceField();
                }
                //disable submit if nosubmit=true on request parameters
                if (getQuerystring('nosubmit')) {
                    document.querySelectorAll('.form-submit-button').forEach(function (b) {
                        b.disabled = true;
                        b.classList.add('conditionallyDisabled');
                    });
                }
                //display all sections
                //used for pdf generation
                if (getQuerystring('displayAllSections')) {
                    // First hide all the pages
                    document.querySelectorAll('.form-section').forEach(function (section) {
                        section.style.display = 'block';
                    });
                }

                if (isPreview) {
                    this.handlePreview(getQuerystring('filled') === 'true');
                } else if(this.initializing && this.isFormViewTrackingAllowed) {
                    this.track(_uuid);
                }

                if (this.isWorkflowForm) {
                    this.setupWorkflowOutcomes();
                }

                if (getQuerystring('showAllHiddenFields') == '1') {
                    this.showAllHiddenFields();
                }

                if (getQuerystring('showAllFormSections') == '1') {
                    this.showAllFormSections();
                }

                // when a form is embedded via a 3rd party app
                this.additionalActionsFormEmbedded();

                // old form footer
                // eslint-disable-next-line no-var
                var constructSubmitBanner = function(){
                    // eslint-disable-next-line no-var
                    var button = Array.from(document.querySelectorAll('.form-submit-button')).find(function(el) {return !(el.classList.contains('form-sacl-button') || el.classList.contains('js-new-sacl-button')) });
                    // eslint-disable-next-line no-var
                    var brandingText = (JotForm.newDefaultTheme && JotForm.poweredByText) ? JotForm.poweredByText.replace(/Jotform/, '<b>Jotform</b>') : JotForm.poweredByText;
                    if (window && window.location.href.indexOf('branding21') !== -1) {
                      brandingText = brandingText.replace('JotForm', 'Jotform');
                    }
                    if(button) {
                        // eslint-disable-next-line no-var
                        var buttonWrapper = button.parentNode;
                        // eslint-disable-next-line no-var
                        var banner = document.createElement('a');
                        banner.target = '_blank';
                        banner.href = 'https://www.jotform.com/?utm_source=powered_by_jotform&utm_medium=banner&utm_term=' + _formID + '&utm_content=powered_by_jotform_text&utm_campaign=powered_by_jotform_signup_hp';
                        banner.setText(brandingText);
                        banner.style.display = 'inline-block';
                        // eslint-disable-next-line no-var
                        var fontColor = '#000000';
                        // eslint-disable-next-line no-var
                        var fontFamily = '';
                        // eslint-disable-next-line no-var
                        var sampleLabel = document.querySelector('.form-label');
                        if(sampleLabel !== null) {
                            // eslint-disable-next-line no-var
                            var computedStyles = getComputedStyle(sampleLabel);
                            fontColor = computedStyles.color;
                            fontFamily = computedStyles.fontFamily;
                        }
                        banner.style.opacity = 0.8;
                        banner.style.webkitFontSmoothing = 'antialiased';
                        banner.style.color = fontColor;
                        banner.style.fontFamily  = fontFamily;
                        banner.style.fontSize = JotForm.newDefaultTheme ? '12px' : '11px';
                        banner.className = 'jf-branding';
                        banner.style.paddingTop = '10px';

                        if (JotForm.newDefaultTheme) {
                            // eslint-disable-next-line no-var
                            var submitWrapper = document.createElement('div');
                            submitWrapper.className = 'submitBrandingWrapper';
                            submitWrapper.style.flexDirection = 'column';
                            submitWrapper.appendChild(button);
                            submitWrapper.appendChild(banner);
                            buttonWrapper.appendChild(submitWrapper);
                        } else {
                            // eslint-disable-next-line no-var
                            var buttonsParent = buttonWrapper.parentNode
                            buttonsParent.appendChild(banner);
                            buttonsParent.style.display = 'flex';
                            buttonsParent.style.flexDirection = 'column';
                            banner.style.textAlign = 'center';
                            banner.style.paddingBottom = '10px';
                        }

                        if(getComputedStyle(buttonWrapper).textAlign !== 'center') {
                          // eslint-disable-next-line no-var
                          var linkDimensions = banner.getBoundingClientRect();
                          // eslint-disable-next-line no-var
                          var buttonDimensions = button.getBoundingClientRect();
                          // eslint-disable-next-line no-var
                          var mr = Math.abs((linkDimensions.width - buttonDimensions.width) / 2);
                          if(linkDimensions.width > buttonDimensions.width) {
                            banner.style.marginLeft = '-' + mr + 'px';
                          } else {
                            banner.style.marginLeft = mr + 'px';
                          }
                        }
                    }
                }

                // eslint-disable-next-line no-var
                var createBadgeWrapperEl = function() {
                    // eslint-disable-next-line no-var
                    var div = document.createElement('div');
                    div.setAttribute('class', 'badge-wrapper');
                    return div;
                }
                // eslint-disable-next-line no-var
                var appendBadgeWrapperIntoForm = function() {
                    // eslint-disable-next-line no-var
                    var selectParentPosition = document.querySelector('.form-all')
                    // eslint-disable-next-line no-var
                    var badgeWrapper = selectParentPosition.querySelector('.badge-wrapper');
                    if (badgeWrapper) return badgeWrapper;
                    // eslint-disable-next-line no-var
                    var el = createBadgeWrapperEl();
                    selectParentPosition.appendChild(el);
                    return el;
                }
                // eslint-disable-next-line no-var
                var appendBadgeIntoForm = function(banner) {
                    // eslint-disable-next-line no-var
                    var badgeWrapper = appendBadgeWrapperIntoForm();
                    badgeWrapper.appendChild(banner);
                    banner.addEventListener('load', JotForm.handleIFrameHeight);
                }
                // eslint-disable-next-line no-var
                var displayBadge = function(badgeUrl, badgeClass, badgeAlt, badgeLink, utmParameter, urlParameter) {
                    // eslint-disable-next-line no-var
                    var formID = document.querySelector('input[name="formID"]').value;

                    // eslint-disable-next-line no-var
                    var banner = document.createElement('img');
                    banner.className = badgeClass;
                    banner.src = badgeUrl;
                    banner.alt = badgeAlt;
                    banner.style.display = 'block';
                    banner.style.width = '95px';

                    // eslint-disable-next-line no-var
                    var badgeWrapper = document.createElement('a');
                    badgeWrapper.setAttribute('class', 'badge-wrapper-button ' + badgeClass + '-wrapper');
                    if (!JotForm.enterprise) {
                        badgeWrapper.setAttribute('href', badgeLink + '/?utm_source=formfooter&utm_medium=banner&utm_term=' + formID + '&utm_content=' + utmParameter + '&utm_campaign=form_badges' + urlParameter);
                        badgeWrapper.setAttribute('target', '_blank');
                    }
                    badgeWrapper.appendChild(banner);
                    appendBadgeIntoForm(badgeWrapper);
                }

                if (JotForm.showHIPAABadge) {
                    displayBadge(
                        'https://cdn.jotfor.ms/assets/img/uncategorized/hipaa-badge-compliance.png',
                        'hipaa-badge',
                        'HIPAA Compliance Form',
                        'https://www.jotform.com/hipaa',
                        'hipaa_compliant',
                        ''
                    );
                } else if (JotForm.showJotFormPowered === "old_footer" && window.JotForm.useJotformSign !== 'Yes') {
                    constructSubmitBanner();
                }

                if (JotForm.isEncrypted && window.FORM_MODE !== 'cardform') {
                    displayBadge('https://cdn.jotfor.ms/assets/img/uncategorized/encrypted-form-badge.png', 'encrypted-form-badge', 'Encrypted Form', 'https://www.jotform.com/encrypted-forms', 'encrypted_form', '');
                }

                if (JotForm.showA11yBadge) {
                    // eslint-disable-next-line no-var
                    var formID = document.querySelector('input[name="formID"]').value;
                    // eslint-disable-next-line no-var
                    var banner = document.createElement('img');
                    banner.className = 'accessibility-badge';
                    banner.src = 'https://cdn.jotfor.ms/assets/img/uncategorized/access-image.png';
                    banner.alt = 'accessibility badge';
                    banner.style.display = 'block';
                    banner.style.width = '54px';

                    // eslint-disable-next-line no-var
                    var A11yWrapper = document.createElement('a');
                    A11yWrapper.setAttribute('class', 'badge-wrapper-button accessibility-badge-wrapper');
                    if (!JotForm.enterprise) {
                        A11yWrapper.setAttribute('href', 'https://www.jotform.com/accessible-forms/?utm_source=formfooter&utm_medium=banner&utm_term=' + formID + '&utm_content=accessibility_enabled_form&utm_campaign=form_badges');
                        A11yWrapper.setAttribute('target', '_blank');
                    }

                    // eslint-disable-next-line no-var
                    var A11yContent = document.createElement('div');
                    A11yContent.setAttribute('class', 'a11y-content');

                    // eslint-disable-next-line no-var
                    var A11yTitle = document.createElement('div');
                    A11yTitle.setAttribute('class', 'a11y-title');
                    A11yTitle.textContent = 'ACCESSIBILITY';

                    // eslint-disable-next-line no-var
                    var A11ySubTitle = document.createElement('div');
                    A11ySubTitle.setAttribute('class', 'a11y-subtitle');
                    A11ySubTitle.textContent = 'ENABLED FORM';

                    A11yContent.appendChild(A11yTitle);
                    A11yContent.appendChild(A11ySubTitle);

                    A11yWrapper.appendChild(banner);
                    A11yWrapper.appendChild(A11yContent);
                    appendBadgeIntoForm(A11yWrapper);
                }

                if (typeof JotForm.enterprise !== "undefined" && JotForm.enterprise) {
                    appendHiddenInput('enterprise_server', JotForm.enterprise, { id: 'enterprise_server' });
                }

                if (JotForm.hipaa) {
                    appendHiddenInput('file_server', 'hipaa-app1', { id: 'file_server' });

                    appendHiddenInput('target_env', 'hipaa', { id: 'target_env' });
                }

                // only Chrome support IDNs:  https://www.jotform.com/ticket-categorize/1711024
                if (jotformForm) {

                    // eslint-disable-next-line no-var
                    var mobileSubmitBlock = false;
                    if (/Android|iPhone|iPad|iPod|Opera Mini/i.test(navigator.userAgent) ) {
                        // eslint-disable-next-line no-var
                        var selectorInputs = 'form input:not([type="hidden"], [name="website"], [data-age]), form textarea:not([type="hidden"])';
                        // eslint-disable-next-line no-var
                        var getFields = document.querySelectorAll(selectorInputs);
                        Array.from(getFields).forEach(function(item, index) {
                            item.addEventListener('keypress', function (keyEvent) {
                                // eslint-disable-next-line no-var
                                var nextItem = getFields[index + 1];
                                if (keyEvent.keyCode === 13 && nextItem && keyEvent.target.type !== 'textarea') {
                                    keyEvent.preventDefault();
                                    mobileSubmitBlock = true;
                                    nextItem.focus();
                                } else {
                                    mobileSubmitBlock = false;
                                }
                            })
                        });
                    }

                    // eslint-disable-next-line no-var
                    var convertEmailToASCII = function (e) {
                        if (typeof punycode !== "undefined") {
                            document.querySelectorAll('input[type="email"]').forEach(function (field) {
                                // eslint-disable-next-line no-undef
                                field.value = punycode.toASCII(field.value);
                            });
                        }

                        if (mobileSubmitBlock && !e.isTrusted) {
                            e.valid = false;
                            e.preventDefault();
                        }
                        e.valid = true;
                    }

                    jotformForm.addEventListener('submit', convertEmailToASCII);
                }

                if (JotForm.newDefaultTheme) {
                    window.newDefaultTheme = 'v2';
                }
                window.addEventListener('load', function () {
                    JotForm.makeReadyWidgets();
                    if (history.state !== null && typeof history.state.submitted !== 'undefined' && history.state.submitted) {
                        history.replaceState({submitted: false}, null, null);
                        // eslint-disable-next-line no-var
                        var productIndex = null;
                        if (typeof window.CardForm !== 'undefined') {
                            CardForm.cards.forEach(function (item, index) {
                                if (item.type === 'products') {
                                    productIndex = index;
                                }
                            });
                            if (productIndex !== null) {
                                CardForm.setFormMode('form');
                                CardForm.setCardIndex(productIndex);
                            }
                        }
                    }
                });

            } catch (err) {
                trackExecution('init-error');
                JotForm.error(err);
                if (!JotForm.validatorExecuted) {
                    try {
                        this.errorCatcherLog(err, 'FORM_VALIDATION_NOT_ATTACHED');
                        this.validator();
                        this.disableHTML5FormValidation();
                    } catch (err) {
                        this.errorCatcherLog(err, 'FORM_VALIDATOR_ERROR');
                    }
                } else {
                    this.errorCatcherLog(err, 'FORM_INIT_ERROR');
                }
            }

            this.initializing = false; // Initialization is over
            // eslint-disable-next-line no-var
            var event = new CustomEvent('JotformReady');
            document.dispatchEvent(event);
            if (window.self !== window.top && JotForm.isPaymentSelected() && window.paymentType) { // Payment total counter observer doesn't work for embedded forms. Recalculate money if form is embedded form.
                JotForm.countTotal(JotForm.prices);
            }
            trackExecution('init-complete');
        }.bind(this);

        // eslint-disable-next-line no-var
        var sourceCodeCompatibilityFixers = function () {
            // fetch jotform texts if not existent
            // eslint-disable-next-line no-var
            var fetchFormTexts = function () {
                return new Promise((resolve, reject) => {
                    if (!window.JotForm.texts || Object.keys(window.JotForm.texts).length === 0) {
                        JotForm.setAPIUrl();
                        JotForm.createXHRRequest(JotForm.getAPIEndpoint() + '/form/staticTexts', 'GET', null, function cb(res) {
                            window.JotForm.texts = (res && res.content && typeof res.content === 'object') ? res.content : {}
                            resolve('Successfully fetched form texts');
                        }, function errCb(err) {
                            console.log(err)
                            reject('Form texts could not be fetched');
                        })
                    } else {
                        resolve('Form texts already in window');
                    }
                });
            }

            fetchFormTexts()
                .then(ready)
                .catch((err) => {
                    console.error('An error occurred in source code compatibility fixers:', err);
                    ready();
                });
        }

        if (document.readyState === 'complete' || (this.jsForm && (document.readyState === undefined || document.readyState === 'interactive'))) {
            sourceCodeCompatibilityFixers();
        } else {
            document.ready(sourceCodeCompatibilityFixers);
        }

        const { getLoops, getCalculationMap} = this.conditionDebugger();
        this.loopMap = getLoops();
        this.calculationMap = getCalculationMap();
        this.loopMapExist = this.loopMap && this.loopMap.size;


        if(typeof __conditionDebugger_logPerformance === 'function') { // Try to log before trying the setInterval method way.
            // eslint-disable-next-line no-undef
            __conditionDebugger_logPerformance([{
                title: 'Form Initialization',
                value: (performance.now() - firstPerformancePoint).toFixed(2)
            }]);
        } else if (!window.__pushInitDataInterval) {
            window.__pushInitDataTries = 0;
            window.__pushInitDataInterval = setInterval(function() {
                if(typeof __conditionDebugger_logPerformance === 'function') {
                    // eslint-disable-next-line no-undef
                    __conditionDebugger_logPerformance([{
                        title: 'Form Initialization',
                        value: (performance.now() - firstPerformancePoint).toFixed(2)
                    }]);

                    // eslint-disable-next-line no-undef
                    clearInterval(__pushInitDataInterval);
                }

                // eslint-disable-next-line no-undef
                if (__pushInitDataTries > 30) {
                    // eslint-disable-next-line no-undef
                    clearInterval(__pushInitDataInterval);
                }

                // eslint-disable-next-line no-undef
                __pushInitDataTries++;
            }, 50);
        }
    },

    /**
     * Checks browser or device agent
     */
    browserIs: {
        userAgent: 'navigator' in window && 'userAgent' in navigator && navigator.userAgent.toLowerCase() || '',
        vendor: 'navigator' in window && 'vendor' in navigator && navigator.vendor.toLowerCase() || '',
        appVersion: 'navigator' in window && 'appVersion' in navigator && navigator.appVersion.toLowerCase() || '',
        chrome: function(){return /chrome|chromium/i.test(this.userAgent) && /google inc/.test(this.vendor)},
        firefox: function(){return /firefox/i.test(this.userAgent)},
        ie: function(){return /msie/i.test(this.userAgent) || "ActiveXObject" in window || /edge\//i.test(this.userAgent)},
        safari: function(){return /safari/i.test(this.userAgent) && /apple computer/i.test(this.vendor)},
        operabrowser: function(){return this.userAgent.indexOf("Opera") > -1},
        iphone: function(){return /iphone/i.test(this.userAgent) || /iphone/i.test(this.appVersion)},
        ipad: function(){return /ipad/i.test(this.userAgent) || /ipad/i.test(this.appVersion)},
        ios: function(){return this.iphone() || this.ipad()},
        android: function(){return /android/i.test(this.userAgent)},
        androidPhone: function(){return this.android() && /mobile/i.test(this.userAgent)},
        androidTablet: function(){return this.android() && !this.androidPhone()},
        blackberry: function(){return /blackberry/i.test(this.userAgent) || /BB10/i.test(this.userAgent)},
        linux: function(){return /linux/i.test(this.appVersion)},
        mac: function(){return /mac/i.test(this.appVersion)},
        windows: function(){return /win/i.test(this.appVersion)},
        windowsPhone: function(){return this.windows() && /phone/i.test(this.userAgent)},
        windowsTablet: function(){return this.windows() && !this.windowsPhone() && /touch/i.test(this.userAgent)},
        mobile: function(){return this.iphone() || this.androidPhone() || this.blackberry() || this.windowsPhone();},
        tablet: function(){return this.ipad() || this.androidTablet() || this.windowsTablet()},
        desktop: function(){return !this.mobile() && !this.tablet()},
        webkit: function(){return this.userAgent.indexOf('applewebkit') !== -1},
        ie8AndBelow: function() {return typeof window.addEventListener !== 'function'}
    },

    hasAccessToLocalStorage: function() {
      // eslint-disable-next-line no-var
      var testItem = 'test';
      // eslint-disable-next-line no-var
      var testKey = 'jflocalStorage_test';
      try {
        if (!window.localStorage) return false;
        window.localStorage.setItem(testKey, testItem);
        if (window.localStorage.getItem(testKey) === testItem) {
          window.localStorage.removeItem(testKey)
          return true;
        }
      }
      catch (e) {
        console.log('Error: unable to access local storage');
        return false
      }
      return false;
    },

    iframeRezizeTimeout: null,
    /**
    ** Call handleIFrameHeight only periodically so millions of messages are not sent when user has lots of conditions
    */
    iframeHeightCaller: function() {
        if (window.parent && window.parent != window) {
            clearTimeout(this.iframeRezizeTimeout);
            this.iframeRezizeTimeout = setTimeout((function() {
                this.handleIFrameHeight();
            }).bind(this), 50);
        }
    },

    setIFrameDeviceType: function() {
        if (window.FORM_MODE !== 'cardform') {
            return;
        }
        window.parent.postMessage('setDeviceType:' + window.CardLayout.layoutParams.deviceType + ':', '*');
    },

    setupWorkflowOutcomes: function() {
        const workflowOutcomesQuestion = document.querySelector('.wfOutcomes[data-component="workflow_outcomes"]'); // There MUST be only one instance of this rendered, ever.
        const workflowOutcomesList = workflowOutcomesQuestion.querySelector('.wfOutcomes-list');
        const workflowOutcomesListItems = workflowOutcomesList.querySelectorAll('.wfOutcomes-list-item');
        const workflowOutcomesButton = workflowOutcomesQuestion.querySelector('.wfOutcomes-list-button');
        const workflowOutcomesButtonTextElement = workflowOutcomesButton.querySelector('.wfOutcomes-list-button-text');

        const clearAllOutcomeInputCheckedStates = () => {
            workflowOutcomesListItems.forEach(listItem => {
                listItem.querySelector('.wfOutcomes-list-item-input').removeAttribute('checked');
            })
        }

        workflowOutcomesQuestion.addEventListener('click', () => {
            workflowOutcomesList.classList.toggle('isVisible');
        });

        document.addEventListener('click', e => {
            if ((e.target !== workflowOutcomesList) && workflowOutcomesList.classList.contains('isVisible')) {
                workflowOutcomesList.classList.remove('isVisible');
            }
        }, true);

        workflowOutcomesList.addEventListener('click', e => {
            e.stopPropagation();
        });

        workflowOutcomesListItems.forEach(workflowOutcomesListItem => {
            workflowOutcomesListItem.addEventListener('click', e => {
                clearAllOutcomeInputCheckedStates();

                workflowOutcomesListItem.querySelector('.wfOutcomes-list-item-input').setAttribute('checked', '');
                workflowOutcomesButtonTextElement.innerText = workflowOutcomesListItem.innerText;
                workflowOutcomesButton.setAttribute('style',workflowOutcomesListItem.readAttribute('style'));
                workflowOutcomesList.classList.remove('isVisible');
                e.stopPropagation();
            });
        })
    },

    conditionDebugger: function() {
        let calculationMap = null;
        let calculationLoops = null;

        const resolveCalculationMap = () => {
            if (!calculationMap) {
                calculationMap = new Map();
                JotForm.calculations.forEach(calculation => {
                    const { operands, resultField, baseField } = calculation;
                    const fields = operands ? operands.split(',') : [baseField].filter(Boolean);
                    if (!fields.length) return;
                    fields.forEach(field => {
                        if (!calculationMap.has(field)) calculationMap.set(field, new Set());
                        calculationMap.get(field).add(resultField);
                    });
                });
            }
        };

        const resolve = (affectedFields = [], baseField) => {
            const isLooped = affectedFields.has(baseField);
            if (isLooped) {
                calculationLoops.set(baseField, [...calculationLoops.get(baseField), ...affectedFields]);
                return;
            }
            affectedFields.forEach(affectedField => {
                const relatedAffectedFields = calculationMap.get(affectedField);
                if (!relatedAffectedFields || relatedAffectedFields.has(affectedField) || calculationLoops.get(baseField).indexOf(affectedField) !== -1) return;
                calculationLoops.set(baseField, [...calculationLoops.get(baseField), affectedField]);
                resolve(relatedAffectedFields, baseField);
            });
        };

        const resolveLoops = () => {
            if (!calculationLoops) calculationLoops = new Map();
            calculationMap.forEach((affectedFields, baseField) => {
                if (!calculationLoops.has(baseField)) calculationLoops.set(baseField, []);
                resolve(affectedFields, baseField);
            });
        };

        const getCalculationMap = () => {
            return calculationMap;
        };

        const getLoops = id => {
            if (!calculationMap) resolveCalculationMap();
            if (!calculationLoops) resolveLoops();
            calculationLoops.forEach((value, key) => {
                if (value.indexOf(key) === -1) {
                calculationLoops.delete(key);
                }
            });
            if (id) {
                return calculationLoops.get(`${id}`);
            }
            return calculationLoops;
        };

        return {
            resolveCalculationMap,
            resolveLoops,
            getLoops,
            getCalculationMap
        };
    },

    calendarCheck: function(){
      // eslint-disable-next-line no-var
      var section = JotForm.currentSection;

      if(!section){
        section = document.querySelector('.form-section');
      }

      // eslint-disable-next-line no-var
      var formLineCount = section.querySelectorAll('.form-line').length;
      // eslint-disable-next-line no-var
      var calendar = false;

      section.querySelectorAll('.form-line').forEach(function (element, index) {
        if(index >= formLineCount - 2 && element.dataset.type === 'control_datetime'){
          // eslint-disable-next-line no-var
          var elementId = element.id.split('_')[1];
          calendar = JotForm.getCalendar(elementId);
        }
      });

      return calendar;
    },
    getFormId: function() {
        // eslint-disable-next-line no-var
        var currentForm = document.querySelector('form');
        // eslint-disable-next-line no-var
        var formId = currentForm && currentForm.id ? currentForm.id : '';
        return formId;
    },
    isFormInNewIframeHeightCalculation: function() {
        // let observerExists = true;
        // if (typeof MutationObserver === 'undefined') {
        //     logError && JotForm.errorCatcherLog({observerType: 'mutation'}, 'OBSERVER_NOT_FOUND_IN_BROWSER');
        //     observerExists = false;
        // } else if (typeof ResizeObserver === 'undefined') {
        //     logError && JotForm.errorCatcherLog({observerType: 'resize'}, 'OBSERVER_NOT_FOUND_IN_BROWSER');
        //     observerExists = false;
        // }
        return false;
    },
    resetGRECaptcha: function() {
        try{
            if (!window.hcaptcha && window.grecaptcha && typeof window.grecaptcha.reset === 'function' && !window.grecaptcha.resetted) {
                window.grecaptcha.resetted = true;
                window.grecaptcha.reset();
                console.log('grecaptcha resetted');
            }
        } catch(e){
            console.log("grecaptcha - ", e);
        }
    },
    postHeightForOEmbed(value) {
        if (!window.location || window.location.host !== 'oembed.jotform.com') {
            return;
        }

        // Embedly
        window.parent.postMessage(JSON.stringify({
            src: window.location.toString(),
            context: 'iframe.resize',
            height: value
        }), '*');
    },
    newHandleIframeHeight: function() {
        const height = JotForm.handleIFrameHeight(true);
        if (height) {
            if (Math.abs(JotForm.prevEmbedFormHeight - height) <= 5) {
                return;
            }
            if ("console" in window && "log" in console && JotForm.debug) {
                console.log('Debug : setting height to ', height, ' from new iframe height handler');
            }
            window.parent.postMessage('setHeight:' + height + ':' + JotForm.getFormId(), '*');
            this.postHeightForOEmbed(height);
            JotForm.prevEmbedFormHeight = height;
        }
    },
    handleIFrameHeight: function (returnHeight = false) {
        if (JotForm.isFormInNewIframeHeightCalculation() && !returnHeight) {
            return;
        }
        // eslint-disable-next-line no-var
        var form = document.querySelectorAll('.jotform-form').length > 0 ? document.querySelector('.jotform-form') : document.querySelector('body')
        // eslint-disable-next-line no-var
        var height = Math.max(JotForm.getDimensions(form).height, form.scrollHeight, form.offsetHeight)
        // eslint-disable-next-line no-var
        var isEmbedForm = document.querySelectorAll(".supernova.isEmbeded").length > 0;

        if (isEmbedForm && JotForm.getDimensions(form).width === 0) {
            // iframe is not visible, so we can't calculate the height
            // we will try again on next resize event

            console.warn('iframe is not visible, so we can\'t calculate the height');
            return;
        }

        // eslint-disable-next-line no-var
        var isEmbeddedInPortal = document.querySelectorAll(".supernova.isEmbeddedInPortal").length > 0;

        // Cover Image
        // eslint-disable-next-line no-var
        var formWrapper = document.querySelector('.form-all');
        // eslint-disable-next-line no-var
        var formWrapperComputedStyle = getComputedStyle(formWrapper);
        // eslint-disable-next-line no-var
        var marginTop = parseInt(formWrapperComputedStyle.marginTop, 10);
        // eslint-disable-next-line no-var
        var marginBottom = parseInt(formWrapperComputedStyle.marginBottom, 10);
        if (!isNaN(marginTop)) {
          height += marginTop;
        }
        if (!isNaN(marginBottom) && !isEmbeddedInPortal) {
            height += marginBottom;
        }

        // eslint-disable-next-line no-var
        var openCalendars = document.querySelectorAll(
          '.calendar.popup:not([style*="display: none"])'
        );
        if (openCalendars.length > 0) {
          // find the calendar with the highest top position
          openCalendars.forEach(function (calendar) {
            // eslint-disable-next-line no-var
            var calendarBottom = calendar.getBoundingClientRect().bottom;
            if (height > calendarBottom) {
              return;
            }

            height = calendarBottom;
            console.log('calendar height is bigger than form height, increasing form height to ' + height);
          });
        }

        // if form has importedPDF set height to welcomeView height or leave it as is
        const isWelcomeMode = document.querySelector('html').getAttribute('data-mode') === 'welcomeMode';
        if (
            typeof JotForm.importedPDF !== 'undefined'
            && typeof MutationObserver !== 'undefined'
            && typeof ResizeObserver !== 'undefined'
            && JotForm.importedPDF
            && isWelcomeMode
        ) {
            const welcomeView = document.querySelector('#pdfimporter-root .pdff-welcomeView');
            const welcomeViewHeight = welcomeView ? Math.max(welcomeView.offsetHeight + 160, 539) : 0; // 160px is top and bottom padding
            height = welcomeViewHeight > 0 ? welcomeViewHeight : height;
        }

        // if form has formuser-header, add its height to the form height
        const formUserHeader = document.querySelector('.jfFormUser-header');
        if (formUserHeader) {
            height += formUserHeader.offsetHeight;
        }

        // if this is a captcha verification page, set height to 350
        height = ( document.title === 'Please Complete' ) ? 350 : height;

        if (window.FORM_MODE === 'cardform') {
            document.body.classList.add('isEmbed')

            // eslint-disable-next-line no-var
            var isSmartEmbed = document.body.classList.contains('isSmartEmbed')
            // this calculation should be calculated from ground
            height = isSmartEmbed ? 464 : 640;

            // checking for smart and/or inline embed settings
            try {
                // eslint-disable-next-line no-var
                var formFrame = window.parent.document.querySelector('[id="' + form.id + '"], [id="JotFormIFrame-' + form.id + '"]');
                if (formFrame && formFrame.hasAttribute('data-frameHeight')) {
                    height = formFrame.getAttribute('data-frameHeight');
                }
            } catch(e) {
                /* noop */
            }
        }
        if (isEmbedForm) {
          // eslint-disable-next-line no-var
          var computedStyles = getComputedStyle(document.querySelector(".supernova.isEmbeded"));
          // eslint-disable-next-line no-var
          var backgroundImage = computedStyles.getPropertyValue("background-image");

          if (backgroundImage && backgroundImage != 'none') {
            // eslint-disable-next-line no-var
            var backgroundStyles = new URLSearchParams();
            // eslint-disable-next-line no-var
            var properties = ["background-image", "background-size", "background-position", "background-repeat", "background-attachment", "background-color"];
              properties.forEach(function (property) {
                backgroundStyles.set(property, computedStyles.getPropertyValue(property));
              });
            window.parent.postMessage('backgroundStyles:' + backgroundStyles.toString() + ':' + form.id, '*');
          }

          /* reset greacaptcha on first height calculation.
           * some users are hiding the form initially and showing it later.
           * this causes grecaptcha to calculate their positions wrong. */

          JotForm.resetGRECaptcha();
        }
        if ("console" in window) {
            if ("log" in console && JotForm.debug) {
                console.log('Debug : setting height to ', height, ' from iframe');
            }
        }

        // eslint-disable-next-line no-var
        var isFeedbackEmbedButton = window.FORM_MODE === 'cardform' && document.location.search.indexOf('feedbackEmbedButton') > -1;
        if (!isFeedbackEmbedButton) {
            if (JotForm.isFormInNewIframeHeightCalculation()) {
                return height;
            }
            window.parent.postMessage('setHeight:' + height + ':' + form.id, '*');
            if (typeof this.postHeightForOEmbed !== "undefined") {
                this.postHeightForOEmbed(height);
            }
        }
    },
    fixIESubmitURL: function () {
        try {
            // IE on XP does not support TLS SSL
            // http://en.wikipedia.org/wiki/Server_Name_Indication#Support
            if (this.ie() <= 8 && navigator.appVersion.indexOf('NT 5.')) {
                $A(this.forms).each(function (form) {
                    if (form.action.include("s://submit.")) {
                        form.action = form.action.replace(/\/\/submit\..*?\//, "//secure.jotform.com/");
                    }
                });
            }
        } catch (e) {
        }
    },
    screenshot: false, // Cached version of screenshot
    passive: false, // States if wishbox iis getting screenshot passively
    onprogress: false, // Are we currently processing a screenshot?
    compact: false, // Use the compact mode of the editor
    imageSaved: false, // Check if the image saved by screenshot editor

    getCharset: function (doc) {
        if (!doc) {
            doc = document;
        }

        return doc.characterSet || doc.defaultCharset || doc.charset || 'UTF-8';
    },
    /**
     * Convert number of bytes into human readable format
     *
     * @param integer bytes     Number of bytes to convert
     * @param integer precision Number of digits after the decimal separator
     * @return string
     */
    bytesToSize: function (bytes, precision) {
        // eslint-disable-next-line no-var
        var sizes = ['B', 'KB', 'MB', 'GB', 'TB'];
        // eslint-disable-next-line no-var
        var posttxt = 0;
        if (bytes == 0) return 'n/a';
        if (bytes < 1024) {
            return Number(bytes) + " " + sizes[posttxt];
        }
        while (bytes >= 1024) {
            posttxt++;
            bytes = bytes / 1024;
        }
        return bytes.toFixed(precision || 2) + " " + sizes[posttxt];
    },
    /*
     * Disables HTML5 validation for stopping browsers to stop submission process
     * (fixes bug of pending submissions when jotform validator accepts email field
     * and browsers' own validator doesn't )
     */
    disableHTML5FormValidation: function () {
        document.querySelectorAll("form").forEach(function (f) {
            f.setAttribute("novalidate", true);
        });
    },

    /**
     * Checks if JSON is available and loads it if not
     */
    checkJSON: function () {
        if (typeof JSON !== 'object') {
            // eslint-disable-next-line no-var
            var script = document.createElement('script');
            script.type = "text/javascript";
            script.src = "/js/vendor/json2.js";
            document.body.appendChild(script);
        }
    },
    /**
     * Will get additional URL queries from SCRIPT embed or feedback widget
     */
    populateGet: function () {
        try {
            if ('FrameBuilder' in window.parent && "get" in window.parent.FrameBuilder && window.parent.FrameBuilder.get != []) {

                // eslint-disable-next-line no-var
                var outVals = {};
                // eslint-disable-next-line no-var
                var getVals = window.parent.FrameBuilder.get;
                $H(getVals).each(function (pair) {
                    if (typeof pair[1] === 'object') {
                        // eslint-disable-next-line no-undef
                        for (prop in pair[1]) {
                            // eslint-disable-next-line no-undef
                            outVals[pair[0] + "[" + prop + "]"] = pair[1][prop];
                        }
                    } else {
                        outVals[pair[0]] = pair[1];
                    }


                });
                document.get = Object.extend(document.get, outVals);
            }
        } catch (e) {
        }
    },
    /**
     * Php.js uniqueID generator
     * @param {Object} prefix
     * @param {Object} more_entropy
     */
    uniqid: function (prefix, more_entropy) {
        if (typeof prefix == 'undefined') {
            prefix = "";
        }
        // eslint-disable-next-line no-var
        var retId;
        // eslint-disable-next-line no-var
        var formatSeed = function (seed, reqWidth) {
            seed = parseInt(seed, 10).toString(16); // to hex str
            if (reqWidth < seed.length) {
                return seed.slice(seed.length - reqWidth);
            }
            if (reqWidth > seed.length) {
                return Array(1 + (reqWidth - seed.length)).join('0') + seed;
            }
            return seed;
        };
        if (!this.php_js) {
            this.php_js = {};
        }
        if (!this.php_js.uniqidSeed) {
            this.php_js.uniqidSeed = Math.floor(Math.random() * 0x75bcd15);
        }
        this.php_js.uniqidSeed++;
        retId = prefix;
        retId += formatSeed(parseInt(new Date().getTime() / 1000, 10), 8);
        retId += formatSeed(this.php_js.uniqidSeed, 5);
        if (more_entropy) {
            retId += (Math.random() * 10).toFixed(8).toString();
        }
        return retId;
    },

    /**
     * Initiates multiple upload scripts
     */
    initMultipleUploads: function () {
        // eslint-disable-next-line no-var
        var self = this;
        // for mobile; prevent device sleep
        // but not in jotform next. fix for #1816394, #1878538, #1879000
        // eslint-disable-next-line no-var
        var isJotFormNext = JotForm.isJotFormNext || /jotformNext=1/.test(window.location.href);
        // eslint-disable-next-line no-var
        var isIosApp = JotForm.browserIs.ios() && !JotForm.browserIs.safari(); // ios webview blank video issue
        if (JotForm.browserIs.mobile() && !isJotFormNext && !isIosApp) {
            // eslint-disable-next-line no-var
            var loadingNoSleepScript = true;
            // eslint-disable-next-line no-var
            var baseScriptURL = 'https://cdn.jotfor.ms';
            if (JotForm.enterprise || window.location.href.indexOf('jotform.pro') > -1) {
                baseScriptURL = window.location.origin;
            }
            // eslint-disable-next-line no-var
            var noSleepURL = baseScriptURL + '/s/static/latest/js/vendor/NoSleep.min.js';
            JotForm.loadScript(noSleepURL, function () {
                loadingNoSleepScript = false;
            });

            // eslint-disable-next-line no-var
            var toggleNoSleep = function () {
                if (loadingNoSleepScript || typeof NoSleep === 'undefined') { return; }
                // eslint-disable-next-line no-var, no-undef
                var noSleep = new NoSleep();
                noSleep.enable();
                document.removeEventListener('click', toggleNoSleep, true);
            };
            document.addEventListener('click', toggleNoSleep, true);
        }

        if (isJotFormNext && JotForm.switchedToOffline && JotForm.rawMultipleFileInputs) {
            JotForm.resetMultipleUploadsBasicMarkup();
        }
        if (window.FORM_MODE !== 'cardform') {
            callIframeHeightCaller();
        }

        JotForm.uploader = {};
        $$('.form-upload-multiple').each(function (file) {
            // eslint-disable-next-line no-var
            var parent = file.up('div');
            // eslint-disable-next-line no-var
            var f = JotForm.getForm(file);
            // eslint-disable-next-line no-var
            var formID = f.formID.value;

            if (isJotFormNext) {
                // Keeping raw inputs in case of user goes offline while filling on JotFormNext.
                JotForm.captureMultipleUploadsBasicMarkup(file);
            }

            // eslint-disable-next-line no-var
            var uniq = formID + "_" + JotForm.uniqueID;

            // Handle upload fail validation
            parent.addClassName('validate[multipleUpload]');

            // Handle default validations. reuired field
            // eslint-disable-next-line no-var
            var className = file.className;
            if (className.include("validate[required]")) {
                if (parent.className.indexOf("validate[required]") === -1) {
                    parent.addClassName("validate[required]");
                }
            }

            if (JotForm.isFillingOffline()) {
                document.querySelectorAll('input[type="file"].form-upload-multiple').forEach(input => {
                  input.addEventListener('change', () => {
                    const parent = input.closest('.validate\\[multipleUpload\\]');
                    if (parent && typeof parent.validateInput === 'function') {
                      parent.validateInput();
                    }
                  });
                });
              }

            parent.validateInput = function() {
                // eslint-disable-next-line no-var
                var _isVisible = JotForm.isVisible(parent);
                if (JotForm.doubleValidationFlag()) {
                    _isVisible = !(JotForm.isInputAlwaysHidden(parent));
                }
                // Don't fire validations for hidden elements
                if (!_isVisible) {
                    JotForm.corrected(parent);
                    return true;
                }

                if (JotForm.isFillingOffline()) {
                    // Added for mobile app
                    // eslint-disable-next-line no-var
                    var fileInput = parent.querySelector('input[type="file"].form-upload-multiple');
                    if (!fileInput || !fileInput.files || fileInput.files.length === 0) {
                        JotForm.corrected(parent);
                        return true;
                    }

                    // eslint-disable-next-line no-var
                    var allowedExtensionsAttr = fileInput.getAttribute('data-file-accept');
                    if (!allowedExtensionsAttr) {
                        JotForm.corrected(parent);
                        return true;
                    }

                    // eslint-disable-next-line no-var
                    var allowedExtensions = allowedExtensionsAttr.split(',').map(e => e.trim().toLowerCase());
                    // eslint-disable-next-line no-var
                    var files = fileInput.files;
                    // eslint-disable-next-line no-var
                    var invalidFiles = [];

                    // eslint-disable-next-line no-var
                    for (var i = 0; i < files.length; i++) {
                        // eslint-disable-next-line no-var
                        var file = files[i];
                        // eslint-disable-next-line no-var
                        var fileExt = file.name.toLowerCase().split('.').pop();
                        if (!allowedExtensions.includes(fileExt)) {
                            invalidFiles.push(file.name);
                        }
                    }

                    if (invalidFiles.length > 0) {
                        // eslint-disable-next-line no-var
                        var errorMsg = `The following file(s) have an invalid extension: ${invalidFiles.join(', ')}. ` +
                                       `Allowed types: ${allowedExtensions.join(', ')}.`;
                        return JotForm.errored(parent, errorMsg);
                    }

                    let sizeLimitActive = fileInput.getAttribute('data-limit-file-size') || fileInput.getAttribute('limit-file-size');
                    let maxFileSizeKB = parseInt((fileInput.getAttribute('data-file-maxsize') || fileInput.getAttribute('file-maxsize')), 10);

                    if (sizeLimitActive !== 'No' && maxFileSizeKB > 0) {
                        let maxFileSize = maxFileSizeKB * 1024;
                        let oversizedFiles = [];

                        for (let j = 0; j < files.length; j++) {
                            let fileToCheck = files[j];
                            if (fileToCheck.size > maxFileSize) {
                                let fileSizeMB = (fileToCheck.size / (1024 * 1024)).toFixed(2);
                                oversizedFiles.push({
                                    name: fileToCheck.name,
                                    size: fileSizeMB + 'MB'
                                });
                            }
                        }

                        if (oversizedFiles.length > 0) {
                            let maxSizeFormatted = (maxFileSize / (1024 * 1024)).toFixed(2) + 'MB';

                            let fileSizeErrorMsg = `The following file(s) exceed the ${maxSizeFormatted} size limit: ${oversizedFiles.map(f => `${f.name} (${f.size})`).join(', ')}`;
                            return JotForm.errored(parent, fileSizeErrorMsg);
                        }
                    }

                    JotForm.corrected(parent);
                    return true;
                }

                // eslint-disable-next-line no-var
                var fileList = parent.select('.qq-upload-list li:not(.file-deleted)');
                if (fileList.length < 1) {
                    if (parent.match('[class*=validate[required]]')) {
                        JotForm.corrected(parent);
                        return JotForm.errored(parent, JotForm.texts.required);
                    }else{
                        JotForm.corrected(parent);
                        return true;
                    }
                } else {
                    // eslint-disable-next-line no-var
                    var status = true;
                    fileList.each(function(elem) {
                        if (elem.getAttribute('class') && elem.getAttribute('class').indexOf('fail') >= 0) {
                            status = false;
                        }
                    });
                    if (status) {
                        JotForm.corrected(parent);
                        return true;
                    } else {
                        JotForm.errored(parent, JotForm.texts.multipleFileUploads_uploadFailed);
                        return false;
                    }
                }
            }

            // Create temp upload folder key
            if (!JotForm.tempUploadFolderInjected) {
                f.appendChild(createHiddenInputElement({ name: 'temp_upload_folder', value: uniq }));
                JotForm.tempUploadFolderInjected = true;
            }

            // Handle limited extensions
            // eslint-disable-next-line no-var
            var exts = (file.readAttribute('data-file-accept') || file.readAttribute('file-accept') || "").strip();
            exts = (exts !== '*') ? exts.split(',').map(function (item) { return item.trim(); }) : [];

            // Handle sublabels
            // eslint-disable-next-line no-var
            var n, subLabel = "";
            if ((n = file.next()) && n.hasClassName('form-sub-label')) {
                subLabel = n.innerHTML;
            }

            //Emre: to make editing "text of multifile upload button" possible (33318)
            // eslint-disable-next-line no-var
            var m, buttonText, cancelText = 'Cancel', ofText = 'of';
            if (m = file.previous('.qq-uploader-buttonText-value')) {
                buttonText = m.innerHTML;
            }
            if (m = file.up('li.form-line').querySelector('.jfUpload-button')) {
                // eslint-disable-next-line no-var
                var isV2 = m.readAttribute('data-version') === 'v2';
                buttonText = isV2 ? m.innerHTML : m.innerText;
            }
            if (!buttonText) {
                buttonText = "Upload a File";
            }
            // Select & Assign cancel and of text
            if (subLabel){
                if (m = parent.querySelector(".cancelText")) {
                    cancelText = m.innerText;
                }
                if (m = parent.querySelector(".ofText")) {
                    ofText = m.innerText;
                }
            }
            else {
                if (m = parent.siblings().find(function (el) { return el.className === 'cancelText'})) {
                    cancelText = m.innerText;
                }
                if (m = parent.siblings().find(function (el) { return el.className === 'ofText'})) {
                    ofText = m.innerText;
                }
            }

            // Hasan
            // Get button style class
            // eslint-disable-next-line no-var
            var classNames = file.className.split(' ');
            // eslint-disable-next-line no-var
            var buttonStyle = '';
            $A(classNames).each(function (className) {
                if (className.indexOf('form-submit-button-') === 0) {
                    buttonStyle = className;
                }
            });

            // Initiate ajax uploader
            try {
                // eslint-disable-next-line no-var
                var eventIDElement = document.querySelector('input[name="event_id"]');
                // eslint-disable-next-line no-var, no-undef
                var uploader = JotForm.isFillingOffline() ? false : new qq.FileUploader({
                    debug: JotForm.debug,
                    element: parent,
                    action: JotForm.server,
                    subLabel: subLabel,
                    buttonText: buttonText,
                    buttonStyle: buttonStyle,
                    fileLimit: file.readAttribute('data-file-limit') || file.readAttribute('file-limit'),
                    sizeLimitActive: file.readAttribute('data-limit-file-size') || file.readAttribute('limit-file-size'),
                    sizeLimit: parseInt((file.readAttribute('data-file-maxsize') || file.readAttribute('file-maxsize')), 10) * 1024, // Set file size limit
                    minSizeLimit: parseInt((file.readAttribute('data-file-minsize') || file.readAttribute('file-minsize')), 10) * 1024,
                    allowedExtensions: exts,
                    cancelText: cancelText,
                    ofText: ofText,
                    messages: {
                        typeError: self.texts.multipleFileUploads_typeError,
                        sizeError: self.texts.multipleFileUploads_sizeError,
                        minSizeError: self.texts.multipleFileUploads_minSizeError,
                        emptyError: self.texts.multipleFileUploads_emptyError,
                        onLeave: self.texts.multipleFileUploads_onLeave,
                        fileLimitError: self.texts.multipleFileUploads_fileLimitError
                    },
                    onComplete: function (id, filename, response) {
                        console.log('onComplete', arguments);
                        if (response.success) {
                            // append uploaded filename to a hidden input for backend validation
                            // eslint-disable-next-line no-var
                            var qFolder = file.name.replace('[]', '');
                            if ('message' in response) {
                                filename = response.message;
                            }
                            // eslint-disable-next-line no-var
                            var uploadHiddenID = [this.params.folder, qFolder, filename].join('_');
                            // eslint-disable-next-line no-var
                            var uploadHiddenInput = document.getElementById(uploadHiddenID);
                            if (!uploadHiddenInput) {
                                uploadHiddenInput = createHiddenInputElement({ name: 'temp_upload[' + qFolder + '][]', id: uploadHiddenID });
                                f.appendChild(uploadHiddenInput);
                            }
                            uploadHiddenInput.value = filename;
                            if (JotForm.uploadServerURL) {
                                uploadHiddenInput.value = filename + '#' + response.fileServer;
                            }
                            if ($('draftID')) {
                                // eslint-disable-next-line no-var
                                var uploadedFiles = [];
                                // eslint-disable-next-line no-var
                                var uploadedFileID = ['uploadNewForSACL', qFolder].join('-');
                                // eslint-disable-next-line no-var
                                var uploadedFileInput = document.getElementById(uploadedFileID);
                                if (!uploadedFileInput) {
                                    uploadedFileInput = createHiddenInputElement({ name: uploadedFileID, id: uploadedFileID });
                                    f.appendChild(uploadedFileInput);
                                } else {
                                    uploadedFiles = uploadedFiles.concat(JSON.parse(uploadedFileInput.value));
                                }
                                uploadedFiles.push(uploadHiddenInput.value);
                                uploadedFileInput.value = JSON.stringify(uploadedFiles);
                            }
                            // eslint-disable-next-line no-var
                            var fileServerInput = document.getElementById('file_server');
                            if (!fileServerInput) {
                                fileServerInput = createHiddenInputElement({ name: 'file_server', id: 'file_server' });
                                f.appendChild(fileServerInput);
                            }
                            fileServerInput.value = response.fileServer;

                            // This is needed for validations. Removes required message
                            parent.value = 'uploaded';
                            parent.validateInput();
                        }
                    },
                    onDelete: function(folder, field, filename) {
                        // eslint-disable-next-line no-var
                        var id = [folder, field, filename].join('_');
                        if ($('draftID')) {
                            // eslint-disable-next-line no-var
                            var uploadedFileID = ['uploadNewForSACL', field].join('-');
                            // eslint-disable-next-line no-var
                            var uploadedFile = $(uploadedFileID);
                            // eslint-disable-next-line no-var
                            var uplodedFileArray = uploadedFile ? JSON.parse(uploadedFile.value) : [];
                            // eslint-disable-next-line no-var
                            var deletedFile = filename;
                            if (JotForm.uploadServerURL) {
                                deletedFile = $(id).value;
                            }
                            if (uplodedFileArray.includes(deletedFile)){
                                const filteredUplodedFileArray = uplodedFileArray.filter(function (item) {
                                    return item !== deletedFile;
                                });
                                if (filteredUplodedFileArray.length < 1){
                                    $(uploadedFileID).remove();
                                } else{
                                    uploadedFile.value = JSON.stringify(filteredUplodedFileArray);
                                }
                            } else if ($(id)) {
                                // eslint-disable-next-line no-var
                                var deletedFiles = [];
                                // eslint-disable-next-line no-var
                                var deletedFileID = ['deletedFileForSACL', field].join('-');
                                // eslint-disable-next-line no-var
                                var deletedFileInput = document.getElementById(deletedFileID);
                                if (!deletedFileInput) {
                                    deletedFileInput = createHiddenInputElement({ name: deletedFileID, id: deletedFileID });
                                    f.appendChild(deletedFileInput);
                                } else {
                                    deletedFiles = deletedFiles.concat(JSON.parse(deletedFileInput.value));
                                }
                                deletedFiles.push(deletedFile);
                                deletedFileInput.value = JSON.stringify(deletedFiles);
                            }
                        }

                        // Remove hidden fileUpload input
                        if ($(id)) $(id).remove();
                        parent.validateInput();
                    },
                    showMessage: function (message) {
                        console.log('showMessage', arguments);
                        // clear any previous error
                        JotForm.corrected(parent);
                        // show error
                        JotForm.errored(parent, message);
                    },
                    params: {
                        action: 'multipleUpload',
                        field: file.name ? file.name.replace('[]', '') : '',
                        origin: window.location.origin || (window.location.protocol + '//' + window.location.hostname),
                        folder: uniq,
                        event_id: eventIDElement && eventIDElement.value
                    },
                    onSubmit: function() {
                        this.params.folder = document.querySelector("input[name='temp_upload_folder']").value;
                    }
                });

                // eslint-disable-next-line no-var
                var initWarningTranslations = function(t) {
                    setTimeout(function () {
                        if (uploader && uploader._options) {
                            uploader._options.messages = {
                                typeError: self.texts.multipleFileUploads_typeError,
                                sizeError: self.texts.multipleFileUploads_sizeError,
                                minSizeError: self.texts.multipleFileUploads_minSizeError,
                                emptyError: self.texts.multipleFileUploads_emptyError,
                                onLeave: self.texts.multipleFileUploads_onLeave,
                                fileLimitError: self.texts.multipleFileUploads_fileLimitError
                            };
                        }
                    }, t);
                };

                initWarningTranslations(1000);
                JotForm.uploader[file.id] = uploader;
            } catch (e) {
                console.log(e);
            }
        });

        // Get fileupload heading texts from form warnings
        Array.from(document.querySelectorAll('.jfUpload-text, .qq-upload-button')).forEach(function(field) {
            // eslint-disable-next-line no-var
            var heading = field.querySelector('.jfUpload-heading.forDesktop');
            heading && (heading.textContent = JotForm.texts.dragAndDropFilesHere_infoMessage);
            //for Mobile
            // eslint-disable-next-line no-var
            var headingMobile = field.querySelector('.jfUpload-heading.forMobile');
            headingMobile && (headingMobile.textContent = JotForm.texts.chooseAFile_infoMessage);
            // eslint-disable-next-line no-var
            var subHeading = field.querySelector('.maxFileSize');
            subHeading && (subHeading.textContent = JotForm.texts.maxFileSize_infoMessage);
        });
    },

    /**
     *  Captures multiple file upload markup in order to reset multiple uploads later.
     */
    captureMultipleUploadsBasicMarkup: function (fileInput) {
        if (!JotForm.rawMultipleFileInputs) JotForm.rawMultipleFileInputs = {};

        // eslint-disable-next-line no-var
        var qID = fileInput.getAttribute('id').match(/input_(.*)/)[1];
        if (qID) {
            JotForm.rawMultipleFileInputs[qID] = fileInput.outerHTML;
        }
    },

    /**
     *  Restores multiple file upload markup (with uploaded file info) to it's original (not scripted yet) state.
     */
    resetMultipleUploadsBasicMarkup: function () {
        Object.keys(JotForm.rawMultipleFileInputs).forEach(function(qID) {
            const fileInput = document.querySelector('li#id_' + qID + ' input[type="file"]');
            const inputContainer = fileInput.closest('div.validate\\[multipleUpload\\]');
            const rawInput = JotForm.rawMultipleFileInputs[qID];
            if (!inputContainer || !rawInput) return;

            const fileList = inputContainer.querySelector('ul.qq-upload-list');
            let fileListMarkup = '';
            if (fileList) {
              // Removing delete buttons
              fileList.querySelectorAll('.qq-upload-delete').forEach(function (each) {
                each.parentNode.removeChild(each);;
              });
              fileListMarkup = fileList.outerHTML;
            }

            while (inputContainer.firstChild) inputContainer.removeChild(inputContainer.firstChild);

            inputContainer.insertAdjacentHTML('afterbegin', rawInput);
            inputContainer.insertAdjacentHTML('beforeend', fileListMarkup);
        });
    },

    /**
     * Hiddenly submits the form on backend
     */
    hiddenSubmit: function (frm, options) {
        // eslint-disable-next-line no-var
        var checkPagesNumber = document.querySelectorAll('.form-section') || null;
        // eslint-disable-next-line no-var
        var currentPage = JotForm.currentSection.pagesIndex;
        // eslint-disable-next-line no-var
        var selectPageBreak = (JotForm.newDefaultTheme && checkPagesNumber.length === currentPage) ? '.form-pagebreak-back-container' : '.form-pagebreak';

        if (JotForm.currentSection) {
            // eslint-disable-next-line no-var
            var formSavingIndicatorEl = document.createElement('div');
            formSavingIndicatorEl.className = 'form-saving-indicator';
            formSavingIndicatorEl.style.float = 'right';
            formSavingIndicatorEl.style.padding = '21px 12px 10px';
            formSavingIndicatorEl.innerHTML = '<img src="' + JotForm.url + 'images/ajax-loader.gif" align="absmiddle" /> Saving...';

            JotForm.currentSection.querySelector(selectPageBreak).appendChild(formSavingIndicatorEl);
        }

        /**
         * Wait just a little to set saving status.
         * We need this because of the back button hack for last page.
         * Last page back button has two click events they both should work
         * but saving status prevents second one to be working
         */
        setTimeout(function () {
            JotForm.saving = true;
            JotForm.disableButtons();
        }, 10);
        // eslint-disable-next-line no-var
        var isCardForm = window.FORM_MODE == 'cardform';

        if (!$('hidden_submit_form')) {
            // eslint-disable-next-line no-var
            var iframe = document.createElement('iframe');
            iframe.name = 'hidden_submit';
            iframe.id = 'hidden_submit_form';
            iframe.style.display = 'none';

            iframe.observe('load', function () {
                JotForm.makeUploadChecks();
                $$('.form-saving-indicator').invoke('remove');
                JotForm.saving = false;
                JotForm.enableButtons();
            });
            $(document.body).insert(iframe);
        }
        $$('.form-radio-other,.form-checkbox-other').each(function (el) { //disable other textbox if not "other" option selected
            if (!el.checked && JotForm.getOptionOtherInput(el)) {
                JotForm.getOptionOtherInput(el).disable();
            }
        });
        $$('.custom-hint-group').each(function (elem) { //remove textarea hints
            elem.hideCustomPlaceHolder();
        });
        if($('current_page')) {
          $('current_page').value = JotForm.currentSection.pagesIndex;
        }
        frm.writeAttribute('target', 'hidden_submit');
        frm.insert({
            top: createHiddenInputElement({
                name: 'hidden_submission',
                id: 'hidden_submission',
                value: '1'
            })
        });

        if (isCardForm) {
            frm.insert({
                top: createHiddenInputElement({
                    name: 'continueLater',
                    id: 'continueLater',
                    value: '1'
                })
            });
        }

        trackExecution('hidden-submit-async-' + (options && !!options.async));

        if(options && !!options.async){
            // eslint-disable-next-line no-var
            var frmAction = new URL(frm.action);
            if (frm.action.include('pci.jotform')) {
              // eslint-disable-next-line no-var
              var formUrl = new URL(this.url);
              frmAction.hostname = formUrl.hostname;
            }

            // eslint-disable-next-line no-var
            var xhr = new XMLHttpRequest();
            xhr.withCredentials = true;
            xhr.open('POST', frmAction, true);
            xhr.addEventListener('load', function () {
                // eslint-disable-next-line no-var
                var response = this;
                if (isCardForm) {
                    JotForm.saving = false;
                    JotForm.enableButtons();
                }
                if (200 === response.status) {
                    if (options.onSuccessCb) options.onSuccessCb(response);
                } else {
                    if (options.onFailureCb) options.onFailureCb();
                }

                if (options.onCompleteCb) options.onCompleteCb();

                frm.writeAttribute('target', '');
                if (isCardForm) {
                    $('continueLater') && $('continueLater').remove();
                }
                $('hidden_submission') && $('hidden_submission').remove();

                $$('.custom-hint-group').each(function (elem) { //reapply textarea hints
                    elem.showCustomPlaceHolder();
                });

                $$('.form-radio-other,.form-checkbox-other').each(function (el) { //reenable other textbox if not "other" option selected
                    if (!el.checked && JotForm.getOptionOtherInput(el)) {
                        JotForm.getOptionOtherInput(el).enable();
                    }
                });
            });
            // this action is for dummyForm that come from SCLManager that in Common
            if (options && options.isClone) {
                // eslint-disable-next-line no-var
                var allInputs = frm.querySelectorAll('input[type="hidden"]');
                // eslint-disable-next-line no-var
                for (var i = 0; i < allInputs.length; i++) {
                    if (allInputs[i].getAttribute('name') && allInputs[i].getAttribute('name').indexOf('other') > -1 && allInputs[i].value === '') {
                        allInputs[i].remove();
                    }
                }
            }
            xhr.send(new FormData(frm));
        }else{
          // TODO: we may want to validate here, needs testing
          JotForm.ignoreDirectValidation = true;
          frm.submit();
          frm.writeAttribute('target', '');
          if (isCardForm) {
            $('continueLater').remove();
          }
          $('hidden_submission').remove();

          $$('.custom-hint-group').each(function (elem) { //reapply textarea hints
            elem.showCustomPlaceHolder();
          });

          $$('.form-radio-other,.form-checkbox-other').each(function (el) { //reenable other textbox if not "other" option selected
            if (!el.checked && JotForm.getOptionOtherInput(el)) {
              JotForm.getOptionOtherInput(el).enable();
            }
          });
        }
    },
    /**
     * Checks the upload fields after hidden submission
     * If they are completed, then makes them empty to prevent
     * Multiple upload of the same file
     */
    makeUploadChecks: function () {
        // eslint-disable-next-line no-var
        var formIDField = $$('input[name="formID"]')[0];
        // eslint-disable-next-line no-var
        var parameters = {
            action: 'getSavedUploadResults',
            formID: formIDField.value,
            sessionID: this.sessionID
        };
        if (this.submissionID) {
            parameters.submissionID = this.submissionID;
        }
        if (this.submissionToken) {
            parameters.submissionToken = this.submissionToken;
        }

        new Ajax.Jsonp(JotForm.server, {
            parameters: parameters,
            evalJSON: 'force',
            onComplete: function (t) {
                // eslint-disable-next-line no-var
                var res = t.responseJSON;
                if (res && res.success) {
                    if (res.submissionID && !$('submission_id')) {
                        if (!JotForm.submissionID) {
                            JotForm.setSubmissionID(res.submissionID);
                        }
                        formIDField.insert({
                            after: createHiddenInputElement({
                                name: 'submission_id',
                                id: 'submission_id',
                                value: res.submissionID
                            })
                        });
                    }
                    if (window.FORM_MODE === 'cardform') {
                        JotForm.editMode(res, true, null, true); // Don't reset fields and skip card index update
                    } else {
                        JotForm.editMode(res, true); // Don't reset fields
                    }
                }
            }
        });
    },
    /**
     * Handles the form being saved stuation
     */
    handleSavedForm: function () {
        // eslint-disable-next-line no-var
        var savedSessionID = ('session' in document.get) && (document.get.session.length > 0) ? document.get.session : false;
        if (!JotForm.sessionID && !savedSessionID) {
            return;
        }
        JotForm.saveForm = JotForm.sessionID ? true : false;

        // eslint-disable-next-line no-var
        var isCardForm = window.FORM_MODE == 'cardform';
        // eslint-disable-next-line no-var
        var formIDField = $$('input[name="formID"]')[0];
        // eslint-disable-next-line no-var
        var sessionIDField = document.getElementById('session');
        if (!sessionIDField) {
            formIDField.insert({
                after: createHiddenInputElement({
                    name: 'session_id',
                    id: 'session',
                    value: JotForm.sessionID
                })
            });
        }

        // eslint-disable-next-line no-var
        var tokenField = document.getElementById('submission_token');
        if (!tokenField && !isCardForm && this.submissionToken) {
          formIDField.insert({
              after: createHiddenInputElement({
                  name: 'submission_token',
                  id: 'submission_token',
                  value: this.submissionToken
              })
          });
        }

        if (!isCardForm) {
            formIDField.insert({
                after: createHiddenInputElement({
                    name: 'current_page',
                    id: 'current_page',
                    value: 0
                })
            });
        }

        // Flag for blocking pressing next/prev button while loading submission data
        JotForm.loadingPendingSubmission = true;
        // eslint-disable-next-line no-var
        var parameters = {
            action: 'getSavedSubmissionResults',
            formID: formIDField.value,
            sessionID: savedSessionID,
            URLparams: window.location.href
        };
        if (this.submissionID) {
            parameters.submissionID = this.submissionID;
        }
        if (this.submissionToken) {
            parameters.submissionToken = this.submissionToken;
        }

        if (window.JFAppsManager && window.JFAppsManager.isProductListForm) {
            parameters.platform = 'APP';
            parameters.platform_id = window.JFAppsManager.appID;
            parameters.checkoutKey = window.JFAppsManager.checkoutKey;
            parameters.submissionID = window.JFAppsManager.submissionID;
        }

        new Ajax.Jsonp(JotForm.url + '/server.php', {
            parameters: parameters,
            evalJSON: 'force',
            onComplete: function (t) {
                // eslint-disable-next-line no-var
                var res = t.responseJSON;
                // eslint-disable-next-line no-var
                var isRealSuccess = res.success && !!res.submissionID;
                if (isRealSuccess) {
                    if (res.submissionID) {
                        if (!$('submission_id')) {
                            // eslint-disable-next-line no-var
                            var submissionID = JotForm.submissionID || res.submissionID;
                            formIDField.insert({
                                after: createHiddenInputElement({
                                    name: 'submission_id',
                                    id: 'submission_id',
                                    value: submissionID
                                })
                            });

                            if (!JotForm.submissionID) {
                                JotForm.setSubmissionID(res.submissionID);
                            }
                        }
                        if (!$('submission_token')) {
                            // eslint-disable-next-line no-var
                            var submissionToken = this.submissionToken || res.token;
                            if(submissionToken){
                                formIDField.insert({
                                    after: createHiddenInputElement({
                                        name: 'submission_token',
                                        id: 'submission_token',
                                        value: submissionToken
                                    })
                                });

                                if (!this.submissionToken) {
                                    this.submissionToken = submissionToken;
                                }
                            }
                        }

                        try {
                            if (window.FORM_MODE === 'cardform') {
                                JotForm.editMode(res, true, null, true);
                            } else {
                                JotForm.editMode(res, true);
                            }
                        } catch (e) {
                            JotForm.loadingPendingSubmission = false;
                        }
                        JotForm.openInitially = res.currentPage - 1;
                    }

                    if (res.jfFormUserSCL_emailSentTo && !$('jfFormUserSCL_emailSentTo')) {
                        formIDField.insert({
                            after: createHiddenInputElement({
                                name: 'jfFormUserSCL_emailSentTo',
                                id: 'jfFormUserSCL_emailSentTo',
                                value: res.jfFormUserSCL_emailSentTo
                            })
                        });
                    }
                }

                // Releasing blocking of next/prev buttons after submissin data filling has done
                JotForm.loadingPendingSubmission = false;
            }
        });
    },
    setSubmissionID: function(submissionID) {
        this.submissionID = submissionID;
    },
    /*
     * Add browser class to html element.
     */
    setHTMLClass: function () {
        // only ie for now
        // eslint-disable-next-line no-var
        var ie = this.ie();
        if (ie) {
            document.querySelector('html').classList.add('ie-' + ie);
        }
    },
    /**
     * Sets the last focus event to keep latest focused element
     */
    setFocusEvents: function () {
        document.querySelectorAll('.form-radio, .form-checkbox, .newDefaultTheme-dateIcon').forEach(function (input) { //Neil: use mousedown event for radio & checkbox (Webkit bug:181934)
            input.addEventListener('mousedown', function () {
                JotForm.lastFocus = input;
            })
            input.addEventListener('focus', function () { // To set lastFocus when Tab key is used
                JotForm.lastFocus = input;
            })
        });
        document.querySelectorAll('.form-textbox, .form-password, .form-textarea, .form-upload, .form-dropdown').forEach(function (input) {
            input.addEventListener('focus', function () {
                JotForm.lastFocus = input;
            });
        });

        if ((JotForm.newPaymentUI) && (window.paymentType !== 'product' && window.paymentType !== 'subscription') && window.FORM_MODE !== 'cardform') {
          // if donation and has a source field
          document.querySelectorAll('[data-component="paymentDonation"]').forEach(function (element) {
            element.closest('.form-line').classList.add('donation_cont');
          });
        }

        // Will be removed after requirement completed
        if ((JotForm.newPaymentUI) && window.paymentType === 'product' && window.FORM_MODE !== 'cardform') {

            // eslint-disable-next-line no-var
            var productItems = document.querySelectorAll('.form-product-item');
            Array.from(productItems).forEach(function(productItem) {
                productItem.addEventListener('click', function(event) {
                    if (isIframeEmbedFormPure()) {
                       callIframeHeightCaller();
                    }
                    if (
                        event.target.tagName !== 'LABEL' &&
                        !['text', 'select-one', 'checkbox', 'radio'].includes(event.target.type) &&
                        !event.target.hasClassName('image_zoom')
                    ) {
                        if (productItem.querySelector('.form-checkbox')) {
                            // eslint-disable-next-line no-var
                            var isSelectedProduct = productItem.classList.contains('p_selected') && productItem.classList.contains('form-product-item');
                            if (JotForm.browserIs.firefox() && event.target.tagName === 'OPTION' && isSelectedProduct) {
                                return;
                            }
                            productItem.querySelector('.form-checkbox').click();
                        } else {
                            // if single selection is enabled, uncheck previously selected product (and it's connected products)
                            if (
                                window.paymentType === 'product' &&
                                JotForm.categoryConnectedProducts &&
                                Object.keys(JotForm.categoryConnectedProducts).length > 0 &&
                                !JotForm.categoryConnectedProducts[productItem.getAttribute('pid')] // if product doesn't have connected prods
                            ) {
                                document.querySelectorAll('.form-product-input').forEach(function(item) {
                                    if (item.checked && item.getValue() !== productItem.getAttribute('pid')) {
                                        item.checked = false;
                                    }
                                });
                            }

                            productItem.querySelector('.form-radio').click();
                        }
                    }

                    if (event.target.type === 'checkbox') {
                        // eslint-disable-next-line no-var
                        var dropDownElement = productItem.querySelector('.form-dropdown');
                        if (dropDownElement) {
                            // eslint-disable-next-line no-var
                            var dropDownElementOptions = dropDownElement.options;
                            // eslint-disable-next-line no-var
                            var isZeroOptionExistInDropDownElementsOptions = false;

                            // eslint-disable-next-line no-var
                            for (var i = 0; i < dropDownElementOptions.length; i++) {
                                if(dropDownElementOptions[i].value === '0' ) {
                                    isZeroOptionExistInDropDownElementsOptions = true;
                                    break;
                                }
                            }

                            if (!event.target.checked && isZeroOptionExistInDropDownElementsOptions) {
                                dropDownElement.value = "0";
                                JotForm.runConditionForId(dropDownElement.id); // needed for dropdown value reset
                            }
                        }

                        // SubTotal
                        if(typeof event.target.checked !== 'undefined' && event.target.checked === false) {
                            // eslint-disable-next-line no-var
                            var itemSubTotal = $(event.target.id + '_item_subtotal');
                            if (itemSubTotal) itemSubTotal.update("0.00");
                        }
                    }
                });

                // add or remove p_selected class
                productItem.addEventListener('change', function (event) {
                    function deselectProduct(quantityType) {
                        // eslint-disable-next-line no-var
                        var subProductTable = event.target.closest('.form-product-child-table');
                        if (subProductTable && typeof subProductTable !== 'undefined') {
                            // eslint-disable-next-line no-var
                            var quantityInputClass = quantityType === 'select-one' ? '.select_cont .form-subproduct-quantity' : '.form-subproduct-quantity.form-product-custom_quantity';
                            // eslint-disable-next-line no-var
                            var quantityList = subProductTable.querySelectorAll(quantityInputClass);
                            if (quantityList.length > 0 && Array.from(quantityList).every(function(el) { return ['', '0'].includes(el.value); })) {
                                productItem.classList.remove('p_selected');
                            }
                        } else {
                            productItem.classList.remove('p_selected');
                        }
                    }
                    // quantity dropdown-text input
                    if (['select-one', 'text'].includes(event.target.type)) {
                        if (['', '0'].includes(event.target.value)) {
                            deselectProduct(event.target.type);
                        } else {
                            productItem.classList.add('p_selected');
                            if (event.target.type === 'select-one') {
                                JotForm.countTotal();
                            }
                        }
                    }
                });
            });

            document.querySelectorAll('.form-checkbox').forEach(function (element) {
                // eslint-disable-next-line no-var
                var productItem = element.closest('.form-product-item');

                function shouldMakeProductSelected() {
                    if (element.checked && productItem) {
                        // eslint-disable-next-line no-var
                        var quantityDd = productItem.querySelector('.select_cont select');
                        if ((quantityDd && Number(quantityDd.value) > 0) || !quantityDd) {
                            return true;
                        }
                    }
                    return false;
                }

                if (shouldMakeProductSelected()) {
                    productItem.classList.add('p_selected');
                }

                element.addEventListener('click', function () {
                    if (shouldMakeProductSelected()) {
                        productItem.classList.add('p_selected');
                    } else {
                        if (productItem && productItem.classList.contains('p_selected')) {
                            productItem.classList.remove('p_selected');
                        }
                    }
                });
            });
        }

        if ((JotForm.newPaymentUI) && window.paymentType === 'subscription') {

            // Select the product if clicked the product line
            document.querySelectorAll('.form-product-item').forEach(function (element) {
                element.addEventListener('click', function (event) {
                    if (event.target.type !== 'radio' &&
                        event.target.type !== 'text' &&
                        event.target.type !== 'select-one' &&
                        !event.target.hasClassName('image_zoom'))
                    {
                        element.querySelector('.form-radio').click();
                    }
                });
            });

            document.querySelectorAll('.form-product-item').forEach(function (element) {
                element.closest('.form-line').classList.add('subscription_cont');
            });

            document.querySelectorAll('.form-product-item .form-radio').forEach(function (element) {
                if (element.checked) {
                    element.closest('.form-product-item').classList.add('p_selected');
                }
                element.addEventListener('change', function () {
                    element.closest('.form-product-item').classList.add('p_selected')
                    document.querySelectorAll('.form-product-item .form-radio').forEach(function (subElement) {
                        if (subElement !== element) subElement.closest('.form-product-item').classList.remove('p_selected')
                    });
                });
            });
        }
    },
    setBirthDateEvents: function () {
        function addOptionsToDayDropdown(dayDropdown, selectedMonth, selectedYear) {
            // eslint-disable-next-line no-var
            var daysInMonth = new Date(selectedYear, selectedMonth, 0).getDate();

            // eslint-disable-next-line no-var
            var daySelectedIndex = dayDropdown.selectedIndex;

            dayDropdown.innerHTML = '';

            // eslint-disable-next-line no-var
            var defaultOption = document.createElement('option');
            dayDropdown.appendChild(defaultOption);

            // eslint-disable-next-line no-var
            for (var i = 1; i <= daysInMonth; i++) {
                // eslint-disable-next-line no-var
                var option = document.createElement('option');
                option.value = i;
                option.innerHTML = i;
                dayDropdown.appendChild(option);
            }

            if (daySelectedIndex <= dayDropdown.children.length) {
                dayDropdown.selectedIndex = daySelectedIndex;
            }
        }

        // eslint-disable-next-line no-var
        var birthdateElements = document.querySelectorAll('[data-type="control_birthdate"]');

        birthdateElements.forEach(birthdate => {
            // eslint-disable-next-line no-var
            var birthdateMonth = birthdate.querySelector('[data-component="birthdate-month"]');
            // eslint-disable-next-line no-var
            var birthdateYear = birthdate.querySelector('[data-component="birthdate-year"]');
            // eslint-disable-next-line no-var
            var birthdateDay = birthdate.querySelector('[data-component="birthdate-day"]');

            let monthIndex = 0;
            let year = 2023;

            birthdateMonth.addEventListener('change', e => {
                monthIndex = e.target.value;
                addOptionsToDayDropdown(birthdateDay, monthIndex, year);
            });

            birthdateYear.addEventListener('change', e => {
                year = e.target.value;
                addOptionsToDayDropdown(birthdateDay, monthIndex, year);
            });
        });
    },
    /**
     * Disables Accept for Google Chrome browsers
     */
    disableAcceptonChrome: function () {
        if (JotForm.browserIs.webkit()) {
            document.querySelectorAll('.form-upload').forEach( input => {
                if (input.hasAttribute('accept')) {
                    // eslint-disable-next-line no-var
                    var r = input.getAttribute('accept');
                    input.setAttribute('accept', '');
                    input.setAttribute('data-file-accept', r);
                    input.setAttribute('file-accept', r);
                }
            })
        }
    },

    browserInformations: function () {
        // eslint-disable-next-line no-var
        var is = JotForm.browserIs;

        function OS() {
            if (is.android()) return "Android";
            else if (is.windows()) return "Windows";
            else if (is.blackberry()) return "Blackberry";
            else if (is.linux()) return "Linux";
            else if (is.ios()) return "iOS";
            else if (is.mac() && !is.ios()) return "MacOS";
            return "Unknown OS";
        }

        function device() {
            if (is.mobile()) {
                // separate ios detection because the new windows phone user agent now includes ios
                // http://www.neowin.net/news/ie11-fakes-user-agent-to-fool-gmail-in-windows-phone-81-gdr1-update
                if (is.windowsPhone() || is.androidPhone() || is.blackberry()) return "Mobile";
                else if (is.ios()) return "iPhone";
            }
            else if (is.tablet()) {
                // same above
                if (is.windowsTablet() || is.androidTablet()) return "Tablet";
                else if (is.ios()) return "iPad";
            }
            else if (is.desktop()) return "Desktop";
            return "Unknown Device";
        }

        function browser() {
            if (is.ie()) return "Internet Explorer";
            else if (is.firefox()) return "Firefox";
            else if (is.chrome()) return "Chrome";
            else if (is.safari()) return "Safari";
            else if (is.operabrowser()) return "Opera";
            return "Unknown Browser";
        }

        // eslint-disable-next-line no-var
        var offset = new Date().getTimezoneOffset();
        // eslint-disable-next-line no-var
        var sign = (offset < 0) ? "+" : "";
        // eslint-disable-next-line no-var
        var timeZone = 'GMT ' + sign + -(offset / 60);
        // eslint-disable-next-line no-var
        var lang = navigator.language || navigator.browserLanguage || navigator.userLanguage;
        // eslint-disable-next-line no-var
        var val = [
            'BROWSER: ' + browser(),
            'OS: ' + OS(),
            'DEVICE: ' + device(),
            'LANGUAGE: ' + lang,
            'RESOLUTION: ' + screen.width + "*" + screen.height,
            'TIMEZONE: ' + timeZone,
            'USER AGENT: ' + navigator.userAgent
        ].join('\n');

        return val;
    },

    /**
     * Populate hidden field with user's browser info
     */
    populateBrowserInfo: function (id) {
        // eslint-disable-next-line no-var
        var val = JotForm.browserInformations();

        setTimeout(function(){
            if ($(id).getValue().length > 0) {
                val = [$(id).getValue(), val].join('\n');
            }
            $(id).setValue(val);
        }, 20);
    },

    /**
     * Show Difference Between time ranges
     */
    displayTimeRangeDuration: function (id, justCalculate) {
        // eslint-disable-next-line no-var
        var displayDuration = function () {
            if ($('input_' + id + '_hourSelectRange')) {
                // eslint-disable-next-line no-var
                var sHour = $('input_' + id + '_hourSelect').value;
                // eslint-disable-next-line no-var
                var sMin = $('input_' + id + '_minuteSelect').value || '00';
                // eslint-disable-next-line no-var
                var sAMPM = $('input_' + id + '_ampm') ? $('input_' + id + '_ampm').value : 'no';
                // eslint-disable-next-line no-var
                var eHour = $('input_' + id + '_hourSelectRange').value;
                // eslint-disable-next-line no-var
                var eMin = $('input_' + id + '_minuteSelectRange').value || '00';
                // eslint-disable-next-line no-var
                var eAMPM = $('input_' + id + '_ampmRange') ? $('input_' + id + '_ampmRange').value : 'no';
                // eslint-disable-next-line no-var
                var lab = $('input_' + id + '_ampmRange') && !(JotForm.newDefaultTheme || JotForm.extendsNewTheme) ? '_ampmRange' : '_dummy';

                // eslint-disable-next-line no-var
                var durationLabel = $$('label[for=input_' + id + lab + ']').first();
                if (window.FORM_MODE === 'cardform') {
                    if (lab == '_ampmRange') {
                        durationLabel = $$('label[for=input_' + id + lab + ']').first();
                    } else {
                        durationLabel = $$('#input_' + id + lab).first();
                    }
                }

                // var durationLabel = window.FORM_MODE === 'cardform' ? $$('div[for=input_' + id + lab + ']').first() : $$('label[for=input_' + id + lab + ']').first();

                if (sHour.length > 0 && sMin.length > 0 && eHour.length > 0 && eMin.length > 0) {
                    if (sAMPM == 'PM' && sHour != 12) sHour = parseInt(sHour) + 12;
                    if (sAMPM == 'AM' && sHour == 12) sHour = 0;
                    if (eAMPM == 'PM' && eHour != 12) eHour = parseInt(eHour) + 12;
                    if (eAMPM == 'AM' && eHour == 12) eHour = 0;

                    // eslint-disable-next-line no-var
                    var start = new Date(0, 0, 0, sHour, sMin, 0);
                    // eslint-disable-next-line no-var
                    var end = new Date(0, 0, 0, eHour, eMin, 0);
                    // eslint-disable-next-line no-var
                    var diff = end.getTime() - start.getTime();
                    if (diff < 0) { //end time is next day
                        end = new Date(0, 0, 1, eHour, eMin, 0);
                        diff = end.getTime() - start.getTime();
                    }
                    // eslint-disable-next-line no-var
                    var hours = Math.floor(diff / 1000 / 60 / 60);
                    diff -= hours * 1000 * 60 * 60;
                    // eslint-disable-next-line no-var
                    var min = Math.floor(diff / 1000 / 60);
                    if (min < 10) min = '0' + min;
                    if(justCalculate){
                        return [hours.toString(), min.toString()];
                    }
                    durationLabel.update('<b>Total ' + hours + ':' + min + '</b>');
                    durationLabel.setStyle({'color': 'black'});
                    $$('input[id=duration_' + id + '_ampmRange][type="hidden"]').first().setValue(hours + ':' + min);
                } else if (!justCalculate) {
                    durationLabel.update('&nbsp');
                }

                if ($('input_' + id + '_timeInput') && $('input_' + id + '_hourSelect') && $('input_' + id + '_hourSelect').triggerEvent) {
                    $('input_' + id + '_hourSelect').triggerEvent('change');
                }
            }
        };

        if ($('input_' + id + '_timeInput')) {
            $('input_' + id + '_timeInput').observe('blur', displayDuration);
            $('input_' + id + '_timeInputRange').observe('blur', displayDuration);
        } else {
            $('input_' + id + '_hourSelect').observe('change', displayDuration);
            $('input_' + id + '_minuteSelect').observe('change', displayDuration);
            $('input_' + id + '_hourSelectRange').observe('change', displayDuration);
            $('input_' + id + '_minuteSelectRange').observe('change', displayDuration);
        }

        if ($('input_' + id + '_ampm') && $('input_' + id + '_ampmRange')) {
            $('input_' + id + '_ampm').observe('change', displayDuration);
            $('input_' + id + '_ampmRange').observe('change', displayDuration);
        }
        // eslint-disable-next-line no-var
        var timeDiff;
        if(JotForm.isEditMode()){
            // eslint-disable-next-line no-var
            var waitDom = function () {
                if($('input_' + id + '_hourSelectRange') && $('input_' + id + '_hourSelectRange').value.empty()) {
                    window.setTimeout(waitDom, 100);
                } else {
                    timeDiff = displayDuration();
                }
            }
            waitDom();
        } else{
            timeDiff = displayDuration();
        }
        return timeDiff;
    },


    /**
     * Set current local time if nodefault not set
     */
    displayLocalTime: function (hh, ii, ampm, v2, fixCurrentAmPm) {
        if (JotForm.isEditMode() && fixCurrentAmPm) return;
        const hhElement = document.querySelector(`#${hh}`);
        if (hhElement && !hhElement.classList.contains('noDefault')) {
            const date = new Date();
            let hour = date.getHours();

            let currentAmpm = "";
            let twentyFour = true;
            const ampmElement = document.querySelector(`#${ampm}`);
            if (ampmElement) {
                twentyFour = false;
                currentAmpm = (hour > 11) ? 'PM' : 'AM';
                hour = (hour > 12) ? hour - 12 : hour;
                hour = (hour == 0) ? 12 : hour;
            }
            let min = date.getMinutes();
            const iiElement = document.querySelector(`#${ii}`);
            if (!v2) {
                const step = Number(iiElement.options[2].value) - Number(iiElement.options[1].value);
                min = Math.round(min / step) * step;
            }
            min = this.addZeros(min, 2);
            if (min >= 60) { //ntw roll over to next hour/day
                min = "00";
                hour++;
                if (twentyFour) {
                    if (hour == 24) hour = 0;
                } else {
                    if (currentAmpm == 'AM' && hour == 12) currentAmpm = 'PM';
                    else if (currentAmpm == 'PM' && hour == 12) currentAmpm = 'AM';
                    else if (hour == 13) hour = 1;
                }
            }
            // prepend with zero
            if (hour < 10 && (!!v2 || hhElement.options[1].value.length > 1)) {
                hour = '0' + hour;
            }

            if (ampmElement) {
                const ampmRangeEl = document.querySelector(`#${ampm}Range`);
                if (currentAmpm == 'PM') {
                    if (ampmElement.querySelectorAll('option[value="PM"]').length > 0) ampmElement.value = 'PM';
                    if (ampmRangeEl && ampmRangeEl.querySelectorAll('option[value="PM"]').length > 0) ampmRangeEl.value = 'PM';
                } else {
                    if (ampmElement.querySelectorAll('option[value="AM"]').length > 0) ampmElement.value = 'AM';
                    if (ampmRangeEl && ampmRangeEl.querySelectorAll('option[value="AM"]').length > 0) ampmRangeEl.value = 'AM';
                }
            }

            if (fixCurrentAmPm) return;

            hhElement.value = hour;
            iiElement.value = min;
            if (document.querySelector(`#${hh}Range`)) {
                document.querySelector(`#${hh}Range`).value = hour;
                document.querySelector(`#${ii}Range`).value = min;
            }

            if (document.querySelector(`#${v2}Range`)) {
                document.querySelector(`#${v2}Range`).value = hour + ':' + min;
            }
            if (v2) {
                document.querySelector(`#${v2}`).value = hour + ':' + min;
            }
        }
    },

    /**
     * Sets field item value to field
     * @param {Object} fieldItem
     * @param {String} qid
     */
    setDateTimeFieldItem: function (fieldItem, qid) {
        const isHourOrMin = fieldItem.key === 'hour' || fieldItem.key === 'min';
        const value = fieldItem.value;
        let element;
        if (isHourOrMin) {
            const _key = fieldItem.key === 'hour' ? 'hour' : 'minute';
            let hourOrMinEl = document.querySelector('#input_' + qid + '_' + _key + 'Select');
            if (hourOrMinEl) {
                hourOrMinEl.value = value.length < 2 && value < 10 ? '0' + value : value;
            }
        }
        const timeInputElement = document.querySelector("#input_" + qid + "_" + fieldItem.key)
        if(document.querySelector(`#${fieldItem.key}_${qid}`)) {
            element = document.querySelector(`#${fieldItem.key}_${qid}`);
            element.value = value;
        } else if (timeInputElement && (JotForm.newDefaultTheme || JotForm.extendsNewTheme || timeInputElement.dataset.version === "v2")) {
            element = timeInputElement;
            element.value = value;
        }
        const elementIsSelect = element && element.nodeName === 'SELECT';
        if (elementIsSelect && isHourOrMin && element.options.selectedIndex === -1) {
            element.value = '0' + value;
        }
    },

    displayDynamicDate: function (id, dynamic) {
        // eslint-disable-next-line no-var
        var offset = parseInt(dynamic.split('today')[1]) || 0;
        // eslint-disable-next-line no-var
        var dynamicDate = new Date();
        dynamicDate.setDate(dynamicDate.getDate() + offset);
        JotForm.formatDate({date: dynamicDate, dateField: document.querySelector(`#id_${id}`)});
    },

    dateLimits: {},

    /**
     * Sets calendar to field
     * @param {Object} id
     */
    getCalendar: function (id) {
      // eslint-disable-next-line no-var
      var calendar = document.querySelector('#calendar_' + id);
      return calendar;
    },
    setCalendar: function (id, startOnMonday, limits, parent) {
        try {
            // eslint-disable-next-line no-var
            var triggerElement = "input_" + id + "_pick";
            JotForm.dateLimits[id] = limits;
            // eslint-disable-next-line no-var
            var field = $('id_' + id);
            // eslint-disable-next-line no-var, no-undef
            var calendar = Calendar.setup({
                triggerElement: triggerElement,
                dateField: "year_" + id,
                parentElement: parent,
                closeHandler: function () {
                    JotForm.calendarClose.apply(this, arguments);
                    if ($('lite_mode_' + id)) {
                        if(JotForm.newDefaultTheme && ($('lite_mode_' + id).hasClassName('calendar-opened'))){
                            $('lite_mode_' + id).removeClassName('calendar-opened');
                        }
                        if (id.indexOf('-') > -1) {
                            // for control_inline date conditions
                            $('lite_mode_' + id).triggerEvent('change');
                        }
                        $('lite_mode_' + id).triggerEvent('blur');
                    }
                },
                selectHandler: function () {
                    JotForm.formatDate.apply(this, arguments);
                },
                startOnMonday: startOnMonday,
                limits: limits,
                id: id
            });
            // eslint-disable-next-line no-var
            var calendarButton = document.querySelector('#' + triggerElement);
            calendarButton.observe("click", function () {
              // eslint-disable-next-line no-var
              var calendar = $("calendar_" + id);
              if (calendar.style && calendar.style.display !== "none") {
                JotForm.handleIFrameHeight();
              }
            });
            field.observe('keyup', function () {
                field.fire('date:changed');
            });
            // eslint-disable-next-line no-var
            var clearDate = function() {
                $("month_"+id).value = $("day_"+id).value = $("year_"+id).value = "";
            }
            // eslint-disable-next-line no-var
            var invalidDate = function(invalidDate) {
                invalidDate.addClassName("invalidDate");
                clearDate();
            }
            if ($('lite_mode_' + id)) {

                $('lite_mode_' + id).dateChanged = function (e, calendar, doNotTriggerErrors) {
                    // eslint-disable-next-line no-var
                    var lite_mode = e.currentTarget;
                    // eslint-disable-next-line no-var
                    var seperator = lite_mode.readAttribute('seperator') || lite_mode.readAttribute('data-seperator');
                    // eslint-disable-next-line no-var
                    var format = (lite_mode.readAttribute('format') || lite_mode.readAttribute('data-format')).toLowerCase();

                    lite_mode.removeClassName("invalidDate");
                    lite_mode.removeClassName("invalidLimits");
                    field.removeClassName('form-line-error');
                    field.removeClassName('form-datetime-validation-error');
                    if(lite_mode.value === "") {
                        field.fire('date:changed');
                        return clearDate();
                    }
                    // Trim input in NDT, since value is like '19-19-199Y'
                    // eslint-disable-next-line no-var
                    var inputLength = calendar.isNewTheme ? lite_mode.value.replace(new RegExp('[^\\d' + seperator + ']'), '').length : lite_mode.value.length;
                    if(inputLength == ((seperator.length*2) + format.length)){
                        // eslint-disable-next-line no-var
                        var _yIn = format.indexOf("yy");
                        // eslint-disable-next-line no-var
                        var _mIn = format.indexOf("mm");
                        // eslint-disable-next-line no-var
                        var _dIn = format.indexOf("dd");
                        // eslint-disable-next-line no-var
                        var _sorter = new Array(_yIn, _mIn, _dIn);
                        _sorter = _sorter.sort();
                        // eslint-disable-next-line no-var
                        var _sortIndex = {
                            year: _sorter.indexOf(_yIn),
                            month: _sorter.indexOf(_mIn),
                            day: _sorter.indexOf(_dIn)
                        }

                        // eslint-disable-next-line no-var
                        var year = parseInt(lite_mode.value.split(seperator)[_sortIndex.year]);
                        // eslint-disable-next-line no-var
                        var month = parseInt(lite_mode.value.split(seperator)[_sortIndex.month])-1;
                        // eslint-disable-next-line no-var
                        var day = parseInt(lite_mode.value.split(seperator)[_sortIndex.day]);
                        // eslint-disable-next-line no-var
                        var _tempDate = new Date(year, month, day);

                        if (!_tempDate || !_tempDate.getDate()) {
                            if (!doNotTriggerErrors) invalidDate(lite_mode, calendar);
                        } else {
                            calendar.setDate(_tempDate);
                            calendar.selectHandler(calendar);
                        }
                    } else {
                        if (!doNotTriggerErrors) invalidDate(lite_mode, calendar);
                    }

                    if(lite_mode.hasClassName("invalidDate")) {
                        JotForm.errored(lite_mode, 'Enter a valid date');
                        field.addClassName('form-line-error');
                        field.addClassName('form-datetime-validation-error');
                    }
                }


                $('lite_mode_' + id).observe('blur', function (e) {
                    e.stopPropagation();
                    /*Dogus: set new date value and run handler*/
                    e.currentTarget.dateChanged(e, calendar);
                    e.currentTarget.setAttribute("date-val", calendar.date.getTime());
                    return false;
                });

                if (!JotForm.newDefaultTheme && !JotForm.extendsNewTheme && !calendar.isNewTheme) {
                    $('lite_mode_' + id).observe('keydown', function (e) {
                        // eslint-disable-next-line no-var
                        var input = e.target.value;
                        if(e.key === 'Backspace' && input[input.length-1] === e.target.dataset.seperator) {
                            input = input.substr(0, input.length-1);
                        }
                        e.target.value = input.substr(0, 10);
                    });

                    $('lite_mode_' + id).observe('input', function (e) {
                        // eslint-disable-next-line no-var
                        var input = e.target.value;
                        // eslint-disable-next-line no-var
                        var values = input.split(e.target.dataset.seperator).map(function(v) {
                            return v.replace(/\D/g, '')
                        });
                        // eslint-disable-next-line no-var
                        var output = [];
                        if (e.target.dataset.format !== 'yyyymmdd'){
                            output = values.map(function(v, i) {
                                return v.length == 2 && i < 2 ? v + e.target.dataset.seperator : v;
                            });
                        } else {
                            output = values.map(function(v,i) {
                                return (v.length == 4 && i == 0) || (v.length == 2 && i == 1) ? v + e.target.dataset.seperator : v;
                            });
                        }
                        e.target.value = output.join('').substr(0, 10);
                        e.currentTarget.dateChanged(e, calendar, true); // the third argument for disabling the error handling for oninput event
                    });
                }
            }

            if (!parent) { // if parent its embedded and show hide will be handled by the parent container
                // eslint-disable-next-line no-var
                var openCalendar = function() {
                    // eslint-disable-next-line no-var
                    var ele = this;
                    setTimeout(function() {
                        if (JotForm.newDefaultTheme) {
                            // eslint-disable-next-line no-undef
                            handlePopupUI(calendar, { width: ele.parentNode.parentNode.offsetWidth });
                        }
                        calendar.showAtElement(ele);
                    }, 50);

                };
                if ($('input_' + id + '_pick').hasClassName('showAutoCalendar') || JotForm.isSourceTeam) {
                    // eslint-disable-next-line no-var
                    var _selectors = [('#day_' + id), ('#month_' + id), ('#year_' + id), ('#lite_mode_' + id)];
                    $$(_selectors.join(',')).each(function(elem) {
                        if(!elem.onclick) {
                            elem.observe('focus', openCalendar);
                            elem.observe('click', openCalendar);
                        }
                    });
                }
                $("year_" + id).observe("blur", function() {
                    calendar.hide();
                });
                if ($("lite_mode_" + id)) {
                    $("lite_mode_" + id).observe("blur", function() {
                        calendar.hide();
                    });
                }
            }

        } catch (e) {
            JotForm.error(e);
        }
    },

    currentDateReadonly: function () {},

    calendarClose: function (calendar) {
        // eslint-disable-next-line no-var
        var calendar_id = !calendar.isNewTheme ? calendar.id : calendar.dateField.id[calendar.dateField.id.length -1];
        // eslint-disable-next-line no-var
        var found = calendar.dateField.id.match(/_[a-z0-9]+/);
        // eslint-disable-next-line no-var
        var selector = Array.isArray(found) ? found[0] : '';
        // eslint-disable-next-line no-var
        var calendarFields = selector ? $$('input[id*="' + selector + '"]') : [];
        // eslint-disable-next-line no-var
        var validations = calendar.dateField.className.replace(/.*validate\[(.*)\].*/, '$1').split(/\s*,\s*/);
        // eslint-disable-next-line no-var
        var incomplete = calendarFields.any(function (c) {
            return c.value.empty()
        });
        if ((validations.include("required") || validations.include("disallowPast"))
            && incomplete) {
            calendar.dateField.validateInput();
        }
        if(validations.include("required") && !incomplete ){
            JotForm.corrected($('id_' + calendar_id));
        }
        calendar.hide();
    },

    /**
     * Collects all inital values of the fields and saves them as default values
     * to be restored later
     */
    getDefaults: function () {
        document.querySelectorAll('.form-textbox, .form-dropdown, .form-textarea, .form-hidden-time').forEach(function (input) {
            if (input.hinted || input.value === "") {
                return;
                /* continue; */
            }

            JotForm.defaultValues[input.id] = input.value;
        });

        document.querySelectorAll('.form-radio, .form-checkbox').forEach(function (input) {
            if (!input.checked) {
                return;
                /* continue; */
            }
            JotForm.defaultValues[input.id] = input.value;
        });
    },
    /**
     * Enables or disables the Other option on radiobuttons/checkboxes
     */
    handleOtherOptions: function () {
        document.querySelectorAll('.form-radio-other-input, .form-checkbox-other-input').forEach(function (inp) {
            inp.placeholder = inp.getAttribute('data-otherhint') || 'Other';
        });

        document.querySelectorAll('.form-radio, .form-checkbox').forEach(function (input) {

            // eslint-disable-next-line no-var
            var id = input.id.replace(/input_(\d+)_\d+/gim, '$1');

            if (id.match('other_')) {
                id = input.id.replace(/other_(\d+)/, '$1');
            }
            // eslint-disable-next-line no-var
            var other = document.getElementById('other_' + id); // radio button
            if (other) {
                // eslint-disable-next-line no-var
                var other_input = document.getElementById('input_' + id); // text input

                other_input.addEventListener('keyup', function () {
                    other.value = other_input.value;
                    // eslint-disable-next-line no-var
                    var willInputBeChecked = other_input.value !== '';
                    // eslint-disable-next-line no-var
                    var isInputChecked = other.checked;
                    if (!isInputChecked && willInputBeChecked) {
                        other_input.click();
                    }
                    setTimeout(function() { // Thank you safari.
                        other.checked = willInputBeChecked;
                    });
                });
                other_input.addEventListener('click', function () {
                    // if(e.handled) { return; } e.handled = true; // Prevent the block from running total option count times, uncomment if you dare.
                    other_input.value = other_input.value === other_input.getAttribute('data-otherhint') ? '' : other_input.value;

                    if(!other.checked){
                      other.checked = true;
                      other_input.parentNode.classList.remove('is-none');
                    }
                });

                // perform only on the "Other" option if input is check box
                other.addEventListener('click', function () {
                    if (other.className.match(/\[.*required.*\]/)) {
                        other_input.value = other_input.value === other_input.getAttribute('data-otherhint') ? '' : other_input.value;
                    } else {
                        other_input.value = other_input.value !== '' ? other_input.value : other_input.getAttribute('data-otherhint');
                    }

                    if (other.checked) {
                        other_input.select();
                    } else {
                        if (other_input.hintClear) {
                            other_input.hintClear();
                        }
                    }
                });

                // delete other option's value if this option is not selected
                input.addEventListener('click', function () {
                  if (input !== other && input.checked && !other.checked) {
                    other_input.value = '';
                  }
                });
            }
        });
    },

    shuffleOptions: function (id) {
        // eslint-disable-next-line no-var
        var type = JotForm.calculationType(id);
        if (type === "radio" || type === "checkbox") {
            try {
                // eslint-disable-next-line no-var
                var options = $("id_" + id).select('.form-' + type + '-item');
                // eslint-disable-next-line no-var
                var length = $("id_" + id).down('.form-' + type + '-other-input') ? options.length - 1 : options.length; //don't shuffle "other"

                // eslint-disable-next-line no-var
                for (var i = 0; i < length - 1; i++) {
                    // eslint-disable-next-line no-var
                    var toSwap = $("id_" + id).select('.form-' + type + '-item')[i];
                    // eslint-disable-next-line no-var
                    var randy = Math.floor(Math.random() * length);
                    // eslint-disable-next-line no-var
                    var swappedOut = options[randy].replace(toSwap);
                    // eslint-disable-next-line no-var
                    var next = toSwap.next();
                    // eslint-disable-next-line no-var
                    var insertAfter = (next && next !== options[length]) ? next : toSwap;
                    insertAfter.insert({after: swappedOut});
                }

                //deal with columns
                if ($("id_" + id).down('.form-multiple-column')) {
                    // eslint-disable-next-line no-var
                    var columnCount = $("id_" + id).down('.form-multiple-column').readAttribute("data-columncount");
                    $("id_" + id).select('.form-' + type + '-item').each(function (item, i) {
                        item.setStyle({'clear': (i % columnCount == 0) ? 'left' : 'none'});
                    });
                }
            } catch (e) {
                console.log(e);
            }

        } else if (type === "select") {
            try {
                // eslint-disable-next-line no-var
                var clone = $('input_' + id).clone(true);
                $('input_' + id).update("");
                // eslint-disable-next-line no-var
                var length = clone.length;
                $('input_' + id).insert(clone[0].clone(true));
                // eslint-disable-next-line no-var
                for (var i = 1; i < length; i++) {
                    // eslint-disable-next-line no-var
                    var randy = Math.floor(Math.random() * (clone.length - 1)) + 1;
                    $('input_' + id).insert(clone[randy].clone(true));
                    clone[randy].remove();
                }
            } catch (e) {
                console.log(e);
            }
        } else if (type === "matrix") {
            try {
                // eslint-disable-next-line no-var
                var rows = $("id_" + id).select('tr');
                // eslint-disable-next-line no-var
                var len = rows.length
                // eslint-disable-next-line no-var
                for(var i=1; i<len; i++) {
                    // eslint-disable-next-line no-var
                    var randy = Math.floor(Math.random() * (len-1)) + 1;
                    // eslint-disable-next-line no-var
                    var swappedOut = rows[randy].replace(rows[i]);
                    // eslint-disable-next-line no-var
                    var insertAfter = rows[i].next() ? rows[i].next() : rows[i];
                    insertAfter.insert({after: swappedOut});
                }
            } catch(e) {
                console.log(e);
            }
        }
    },

    handleSingleChoiceWithMultiTypeColumns: function () {
        /*
            This function is used for additional check when used input table with multi-type
            column and single choice. It takes all item in matrix and then check any radio
            button is checked. If check in same row on the matrix, remove other checked values
        */
        const listItem = document.querySelectorAll('td.form-matrix-values');
        if (listItem) {
            listItem.forEach(function(e) {e.children[0].addEventListener('click', function() {
                if (e.children[0] &&  e.getElementsByClassName("form-radio")) {
                    if (e.getElementsByClassName("form-radio")[0]) {
                        const selectedItem = e.getElementsByClassName("form-radio")[0];
                        if(selectedItem && selectedItem.name && e.parentElement) {
                            const selectedElementName = selectedItem.name;
                            const parent = e.parentElement;
                            if (selectedElementName && parent && parent.cells && parent.cells.length) {
                                const parentCells = parent.cells;
                                const parentCellsLength = parent.cells.length;
                                for (let i = 0; i < parentCellsLength; i ++) {
                                    const item = parentCells[i];
                                    if(item && item.className && selectedItem.type && item.children[0] && item.children[0].name) {
                                        if (item.className === "form-matrix-values" && selectedItem.type === "radio" && item.children[0].name !== selectedElementName) {
                                            const notSelectedItem = item.children[0];
                                            notSelectedItem.type === "radio" ? notSelectedItem.checked = false : "";
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            })});
        }
    },

    handleSingleChoiceWithMultiTypeColumnsForCardForms: function () {},

    handleDateTimeChecks: function () {
        try {
        document.querySelectorAll('[name$=\\[month\\]]').forEach(function (monthElement) {
            const isBirthdate = monthElement.type !== "tel" && monthElement.type !== "text";
            const questionId = isBirthdate ? monthElement.id.replace(new RegExp('.*?([0-9]+).*', 'gim'), '$1') :  monthElement.id.split('month_').last() ;
            const dateElement = document.querySelector('#id_' + questionId);
            if (!dateElement)
                return;

            const dayElement = dateElement.querySelector('[id*=day]');
            const yearElement = dateElement.querySelector('[id*=year]');


            let hourElement = dateElement.querySelector('#hour_' + questionId)
            let minElement = dateElement.querySelector('#min_' + questionId)
            let ampmElement = dateElement.querySelector('#ampm_' + questionId)

            if (JotForm.newDefaultTheme) {
                hourElement = dateElement.querySelector('#input_' + questionId + '_hourSelect')
                minElement = dateElement.querySelector('#input_' + questionId + '_minuteSelect')
                ampmElement = dateElement.querySelector('#input_' + questionId + '_ampm')
            } else {
                if(dateElement.querySelector('#input_' + questionId + '_hourSelect') && dateElement.querySelector('#input_' + questionId + '_minuteSelect')) {
                    hourElement = dateElement.querySelector('#input_' + questionId + '_hourSelect')
                    minElement = dateElement.querySelector('#input_' + questionId + '_minuteSelect')
                    ampmElement = dateElement.querySelector('#input_' + questionId + '_ampm')
                }
            }

            monthElement.dateTimeCheck = function (e) {
                let erroredElement = null;
                const ignoreBirthdate = isBirthdate && (monthElement.value === "" || dayElement.value === "" || yearElement.value === "");
                if (!ignoreBirthdate && (monthElement.value != "" || dayElement.value != "" || yearElement.value != "")) {
                    const _month = isBirthdate ? monthElement.selectedIndex :  monthElement.value;
                    const month = parseInt(_month, 10);
                    const day = +dayElement.value;
                    const year = +yearElement.value;

                    if (isNaN(year) || year < 1 || year.toString().length < 4) {
                        erroredElement = yearElement;
                    } else if (isNaN(_month) || isNaN(month) || month < 1 || month > 12) { // second isNaN check to handle cases like null or "".
                        erroredElement = monthElement;
                    } else if ((isNaN(day) || day < 1)) {
                        erroredElement = dayElement;
                    } else {
                        switch (month) {
                            case 2:
                                if ((year % 4 == 0) ? day > 29 : day > 28) {
                                    erroredElement = dayElement;
                                }
                                break;
                            case 4:
                            case 6:
                            case 9:
                            case 11:
                                if (day > 30) {
                                    erroredElement = dayElement;
                                }
                                break;
                            default:
                                if (day > 31) {
                                    erroredElement = dayElement;
                                }
                                break;
                        }
                    }
                }

                let isTargetActive = e && e.target && e.target === document.activeElement;
                if (window.FORM_MODE === 'cardform' && typeof document.activeElement !== 'undefined' && document.activeElement && typeof document.activeElement.up === 'function' && monthElement) {
                    isTargetActive = monthElement.closest('.jfCard-question') === document.activeElement.closest('.jfCard-question');
                }

                if (!erroredElement && hourElement && minElement && (hourElement.value != "" || minElement.value != "")
                    && !isTargetActive) // do not produce an error yet if target is currently active
                {
                    const hour = (hourElement.value.strip() == '') ? -1 : +hourElement.value;
                    const min = (minElement.value.strip() == '') ? -1 : +minElement.value;
                    if (isNaN(hour) || (ampmElement ? (hour < 0 || hour > 12) : (hour < 0 || hour > 23))) {
                        erroredElement = hourElement;
                    } else if (isNaN(min) || min < 0 || min > 59) {
                        erroredElement = minElement;
                    }
                }

                const active = document.activeElement;
                let hasErrorInLiteModeEl = false;
                let limitError = false;
                if (!erroredElement) {
                    // check if there are any other error (limit date, format etc.)
                    // eslint-disable-next-line no-var
                    var dateInput = dateElement.querySelector('input[class*="validateLiteDate"]') || dateElement.querySelector('input[class*="validate"][class*="limitDate"]');
                    if (dateInput && dateInput.classList.contains('invalidDate')) {
                        erroredElement = dateInput;
                        hasErrorInLiteModeEl = true;
                    }
                    if (dateInput && dateInput.classList.contains('invalidLimits')) {
                        erroredElement = dateInput;
                        limitError = true;
                    }
                }
                if (erroredElement && active!=yearElement && active!=monthElement && active!=dayElement) {
                    if (erroredElement === hourElement || erroredElement === minElement) {
                        erroredElement.errored = false;
                        JotForm.errored(erroredElement, JotForm.texts.invalidTime);
                    } else if (hasErrorInLiteModeEl) { // https://www.jotform.com/ticket-categorize/2800532
                        erroredElement.errored = false;
                        const errorTxt = JotForm.texts.dateInvalid.replace("{format}", erroredElement.readAttribute("placeholder"));
                        JotForm.errored(erroredElement, errorTxt);
                    } else if (limitError) {
                        erroredElement.errored = false;
                        JotForm.errored(erroredElement, JotForm.texts.dateLimited);
                    } else {
                        erroredElement.errored = false;
                        const errorTxt = JotForm.texts.dateInvalidSeparate.replace('{element}', erroredElement.id.replace("_"+questionId,""))
                        JotForm.errored(erroredElement, errorTxt);
                    }
                    dateElement.classList.add('form-line-error');
                    dateElement.classList.add('form-datetime-validation-error');
                    return false;
                } else {
                    JotForm.corrected(monthElement);
                    JotForm.corrected(dayElement);
                    JotForm.corrected(yearElement);
                    if (hourElement && minElement) {
                        JotForm.corrected(hourElement);
                        JotForm.corrected(minElement);
                    }
                    dateElement.classList.remove('form-line-error');
                    dateElement.classList.remove('form-datetime-validation-error');
                }
                return true;
            };

            if (hourElement && minElement) {
                hourElement.addEventListener('change',  function(e) { monthElement.dateTimeCheck(e)});
                minElement.addEventListener('change',  function(e) { monthElement.dateTimeCheck(e)});
            }
        });
        } catch(e) {
            console.error(e);
        }
    },

    handleTimeChecks: function () {
        try {
            document.querySelectorAll('.form-line[data-type=control_time]').forEach(function (timeField) {

                // eslint-disable-next-line no-var
                var questionId = timeField.id.split('_')[1];

                // eslint-disable-next-line no-var
                var hourElement = timeField.querySelector(`#input_${questionId}_hourSelect`);
                // eslint-disable-next-line no-var
                var minElement = timeField.querySelector(`#input_${questionId}_minuteSelect`);
                // eslint-disable-next-line no-var
                var ampmElement = timeField.querySelector(`#input_${questionId}_ampm`);

                // eslint-disable-next-line no-var
                var hourRangeElement = timeField.querySelector(`#input_${questionId}_hourSelectRange`);
                // eslint-disable-next-line no-var
                var minRangeElement = timeField.querySelector(`#input_${questionId}_minuteSelectRange`);
                // eslint-disable-next-line no-var
                var ampmRangeElement = timeField.querySelector(`#input_${questionId}_ampmRange`);

                hourElement.timeCheck = function() {
                    // eslint-disable-next-line no-var
                    var erroredElement = null;

                    if (!erroredElement && hourElement && minElement && (hourElement.value != "" || minElement.value != "")) {
                        // eslint-disable-next-line no-var
                        var hour = (hourElement.value.strip() == '') ? -1 : +hourElement.value;
                        // eslint-disable-next-line no-var
                        var min = (minElement.value.strip() == '') ? -1 : +minElement.value;
                        if (isNaN(hour) || (ampmElement ? (hour < 0 || hour > 12) : (hour < 0 || hour > 23))) {
                            erroredElement = hourElement;
                        } else if (isNaN(min) || min < 0 || min > 59) {
                            erroredElement = minElement;
                        }
                    }

                    if (!erroredElement && hourRangeElement && minRangeElement && (hourRangeElement.value != "" || minRangeElement.value != "")) {
                        // eslint-disable-next-line no-var
                        var hour = (hourRangeElement.value.strip() == '') ? -1 : +hourRangeElement.value;
                        // eslint-disable-next-line no-var
                        var min = (minRangeElement.value.strip() == '') ? -1 : +minRangeElement.value;
                        if (isNaN(hour) || (ampmRangeElement ? (hour < 0 || hour > 12) : (hour < 0 || hour > 23))) {
                            erroredElement = hourRangeElement;
                        } else if (isNaN(min) || min < 0 || min > 59) {
                            erroredElement = minRangeElement;
                        }
                    }

                    if (erroredElement) {
                        JotForm.errored(erroredElement, JotForm.texts.invalidTime);
                        timeField.classList.add('form-line-error');
                        return false;
                    } else {
                        if (hourElement && minElement) {
                            JotForm.corrected(hourElement);
                            JotForm.corrected(minElement);
                        }
                        if (hourRangeElement && minRangeElement) {
                            JotForm.corrected(hourRangeElement);
                            JotForm.corrected(minRangeElement);
                        }
                    }
                    return true;
                }

                if (hourElement && minElement) {
                    hourElement.addEventListener('change', function() { hourElement.timeCheck()});
                    minElement.addEventListener('change', function() { hourElement.timeCheck()});
                }

                if(hourRangeElement && minRangeElement) {
                    hourRangeElement.addEventListener('change', function() { hourElement.timeCheck()});
                    minRangeElement.addEventListener('change', function() { hourElement.timeCheck()});
                }

            });
        } catch(e) {
            console.error(e);
        }
    },

    handleTextareaLimits: function (firstRun) {
        if (typeof firstRun === 'undefined') {
            firstRun = true;
        }
        $$('.form-textarea-limit-indicator span').each(function (el) {
            // eslint-disable-next-line no-var
            var inpID = el.id.split('-')[0];
            if (!$(inpID)) {
                return;
            } // cannot find the main element

            // eslint-disable-next-line no-var
            var minimum = el.readAttribute('data-minimum');
            // eslint-disable-next-line no-var
            var limit = el.readAttribute('data-limit');
            // eslint-disable-next-line no-var
            var input = $(inpID);
            // eslint-disable-next-line no-var
            var count;

            // eslint-disable-next-line no-var
            var countText = function (firstRun) {
                if (input.value === "" || input.hasClassName('form-custom-hint')) {
                    $(el.parentNode).removeClassName('form-textarea-limit-indicator-error');
                    el.update("0/" + (minimum > -1 ? minimum : limit));
                    return JotForm.corrected(el);
                }

                // eslint-disable-next-line no-var
                var contents;
                if (input.hasClassName("form-textarea") && input.up('div').down('.nicEdit-main')) { //rich text
                    contents = input.value.stripTags(' ').replace(/&nbsp;/g, ' ');
                } else {
                    contents = input.value;
                }

                if (input.up('div').down('.nicEdit-main')) {
                    // When copying text from MS WORD it comes with style and causes wrong word counting
                    // eslint-disable-next-line no-var
                    var isStyled = input.up('div').down('.nicEdit-main').querySelector('style');
                    if (isStyled) isStyled.remove();
                  }

                // remove html tags and space chars, to prevent wrong counts on text copied from MS WORD
                // eslint-disable-next-line no-var
                var cleaned_contents = contents.replace(/(\<\w*)((\s\/\>)|(.*\<\/\w*\>))/gm, ' ').replace(/&nbsp;|&#160;/gi, ' ');

                $(el.parentNode).removeClassName('form-textarea-limit-indicator-error');
                JotForm.corrected(el.up('.form-line').down('textarea'));

                // eslint-disable-next-line no-var
                var limitByType = function (type) {
                    // eslint-disable-next-line no-var
                    var limitType = type == "min" ? el.readAttribute('data-typeminimum') : el.readAttribute('type');
                    if (limitType == 'Words') {
                        count = $A(cleaned_contents.replace(/[.,\/#!$%\^&\*;:{}=\-_`~()]/g, '').split(/\s+/)).without("").length;
                    } else if (limitType == 'Letters') {
                        count = cleaned_contents.length;
                    }
                    // eslint-disable-next-line no-var
                    var limiting = false;
                    if (((type == "min" && count < minimum) || (type == "max" && count > limit)) && !(firstRun === true)) {
                        $(el.parentNode).addClassName('form-textarea-limit-indicator-error');
                        // eslint-disable-next-line no-var
                        var minMax = type == "min" ? "Min" : "";
                        // eslint-disable-next-line no-var
                        var lim = type == "min" ? minimum : limit;
                        // eslint-disable-next-line no-var
                        var lettersWords = limitType === "Words" ? "word" : "character";
                        // eslint-disable-next-line no-var
                        var msg = JotForm.getValidMessage(JotForm.texts[lettersWords + minMax + "LimitError"], lim);
                        JotForm.errored(el.up('.form-line').down('textarea'), msg);
                        limiting = true;
                    }
                    el.update(count + "/" + ((minimum && count < minimum && type == "min") || limit == -1 ? minimum : limit));
                    return limiting;
                }
                // eslint-disable-next-line no-var
                var runMax = true;
                if (minimum && minimum > 0) {
                    runMax = !limitByType("min")
                }
                if (limit && limit > 0 && runMax) {
                    limitByType("max");
                }
            };
            countText(firstRun);
            input.observe('change', countText);
            input.observe('focus', countText);
            input.observe('keyup', countText);

            //check whether rich text
            if (input.hasClassName("form-textarea") && input.up('div').down('.nicEdit-main')) {
                // eslint-disable-next-line no-var
                var cEditable = input.up('div').down('.nicEdit-main');
                // eslint-disable-next-line no-var
                var runCount = function() {
                    input.value = cEditable.innerHTML;
                    countText();
                };
                cEditable.observe('keyup', runCount);
                cEditable.observe('blur', function() {
                    setTimeout(runCount, 0);
                });
            }
        });
    },

    /**
     * Activates all autocomplete fields
     */
    handleAutoCompletes: function () {
      // Edit mode first initialize
        // eslint-disable-next-line no-var
        var editModeFirst = [];
        // Get all autocomplete fields
        $H(JotForm.autoCompletes).each(function (pair) {
            // eslint-disable-next-line no-var
            var el = $(pair.key); // Field itself

            el.writeAttribute('autocomplete', 'off');

            // eslint-disable-next-line no-var
            var pairs = pair.value.split(/\r\n|\r|\n|\|/g);
            // eslint-disable-next-line no-var
            var values = $A(pairs); // Values for auto complete

            // eslint-disable-next-line no-var
            var lastValue; // Last entered value
            // eslint-disable-next-line no-var
            var selectCount = 0; // Index of the currently selected element
            //parent.setStyle('position:relative;z-index:1000;'); // Set parent position to relative for inserting absolute positioned list
            // eslint-disable-next-line no-var
            var liHeight = 0; // Height of the list element

            // Create List element with must have styles initially
            // eslint-disable-next-line no-var
            var list = document.createElement('div');
            list.className = 'form-autocomplete-list';
            Object.assign(list.style, {
                listStyle: 'none',
                listStylePosition: 'outside',
                position: 'absolute',
                zIndex: '10000',
                display: 'none'
            });

            // eslint-disable-next-line no-var
            var render = function () {

                // eslint-disable-next-line no-var
                var isCardForm = window.FORM_MODE === 'cardform';
                if(isCardForm) {
                    // eslint-disable-next-line no-var
                    var ebcr = el.getBoundingClientRect();
                    // eslint-disable-next-line no-var
                    var top = ((ebcr.top + ebcr.height)) - 5 + 'px';
                    // eslint-disable-next-line no-var
                    var left = (ebcr.left) + 'px';
                    // eslint-disable-next-line no-var
                    var width = (ebcr.width < 1 ? 100 : ebcr.width) + 'px';

                    list.setStyle({
                        top: top,
                        left: left,
                        width: width
                    });
                    list.show();
                } else {
                    // eslint-disable-next-line no-var
                    var dims = el.getDimensions(); // Dimensions of the input box
                    // eslint-disable-next-line no-var
                    var offs = el.cumulativeOffset();

                    list.setStyle({
                        backgroundColor: '#f0f8ff',
                        top: ((dims.height + offs[1])) + 'px',
                        left: offs[0] + 'px',
                        width: ((dims.width < 1 ? 100 : dims.width) - 2) + 'px'
                    });
                    list.show();
                }
            };

            // Insert list onto page
            // parent.insert(list);
            $(document.body).insert(list);

            list.close = function () {
                list.update();
                list.hide();
                selectCount = 0;
            };

            // Hide list when field get blurred
            el.observe('blur', function () {
                list.close();
            });

            // Search entry in values when user presses a key
            el.observe('keyup', function (e) {
                // eslint-disable-next-line no-var
                var word = el.value;
                // If entered value is the same as the old one do nothing
                if (lastValue == word) {
                    return;
                }
                lastValue = word; // Set last entered word
                list.update(); // Clean up the list first
                if (!word) {
                    list.close();
                    return;
                } // If input is empty then close the list and do nothing
                // Get matches

                // eslint-disable-next-line no-var
                var fuzzy = el.readAttribute('data-fuzzySearch') == 'Yes';
                // eslint-disable-next-line no-var
                var matches;

                // eslint-disable-next-line no-var
                var string = word.toLowerCase();
                matches = values.collect(function (v) {
                    if ((fuzzy && v.toLowerCase().include(string)) || v.toLowerCase().indexOf(string) == 0) {
                        return v;
                    }
                }).compact();

                // If matches found
                // eslint-disable-next-line no-var
                var maxMatches = el.readAttribute('data-maxMatches');
                if (maxMatches > 0) matches = matches.slice(0, maxMatches);
                if (matches.length > 0) {
                    matches.each(function (match) {
                        // eslint-disable-next-line no-var
                        var li = document.createElement('li');
                        li.className = 'form-autocomplete-list-item';

                        // eslint-disable-next-line no-var
                        var val = match;
                        li.val = val;
                        try {
                            val = match.replace(new RegExp('(' + word + ')', 'gim'), '<b>$1</b>');
                        }
                        catch (e) {
                            JotForm.error(e);
                        }
                        li.insert(val);
                        li.onmousedown = function () {
                            el.value = JotForm.decodeHtmlEntities(match);
                            el.triggerEvent('change');
                            list.close();
                        };
                        list.insert(li);
                    });

                    render();

                    // Get li height by adding margins and paddings for calculating 10 item long list height
                    liHeight = liHeight || $(list.firstChild).getHeight() + (parseInt($(list.firstChild).getStyle('padding'), 10) || 0) + (parseInt($(list.firstChild).getStyle('margin'), 10) || 0);
                    // limit list to show only 10 item at once
                    list.setStyle({
                        height: (liHeight * ((matches.length > 9) ? 10 : matches.length) + 4) + 'px',
                        overflow: 'auto'
                    });
                    // EditMode Check
                    // hide list for the first time for each field
                    if (JotForm.isEditMode() && editModeFirst.indexOf(el.id) === -1) {
                        list.hide();
                        editModeFirst.push(el.id);
                    }

                    if(!e.isTrusted) {
                        list.close();
                    }
                } else {
                    list.close(); // If no match found clean the list and close
                }
            });

            // handle navigation through the list
            el.observe('keydown', function (e) {

                //e = document.getEvent(e);
                // eslint-disable-next-line no-var
                var selected; // Currently selected item
                // If the list is not visible or list empty then don't run any key actions
                if (!list.visible() || !list.firstChild) {
                    return;
                }

                // Get the selected item
                selected = list.select('.form-autocomplete-list-item-selected')[0];
                if (selected) {
                    selected.removeClassName('form-autocomplete-list-item-selected');
                }

                switch (e.keyCode) {
                    case Event.KEY_UP: // UP
                        if (selected && selected.previousSibling) {
                            $(selected.previousSibling).addClassName('form-autocomplete-list-item-selected');
                        } else {
                            $(list.lastChild).addClassName('form-autocomplete-list-item-selected');
                        }

                        if (selectCount <= 1) { // selected element is at the top of the list
                            if (selected && selected.previousSibling) {
                                $(selected.previousSibling).scrollIntoView(true);
                                selectCount = 0; // scroll element into view then reset the number
                            } else {
                                $(list.lastChild).scrollIntoView(false);
                                selectCount = 10; // reverse the list
                            }
                        } else {
                            selectCount--;
                        }

                        break;
                    case Event.KEY_DOWN: // Down
                        if (selected && selected.nextSibling) {
                            $(selected.nextSibling).addClassName('form-autocomplete-list-item-selected');
                        } else {
                            $(list.firstChild).addClassName('form-autocomplete-list-item-selected');
                        }

                        if (selectCount >= 9) { // if selected element is at the bottom of the list
                            if (selected && selected.nextSibling) {
                                $(selected.nextSibling).scrollIntoView(false);
                                selectCount = 10; // scroll element into view then reset the number
                            } else {
                                $(list.firstChild).scrollIntoView(true);
                                selectCount = 0; // reverse the list
                            }
                        } else {
                            selectCount++;
                        }
                        break;
                    case Event.KEY_ESC:
                        list.close(); // Close list when pressed esc
                        break;
                    case Event.KEY_TAB:
                    case Event.KEY_RETURN:
                        if (selected) { // put selected field into the input bıx
                            el.value = JotForm.decodeHtmlEntities(selected.val);
                            lastValue = el.value;
                        }
                        list.close();
                        if (e.keyCode == Event.KEY_RETURN) {
                            e.stop();
                        } // Prevent return key to submit the form
                        break;
                    default:
                        return;
                }
            });

            // close on initial setup
            list.close();
        });

    },

    /**
     * Clever way to decode htmlentities
     * it even preserve tags if it's html
     * @param {string} html
     * @return {[string]} [the parsed string]
     */
    decodeHtmlEntities: function(str) {
        // eslint-disable-next-line no-var
        var textarea = document.createElement('textarea');
        textarea.innerHTML = str;
        return textarea.value;
    },

    /**
     * Returns the extension of a file
     * @param {Object} filename
     */
    getFileExtension: function (filename) {
        return (/[.]/.exec(filename)) ? (/[^.]+$/.exec(filename))[0] : undefined;
    },

    /**
     * Set APIUrl field according to current domain
     */
    setAPIUrl: function () {
        if (JotForm.enterprise !== 'undefined' && JotForm.enterprise) {
            this.APIUrl = 'https://' + JotForm.enterprise + '/API';
            return;
        }

        const isEUDomain = /(?:eu\.jotform)|(jotformeu\.com)/.test(window.location.host);
        const isHipaaDomain = /(?:hipaa\.jotform)/.test(window.location.host);
        switch (true) {
            case isEUDomain:
                this.APIUrl = 'https://eu-api.jotform.com';
                break;
            case isHipaaDomain:
                this.APIUrl = 'https://hipaa-api.jotform.com';
                break;
            case /form.jotform/.test(window.location.host):
            case /fb.jotform/.test(window.location.host):
            case /form.myjotform/.test(window.location.host):
            case /pci.jotform/.test(window.location.host):
                this.APIUrl = 'https://api.jotform.com';
                break;
            case Boolean(window.JotFormAPIEndpoint):
                this.APIUrl = window.JotFormAPIEndpoint;
                break;
            case window.parent !== window:
                const form = document.querySelector('.jotform-form');
                const formAction = form.readAttribute('action');
                switch (true) {
                    case Boolean(JotForm.hipaa):
                        this.APIUrl = 'https://hipaa-api.jotform.com';
                        break;
                    case /jotformeu\./.test(formAction):
                        this.APIUrl = 'https://eu-api.jotform.com';
                        break
                    default:
                        this.APIUrl = 'https://api.jotform.com';
                        break;
                }
                break;
            case JotForm.isFullSource === true:
                switch (true) {
                    case /eu-submit.jotform/.test(this.url):
                        this.APIUrl = 'https://eu-api.jotform.com';
                        break;
                    case /:\/\/submit.jotform/.test(this.url):
                        this.APIUrl = 'https://api.jotform.com';
                        break;
                    default:
                        this.APIUrl = this.url.replace(/\/$/, '') + '/API'
                        break;
                }
                break;
            default:
                this.APIUrl = '/API';
        }
    },

    /**
     * Get current session user and set it to JFUser property of window object
     */
    setJotFormUserInfo: function () {
        const formID = document.querySelector('input[name="formID"]').value;
        JotForm.createXHRRequest(JotForm.APIUrl + '/formuser/'+ formID +'/combinedinfo', 'GET', null, function (responseData) {
            const user = responseData.content.credentials;
            if (!user) {
                return;
            }
            if (user.accountType === 'GUEST' || user.account_type === 'GUEST') {
                return;
            }
            if (user.account_type && user.account_type.name && user.account_type.name === 'GUEST') {
                return;
            }
            window.JFUser = { name: user.name, email: user.email }

            if (window.parent.isBuilder) {
                return;
            }
            JotForm.setNameAndEmailFieldsFromUserCredentials();
        }, function () {}, true);
    },

    setAsanaTaskID: function () {
        appendHiddenInput('asanaTaskID', getQuerystring('asanaTaskID'));
    },

    /**
     * Takes a field element and if it is empty, fills it with provided value
     * @param {Object} element
     * @param {string} value
     */
    fillFieldElementIfEmpty: function (element, value) {
        if (element && !element.value) {
            element.value = value;
            if (window.FORM_MODE === 'cardform') {
                element.parentNode.classList.add('isFilled');
            }
        }
    },

    /**
     * It reads window.JFUser, takes name and email and fills first matched fields with these
     */
    setNameAndEmailFieldsFromUserCredentials: function () {
        if (!window.JFUser || getQuerystring('preview')) {
            return;
        }
        // It gets only the first field which matches
        // eslint-disable-next-line no-var
        var firstName = document.querySelector("input[data-component='first']");
        // eslint-disable-next-line no-var
        var lastName = document.querySelector("input[data-component='last']");
        // eslint-disable-next-line no-var
        var middleName = document.querySelector("input[data-component='middle']");
        // eslint-disable-next-line no-var
        var email = document.querySelector("input[data-component='email']");
        // eslint-disable-next-line no-var
        var user = window.JFUser;

        // Trigger runAllConditions in async way. So it will be executed after all set field operations
        setTimeout(function(){
            JotForm.runAllConditions();
        }, 1200);

        // Set the email but if it has another pre-set value, don't change it
        if (user.email) {
            JotForm.fillFieldElementIfEmpty(email, user.email);
        }
        if (!user.name) {
            return;
        }

        // eslint-disable-next-line no-var
        var names = user.name.split(' ');

        if (names.length > 1) {

            // Set the last name but if it has another pre-set value, don't change it
            JotForm.fillFieldElementIfEmpty(lastName, names[names.length - 1]);

            // If it has more than 2 words
            // If middle name field exist then fill it with all words (except last one and first one)
            // If middle name field does not exist then fill first name field with all words (except only last one)
            if (names.length > 2) {
                if (middleName) {
                    JotForm.fillFieldElementIfEmpty(middleName, user.name.substring(user.name.indexOf(" "), user.name.lastIndexOf(" ")));
                } else {
                    // Set the first name but if it has another pre-set value, don't change it
                    JotForm.fillFieldElementIfEmpty(firstName, user.name.substring(0, user.name.lastIndexOf(" ")));
                }

            }
        }

        // If name has 2 and less words or form has middle name field than first name field should be only first word in the name
        JotForm.fillFieldElementIfEmpty(firstName, names[0]);

    },

    getIsHTML: function(content) {
        try {
            // eslint-disable-next-line no-var
            var divElem = document.createElement('div');
            divElem.innerHTML = content;
            return divElem.children.length > 0;
        } catch (e) {
            return false;
        }
    },

    /**
     * Fill fields from the get values prepopulate
     */
    prePopulations: function (fields, isPrefill) {
        // eslint-disable-next-line no-var
        var _data = fields || document.get;

        /**
         * Replace unicode spaces with regular spaces
         * Full list: http://jkorpela.fi/chars/spaces.html
         */
        // eslint-disable-next-line no-var
        var replaceUnicodeSpaces = function (str) {
            return str.replace(/[\u00A0\u180E\u2000-\u200B\u202F\u205F\u3000\uFEFF]/, ' ');
        }

        $H(_data).each(function (pair) {
            if (typeof pair.value === 'undefined') {
                return;
            }
            // Some email clients add unnecessary carriage return so clean them
            if (pair.key.match(/[\s\S]+;/)) pair.key = pair.key.replace(/[\s\S]+;/, '');

            // eslint-disable-next-line no-var
            var stricterMatch = pair.key.length < 3 ? true : false; //this will prevent "a=fill" matching any name that starts with an a
            // eslint-disable-next-line no-var
            var strict_n = '[name$="_' + pair.key + '"]';
            // eslint-disable-next-line no-var
            var n = stricterMatch ? strict_n : '[name*="_' + pair.key + '"]';
            // eslint-disable-next-line no-var
            var checkbox_n = '[name*="_' + pair.key + '"]';
            // eslint-disable-next-line no-var
            var radio_n = '[name$="_' + pair.key + '"]';
            // eslint-disable-next-line no-var
            var input;

            if(window.FORM_MODE !== 'cardform'){
                input = $$('.form-star-rating' + strict_n)[0];
                if (input) {
                    input.setRating(parseInt(pair.value));
                    return;
                }
            }
            // if there are  two or more similar params e.g., ?name=John&name=Dave
            if (typeof pair.value === 'object') {
                pair.value = pair.value[0] || "";
            }

            input = $$('.form-slider' + n)[0]; //Add classname in builder?
            if (input) {
                input.setSliderValue(parseInt(pair.value));
                return;
            }
            // eslint-disable-next-line no-var
            var signatureFitbEl = n.indexOf('signature') > 0 && $$(n)[0];

            if (pair.key == "coupon-input" && $('coupon-input')) {
                $('coupon-input').setValue(pair.value);
                $('coupon-button').triggerEvent('click');
                $(window).scrollTo(0,0);
                return;
            }


            input = $$('.form-textbox%s, .form-dropdown%s, .form-textarea%s, .form-hidden%s'.replace(/\%s/gim, strict_n))[0];
            if (!input) {
                input = $$('.form-textbox%s, .form-dropdown%s, .form-textarea%s, .form-hidden%s'.replace(/\%s/gim, n))
                    .filter(function(x) { return x.value === ''; })[0];
                if (input) {
                    // eslint-disable-next-line no-var
                    var formIDField = $$('input[name="formID"]')[0];
                    // eslint-disable-next-line no-var
                    var questionType = input.closest('li') && input.closest('li').getAttribute('data-type');
                    if (questionType && !['control_rating', 'control_phone', 'control_time'].includes(questionType)) {
                        JotForm.errorCatcherLog({ message: {
                            inputName: input.name,
                            matchedParam: pair.key,
                            questionType,
                            formID: formIDField.value
                        }}, 'PREPOPULATE_SINGLE_INPUT_NON_STRICT_MATCH');
                    }
                }
            }

            if (!input && pair.key.indexOf("[") > 0) {
                // eslint-disable-next-line no-var
                var name = pair.key.substr(0, pair.key.lastIndexOf('['));
                // eslint-disable-next-line no-var
                var strictName = name.includes(']') ? name : pair.key.replace(/(\w+)\[\d+\]/g, '_$1\\[');
                // eslint-disable-next-line no-var
                var strictRadioName = pair.key.replace(/(\w+)\[\d+\]/g, '_$1');
                if (name.length > 0 && $$("select[name*=" + name + "], input[name*=" + name + "]").length > 0) {
                    // eslint-disable-next-line no-var
                    var index = pair.key.substr(pair.key.lastIndexOf('[') + 1).replace("]", "");
                    if (index && Number(index) > -1 && $$("select[name*=" + name + "], input[name*=" + name + "]").length > index) {
                        // eslint-disable-next-line no-var
                        var type = $$("select[name*=" + name + "]")[index] ? "select" : ($$("input[name*=" + name + "]")[index] && $$("input[name*=" + name + "]")[index].type);

                        switch (type) {
                            case "select":
                                if ($$("select[name*=" + name + "]")[index]) {
                                    $$("select[name*=" + name + "]")[index].value = pair.value.replace(/\+/g, ' ');
                                }
                                break;
                            case "text":
                            case "tel":
                            case "number":
                                input = $$("input[name*=" + strictName + "]")[index];
                                if (!input) {
                                    input = $$("input[name*=" + name + "]")[index];
                                    if (!input) {
                                        break;
                                    }
                                    // eslint-disable-next-line no-var
                                    var formIDField = $$('input[name="formID"]')[0];
                                    // eslint-disable-next-line no-var
                                    var questionType = input.closest('li') && input.closest('li').getAttribute('data-type');
                                    JotForm.errorCatcherLog({ message: {
                                        inputName: input.name,
                                        matchedParam: name,
                                        index,
                                        questionType,
                                        formID: formIDField.value
                                    }}, 'PREPOPULATE_MULTI_INPUT_NON_STRICT_MATCH');
                                }
                                input.value = pair.value.replace(/\+/g, ' ');
                                input.triggerEvent('keyup');
                                break;
                            case "radio":
                            case "checkbox":
                                try {
                                if ((pair.value == "true" || pair.value == 1) && $$("input[name*=" + name + "]")[index]
                                    && !($$("input[name*=" + name + "]").first().up('.form-line').readAttribute('data-type') === 'control_matrix' && name.indexOf('[') < 0)) {
                                        let checkboxRadioInput = $$("input[name$=" + strictRadioName + "]")[index] || $$("input[name*=" + strictName + "]")[index];
                                        if (!checkboxRadioInput) {
                                            checkboxRadioInput = $$("input[name*=" + name + "]")[index];
                                            if (!checkboxRadioInput) {
                                                break;
                                            }
                                            // eslint-disable-next-line no-var
                                            var formIDField = $$('input[name="formID"]')[0];
                                            // eslint-disable-next-line no-var
                                            var questionType = checkboxRadioInput.closest('li').getAttribute('data-type');
                                            JotForm.errorCatcherLog({ message: {
                                                inputName: checkboxRadioInput.name,
                                                matchedParam: name,
                                                index,
                                                questionType,
                                                formID: formIDField.value
                                            }}, 'PREPOPULATE_MULTI_INPUT_NON_STRICT_MATCH');
                                        }
                                    checkboxRadioInput.click();
                                }
                                }catch(e) {console.log(e);}
                                break;
                        }
                    }
                }
            }

            if (input && input.readAttribute('data-type') == 'input-grading') {
                // eslint-disable-next-line no-var
                var grades = pair.value.split(',');
                // eslint-disable-next-line no-var
                var stub = input.id.substr(0, input.id.lastIndexOf('_') + 1);
                // eslint-disable-next-line no-var
                for (var i = 0; i < grades.length; i++) {
                    if ($(stub + i)) $(stub + i).value = grades[i];
                }
            } else if (input && (input.hasClassName('form-checkbox-other-input') || input.hasClassName('form-radio-other-input'))) {
                JotForm.onTranslationsFetch(function () {
                    input = $(input.id); // Get input from DOM again because in setTimeout callback, input does not refer to the input in DOM.
                    // eslint-disable-next-line no-var
                    var inputId = input.id.split("_").pop();
                    if (n.indexOf('[other]') > -1) {
                        input.value = pair.value.replace(/\+/g, ' ');
                        JotForm.defaultValues[input.id] = input.value;
                    } else {
                        try {
                            // eslint-disable-next-line no-var
                            var valuesArray = input.up('.form-line').readAttribute('data-type') === "control_checkbox" ? pair.value.split(',') : [pair.value];
                            // eslint-disable-next-line no-var
                            for(var i=0; i<valuesArray.length; i++){
                                // eslint-disable-next-line no-var
                                var formInputDiv = window.FORM_MODE === 'cardform' ? input.up('.form-multiple-column') : input.up('.form-input, .form-input-wide');
                                // eslint-disable-next-line no-var
                                var normalInputWithValue = formInputDiv.select('input[type="radio"], input[type="checkbox"]').any(function (inp) {
                                    if (typeof FormTranslation !== 'undefined' && Object.keys(FormTranslation.dictionary).length > 0) {
                                        // eslint-disable-next-line no-var
                                        var translatedValues = Object.values(FormTranslation.dictionary)
                                            .map(function(language) { return language[inp.value]; })
                                            .filter(function(translation) { return translation; });
                                        if (translatedValues.length > 0) {
                                            return translatedValues.any(function(translatedValue) {
                                                return valuesArray[i] === translatedValue;
                                            });
                                        }
                                    }
                                    return valuesArray[i] === inp.value;
                                });
                                if (!normalInputWithValue && RegExp(pair.key + '\\[other\\]$').test(input.name)) {
                                    input.value = valuesArray[i];
                                    if (input.value === '') {
                                        continue;
                                    }
                                    valuesArray[i] = "other";
                                    // eslint-disable-next-line no-var
                                    var other = $('other_' + inputId);
                                    other.value = input.value;
                                }
                            }
                            pair.value = valuesArray.join(",");
                        } catch(e) {
                            console.error(e);
                        }
                    }
                });
            } else if (input && input.hasClassName("form-textarea") && input.up('div').down('.nicEdit-main')) {
                // eslint-disable-next-line no-var
                var val = pair.value.replace(/\+/g, ' ');
                if (window.DomPurify) {
                    val = window.DomPurify.sanitize(val);
                }
                input.up('div').down('.nicEdit-main').update(val);
            } else if (input && input.hasClassName("form-textarea") && input.up('div').down('.jfTextarea-editor')) {
                if (window.DomPurify) {
                    pair.value = window.DomPurify.sanitize(pair.value);
                }
                input.up('div').down('.jfTextarea-editor').update(pair.value);
            } else if (input && input.hasClassName("form-dropdown")) {
                // eslint-disable-next-line no-var
                var isMultiple = input.readAttribute('multiple') || input.multiple;
                // eslint-disable-next-line no-var
                var val = pair.value.replace(/\{\+\}/g,'{plusSign}').replace(/\+/g, ' ').replace(/\{plusSign\}/g,'+');
                // eslint-disable-next-line no-var
                var arr = isMultiple ? val.split(",") : [val];
                // eslint-disable-next-line no-var
                var options = input.select('option');

                input.value = arr;
                $A(options).each(function(option) {
                    option.writeAttribute("selected", arr.include(option.value) ? "selected" : false);
                });

                if (window.FORM_MODE === 'cardform' && window.CardForm) {
                    window.CardForm.setDropdownInitialValues();
                }
            } else if (input) {
                input.value = pair.value.replace(/\{\+\}/g,'{plusSign}').replace(/\+/g, ' ').replace(/\{plusSign\}/g,'+');

                // eslint-disable-next-line no-var
                var formLine = input.up('.form-line');
                // eslint-disable-next-line no-var
                var dontStripPlusIn = ["control_textarea"];

                // do not strip plus signs when value is passed from another jotform (b#1231139)
                // Don't strip plus sign if the input is email (#1416809)
                // do not strip plus signs if the input is textarea, textbox or address (#2168454)
                // Do not strip plus sign if prefill data
                if (isPrefill || document.referrer.match(/jotform/) || input.getAttribute('type') === 'email' || (formLine && (dontStripPlusIn.indexOf(formLine.readAttribute('data-type')) > -1))) {
                    input.value = pair.value;
                }
                JotForm.defaultValues[input.id] = input.value;
                try{
                    if (formLine && (formLine.readAttribute('data-type') === "control_datetime" || formLine.readAttribute('data-type') === "control_inline")) {
                        // eslint-disable-next-line no-var
                        var dateField = formLine.readAttribute('data-type') === 'control_datetime' ? formLine : input.up('[data-type=datebox]');
                        if(dateField){
                            // eslint-disable-next-line no-var
                            var year = dateField.down('input[id*="year_"]').value;
                            // eslint-disable-next-line no-var
                            var month = dateField.down('input[id*="month_"]').value;
                            // eslint-disable-next-line no-var
                            var day = dateField.down('input[id*="day_"]').value;
                            if (year !== "" && month !== "" && day !== "") {
                                JotForm.formatDate({
                                    date: new Date(year, month - 1, day),
                                    dateField: dateField
                                });
                                // We need to set default value for lite mode field and date field because
                                // if there is no default value, prepopulated values will delete after condition checking
                                // eslint-disable-next-line no-var
                                var dateInput = dateField.down('input[id*="input_"]');
                                // eslint-disable-next-line no-var
                                var liteModeInput = dateField.down('input[id*="lite_mode_"]');
                                if (dateInput && dateInput.getAttribute('id').indexOf("timeInput") === -1) {
                                    // Card Form's date field is standard HTML5 date field and HTML5 date field's value must be in ISO Format(yyyy-mm-dd)
                                    // eslint-disable-next-line no-var
                                    var ISODate = year + '-' + month + '-' + day;
                                    JotForm.defaultValues[dateInput.id] = ISODate;
                                    dateInput.value = ISODate;
                                }
                                if (liteModeInput) {
                                    JotForm.defaultValues[liteModeInput.id] = liteModeInput.value;
                                }
                            }
                        }
                    }
                } catch (e) {
                    console.log(e)
                }

            } else if (signatureFitbEl) {
                // eslint-disable-next-line no-var
                var spanElement = signatureFitbEl.closest('span');
                // eslint-disable-next-line no-var
                var imgElement = spanElement && spanElement.querySelector('.FITB-sign-image');

                if (imgElement) {
                    signatureFitbEl.value = pair.value;
                    imgElement.src = pair.value;
                }
            }
            $$('.form-textbox%s, .form-textarea%s, .form-hidden%s'.replace(/\%s/gim, n)).each(function (input) {
                //simulate 'keyup' event to execute conditions upon prepopulation
                input.triggerEvent('keyup');
            });
            $$('.form-dropdown%s'.replace(/\%s/gim, n)).each(function (input) {
                //simulate 'change' event to execute conditions upon prepopulation
                input.triggerEvent('change');
            });

            JotForm.onTranslationsFetch(function() {
                // eslint-disable-next-line no-var
                var checkboxNaming = '(_' + pair.key + '([(.*?)])?)$';
                // eslint-disable-next-line no-var
                var checkboxNamingRegex = new RegExp(checkboxNaming.replace(/\[/g, '\\[').replace(/\]/g, '\\]'));
                // eslint-disable-next-line no-var
                var checkboxParam = '.form-radio%s'.replace(/\%s/gim, radio_n) + ', ' + '.form-checkbox%s'.replace(/\%s/gim, checkbox_n)
                $$(checkboxParam).each(function (input) {
                    input = $(input.id);
                    if (isPrefill && input.type === 'checkbox' && !checkboxNamingRegex.test(input.name)) return;
                    //input.checked = $A(pair.value.split(',')).include(input.value);
                    //Emre: when checkboxed is checked, total count does not increase on payment forms  (79814)

                    // eslint-disable-next-line no-var
                    var disabled = input.disabled ? !!(input.enable()) : false;
                    // eslint-disable-next-line no-var
                    var value = pair.value.replace(/\{\+\}/g,'{plusSign}').replace(/\+/g, ' ').replace(/\{plusSign\}/g,'+');

                    // eslint-disable-next-line no-var
                    var allTranslations = [];

                    if (typeof FormTranslation !== 'undefined') {
                        Object.values(FormTranslation.dictionary).forEach(
                            function processTranslations(e) {
                                if (e[input.value]) {
                                    allTranslations.push(e[input.value].replace(/\{\+\}/g,'{plusSign}').replace(/\+/g, ' ').replace(/\{plusSign\}/g,'+'));
                                }
                            }
                        );
                    }

                    if (allTranslations.length === 0) {
                        allTranslations.push(input.value.replace(/\{\+\}/g,'{plusSign}').replace(/\+/g, ' ').replace(/\{plusSign\}/g,'+')); // There is no translation so just compare actual values
                    }

                    // eslint-disable-next-line no-var
                    var valueSplittedByComma = value.replace(/([^\\]),/g, '$1\u000B').split('\u000B');
                    allTranslations.each(function(inputValue) {
                        // if input value contains comma, escape it
                        if(!isPrefill && inputValue.indexOf(',') && !(value.includes('<br>'))) {
                            inputValue = inputValue.replace(/,/g, "\\,");
                        }

                        if (
                            value == inputValue ||
                            $A(valueSplittedByComma).include(inputValue) ||
                            $A(value.split('<br>')).include(inputValue) ||
                            valueSplittedByComma.includes(replaceUnicodeSpaces(inputValue)) // BUGFIX: #5135762, try one more time with unicode spaces replaced
                        ) {
                            if (!input.checked) {
                                if(input.disabled) {
                                    // Ticket ID: 1479721
                                    // Values were prepopulating with setTimeout function before but that was not working properly.
                                    // Sometimes,Inputs were disabling before prepopulation and radio fields were prepopulating wrong.
                                    // I replaced setTimeout part but I think this if block meaningless because input disables after prepopulation.
                                    // I didn't remove because if somehow input disables before prepopulation, values will populate here.
                                    input.enable();
                                    input.click();
                                    input.disable();
                                } else {
                                    input.click();
                                }
                                JotForm.defaultValues[input.id] = inputValue;
                            }
                        } else if ($A(pair.value.split(',')).include('other')) {
                            if ((input.name.indexOf('[other]') > -1) || (input.id && input.id.indexOf('other_') > -1)) {
                                input.click(); //select other option
                            }
                        }

                        if(disabled) setTimeout(function() { input.disable(); });
                    });
                });
            });

            //if textarea is hinted and has content remove the hint class

            if (input && input.hasClassName('form-textarea') && input.hasClassName('form-custom-hint')) {
                let hasContentForTextArea = input.hasContent;
                const richTextEditorContent =  input.up('div').down('.nicEdit-main') && input.up('div').down('.nicEdit-main').innerHTML;
                if (richTextEditorContent) {
                    hasContentForTextArea = true;
                }
                if (hasContentForTextArea) {
                    input.removeClassName('form-custom-hint');
                }
            }
        });

        setTimeout(function(){
            if(!(document.getElementById('draftID'))){
                JotForm.firstUrlPrefillCondition = false;
                JotForm.runAllConditions();
            }
        }, 1500);

        // When the form is embeded (with single script tag), fields are prepopulated after isFilled check.
        // This causes placaholders and texts overlap. We need to explicitly call this method again.
        if (window.FORM_MODE === 'cardform') {
            // eslint-disable-next-line no-var
            var cards = window.CardForm.cards;
            window.CardForm.checkCardsIfFilled(cards);
        }

        // BUGFIX: #4446963 - Browser's native share feature gets the link from canonical tag
        // eslint-disable-next-line no-var
        var hasQueryParams = window.location.search !== '';
        // eslint-disable-next-line no-var
        var canonical = $$('link[rel="canonical"]')[0];
        if (hasQueryParams && canonical && window.location.href !== canonical.href) {
            canonical.href = window.location.href;
        }
    },
    /**
     * Reset form while keeping the values of hidden fields
     * @param {Object} frm
     */
    resetForm: function (frm) {
        // eslint-disable-next-line no-var
        var hiddens = frm.querySelectorAll('input[type="hidden"], #input_language');
        hiddens.forEach(function (h) {
            h.__defaultValue = h.value;
        });
        frm.reset();
        hiddens.forEach(function (h) {
            h.value = h.__defaultValue;
        });
        return frm;
    },
    /**
     * Bring the form data for edit mode
     *
     * dynamically load editMode function from form.edit.mode.js
     * it will add a function named editModeFunction to global scope
     */
    editMode: function (data, noreset, skipField, skipCardIndex, cb, errorCb) {
        if (cb === undefined) {
            cb = function() { };
        }

        if (errorCb === undefined) {
            errorCb = function() { };
        }

        if (this.isNewSaveAndContinueLaterActive && this.isEditMode()) {
            document.querySelectorAll('.js-new-sacl-button').forEach(function (saveBtn) {
                saveBtn.style.display = 'none';
            });
        }
        let preLink = "";
        if (!JotForm.debug) {
            // if (this.url.search("https") == -1) {
            //     preLink = "http://cdn.jotfor.ms/";
            // } else {
            //     preLink = "https://cdn.jotfor.ms/";
            // }
            preLink = "https://cdn.jotfor.ms/";
        }

        if (document.get.offline_forms == 'true' && document.get.jotformNext == 1) {
            preLink = window.location.pathname.replace('/index.html', '');
        }

        const self = this;
        if (!window.editModeFunction) {
            this.loadScript(preLink + '/s/static/latest/js/form.edit.mode.js?v_' + (new Date()).getTime(), function () {
                //editModeFunction is function name defined in form.edit.mode.js
                // eslint-disable-next-line no-undef
                self.editMode = editModeFunction;
                if (JotForm.sessionID && data) {
                    data.fromSession = true;
                }
                self.editMode(data, noreset, skipField, skipCardIndex, errorCb);
                cb()
            });
            this.loadScript(preLink + '/s/static/latest/js/stock.edit.js?v_' + (new Date()).getTime())
        } else {
            self.editMode(data, noreset, skipField, skipCardIndex, cb);
        }
    },
    /**
     * Helper function that will tell if form is in edit mode
     */
    isEditMode: function () {
        if (window.FORM_MODE === 'cardform' && window.CardForm && window.CardForm.layoutParams) {
            return CardForm.layoutParams.isEditMode;
        }

        return window.location.pathname.match(/^\/edit\//) ||
          window.location.pathname.match(/^\/\/edit/) ||
          window.location.href.match(/mode=inlineEdit/) ||
          window.location.href.match(/mode=submissionToPDF/) ||
          window.JotForm.offlineEditMode === true;
    },
    /**
     * add the given condition to conditions array to be used in the form
     * @param {Object} qid id of the field
     * @param {Object} condition condition array
     */
    setConditions: function (conditions) {

        conditions.reverse();

        JotForm.conditions = conditions;
        // Ozan, IMPORTANT NOTE: To enable chainig multiple field/email actions to a single/multiple conditions,
        // any "condition.action" is expected to be an array, regardless of "condition.type". Since old conditions
        // are stored in the database with a single action, "condition.action" is converted to an array, concatting
        // the only action which condition has.
        conditions.forEach(function (condition) {
            condition.action = [].concat(condition.action);
        });
    },

    setCalculations: function (calculations) {
        if(JotForm.calculations.length === 0) {
            JotForm.calculations = calculations;
        } else {
            Object.values(calculations).forEach(function(calculation) {
                JotForm.calculations.push(calculation);
            });
        }
    },

    prepareCalculationsOnTheFly: function (questions) {
        // eslint-disable-next-line no-var
        var questions_by_name = [];
        // eslint-disable-next-line no-var
        var questions_by_type = [];

        function transpose(a) {
          return a[0].map(function (val, c) {
            return a.map(function (r) {
              return r[c];
            });
          });
        }

        if (questions.length > 0) {
            // if no calculation is set, calculations equals to an empty object
            if (JotForm.calculations.length <= 0) {
                JotForm.calculations = [];
            }

            questions.each(function(question) {
                if (question) {
                    // Create lookup array
                    questions_by_name[question.name] = question.qid;
                    // Create type array in order to differentiate between inline field and multi-valued fields (address, fullname) when colon is used
                    questions_by_type[question.name] = question.type;
                }
            });

            questions.each(function(question) {
                if (question) {
                    // eslint-disable-next-line no-var
                    var values = [];
                    switch (question.type) {
                        // some questions may have their values on a different place
                        case 'control_textbox':
                          question.text !== '' ? values.push(question.text) : void(0);
                          question.subLabel !== '' ? values.push(question.subLabel) : void(0);
                          question.description !== '' ? values.push(question.description) :void(0);
                          break;
                        case 'control_image':
                          question.labelText !== '' ? values.push(question.labelText) : void(0);
                          break;
                        case 'control_inline':
                          question.template !== '' ? values.push(question.template) : void(0);
                          break;
                        default:
                          question.text !== '' ? values.push(question.text) : void(0);
                          question.description !== '' ? values.push(question.description) :void(0);
                    }

                    // eslint-disable-next-line no-var
                    for(var value; value = values.shift();) {
                      // eslint-disable-next-line no-var
                      var regex = /\{([^\}]*)\}/gim;
                      // collect all questions in array
                      // eslint-disable-next-line no-undef, no-var
                      for (var questions = []; result = regex.exec(value); questions.push(result));

                      if (questions.length > 0) {
                          // reorganise the matrix
                          questions = transpose(questions);

                          questions[1].forEach(function(question_name) {
                              // eslint-disable-next-line no-var
                              var qname, qtype;
                              // eslint-disable-next-line no-var
                              var seperator = question_name.indexOf(':') > -1 ? ':' : '[';
                              qname = questions_by_name[question_name.split(seperator)[0]];
                              qtype = questions_by_type[question_name.split(seperator)[0]];

                              // there may be a multiline question field in the question_name:
                              // eslint-disable-next-line no-var
                              var multilineFieldRegex = /\[(.*?)\]/gi;
                              // eslint-disable-next-line no-var
                              var multilineFieldResult = multilineFieldRegex.exec(question_name);
                              // eslint-disable-next-line no-var
                              var multilineFieldEquation = multilineFieldResult ? qname + '|' + multilineFieldResult[1] : '';

                              if (qtype === 'control_inline') {
                                  // eslint-disable-next-line no-var
                                  var inlineFieldRegex = /(\:)(.*)/gi;
                                  // eslint-disable-next-line no-var
                                  var inlineFieldResult = inlineFieldRegex.exec(question_name);
                                  if (inlineFieldResult) {
                                      // eslint-disable-next-line no-var
                                      var subfield = inlineFieldResult[2];
                                      // eslint-disable-next-line no-var
                                      var subfieldSplit = subfield.split('-');
                                      // eslint-disable-next-line no-var
                                      var fieldId = Number(subfieldSplit[0]) ? subfieldSplit[0] : subfieldSplit[1];
                                      multilineFieldEquation = qname + '|' + fieldId;
                                  }
                              }

                              JotForm.calculations.push({
                                  decimalPlaces: "2",
                                  defaultValue: "",
                                  equation: "{" + (multilineFieldEquation || qname) + "}",
                                  ignoreHiddenFields: "",
                                  insertAsText: "1",
                                  isLabel: ["control_text", "control_inline"].indexOf(question.type) > -1 ? "" : "1",
                                  newCalculationType: "1",
                                  operands: (multilineFieldEquation || qname),
                                  readOnly: "",
                                  replaceText: question_name,
                                  resultField: question.qid,
                                  showBeforeInput: "",
                                  tagReplacement: "1",
                                  useCommasForDecimals: "",
                                  allZeroCopy: ""
                              });
                          });
                      }
                    }
                }
            });
        }
    },

    runConditionForId: function (id) {
        Object.values(JotForm.fieldConditions).forEach(function (value) {
            const conds = value.conditions;
            conds.forEach(function (cond) {
                cond.terms.forEach(function (term) {
                    // calls checkCondition on product quantity checkbox state
                    // eslint-disable-next-line no-var
                    var inputTermField = "input_" + term.field;
                    if (term.field === id || id === inputTermField) {
                        JotForm.checkCondition(cond);
                    }
                });
            });
        });
    },

    otherConditionTrue: function (field, visibility) {
        visibility = visibility.replace(/multiple/, "");
        // eslint-disable-next-line no-var
        var otherConditionTrue = false;
        Object.values(JotForm.fieldConditions).forEach(function (value) {
            // eslint-disable-next-line no-var
            var conds = value.conditions;
            conds.forEach(function (cond) {
                cond.action.forEach(function (action) {
                    if (action.fields) {
                        action.fields.forEach(function (multiField) {
                            if (multiField === field && action.visibility && action.visibility.toLowerCase().replace(/multiple/, "") === visibility && action.hasOwnProperty('currentlyTrue') && action.currentlyTrue) {
                                otherConditionTrue = true;
                                return;
                            }
                        });
                    }
                    if (action.field === field && action.visibility && action.visibility.toLowerCase() === visibility && action.hasOwnProperty('currentlyTrue') && action.currentlyTrue) {
                        otherConditionTrue = true;
                    }
                });
            });
        });

        return otherConditionTrue;
    },

    /**
     * Shows a field
     * @param {Object} field
     */
    showField: function (field, isConditionActive) {
        if (JotForm.otherConditionTrue(field, 'hide')) return;
        // Default value for isConditionActive
        isConditionActive = typeof isConditionActive == 'undefined' ? true : isConditionActive
        // eslint-disable-next-line no-var
        var element = null;
        // eslint-disable-next-line no-var
        var idField = $('id_' + field);
        // eslint-disable-next-line no-var
        var cidField = $('cid_' + field);
        // eslint-disable-next-line no-var
        var sectionField = $('section_' + field);

        if (sectionField && cidField) { // Form collapse
            element = sectionField;
        } else if (cidField && !idField) { // Heading
            element = cidField;
        } else { // Regular field
            element = idField;
        }

        //If no form element is found check for hidden single product field
        if (!element) {
            // eslint-disable-next-line no-var
            var productField = $$('input[name*="q' + field + '"][type="hidden"]');

            if (productField.length > 0) {
                productField[0].setAttribute('selected', true);
            }

            return element;
        }

        if (element.getAttribute('data-type') === 'control_button' && element.getElementsBySelector('button').length > 1) {
            element.getElementsBySelector('button').each(function (item) {
                if (JotForm.useJotformSign === 'Yes' && item.hasClassName('useJotformSign-button')) {
                    item.show();
                } else if((!JotForm.useJotformSign || JotForm.useJotformSign !== 'Yes') && item.hasClassName('submit-button')) {
                    item.show();
                }
                if (item.hasClassName('form-submit-reset') || item.hasClassName('form-submit-print')) {
                    item.show();
                }
                if (item.hasClassName('form-pagebreak-back')) {
                    item.show();
                }
                if (element.querySelector('.form-submit-clear-wrapper')) {
                    element.querySelector('.form-submit-clear-wrapper').show();
                }
            });
        } else {
            element.show();
        }

        // check if element is currently hidden
        // eslint-disable-next-line no-var
        var wasHidden = element.hasClassName('form-field-hidden') || element.hasClassName('always-hidden');

        element.removeClassName('form-field-hidden');
        if (isConditionActive || window.FORM_MODE === 'cardform') {
             if (window.FORM_MODE == 'cardform' && element.hasClassName('always-hidden')) {
                element.setAttribute('always-hidden-removed-by-cardform', true)
            }
            element.removeClassName('always-hidden');
        }
        if(!(element.hasClassName("form-section") || element.hasClassName("form-section-closed")) && element.down(".always-hidden")) {
            element.down(".always-hidden").removeClassName('always-hidden');
        }

        if (JotForm.paymentFields.indexOf(element.getAttribute('data-type')) > -1 && $('hiddenPaymentField')) {
            $('hiddenPaymentField').remove();
        }

        // kemal:bug::#145986 Form collapse bug
        if (sectionField) {
            if (element.hasClassName('form-section-closed')) { //if a closed form-section
                //check for .form-collapse-table has class form-collapse-hidden
                if (element.select('.form-collapse-table')[0].hasClassName('form-collapse-hidden')) {
                    //element is hidden remove class add class
                    element.removeClassName('form-section-closed');
                    element.addClassName('form-section');
                    element.setStyle({
                        height: "auto",
                        overflow: "visible"
                    });
                } else {
                    //element is visible do not add auto height
                    element.setStyle({
                        overflow: "hidden"
                    });
                }
            } else {
                //case for status = closed
                element.setStyle({
                    height: "auto",
                    overflow: "visible"
                });
            }
        }

        if (JotForm.getInputType(field) === 'html') {
            if ($('text_' + field).innerHTML.match(/google.*maps/gi)) { //google maps hack to get the iframe to redisplay in the right place
                $('text_' + field).innerHTML = $('text_' + field).innerHTML;
            }
            JotForm.runAllCalculationByID(field);
        }

        // eslint-disable-next-line no-var
        var elemShown = element.show();

        if (JotForm.getInputType(field) === 'widget') {
            JotForm.showWidget(field);
        }
        if (JotForm.getInputType(field) === 'signature' && wasHidden) {
            JotForm.showAndResizeESignature(field);
        }

        // kenneth: form callapse + condition + widgets bug when collapse opened by default
        if (JotForm.getInputType(field) === 'collapse') {
            // do something under collapse bar if shown opened by default
            if (sectionField && !element.hasClassName('form-section-closed')) {
                element.select('li.form-line').each(function (node) {
                    // eslint-disable-next-line no-var
                    var id = node.id.split('_')[1];

                    // show widget fields
                    if (JotForm.getInputType(id) === 'widget') {
                        JotForm.showWidget(id);
                    } else if (JotForm.getInputType(id) === 'signature') {
                        JotForm.showAndResizeESignature(id);
                    }
                });
            }
        }

        // Re-calculate cardform matrix size
        if (window.FORM_MODE == 'cardform' && wasHidden && ($('id_' + field) && $('id_' + field).readAttribute('data-type') == 'control_matrix')) {
            JotForm.setMatrixLayout(field, false);
        }

        // if donation and has a source field
        if (JotForm.donationField && element.down('[data-component="paymentDonation"][data-custom-amount-field]')) {
            JotForm.updateDonationAmount();
        }

        if (element.getAttribute('data-type') === "control_paypalSPB" && $$('[data-paypal-button="Yes"]')[0]) {
            // eslint-disable-next-line no-var
            var paypalButton = $$('.paypal-buttons.paypal-buttons-context-iframe')[0];

            if (paypalButton) {
                // eslint-disable-next-line no-var
                var paypalButtonContainer = JotForm.getContainer(paypalButton);

                if (paypalButtonContainer) {
                    paypalButtonContainer.setAttribute('paypal-button-status', 'show');
                }
            }
        }

        return elemShown;
    },

    showAllHiddenFields: function () {
        JotForm.conditions = [];
        JotForm.fieldConditions = {};

        $$('.always-hidden, .form-field-hidden').each(function(el) {
            const id = el.getAttribute('id').split('_')[1];
            JotForm.showField(id);
        });
    },

    collectStylesheet: function () {
        const styles = document.querySelectorAll('style, link');
        const styleTags = [];

        styles.forEach(function (style) {
            if (style.type === 'text/css' || style.rel === 'stylesheet') {
                styleTags.push(style.outerHTML);
            }
        });

        return styleTags;
    },


    showWidget: function (id, postTranslate) {
        // eslint-disable-next-line no-var
        var referrer = document.getElementById("customFieldFrame_" + id) ? document.getElementById("customFieldFrame_" + id).src : false;
        if (referrer) {
            // eslint-disable-next-line no-var, no-undef
            var frame = (navigator.userAgent.indexOf("Firefox") != -1 && typeof getIframeWindow !== 'undefined') ? getIframeWindow(window.frames["customFieldFrame_" + id]) : window.frames["customFieldFrame_" + id];
            // eslint-disable-next-line no-var
            var isFrameXDready = (!$("customFieldFrame_" + id).hasClassName('frame-xd-ready') && !$("customFieldFrame_" + id).retrieve('frame-xd-ready')) ? false : true;

            // only post a message when its ready to receive a post message
            if (frame && isFrameXDready) {
                window.XD.postMessage(JSON.stringify({type: "show", qid: id}), referrer, frame);

                // send ready message event at the same time for widgets
                // that doesn't work with show
                if (typeof window.JCFServerCommon !== 'undefined') {
                    // only send ready if the section of the frame is current visible
                    if (JotForm.isVisible(JotForm.getSection($("id_" + id))) && JotForm.isVisible($("id_" + id))) {
                        // verify existence of widget frame
                        if (window.JCFServerCommon.frames.hasOwnProperty(id)) {
                            window.JCFServerCommon.frames[id].sendReadyMessage(id);
                        }
                    }
                }

                // BUGFIX#2781483 :: send translate message event for configurable list widgets
                if (postTranslate && JotForm.getWidgetType(id) === 'configurableList' && typeof FormTranslation !== 'undefined') {
                    // eslint-disable-next-line no-var
                    var message = {
                        type: "translate",
                        id: id,
                        dictionary: FormTranslation.dictionary,
                        to: FormTranslation.to,
                        success: true
                    };
                    // eslint-disable-next-line no-undef
                    XD.postMessage(JSON.stringify(message), referrer, frame);
                }
            }
        }
    },

    reloadWidget: function (id) {
        // eslint-disable-next-line no-var
        var referrer = document.getElementById("customFieldFrame_" + id) ? document.getElementById("customFieldFrame_" + id).src : false;
        if (referrer) {
            // eslint-disable-next-line no-var, no-undef
            var frame = (navigator.userAgent.indexOf("Firefox") != -1 && typeof getIframeWindow !== 'undefined') ? getIframeWindow(window.frames["customFieldFrame_" + id]) : window.frames["customFieldFrame_" + id];
            // eslint-disable-next-line no-var
            var isFrameXDready = (!$("customFieldFrame_" + id).hasClassName('frame-xd-ready') && !$("customFieldFrame_" + id).retrieve('frame-xd-ready')) ? false : true;

            // only post a message when its ready to receive a post message
            if (frame && isFrameXDready) {
                // eslint-disable-next-line no-undef
                XD.postMessage(JSON.stringify({type: "reload", qid: id}), referrer, frame);
            }
        }
    },
    disableWidget: function (id) {
        // eslint-disable-next-line no-var
        var referrer = document.getElementById("customFieldFrame_" + id) ? document.getElementById("customFieldFrame_" + id).src : false;
        if (referrer) {
            // eslint-disable-next-line no-var, no-undef
            var frame = (navigator.userAgent.indexOf("Firefox") != -1 && typeof getIframeWindow !== 'undefined') ? getIframeWindow(window.frames["customFieldFrame_" + id]) : window.frames["customFieldFrame_" + id];
            // eslint-disable-next-line no-var
            var isFrameXDready = (!$("customFieldFrame_" + id).hasClassName('frame-xd-ready') && !$("customFieldFrame_" + id).retrieve('frame-xd-ready')) ? false : true;

            // only post a message when its ready to receive a post message
            if (frame && isFrameXDready) {
                // eslint-disable-next-line no-undef
                window.XD.postMessage(JSON.stringify({type: "disable", qid: id}), referrer, frame);
            }
        }
    },


    /**
     * Determines if widgets should skip submitting the form or not
     * Some other processes, like payments or encryption, might have to perform the submit action
     * @returns {boolean}
     */
    shouldWidgetSkipSubmit: function () {
        if (JotForm.isEncrypted || JotForm.disableSubmitButton) { return true; }

        // eslint-disable-next-line no-var
        var selfSubmittingPayments = ["stripe", "braintree", "square", "eway", "bluepay", "moneris", "paypalcomplete", "mollie"];
        if (JotForm.payment === 'sensepass' && JotForm.isDirectFlow === 'Yes') {
            selfSubmittingPayments.push('sensepass');
        }

        if (window.paymentType === 'subscription' && JotForm.payment === 'paypalcomplete') {
            selfSubmittingPayments.splice(selfSubmittingPayments.indexOf('paypalcomplete'), 1);
        }

        if (!JotForm.isEditMode() && JotForm.isPaymentSelected() &&  selfSubmittingPayments.indexOf(JotForm.payment) > -1) {
            return JotForm.paymentTotal > 0 || (JotForm.payment == 'stripe' && window.paymentType == 'subscription');
        }

        return false;
    },

    showAndResizeESignature: function(id) {
        // resize field and reset, only when visible
        // eslint-disable-next-line no-var
        var element = document.querySelector('#id_' + id);
        if (element && JotForm.isVisible(element) && element.querySelectorAll('.pad').length > 0) {
          const sigresizeEvent = document.createEvent('HTMLEvents');
          sigresizeEvent.initEvent("dataavailable", true, true);
          sigresizeEvent.eventName = "on:sigresize";
          sigresizeEvent.memo = sigresizeEvent.memo || { };

          document.querySelector('.pad').dispatchEvent(sigresizeEvent);
        }
    },

    /**
     * Hides a field
     * @param {Object} field
     */
    hideField: function (field, multiple, dontClear) {
        if (JotForm.otherConditionTrue(field, 'show')) return;

        // eslint-disable-next-line no-var
        var idPrefix = 'id_';

        // For headings
        if ($('cid_' + field) && !$('id_' + field)) {
            idPrefix = 'cid_';
        }

        // For form collapses
        if ($('cid_' + field) && $('section_' + field)) {
            idPrefix = 'section_';
        }
        // eslint-disable-next-line no-var
        var element = $(idPrefix + field);

        if (element) {
            element.addClassName('form-field-hidden');
            // add field to identify that payment is conditionally hidden
            // eslint-disable-next-line no-var
            var isProductListInEditMode = JotForm.isEditMode() && JotForm.clearFieldOnHide === 'dontClear' && element.getAttribute('data-type') === 'control_payment';
            if (JotForm.paymentFields.indexOf(element.getAttribute('data-type')) > -1 && !$('hiddenPaymentField') && !isProductListInEditMode) {
                appendHiddenInput('hiddenPaymentField', 1, { id: 'hiddenPaymentField' });
            }

            if (element.getAttribute('data-type') === "control_paypalSPB" && $$('[data-paypal-button="Yes"]')[0]) {
                // eslint-disable-next-line no-var
                var paypalButton = $$('.paypal-buttons.paypal-buttons-context-iframe')[0];

                if (paypalButton) {
                    // eslint-disable-next-line no-var
                    var paypalButtonContainer = JotForm.getContainer(paypalButton);

                    if (paypalButtonContainer) {
                        paypalButtonContainer.setAttribute('paypal-button-status', 'hide');
                    }
                }
            }

            if (JotForm.clearFieldOnHide == "enable" && !dontClear && !JotForm.ignoreInsertionCondition) {
                try {
                    JotForm.clearField(field);
                } catch (e) {
                    console.log(e);
                }
            }

            if (element.style.setProperty) {
                element.style.setProperty('display', 'none', 'important');
            } else {
                element.hide();
            }

            if (element.getAttribute('data-type') && element.getAttribute('data-type') == 'control_button' && element.getElementsBySelector('button').length > 1) {
                // this means that the form has at least two of them (submit-save-clear-reset)
                // eslint-disable-next-line no-var
                var submitButtonsElements = element.getElementsBySelector('button');
                // eslint-disable-next-line no-var
                var saclButton = submitButtonsElements.find(function(bt) { return bt.hasClassName('form-sacl-button')});
                // eslint-disable-next-line no-var
                var previewPDFButton = submitButtonsElements.find(function(bt) { return bt.hasClassName('form-submit-preview')});

                if (saclButton || previewPDFButton) {
                    // this meas that the form has a save & continue later // previewPDFButton
                    // therefore, we should be show always, even if submit button hide
                    element.show();
                    submitButtonsElements.each(function (item) {
                        if(item != saclButton && item != previewPDFButton) {
                            item.addClassName('form-field-hidden');
                            if(item.style.setProperty) {
                                item.style.setProperty('display', 'none', 'important');
                            } else {
                                item.hide();
                            }
                            if(element.querySelector('.form-submit-clear-wrapper')) {
                                element.querySelector('.form-submit-clear-wrapper').hide();
                            }
                        }
                    });

                }
            }

            // if donation and has a source field
            if (JotForm.donationField && element.down('[data-component="paymentDonation"][data-custom-amount-field]')) {
                JotForm.updateDonationAmount(0);
            }
            // correct this field
            JotForm.corrected(element);

            if (JotForm.clearFieldOnHide == 'enable' && JotForm.getInputType(field) === "signature") {
                JotForm.handleSignatureState(field);
            }

            return element;
        }

        //If no form element is found check for hidden single product field
        // eslint-disable-next-line no-var
        var productField = $$('input[name*="q' + field + '"][type="hidden"]');

        if (productField.length > 0) {
            productField[0].setAttribute('selected', false);
        }
    },

    handleSignatureState: function(field) {
        // eslint-disable-next-line no-var
        var signatureLine = jQuery('#signature_pad_' + field + " .signature-line");
        // eslint-disable-next-line no-var
        var signatureInput = jQuery('#signature_pad_' + field + " #input_" + field);
        // eslint-disable-next-line no-var
        var pad = jQuery('#signature_pad_' + field + " .pad");
        if (pad && signatureInput && signatureInput.val() !== "") {
            pad.jSignature("clear");
            signatureLine.addClass('signature-placeholder');
            signatureInput.val("");
            JotForm.triggerWidgetCondition(field);
        }
    },

    clearField: function (field, subfield, dontTrigger) {

        // eslint-disable-next-line no-var
        var type = JotForm.calculationType(field);

        if (!type) return;

        // eslint-disable-next-line no-var
        var defaultValue = "input_"+field in JotForm.defaultValues ? JotForm.defaultValues["input_"+field] : "";

        if (field.indexOf('|') > -1) {
            // eslint-disable-next-line no-var
            var fieldSplit = field.split('|');
            field = fieldSplit[0];
            if (!subfield) {
                subfield = fieldSplit[1];
            }
        }

        if (type == "file") {
            document.querySelector("#id_" + field).querySelectorAll('ul').forEach(function (element) {
                if(element.getElementsByTagName('li').length > 0) {
                    element.querySelectorAll('span.qq-upload-delete').forEach(function(item) {
                        item.click();
                    });
                }
            });
        }

        if (type == "collapse") {
            document.querySelector("#section_" + field).querySelectorAll(".form-line").forEach(function (el) {
                // eslint-disable-next-line no-var
                var id = el.id.replace("id_", "");
                JotForm.clearField(id);
            });
            return;
        }

        const subfieldElement = subfield instanceof Element ? subfield : document.getElementById(subfield)
        if(type === "matrix" && subfieldElement) {
            subfieldElement.value = "";
            if(!dontTrigger && subfieldElement.triggerEvent) {
                subfieldElement.triggerEvent('keyup');
            }

        } else if(type === "matrix") {

            document.querySelector('#id_' + field).querySelectorAll('input[type="text"], input[type="tel"], input[type="number"]').forEach(function (el) {
                el.value = (el.id in JotForm.defaultValues) ? JotForm.defaultValues[el.id] : "";
            });

            document.querySelector("#id_" + field).querySelectorAll('input[type="radio"], input[type="checkbox"]').forEach(function (input) {
                if (!JotForm.defaultValues[input.id]) {
                    input.checked = false;
                }
            });

            document.querySelector('#id_' + field).querySelectorAll('select').forEach(function (el) {
                if(el.id in JotForm.defaultValues) {
                    el.value = JotForm.defaultValues[el.id];
                } else {
                    el.selectedIndex = 0;
                }
            });


            if(document.querySelector('#id_' + field).querySelectorAll('input, select').length === 0) return;

            // eslint-disable-next-line no-var
            var firstField = document.querySelector('#id_' + field).querySelectorAll('input, select')[0];
            if(firstField && firstField.triggerEvent) {
                if(firstField.nodeName.toLowerCase() === 'input') {
                    if(firstField.type === "checkbox" || firstField.type === "radio") {
                        document.querySelector('#id_' + field).triggerEvent('change');
                    } else {
                        firstField.triggerEvent('keyup');
                    }
                } else {
                    firstField.triggerEvent('change');
                }
            }

        } else if (["address", "combined", "datetime", "time"].includes(type)) {
            if (document.querySelector('#id_' + field).getAttribute('data-type') === 'control_mixed') {
                document.querySelector('#id_' + field).querySelectorAll('.jfField').forEach( function (el) {
                    if (el.getAttribute('data-type') === 'mixed-dropdown') {
                        // eslint-disable-next-line no-var
                        var dropdownID = el.querySelector('select').id;
                        if (el.querySelector('input')) {
                            el.querySelector('input').value = (dropdownID in JotForm.defaultValues) ? JotForm.defaultValues[dropdownID] : "";
                        }
                    }
                })
            } else {
                document.querySelector('#id_' + field).querySelectorAll('input').forEach(function (el) {
                    el.value = (el.id in JotForm.defaultValues) ? JotForm.defaultValues[el.id] : "";
                });
            }

            document.querySelector('#id_' + field).querySelectorAll('select').forEach(function (el) {
                if(el.id in JotForm.defaultValues) {
                    el.value = JotForm.defaultValues[el.id];
                } else {
                    el.selectedIndex = 0;
                }
            });

            // eslint-disable-next-line no-var
            var triggerMe = document.querySelector('#input_' + field) ? document.querySelector('#input_' + field) : document.querySelector('#id_' + field).querySelectorAll('input')[0];
            if (triggerMe && triggerMe.triggerEvent) {
                triggerMe.triggerEvent('keyup');
            }

            if (document.querySelector('#input_' + field + '_full') && document.querySelector('#input_' + field + '_full').getAttribute("data-masked") == "true") {
                JotForm.setQuestionMasking("#input_" + field + "_full", "textMasking", document.querySelector('#input_' + field + '_full').getAttribute("maskValue"));
            }

        } else if (["braintree", "stripe", "paypalpro", "authnet"].includes(type)) {
            document.querySelector('#id_' + field).querySelectorAll('input[type="text"], .form-address-country').forEach(function (el) {
                el.value = (el.id in JotForm.defaultValues) ? JotForm.defaultValues[el.id] : "";
            });
        } else if (type === "html") {
            try {
                document.querySelector('#id_' + field).querySelectorAll(".replaceTag").forEach(function(span) {
                    // eslint-disable-next-line no-var
                    var def = span.getAttribute("default");
                    span.innerHTML = def;
                });
            } catch (e) {
                console.log(e);
            }
        } else if (type === "inline") {
            // eslint-disable-next-line no-var
            var selector = 'input, select';
            if (subfield) {
                // eslint-disable-next-line no-var
                var TIMESTAMP_OF_2019 = 1546300000000;
                // eslint-disable-next-line no-var
                var isNewIDType = Number(subfield) < TIMESTAMP_OF_2019; // old: 1546312345678-firstname / new: firstname-12
                selector = isNewIDType ? 'input[id$="-' + subfield + '"], select[id$="-' + subfield + '"]' : 'input[id*=' + subfield + '-], select[id*=' + subfield + '-]'
            }
            document.querySelector('#id_' + field).querySelectorAll(selector).forEach(function (el) {
                if (['radio', 'checkbox'].indexOf(el.type) > -1) {
                    if (el.id in JotForm.defaultValues) {
                        el.checked = true;
                    } else {
                        el.checked = false;
                    }
                } else {
                    if (el.parentNode.dataset.type === 'signaturebox') {
                        // clear image as well
                        // eslint-disable-next-line no-var
                        var signatureImage = el.parentNode.querySelector('.FITB-sign-image');
                        if (signatureImage) signatureImage.setAttribute('src', '');
                    }
                    // eslint-disable-next-line no-var
                    var newValue = (el.id in JotForm.defaultValues) ? JotForm.defaultValues[el.id] : "";
                    if (el.value !== newValue) {
                        el.value = newValue;
                        el.triggerEvent("change");
                    }
                }
            });
        } else if (type == "textarea") {
            document.querySelector('#input_' + field).value = defaultValue;
            if (document.querySelector('#input_' + field).triggerEvent && !dontTrigger) document.querySelector('#input_' + field).triggerEvent("keyup");
            if (document.querySelector('#input_' + field).showCustomPlaceHolder) {
                document.querySelector('#input_' + field).showCustomPlaceHolder();
            }
            // eslint-disable-next-line no-var
            var richArea = document.querySelector("#id_" + field).querySelector('.nicEdit-main');
            if (richArea) {
                richArea.innerHTML = defaultValue;
                if (document.querySelector('#input_' + field).classList.contains('custom-hint-group') && !document.querySelector('#input_' + field).hasContent) {
                    richArea.style.cssText += '; color: #babbc0';
                }
            }
        } else {
            if (type == "checkbox" || type == "radio") {
                // eslint-disable-next-line no-var
                var dataChanged = false;
                document.querySelector("#id_" + field).querySelectorAll('input[type="radio"], input[type="checkbox"]').forEach(function (input) {
                    // eslint-disable-next-line no-var
                    var currentValue = input.checked;
                    if(input.id in JotForm.defaultValues) {
                        input.checked = true;
                    } else {
                        input.checked = false;
                    }
                    if (!dataChanged && currentValue !== input.checked) dataChanged = true;
                });
                if (document.querySelector('#id_' + field).triggerEvent && !dontTrigger && dataChanged) document.querySelector('#id_' + field).triggerEvent('change');
            } else if (type == "select") {
                if (document.querySelector('#input_' + field)) {
                    if (!JotForm.firstUrlPrefillCondition && !document.querySelector('#input_' + field).value) {
                        document.querySelector('#input_' + field).value = defaultValue;
                    } else if (JotForm.firstUrlPrefillCondition) {
                        document.querySelector('#input_' + field).value = defaultValue;
                        if (document.querySelector('#input_' + field).triggerEvent && !dontTrigger) document.querySelector('#input_' + field).triggerEvent('change');
                    }
                    JotForm.firstUrlPrefillCondition = true;
                } else { //select matrices
                    document.querySelector("#id_" + field).querySelectorAll('select').forEach(function (element) {
                        if (element.getAttribute('data-component') !== 'mixed-dropdown') {
                            element.value = '';
                            if (element.triggerEvent && !dontTrigger) element.triggerEvent('change');
                        }
                    });
                }
            } else if (document.querySelector('#input_' + field)) {
                document.querySelector('#input_' + field).value = defaultValue;
                if (document.querySelector('#input_' + field).triggerEvent && !dontTrigger) {
                    if (type == "widget") {
                        // eslint-disable-next-line no-var
                        var widgetEl = document.querySelector('#input_' + field);
                        // eslint-disable-next-line no-var
                        var widgetClearEvent = document.createEvent('HTMLEvents');
                        widgetClearEvent.initEvent('dataavailable', true, true);
                        widgetClearEvent.eventName = 'widget:clear';
                        widgetClearEvent.memo = {qid: parseInt(widgetEl.id.split('_')[1])}
                        widgetEl.dispatchEvent(widgetClearEvent);

                    } else {
                        document.querySelector('#input_' + field).triggerEvent('keyup');
                    }
                }

                if(defaultValue === "" && document.querySelector('#input_' + field).hintClear) {
                    document.querySelector('#input_' + field).hintClear();
                }
                if (document.querySelector('#input_' + field).getAttribute("data-masked") == "true") {
                    JotForm.setQuestionMasking("#input_" + field, "textMasking", document.querySelector('#input_' + field).getAttribute("maskValue"));
                }
                if (document.querySelector('#input_' + field).classList.contains("form-star-rating") && document.querySelector('#input_' + field).setRating) {
                    document.querySelector('#input_' + field).setRating(0);
                }
                if (type == "email") {
                    // eslint-disable-next-line no-var
                    var parent = document.querySelector('#input_' + field).parentElement;
                    if(window.FORM_MODE == 'cardform' && parent && parent.classList.contains('isFilled')) {
                        parent.classList.remove('isFilled');
                    }
                }
            }
        }
    },

    /**
     * Checks the fieldValue by given operator string
     * @param {Object} operator
     * @param {Object} condValue
     * @param {Object} fieldValue
     */
    checkValueByOperator: function (operator, condValueOrg, fieldValueOrg, termField) {
        try {
            if (typeof condValueOrg == "string" && condValueOrg.indexOf("{") > -1 && condValueOrg.indexOf("}") > -1) { //contains other field reference
                condValueOrg = condValueOrg.replace(/\{.*?\}/gi, function (match) {
                    // eslint-disable-next-line no-var
                    var stripped = match.replace(/[\{\}]/g, "");
                    // eslint-disable-next-line no-var
                    var elements = $$('input[name$="_' + stripped + '"], input[name$="_' + stripped + '[date]"], input[name$="_' + stripped + '[0]"]'); // updated to fetch emoji slider elements

                    elements = Array.from(elements);
                    if (elements.length > 0) {
                        // eslint-disable-next-line no-var
                        var element = elements.first();
                        // fixes value for radio type input elems that are set to another field
                        // eslint-disable-next-line no-var
                        var nonRadioElement = elements.find(function(el) { return el.type !== 'radio'});
                        if (element && !nonRadioElement) {
                            // eslint-disable-next-line no-var
                            var checkedElement = elements.find(function(el) { return el.checked });
                            if (checkedElement) {
                                return checkedElement.value;
                            }
                            return;
                        }
                        if (element && element.value) {
                            return element.value;
                        }
                    }
                    return match;
                });
            }
        } catch (e) {
            console.log(e);

        }

        // eslint-disable-next-line no-var
        var fieldType = JotForm.getInputType(termField);

        // eslint-disable-next-line no-var
        var fieldValue = Object.isBoolean(fieldValueOrg) ? fieldValueOrg : fieldValueOrg.toString().strip().toLowerCase();
        // eslint-disable-next-line no-var
        var condValue = Object.isBoolean(condValueOrg) ? condValueOrg : condValueOrg.toString().strip().toLowerCase();

        if (fieldType === 'appointment') {
            fieldValue = fieldValue ? new Date(fieldValue.replace(/-/g, '/')).getTime() : 0;
            condValue = condValue ? new Date(condValue.replace(/-/g, '/')).getTime() : 0;
        }

        switch (operator) {
            case "equals":
                return fieldType == 'number' ?  parseFloat(fieldValue) == parseFloat(condValue) : fieldValue == condValue;
            case "quantityEquals":
            case "equalDate":
                return fieldValue == condValue;
            case "equalDay":
                return JotForm.getDayOfWeek(fieldValue) == condValueOrg.toLowerCase();
            case "notEquals":
            case "notEqualDate":
            case "quantityNotEquals":
                return fieldValue != condValue;
            case "notEqualDay":
                return JotForm.getDayOfWeek(fieldValue) != condValue;
            case "endsWith":
                return fieldValue.endsWith(condValue);
            case "notEndsWith":
                return !fieldValue.endsWith(condValue);
            case "startsWith":
                return fieldValue.startsWith(condValue);
            case "notStartsWith":
                return !fieldValue.startsWith(condValue);
            case "contains":
                // eslint-disable-next-line no-undef
                condValues = condValue != "," ? condValue.split(",") : condValue.split(" ");
                // eslint-disable-next-line no-undef
                return $A(condValues).any(function (cv) {
                    return fieldValue.include(cv.replace(/^\s+|\s+$/g, ''));
                });
            case "notContains":
                // eslint-disable-next-line no-undef
                condValues = condValue.split(",");
                // eslint-disable-next-line no-undef
                return !$A(condValues).any(function (cv) {
                    return fieldValue.include(cv.replace(/^\s+|\s+$/g, ''));
                });
            case "greaterThan":
            case "quantityGreater":
                return (parseFloat(fieldValue, 10) || 0) > (parseFloat(condValue, 10) || 0);
            case "lessThan":
            case "quantityLess":
                //Emre: if Scale Rating doesn't have value it returns "true" so we need to check wheater its length is greater than 0 (52809)
                //fieldValue is string, not number
                if (fieldValue.length) {
                    return (parseFloat(fieldValue, 10) || 0) < (parseFloat(condValue, 10) || 0);
                } else {
                    return false;
                }
            case "isEmpty":
                if (Object.isBoolean(fieldValue) || !fieldValue.empty) {
                    return !fieldValue;
                }
                return fieldValue.empty();
            case "isFilled":
                if (Object.isBoolean(fieldValue) || !fieldValue.empty) {
                    return fieldValue;
                }
                return !fieldValue.empty();
            case "before":
                return fieldValueOrg < condValueOrg;
            case "after":
                return fieldValueOrg > condValueOrg;
            default:
                JotForm.error("Could not find this operator", operator);
        }
        return false;
    },

    getDayOfWeek: function (date) {
        date = new Date(date);
        // eslint-disable-next-line no-var
        var days = ["sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"];
        return days[date.getDay()];
    },

    typeCache: {},   // Cahcke the check type results for performance
    /**
     *
     * @param {Object} id
     */
    getInputType: function (id) {
        if (JotForm.typeCache[id]) {
            return JotForm.typeCache[id];
        }

        if (typeof id === 'string' && id.indexOf('|') > -1) {
            // eslint-disable-next-line no-var
            var tempField = id.split( '|' );
            if ($('id_' + tempField[0]) && $('id_' + tempField[0]).readAttribute('data-type') == "control_inline") {
                id = tempField[0];
            } else {
                id = tempField[0] + '_field_' + tempField[1];
            }
        }

        // eslint-disable-next-line no-var
        var type = "other";
        if ($('id_' + id) && $('id_' + id).readAttribute('data-type') == "control_text") {
            type = 'html';
        } else if ($('id_' + id) && $('id_' + id).readAttribute('data-type') == "control_inline") {
            type = 'inline';
        } else if ($('input_' + id + '_pick') || ($('id_' + id) && $('id_' + id).readAttribute('data-type') == "control_datetime")) {
          type = 'datetime';
        } else if ($('input_' + id + '_duration')) {
          type = 'appointment';
        } else if ($('input_' + id)) {
            type = $('input_' + id).nodeName.toLowerCase() == 'input' ? $('input_' + id).readAttribute('type').toLowerCase() : $('input_' + id).nodeName.toLowerCase();
            if ($('input_' + id).hasClassName("form-radio-other-input")) {
                type = "radio";
            }

            if ($('input_' + id).hasClassName("js-forMixed")) {
                type = "mixed";
            }

            if ($('input_' + id).hasClassName("form-checkbox-other-input")) {
                type = "checkbox";
            }

            if ($('input_' + id).hasClassName('form-autocomplete')) {
                type = "autocomplete";
            }

            if ($$('#id_' + id + ' .pad').length > 0) {
                type = 'signature';
            }

            if ($('input_' + id).hasClassName('form-slider')) {
                type = 'slider';
            }

            if ($('input_' + id).hasClassName('form-widget')) {
                type = 'widget';
            }

            if ($('input_' + id).hasClassName('form-star-rating')) {
                type = "rating";
            }

        } else if ($('input_' + id + '_month')) {
            type = 'birthdate';
        } else if ($('input_' + id + '_hourSelect')) {
            type = 'time';
        } else if ($("cid_" + id) && $("cid_" + id).getAttribute("data-type") == "control_collapse") {
            return 'collapse';
        } else if ($$('#id_' + id + ' .form-product-item').length > 0) {
            type = $$('#id_' + id + ' .form-product-item')[0].select('input')[0].readAttribute('type').toLowerCase();
        } else if ($$('#id_' + id + ' .product--subscription').length > 0) {
            type = $$('#id_' + id + ' .product--subscription')[0].select('input')[0].readAttribute('type').toLowerCase();
        } else if ($$('#id_' + id + ' .form-address-table').length > 0) {
            type = 'address';
        } else if ($$('input[id^=input_' + id + '_]')[0] && $$('input[id^=input_' + id + '_]')[0].hasClassName('form-grading-input')) {
            type = 'grading';
        } else if ($('id_' + id) && $('id_' + id).getAttribute('data-type') == 'control_mixed') {
            type = 'mixed';
        } else {
            if ($$('#id_' + id + ' input')[0]) {
                type = $$('#id_' + id + ' input')[0].readAttribute('type').toLowerCase();
                if (type == "text" || type == 'tel' || type === 'number') {
                    type = "combined";
                }
                // eslint-disable-next-line no-var
                var matrixInputs = $$('#id_' + id + ' input,' + '#id_' + id + ' select');
                if (!matrixInputs.every(function (input) { return input.type === matrixInputs[0].type })) {
                    // Multi-type matrix
                    type = "combined";
                }
            } else if ($$('#id_' + id + ' select')[0]) {
                type = "select"; //select matrices
            }
        }

        JotForm.typeCache[id] = type;
        return type;
    },
    /**
     * Parses ISO Date string to a real date
     * @param {Object} str
     */
    strToDate: function (str) {
        // When cannot parse return an invalid date
        // eslint-disable-next-line no-var
        var invalid = new Date(undefined);
        // eslint-disable-next-line no-var
        var match = /(\d{4})\-(\d{2})-(\d{2})T?(\d{2})?\:?(\d{2})?/gim;

        if (str.empty()) {
            return invalid;
        }

        // if(!str.include("T")){ str += "T00:00"; }

        if (!match.test(str)) {
            return invalid;
        }

        // eslint-disable-next-line no-var
        var d = new Date();
        str.replace(match, function (all, year, month, day, hour, minutes) {
            if (hour) {
                d = new Date(parseInt(year, 10), parseInt(month, 10) - 1, parseInt(day, 10), parseInt(hour, 10), parseInt(minutes, 10));
            } else {
                d = new Date(parseInt(year, 10), parseInt(month, 10) - 1, parseInt(day, 10));
            }
            return all;
        });

        return d;
    },

    getBirthDate: function (id) {
        // eslint-disable-next-line no-var
        var day = document.querySelector('#input_' + id + '_day').value || "%empty%";
        // eslint-disable-next-line no-var
        var month = document.querySelector('#input_' + id + '_month').selectedIndex || "%empty%";
        month = String(month);
        // eslint-disable-next-line no-var
        var year = document.querySelector('#input_' + id + '_year').value || "%empty%";
        // eslint-disable-next-line no-var
        var date = year + "-" + (month.length == 1 ? '0' + month : month) + "-" + (day.length == 1 ? '0' + day : day);
        if (date.includes("%empty%")) return "";
        return date;
    },

    get24HourTime: function (id) {
        // eslint-disable-next-line no-var
        var hour = document.querySelector('#input_' + id + '_hourSelect').value;
        if (hour == "") return "";
        // eslint-disable-next-line no-var
        var minute = document.querySelector('#input_' + id + '_minuteSelect').value;
        if (minute.length == 0) minute = "00";
        // eslint-disable-next-line no-var
        var ampm = (document.querySelector('#input_' + id + '_ampm')) ? document.querySelector('#input_' + id + '_ampm').value : '';
        hour = Number(hour);
        if (ampm == 'PM' && hour != 12) {
            hour += 12;
        } else if (ampm == 'AM' && hour == 12) {
            hour = 0;
        }
        hour = (hour < 10) ? "0" + hour : String(hour);
        return hour + minute;
    },

    getDateValue: function (id) {
        let date = "";
        const yearElement = document.querySelector(`#year_${id}`)
        if (yearElement) {
            date += (yearElement.value || "%empty%");
        }
        const monthElement = document.querySelector(`#month_${id}`)
        if (monthElement) {
            const mm = monthElement.value ? (monthElement.value.length > 1 ? monthElement.value : "0" + monthElement.value) : "%empty%";
            date += "-" + mm;
        }
        const dayElement = document.querySelector(`#day_${id}`)
        if (dayElement) {
            const dd = dayElement.value ? (dayElement.value.length > 1 ? dayElement.value : "0" + dayElement.value) : "%empty%";
            date += "-" + dd;
        }

        if (date.includes("%empty%")) {
            JotForm.info("Wrong date: " + date);
            return "";
        }
        let h = "";
        const hourElement = document.querySelector(`#input_${id}_hourSelect`)
        const ampmElement = document.querySelector(`#input_${id}_ampm`)
        if (ampmElement) {
            if (hourElement) {
                h = hourElement.value;
                if (ampmElement.value == 'pm') {
                    h = parseInt(h, 10) + 12;
                }
                if (h == "24") {
                    h = 0;
                }
                date += "T" + ((h.length == 1 ? "0" + h : h) || "00");
            }
        } else {
            if (hourElement) {
                h = hourElement.value;
                date += "T" + ((h.length == 1 ? "0" + h : h) || "00");
            }
        }
        const minElement = document.querySelector(`#input_${id}_minuteSelect`);
        if (minElement) {
            date += ":" + (minElement.value || "00");
        }
        if (h === "") {
            date += "T00:00";
        }
        return date;
    },
    hidePages: {},
    skippedPages: {},

    getAdditionalRequiredValidationArray: function (action, qIdForMultiple) {
        if(!action.additionalRequireTypes) return;
        // eslint-disable-next-line no-var
        var values = [];

        if(qIdForMultiple) {
            Object.keys(action.additionalRequireTypes).forEach(function(qKey) {
                // eslint-disable-next-line no-var
                var qidFromQKey = typeof qKey === 'string' && qKey.split('-').length >= 2 && qKey.split('-')[1]
                if(qIdForMultiple === qidFromQKey) {
                    Object.keys(action.additionalRequireTypes[qKey]).forEach(function(val) {
                        values.push(action.additionalRequireTypes[qKey][val]);
                    });
                }
            });
        }else {
            Object.keys(action.additionalRequireTypes).forEach(function(qKey) {
                Object.keys(action.additionalRequireTypes[qKey]).forEach(function(val) {
                    values.push(action.additionalRequireTypes[qKey][val]);
                });
            });
        }
        return values;
    },

    getFieldFromID: function (questionID) {
        return document.querySelector('.form-line#id_' + questionID);
    },

    getMatrixValues: function(questionID, operator) {
        const matrix = document.getElementById("matrix_" + questionID);
        const desktopVersion = matrix.querySelector('.forDesktop');
        const mobileVersion = matrix.querySelector('.forMobile');
        const dataType = matrix.getAttribute('data-type');
        let currentVersion = 'desktop';
        if (desktopVersion && mobileVersion && document.defaultView.getComputedStyle(desktopVersion,null).display === 'none') {
            currentVersion = 'mobile';
        }
        const checkedValues = function (value) {
            const yesNoID = value.id;
            const yesNoValue = Array.from(document.querySelectorAll('label[for="' + yesNoID + '"]'));
            const yesNoValueText = yesNoValue.length > 0 ? yesNoValue[0].innerText : value.checked;
            return value.checked ? yesNoValueText : value.checked;
        }
        switch(true) {
            case dataType === 'Yes No' && (operator == 'contains' || operator == 'notContains'):
                let selector = "";
                if (desktopVersion && currentVersion === 'desktop') {
                    selector = '#id_' + questionID + ' input:not([disabled]):not([class*="jsMatrix-mobileNo"]:not([class*="jsMatrix-mobileYes"])';
                }
                if (mobileVersion && currentVersion === 'mobile') {
                    selector = '#id_' + questionID + ' input:not([disabled])[class*="jsMatrix-mobileNo"],[class*="jsMatrix-mobileYes"]';
                }
                return Array.from(document.querySelectorAll(selector)).map(function(value) {
                    return checkedValues(value);
                });
        }
    },

    addEventToDebug: function (data) {
      if (!Object.keys(data).length || JotForm && JotForm.conditionCalculationDebugEnabledServers.indexOf(JotForm.enterprise) === -1) {
        return;
      }
      JotForm.conditionCalculationDebugLogs.push(data);
    },
    /**
     *
     * @param {Object} condition
     */
    checkCondition: function (condition, sourceField, sourceEvent) {
        if (condition.__disabledByDebugger) { return; }
        JotForm.addEventToDebug({ conditionID: condition.id, sourceField, sourceEvent });

        // eslint-disable-next-line no-var
        var any = false, all = true;
        // eslint-disable-next-line no-var
        var filled;

        if(condition.link === undefined) {
            condition.link = 'Any';
        }

        $A(condition.terms).each(function (term) {
            // eslint-disable-next-line no-var
            var value;
            // eslint-disable-next-line no-var
            var anotherField = JotForm.getFieldIdFromFieldRef(term.value);
            term.field = String(term.field);
            try {
                // eslint-disable-next-line no-var
                var fieldType = JotForm.getInputType(term.field);
                switch (fieldType) {
                    case "combined":
                        if (['isEmpty', 'isFilled'].include(term.operator)) {
                            filled = $$('#id_' + term.field + ' input,' + '#id_' + term.field + ' select')
                                .filter(e => e.getAttribute('type') !== 'hidden')
                                .collect(function (e) {
                                    return e.getAttribute('type') === 'checkbox' || e.getAttribute('type') === 'radio' ? (e.checked ? e.value : '') : e.value;
                            }).any();

                            if (JotForm.checkValueByOperator(term.operator, term.value, filled)) {
                                any = true;
                            } else {
                                all = false;
                            }

                            return;
                            /* continue; */
                        } else {
                            //for matrices
                            value = $$('#id_' + term.field + ' input,' + '#id_' + term.field + ' select').collect(function (e) {
                                return e.getAttribute('type') === 'checkbox' || e.getAttribute('type') === 'radio' ? (e.checked ? e.value : '') : e.value;
                            });
                            if (JotForm.checkValueByOperator(term.operator, term.value, value)) {
                                any = true;
                            } else {
                                all = false;
                            }
                        }
                        break;
                    case "address":
                        if (['isEmpty', 'isFilled'].include(term.operator)) {
                            filled = $$('#id_' + term.field + ' input:not(.jfDropdown-search)', '#id_' + term.field + ' select').collect(function (e) {
                                return e.value;
                            }).any();
                            if (JotForm.checkValueByOperator(term.operator, term.value, filled)) {
                                any = true;
                            } else {
                                all = false;
                            }
                        } else if(term.operator == "equalCountry" || term.operator == 'notEqualCountry') {
                            // eslint-disable-next-line no-var
                            var option;
                            // eslint-disable-next-line no-var
                            var termValue = term.value;

                            if (anotherField) {
                                termValue = $('input_'+anotherField+'_country').value;
                            }

                            $('input_' + term.field + '_country').select("option").each(function(opt) {
                                if(termValue === opt.value) {
                                    option = opt;
                                    throw $break;
                                }
                            });

                            if(option) {
                                if (term.operator == 'equalCountry') {
                                    if (option.selected) {
                                        any = true;
                                    } else {
                                        all = false;
                                    }
                                } else if (term.operator == 'notEqualCountry') {
                                    if (!option.selected) {
                                        any = true;
                                    } else {
                                        all = false;
                                    }
                                }
                            }
                        } else {
                            // eslint-disable-next-line no-var
                            var inputValue;
                            // eslint-disable-next-line no-var
                            var termValue = term.value;
                            if (anotherField) {
                                termValue = $('input_'+anotherField+'_state').value;
                            }
                            inputValue = $('input_' + term.field + '_state').value
                            if(inputValue) {
                                if (term.operator == 'equalState') {
                                    if (inputValue == termValue) {
                                        any = true;
                                    } else {
                                        all = false;
                                    }
                                } else if (term.operator == 'notEqualState') {
                                    if (!(inputValue == termValue)) {
                                        any = true;
                                    } else {
                                        all = false;
                                    }
                                }
                            }
                        }
                        break;
                    case "birthdate":
                    case "datetime":
                        value = (fieldType == "datetime") ? JotForm.getDateValue(term.field) : JotForm.getBirthDate(term.field);
                        if (value === undefined) {
                            return;
                            /* continue; */
                        }

                        if (['isEmpty', 'isFilled'].include(term.operator)) {
                            if (JotForm.checkValueByOperator(term.operator, term.value, value)) {
                                any = true;
                            } else {
                                all = false;
                            }

                        } else {
                            // eslint-disable-next-line no-var
                            var termValue = term.value;
                            termValue = term.value.toLowerCase().replace(/\s/g,"");
                            if (termValue.indexOf('today') > -1) {
                                // eslint-disable-next-line no-var
                                var offset = parseInt(termValue.split('today')[1]) || 0;
                                // eslint-disable-next-line no-var
                                var comparativeDate = new Date();
                                comparativeDate.setDate(comparativeDate.getDate() + offset);
                                // eslint-disable-next-line no-var
                                var year = comparativeDate.getFullYear();
                                // eslint-disable-next-line no-var
                                var month = comparativeDate.getMonth() + 1;
                                month = (month < 10) ? '0' + month : month;
                                // eslint-disable-next-line no-var
                                var day = comparativeDate.getDate();
                                day = (day < 10) ? '0' + day : day;
                                termValue = year + "-" + month + "-" + day;
                            } else if(anotherField) {
                                // eslint-disable-next-line no-var
                                var year = $("year_"+anotherField).value;
                                // eslint-disable-next-line no-var
                                var month = $("month_"+anotherField).value;
                                // eslint-disable-next-line no-var
                                var day = $("day_"+anotherField).value;

                                if(term.operator === "equalDay" || term.operator === "notEqualDay") {
                                    termValue = JotForm.getDayOfWeek(JotForm.strToDate(year+"-"+month+"-"+day));
                                } else {
                                    termValue = JotForm.getDateValue(anotherField);
                                }

                            }

                            if (['equalDate', 'notEqualDate', 'before', 'after'].include(term.operator)) {
                                if (JotForm.checkValueByOperator(term.operator, JotForm.strToDate(termValue), JotForm.strToDate(value))) {
                                    any = true;
                                } else {
                                    all = false;
                                }
                            } else if (['equalDay', 'notEqualDay'].include(term.operator)) {
                                if (JotForm.checkValueByOperator(term.operator, termValue, JotForm.strToDate(value))) {
                                    any = true;
                                } else {
                                    all = false;
                                }
                            } else {
                                if (JotForm.checkValueByOperator(term.operator, JotForm.strToDate(termValue), JotForm.strToDate(value))) {
                                    any = true;
                                } else {
                                    all = false;
                                }
                            }
                        }
                        break;
                    case "time":
                        value = JotForm.get24HourTime(term.field);
                        // eslint-disable-next-line no-var
                        var termValue = (!term.value) ? "" : term.value.replace(/:/, "");
                        if(anotherField) {
                            termValue = JotForm.get24HourTime(anotherField);
                        }

                        if (termValue.length == 3) termValue = "0" + termValue;
                        if (term.operator == 'before' && value.empty()) {
                            all = false;
                        } else {
                            if (JotForm.checkValueByOperator(term.operator, termValue, value))
                                any = true;
                            else
                                all = false;
                        }
                        break;
                    case "checkbox":
                    case "radio":
                        if (['isEmpty', 'isFilled'].include(term.operator)) {
                            filled = $$('#id_' + term.field + ' input').collect(function (e) {
                                return e.checked;
                            }).any();

                            if (JotForm.checkValueByOperator(term.operator, term.value, filled)) {
                                any = true;
                            } else {
                                all = false;
                            }

                            return;
                            /* continue; */
                        }
                        if (term.value) term.value = term.value.replace(/&amp;/g, '&').replace(/&gt;/g, '>').replace(/&lt;/g, '<');

                        if (['lessThan', 'greaterThan'].include(term.operator)) {
                            // eslint-disable-next-line no-var
                            var localResult = false;
                            $$('#id_' + term.field + ' input').each(function (input) {
                                value = input.checked ? input.value : '';
                                if (JotForm.checkValueByOperator(term.operator, term.value, value)) {
                                    any = true;
                                    localResult = true;
                                }
                            });
                            if (!localResult) all = false;
                            return;
                        }

                        // eslint-disable-next-line no-var
                        var otherValue = $('id_' + term.field).down(".form-"+fieldType+"-other-input") ? $('id_' + term.field).down(".form-"+fieldType+"-other-input").getAttribute('data-otherhint').replace(/&amp;/g, '&').replace(/&gt;/g, '>').replace(/&lt;/g, '<') : "";

                        $$('#id_' + term.field + ' input').each(function (input) {
                            if (input.hasClassName('form-' + fieldType + '-other') && input.checked) {
                                value = '-- '+otherValue+' --';
                            } else {
                                value = input.checked ? input.value : '';
                                value = value.replace(/_expanded/, '');
                            }

                            // eslint-disable-next-line no-var
                            var termValue = term.value.strip();
                            // eslint-disable-next-line no-var
                            var checkResult = JotForm.checkValueByOperator(term.operator, termValue, value);

                            if (term.operator == 'notEquals') {
                                checkResult = $$('#id_' + term.field + ' input').filter(function(value) {
                                    return value.checked;
                                }).map(function(checkedValue){
                                    return JotForm.checkValueByOperator(term.operator, termValue, checkedValue.value);
                                }).every(function(value) {
                                    return value;
                                });
                            }

                            if (document.getElementById("matrix_" + term.field)){
                                // eslint-disable-next-line no-var
                                var checkedValue = JotForm.getMatrixValues(term.field, term.operator);
                                if (checkedValue) {
                                    checkResult = JotForm.checkValueByOperator(term.operator, termValue, checkedValue);
                                }
                            }

                            if (checkResult) {
                                any = true;
                            } else {
                                if (term.operator == 'notEquals' && termValue == value) {
                                    // If not equals item is found 'all' condition should fail
                                    all = false;
                                    // If condition is interested in 'all', then we can break each loop
                                    if(condition.link.toLowerCase() == 'all') {
                                        throw $break;
                                    }
                                } else if (input.value == termValue || (input.hasClassName('form-' + fieldType + '-other') && termValue == '-- '+otherValue+' --') || input.value.replace(/_expanded/, '') == termValue) {
                                    all = false;
                                }
                            }
                        });
                        break;
                    case "select":

                        if (term.value) {
                          term.value = term.value.replace(/&amp;/g, '&');
                        }

                        // eslint-disable-next-line no-var
                        var tempInput = '';
                        if (term.field.indexOf('|') > -1) {
                          // eslint-disable-next-line no-var
                          var tempSplit = term.field.split( '|' );
                          tempInput = 'input_' + tempSplit[0] + '_field_' + tempSplit[1];
                        } else {
                          tempInput = 'input_' + term.field;
                        }

                        if ($(tempInput) && $(tempInput).multiple) {
                            if (term.operator == 'equals') {
                                // eslint-disable-next-line no-var
                                var option = $(tempInput).querySelector('option[value="' + (term.value || '').replace(/["\\]/g, '\\$&') + '"]');
                                if (option && option.selected) {
                                    any = true;
                                } else {
                                    all = false;
                                }
                            } else if (term.operator == 'notEquals') {
                                // eslint-disable-next-line no-var
                                var option = $(tempInput).querySelector('option[value="' + (term.value || '').replace(/["\\]/g, '\\$&') + '"]');
                                if (option && !option.selected) {
                                    any = true;
                                } else {
                                    all = false;
                                }
                            } else if (['isEmpty', 'isFilled'].include(term.operator)) {
                                // eslint-disable-next-line no-var
                                var selected = false;
                                // eslint-disable-next-line no-var
                                var arr = $(tempInput).options;
                                // eslint-disable-next-line no-var
                                for (var i = 0; i < arr.length; i++) {
                                    if (!arr[i].value.empty() && arr[i].selected == true) {
                                        selected = true;
                                    }
                                }
                                if (term.operator == 'isEmpty') {
                                    if (!selected) any = true;
                                    else all = false;
                                }
                                if (term.operator == 'isFilled') {
                                    if (selected) any = true;
                                    else all = false;
                                }
                            }
                        } else if ($(tempInput)) {
                            value = $(tempInput).value;
                            if (value === undefined) {
                                return;
                                /* continue; */
                            }
                            if (JotForm.checkValueByOperator(term.operator, term.value, value)) {
                                any = true;
                            } else {
                                all = false;
                            }
                        } else if (['isEmpty', 'isFilled'].include(term.operator)) {
                            filled = $$('#id_' + term.field + ' select').collect(function (e) {
                                return e.value;
                            }).any();
                            if (JotForm.checkValueByOperator(term.operator, term.value, filled)) {
                                any = true;
                            } else {
                                all = false;
                            }
                        } else {
                            value = $$('#id_' + term.field + ' select').collect(function (e) {
                                return e.value;
                            });
                            if (JotForm.checkValueByOperator(term.operator, term.value, value)) {
                                any = true;
                            } else {
                                all = false;
                            }
                        }
                        break;
                    case "grading":
                        if (['isEmpty', 'isFilled'].include(term.operator)) {
                            filled = $$('input[id^=input_' + term.field + '_]').collect(function (e) {
                                return e.value;
                            }).any();
                            if (JotForm.checkValueByOperator(term.operator, term.value, filled)) {
                                any = true;
                            } else {
                                all = false;
                            }
                        } else {
                            value = $('grade_point_' + term.field).innerHTML.stripTags();
                            if (JotForm.checkValueByOperator(term.operator, term.value, value)) {
                                any = true;
                            } else {
                                all = false;
                            }
                        }
                        break;
                    case "file":
                        if ($('id_' + term.field).select('.qq-uploader').length > 0) {
                            value = $('id_' + term.field).select('.qq-upload-file').length > 0;
                        } else {
                            if ($('input_' + term.field).uploadMarked) {
                                value = $('input_' + term.field).uploadMarked;
                            } else {
                                value = $('input_' + term.field).value;
                            }
                        }

                        if (value === undefined) {
                            return;
                            /* continue; */
                        }
                        if (JotForm.checkValueByOperator(term.operator, term.value, value, term.field)) {
                            any = true;
                        } else {
                            all = false;
                        }
                        break;

                    case "textarea":
                        value = $('input_' + term.field).value;
                        if ($('input_' + term.field).hinted || $('input_' + term.field).hasClassName('form-custom-hint')) {
                            value = "";
                        }
                        if (value === undefined) {
                            return;
                            /* continue; */
                        }
                        // eslint-disable-next-line no-var
                        var rich = $('id_' + term.field).down('.nicEdit-main');
                        if (rich) {
                            value = value.stripTags().replace(/\s/g, ' ').replace(/&nbsp;/g, ' ');
                        }

                        if (JotForm.checkValueByOperator(term.operator, term.value, value, term.field)) {
                            any = true;
                        } else {
                            all = false;
                        }
                        break;

                    case "widget":
                        value = $('input_' + term.field).value;
                        // eslint-disable-next-line no-var
                        var termField = term.field;

                        // eslint-disable-next-line no-var
                        var widgetType = JotForm.getWidgetType(term.field);
                        if (value === undefined) {
                            return;
                        }
                        if (widgetType && widgetType === 'checklist') {
                            // eslint-disable-next-line no-var
                            var checked = JotForm.getChecklistWidgetValues(term.field).checked;
                            termField = checked.indexOf(term.value) !== -1;
                            value = checked.find(function(value) { return value === term.value;}) || '';
                            if (term.operator === 'isFilled' || term.operator === 'isEmpty') {
                                value = checked.join(',');
                            }

                        }
                        if (widgetType && ( widgetType == 'inventory' || widgetType == 'inventoryV2') && value) {
                            // eslint-disable-next-line no-var
                            var valArr = value.split('\n');
                            if (Array.isArray(valArr)) {
                                value = valArr[0];
                                if (isNaN(valArr[0])) {
                                    value = valArr[0].match(/ \[(\d+)\]$/)[1];
                                }
                            }
                        }
                        if (value.indexOf("widget_metadata") > -1) { //object not simple
                            try {
                                value = JSON.parse(value).widget_metadata.value;
                                // eslint-disable-next-line no-var
                                var matchingItem = false;
                                // eslint-disable-next-line no-var
                                for (var i = 0; i < value.length; i++) {
                                    // eslint-disable-next-line no-var
                                    var obj = value[i];
                                    // eslint-disable-next-line no-var
                                    for (var item in obj) {
                                        if (JotForm.checkValueByOperator(term.operator, term.value, obj[item], termField)) {
                                            any = true;
                                            matchingItem = true;
                                        }
                                    }
                                }
                                if (!matchingItem) all = false;
                            } catch (e) {
                                console.log(e);
                            }

                        } else {

                            value = (term.operator === "greaterThan" || term.operator === "lessThan") && typeof value === "string" ? value.replace(/,/g, '') : value;

                            if (JotForm.checkValueByOperator(term.operator, term.value, value, termField)) {
                                any = true;
                            } else {
                                all = false;
                            }
                        }

                        break;

                    case "hidden":
                        if($('input_' + term.field + "_donation")) {
                            value = $('input_' + term.field + "_donation").value;
                        } else {
                            value = $('input_' + term.field).value;
                        }
                        if (JotForm.checkValueByOperator(term.operator, term.value, value, term.field)) {
                            any = true;
                        } else {
                            all = false;
                        }
                        break;

                    case "rating":
                        value = $('input_' + term.field).value || '';
                        if (JotForm.checkValueByOperator(term.operator, term.value, value, term.field)) {
                            any = true;
                        } else {
                            all = false;
                        }
                        break;
                    case "inline":
                        // eslint-disable-next-line no-var
                        var selector = '';
                        if (term.field.indexOf('|') > -1) {
                            // eslint-disable-next-line no-var
                            var tempSplit = term.field.split( '|' );
                            // eslint-disable-next-line no-var
                            var questionId = tempSplit[0];
                            // eslint-disable-next-line no-var
                            var fieldId = tempSplit[1];
                            // eslint-disable-next-line no-var
                            var TIMESTAMP_OF_2019 = 1546300000000;
                            // eslint-disable-next-line no-var
                            var isNewIDType = Number(fieldId) > TIMESTAMP_OF_2019; // old: 1546312345678-firstname / new: firstname-12
                            // eslint-disable-next-line no-var
                            var selector = isNewIDType ? '[id*=' + fieldId + '-]' : '[id$=-' + fieldId + ']';
                            selector = '#id_' + questionId + ' input' + selector + ', #id_' + questionId + ' select' + selector;
                        } else {
                            return;
                        }
                        // eslint-disable-next-line no-var
                        var inputs = $$(selector);
                        if (inputs.length === 0) {
                            return;
                        }
                        value = inputs.collect(function(e) {
                            return ['checkbox', 'radio'].indexOf(e.getAttribute('type')) > -1 ? (e.checked ? e.value : '') : e.value;
                        }).filter(function(val) {return val;}).join(' ');
                        if (JotForm.checkValueByOperator(term.operator, term.value, value, term.field)) {
                            any = true;
                        } else {
                            all = false;
                        }
                        break;
                    case "appointment":
                        value = JotForm.appointments[term.field].getComparableValue();
                        if (JotForm.checkValueByOperator(term.operator, term.value, value, term.field)) {
                            any = true;
                        } else {
                            all = false;
                        }
                        break;
                    default:
                        // eslint-disable-next-line no-var
                        var tempInput = '';

                        if (term.field.indexOf('|') > -1) {
                          // eslint-disable-next-line no-var
                          var tempSplit = term.field.split( '|' );
                          tempInput = 'input_' + tempSplit[0] + '_field_' + tempSplit[1];
                        } else {
                          tempInput = 'input_' + term.field;
                        }
                        if(!$(tempInput)) {
                            return;
                        }

                        if ($(tempInput) && $(tempInput).multiple) {
                            if (term.operator == 'equals') {
                                // eslint-disable-next-line no-var
                                var option = $(tempInput).select('option[value=' + term.value + ']');
                                if (option.length > 0 && option[0].selected) {
                                    any = true;
                                } else {
                                    all = false;
                                }
                            } else if (term.operator == 'notEquals') {
                                // eslint-disable-next-line no-var
                                var option = $(tempInput).select('option[value=' + term.value + ']');
                                if (option.length > 0 && !option[0].selected) {
                                    any = true;
                                } else {
                                    all = false;
                                }
                            } else if (['isEmpty', 'isFilled'].include(term.operator)) {
                                // eslint-disable-next-line no-var
                                var selected = false;
                                // eslint-disable-next-line no-var
                                var arr = $(tempInput).options;
                                // eslint-disable-next-line no-var
                                for (var i = 0; i < arr.length; i++) {
                                    if (!arr[i].value.empty() && arr[i].selected == true) {
                                        selected = true;
                                    }
                                }
                                if (term.operator == 'isEmpty') {
                                    if (!selected) any = true;
                                    else all = false;
                                }
                                if (term.operator == 'isFilled') {
                                    if (selected) any = true;
                                    else all = false;
                                }
                            }
                        } else if ($(tempInput)) {
                            value = $(tempInput).value;
                            if (value === undefined) {
                                return;
                                /* continue; */
                            }
                            if (JotForm.checkValueByOperator(term.operator, term.value, value, term.field)) {
                                any = true;
                            } else {
                                all = false;
                            }
                        } else if (['isEmpty', 'isFilled'].include(term.operator)) {
                            filled = $$('#id_' + term.field + ' select').collect(function (e) {
                                return e.value;
                            }).any();
                            if (JotForm.checkValueByOperator(term.operator, term.value, filled, term.field)) {
                                any = true;
                            } else {
                                all = false;
                            }
                        } else {
                            value = $$('#id_' + term.field + ' select').collect(function (e) {
                                return e.value;
                            });
                            if (JotForm.checkValueByOperator(term.operator, term.value, value, term.field)) {
                                any = true;
                            } else {
                                all = false;
                            }
                        }
                }

            } catch (e) {
                JotForm.error(e);
            }
        });

        // eslint-disable-next-line no-var
        var conditionInfiniteLoop = function () {
            // prevent calculation&condition infinite loop by limiting the nuber of times
            // a calculation can be run on an element in a 500ms period

            // Those who are curious about the numbers in this function.
            // ALL ARE MAGICAL !!!
            // SORRY FOR SHITTING ANOTHER ONE :)
            // I HOPE I REFACTOR ANOTHER TIME
            // eslint-disable-next-line no-var
            var timestamp = new Date().getTime();
            // eslint-disable-next-line no-var
            var msPart = timestamp % 1000;
            if (msPart < 500) {
                msPart = "0";
            } else {
                msPart = "1";
            }
            // eslint-disable-next-line no-var
            var secPart = parseInt(timestamp / 1000);
            // eslint-disable-next-line no-var
            var antiLoopKey = condition.id + '-' + secPart + '-' + msPart;
            // eslint-disable-next-line no-var
            var conditionBasedMaxLoop = (Array.isArray(JotForm.conditions) && (19 * ((JotForm.conditions.length / 100) + 1))) || 19;
            // eslint-disable-next-line no-var
            var limitedMaxLoop = conditionBasedMaxLoop > 100 ? 100 : conditionBasedMaxLoop;
            // eslint-disable-next-line no-var
            var maxLoopSize = JotForm.clearFieldOnHide == "enable" ? 3 : limitedMaxLoop;

            window.lastConditionTimeStamp = window.lastConditionTimeStamp || new Date().getTime();
            // eslint-disable-next-line no-var
            var betweenLookUp = (timestamp - window.lastConditionTimeStamp) / 1000;
            if (betweenLookUp > 10) {
                window.__antiConditionLoopCache = {};
                window.lastConditionTimeStamp = null;
            }
            //create global antiLoop variable if not created yet
              if (!("__antiConditionLoopCache" in window)) {
                  window.__antiConditionLoopCache = {};
              }
            if (antiLoopKey in window.__antiConditionLoopCache) {
                window.__antiConditionLoopCache[antiLoopKey]++;
                if (window.__antiConditionLoopCache[antiLoopKey] > maxLoopSize) {
                    return true; //only allow same calc to trigger nine times in half a secondmultiple are needed for things like sliders that change quickly
                }
            } else {
                window.__antiConditionLoopCache[antiLoopKey] = 1;
            }

            return false;
        }

        const ignoreFields = ['time', 'datetime', 'text', 'mixed'];
        const operands = (condition.action && condition.action[0] && condition.action[0].operands && condition.action[0].operands.split(',')) || [];
        const baseFieldsForLoop = (condition.action && condition.action[0] && condition.action[0].baseField && condition.action[0].baseField.split(',')) || [];
        const ignoreFieldConditionLoopCheck = Boolean(([...baseFieldsForLoop, ...operands]).find(conditionFieldForLoop => ignoreFields.includes(JotForm.getInputType(conditionFieldForLoop))));
        const checkConditionInfiniteLoop = condition.type === 'calculation' ? (this.loopMapExist || ignoreFieldConditionLoopCheck) : true;
        if (checkConditionInfiniteLoop && conditionInfiniteLoop()) {
            if (JotForm.isConditionDebugMode) {
                // eslint-disable-next-line no-var
                var index = JotForm.conditions.findIndex(val => val === condition);
                if(typeof __conditionDebugger_logStatus === 'function') {
                    // eslint-disable-next-line no-undef
                    __conditionDebugger_logStatus([{
                        title: 'Loop Detected In',
                        value: `Condition - ${index}`
                    }]);
                }
                console.log({ condition: condition, sourceField: sourceField, index }, 'IN CHECK CONDITION');
            }
            return;
        }


        if (condition.type == 'field') { // Field Condition
            // JotForm.log("any: %s, all: %s, link: %s", any, all, condition.link.toLowerCase());
            // eslint-disable-next-line no-var
            var isConditionValid = (condition.link.toLowerCase() == 'any' && any) || (condition.link.toLowerCase() == 'all' && all);
            if (condition.disabled == true) return;

            condition.action.each(function (action) {
                // eslint-disable-next-line no-var
                var matchingTermAction = condition.terms.any(function (term) {
                    return term.field == action.field;
                });

                if (isConditionValid) {
                    action.currentlyTrue = true;
                    if (action.visibility.toLowerCase() == 'show') {
                        JotForm.showField(action.field);
                    } else if (action.visibility.toLowerCase() == 'hide') {
                        JotForm.hideField(action.field, false, matchingTermAction);
                    } else if (action.visibility.toLowerCase() == 'showmultiple' && action.fields) {
                        if (JotForm.showOrHideMultipleFields) {
                            JotForm.showOrHideMultipleFields(true, action.fields, true);
                        } else {
                            action.fields.each(function (field) {
                                JotForm.showField(field, true);
                            });
                        }
                    } else if (action.visibility.toLowerCase() == 'hidemultiple' && action.fields) {
                        if (JotForm.showOrHideMultipleFields) {
                            JotForm.showOrHideMultipleFields(false, action.fields, true, matchingTermAction);
                        } else {
                            action.fields.each(function (field) {
                                JotForm.hideField(field, true, matchingTermAction);
                            });
                        }
                    }
                } else {
                    action.currentlyTrue = false;
                    if (action.visibility.toLowerCase() == 'show') {
                        JotForm.hideField(action.field, false, matchingTermAction);
                    } else if (action.visibility.toLowerCase() == 'hide') {
                        JotForm.showField(action.field, false);
                    } else if (action.visibility.toLowerCase() == 'showmultiple' && action.fields) {
                        if (JotForm.showOrHideMultipleFields) {
                            JotForm.showOrHideMultipleFields(false, action.fields, true, matchingTermAction);
                        } else {
                            action.fields.each(function (field) {
                                JotForm.hideField(field, true, matchingTermAction);
                            });
                        }
                    } else if (action.visibility.toLowerCase() == 'hidemultiple' && action.fields) {
                        if (JotForm.showOrHideMultipleFields) {
                            JotForm.showOrHideMultipleFields(true, action.fields, true);
                        } else {
                            action.fields.each(function (field) {
                                JotForm.showField(field, true);
                            });
                        }
                    }
                }

                if (window.FORM_MODE !== 'cardform') JotForm.iframeHeightCaller();
                if ($('section_' + action.field) || 'fields' in action) {
                    if (JotForm.clearFieldOnHide === 'enable') {
                        JotForm.runAllCalculations(true);
                    }
                }

                if ($('input_' + action.field) && $('input_' + action.field).triggerEvent) {
                    if (!matchingTermAction && $('input_' + action.field).className.indexOf("-other-") < 0) {
                        $('input_' + action.field).triggerEvent('keyup'); //trigger calculations when hiding/showing
                    }
                }

            });
        } else if (condition.type == 'require') {
            // eslint-disable-next-line no-var
            var isConditionValid = (condition.link.toLowerCase() == 'any' && any) || (condition.link.toLowerCase() == 'all' && all);
            condition.action.each(function (action) {
                action.currentlyTrue = isConditionValid;

                if (action.visibility.toLowerCase() == 'require') {
                    // eslint-disable-next-line no-var
                    var additionalRequireType = JotForm.getAdditionalRequiredValidationArray(action, false);
                    JotForm.requireField(action.field, isConditionValid, additionalRequireType);
                } else if (action.visibility.toLowerCase() == 'unrequire') {
                    JotForm.requireField(action.field, !isConditionValid);
                } else if (action.visibility.toLowerCase() == 'requiremultiple' && action.fields) {
                    action.fields.each(function (field) {
                        // eslint-disable-next-line no-var
                        var additionalRequireType = JotForm.getAdditionalRequiredValidationArray(action, field);
                        JotForm.requireField(field, isConditionValid, additionalRequireType);
                    });
                } else if (action.visibility.toLowerCase() == 'unrequiremultiple' && action.fields) {
                    action.fields.each(function (field) {
                        JotForm.requireField(field, !isConditionValid);
                    });
                } else if(action.visibility.toLowerCase() == 'enable') {
                    JotForm.enableDisableField(action.field, isConditionValid);
                } else if(action.visibility.toLowerCase() == 'disable') {
                    JotForm.enableDisableField(action.field, !isConditionValid);
                } else if(action.visibility.toLowerCase() == 'disablesubmit') {
                    JotForm.disableSubmitForCard(action, isConditionValid);
                }
            });
        } else if (condition.type == 'mask') {
          try {
            condition.action.each(function (action) {
                if ((condition.link.toLowerCase() == 'any' && any) || (condition.link.toLowerCase() == 'all' && all)) {
                    condition.conditionTrue = true;
                    JotForm.setQuestionMasking("#input_" + action.field, "textMasking", action.mask);
                    if ($("input_" + action.field))
                    {
                        $("input_" + action.field).writeAttribute('data-masked', "true");
                        $("input_" + action.field).className.indexOf('validate[Fill Mask]') === -1 && $("input_" + action.field).addClassName('validate[Fill Mask]');
                        $("input_" + action.field).writeAttribute('masked', "true");
                        JotForm.setFieldValidation($("input_" + action.field));
                    }
                } else {
                    condition.conditionTrue = false;
                    //if no other mask conditions for this field are true remove the mask
                    // eslint-disable-next-line no-var
                    var removeMask = true;
                    $A(JotForm.conditions).each(function (cond) {
                        if (cond.disabled == true) return; //go to next condition
                        if (cond.type !== 'mask') return;
                        if (!cond.conditionTrue) return;
                        $A(cond.action).each(function (act) {
                            if (act.field == action.field) {
                                removeMask = false; //there is a different true mask cond on this field so do not remove mask
                            }
                        });
                    });

                    if (removeMask) {
                        JotForm.setQuestionMasking("#input_" + action.field, "", "", true);
                        if ($("input_" + action.field))
                        {
                            $("input_" + action.field).writeAttribute('masked', "false");
                        }
                    }
                }
            });
          } catch (error) {
            console.log(error);
          }
        } else if (condition.type == 'calculation') {
          // eslint-disable-next-line no-var
          var tempResultField = condition.action[0].resultField;

          // eslint-disable-next-line no-var
          var tempInput = $("id_" + tempResultField );

          if (tempResultField.indexOf('|') > -1) {
              // eslint-disable-next-line no-var
              var slicedQid = tempResultField.split('|');
              // eslint-disable-next-line no-var
              var qid = slicedQid[0];
              // eslint-disable-next-line no-var
              var fieldId = slicedQid[1];
              if ($("id_" + qid) && $("id_" + qid).getAttribute('data-type') === 'control_inline') {
                tempInput = $$("#id_" + qid + ' input[id*=' + fieldId + ']');
              } else {
                tempResultField = 'input_' + qid + '_field_' + fieldId;
                tempInput = $(tempResultField );
              }
            }

            if (!tempInput) {
                return;
            }

            // eslint-disable-next-line no-var
            var calcs = JotForm.calculations;
            // eslint-disable-next-line no-var
            for (var i = 0; i < calcs.length; i++) {
                if (calcs[i].conditionId === condition.id) {
                    // eslint-disable-next-line no-undef
                    calc = calcs[i];
                }
            }
            if ((condition.link.toLowerCase() == 'any' && any) || (condition.link.toLowerCase() == 'all' && all)) {
                // eslint-disable-next-line no-undef
                calc.conditionTrue = true;
                // eslint-disable-next-line no-undef
                JotForm.checkCalculation(calc, sourceField, sourceEvent);
            } else {

                // eslint-disable-next-line no-undef
                calc.conditionTrue = false;

                // eslint-disable-next-line no-undef
                if (calc.resultFieldProp === 'startdate') {
                    // eslint-disable-next-line no-undef
                    JotForm.appointments[calc.resultField].forceStartDate();
                }

                // eslint-disable-next-line no-undef
                if (calc.resultFieldProp === 'enddate') {
                    // eslint-disable-next-line no-undef
                    JotForm.appointments[calc.resultField].forceEndDate();
                }

                //check if any other conditions are true for this result field
                setTimeout(function () {
                    // eslint-disable-next-line no-var
                    var matchForThisResult = {};
                    // eslint-disable-next-line no-var
                    var subfield;
                    // eslint-disable-next-line no-var
                    for (var i = 0; i < calcs.length; i++) {
                        if ((condition.action[0].resultField == calcs[i].resultField && calcs[i].hasOwnProperty('conditionTrue') && calcs[i].conditionTrue)
                            && !(JotForm.getInputType(condition.action[0].resultField) === "html" && condition.action[0].replaceText !== calcs[i].replaceText)) {
                            subfield = calcs[i].resultSubField || "";
                            matchForThisResult[calcs[i].resultField+subfield] = true;
                        }
                    }

                    subfield = "resultSubField" in condition.action[0] ? condition.action[0].resultSubField : "";
                    if (!matchForThisResult[condition.action[0].resultField+subfield]) {
                        try {
                            // eslint-disable-next-line no-var
                            var dontTrigger = condition.terms.map(function (term) {
                                return term.field === condition.action[0].resultField;
                            }).any();
                            if(!dontTrigger) {
                                dontTrigger = condition.action[0].operands && condition.action[0].operands.split(',').include(condition.action[0].resultField);
                            }

                            // eslint-disable-next-line no-var
                            var toBeClearField = condition.action[0].resultField;
                            if (!JotForm.isEditMode() && !JotForm.ignoreInsertionCondition) {
                                JotForm.clearField(toBeClearField, subfield, dontTrigger);
                            }

                            // when clearing a field from condition calculation, remove them from __antiLoopCache as well
                            // so recalculation will be triggered on the result field once again
                            if (typeof window.__antiLoopCache === "object" && toBeClearField in window.__antiLoopCache) {
                              delete window.__antiLoopCache[toBeClearField];
                            }
                        } catch (e) {
                            console.log(e);
                        }
                    }
                // eslint-disable-next-line no-undef
                }, 50, calc);
            }
        } else if (condition.type == 'url') {
            return (condition.link.toLowerCase() == 'any' && any) || (condition.link.toLowerCase() == 'all' && all);
        } else { // Page condition

            // eslint-disable-next-line no-var
            var isConditionValid = (condition.link.toLowerCase() == 'any' && any) || (condition.link.toLowerCase() == 'all' && all);
            if($A(condition.action).length > 0 && condition.action.first().skipHide === 'hidePage') {
                // eslint-disable-next-line no-var
                var action = condition.action.first();

                if (window.FORM_MODE == 'cardform') {
                  if ((condition.link.toLowerCase() == 'any' && any) || (condition.link.toLowerCase() == 'all' && all)) {
                    JotForm.hideField(action.skipTo);
                  } else {
                    JotForm.showField(action.skipTo);
                  }
                } else {
                    // eslint-disable-next-line no-var
                    var pageId = parseInt(action.skipTo.replace('page-', ''), 10);

                    if ((condition.link.toLowerCase() == 'any' && any) || (condition.link.toLowerCase() == 'all' && all)) {
                        JotForm.hidePages[pageId] = true;

                        Array.from(document.querySelectorAll('.form-all .page-section')[pageId - 1].children || []).forEach(function(element) {
                            JotForm.corrected(element);
                        });
                    } else {
                        JotForm.hidePages[pageId] = false;
                    }
                }
                return;
            }

            if ($A(condition.action).length > 0 && condition.action.first().skipHide === 'skipTo') {
                // eslint-disable-next-line no-var
                var action = condition.action.first();

                if (window.FORM_MODE !== 'cardform') {
                    // eslint-disable-next-line no-var
                    var pageId = parseInt(action.skipTo.replace('page-', ''), 10);

                    // eslint-disable-next-line no-var
                    var currentPage = JotForm.currentSection.pagesIndex;

                    if ((condition.link.toLowerCase() == 'any' && any) || (condition.link.toLowerCase() == 'all' && all)) {
                        $$('.page-section').forEach(item => {
                            if (item.pagesIndex > currentPage && item.pagesIndex < pageId) {
                                JotForm.skippedPages[item.pagesIndex] = true;
                            }
                        });
                    } else  {
                        $$('.page-section').forEach(item => {
                            if (item.pagesIndex > currentPage && item.pagesIndex < pageId) {
                                JotForm.skippedPages[item.pagesIndex] = false;
                            }
                        });
                    }
                }
            }

            // eslint-disable-next-line no-var
            var action = condition.action[0];
            // eslint-disable-next-line no-var
            var sections;

            if (window.FORM_MODE == 'cardform'){
                sections = $$('.form-all > .form-line');

                // eslint-disable-next-line no-var
                var currentQuestionIndex;
                // eslint-disable-next-line no-var
                var nextQuestionIndex;

                try {
                    // eslint-disable-next-line no-var
                    var allQuestions = window.CardLayout.layoutParams.allQuestions;
                    // eslint-disable-next-line no-var
                    var currentSection = sections.find(function(section) { return section.firstChild && section.firstChild.classList.contains('isVisible');});
                    allQuestions.some(function(q, index) {
                        if (q.id === currentSection.id.substring(currentSection.id.indexOf('_') + 1)) {
                            currentQuestionIndex = index;
                            return true;
                        }
                    });
                    if (action.skipTo == 'end') {
                        nextQuestionIndex = allQuestions.length - 1;
                    } else {
                        allQuestions.some(function(q, index) {
                            if (q.id === action.skipTo || q.id === action.skipTo.replace('page-', '')) {
                                nextQuestionIndex = index;
                                return true;
                            };
                        });
                    }
                } catch (error) {
                    console.log(error);
                }
            } else {
                sections = $$('.form-all > .page-section');
            }


            if (window.FORM_MODE == 'cardform' && !isConditionValid) {
                // eslint-disable-next-line no-var
                for(var i = nextQuestionIndex; i < allQuestions.length; i++) {
                    if(allQuestions[nextQuestionIndex] && allQuestions[nextQuestionIndex].type === 'control_head') {
                        nextQuestionIndex++;
                    }
                }

                if (currentQuestionIndex < nextQuestionIndex) {
                    // eslint-disable-next-line no-var
                    for (var i = currentQuestionIndex + 1; i < nextQuestionIndex; i++) {
                        // eslint-disable-next-line no-var
                        var card = JotForm.getFieldFromID(allQuestions[i].id);
                        if (card && !card.hasClassName('always-hidden') && !card.getAttribute('always-hidden-removed-by-cardform') &&  card.getAttribute('data-skipped-by') !== allQuestions[currentQuestionIndex].id) {
                            // eslint-disable-next-line no-var
                            var hideWidget = false;
                            // checks if the widget has a "hide" parameter and if it is equal to "Yes", we need to hide the widget when "Skip to Page" condition is set
                            if(card.readAttribute('data-type') === 'control_widget'){
                                // eslint-disable-next-line no-var
                                var inputSettings = card.select('input[id="widget_settings_' + allQuestions[i].id + '"]').first();
                                if(inputSettings && inputSettings.value) {
                                    // eslint-disable-next-line no-var
                                    var settingsData = JSON.parse(decodeURIComponent(inputSettings.value));
                                    // eslint-disable-next-line no-var
                                    for(var j = 0; j < settingsData.length; j++) {
                                        if(settingsData[j].name === 'hide' && settingsData[j].value === 'Yes'){
                                            hideWidget = true;
                                            break;
                                        }
                                    }
                                }

                            }
                            if(!hideWidget){
                                JotForm.showField(allQuestions[i].id);
                            }
                        }
                    }
                }
            }

            if (JotForm.nextPage) {
                return;
            }

            if (isConditionValid) {
                if (window.FORM_MODE == 'cardform') {
                  if (action.skipTo == 'end') {
                    JotForm.nextPage = sections[sections.length - 1];
                  } else {
                    try {
                      JotForm.headerInBetween = false;
                      // eslint-disable-next-line no-var
                      for(var i = nextQuestionIndex; i < allQuestions.length; i++) {
                          if(allQuestions[nextQuestionIndex] && allQuestions[nextQuestionIndex].type === 'control_head') {
                              JotForm.headerInBetween = true;
                              nextQuestionIndex++;
                          }
                      }
                      // eslint-disable-next-line no-var
                      var skipTo = allQuestions[nextQuestionIndex].id;


                      // eslint-disable-next-line no-var
                      var next = sections.find(function(section) { return section.id === 'id_' + skipTo;});
                      if (next) {
                        JotForm.nextPage = sections.find(function(section) { return section.id === 'id_' + skipTo;});
                        JotForm.prevPage = currentSection;
                        if (currentQuestionIndex < nextQuestionIndex) {
                            // eslint-disable-next-line no-var
                            for (var i = currentQuestionIndex + 1; i < nextQuestionIndex; i++) {
                                // eslint-disable-next-line no-var
                                var card = JotForm.getFieldFromID(allQuestions[i].id);
                                if (card && !card.hasClassName('always-hidden')) {
                                    JotForm.hideField(allQuestions[i].id);
                                    card.setAttribute('data-skipped-by', allQuestions[currentQuestionIndex].id);
                                }
                            }
                        } else {
                            // eslint-disable-next-line no-var
                            for (var i = currentQuestionIndex - 1; i >= nextQuestionIndex; i--) {
                                // eslint-disable-next-line no-var
                                var card = JotForm.getFieldFromID(allQuestions[i].id);
                                if (card && !card.hasClassName('always-hidden')) {
                                    JotForm.showField(allQuestions[i].id);
                                }
                            }
                        }
                      }
                    } catch (error) {
                      console.log(error);
                    }
                  }
                } else {
                  if (action.skipTo == 'end') {
                      JotForm.nextPage = sections[sections.length - 1];
                  } else {
                      JotForm.nextPage = sections[parseInt(action.skipTo.replace('page-', ''), 10) - 1];
                  }
                }

                if ($$('[data-type="control_paypalSPB"]')[0] && $$('[data-paypal-button="Yes"]')[0]) {
                    // eslint-disable-next-line no-var
                    var paypalSection = JotForm.getSection($$('[data-type="control_paypalSPB"]')[0]).pagesIndex;
                    // eslint-disable-next-line no-var
                    var currentSection = JotForm.currentSection.pagesIndex;
                    // eslint-disable-next-line no-var
                    var nextSection = JotForm.nextPage.pagesIndex;

                    if (
                        (paypalSection > currentSection && paypalSection < nextSection)
                        || (paypalSection < currentSection && paypalSection > nextSection)
                    ) {
                        // eslint-disable-next-line no-var
                        var paypalButton = $$('.paypal-buttons.paypal-buttons-context-iframe')[0];
                        // eslint-disable-next-line no-var
                        var paypalButtonContainer = JotForm.getContainer(paypalButton);

                        if (paypalButton && paypalButtonContainer) {
                            paypalButtonContainer.setAttribute('paypal-button-status', 'hide');
                        }
                    }
                }

            } else {

                JotForm.info('Fail: Skip To: page-' + JotForm.currentPage + 1);

                JotForm.nextPage = false;
            }
        }
        if (JotForm.nextPage && JotForm.isEditMode()) {
            // because on edit mode, fields are populated, some conditions may already be satisfied
          if(window.FORM_MODE !== 'cardform'){
            // eslint-disable-next-line no-var
            var currentPageIndex = $$('.page-section').indexOf(JotForm.currentSection);
            // eslint-disable-next-line no-var
            var skipCondition = function() {
                if (condition.link.toLowerCase() == 'any') {
                    // skip if all fields are ahead
                    return condition.terms.every(function(term) {
                        return $$('.page-section').indexOf($('id_' + term.field).up('.page-section')) > currentPageIndex;
                    });
                }
                // skip if any  of the fields are ahead
                return condition.terms.some(function(term) {
                    return $$('.page-section').indexOf($('id_' + term.field).up('.page-section')) > currentPageIndex;
                });
            }
            // ignore this skip-to-page condition at this moment
            JotForm.nextPage = skipCondition() ? false : JotForm.nextPage;
          }
        }
        JotForm.enableDisableButtonsInMultiForms();
    },
    currentPage: false,
    nextPage: false,
    previousPage: false,
    fieldConditions: {},

    setFieldConditions: function (field, event, condition) {
        // eslint-disable-next-line no-var
        var tempField = '';
        if (field.indexOf('|') > -1) {
          // eslint-disable-next-line no-var
          var fieldSplit = field.split( '|' );
          tempField = fieldSplit[0] + '_field_' + fieldSplit[1];
        } else {
          tempField = field;
        }

        if (!JotForm.fieldConditions[tempField]) {
            JotForm.fieldConditions[tempField] = {
                event: event,
                conditions: []
            };
        }
        JotForm.fieldConditions[tempField].conditions.push(condition);
        this.setSubproductQuantityConditions(tempField, condition); // b#5022272
    },

    setSubproductQuantityConditions: function (tempField, condition) {
        if (tempField.match(/input_[0-9]+_quantity_[0-9]+_[0-9]+/)) {
            // eslint-disable-next-line no-var
            var qid = tempField.split('_')[1], pid = tempField.split('_')[3];
            // eslint-disable-next-line no-var
            var pItem = document.querySelector('.form-product-item[pid="' + pid + '"], .form-product-item[data-pid="' + pid + '"]');

            if (!pItem) { return; }
            // eslint-disable-next-line no-var
            var subQuantities = pItem.querySelectorAll(
                '#input_' + qid + '_' + pid + '_subproducts.form-product-child-table .form-subproduct-quantity'
            );

            if (subQuantities.length === 0) { return; }

            Array.from(subQuantities).forEach(function(quantityInput) {
                // eslint-disable-next-line no-var
                var _condition = JSON.parse(JSON.stringify(condition));
                _condition.terms[0].field = quantityInput.id.replace('input_', '');
                // eslint-disable-next-line no-var
                var c = {
                    conditions: [],
                    event: 'change'
                };
                c.conditions.push(_condition);

                JotForm.fieldConditions[quantityInput.id] = c;
            });
        }
    },

    widgetsAsCalculationOperands: [],

    requireWidget: function (qid, req) {
        // eslint-disable-next-line no-var
        var referrer = document.getElementById("customFieldFrame_" + qid) ? document.getElementById("customFieldFrame_" + qid).src : false;
        if (referrer) {
            // eslint-disable-next-line no-var, no-undef
            var frame = (navigator.userAgent.indexOf("Firefox") != -1 && typeof getIframeWindow !== 'undefined') ? getIframeWindow(window.frames["customFieldFrame_" + qid]) : window.frames["customFieldFrame_" + qid];
            // eslint-disable-next-line no-var
            var isFrameXDready = (!$("customFieldFrame_" + qid).hasClassName('frame-xd-ready') && !$("customFieldFrame_" + qid).retrieve('frame-xd-ready')) ? false : true;
            if (frame && isFrameXDready) {
                window.XD.postMessage(JSON.stringify({type: 'required', qid, req}), referrer, frame);
            }
        }
    },

    /*
     * Require or Unrequire a field
     */
    requireField: function (qid, req, additionalRequireType) {
        // eslint-disable-next-line no-var
        var subfieldID = null;
        if (qid.indexOf('|') > -1) {
            // eslint-disable-next-line no-var
            var subfieldID = qid.split('|')[1];
            qid = qid.split('|')[0];
        }
        if (!$('id_' + qid)) return;
        if (JotForm.otherConditionTrue(qid, req ? 'unrequire' : 'require')) return;

        // eslint-disable-next-line no-var
        var elements = [];
        if (subfieldID) {
            elements = $$('#id_' + qid + ' input[id$=-' + subfieldID + '], #id_' + qid + ' textarea[id$=-' + subfieldID + '], #id_' + qid + ' select[id$=-' + subfieldID + ']');

            if (window.FORM_MODE == 'cardform' && $('input_' + qid + '_field_' + subfieldID) && $('input_' + qid + '_field_' + subfieldID).hasClassName("js-forMixed")) {
                elements = $$('#id_' + qid + ' input[id$=_' + subfieldID + '], #id_' + qid + ' textarea[id$=_' + subfieldID + '], #id_' + qid + ' select[id$=_' + subfieldID + ']');
            }
        } else {
            elements = $$('#id_' + qid + ' input, #id_' + qid + ' textarea, #id_' + qid + ' select');
        }
        elements.each(function (el) {

            //do not required non-necessary parts of combined field
            if (el.id === 'coupon-input'
                || (el.type === 'hidden' && !el.up('.form-star-rating') && !el.hasClassName('form-widget') && !el.up('.FITB-inptCont[data-type="signaturebox"]') && (!("input_" + qid + "_date" === el.id && JotForm.getInputType(qid) === "appointment" && $("input_" + qid + "_date"))))
                || el.hasClassName('form-checkbox-other-input') || el.hasClassName('form-radio-other-input')
                || el.hasClassName('jfModal-input')
                || $A(['prefix', 'middle', 'suffix', 'addr_line2']).any(function (name) {
                    return el.name.indexOf("[" + name + "]") > -1;
                })
                || el.hasClassName('jfDropdown-search')
                || el.hasClassName('jfRating-shortcut-input')
                || el.hasClassName('__PrivateStripeElement-input')
                || el.up('.product-container-wrapper .filter-container #payment-category-dropdown') // product category
                || (el.up('.product-container-wrapper .filter-container') && el.id === 'productSearch-input')) { // product search
                return;
            }

            //get all validations
            // eslint-disable-next-line no-var
            var validations = [];
            if (el.className.indexOf('validate[') > -1) {
                validations = el.className.substr(el.className.indexOf('validate[') + 9);
                validations = validations.substr(0, validations.indexOf(']')).split(/\s*,\s*/);
            } else {
                validations = [];
            }

            if (JotForm.getInputType(qid) == "file" && el.getAttribute("multiple") == "multiple" && el.up('[class*=validate[multipleUpload]]')) {
                // eslint-disable-next-line no-var
                var uploadWrapper = el.up('[class*=validate[multipleUpload]]');
                uploadWrapper.className = uploadWrapper.className.replace(/validate\[required\]/gi, '');
                if (req) {
                    uploadWrapper.addClassName("validate[required]");
                } else {
                    uploadWrapper.removeClassName("form-validation-error");
                }
            }

            if ("input_" + qid + "_date" === el.id && JotForm.getInputType(qid) == "appointment" && $("input_" + qid + "_date")) {
                if (req) {
                    $("input_" + qid + "_date").addClassName("validate");
                } else {
                    $("input_" + qid + "_date").removeClassName("validate");
                }
            }

            //remove all validation from class
            el.className = el.className.replace(/validate\[.*\]/, '');
            //remove required from validations array
            // eslint-disable-next-line no-var
            for (var i = validations.length - 1; i >= 0; i--) {
                if (validations[i] === 'required' || additionalRequireType && additionalRequireType.some(function(t) { return t === validations[i]; })) {
                    validations.splice(i, 1);
                }
            }

            if (req) {
                validations.push('required'); //add required to validations
                additionalRequireType && additionalRequireType.forEach(function(t) { validations.push(t) });
                if (el.hasClassName('form-widget')) {
                    el.addClassName('widget-required');
                }
            } else {
                el.removeClassName('form-validation-error');
                el.removeClassName('widget-required');
            }

            //add validations back to class
            if (validations.length > 0) {
                el.addClassName('validate[' + validations.join(',') + ']');
            }
            JotForm.setFieldValidation(el);

            if (JotForm.getInputType(qid) == 'widget'){
                JotForm.requireWidget(qid, req);
            }
        });

        // signature
        // eslint-disable-next-line no-var
        var sigPad = $$('div.pad#sig_pad_' + qid)[0];
        if (sigPad) {
            sigPad.setAttribute('data-required', req);
            sigPad.className = sigPad.className.replace('validate[required]', '').trim()
            if (req) {
                sigPad.className = sigPad.className + ' validate[required]';
            }
        }

        if (req) {
            if ($('label_' + qid) && !$('label_' + qid).down('.form-required')) {
                $('label_' + qid).insert('<span class="form-required">*</span>');
            }

            // FITB exception
            elements.each(function(e) {
                if (e.up('.FITB-inptCont') && !e.up('.FITB-inptCont').down('.form-required')) {
                    e.up('.FITB-inptCont').insert('<span class="form-required">*</span>');
                }
            });
        } else {
            if ($('label_' + qid) && $('label_' + qid).down('.form-required')) {
                $('label_' + qid).down('.form-required').remove();
            }

            // FITB exception
            elements.each(function(e) {
                if (e.up('.FITB-inptCont') && e.up('.FITB-inptCont').down('.form-required')) {
                    e.up('.FITB-inptCont').down('.form-required').remove();
                }
            });

            //remove any existing errors
            if ($("id_" + qid).down('.form-error-message')) {
                $("id_" + qid).down('.form-error-message').remove();
            }
            $("id_" + qid).removeClassName('form-line-error');

            if ($$('.form-line-error').length == 0) {
                JotForm.hideButtonMessage();
            }
        }
    },

    enableDisableField: function(qid, enable) {
        // eslint-disable-next-line no-var
        var subfieldID = null;
        if (qid.indexOf('|') > -1) {
            // eslint-disable-next-line no-var
            var subfieldID = qid.split('|')[1];
            qid = qid.split('|')[0];
        }
        if (!$('id_' + qid)) return;

        try {
            // eslint-disable-next-line no-var
            var isSignatureField = $('id_' + qid).getAttribute('data-type') === "control_signature";
            // eslint-disable-next-line no-var
            var isAppointmentField = $('id_' + qid).getAttribute('data-type') === "control_appointment";
            // eslint-disable-next-line no-var
            var appointmentElements = isAppointmentField ? Array.from($('id_' + qid).querySelectorAll(".calendarDay:not(.isUnavailable):not(.empty), .calendarDay.conditionallyDisabled, .appointmentSlot:not(.disabled), .appointmentSlot.conditionallyDisabled")) : [];
            // eslint-disable-next-line no-var
            var isWidget = $('id_' + qid).readAttribute('data-type') === 'control_widget' && JotForm.getWidgetType(qid);
            // eslint-disable-next-line no-var
            var canEnabledDisabledWidget = isWidget ? $('id_' + qid).down("iframe") : false;

            // eslint-disable-next-line no-var
            var elements = [];
            if (subfieldID) {
                elements = $('id_' + qid).select("input[id*=" + subfieldID + "], select[id*=" + subfieldID + "]");

                if (window.FORM_MODE == 'cardform' && $('input_' + qid + '_field_' + subfieldID) && $('input_' + qid + '_field_' + subfieldID).hasClassName("js-forMixed")) {
                    elements = $$('#id_' + qid + ' input[id$=_' + subfieldID + '], #id_' + qid + ' textarea[id$=_' + subfieldID + '], #id_' + qid + ' select[id$=_' + subfieldID + ']');
                }
            } else {
                elements = $('id_' + qid).select("input, textarea, select, button").concat(appointmentElements);
            }

            elements.each(function(input) {
                // eslint-disable-next-line no-var
                var isAppointmentSlot = isAppointmentField && input.hasClassName("appointmentSlot");
                // eslint-disable-next-line no-var
                var isAppointmentCalendarDay = isAppointmentField && input.hasClassName("calendarDay");
                // eslint-disable-next-line no-var
                var isActiveSlot = isAppointmentSlot && input.hasClassName('active');
                // eslint-disable-next-line no-var
                var isDataRichText = input.hasAttribute('data-richtext') && input.getAttribute('data-richtext') == "Yes";
                // eslint-disable-next-line no-var
                var signaturePad = isSignatureField ? jQuery('#sig_pad_' + qid + '.pad') : null;
                // eslint-disable-next-line no-var
                var isMatrixButtonForMobileView = input.hasClassName("js-mobileMatrixPrevButton") || input.hasClassName("js-mobileMatrixNextButton");

                /** SHORT CIRCUIT **/
                if(isMatrixButtonForMobileView) {
                    return;
                }

                /** ENABLE **/
                if (enable) {
                    input.removeClassName("conditionallyDisabled");
                    if (signaturePad && signaturePad.jSignature) {
                        signaturePad.jSignature('enable');
                    }
                    if (canEnabledDisabledWidget) {
                        canEnabledDisabledWidget.setStyle({ 'pointer-events': '' });
                    }

                    // https://www.jotform.com/answers/15761281
                    if (input.readAttribute('data-component') === 'calculation' && JotForm.accessible) {
                        input.setAttribute("readonly", "false");
                    }
                    if (!JotForm.isEditMode()) {
                        input.enable();
                        // needs to call parent div of star rating input to enable
                        if (input.classList.contains('form-star-rating-star')) {
                            input.parentNode.enable();
                        }
                        if (isActiveSlot) {
                            input.setStyle({'pointer-events': 'all'});
                        } else if (isDataRichText) {
                            // eslint-disable-next-line no-var
                            var richTextArea = input.parentElement.querySelector(".nicEdit-main");
                            if (richTextArea) { richTextArea.setAttribute("contenteditable", "true") };
                        } else {
                            input.removeClassName(isAppointmentSlot ? "disabled" : (isAppointmentCalendarDay ? "isUnavailable" : ""));
                        }
                        return;
                    }
                    // edit mode
                    switch (input.tagName) {
                        case 'SELECT':
                            $$('#' + input.id + ' > option').each(function (opt) {
                                opt.enable();
                            });
                            break;
                        case 'TEXTAREA':
                            if(isDataRichText) {
                                // eslint-disable-next-line no-var
                                var richTextArea = input.parentElement.querySelector(".nicEdit-main");
                                if (richTextArea) { richTextArea.setAttribute("contenteditable", "true") };
                            }
                        default:
                            input.removeAttribute('readonly');
                            input.enable();
                            break;
                    }
                    return;
                }
                /** DISABLE **/
                if (!(input.hasClassName('form-radio-other-input') || input.hasClassName('form-checkbox-other-input'))) {
                    input.addClassName("conditionallyDisabled");
                }
                if (signaturePad && signaturePad.jSignature) {
                    signaturePad.jSignature('disable');
                }
                if (canEnabledDisabledWidget) {
                    canEnabledDisabledWidget.setStyle({ 'pointer-events': 'none' });
                }
                if (!JotForm.isEditMode()) {
                    input.disable();
                    // needs to call parent div of star rating input to disable
                    if (input.classList.contains('form-star-rating-star')) {
                        input.parentNode.disable();
                    }

                    // https://www.jotform.com/answers/15761281
                    if (input.readAttribute('data-component') === 'calculation' && JotForm.accessible) {
                        input.enable();
                        input.setAttribute("readonly", "true");
                    }
                    if (isActiveSlot) {
                        input.setStyle({'pointer-events': 'none'});
                    } else if (isDataRichText) {
                        // eslint-disable-next-line no-var
                        var richTextArea = input.parentElement.querySelector(".nicEdit-main");
                        if (richTextArea) { richTextArea.setAttribute("contenteditable", "false") };
                    } else {
                        input.addClassName(isAppointmentSlot ? "disabled" : (isAppointmentCalendarDay ? "isUnavailable" : ""));
                    }
                    return;
                }
                // edit mode
                switch (input.tagName) {
                    case 'SELECT':
                        $$('#' + input.id + ' > option').each(function (opt) {
                            opt.disabled = !opt.selected;
                        });
                        break;
                    case 'INPUT':
                        if (['checkbox', 'radio'].include(input.type) || input.type === 'file'
                            || (['year_' + qid, 'month_' + qid, 'day_' + qid, 'lite_mode_' + qid ]).include(input.id) || (input.getAttribute('data-type') === 'input-spinner'))
                        {
                            input.disable();
                        }
                    case 'TEXTAREA':
                        if(isDataRichText) {
                            // eslint-disable-next-line no-var
                            var richTextArea = input.parentElement.querySelector(".nicEdit-main");
                            if (richTextArea) { richTextArea.setAttribute("contenteditable", "false") };
                        }
                    default:
                        input.setAttribute('readonly', '');
                        break;
                }
            });
        } catch(e) {console.log(e);}
    },

    /**
     * When widget value is updated check whether to trigger calculation
     */
    triggerWidgetCalculation: function (id) {
        if (JotForm.widgetsAsCalculationOperands.include(id)) {
            if (document.createEvent) {
                // eslint-disable-next-line no-var
                var evt = document.createEvent('HTMLEvents');
                evt.initEvent('change', true, true);
                $('input_' + id).dispatchEvent(evt);
            } else if ($('input_' + id).fireEvent) {
                return $('input_' + id).fireEvent('onchange');
            }
        }
    },


    setCalculationResultReadOnly: function () {
        JotForm.calculations.forEach(function (calc) {
            if ((calc.readOnly && calc.readOnly != "0") && $('input_' + calc.resultField) != null) {
                $('input_' + calc.resultField).setAttribute('readOnly', 'true');
            }
        });
    },

    setCalculationEvents: function () {
        // eslint-disable-next-line no-var
        var setCalculationListener = function (el, ev, calc) {
            // eslint-disable-next-line no-var
            var element = typeof el === "string" ? document.getElementById(el) : el;
            element.addEventListener(ev, function () {
                if (ev === "paste") { //same action as other events but wait for the text to be pasted
                    setTimeout(function () {
                        element.classList.add('calculatedOperand');
                        JotForm.checkCalculation(calc, el, ev);
                    }, 10);
                } else {
                    element.classList.add('calculatedOperand');
                    JotForm.checkCalculation(calc, el, ev);
                }
            });
        };

        JotForm.calculations.forEach(function (calc, index) {
            if (!calc.operands || typeof calc.operands === 'function') return;
            // eslint-disable-next-line no-var
            var ops = calc.operands.split(',');
            // eslint-disable-next-line no-var
            for (var i = 0; i < ops.length; i++) {

                // eslint-disable-next-line no-var
                var opField = ops[i];
                // eslint-disable-next-line no-var
                var mixedOpField = '';
                if(opField.indexOf('|') > -1) {
                    // eslint-disable-next-line no-var
                    var splitResult = opField.split('|');
                    // eslint-disable-next-line no-var
                    var qid = splitResult[0];
                    // eslint-disable-next-line no-var
                    var fieldId =  splitResult[1];
                    if ($('id_' + qid) && $('id_' + qid).getAttribute('data-type') === 'control_inline') {
                        mixedOpField = 'id_' + qid;
                    } else {
                        mixedOpField = 'input_' + qid + '_field_' + fieldId;
                    }
                }

                if (!opField || opField.empty() || (!$('id_' + opField) && !$(mixedOpField))) continue;

                // eslint-disable-next-line no-var
                var type = JotForm.calculationType(opField);

                switch (type) {
                    case "mixed":
                        if ($(mixedOpField)) {
                            setCalculationListener($(mixedOpField), 'change', calc, index);
                            setCalculationListener($(mixedOpField), 'blur', calc, index);
                            setCalculationListener($(mixedOpField), 'keyup', calc, index);
                            setCalculationListener($(mixedOpField), 'paste', calc, index);
                        }
                        break;

                    case 'inline':
                        // eslint-disable-next-line no-var
                        var el = $(mixedOpField) ? $(mixedOpField) : $('id_' + opField);
                        setCalculationListener(el, 'change', calc, index);
                        break;

                    case "widget":
                        setCalculationListener($('id_' + opField), 'change', calc);
                        JotForm.widgetsAsCalculationOperands.push(opField);
                        break;

                    case 'radio':
                    case 'checkbox':
                        setCalculationListener($('id_' + opField), 'change', calc);
                        if ($('input_' + opField)) {
                            setCalculationListener($('id_' + opField), 'keyup', calc);
                        }
                        break;

                    case 'select':
                    case 'file':
                        // eslint-disable-next-line no-undef
                        if (Protoplus && Protoplus.getIEVersion && Protoplus.getIEVersion() == 8) {
                            setCalculationListener($('id_' + opField), 'click', calc);
                        } else {
                            setCalculationListener($('id_' + opField), 'change', calc);
                        }
                        break;

                    case 'datetime':
                        setCalculationListener($('id_' + opField), 'date:changed', calc);
                        setCalculationListener($('id_' + opField), 'paste', calc);
                        setCalculationListener($('id_' + opField), 'keyup', calc);
                        $$('#id_' + opField + ' input').each(function (el) {
                          setCalculationListener($(el), 'blur', calc);
                        });
                        $$("#id_" + opField + ' select').each(function (el) {
                            setCalculationListener($(el), 'change', calc);
                        });
                        break;

                    case 'time':
                        $$("#id_" + opField + ' select').each(function (el) {
                            setCalculationListener($(el), 'change', calc, index);
                        });
                        if (JotForm.newDefaultTheme || JotForm.extendsNewTheme) {
                            $$("#id_" + opField + " input[class*='form-textbox']").each(function (el) {
                                setCalculationListener($(el), 'keyup', calc, index);
                                setCalculationListener($(el), 'blur', calc, index);
                            });
                        }
                        break;
                    case 'birthdate':
                        $$("#id_" + opField + ' select').each(function (el) {
                            setCalculationListener($(el), 'change', calc, index);
                        });
                        break;

                    case 'address':
                        setCalculationListener($('id_' + opField), 'change', calc, index);
                        setCalculationListener($('id_' + opField), 'blur', calc, index);
                        setCalculationListener($('id_' + opField), 'keyup', calc, index);
                        $$("#id_" + opField + ' select').each(function (el) {
                            setCalculationListener($(el), 'change', calc, index);
                        });
                        break;

                    case 'number':
                        setCalculationListener($('id_' + opField), 'keyup', calc, index);
                        setCalculationListener($('id_' + opField), 'paste', calc, index);
                        setCalculationListener($('id_' + opField), 'click', calc, index);
                        break;

                    default:
                        setCalculationListener($('id_' + opField), 'change', calc, index);
                        setCalculationListener($('id_' + opField), 'blur', calc, index);
                        setCalculationListener($('id_' + opField), 'keyup', calc, index);
                        setCalculationListener($('id_' + opField), 'paste', calc, index);
                        if(window.FORM_MODE === 'cardform' && $('id_' + opField).querySelector(".jfQuestion-fullscreen") && !$('id_' + opField).querySelector(".jfQuestion-fullscreen").hasClassName("isHidden")) {
                           setCalculationListener($('id_' + opField), 'click', calc, index);
                        }
                        break;
                }
            }
        });
    },

    runAllCalculations: function (ignoreEditable, htmlOnly) {

        JotForm.calculations.forEach(function (calc) {
            if(htmlOnly && JotForm.getInputType(calc.resultField) !== "html") return;
            if (!(ignoreEditable && (!calc.readOnly || calc.readOnly == "0")) && !!calc.equation) {
                JotForm.checkCalculation(calc);
            }
        });
        JotForm.conditionCalculationDebugLogs = [];
    },

    calculationType: function (id) {
        const paymentTypes = [
         'control_stripe',
         'control_stripeCheckout',
         'control_stripeACH',
         'control_stripeACHManual',
         'control_payment',
         'control_paymentwall',
         'control_paypal',
         'control_paypalexpress',
         'control_paypalpro',
         'control_paypalcomplete',
         'control_clickbank',
         'control_2co',
         'control_googleco',
         'control_worldpay',
         'control_onebip',
         'control_authnet',
         'control_dwolla',
         'control_braintree',
         'control_square',
         'control_boxpayment',
         'control_eway',
         'control_bluepay',
         'control_firstdata',
         'control_paypalInvoicing',
         'control_payjunction',
         'control_chargify',
         'control_cardconnect',
         'control_echeck',
         'control_bluesnap',
         'control_payu',
         'control_payuMoney',
         'control_pagseguro',
         'control_moneris',
         'control_mollie',
         'control_sofort',
         'control_skrill',
         'control_sensepass',
         'control_paysafe',
         'control_iyzico',
         'control_gocardless',
         'control_paypalSPB',
         'control_cybersource',
         'control_payfast'
        ];
        const field = document.querySelector(`[id="id_${id}"]`)
        if (field && field.readAttribute('data-type') && paymentTypes.includes(field.readAttribute('data-type'))) {
            return field.readAttribute('data-type').replace("control_", "");
        } else if (field && field.readAttribute('data-type') == 'control_matrix') {
            return 'matrix';
        } else {
            return JotForm.getInputType(id);
        }
    },

    isTimeObject: function (id) {
        // eslint-disable-next-line no-var
        var ndtTimeIDs = ['time', 'hour', 'min', 'ampm'];
        // eslint-disable-next-line no-var
        for (var i = 0 ; i < ndtTimeIDs.length ; i++) {
            if (id.indexOf(ndtTimeIDs[i]) >= 0) {
                return true;
            }
        }
        return false;
    },

    runAllCalculationByID: function(field){
        JotForm.calculations.forEach(calc => {
            if (calc && calc.resultField == field) {
                JotForm.checkCalculation(calc);
            }
        });
    },

    runRelatedCalculations: function (field) {
        JotForm.calculations.forEach(calc => {
            const { operands, baseField } = calc;
            const fields = operands ? operands.split(',') : [baseField].filter(Boolean);
            if (fields.indexOf(field) !== -1) {
                JotForm.checkCalculation(calc);
            }
        });
    },

    checkCalculation: function (calc, sourceField, sourceEvent) {
        if (!calc.resultField || (calc.hasOwnProperty('conditionTrue') && !calc.conditionTrue)) {
            return '';
        }

        if(JotForm.ignoreInsertionCondition && !JotForm.replaceTagTest){
            return;
        }

        // eslint-disable-next-line no-var
        var result = calc.resultField;
        // Check for multiline
        // eslint-disable-next-line no-var
        var mixedResult = false;
        if(result.indexOf('|') > -1) {
            // eslint-disable-next-line no-var
            var splitResult = result.split('|');
            // eslint-disable-next-line no-var
            var qid = splitResult[0];
            // eslint-disable-next-line no-var
            var fieldId =  splitResult[1];
            if ($('id_' + qid) && $('id_' + qid).getAttribute('data-type') === 'control_inline') {
                mixedResult = 'id_' + qid;
            } else {
                mixedResult = 'input_' + qid + '_field_' + fieldId;
            }
        }
        // eslint-disable-next-line no-var
        var showBeforeInput = (calc.showBeforeInput && calc.showBeforeInput != "0") ? calc.showBeforeInput : false;
        // eslint-disable-next-line no-var
        var ignoreHidden = (calc.ignoreHiddenFields && calc.ignoreHiddenFields != "0") ? calc.ignoreHiddenFields : false;
        // eslint-disable-next-line no-var
        var useCommasForDecimals = (calc.useCommasForDecimals && calc.useCommasForDecimals != "0") ? calc.useCommasForDecimals : false;

        if (!$('id_' + result) && !$(mixedResult)) return;
        try {
            if (![
                'text', 'email', 'textarea', 'calculation', 'combined', 'address', 'datetime', 'time', 'html', 'authnet', 'paypalpro', 'number', 'radio', 'checkbox',
                'select', 'matrix', 'widget', 'signature', 'braintree', 'stripe', 'square', 'eway', 'bluepay', 'firstdata', 'chargify', 'echeck', 'payu', 'payuMoney', 'pagseguro', 'moneris', 'paypal',
                'dwolla', 'bluesnap', 'paymentwall', 'payment', 'paypalexpress', 'payjunction', '2co', 'cardconnect', 'clickbank', 'onebip', 'worldpay', 'rating', 'hidden',
                'file', 'other', 'mixed', 'sofort', 'sensepass', 'paysafe', 'iyzico', 'gocardless', 'stripeACH', 'paypalSPB', 'cybersource', "paypalcomplete", 'inline', 'appointment',
                'stripeCheckout', 'payfast', 'stripeACHManual', 'sensepass', 'birthdate'
                ].include(JotForm.calculationType(result))) return;
        } catch (e) {
            console.log(e);
        }

        // eslint-disable-next-line no-var
        var combinedObject = {};

        // eslint-disable-next-line no-var
        var getValue = function (data, numeric) {
            // eslint-disable-next-line no-var
            var subField = "";
            if (data.indexOf("_") > -1) { //matrix sub field
                subField = data.substring(data.indexOf("_"));
                data = data.substring(0, data.indexOf("_"));
            }

            // eslint-disable-next-line no-var
            var hasMixedTypeChar = false;
            if (data.indexOf("|") > -1) {
              hasMixedTypeChar = true;
              // subField = data.substring(data.indexOf("|"));
              // data = data.substring(0, data.indexOf("|"));
            }

            if (hasMixedTypeChar == false) {
              if ($('id_' + data)){
                  if (!$('id_' + data).hasClassName('calculatedOperand') && showBeforeInput) return ''; //no input yet so ignore field
                  if (ignoreHidden && ($('id_' + data).hasClassName("form-field-hidden") || ($('id_' + data).up(".form-section") && $('id_' + data).up(".form-section").hasClassName("form-field-hidden")))) {
                      return numeric ? 0 : '';
                  }
              } else if(!$('input_' + data)){
                    return '';
              }
            }

            // eslint-disable-next-line no-var
            var type = JotForm.calculationType(data);
            // eslint-disable-next-line no-var
            var val = '';

            switch (type) {
                case 'matrix':
                    if ($("input_" + data + subField)) {
                        // eslint-disable-next-line no-var
                        var subFieldType = $("input_" + data + subField).type;
                        if (["checkbox", "radio"].indexOf(subFieldType) > -1) {
                            if ($("input_" + data + subField).checked) {
                                // eslint-disable-next-line no-var
                                var chk = $("input_" + data + subField);
                                if (chk.readAttribute('data-calcvalue')) {
                                    val = chk.readAttribute('data-calcvalue');
                                } else {
                                    val = chk.value;
                                }
                            }
                        } else {
                            val = $("input_" + data + subField).value;
                        }
                    } else if ($("id_" + data).down('.form-radio')) {
                        $$('input[id^="input_'+data+subField+'_"]').each(function (radio) {
                            if (radio.checked) {
                              val = radio.readAttribute('data-calcvalue') ? radio.readAttribute('data-calcvalue') : radio.value;
                            }
                        });
                    }
                    break;

                case 'mixed':
                  // eslint-disable-next-line no-var
                  var slicedQid;
                  // eslint-disable-next-line no-var
                  var fieldId;

                  if (data.indexOf('|') > -1) {
                    slicedQid = data.split('|');
                    questionId = slicedQid[0]; // eslint-disable-line
                    fieldId = slicedQid[1];
                  }

                  // eslint-disable-next-line no-var
                  var tempInput = $('input_' + questionId + '_field_' + fieldId); // eslint-disable-line

                  if (tempInput && typeof tempInput.value !== 'undefined') {
                    val = tempInput.value;
                  }

                  break;

                case '2co':
                case 'authnet':
                case 'bluepay':
                case 'bluesnap':
                case 'boxpayment':
                case 'braintree':
                case 'cardconnect':
                case 'chargify':
                case 'clickbank':
                case 'cybersource':
                case 'dwolla':
                case 'echeck':
                case 'eway':
                case 'firstdata':
                case 'gocardless':
                case 'googleco':
                case 'mollie':
                case 'moneris':
                case 'onebip':
                case 'pagseguro':
                case 'payjunction':
                case 'payment':
                case 'paysafe':
                case 'iyzico':
                case 'sensepass':
                case 'paypal':
                case 'paypalexpress':
                case 'paypalSPB':
                case 'paypalpro':
                case 'paypalcomplete':
                case 'paypalInvoicing':
                case 'payu':
                case 'payuMoney':
                case 'square':
                case 'sofort':
                case 'stripe':
                case 'stripeCheckout':
                case 'stripeACH':
                case 'stripeACHManual':
                case 'worldpay':
                case 'payfast':
                    if ($("id_" + data).down('#payment_total')) {
                        val = $("id_" + data).down('#payment_total').innerText;
                    } else if ($('input_' + data + '_donation')) {
                        val = $('input_' + data + '_donation').value;
                    } else if ($("id_" + data).down('#payment_recurringpayments')) {
                        val = $("id_" + data).down('#payment_recurringpayments').innerText;
                    }
                    if(JotForm.currencyFormat && JotForm.currencyFormat.dSeparator === ",") {
                        val = val.replace(/\./g, "").replace(/\,/g, ".");
                    }
                    break;

                case 'radio':
                    $$("#id_" + data + ' input[type="radio"]').each(function (rad) {
                        if (rad.checked) {
                            if (rad.readAttribute('data-calcvalue')) {
                                val = rad.readAttribute('data-calcvalue');
                            } else {
                                // eslint-disable-next-line no-var
                                var otherOption = JotForm.getOptionOtherInput(rad);
                                if (typeof FormTranslation !== 'undefined' && otherOption && otherOption.innerText) {
                                    val = JotForm.getOptionOtherInput(rad).innerText;
                                } else {
                                    val = rad.value;

                                    if (typeof FormTranslation !== 'undefined') {
                                        val = FormTranslation.translate(val);
                                    }
                                }
                            }
                        }
                    });
                    break;

                case 'checkbox':

                    // eslint-disable-next-line no-var
                    var valArr = [];
                    $$("#id_" + data + ' input[type="checkbox"]').each(function (chk) {
                        if (chk.checked) {
                            if (chk.readAttribute('data-calcvalue')) {
                                valArr.push(chk.readAttribute('data-calcvalue'));
                            } else {
                                if (typeof FormTranslation !== 'undefined') {
                                    valArr.push(FormTranslation.translate(chk.value));
                                } else {
                                    valArr.push(chk.value);
                                }
                            }
                        }
                    });

                    if (numeric) {
                        val = valArr.inject(0, function (accum, thisVal) {
                            return accum + (parseFloat(thisVal.replace(/-?([^0-9])/g, "$1").replace(/[^0-9\.-]/g, "")) || 0);
                        });
                    } else {
                        val = valArr.join(', ');
                    }
                    break;

                case 'select':
                    // eslint-disable-next-line no-var
                    var optionValue = function(option) {
                        if(JotForm.newDefaultTheme && option.value === '') return '';
                        if(option.textContent) return option.textContent.replace(/^\s+|\s+$/g, '');
                        return option.innerText.replace(/^\s+|\s+$/g, '');
                    };

                    if (numeric) val = 0;

                    // eslint-disable-next-line no-var
                    var tempInput;
                    if (data.indexOf('|') > -1) {
                        slicedQid = data.split('|');
                        // eslint-disable-next-line no-var
                        var questionId = slicedQid[0];
                        // eslint-disable-next-line no-var
                        var fieldId = slicedQid[1];

                        tempInput = $('input_' + questionId + '_field_' + fieldId);
                    } else {
                        tempInput = $('input_' + data);
                    }

                    tempInput.select('option').each(function (option, ind) {
                        // eslint-disable-next-line no-var
                        var option = tempInput.options[ind];
                        if (option && option.selected) {
                            // eslint-disable-next-line no-var
                            var current = option.readAttribute('data-calcvalue') ? option.readAttribute('data-calcvalue') : optionValue(option);
                            if(numeric) {
                                if (/\d/.test(current)) {   // is really numeric?
                                    val += (current === "") ? 0 : parseFloat(current.replace(/[^\-0-9.]/g, ""));
                                } else {
                                    val += 0;
                                }
                            } else {
                                val +=  current;
                            }
                        }
                    });
                    break;

                case 'number':
                    if ($$("#id_" + data + ' input[type="number"]').length > 1) { //ranges
                        // eslint-disable-next-line no-var
                        var valArr = [];
                        $$("#id_" + data + ' input[type="number"]').each(function (el) {
                            valArr.push(el.value);
                        });
                        val = valArr.join(' ');
                    } else {
                        if (!$('input_' + data).value.empty() && !isNaN($('input_' + data).value)) {
                            val = parseFloat($('input_' + data).value);
                        }
                    }
                    break;
                case 'inline':
                    // eslint-disable-next-line no-var
                    var qid = '';
                    // eslint-disable-next-line no-var
                    var fieldID = '';
                    if (data.indexOf('|') > -1) {
                        qid = data.split('|')[0];
                        fieldID = data.split('|')[1];
                        // eslint-disable-next-line no-var
                        var valArr = [];
                        combinedObject = {};
                        // eslint-disable-next-line no-var
                        var TIMESTAMP_OF_2019 = 1546300000000;
                        // eslint-disable-next-line no-var
                        var isDate = false;
                        // eslint-disable-next-line no-var
                        var isTime = false;
                        // eslint-disable-next-line no-var
                        var selector = Number(fieldID) > TIMESTAMP_OF_2019 ? '#id_' + qid + ' input[id*=' + fieldID + '-]' + ', select[id*=' + fieldID + '-]' : '#id_' + qid + ' input[id$=-' + fieldID + ']' + ', select[id$=-' + fieldID + ']'
                        $$(selector).each(function (el) {
                            if (!el.value.empty() && (!(['checkbox', 'radio'].indexOf(el.getAttribute('type')) > -1) || el.checked)) {
                                valArr.push(el.value);
                            }
                            // eslint-disable-next-line no-var
                            var id = el.id.replace(Number(fieldID) > TIMESTAMP_OF_2019 ? /^[^-]*-/ : /-[^-]*$/, '');
                            combinedObject[id] = el.value;
                            // check if calculation is done on a date field
                            if (el && el.parentNode && el.parentNode.getAttribute("data-type") === 'datebox') isDate = true;
                            // check if calculation is done on a time field
                            if (el && el.parentNode.parentNode && el.parentNode.parentNode.getAttribute("data-type") === 'timebox') isTime = true;
                        });
                        val = valArr.join(' ');
                        if (isDate) {
                            // eslint-disable-next-line no-var
                            var date = new Date(combinedObject['year_' + qid + '-date'], combinedObject['month_' + qid + '-date'] - 1, combinedObject['day_' + qid + '-date']);
                            val = date / 60 / 60 / 24 / 1000;
                        }
                        if (isTime) {
                            // eslint-disable-next-line no-var
                            var millis = Date.UTC('1970', '0', '1', combinedObject['hourSelect_' + qid + '_time'],combinedObject['minuteSelect_' + qid + '_time']);
                            val = millis / 60 / 60 / 1000;
                        }
                    } else {
                        qid = data;
                        // eslint-disable-next-line no-var
                        var valArr = [];
                        combinedObject = {};
                        $$("#id_" + qid + ' input[type="text"]').each(function (el) {
                            if (!el.value.empty() && JotForm.isVisible(el)) {
                                valArr.push(el.value);
                            }
                            // eslint-disable-next-line no-var
                            var id = el.id;
                            combinedObject[id] = el.value;

                        });
                        $$("#id_" + qid + ' input[type="tel"]').each(function (el) {
                            if (!el.value.empty() && JotForm.isVisible(el)) {
                                valArr.push(el.value);
                            }
                            // eslint-disable-next-line no-var
                            var id = el.id;
                            combinedObject[id] = el.value;
                        });
                        $$("#id_" + qid + ' input[type="checkbox"]').each(function (chk) {
                            if (chk.checked) {
                                if (typeof FormTranslation !== 'undefined') {
                                    valArr.push(FormTranslation.translate(chk.value));
                                } else {
                                    valArr.push(chk.value);
                                }
                            }
                            // eslint-disable-next-line no-var
                            var id = chk.id;
                            combinedObject[id] = chk.checked ? chk.value : '';
                        });
                        val = valArr.join(' ');
                    }
                    break;
                case 'combined':
                case 'grading':
                    // eslint-disable-next-line no-var
                    var valArr = [];
                    combinedObject = {};
                    $$("#id_" + data + ' input[type="text"]').each(function (el) {
                        if (!el.value.empty()) {
                            valArr.push(el.value);
                        }
                        // eslint-disable-next-line no-var
                        var id = el.id.replace(/_.*/, "");
                        combinedObject[id] = el.value;

                    });
                    $$("#id_" + data + ' input[type="tel"]').each(function (el) {
                        if (!el.value.empty()) {
                            valArr.push(el.value);
                        }
                        // eslint-disable-next-line no-var
                        var id = el.id.replace(/input_[0-9].*_+/, "");
                        combinedObject[id] = el.value;
                    });
                    val = valArr.join(' ');
                    break;

                case 'datetime':
                    // eslint-disable-next-line no-var
                    var valArr = [];
                    if (numeric) {
                        valArr.push($("month_" + data).value);
                        valArr.push($("day_" + data).value);
                        valArr.push($("year_" + data).value);
                        if (!(JotForm.newDefaultTheme || JotForm.extendsNewTheme) || window.FORM_MODE == 'cardform') {
                            $$("#id_" + data + ' select').each(function (el) {
                                valArr.push(el.value);
                            });
                        } else {
                            $$("#id_" + data + ' input,' + "#id_" + data + ' select').each(function (el) {
                                // eslint-disable-next-line no-var
                                var splittedID = el.id.split("_");
                                // eslint-disable-next-line no-var
                                var id = JotForm.isTimeObject(el.id) ? splittedID[splittedID.length - 1] : el.id.replace(/_.*/, "");
                                if (['hourSelect', 'minuteSelect', 'ampm'].indexOf(id) > -1) {
                                    valArr.push(el.value);
                                }
                            });
                        }
                    } else {
                        $$("#id_" + data + ' input[type="tel"]').each(function (el) {
                            valArr.push(el.value);

                            // eslint-disable-next-line no-var
                            var id = el.id.replace(/_.*/, "");
                            combinedObject[id] = el.value;
                        });
                        if (!(JotForm.newDefaultTheme || JotForm.extendsNewTheme) || window.FORM_MODE == 'cardform') {
                            $$("#id_" + data + ' select').each(function (el) {
                                // eslint-disable-next-line no-var
                                var id = el.id.replace(/_.*/, "");
                                combinedObject[id] = el.value;
                                valArr.push(el.value);
                            });
                        } else {
                            $$("#id_" + data + ' input,' + "#id_" + data + ' select').each(function (el) {
                                if (el.id.indexOf('lite') === -1) {
                                    // eslint-disable-next-line no-var
                                    var splittedID = el.id.split("_");
                                    // eslint-disable-next-line no-var
                                    var id = JotForm.isTimeObject(el.id) ? splittedID[splittedID.length - 1] : el.id.replace(/_.*/, "");
                                    combinedObject[id] = el.value;
                                    if (['hourSelect', 'minuteSelect', 'ampm'].indexOf(id) > -1) {
                                        valArr.push(el.value);
                                    }
                                }
                            });
                        }
                    }

                    //if numeric calculation calculate the number of days in epoch
                    if (numeric) {

                        if(!valArr[0].empty() && !valArr[1].empty() && !valArr[2].empty()) {
                            // eslint-disable-next-line no-var
                            var hours = '';
                            // eslint-disable-next-line no-var
                            var mins = '';
                            // eslint-disable-next-line no-var
                            var ampm = '';
                            if (valArr.length > 4 && !valArr[3].empty() && !valArr[4].empty()) {
                                hours = parseInt(valArr[3]);
                                //convert to 24hours
                                if (valArr.length == 6 && !valArr[5].empty()) {
                                    ampm = valArr[5];
                                    if (ampm == 'PM' && hours != 12) {
                                        hours += 12;
                                    } else if (ampm == 'AM' && hours == 12) {
                                        hours = 0;
                                    }
                                }
                                mins = valArr[4];
                            }
                            // eslint-disable-next-line no-var
                            var millis = new Date(valArr[2], valArr[0] - 1, valArr[1], hours, mins).getTime();
                            val = millis / 60 / 60 / 24 / 1000;
                            if(!hours && !mins) {
                                val = Math.ceil(val);
                            }
                        } else {
                            val = 0;
                        }
                    } else {
                        if (valArr.length > 2 && !valArr[0].empty() && !valArr[1].empty() && !valArr[0].empty()) {
                            // eslint-disable-next-line no-var
                            var separator = "-";
                            // eslint-disable-next-line no-var
                            var separatorEl = $$("#id_" + data + " span[class=date-separate]").first();

                            if (separatorEl) {
                                separator = separatorEl.innerHTML.replace(/[^\/\-\.]/g, '');
                            }

                            val = valArr[0] + separator + valArr[1] + separator + valArr[2];
                        }
                        if (valArr.length > 4 && !valArr[3].empty() && !valArr[4].empty()) {
                            val += ' ' + valArr[3] + ':' + valArr[4];
                            if (valArr.length == 6 && !valArr[5].empty()) val += ' ' + valArr[5]; //ampm
                        }
                    }

                    break;

                case 'time':
                    if ($('until_' + data)) {
                        if ($("duration_" + data + "_ampmRange") && !$("duration_" + data + "_ampmRange").value.empty()) {
                            if (numeric) {
                                // eslint-disable-next-line no-var
                                var duration = $("duration_" + data + "_ampmRange").value;
                                if (duration.indexOf(":") > -1) {
                                    // eslint-disable-next-line no-var
                                    var time = duration.split(":");
                                    // eslint-disable-next-line no-var
                                    var hours = time[0] || 0;
                                    // eslint-disable-next-line no-var
                                    var mins = time[1] || 0;
                                    // eslint-disable-next-line no-var
                                    var millis = Date.UTC('1970', '0', '1', hours, mins);
                                    val = millis / 60 / 60 / 1000;
                                }
                            } else {
                                val = $("duration_" + data + "_ampmRange").value;
                            }
                        } else {
                            // eslint-disable-next-line no-var
                            var res = JotForm.displayTimeRangeDuration(data, true);
                            if(res){
                                // eslint-disable-next-line no-var
                                var hours = res[0] || 0;
                                // eslint-disable-next-line no-var
                                var mins = res[1] || 0;
                                // eslint-disable-next-line no-var
                                var millis = Date.UTC('1970', '0', '1', hours, mins);
                                // eslint-disable-next-line no-use-before-define
                                val = numeric ? millis / 60 / 60 / 1000 : (hour + ":" + mins);
                                if(numeric) {
                                    break;
                                }
                            }
                        }

                        if($("duration_" + data + "_ampmRange") && !$("duration_" + data + "_ampmRange").value.empty()) {
                            break;
                        }
                    }

                    // eslint-disable-next-line no-var
                    var valArr = [];
                    combinedObject = {};
                    // eslint-disable-next-line no-var
                    var timeElements = JotForm.newDefaultTheme || JotForm.extendsNewTheme ? "#id_" + data + " select," + "#id_" + data + " input," +", #id_" + data + " input:not(.form-textbox)" : "#id_" + data + " select";

                    if (numeric) {
                        $$(timeElements).each(function (el) {
                            // eslint-disable-next-line no-var
                            var isNDTtimeInput = (JotForm.newDefaultTheme || JotForm.extendsNewTheme) && el.getAttribute('id').indexOf('timeInput') >= 0;
                            if (!isNDTtimeInput) {
                                valArr.push(el.value);
                            }
                        });
                        // eslint-disable-next-line no-var
                        var hour = '';
                        // eslint-disable-next-line no-var
                        var mins = '';
                        // eslint-disable-next-line no-var
                        var ampm = '';
                        hours = parseInt(valArr[0]) || 0;
                        if (valArr.length == 3 && !valArr[2].empty()) {
                            ampm = valArr[2];
                            if (ampm == 'PM' && hours != 12) {
                                hours += 12;
                            } else if (ampm == 'AM' && hours == 12) {
                                hours = 0;
                            }
                        }
                        mins = valArr[1];
                        // eslint-disable-next-line no-var
                        var millis = Date.UTC('1970', '0', '1', hours, mins);
                        val = millis / 60 / 60 / 1000;
                    } else {

                        if ($("input_" + data + "_hourSelect") && !$("input_" + data + "_hourSelect").value.empty() && $("input_" + data + "_minuteSelect") && !$("input_" + data + "_minuteSelect").value.empty()) {
                            val = $("input_" + data + "_hourSelect").value + ":" + $("input_" + data + "_minuteSelect").value;
                            if ($("input_" + data + "_ampm")) {
                                val += " " + $("input_" + data + "_ampm").value;
                            }
                        }

                        if ($("input_" + data + "_hourSelectRange") && !$("input_" + data + "_hourSelectRange").value.empty() && $("input_" + data + "_minuteSelectRange") && !$("input_" + data + "_minuteSelectRange").value.empty()) {
                            val += " - " + $("input_" + data + "_hourSelectRange").value + ":" + $("input_" + data + "_minuteSelectRange").value;
                            if ($("input_" + data + "_ampmRange")) {
                                val += " " + $("input_" + data + "_ampmRange").value;
                            }

                            if ($("duration_" + data + "_ampmRange") && !$("duration_" + data + "_ampmRange").value.empty()) {
                                val += " (" + $("duration_" + data + "_ampmRange").value + ")";
                            }
                        }
                        $$(timeElements).each(function (el) {
                            // eslint-disable-next-line no-var
                            var splittedID = el.id.split("_");
                            // eslint-disable-next-line no-var
                            var id = splittedID[splittedID.length - 1];
                            if (splittedID[0] === 'duration') {
                                id = 'duration-' + id;
                            }
                            combinedObject[id] = el.value;
                        });
                    }
                    break;

                case 'birthdate':
                    // eslint-disable-next-line no-var
                    var valArr = [];
                    if (numeric) {
                        try {
                            // here the selected month value is already a number and not the name of the month, so I commented the two lines below
                            // var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]
                            // var months = monthNames.indexOf($("input_" + data + "_month").value);
                            // eslint-disable-next-line no-var
                            var months = $("input_" + data + "_month").value;
                            // eslint-disable-next-line no-var
                            var days = $("input_" + data + "_day").value;
                            // eslint-disable-next-line no-var
                            var years = $("input_" + data + "_year").value;
                            // eslint-disable-next-line no-var
                            var millis = new Date(years, months ? months - 1 : '', days).getTime();
                            val = Math.ceil(millis / 60 / 60 / 24 / 1000);
                        } catch (e) {
                            console.log("birthdate error");
                            console.log(e);
                        }
                    } else {
                        $$("#id_" + data + ' select').each(function (el) {
                            valArr.push(el.value);
                        });
                        if (!valArr[0].empty() && !valArr[1].empty() && !valArr[2].empty()) {
                            val = valArr[0] + ' ' + valArr[1] + ' ' + valArr[2];
                        }
                    }
                    break;

                case 'address':
                    // eslint-disable-next-line no-var
                    var valArr = [];
                    combinedObject = {};
                    // eslint-disable-next-line no-var
                    var inputSelector = "#id_" + data + (window.FORM_MODE == 'cardform' ? ' .jfField:not(.isHidden)' : '') + ' input[type="text"]:not(.jfDropdown-search)';
                    // eslint-disable-next-line no-var
                    var dropdownSelector = "#id_" + data + (window.FORM_MODE == 'cardform' ? ' .jfField:not(.isHidden)' : '') + ' select';

                    $$(inputSelector).each(function (el) {
                        // eslint-disable-next-line no-var
                        var isDuplicate = false;
                        // Do not use .includes here as IE11 does not support it.
                        if (!el.value.empty() && valArr[0] && valArr[0].indexOf(el.value) > -1){
                            isDuplicate = true;
                        }
                        if (!el.value.empty() && !isDuplicate) {
                            valArr.push(el.value);
                        }
                        // eslint-disable-next-line no-var
                        var id = el.id.replace(/input_[0-9].*?_+/, "");
                        combinedObject[id] = el.value;

                    });
                    $$(dropdownSelector).each(function (el) {
                        // eslint-disable-next-line no-var
                        var isDuplicate = false;
                        if (!el.value.empty() && valArr[0] && valArr[0].includes(el.value)){
                            isDuplicate = true;
                        }
                        if (!el.value.empty() && !isDuplicate) {
                            valArr.push(el.value);
                        }
                        // eslint-disable-next-line no-var
                        var id = el.id.replace(/input_[0-9].*_+/, "");
                        combinedObject[id] = el.value;
                    });
                    val = valArr.join(', ');
                    break;

                case 'file':
                    if ($$('#id_' + data + ' input')[0].readAttribute('multiple') === 'multiple' || $$('#id_' + data + ' input')[0].readAttribute('multiple') === '') {
                        // eslint-disable-next-line no-var
                        var fileList = $('id_' + data).select('.qq-upload-list li');
                        if (fileList.length > 0) {
                            val = fileList.reduce(function(acc, elem) {
                                return (acc ? acc + ', ' : '') + elem.getAttribute('actual-filename');
                            }, '');
                        }
                    } else {
                        val = $('input_' + data).value;
                        val = val.substring(val.lastIndexOf("\\") + 1);
                    }
                    break;

                case 'textarea':
                    if ($('input_' + data) && typeof $('input_' + data).value !== 'undefined') {
                        val = $('input_' + data).value;
                        // eslint-disable-next-line no-var
                        var rich = $('id_' + data).down('.nicEdit-main');
                        if (rich) {
                            val = val.stripTags().replace(/\s/g, ' ').replace(/&nbsp;/g, ' ');
                        }
                    }
                    break;

                case 'widget':
                    // eslint-disable-next-line no-var
                    var widgetType = JotForm.getWidgetType(data);
                    switch(widgetType) {
                        case "timer":
                        case "fancyTimer":
                            if(numeric) {
                                val = $('input_' + data).value;
                            } else {
                                // eslint-disable-next-line no-var
                                var seconds = $('input_' + data).value;
                                // eslint-disable-next-line no-var
                                var minutes = Math.floor(seconds/60);
                                seconds = seconds -  (minutes*60);
                                seconds = JotForm.addZeros(seconds, 2);
                                val = minutes + ":" + seconds;
                            }
                            break;

                        case "configurableList":
                        case "dynMatrix":
                            // eslint-disable-next-line no-var
                            var br = JotForm.calculationType(result) === "html" ? "<br/>" : "\n";
                            // eslint-disable-next-line no-var
                            var json = $('input_' + data).value;
                            if (numeric) {
                              val = 0;
                            }
                            try {
                                json = JSON.parse(json);
                                // eslint-disable-next-line no-var
                                for(var i=0; i<json.length; i++) {
                                    // eslint-disable-next-line no-var
                                    var valArr = [];
                                    // eslint-disable-next-line no-undef
                                    for(line in json[i]) {
                                        // eslint-disable-next-line no-undef
                                        if(!json[i].hasOwnProperty(line)) continue;
                                        // eslint-disable-next-line no-undef
                                        if(!json[i][line].empty()) {
                                          if (numeric) {
                                            // eslint-disable-next-line no-var, no-undef
                                            var isNumber = /^[-]?\d+(\.\d+)?$/.test(json[i][line]);
                                            if (isNumber) {
                                              // eslint-disable-next-line no-undef
                                              val += parseFloat(json[i][line]);
                                            }
                                          } else {
                                            // eslint-disable-next-line no-undef
                                            valArr.push(json[i][line]);
                                          }
                                        }
                                    }
                                    if (valArr.length > 0) {
                                      val += valArr.join(",") + br;
                                    }
                                }
                            } catch(e) {
                                console.log($('input_' + data).value);
                                console.log(calc);
                            }
                            break;

                        case "giftRegistry":
                            val = $('input_' + data).value;
                            if(JotForm.calculationType(result) === "html") {
                                val = val.replace(/\n/g, "<br/>");
                            }
                            break;

                        case "inventory":
                        case "inventoryV2":
                            val = $('input_' + data).value;
                            if (val) {
                                // eslint-disable-next-line no-var
                                var valArr = val.split('\n');
                                val = valArr[0];
                                if (numeric && isNaN(valArr[0])) {
                                    val = valArr[0].match(/ \[(\d+)\]$/)[1];
                                }
                            }
                            break;

                        case "imagelinks":
                        case "links":
                            // eslint-disable-next-line no-var
                            var br = JotForm.calculationType(result) === "html" ? "<br/>" : "\n";
                            // eslint-disable-next-line no-var
                            var json = JSON.parse($('input_' + data).value).widget_metadata.value;
                            // eslint-disable-next-line no-var
                            for(var i=0; i<json.length; i++) {
                                if(json[i].url.replace(/\s/g, "").empty()) continue;
                                // eslint-disable-next-line no-var
                                var showName = json[i].name && !json[i].name.replace(/\s/g, "").empty();
                                if(JotForm.calculationType(result) === "html") {
                                    if(widgetType === "imagelinks") {
                                        val += '<a href="'+json[i].url+'"><img src="'+json[i].url+'" /></a>';
                                    } else {
                                        val += '<a href="'+json[i].url+'">'+(showName ? json[i].name : json[i].url)+'</a>';
                                    }
                                } else {
                                    val += showName ? json[i].name + ": " : "";
                                    val += json[i].url + br;
                                }
                            }
                            break;

                        case "htmltext":
                            // eslint-disable-next-line no-var
                            var b64 =  JSON.parse($('input_' + data).value).widget_metadata.value;
                            val = window.atob ? window.atob(b64) : "";
                            if(JotForm.calculationType(result) !== "html") {
                                val = val.strip().replace(/<br>/g, "\n").stripTags().replace(/&nbsp;/g,' ');
                            }
                            break;

                        case "drivingDistance":
                            val = $('input_' + data).value;
                            if(val.indexOf("Distance") > -1) {
                                // eslint-disable-next-line no-var
                                var matches = val.match(/Distance(.*)/);
                                if (matches.length > 1) {
                                    val = matches[1];
                                }
                            }
                            break;

                        case "pickers":
                            // eslint-disable-next-line no-var
                            var val = $('input_' + data).value;
                            if (numeric && $('customFieldFrame_' + data).src.indexOf('datepicker.html') !== -1) {
                                // eslint-disable-next-line no-var
                                var valArr = val.split("/");
                                // eslint-disable-next-line no-var
                                var millis = Date.UTC(valArr[2], valArr[0] - 1, valArr[1], 0, 0);
                                val = millis / 60 / 60 / 24 / 1000;
                            }
                            break;

                        case "ios7Date":
                            // eslint-disable-next-line no-var
                            var val = $('input_' + data).value;
                            if (numeric && val) {
                              // eslint-disable-next-line no-var
                              var valArr = val.split("/");
                              // eslint-disable-next-line no-var
                              var millis = Date.UTC(valArr[2], valArr[0] - 1, valArr[1], 0, 0);
                              val = millis / 60 / 60 / 24 / 1000;
                            }
                            break;

                        case 'checklist':
                            // eslint-disable-next-line no-var
                            var checked = JotForm.getChecklistWidgetValues(data).checked;
                            return checked;
                        default:
                            val = $('input_' + data).hasAttribute('data-calc') ? $('input_' + data).getAttribute('data-calc') : $('input_' + data).value;
                            break;
                    }

                    break;
                case 'appointment':
                    if (numeric) {
                        // eslint-disable-next-line no-var
                        var value = JotForm.appointments[data].getComparableValue();
                        return value ? new Date(value.replace(/-/g, '/')).getTime() : 0;
                    }

                    // eslint-disable-next-line no-var
                    var selection = $$('#cid_' + data + ' .jsAppointmentValue');
                    // eslint-disable-next-line no-var
                    var val = '';

                    if (!!selection.length) {
                        val = JotForm.calculationType(result) === 'datetime'
                            ? selection[0].dataset.date
                            : selection[0].dataset.calculate;
                    }
                    break;
                default:
                    if ($('input_' + data) && typeof $('input_' + data).value !== 'undefined') {
                        val = $('input_' + data).value;
                    }
                    break;
            }

            if (numeric && typeof val !== 'number') {
              if(useCommasForDecimals) {
                if(/\..*\,/.test(val)) { //dot used as units separator before comma
                  val = val.replace(/\./g, "");
                }
                val = val.replace(",",".");
              }
              val = val.replace(/-?([^0-9])/g, "$1").replace(/[^0-9\.-]/g, "");
            }

            if (numeric && val < 0) { //ntw 343248 - this is to patch a weirdness in the parser whereby x+-y will not parse
              val = '(' + val + ')';
            }

            if (numeric && val === '') {
              val = 0;
            }
            return val;
        };

        // eslint-disable-next-line no-var
        var secondsMS = 1000;
        // eslint-disable-next-line no-var
        var minutesMS = secondsMS * 60;
        // eslint-disable-next-line no-var
        var hoursMS = minutesMS * 60;
        // eslint-disable-next-line no-var
        var daysMS = hoursMS * 24;
        // eslint-disable-next-line no-var
        var weeksMS = daysMS * 7;
        // eslint-disable-next-line no-var
        var monthsMS = daysMS * 30;
        // eslint-disable-next-line no-var
        var yearsMS = daysMS * 365;
        // eslint-disable-next-line no-var
        var copyZero = typeof calc.allowZeroCopy === 'string' ? calc.allowZeroCopy === '1' : calc.allowZeroCopy;

        // eslint-disable-next-line no-var
        var calculate = function (equation, numeric) {
            // eslint-disable-next-line no-var
            var out = '';
            // eslint-disable-next-line no-var
            var acceptableFunctions = {
                "abs": Math.abs,
                "acos": Math.acos,
                "acosh": Math.acosh,
                "asin": Math.asin,
                "asinh": Math.asinh,
                "atan": Math.atan,
                "atanh": Math.atanh,
                "atan2": Math.atan2,
                "cbrt": Math.cbrt,
                "ceil": Math.ceil,
                "cos": Math.cos,
                "cosh": Math.cosh,
                "exp": Math.exp,
                "expm1": Math.expm1,
                "floor": Math.floor,
                "fround": Math.fround,
                "hypot": Math.hypot,
                "imul": Math.imul,
                "log": Math.log,
                "log1p": Math.log1p,
                "log10": Math.log10,
                "log2": Math.log2,
                "max": Math.max,
                "min": Math.min,
                "pow": Math.pow,
                "random": Math.random,
                "round": Math.round,
                "sign": Math.sign,
                "sin": Math.sin,
                "sinh": Math.sinh,
                "sqrt": Math.sqrt,
                "tan": Math.tan,
                "tanh": Math.tanh,
                "toSource": Math.toSource,
                "trunc": Math.trunc,
                "E": Math.E,
                "LN2": Math.LN2,
                "LN10": Math.LN10,
                "LOG2E": Math.LOG2E,
                "LOG10E": Math.LOG10E,
                "PI": Math.PI,
                "SQRT1_2": Math.SQRT1_2,
                "SQRT2": Math.SQRT2,
                "minutes": function (p) {return minutesMS * p},
                "hours": function (p) {return hoursMS * p},
                "days": function (p) {return daysMS * p },
                "weeks": function(p) { return weeksMS * p},
                "months": function(p) { return monthsMS * p},
                "years": function(p) { return yearsMS * p}
            };

            // eslint-disable-next-line no-var
            var getStringDate = function(date) {
                // eslint-disable-next-line no-var
                var monthNames = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
                    // eslint-disable-next-line no-var
                    var dayNames = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
                    // eslint-disable-next-line no-var
                    var day = dayNames[date.getDay()];
                    // eslint-disable-next-line no-var
                    var month = monthNames[date.getMonth()];
                    // eslint-disable-next-line no-var
                    var dayOfMonth = JotForm.addZeros(date.getDate(), 2);
                    // eslint-disable-next-line no-var
                    var year = date.getFullYear();
                    return day+" "+month+" "+dayOfMonth+" "+year;
            };
            // eslint-disable-next-line no-var
            for (var i = 0; i < equation.length; i++) {

                // eslint-disable-next-line no-undef
                character = equation.charAt(i);

                // eslint-disable-next-line no-undef
                if (character === '[' && !numeric) {
                    // eslint-disable-next-line no-var
                    var end = equation.indexOf(']', i);
                    try {
                        // eslint-disable-next-line no-var
                        var num = calculate(equation.substring(i + 1, end), true);
                        if (num) {
                            if (num.indexOf(",") == -1) { //normal calc string
                                // eslint-disable-next-line no-undef
                                num = new MathProcessor().parse(num);
                                if (JotForm.getInputType(calc.resultField) !== "datetime") {
                                    num = JotForm.morePreciseToFixed(num, calc.decimalPlaces);
                                    if (!calc.showEmptyDecimals || calc.showEmptyDecimals == "0") {
                                        num = parseFloat(num);

                                        // if num is decimal, fixed decimal places
                                        if (num % 1 !== 0) {
                                          num = JotForm.morePreciseToFixed(num, calc.decimalPlaces);
                                        }
                                    }
                                }
                                if (!isFinite(num)) {
                                    num = 0;
                                }
                            }
                            if(useCommasForDecimals) {
                                num = num.toString().replace(".", ",");
                            }
                            out += num;
                        }
                    } catch (e) {
                        console.log('exception in ' + calc.conditionId + " : " + num + "(" + equation + ")");
                    }
                    i = end;
                } else if (equation.substr(i, 3) === '|*|') {
                    try {
                        i += 3;
                        // eslint-disable-next-line no-var
                        var end = equation.indexOf('|*|', i);
                        if (end === -1) continue;
                        // eslint-disable-next-line no-var
                        var specOp = equation.substring(i, end);
                        i += end + 2 - i;
                        if (equation.charAt(i + 1) === '(' || (equation.charAt(i + 1) === '[' && equation.charAt(i + 2) === '(')) {
                            i += (equation.charAt(i + 1) === '[') ? 3 : 2;
                            // eslint-disable-next-line no-var
                            var endSpecial = -1;
                            // eslint-disable-next-line no-var
                            var balance = 1;
                            // eslint-disable-next-line no-var
                            for (var k = i; k < equation.length; k++) {
                                if (equation.charAt(k) === ')') {
                                    balance--;
                                    if (balance === 0) {
                                        endSpecial = k;
                                        break;
                                    }
                                } else if (equation.charAt(k) === '(') {
                                    balance++;
                                }
                            }

                            if (endSpecial === -1) continue;
                            // eslint-disable-next-line no-var
                            var args = equation.substring(i, endSpecial);
                            args = args.split(',');
                            // eslint-disable-next-line no-var
                            var originalArgs = args.slice(0);

                            // Check parantheses equality and if it fails then join strings until fixed
                            // eslint-disable-next-line no-var
                            for (var el = 0; el < args.length; el++) {
                                // eslint-disable-next-line no-var
                                var p = 1;
                                while (!JotForm.calcParanthesesBalance(args[el])) {
                                    args[el] = args[el] + ',' + args[el + p];
                                    args[el + p] = '';
                                    p++;
                                }
                            }

                            // let remove empty strings
                            args = args.filter(function (str) { return str !== '' });

                            // eslint-disable-next-line no-var
                            for (var j = 0; j < args.length; j++) {
                                args[j] = calculate(args[j], true);
                                if (args[j]) {
                                    // eslint-disable-next-line no-undef
                                    args[j] = new MathProcessor().parse(args[j]);
                                }
                            }
                            i += endSpecial - i;
                            if (specOp === 'dateString') {
                                // eslint-disable-next-line no-var
                                var baseFieldType = calc.isLabel ? "html" : JotForm.calculationType(calc.baseField);
                                // eslint-disable-next-line no-var
                                var millis =  baseFieldType && baseFieldType === 'appointment' ? args[0] : args[0] * 24 * 60 * 60 * 1000;
                                // eslint-disable-next-line no-var
                                var date = new Date(millis);

                                out += getStringDate(date);

                                if (equation.charAt(i) === ']') {
                                    i++;
                                } else {
                                    equation = equation.substr(0, i + 1) + '[' + equation.substr(i + 1);
                                }
                            } else if (specOp === 'date') {
                                if (args.length > 2) {
                                    // eslint-disable-next-line no-var
                                    var millis = Date.UTC(args[0], args[1] - 1, args[2]);
                                    out += millis / 60 / 60 / 24 / 1000;
                                }
                            } else if (specOp === 'nth') {
                                // eslint-disable-next-line no-var
                                var n = args[0];
                                args = args.splice(1);
                                args = args.sort(function (a, b) {
                                    if (parseFloat(a) > parseFloat(b)) return 1;
                                    if (parseFloat(b) > parseFloat(a)) return -1;
                                    return 0;
                                });
                                args = args.reverse();
                                out += args[parseFloat(n) - 1];
                            } else if (specOp === 'avg' || specOp === 'avgNoZero') {
                                // eslint-disable-next-line no-var, no-undef
                                var len = sum = 0;
                                // eslint-disable-next-line no-var
                                for (var j = 0; j < args.length; j++) {
                                    if (parseFloat(args[j]) > 0) {
                                        len++;
                                        // eslint-disable-next-line no-undef
                                        sum += parseFloat(args[j]);
                                    }
                                }
                                // eslint-disable-next-line no-undef
                                out += specOp === 'avg' ? sum / args.length : sum / len;
                            } else if (specOp === 'count') {
                                // eslint-disable-next-line no-var
                                var field = originalArgs[0];
                                field = field.replace(/[\{\}]/g, '');
                                // eslint-disable-next-line no-var
                                var type = JotForm.getInputType(field);
                                // eslint-disable-next-line no-var
                                var len = $$("#id_" + field + ' input[type="' + type + '"]:checked').length;
                                out += len;
                            } else if (specOp === 'commaSeparate') {
                                if (typeof args[0] == "number") {
                                    args[0] = args[0].toFixed(calc.decimalPlaces);
                                    // eslint-disable-next-line no-var
                                    var parts = args[0].toString().split(".");
                                    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ",");
                                    out += parts.join(".");
                                } else {
                                    out += args[0];
                                }
                            } else if (specOp === 'addDays' || specOp === 'subtractDays') {

                                function isValidDate(d) {
                                    return d instanceof Date && !isNaN(d);
                                }

                                // eslint-disable-next-line no-var
                                var date = isValidDate(new Date(args[0] * 24 * 60 * 60 * 1000)) ? new Date(args[0] * 24 * 60 * 60 * 1000) : new Date(args[0]);
                                date.setHours(0,0,0);
                                date.setMinutes(0,0,0);

                                if(specOp === 'addDays') {
                                    date.setDate(date.getDate() + args[1]);
                                }
                                if(specOp === 'subtractDays') {
                                    date.setDate(date.getDate() - args[1]);
                                }
                                if(!isValidDate(date)) {
                                    return;
                                }
                                if(JotForm.getInputType(calc.resultField) !== "datetime") {
                                    out += getStringDate(date);
                                } else {
                                    out += date.getTime();
                                }
                                return out;
                            } else {
                                // eslint-disable-next-line no-var
                                var tempValue = acceptableFunctions[specOp].apply(undefined, args);

                                if (specOp === 'pow') { // This check can be removed and this fix can be applied to all mathematical functions but I'm not sure yet.
                                    if (typeof BigInt === 'function' && tempValue > Number.MAX_SAFE_INTEGER) { // Only try to use BigInt if the number is bigger than the MAX_SAFE_INTEGER constant.
                                        // eslint-disable-next-line no-undef
                                        tempValue = BigInt(tempValue).toString();
                                    } else if (tempValue < 1 && copyZero) {
                                        tempValue = tempValue.toFixed(calc.decimalPlaces);
                                    } else { /* Leave it as it is. */ }
                                }

                                out += tempValue;
                            }

                        } else if (specOp === 'random') {
                            out += Math.random();
                        } else {
                            out += acceptableFunctions[specOp];
                        }
                    } catch (e) {
                        console.log(e);
                    }
                // eslint-disable-next-line no-undef
                } else if (character === '{') {
                    // eslint-disable-next-line no-var
                    var end = equation.indexOf('}', i);
                    // eslint-disable-next-line no-var
                    var qid = equation.substring(i + 1, end);
                    try {
                        // eslint-disable-next-line no-var
                        var val = getValue(qid, numeric);
                        if (numeric && typeof val !== 'number' && (val.indexOf('(') == -1 && val.indexOf(')') == -1)) {
                            val = Number(val) || 0;
                        }
                    } catch (e) {
                        console.log("error catching value");
                        console.log(e);
                    }
                    if (val === '' && numeric) return false;
                    out += val;

                    i += end - i;
                } else {
                    // eslint-disable-next-line no-undef
                    out += character;
                }
            }
            return out;
        };

        // eslint-disable-next-line no-var
        var output = calculate(calc.equation);
        if (!(typeof output== "string" && output.length > 1) && ((typeof calc.allowZeroCopy === 'string' ? calc.allowZeroCopy !== '1' : !calc.allowZeroCopy) && parseFloat(output) === 0) && $('input_' + result) && ($('input_' + result).readAttribute('defaultValue') != null || $('input_' + result).readAttribute('data-defaultvalue') != null)) {
            output = $('input_' + result).readAttribute('defaultValue') || $('input_' + result).readAttribute('data-defaultvalue');
        }

        JotForm.addEventToDebug({ calculationID: calc.id, sourceField: sourceField instanceof HTMLElement ? sourceField.id : sourceField, sourceEvent, output });

        // eslint-disable-next-line no-var
        var resultFieldType = calc.isLabel ? "html" : JotForm.calculationType(result);

        if(JotForm.ignoreInsertionCondition && JotForm.replaceTagTest && (resultFieldType !== 'html' && resultFieldType !== 'inline')) {
            return;
        }

        switch (resultFieldType) {
            case "inline":
                if (result.indexOf('|') > -1) {
                    // eslint-disable-next-line no-var
                    var idPatcher = { addr_line1: 'streetaddress', addr_line2: 'addressline2', postal: 'zip' };
                    // eslint-disable-next-line no-var
                    var selectFieldId = [ "country" ]; // used for replace the input tag with select tag

                    // eslint-disable-next-line no-var
                    var splitResult = result.split('|');
                    // eslint-disable-next-line no-var
                    var qid = splitResult[0];
                    // eslint-disable-next-line no-var
                    var fieldId = splitResult[1];
                    // eslint-disable-next-line no-var
                    var TIMESTAMP_OF_2019 = 1546300000000;
                    // eslint-disable-next-line no-var
                    var isNewIDType = Number(fieldId) > TIMESTAMP_OF_2019; // old: 1546312345678-firstname / new: firstname-12
                    // eslint-disable-next-line no-var
                    var selector = isNewIDType ? '#id_' + qid + ' input[id*=' + fieldId + '-]' : '#id_' + qid + ' input[id$=-' + fieldId + ']';
                    // eslint-disable-next-line no-var
                    var resultFields = $$(selector);
                    // eslint-disable-next-line no-var
                    var hasCombinedField = false;
                    Object.keys(combinedObject).forEach(function(id) {
                        // eslint-disable-next-line no-var
                        var patchedId = idPatcher[id] ? idPatcher[id] : id;
                        // eslint-disable-next-line no-var
                        var selectInput = selectFieldId.indexOf(patchedId) > -1 ? 'select' : 'input';

                        // eslint-disable-next-line no-var
                        var selector = isNewIDType ? '#id_' + qid + ' input[id*=' + fieldId + '-' + id + ']' : '#id_' + qid + ' ' + selectInput + '[id*=' + patchedId + '][id$=-' + fieldId + ']';
                        // eslint-disable-next-line no-var
                        var visibleFields = $$(selector).filter(function (field) {
                            return JotForm.isVisible(field) || field.id.indexOf('lite_mode' > -1);
                        });
                        if (visibleFields[0] && (isNaN(output) && output.indexOf(combinedObject[id]) > -1)) {
                            hasCombinedField = true;
                            visibleFields[0].value = combinedObject[id];
                            visibleFields[0].triggerEvent('blur');
                        }
                    });
                    if (!hasCombinedField && resultFields[0]) {
                        if (resultFields[0].parentNode.getAttribute("data-type") === "datebox") {
                            // eslint-disable-next-line no-var
                            var date = new Date(output * 60 * 60 * 24 * 1000);
                            JotForm.formatDate({ date: date, dateField: $("lite_mode_" + qid + "-date-" + fieldId) });
                        }
                        else if (resultFields[0].value !== output) {
                            resultFields[0].value = output;
                            resultFields[0].triggerEvent('change');
                        }
                    }
                    break;
                }
            case "html":
                JotForm.runReplaceTag(calc, combinedObject, output, result, resultFieldType);
                break;
            case "address":
            case "authnet":
            case "paypalpro":
            case "combined":
            case "braintree":
            case "stripe":
               // eslint-disable-next-line no-var
               for (var inputId in combinedObject) {
                    if (inputId !== "") {
                        if ($('id_' + result).select('input[id*=' + inputId + '], select[id*=' + inputId + ']').length > 0) {
                            // eslint-disable-next-line no-var
                            var fieldInputElement = $('id_' + result).select('input[id*=' + inputId + '], select[id*=' + inputId + ']').first()
                            if (calc.baseField && $('id_' + calc.baseField).readAttribute('data-type') === "control_fullname") {
                                $('id_' + result).select('input[id*=' + inputId + '], select[id*=' + inputId + ']').each(function (value) {
                                    if (value.readAttribute('data-component') == 'cc_firstName') {
                                        fieldInputElement = value;
                                    }
                                    if (value.readAttribute('data-component') == 'cc_lastName') {
                                        fieldInputElement = value;
                                    }
                                });
                            }
                            fieldInputElement.value = combinedObject[inputId];
                            if(resultFieldType == 'address' &&  window.FORM_MODE == 'cardform'){
                              // eslint-disable-next-line no-var
                              var parentElement = fieldInputElement.parentElement;
                              if (parentElement.querySelector('input')) {
                                parentElement.querySelector('input').value = combinedObject[inputId];
                              } else if (parentElement.querySelector('select')) { // Address fields can have states as dropdown type
                                parentElement.querySelector('select').value = combinedObject[inputId];
                                parentElement.querySelector(".jfDropdown-chip.isSingle").innerText = combinedObject[inputId];
                              }
                            }
                            if (combinedObject[inputId]) {
                              fieldInputElement.parentNode.addClassName('isFilled');
                            }
                        }
                    }
                }
                if ($('input_' + result + '_full') && $('input_' + result + '_full').readAttribute("masked") == "true") { //mask if phone is masked
                    JotForm.setQuestionMasking('#input_' + result + '_full', "textMasking", $('input_' + result + '_full').readAttribute("maskValue"));
                }
                break;
            case "time":
            case "datetime":
                // eslint-disable-next-line no-var
                var setTimeValues = function(date) {
                    // eslint-disable-next-line no-var
                    var hour = date.getHours();
                    // eslint-disable-next-line no-var
                    var minute = JotForm.addZeros(date.getMinutes(), 2);

                    if (!isNaN(hour) && !isNaN(minute)) {
                        // eslint-disable-next-line no-var
                        var ampmField = $('input_'+result+'_ampm') || $('ampm_' + result);
                        if (ampmField) {
                            ampmField.value = hour >= 12 ? 'PM' : 'AM';
                            hour = hour % 12 || 12;
                            ampmField.triggerEvent('change');
                        }

                        // eslint-disable-next-line no-var
                        var hourSelect = $("input_" + result+ "_hourSelect") || $("hour_" + result);
                        if (hourSelect) {
                            if(!ampmField)
                                hour = JotForm.addZeros(hour, 2);
                            hourSelect.value = hour;
                            hourSelect.triggerEvent('change');
                        }

                        // eslint-disable-next-line no-var
                        var minuteSelect = $("input_" + result+ "_minuteSelect") || $("min_" + result);
                        if (minuteSelect) {
                            if (minuteSelect.options) {
                                // eslint-disable-next-line no-var
                                var roundedMinute = '00';
                                // eslint-disable-next-line no-var
                                for(var i = 0; i < minuteSelect.options.length; i++) {
                                    roundedMinute = minuteSelect.options[i].value;
                                    if (minuteSelect.options[i].value >= minute) {
                                        break;
                                    }
                                }
                                minute = roundedMinute;
                            }
                            minuteSelect.value = minute;
                            minuteSelect.triggerEvent('change');
                        }

                        // eslint-disable-next-line no-var
                        var timeInput = $('input_'+result+'_timeInput');
                        if (timeInput) {
                            // eslint-disable-next-line no-var
                            var calculatedHour = hour.toString().length === 1 ? '0' + hour : hour;
                            calculatedHour = calculatedHour == 0 ? '12' : calculatedHour;
                            timeInput.value = calculatedHour+":"+minute;
                            timeInput.triggerEvent('change');
                        }
                    }
                };

                if (combinedObject && "year" in combinedObject || resultFieldType === 'time') {
                    if (output.length === 13) {
                        output = parseFloat(output, 10);
                        // eslint-disable-next-line no-var
                        var date = new Date(output);
                        setTimeValues(date);
                    } else {
                        // eslint-disable-next-line no-var
                        var dateObject = new Date(output);
                        if (dateObject.getTime() && resultFieldType === 'time') {
                            setTimeValues(dateObject);
                        } else {
                            // eslint-disable-next-line no-var
                            for (var inputId in combinedObject) {
                                if (JotForm.isTimeObject(inputId)) {

                                    // eslint-disable-next-line no-var
                                    var ndtTimeQuery = $('id_' + result).select('input[id*=input_' + result + '_' + inputId + '], select[id*=input_' + result + '_' + inputId + ']');
                                    // eslint-disable-next-line no-var
                                    var targetTimeObject = JotForm.newDefaultTheme && ndtTimeQuery.length > 0 ? ndtTimeQuery.first() : '';

                                    // eslint-disable-next-line no-var
                                    var ldtTimeQuery = $('id_' + result).select('input[id*=' + inputId + '], select[id*=' + inputId + ']');
                                    targetTimeObject = !JotForm.newDefaultTheme && ldtTimeQuery.length > 0 ? ldtTimeQuery.first() : targetTimeObject;

                                    // eslint-disable-next-line no-var
                                    var cardFormTimeQuery = $('id_' + result).select('input[id*=' + inputId + '_' + result + '], select[id*=' + inputId + '_' + result + ']');
                                    targetTimeObject = window.FORM_MODE == 'cardform' && cardFormTimeQuery.length > 0 ? cardFormTimeQuery.first() : targetTimeObject;

                                    targetTimeObject.value = combinedObject[inputId];

                                    if(inputId === 'duration-ampmRange') {
                                        // eslint-disable-next-line no-var
                                        var durationSplittedIds = inputId.split("-");
                                        // eslint-disable-next-line no-var
                                        var durationAmpmRangeQuery = $('id_' + result).select('input[id*=' + durationSplittedIds[0] + '_'  + result  + '_' + durationSplittedIds[1] +'], select[id*=' + durationSplittedIds[0] + '_' + result + '_' + durationSplittedIds[1] + ']');
                                        targetTimeObject = JotForm.newDefaultTheme && durationAmpmRangeQuery.length > 0 ? durationAmpmRangeQuery.first() : targetTimeObject;
                                        targetTimeObject.value = combinedObject[inputId];
                                        JotForm.displayTimeRangeDuration(result, false);
                                    }

                                    if (window.FORM_MODE == 'cardform') {
                                        // eslint-disable-next-line no-var
                                        var tempInputID = inputId.indexOf('Range') >= 0 ? inputId.replace('Range', '') + '-range' : inputId;
                                        tempInputID = tempInputID.indexOf('Select') >= 0 ? tempInputID.replace('Select', '') : tempInputID;

                                        // eslint-disable-next-line no-var
                                        var dataType = resultFieldType === 'time' ? 'data-type*="' + 'time-' + tempInputID + '"' : 'data-type*="' + inputId + '"';
                                        // eslint-disable-next-line no-var
                                        var dateQuery = $('id_' + result).select('div[class*=jfField][' + dataType + ']');
                                        // eslint-disable-next-line no-var
                                        for (var i = 0; i < dateQuery.length; i++) {
                                            dateQuery[i].querySelector(".jfDropdown-chip.isSingle").innerText = combinedObject[inputId];
                                        }
                                    }
                                } else {
                                    // eslint-disable-next-line no-var
                                    var dateQuery = $('id_' + result).select('input[id*=' + inputId + '_' + result + '], select[id*=' + inputId + '_' + result + ']');
                                    // eslint-disable-next-line no-var
                                    var targetDateEl = dateQuery.length > 0 ? dateQuery.first() : '';
                                    targetDateEl.value = combinedObject[inputId];
                                }
                            }
                        }
                    }
                } else {
                    try {
                        if ((typeof output == "number" && output > 0) || (typeof output == "string" && output.replace(/\s/g, "").length > 0 && output !== "0")) {
                            if (!isNaN(output)) {
                                if (output.length === 13) {
                                    output = parseFloat(output, 10);
                                } else {
                                    output = Math.round(output * 60 * 60 * 24 * 1000);
                                }
                            }

                            // eslint-disable-next-line no-var
                            var date = new Date(typeof output === 'string' ? output.replace(/(\-|\.)/g, '/') : output);
                            // eslint-disable-next-line no-var
                            var year = date.getFullYear();
                            // eslint-disable-next-line no-var
                            var month = JotForm.addZeros(date.getMonth() + 1, 2);
                            // eslint-disable-next-line no-var
                            var day = JotForm.addZeros(date.getDate(), 2);

                            if ($('input_'+result)) {
                              $('input_'+result).value = year+'-'+month+'-'+day;

                              // set the year, month and date for card forms
                              if (!isNaN(year)) $$('#cid_'+result+' .jfField[data-type="year"] input')[0].value = year;
                              if (!isNaN(month)) $$('#cid_'+result+' .jfField[data-type="month"] input')[0].value = month;
                              if (!isNaN(day)) $$('#cid_'+result+' .jfField[data-type="day"] input')[0].value = day;

                            } else {
                              if (!isNaN(year)) $("year_" + result).value = year;
                              if (!isNaN(month)) $("month_" + result).value = month;
                              if (!isNaN(day)) $("day_" + result).value = day;
                            }

                            setTimeValues(date);
                        }
                    } catch (e) {
                        console.log(e);
                    }
                }
                if ($('lite_mode_' + result)) {
                    // eslint-disable-next-line no-var
                    var date = new Date($("year_" + result).value, ($("month_" + result).value - 1), $("day_" + result).value);
                    if(date.getTime()) {
                        JotForm.formatDate({date: date, dateField: $('id_' + result)});
                    }
                }

                break;
            case "number":
                // eslint-disable-next-line no-var
                var lastCommaIndex = output.lastIndexOf(',');
                if ( lastCommaIndex > -1 && lastCommaIndex === output.length - calc.decimalPlaces - 1) {
                    output = output.substring(0, lastCommaIndex) + "." + output.substring(lastCommaIndex + 1);
                }
                output = output.replace(/[^\-0-9\.]/g, "");
                $('input_' + result).value = output;
                // eslint-disable-next-line no-var
                var parent = $('input_' + result).parentElement;
                if(window.FORM_MODE == 'cardform' && parent && !parent.hasClassName('isFilled')) {
                    parent.addClassName('isFilled');
                }
                break;
            case "radio":
                // eslint-disable-next-line no-var
                var sources = $$('#id_'+calc.operands+' input[type="radio"]:checked');

                // eslint-disable-next-line no-var
                var outputs = sources.length ? sources.collect(function(out){
                    if (out.value){
                        return out.value;
                    }
                }) : output.strip();

                // eslint-disable-next-line no-var
                var radios = $$("#id_" + result + ' input[type="radio"]');
                $A(radios).each(function (rad) {
                    rad.checked = false;
                    if(typeof outputs === 'string') {
                        if (rad.value == output.strip()) {
                            rad.checked = true;
                        }
                    } else {
                        if (rad.value == output.strip() || outputs.include(rad.value)) {
                            rad.checked = true;
                        }
                    }

                });
                break;
            case "checkbox":
                // eslint-disable-next-line no-var
                var sources = $$('#id_'+calc.operands+' input[type="checkbox"]:checked');

                // eslint-disable-next-line no-var
                var outputs = sources.length ? sources.collect(function(out){
                    /**
                     * Check if there is data-calcvalue attribute within the target element
                     */
                    // eslint-disable-next-line no-var
                    var dataCalcValue = out.getAttribute('data-calcvalue')

                    /**
                     * If element has data-calcvalue attribute then return it,
                     * so value of the attribute can be pushed to the array called outputs.
                     * Because outputs array's elements will be used to be checked or unchecked
                     * somewhere in the following lines.
                     */
                    if(dataCalcValue){
                        return dataCalcValue
                    }

                    /**
                     * If element hasn't data-calcvalue,
                     * then use value attribute instead.
                     */
                  return typeof out.value === 'string' ? out.value.strip() : out.value;
                }) : output.strip();

                // eslint-disable-next-line no-var
                var checks = $$("#id_" + result + ' input[type="checkbox"]');

                /* Detect if the base field (which the calculation's term belong to) is a radio field
                    (As we don't want to uncheck everything from the checkbox field when the base is radio)
                If radio:
                        If the calculation is an insertion of the radio field's value ( calc.equation will be like {baseFieldId} )
                            Then collect values of the base inputs into the array calcBaseInputValues
                        Else
                            Get the calculation values of the calculations which has the same base & result fields with calc.
                            Collect those values into the array calcBaseInputValues
                        Filter the checks by using the calcBaseInputValues and assign to variable toBeChecked

                Standart flow with $A(checks).each(function (chk)

                Make the necessary recheckings if there are any.
                */
                // eslint-disable-next-line no-var
                var toBeChecked = [];

                // eslint-disable-next-line no-var
                var calcBaseInputs = $$('[id^=input_'+calc.baseField+'_')
                // eslint-disable-next-line no-var
                var calcBaseIsRadio = calcBaseInputs.length && calcBaseInputs[0].type === 'radio';
                if (calcBaseIsRadio) {
                    // eslint-disable-next-line no-var
                    var calcBaseInputValues = []
                    if ('{'+calc.baseField+'}' === calc.equation) {
                        calcBaseInputValues = calcBaseInputs.map(function(calcBaseInput) {
                            if (calcBaseInput.dataset.calcvalue) {
                                return calcBaseInput.dataset.calcvalue;
                            } else {
                                return calcBaseInput.value;
                            }
                        });
                    } else {
                        // eslint-disable-next-line no-var
                        var tempCalcs = JotForm.calculations;
                        calcBaseInputValues = tempCalcs.filter(function(c) {
                            return c.baseField === calc.baseField && c.resultField === calc.resultField;
                        }).map(function (calcBaseInput) { return calcBaseInput.equation; });
                    }
                    toBeChecked = checks.filter(function(check) { return check.checked === true && !calcBaseInputValues.include(check.value); });
                }

                $A(checks).each(function (chk) {
                    if (!JotForm.defaultValues[chk.id]) {
                        chk.checked = false;
                    }

                    if (typeof outputs === 'string' && calcBaseIsRadio && outputs === chk.value) {
                        /*
                            Make sure to include a check where you not only find if a value contains another value,
                            but also confirm that they are exactly the same.
                            For instance, if you're condition like these options:
                                Radio  "type option1"
                                Checkbox "type option" and "type option1"
                            Currently, two checkboxes are checked
                            In this case, it's important to perform a strict equality check on the strings.
                            Example ticket: #4602084
                        */
                        chk.checked = true;
                    } else {
                        const checkValue = chk.getAttribute('data-calcvalue') || chk.value;
                        if (outputs.include(checkValue)) {
                            chk.checked = true;
                        }
                    }
                });

                toBeChecked.forEach(function(input) { input.checked = true; });
                break;
            case "select":
                 try {
                    // eslint-disable-next-line no-var
                    var source = $$('#id_'+calc.operands+' select');
                    // eslint-disable-next-line no-var
                    var out = (source[0] ? source[0].value : output);
                    /**
                     * Sometimes users can create options with one or more spaces in them.
                     * This code block was malfunctioning in such cases.
                     * Hence, if the string which is the value of the selected option
                     * ends with one or more spaces, those spaces are going to be removed anymore.
                     */
                    // eslint-disable-next-line no-var
                    var stripped = (/\s$/).test(out) ? out.strip() + ' ' : out.strip();
                    if (result.indexOf('|') > 0) {
                        $('input_' + result.split('|').join('_field_')).setValue(stripped);
                    } else {
                        $('input_' + result).setValue(stripped);
                    }
                    break;
                } catch (error) {
                    console.log(error);
                }
            case "matrix":
                if ("resultSubField" in calc) {
                    if ($(calc.resultSubField)) {
                        $(calc.resultSubField).value = output;
                    }
                }
                break;

            case "textarea":
                output = output.replace(/<br>|<br\/>/gi, "\r\n");
                if (output && output.length > 0) {
                    $('input_' + result).removeClassName('form-custom-hint').removeAttribute('spellcheck');
                }
                // eslint-disable-next-line no-var
                var richAreaSelector = window.FORM_MODE == 'cardform' ? "#input_"+result+"_editor" : ".nicEdit-main"
                // eslint-disable-next-line no-var
                var richArea = $("id_" + result).down(richAreaSelector);
                if (richArea) {
                    richArea.innerHTML = output;
                    richArea.setStyle({'color': ''});
                }
                $('input_' + result).value = output;
                break;
            case "mixed":
                if($(mixedResult)) {
                    $(mixedResult).value = output;
                    // eslint-disable-next-line no-var
                    var parent = $(mixedResult).up();
                    if(window.FORM_MODE == 'cardform' && parent && !parent.hasClassName('isFilled')) {
                        parent.addClassName('isFilled');
                    }
                }
                break;
            case "email":
                if ($('input_' + result)) {
                    $('input_' + result).value = output;
                }
                // eslint-disable-next-line no-var
                var parent = $('input_' + result).parentElement;
                if(window.FORM_MODE == 'cardform' && parent && !parent.hasClassName('isFilled')) {
                    parent.addClassName('isFilled');
                }
                break;
            case "appointment":
                // eslint-disable-next-line no-var
                var parsedOutput = calc.conditionTrue ? parseInt(output) : false;

                setTimeout(function() {
                    if (calc.resultFieldProp === 'startdate') {
                        JotForm.appointments[result].forceStartDate(parsedOutput, calc.equation);
                    }

                    if (calc.resultFieldProp === 'enddate') {
                        JotForm.appointments[result].forceEndDate(parsedOutput);
                    }
                }, 100);
                break;
            default:
                try {
                    if ($('input_' + result) && $('input_' + result).hinted === true) { //IE8&9 make sure inserted value is not hinted
                        $('input_' + result).clearHint();
                    }

                    if ($('input_' + result)) {
                        if ((calc.equation === '0' || calc.equation === '[0]') && resultFieldType === 'text') {
                            $('input_' + result).value = '0';
                        } else {
                            $('input_' + result).value = output;
                        }
                    }

                    if ( $('input_' + result) && output && output.length === 0 && $('input_' + result).hintClear) { //IE8&9 if value is empty reapply hint
                        $('input_' + result).hintClear();
                    }

                    if ($('input_' + result) && $('input_' + result).readAttribute("data-masked") == "true") {
                        JotForm.setQuestionMasking("#input_" + result, "textMasking", $('input_' + result).readAttribute("maskValue"));
                    }

                    if (resultFieldType === 'widget') {
                        // eslint-disable-next-line no-var
                        var widgetEl = $('input_' + result);
                        // eslint-disable-next-line no-var
                        var iframe = document.getElementById('customFieldFrame_' + result);
                        if (widgetEl && iframe) {
                            if ($(iframe).hasClassName('frame-xd-ready')) { // the iframe is already loaded
                                widgetEl.fire('widget:populate', { qid: result, value: output });
                                widgetEl.triggerEvent('change');
                                // eslint-disable-next-line no-var
                                var clientID = iframe.getAttribute('data-client-id');
                                JotForm.makeForceReloadWidgets(clientID, result);
                            } else {
                                // wait for iframe to load
                                iframe.addEventListener('load', function() {
                                    widgetEl.fire('widget:populate', { qid: result, value: output });
                                    widgetEl.triggerEvent('change');
                                });
                            }
                        }
                    }

                    break;
                } catch (error) {
                    console.log(error);
                }
        }

        // eslint-disable-next-line no-var
        var infiniteLoop = function () {

            // eslint-disable-next-line no-var
            var checkVal = typeof output === 'object' ? JSON.stringify(output) : output;
            // eslint-disable-next-line no-var
            var checkField = calc.resultSubField||calc.resultField;
            //create global antiLoop variable if not created yet
            if (!("__antiLoopCache" in window)) {
                window.__antiLoopCache = {};
            }
            if (window.__antiLoopCache[checkField] === checkVal) {
                return true;
            }

            window.__antiLoopCache[checkField] = checkVal;

            return false;
        }

        // eslint-disable-next-line no-var
        var calculationInfiniteLoop = function () {
            // eslint-disable-next-line no-var
            var timestamp = new Date().getTime();
            // eslint-disable-next-line no-var
            var msPart = timestamp % 1000;
            if (msPart < 500) {
                msPart = "0";
            } else {
                msPart = "1";
            }
            // eslint-disable-next-line no-var
            var secPart = parseInt(timestamp / 1000);
            // eslint-disable-next-line no-var
            var antiLoopKey = (calc.id || calc.resultField) + '-' + secPart + '-' + msPart;
            // eslint-disable-next-line no-var
            var maxLoopSize = 19;

            window.lastCalculationTimeStamp = window.lastCalculationTimeStamp || new Date().getTime();
            // eslint-disable-next-line no-var
            var betweenLookUp = (timestamp - window.lastCalculationTimeStamp) / 1000;
            if (betweenLookUp > 10) {
                window.__antiCalculationLoopCache = {};
                window.lastCalculationTimeStamp = null;
            }
            if (!("__antiCalculationLoopCache" in window)) {
                window.__antiCalculationLoopCache = {};
            }
            if (antiLoopKey in window.__antiCalculationLoopCache) {
                window.__antiCalculationLoopCache[antiLoopKey]++;
                if (window.__antiCalculationLoopCache[antiLoopKey] > maxLoopSize) {
                    return true;
                }
            } else {
                window.__antiCalculationLoopCache[antiLoopKey] = 1;
            }

            return false;
        }

        const ignoreFields = ['time', 'datetime', 'text'];
        const ignoreFieldsPayment = ignoreFields.slice(0, -1); // text prevents 'get price from' from working #20174771
        const ignoreFieldsList = Boolean(JotForm.payment || window.paymentType) ? ignoreFieldsPayment : ignoreFields;
        const operands = (calc.operands && calc.operands.split(',')) || [];
        const baseFieldsForLoop = (calc.baseField && calc.baseField.split(',')) || [];
        const ignoreFieldCalculationLoopCheck = Boolean(([...baseFieldsForLoop, ...operands]).find(operand => ignoreFieldsList.includes(JotForm.getInputType(operand))));
        const checkCalculationInfiniteLoop = this.loopMapExist || ignoreFieldCalculationLoopCheck;
        if (checkCalculationInfiniteLoop && (infiniteLoop() || calculationInfiniteLoop())) {
            if (JotForm.isConditionDebugMode) {
                // eslint-disable-next-line no-var
                var index = JotForm.calculations.findIndex(val => val === calc);
                console.log({
                    calc: calc,
                    sourceField: sourceField,
                    index
                }, 'IN CHECK CALCULATION');

                if(typeof __conditionDebugger_logStatus === 'function') {
                    // eslint-disable-next-line no-undef
                    __conditionDebugger_logStatus([{
                        title: 'Loop Detected In',
                        value: `Calculation - ${index}`
                    }]);
                }
            }
            return;
        }

        if (!mixedResult && $('id_' + result).hasClassName("form-line-error")) {
            $('id_' + result).select("select[class*='required'], textarea[class*='required'], input[class*='required']").each(function (el) {
                if (el.validateInput) {
                    el.validateInput();
                }
            });
        }

        // eslint-disable-next-line no-var
        var triggerMe;
        // eslint-disable-next-line no-var
        var eventType;

        if (resultFieldType == "checkbox" || resultFieldType == "radio") {
            eventType = "change";
            triggerMe = $('id_' + result)
        } else if (resultFieldType == "select") {
            eventType = "change";
            if (result.indexOf('|') > 0) {
                if ($('input_' + result.split('|').join('_field_'))) {
                    triggerMe = $('input_' + result.split('|').join('_field_'));
                }
            } else {
                if ($('input_' + result)) {
                    triggerMe = $('input_' + result);
                }
            }
        } else if(resultFieldType == "mixed") {
            eventType = "change";
            if(result.indexOf('|') > 0){
                triggerMe = $('input_' + result.split('|').join('_field_'));
            }
        } else if (resultFieldType === 'inline') {
            return;
        }
        else {
            eventType = "keyup";
            if($(mixedResult)) {
                triggerMe = $(mixedResult);
            } else if (!calc.isLabel) {
                triggerMe = $('input_' + result) ? $('input_' + result) : $('id_' + result).select('input').first();
            }
        }

        // eslint-disable-next-line no-var
        var sourceFieldElement = sourceField && $(sourceField);
        // eslint-disable-next-line no-var
        var preventRetriggerItself = sourceEvent && sourceFieldElement && sourceFieldElement.contains(triggerMe) && eventType === sourceEvent;
        if (preventRetriggerItself) return;

        if (!triggerMe) return;
        if (document.createEvent) {
            // eslint-disable-next-line no-var
            var evt = document.createEvent('HTMLEvents');
            evt.initEvent(eventType, true, true);
            triggerMe.dispatchEvent(evt);
        }
        if (triggerMe.fireEvent) {
            triggerMe.fireEvent('on' + eventType);
        }
    },

    // It checks parantheses equality for a given string
    calcParanthesesBalance: function (str) {
        // eslint-disable-next-line no-var
        var openPar = (str.match(/\(/g) || []).length;
        // eslint-disable-next-line no-var
        var closePar = (str.match(/\)/g) || []).length;
        return openPar === closePar;
    },

    getWidgetType: function(qid) {
        try {
            const el = document.querySelector(`#id_${qid}`)
            if (!(el || el.querySelector('iframe'))) return false;
            if(document.querySelector(`#input_${qid}`).value.indexOf("widget_metadata") > 1) {
                return JSON.parse(document.querySelector(`#input_${qid}`).value).widget_metadata.type;
            }
            const iframe = el.querySelector('iframe');
            const src = iframe.src
            const offlineReg = new RegExp('^file://.*/(.*?)/index.html');
            const offlineWidgetMatch = offlineReg.exec(src);
            if (offlineWidgetMatch) {
                return offlineWidgetMatch[1]
            }
            const reg = new RegExp( 'jotform.io/(.*)/');
            const widget = reg.exec(src);
            if(!widget || widget.length < 2 || !widget[1]) return false;
            return widget[1];
        } catch(e) {
            console.error("get widget type error");
            return false;
        }
    },

    widgetsWithConditions: [],

    /**
     * When widget value is updated check whether to trigger conditions
     */
    triggerWidgetCondition: function (id) {
        if (JotForm.widgetsWithConditions.include(id)) {
            if (document.createEvent) {
                // eslint-disable-next-line no-var
                var evt = document.createEvent('HTMLEvents');
                evt.initEvent('change', true, true);
                $('input_' + id).dispatchEvent(evt);
            } else if ($('input_' + id).fireEvent) {
                return $('input_' + id).fireEvent('onchange');
            }
        }
    },

    getChecklistWidgetValues: function (data) {
        // eslint-disable-next-line no-var
        var checkedPrefix = "CHECKED: ";
        // eslint-disable-next-line no-var
        var uncheckedPrefix = "UNCHECKED: ";
        // eslint-disable-next-line no-var
        var val = $('input_' + data).value;
        // eslint-disable-next-line no-var
        var itemLines = val.split(/\r\n|\r|\n/g);
        // eslint-disable-next-line no-var
        var checklistValue = itemLines.reduce(function(result, line) {
            line = line.trim();
            if (line.indexOf(checkedPrefix) === 0) {
                result.checked.push(line.slice(checkedPrefix.length));
            } else if (line.indexOf(uncheckedPrefix) === 0) {
                result.unchecked.push(line.slice(uncheckedPrefix.length));
            } else {
                result.checked.push(line);
            }
            return result;
        }, { checked: [], unchecked: [] });
        return checklistValue;
    },

    getFieldIdFromFieldRef: function(ref) {
        try {
            if (typeof ref === "string" && ref.indexOf("{") > -1 && ref.indexOf("}") > -1) {
                const stripped = ref.strip().replace(/[\{\}]/g, "");
                let inputs = document.querySelectorAll('input[name*="_' + stripped + '["\],select[name*="_' + stripped + '\["]')
                if(!inputs || inputs.length == 0) {
                    inputs = document.querySelectorAll('input[name*="_' + stripped + '"],select[name*="_' + stripped + '"]');
                }
                if(inputs.length > 0) {
                    const field = inputs[0].closest(".form-line");
                    if(field) {
                        return field.id.replace(/.*id_/,"");
                    }
                }
            }
        } catch(e) {
            console.log(e);
        }
        return false;
    },

    /**
     * Sets all events and actions for form conditions
     */
    setConditionEvents: function () {
        // Debounce timers for condition checking to improve performance
        const conditionDebounceTimers = {};
        const CONDITION_DEBOUNCE_DELAY = 200; // milliseconds
        // Only use debounce for specific enterprise user

        const useDebounce = window.JotForm.enterprise === "eel.jotform.com";
        try {
            $A(JotForm.conditions).each(function (condition) {

                if (condition.disabled == true) return; //go to next condition

                if (condition.type == 'field' || condition.type == 'calculation' || condition.type == 'require' || condition.type == 'mask'
                    || ($A(condition.action).length > 0 && condition.action.first().skipHide === 'hidePage')) {

                    // eslint-disable-next-line no-var
                    var fields = [];
                    // eslint-disable-next-line no-var
                    var keys = {};
                    $A(condition.terms).each(function (term) {
                      term.field = String(term.field);
                      if (typeof term.value === 'boolean') {
                          term.value = String(term.value);
                      }
                      // eslint-disable-next-line no-var
                      var tempField = '';
                      if (term.field.indexOf('|') > -1) {
                        // eslint-disable-next-line no-var
                        var fieldSplit = term.field.split( '|' );
                        if ($('id_' + fieldSplit[0]) && $('id_' + fieldSplit[0]).readAttribute('data-type') == "control_inline") {
                            tempField = term.field;
                        } else {
                            tempField = fieldSplit[0] + '_field_' + fieldSplit[1];
                        }
                      } else {
                        tempField = term.field;
                      }
                        // eslint-disable-next-line no-var
                        var key = term.operator + '|' + term.field;
                        if (!keys[key]) {
                          keys[key] = true;
                          fields.push(tempField);
                        }
                        // eslint-disable-next-line no-var
                        var otherFieldRef = JotForm.getFieldIdFromFieldRef(term.value)
                        if(otherFieldRef) {
                            fields.push(otherFieldRef);
                        }
                    });

                    $A(fields).each(function (id) {
                        // eslint-disable-next-line no-var
                        var inputTypeTemp = JotForm.getInputType(id);
                        switch (inputTypeTemp) {
                            case "widget":
                            case "signature":
                                JotForm.setFieldConditions('input_' + id, 'change', condition);
                                JotForm.widgetsWithConditions.push(id);
                                break;
                            case "combined":
                            case "email":
                                if (id.indexOf('_field_') > -1) {
                                  JotForm.setFieldConditions('input_' + id, 'autofill', condition);
                                } else {
                                  JotForm.setFieldConditions('id_' + id, 'autofill', condition);
                                }
                                break;
                            case "address":
                                JotForm.setFieldConditions('id_' + id, 'autofill', condition);
                                JotForm.setFieldConditions('input_' + id + '_country', 'change', condition);
                                JotForm.setFieldConditions('input_' + id + '_state', 'change', condition);
                                break;
                            case "datetime":
                                JotForm.setFieldConditions('id_' + id, 'date:changed', condition);
                                break;
                            case "birthdate":
                                JotForm.setFieldConditions('input_' + id + '_day', 'change', condition);
                                JotForm.setFieldConditions('input_' + id + '_month', 'change', condition);
                                JotForm.setFieldConditions('input_' + id + '_year', 'change', condition);
                                break;
                            case "time":
                                JotForm.setFieldConditions('input_' + id + '_hourSelect', 'change', condition);
                                JotForm.setFieldConditions('input_' + id + '_minuteSelect', 'change', condition);
                                JotForm.setFieldConditions('input_' + id + '_ampm', 'change', condition);
                            case "select":
                            case "file":
                                if ($('input_' + id)) {
                                    JotForm.setFieldConditions('input_' + id, 'change', condition);
                                } else {
                                    $('id_' + id).select('select').each(function (el) {
                                        JotForm.setFieldConditions(el.id, 'change', condition);
                                    });
                                }
                                break;
                            case "checkbox":
                            case "radio":
                                JotForm.setFieldConditions('id_' + id, 'change', condition);
                                break;
                            case "number":
                                JotForm.setFieldConditions('input_' + id, 'number', condition);
                                break;
                            case "autocomplete": // Neil: Set custom event for autocomplete fields (classname: "form-autocomplete")
                                JotForm.setFieldConditions('input_' + id, 'autocomplete', condition);
                                break;
                            case "grading":
                                JotForm.setFieldConditions('id_' + id, 'keyup', condition);
                                break;
                            case "text":
                            case "textarea":
                                JotForm.setFieldConditions('input_' + id, 'autofill', condition);
                                break;
                            case "hidden":
                                if ($('input_' + id + "_donation")) {
                                    JotForm.setFieldConditions('input_' + id + "_donation", 'keyup', condition);
                                } else {
                                    JotForm.setFieldConditions('input_' + id, 'keyup', condition);
                                }
                                break;
                            case "mixed":
                                if (id.indexOf('_field_') > -1) {
                                    // eslint-disable-next-line no-var
                                    var idSplit = id.split('_field_');
                                    // eslint-disable-next-line no-var
                                    var tempQid = idSplit[0];
                                    // eslint-disable-next-line no-var
                                    var tempQuestion;
                                    // If we can
                                    this.CardLayout.layoutParams.allQuestions.forEach(function (question) {
                                        if (question.id == tempQid) {
                                          tempQuestion = question;
                                        }
                                    });
                                    if (tempQuestion && tempQuestion.fields) {
                                        tempQuestion.fields.forEach( function (field) {
                                        // eslint-disable-next-line no-var
                                        var tempSelector = 'input_' + tempQid + '_field_' + field.fieldID;
                                          JotForm.setFieldConditions(tempSelector, 'change', condition);
                                          JotForm.widgetsWithConditions.push(tempSelector);
                                        });
                                    }
                                }
                              break;
                            case "inline":
                                // eslint-disable-next-line no-var
                                var fieldSplit = id.split('|');
                                // eslint-disable-next-line no-var
                                var qid = fieldSplit[0];
                                // eslint-disable-next-line no-var
                                var tempSelector = 'id_' + qid;
                                JotForm.setFieldConditions(tempSelector, 'change', condition);
                                break;
                            default: // text, textarea, dropdown
                                JotForm.setFieldConditions('input_' + id, 'keyup', condition);
                        }
                    });

                } else {
                    $A(condition.terms).each(function (term) {
                        // eslint-disable-next-line no-var
                        var id = term.field.toString();

                        // if this is a product quantity option (e.g. 4_quantity_1009_0)
                        if (id.indexOf("_") !== -1) {
                            id = id.split("_")[0];
                        }

                        // if element is a multiline
                        if (id.indexOf("|") !== -1) {
                          id = id.split("|")[0];
                        }

                        if(!$('id_' + id)) {
                            return;
                        }

                        // eslint-disable-next-line no-var
                        var nextButton;
                        if(window.FORM_MODE === 'cardform') {
                          nextButton = $('id_' + id).select('.forNext')[0];
                        } else {
                          nextButton = JotForm.getSection($('id_' + id)).select('.form-pagebreak-next')[0];
                        }

                        if (!nextButton) {
                            return;
                        }

                        nextButton.observe('mousedown', function () {
                            // JotForm.warn('Checking ' + $('label_' + id).innerHTML.strip());
                            if (useDebounce) {
                                const timerKey = nextButton.id + '_mousedown_' + condition.id;
                                clearTimeout(conditionDebounceTimers[timerKey]);
                                conditionDebounceTimers[timerKey] = setTimeout(function() {
                                    JotForm.checkCondition(condition, nextButton.id, 'mousedown');
                                }, CONDITION_DEBOUNCE_DELAY);
                            } else {
                                JotForm.checkCondition(condition, nextButton.id, 'mousedown');
                            }
                        });
                    });
                }
            });

            $H(JotForm.fieldConditions).each(function (pair) {
                // eslint-disable-next-line no-var
                var field = pair.key;
                // eslint-disable-next-line no-var
                var event = pair.value.event;
                // eslint-disable-next-line no-var
                var conds = pair.value.conditions;

                // JotForm.info("Has Condition:", field, $(field));
                // If field is not found then continue
                if (!$(field)) {
                    return;
                }
                if (event == "autocomplete") { // if event type is trigger by autocomplete, listen to blur and keyup events
                    $(field).observe('blur', function () {
                        if (useDebounce) {
                            const timerKey = field + '_blur';
                            clearTimeout(conditionDebounceTimers[timerKey]);
                            conditionDebounceTimers[timerKey] = setTimeout(function() {
                                $A(conds).each(function (cond) {
                                    JotForm.checkCondition(cond, field, 'blur');
                                });
                            }, CONDITION_DEBOUNCE_DELAY);
                        } else {
                            $A(conds).each(function (cond) {
                                JotForm.checkCondition(cond, field, 'blur');
                            });
                        }
                    }).run('blur');
                    $(field).observe('keyup', function () {
                        if (useDebounce) {
                            const timerKey = field + '_keyup';
                            clearTimeout(conditionDebounceTimers[timerKey]);
                            conditionDebounceTimers[timerKey] = setTimeout(function() {
                                $A(conds).each(function (cond) {
                                    JotForm.checkCondition(cond, field, 'keyup');
                                });
                            }, CONDITION_DEBOUNCE_DELAY);
                        } else {
                            $A(conds).each(function (cond) {
                                JotForm.checkCondition(cond, field, 'keyup');
                            });
                        }
                    }).run('keyup');
                } else if (event == "number") {
                    $(field).observe('change', function () {
                        if (useDebounce) {
                            const timerKey = field + '_change';
                            clearTimeout(conditionDebounceTimers[timerKey]);
                            conditionDebounceTimers[timerKey] = setTimeout(function() {
                                $A(conds).each(function (cond) {
                                    JotForm.checkCondition(cond, field, 'change');
                                });
                            }, CONDITION_DEBOUNCE_DELAY);
                        } else {
                            $A(conds).each(function (cond) {
                                JotForm.checkCondition(cond, field, 'change');
                            });
                        }
                    }).run('change');
                    $(field).observe('keyup', function () {
                        if (useDebounce) {
                            const timerKey = field + '_keyup';
                            clearTimeout(conditionDebounceTimers[timerKey]);
                            conditionDebounceTimers[timerKey] = setTimeout(function() {
                                $A(conds).each(function (cond) {
                                    JotForm.checkCondition(cond, field, 'keyup');
                                });
                            }, CONDITION_DEBOUNCE_DELAY);
                        } else {
                            $A(conds).each(function (cond) {
                                JotForm.checkCondition(cond, field, 'keyup');
                            });
                        }
                    }).run('keyup');
                } else if (event == "autofill") {
                    $(field).observe('blur', function () {
                        if (useDebounce) {
                            const timerKey = field + '_blur';
                            clearTimeout(conditionDebounceTimers[timerKey]);
                            conditionDebounceTimers[timerKey] = setTimeout(function() {
                                $A(conds).each(function (cond) {
                                    JotForm.checkCondition(cond, field, 'blur');
                                });
                            }, CONDITION_DEBOUNCE_DELAY);
                        } else {
                            $A(conds).each(function (cond) {
                                JotForm.checkCondition(cond, field, 'blur');
                            });
                        }
                    }).run('blur');
                    $(field).observe('keyup', function () {
                        if (useDebounce) {
                            const timerKey = field + '_keyup';
                            clearTimeout(conditionDebounceTimers[timerKey]);
                            conditionDebounceTimers[timerKey] = setTimeout(function() {
                                $A(conds).each(function (cond) {
                                    JotForm.checkCondition(cond, field, 'keyup');
                                });
                            }, CONDITION_DEBOUNCE_DELAY);
                        } else {
                            $A(conds).each(function (cond) {
                                JotForm.checkCondition(cond, field, 'keyup');
                            });
                        }
                    }).run('keyup');

                    if (!(!Prototype.Browser.IE9 && !Prototype.Browser.IE10 && Prototype.Browser.IE)) {
                        $(field).observe('change', function () {
                            if (useDebounce) {
                                const timerKey = field + '_change';
                                clearTimeout(conditionDebounceTimers[timerKey]);
                                conditionDebounceTimers[timerKey] = setTimeout(function() {
                                    $A(conds).each(function (cond) {
                                        JotForm.checkCondition(cond, field, 'change');
                                    });
                                }, CONDITION_DEBOUNCE_DELAY);
                            } else {
                                $A(conds).each(function (cond) {
                                    JotForm.checkCondition(cond, field, 'change');
                                });
                            }
                        }).run('change');
                    }
                } else {
                    $(field).observe(event, function () {
                        if (useDebounce) {
                            // Debounce condition checking for better performance
                            const timerKey = field + '_' + event;
                            clearTimeout(conditionDebounceTimers[timerKey]);
                            conditionDebounceTimers[timerKey] = setTimeout(function() {
                                $A(conds).each(function (cond) {
                                    JotForm.checkCondition(cond, field, event);
                                });
                            }, CONDITION_DEBOUNCE_DELAY);
                        } else {
                            $A(conds).each(function (cond) {
                                JotForm.checkCondition(cond, field, event);
                            });
                        }
                    });
                    if (!$(field).id.match(/input_[0-9]+_quantity_[0-9]+_[0-9]+/)) { // b#652068 (do not auto-run condition events on quantity fields)
                        $(field).run(event);
                    } else {
                        JotForm.runConditionForId(field.replace('input_', ''));
                    }
                }
            });
        } catch (e) {
            JotForm.error(e);
        }
    },

    /**
     * Sets field values to be duplicated before encryption
     * These fields are needed by some payment gateways, integrations, and email-type conditions
     * for example, braintree gets the first email field on the form
     * but it should be unencrypted, so we duplicate the original value
     * before encryption (at JotForm.encryptAll)
     */

    setFieldsToPreserve: function (preset) {

        // gateways that need these fields
        const gateways = [
            "braintree",
            "dwolla",
            "stripe",
            "paypal",
            "paypalpro",
            "paypalexpress",
            "authnet"
        ];


        const paymentElements = document.querySelectorAll('input[name="simple_fpc"]')
        const getPaymentFields = paymentElements.length > 0 && gateways.indexOf(paymentElements[0].getAttribute('data-payment_type')) > -1;
        const paymentExtras = [{
            type: "phone",
            pattern: /Phone|Contact/i
        }, {
            type: "email",
            pattern: /email|mail|e-mail/i
        }, {
            type: "company",
            pattern: /company|organization/i
        }];

        const eligibleFields = document.querySelectorAll('.form-line[data-type*="email"],' +
            '.form-line[data-type*="textbox"],' +
            '.form-line[data-type*="phone"],' +
            '.form-line[data-type*="dropdown"],' +
            '.form-line[data-type*="radio"]');
        // arrange all fields by id
        const sortedFields = Array.from(eligibleFields).sort(function (a, b) {
            return Number(a.id.replace("id_", "")) - Number(b.id.replace("id_", ""));
        });

        const paymentFieldsToPreserve = {}; // holder for payment fields (max 3; see paymentExtras)
        // collect fields whose values need to be duplicated prior to encryption
        sortedFields.forEach(function (field) {
            const fieldId = field.id.replace('id_', '');
            const fieldName = field.querySelector('input, select').name.replace(/q\d+_/, "");
            const fieldType = field.getAttribute('data-type').replace('control_', '');
            // find and match payment extras (total of 3; email, phone, company)
            if (getPaymentFields && Object.keys(paymentFieldsToPreserve).length < 3) {
                paymentExtras.forEach(function (extra) {
                    /*
                     valid form field type
                     email =>  email and textbox
                     phone =>  phone field and textbox
                     company => textbox only
                     */
                    if (fieldType == 'textbox' || fieldType == extra.type) {
                        const label = field.querySelector('label').innerHTML.strip();
                        if (extra.pattern.exec(label) && !paymentFieldsToPreserve[extra.type]) {
                            paymentFieldsToPreserve[extra.type] = fieldId;
                            if (JotForm.fieldsToPreserve.indexOf(fieldId) === -1) {
                                JotForm.fieldsToPreserve.push(fieldId);
                            }
                        }
                    }
                });
            }
            // preset is an array of question ids and/or question names set at build_source.js
            // if it matches eligible fields on the form, add it to the list
            if (preset && JotForm.fieldsToPreserve.indexOf(fieldId)
                && (preset.indexOf(fieldName) > -1 || preset.indexOf(fieldId) > -1))
            {
                JotForm.fieldsToPreserve.push(fieldId);
            }
        });
    },

    /**
     * Changes payment strings upon form load
     * @param {type} text
     * @returns {undefined}
     */

    changePaymentStrings: function (text) {
        const couponHeader = document.querySelector('#coupon-header');
        const shippingText = document.querySelector('#shipping-text');
        const taxText = document.querySelector('#tax-text');
        const subTotalText = document.querySelector('#subtotal-text');
        const totalText = document.querySelector('#total-text');
        if (couponHeader && text.couponEnter) {
            couponHeader.innerHTML = text.couponEnter;
        }
        if (shippingText && text.shippingShipping) {
            shippingText.innerHTML = text.shippingShipping;
        }
        if (taxText && text.taxTax) {
            taxText.innerHTML = text.taxTax;
        }
        if (subTotalText && text.totalSubtotal) {
            subTotalText.innerHTML = text.totalSubtotal;
        }
        if (totalText && text.totalTotal) {
            totalText.innerHTML = text.totalTotal ;
        }
    },

    handleSubscriptionPrice: function () {
        // safari fix (input focus bug)
        if (navigator.userAgent.toLowerCase().indexOf('safari/') > -1) {
            document.querySelectorAll('.form-product-custom_price').forEach(function (inp) {
                // form-product-custom_price
                inp.onclick = function (e) {
                    e.preventDefault();
                };
            })
        }
        const inputs = document.querySelectorAll('input[data-price-source]');
        if (inputs.length < 1) {
            return;
        }
        const priceSources = [];
        const events = {};
        inputs.forEach(function (inp) {
            // eslint-disable-next-line no-var
            var sourceId = inp.getAttribute('data-price-source');

            // eslint-disable-next-line no-var
            var source = document.querySelector('#input_' + sourceId);
            if (!source) {
                return;
            }

            if (!events[sourceId]) {
                events[sourceId] = [];
            }

            const getVal = function () {
                let val = source.value;
                if (typeof val !== 'number') {
                    val = val.replace(/[^0-9\.]/gi, "");
                }
                return !isNaN(val) && val > 0 ? val : 0;
            }
            // collect source fields
            priceSources.push(source);

            // collect events
            events[sourceId].push(function() {
                inp.value = getVal();
            });
        });

        // attach events to source fields
        priceSources.forEach(function (source) {
            const id = source.id.replace('input_', '');
            source.onkeyup = function () {
                events[id].forEach(function (evt) {
                    evt();
                });
                JotForm.countTotal(); // re-count total
            };

        });
    },
    /*
     * Handle subscription payment custom price field
     */
    validateCustomPriceField: function () {
        // eslint-disable-next-line no-var
        var customPrice = document.querySelectorAll('input[id*="_custom_price"]');
        if (customPrice && customPrice.length > 0) {
            customPrice.forEach(function (element) {
                // eslint-disable-next-line no-var
                var preventChangeReadonly = element.hasAttribute('readonly') || false;
                element.addEventListener('input', function () {
                    if (preventChangeReadonly) {
                        return;
                    }
                });
                if (preventChangeReadonly) {
                    element.addEventListener('keydown', function () {
                        element.readOnly = true;
                    });
                }
            });
        }
    },
    /*
     * Handles payment donations
     */

    handleDonationAmount: function () {
        // donation amount input
        // eslint-disable-next-line no-var
        var donationField = JotForm.donationField = document.querySelector('input[id*="_donation"]');
        const preventChangeReadonly = donationField.hasAttribute('readonly') || false;
        // default
        JotForm.paymentTotal = donationField.value || 0;
        // observe changes
        // eslint-disable-next-line no-var
        var prevInput = '';
        // predefined options in cardform
        if (window.FORM_MODE === "cardform") {
            // eslint-disable-next-line no-var
            var donationPredefinedRadios =  document.querySelectorAll('input[class*="js-donation-suggestion"]');
            donationPredefinedRadios.forEach(function(radio) {
                radio.addEventListener('click', function (e) {
                    JotForm.paymentTotal = e.target.value;
                })
            })
        }
        // // prevent price autofilling in donations after back navigation
        // if(performance?.getEntriesByType && performance.getEntriesByType("navigation")[0]?.type === 'back_forward'){
        //     donationField.setAttribute('autocomplete', 'off');
        //     donationPredefinedRadios && donationPredefinedRadios.forEach( function(e){
        //         e.setAttribute('autocomplete', 'off')
        //     })
        // }
        donationField.addEventListener('input', function () {
            // eslint-disable-next-line no-var
            var donationRegex = new RegExp(/^([0-9]{0,15})(\.[0-9]{0,2})?$/);
            if (preventChangeReadonly) return;
            if (this.value.match(donationRegex)) {
                JotForm.paymentTotal = prevInput = this.value;
            } else {
                JotForm.paymentTotal = this.value = prevInput;
            }
        });
        // if change readonly from inspect, it will activate readonly again
        if (preventChangeReadonly){
            donationField.addEventListener('keydown', function () {
                donationField.readOnly = true;
            });
        }
        // if donation gets its amount from a calculation widget
        if (donationField.getAttribute('data-custom-amount-field') > 0) {
            JotForm.donationSourceField = document.querySelector(`#input_${donationField.getAttribute('data-custom-amount-field')}`);
            // if calculation widget does not exist
            if (!JotForm.donationSourceField) {
                donationField.removeAttribute('readonly');
                return;
            }
            // get value from calculation widget
            setTimeout(function () {
                JotForm.updateDonationAmount();
                donationField.triggerEvent('keyup');
            }, 1000);
            // observe calc widget value changes
            JotForm.donationSourceField.addEventListener('keyup', JotForm.updateDonationAmount);
            JotForm.donationSourceField.addEventListener('change', JotForm.updateDonationAmount);
        // if donation field requires a minimum amount
        } else if (donationField.hasAttribute('data-min-amount')) {
            // eslint-disable-next-line no-var
            var currency = donationField.nextSibling.textContent.strip();
            // eslint-disable-next-line no-var
            var minAmount = parseFloat(donationField.readAttribute('data-min-amount'));
            donationField.validateMinimum = function () { // called at setFieldValidation
                // eslint-disable-next-line no-var
                var val = this.getValue();
                if (isNaN(val) || val < minAmount) {
                    // eslint-disable-next-line no-var
                    var errorTxt = JotForm.texts.ccDonationMinLimitError.replace('{minAmount}', minAmount).replace('{currency}', currency);
                    return JotForm.errored(donationField, errorTxt);
                } else {
                    return JotForm.corrected(donationField);
                }
            };
        }
    },

    /**
     * Updates donation with a specified amount or amount taken from source field (calculation widget)
     * @param amount
     */
    updateDonationAmount: function (amount) {
        if (!JotForm.donationSourceField // source field is missing
            || JotForm.donationField.closest('.form-line.form-field-hidden') // skip if hidden by condition; it will be updated when shown again (JotForm.showField)
            || JotForm.donationField.closest('ul.form-field-hidden'))
        { return; }
        // amount is specified
        if (!['undefined', 'object'].includes(typeof amount)) {
            JotForm.donationField.value = JotForm.paymentTotal = amount;
            return;
        }
        const getVal = function () {
            let val = JotForm.donationSourceField.value;

            const sourceField = JotForm.calculations.find(function(c){
                return c.resultField === JotForm.donationSourceField.id.split("_")[1];
            });

            if (sourceField && sourceField.useCommasForDecimals === "1"){
                val = val.replace(",",".");
            }

            if (typeof val !== 'number') {
                val = val.replace(/[^0-9\.]/gi, "");

                // put only two decimal points if there is more
                if (val !== '') {
                    try {
                        val = val.match(/^([0-9]{1,15})(?:\.(\d{0,2}))?/)[0];
                    } catch (error) {
                        console.log('Error from "Get Price From" on donation input:', error);
                    }
                }
            }
            return !isNaN(val) && val > 0 ? val : 0;
        }
        JotForm.donationField.value = JotForm.paymentTotal = getVal();

        if(window.FORM_MODE && window.FORM_MODE == 'cardform') {
            JotForm.donationField.parentNode.addClassName('isFilled');
        }
    },

    /**
     * New Product UI
     * Will be removed after requirement completed
     */
    isComparePaymentFormV1: function() {
        // eslint-disable-next-line no-var
        var queryParameters = window.location.search.substring(1);
        return queryParameters === "comparePaymentForm=v1" ? true : false;
    },

    /**
     * Checks whether form should process a payment
     * @returns {Boolean}
     */

    isPaymentSelected: function () {
        // eslint-disable-next-line no-var
        var selected = false;
        // eslint-disable-next-line no-var
        var inputSimpleFpc = document.querySelector('input[name="simple_fpc"]');
        // eslint-disable-next-line no-var
        var paymentFieldId = inputSimpleFpc && inputSimpleFpc.value;
        // eslint-disable-next-line no-var
        var paymentField = $('id_' + paymentFieldId);

        if (!paymentField) {
            // should return true if it's a hidden single product
            // see showSingle property for payment field (v4-fields)
            return !!inputSimpleFpc;
        }

        if (paymentField.hasClassName('form-field-hidden')
            || paymentField.up('ul.form-section').hasClassName('form-field-hidden')
            // In case section that contains payment field is hidden/shown conditionally.
            // This case should have been handled in the `if` below but JotForm.getSection skips
            // sections that have id starting with "section_".
            || (paymentField.up('ul.form-section-closed') &&
                paymentField.up('ul.form-section-closed').hasClassName('form-field-hidden')))
        {
            return false;
        }

        if (!inputSimpleFpc) {
            return false;
        }
        // if with payment field but hidden by condition
        // or inside conditionally-hidden (not collapsed) form collapse section
        if (paymentField && (paymentField.getStyle('display') === "none"
            || !JotForm.isVisible(paymentField) && JotForm.getSection(paymentField).id)
        ) {
            return false;
        }

        // Jotform Store Builder selected product control
        if (window.paymentType === 'product' && (window.JFAppsManager && window.JFAppsManager.checkoutKey && window.JFAppsManager.cartProductItemCount > 0)) {
            return true;
        }

        // if this is a multi-item product or subscription
        if (window.productID) {
            // check if at least one product is selected
            $H(window.productID).each(function (pair) {
                // eslint-disable-next-line no-var
                var elem = $(pair.value);
                if (elem && elem.checked) {
                    // get quantity field/s
                    // eslint-disable-next-line no-var
                    var quantityField = elem.up().select('select[id*="_quantity_"],input[id*="_quantity_"]');
                    // if no quantity option or quantity is selected
                    selected = quantityField.length === 0 || (quantityField.length === 1 && quantityField[0].getValue() > 0);
                    // if payment has subproducts
                    if (quantityField.length > 1) {
                        selected = quantityField.any(function (qty) {
                            return qty.getValue() > 0;
                        });
                    }
                    if (selected) { throw $break; }
                }
            });
            // if this is a donation
        } else if ($('input_' + paymentFieldId + '_donation')) {
            // eslint-disable-next-line no-var
            var elem = $('input_' + paymentFieldId + '_donation');
            if (/^\d+(?:\.\d+)?$/.test(elem.getValue())) {
                selected = elem.getValue() > 0;
            }
            // if this is a hidden single item
        } else {

            // eslint-disable-next-line no-var
            var productField = $$('input[name*="q' + paymentFieldId + '"][type="hidden"]');

            if (productField.length < 1) {
                return false;
            }

            if (productField[0].readAttribute('selected') === 'false') {
                productField[0].remove();
                return false;
            }

            return true;
        }
        return selected;
    },

    /**
     * Toggles between paypal button and regular submit button
     * @param {type} show
     * @returns {unresolved}
     */

    togglePaypalButtons: function (show) {
        // eslint-disable-next-line no-var
        var paymentFieldId = $$('input[name="simple_fpc"]')[0].value;
        // if this is paypal pro and credit card payment is selected
        if ($('input_' + paymentFieldId + '_paymentType_express')
            && !$('input_' + paymentFieldId + '_paymentType_express').checked) {
            show = false;
        }
        // if checkout button is not to be used
        if ($$('.paypal-button').length < 1 || !$('use_paypal_button')) {
            return;
        }
        // replace all submit buttons with express checkout buttons
        $$('.form-submit-button').each(function (btn) {
            if (show) {
                if (btn.up().down('.paypal-button')) {
                    btn.up().down('.paypal-button').show();
                    btn.hide();
                }
            } else {
                if (btn.up().down('.paypal-button')) {
                    btn.up().down('.paypal-button').hide();
                }
                btn.show();
            }
        });
    },

    /*
     * Handles toggling between PayPal checkout buttons
     * and ordinary submit buttons
     * @returns {undefined}
     */

    handlePaypalButtons: function () {
        // eslint-disable-next-line no-var
        var products = window.productID;
        // eslint-disable-next-line no-var
        var requiredPayment = false;
        // eslint-disable-next-line no-var
        var paymentFieldId = $$('input[name="simple_fpc"]')[0].value;
        // check if payment is required
        if (products) {
            $H(products).each(function (p) {
                // if required
                if ($(p.value).getAttribute('class').indexOf('[required]') > -1) {
                    requiredPayment = true;
                    throw $break;
                }
            });
        } else if ($('input_' + paymentFieldId + '_donation')) {
            requiredPayment = $('input_' + paymentFieldId + '_donation').getAttribute('class').indexOf('required') > -1;
        }
        // toggle upon form load
        JotForm.togglePaypalButtons(requiredPayment || JotForm.isPaymentSelected());

        // set button trigger if payment is not required
        if (!requiredPayment) {
            $H(products).each(function (p) {
                $(p.value).observe('click', function () {
                    JotForm.togglePaypalButtons(JotForm.isPaymentSelected());
                });
            });
        }
    },

    paymentDropdownHandler: function(uid, onChange) {
        // eslint-disable-next-line no-var
        var dropdown = null;

        if (uid) {
            dropdown = document.getElementById(uid);
        } else if (document.querySelectorAll('.payment-dropdown').length > 0) {
            dropdown = document.querySelectorAll('.payment-dropdown')[0];
        }

        if (!dropdown){ return; };

        // eslint-disable-next-line no-var
        var selectArea = dropdown.querySelector('.select-area');
        // eslint-disable-next-line no-var
        var selectedValueArea = selectArea.querySelector('.selected-value');
        // eslint-disable-next-line no-var
        var options = dropdown.querySelectorAll('.option');
        // eslint-disable-next-line no-var
        var productCategoryDropdown = document.querySelector('#payment-category-dropdown');

        options.forEach(function(option){
            option.addEventListener('click', function(event){
                // eslint-disable-next-line no-var
                var option = event.target;
                // eslint-disable-next-line no-var
                var optionVal = option.getAttribute('data-value');
                // eslint-disable-next-line no-var
                var selectedOption = {};

                // Step-3: Find selected categories
                options.forEach(function(opt){
                    if (opt.getAttribute('data-value') === optionVal){
                        selectedOption = {
                            label: opt.innerText.trim(),
                            value: optionVal
                        };
                    }
                });

                // Step - 5 : Update the selected-value
                if (!selectedOption.value || selectedOption.value === 'clear') {
                    dropdown.classList.remove('option-selected');
                } else {
                    dropdown.classList.add('option-selected');
                }

                if (selectedOption.value !== 'clear') {
                    selectedValueArea.innerText = selectedOption.label;
                } else {
                    selectedValueArea.innerText = '';
                }

                dropdown.classList.remove('open');
                selectArea.setAttribute('aria-expanded', 'false');

                onChange(selectedOption);
            });
        });

        selectArea.addEventListener('click', function(){
            if (dropdown.classList.contains('open')){
                dropdown.classList.remove('open');
                selectArea.setAttribute('aria-expanded', 'false');
            } else {
                dropdown.classList.add('open');
                selectArea.setAttribute('aria-expanded', 'true');
            }
        });

        window.addEventListener('click', function(event) {
            if ( event.target && !event.target.closest('#payment-sorting-products-dropdown')) {
                dropdown.classList.remove('open');
            }

            if (event.target && !event.target.closest('#payment-category-dropdown')) {
                if (productCategoryDropdown && productCategoryDropdown.classList.contains('open')) {
                    productCategoryDropdown.classList.remove('open');
                }
            }
        });
    },

    /**
     * Handles multi-select dropdown controls
     * @returns{undefined}
    */
    multiSelectDropdownHandler: function(onChange){
        // eslint-disable-next-line no-var
        var dropdown = document.querySelector('.multi-select-dropdown');
        if (!dropdown) {
            return;
        }

        // eslint-disable-next-line no-var
        var selectArea = dropdown.querySelector('.select-area');
        // eslint-disable-next-line no-var
        var selectedValueArea = selectArea.querySelector('.selected-values');
        // eslint-disable-next-line no-var
        var options = dropdown.querySelectorAll('.option');
        // eslint-disable-next-line no-var
        var dropdownHint = selectArea.querySelector('.dropdown-hint');

        options.forEach(function(option){
            option.addEventListener('click', function(event){
                // eslint-disable-next-line no-var
                var clickedItem = event.target;
                // eslint-disable-next-line no-var
                var closestOption = clickedItem.closest('.option') || clickedItem;
                // eslint-disable-next-line no-var
                var input = closestOption.querySelector('input');
                // eslint-disable-next-line no-var
                var clickedItemValue = input.value;
                // eslint-disable-next-line no-var
                var selectedOptions = [];

                // Step-1: Set input value
                if (clickedItem.nodeName !== 'INPUT'){ input.checked = !input.checked; } // If clickedItem dom type is not input, check it.

                // Step-2: Clear and set initial class value
                if (input.checked) { // If true; it means we will enable to selection.
                    // If all selected; clear other categories
                    if (clickedItemValue === 'All'){
                        options.forEach(function(opt){
                            // eslint-disable-next-line no-var
                            var inp = opt.select('input')[0];
                            if (inp.value !== 'All') {
                                inp.checked = false;
                                opt.classList.remove('selected');
                            }
                        });
                    } else { // If another categories selected, clear only "all" option.
                        options[0].classList.remove('selected');
                        options[0].querySelector('input').checked = false;
                    }

                    closestOption.classList.add('selected');
                } else {
                    closestOption.classList.remove('selected');
                }

                // Step-3: Find selected categories
                options.forEach(function(opt){
                    if (opt.classList.contains('selected')){
                        selectedOptions.push({
                            label: opt.querySelector('span').innerText,
                            value: opt.querySelector('input').value
                        });
                    }
                });

                // Step-4: If select all enabled
                if (dropdown.classList.contains('hasSelectAll') && selectedOptions.length === 0){
                    options[0].classList.add('selected');
                    options[0].querySelector('input').checked = true;
                    selectedOptions.push({
                        label: options[0].querySelector('span').innerText,
                        value: options[0].querySelector('input').value
                    });
                }

                // Step - 5 : Update the selected-value
                if (selectedOptions[0] === 'All') {
                    dropdownHint.show();
                } else {
                    dropdownHint.hide();
                }

                // eslint-disable-next-line no-var
                var selectedOptionsValues = selectedOptions.map(function(s) { return s.value; });
                // eslint-disable-next-line no-var
                var selectedOptionsLabel = selectedOptions.map(function(s) { return s.label; });

                selectedValueArea.innerText = selectedOptionsLabel.join(', ');

                if (selectedOptions[0].value === 'All' || (JotForm.isVisible(dropdownHint) && selectedOptions[0].value === 'All')) {
                    selectedValueArea.classList.add('all_selected');
                } else if (selectedValueArea.hasClassName('all_selected')) {
                    selectedValueArea.classList.remove('all_selected');
                }
                onChange(selectedOptions, selectedOptionsLabel, selectedOptionsValues);
            });
        });

        selectArea.addEventListener('click', function() {
            dropdown.classList.toggle('open');
            selectArea.setAttribute('aria-expanded', dropdown.classList.contains('open').toString());
        });

        window.addEventListener('click', function(event) {
            if (event.target && (!event.target.closest('#payment-category-dropdown') && !event.target.closest('#payment-sorting-products-dropdown'))) {
                dropdown.classList.remove('open');
            }
        });
    },

    /**
     * Handles category dropdown controls for Payment Fields
     * @returns{undefined}
     */

    handleProductCategoryDropdown: function (){
        this.multiSelectDropdownHandler(function(selectedCategories, selectedCategoriesLabels, selectedCategoriesValues){
            // eslint-disable-next-line no-var
            var dropdown = document.getElementById('payment-category-dropdown');
            // eslint-disable-next-line no-var
            var allCategoryTitles = document.querySelectorAll('.form-product-category-item');
            // eslint-disable-next-line no-var
            var isCategoryTitleEnabled = dropdown && dropdown.hasClassName('category-title-enabled');
            // eslint-disable-next-line no-var
            var products = document.querySelectorAll('.form-product-item');
            // eslint-disable-next-line no-var
            var productSortingProductsDropdown = document.querySelector('#payment-sorting-products-dropdown');

            if (products.length === 0){ return; }

            // Handle Products
            // Handle Products
            products.forEach(function(p){
                // eslint-disable-next-line no-var
                var product = p;
                product.classList.remove('not-category-found');

                if (selectedCategories[0].value !== 'All'){
                    if (!isCategoryTitleEnabled){
                        // eslint-disable-next-line no-var
                        var productCategories = product.getAttribute('categories') ? product.getAttribute('categories').split(',') : [];

                        if (productCategories){
                            // eslint-disable-next-line no-var
                            var isCategoryFound = false;

                            productCategories.forEach(function(productCategory){
                                if (selectedCategoriesValues.includes(productCategory)){
                                    isCategoryFound = true;
                                }
                            });

                            if (!isCategoryFound){
                                product.classList.add('not-category-found');
                            }
                        }
                    } else {
                        if (!selectedCategoriesValues.includes(product.getAttribute('active-category'))){
                            product.classList.add('not-category-found');
                        }
                    }
                }
            });

            if (allCategoryTitles.length === 0 && !isCategoryTitleEnabled){ return; }

            // Handle Category Titles
            allCategoryTitles.forEach(function(categoryTitle){
                categoryTitle.classList.remove('not-category-found');

                if (selectedCategories[0].value !== 'All'){
                    if (!selectedCategoriesValues.includes(categoryTitle.getAttribute('category'))){
                        categoryTitle.classList.add('not-category-found');
                    } else {
                        categoryTitle.classList.remove('not-category-found');
                    }
                }
            });

            window.addEventListener('click', function(event) {
                if ( event.target && !event.target.closest('#payment-category-dropdown')) {
                    dropdown.classList.remove('open');
                }
                if (event.target && !event.target.closest('#payment-sorting-products-dropdown')) {
                    if( productSortingProductsDropdown && productSortingProductsDropdown.classList.contains('open')){
                        productSortingProductsDropdown.classList.remove('open');
                    }
                }

            });
        });

        // Attached click event to every form-product-category-item for recalculate iframe height
        if (isIframeEmbedFormPure()) {
            document.querySelectorAll('.form-product-category-item').forEach(function (productCategory) {
                productCategory.addEventListener('click', callIframeHeightCaller);
            });
        }
    },

    initPaymentProperties: function(initValues) {
        try {
            if (!initValues) { return; }
            if (Object.keys(initValues).length === 0) { return; }
            JotForm.paymentProperties = JSON.parse(initValues);
        } catch (err) {
            console.error(err);
        }
    },

    /*
     * Checks whether form is embedded or not
     * Sends url of the form's parent page
     * @returns {undefined}
     */
    checkEmbed: function () {
        if (window !== window.top) {
            const embedUrl = document.get !== undefined && document.get.jsForm === 'true' && document.get.parentURL ? document.get.parentURL : document.referrer;

            appendHiddenInput('embedUrl', embedUrl);

            if (JotForm.debug) console.log(embedUrl);

            // If the form redirects to an external URL after submission (activeRedirect === 'thankurl'), we need to set the target of the form to _top. This prevents issues with the browsers
            // history which can result in duplicate submissions, particularly in iOS Safari. See L3 ticket #123301. Currently this is only enabled for specific hostnames for testing.
            if (JotForm.activeRedirect === 'thankurl' && document.referrer && ['www.speedeebeer.com', 'jamesjohnmadden.github.io'].includes(new URL(document.referrer).hostname)) {
                JotForm.forms.forEach(form => form.setAttribute('target', '_top'));
            }
        }
    },
    /*
     * Checks whether form is opened within a pwa or not
     * Sends pwa id
     * @returns {undefined}
     */
    checkPwa: function() {
        if (window.location.href.indexOf('jotform_pwa=1') > -1) {
            if (window.location.href.indexOf('pwa_id=') === -1) {
                return new Error('AppId couldn\'t be found!');
            }

            // eslint-disable-next-line no-var
            var hiddenInputs = [
                { name: 'jotform_pwa', val: 1 },
                { name: 'pwa_id', val: document.get.pwa_id },
                { name: 'pwa_isPWA' },
                { name: 'pwa_device' }
            ];
            hiddenInputs.forEach(function (inp) {
                if (inp.val || document.get[inp.name]) {
                    appendHiddenInput(inp.name, inp.val || document.get[inp.name]);
                }
            });
        }
    },
    /**
     * Handles Paypal Express actions
     * @returns {undefined}
     */

    handlePaypalExpress: function () {
        if (typeof _paypalExpress !== "function" || $('express_category').getAttribute('data-digital_goods') === "No") {
            return;
        }
        // eslint-disable-next-line no-var, no-undef
        var paypalExpress = new _paypalExpress();
        paypalExpress.init();
    },

    /**
     * Handles echeck actions
     * @returns {undefined}
     */

    handleEcheck: function () {
        if (typeof _echeck !== "function") {
            return;
        }
        // eslint-disable-next-line no-var, no-undef
        var echeck = new _echeck();
        echeck.init();
    },

    /**
     * Handles Braintree payments
     */

    handleBraintree: function () {
        // skip on edit mode
        if (window.location.pathname.match(/^\/edit/) || (["edit", "inlineEdit", "submissionToPDF"].indexOf(document.get.mode) > -1 && document.get.sid)) {
            return;
        }
        if (typeof __braintree !== "function") {
            alert("Braintree payment script didn't work properly. Form will be reloaded");
            location.reload();
            return;
        }
        // eslint-disable-next-line no-undef
        JotForm.braintree = __braintree();
        JotForm.braintree.init();
    },

    handlePagseguro: function () {
      // skip on edit mode
      if (window.location.pathname.match(/^\/edit/) || (["edit", "inlineEdit", "submissionToPDF"].indexOf(document.get.mode) > -1 && document.get.sid)) {
        return;
      }
      if (typeof __pagseguro !== "function") {
        alert("PagSeguro payment script didn't work properly. Form will be reloaded");
        location.reload();
        return;
      }
      // eslint-disable-next-line no-undef
      JotForm.pagseguro = __pagseguro();
      JotForm.pagseguro.init();
    },

    handleSquare: function () {
        // skip on edit mode
        if (/*JotForm.paidSubmission && */(window.location.href.match(/mode=inlineEdit/) || window.location.pathname.match(/^\/\/edit/) || window.location.pathname.match(/^\/edit/) || window.location.href.match(/mode=submissionToPDF/)) && document.get.sid) { // ["edit", "inlineEdit", "submissionToPDF"].indexOf(document.get.mode) > -1 does not work, JotForm.paidSubmission is unreachable from here (set in form.edit.mode.js)
            return;
        }

        // force https on standalone forms
        if (window === window.top) {
            if (window.location.protocol !== 'https:') {
                window.location.href = window.location.href.replace('http', 'https');
                return;
            }
        }

        if (typeof __square !== "function") {
            alert("Square payment script didn't work properly. Form will be reloaded");
            location.reload();
            return;
        }

        const searchParams = new URLSearchParams(window.location.search);
        const inputUseSquareFormPayment = document.getElementById('useSquareFormPayment');
        if (inputUseSquareFormPayment) {
          if (searchParams.get('useSquareFormPayment') === '1') {
            inputUseSquareFormPayment.value = 1;
          } else {
            inputUseSquareFormPayment.remove();
          }
        }

        // eslint-disable-next-line no-undef
        JotForm.squarePayment = __square();
        JotForm.squarePayment.loadSquareScript(function() {
          JotForm.squarePayment.init();
        });
    },

    handleSensepass: function () {
        if (JotForm.isEditMode() || JotForm.isDirectFlow === 'No') return;

        if (typeof __sensepass !== "function") {
            alert("Sensepass payment script didn't work properly. Form will be reloaded");
            location.reload();
            return;
        }

        // eslint-disable-next-line no-undef
        JotForm.sensepassPayment =  __sensepass();
        JotForm.sensepassPayment.init();
    },

    handleStripeACH: function () {
      if (JotForm.isEditMode()) return;

      if (typeof __stripeACH === "undefined") {
        alert("Stripe ACH payments script didn't work properly. Form will be reloaded. ");
        location.reload();
        return;
      }

      // eslint-disable-next-line no-undef
      JotForm.stripeACH =  __stripeACH;
      JotForm.stripeACH.init();
    },

    handleMollie: function () {
      if (JotForm.isEditMode()) return;

      if (typeof __mollie === "undefined") {
        alert("Mollie script didn't work properly. Form will be reloaded. ");
        location.reload();
        return;
      }

      // eslint-disable-next-line no-undef
      JotForm.mollie =  __mollie;
      JotForm.mollie.init();
    },

    handleBluepay: function () {
      if (JotForm.isEditMode()) return;

      if (typeof __bluepay === "undefined") {
        alert("Bluepay script didn't work properly. Form will be reloaded. ");
        location.reload();
        return;
      }

      // eslint-disable-next-line no-undef
      JotForm.bluepay =  __bluepay;
      JotForm.bluepay.init();
    },

    handlePaypalSPB: function () {
      // eslint-disable-next-line no-undef
      JotForm.paypalSPB = __paypalSPB;
      try {
        JotForm.paypalSPB.init();
        JotForm.paypalSPB.render();
      } catch(e) {
        console.error(e);
        if (typeof e === 'string') {
          alert(e);
          return;
        }
        alert("There was a problem with PayPal Smart Payment Buttons integration.");
      }
    },

    /**
     * Handles the payment subproducts behavior
     */

    handlePaymentSubProducts: function () {

        // eslint-disable-next-line no-var
        var heights = [];                   // container for the heights of the products when opened and closed
        // eslint-disable-next-line no-var
        var optionValues = [];              // container for the values of the properties when opened and closed
        // eslint-disable-next-line no-var
        var sections = document.querySelectorAll('.form-section'); // get the sections if there are page breaks
        // eslint-disable-next-line no-var
        var productPage = false;            // page where the payment field is

        document.querySelectorAll('.form-product-has-subproducts').forEach(function (sp) {

            // eslint-disable-next-line no-var
            var formLine = sp.closest(".form-line");
            // eslint-disable-next-line no-var
            var wasHidden = false;
            if(formLine && formLine.classList.contains("form-field-hidden")){
                formLine.style.display = '';
                wasHidden = true;
            }
            // if this form has page breaks,
            if (sections.length > 1) {
                // get the page where the payment field is
                productPage = productPage ? productPage : sections.filter(function (p) {
                    // eslint-disable-next-line no-var
                    var closestFormSection = sp.closest('.form-section');
                    return closestFormSection && closestFormSection === p;
                })[0];
                // if this page is hidden
                if (!productPage.isVisible()) {
                    // show page temporarily
                    productPage.setStyle({'display': 'block'});
                    // get the height of the product
                    heights[sp.id] = [sp.parentNode.offsetHeight, document.querySelector('label[for="' + sp.id + '"]').offsetHeight];
                    // hide the page
                    productPage.setStyle({'display': 'none'});
                } else {
                    heights[sp.id] = [sp.parentNode.offsetHeight, document.querySelector('label[for="' + sp.id + '"]').offsetHeight];
                }
            } else {
                heights[sp.id] = [sp.parentNode.offsetHeight, document.querySelector('label[for="' + sp.id + '"]').offsetHeight];
            }

            sp.addEventListener('click', function () {
                showSubProducts(this);
                JotForm.countTotal();
            });

            if(wasHidden) {
                // eslint-disable-next-line no-var
                var formLine = sp.closest(".form-line");
                if (formLine) {
                    formLine.style.display = 'none';
                }
            }
        });

        function showSubProducts(el) {

            // eslint-disable-next-line no-var
            var productSpan = el.parentNode;

            if (!el.checked) {
                productSpan.shift({
                    height: heights[el.id][1],
                    duration: 0.3,
                    onEnd: JotForm.handleIFrameHeight
                });

              // if product has expanded options/subproduct and product has a description
              if (el.value && el.value.indexOf('_expanded') > -1 && productSpan.querySelector('.form-product-description') && productSpan.querySelector('.form-product-description').childNodes[0] && productSpan.querySelector('.form-product-description').childNodes[0].nodeValue.trim() !== "") {
                  productSpan.shift({
                    height: heights[el.id][1]+20
                  });
                }
                // clear the values array
                optionValues[el.id] = [];


                JotForm.clearProductValues(el, optionValues);
            } else {
                productSpan.shift({
                    height: heights[el.id][0] - 10,
                    duration: 0.3,
                    onEnd: JotForm.handleIFrameHeight
                });
                // populate values
                JotForm.populateProductValues(el, optionValues);
            }
            // resume calculation
            setTimeout(function () {
                JotForm.totalCounter(JotForm.prices)
            }, 300);
        };
    },

    clearProductValues: function (el, optionValues) {
        document.querySelectorAll('#' + el.id + '_subproducts select,' + '#' + el.id + '_subproducts input[type="text"]').forEach(function (field) {
            // capture the values
            // eslint-disable-next-line no-var
            var fieldValue = field.tagName === "select" ? field.options[field.selectedIndex].value : field.value;
            if (fieldValue) {
                optionValues[el.id].push([field.id, fieldValue]);
            }
            // pause calculation functions to avoid potential browser crash
            field.stopObserving();
            // clear values
            if (field.tagName === "SELECT") {
                field.selectedIndex = 0;
            } else {
                field.value = 0;
            }
        });
    },

    clearProductValuesV1: function (el, optionValues) {
        document.querySelectorAll('#' + el.id + '_subproducts select,' + '#' + el.id + '_subproducts input[type="text"]').forEach(function (field) {
            // capture the values
            // eslint-disable-next-line no-var
            var fieldValue = field.tagName === "select" ? field.options[field.selectedIndex].value : field.value;
            if (fieldValue) {
                optionValues[el.id].push([field.id, fieldValue]);
            }
            // pause calculation functions to avoid potential browser crash
            field.stopObserving('blur');
            field.stopObserving('focus');

            // clear values
            if (field.tagName === "SELECT") {
                field.selectedIndex = 0;
            } else {
                field.value = 0;
            }
        });
    },

    populateProductValues: function (el, optionValues) {
        if (optionValues[el.id] && optionValues[el.id].length > 0) {
            optionValues[el.id].each(function (vv) {
                // pause calculation functions to avoid potential browser crash
                $(vv[0]).stopObserving();
                $$("#" + vv[0] + ".form-product-custom_quantity").each(function(el){el.observe('blur', function(){isNaN(this.value) || this.value < 1 ? this.value = '0' : this.value = parseInt(this.value)})}); // Add event listeners again when re-opening the sub products
                $$("#" + vv[0] + ".form-product-custom_quantity").each(function(el){el.observe('focus', function(){this.value == 0 ? this.value = '' : this.value})});;
                if ($(vv[0]).tagName === "SELECT") {
                    $(vv[0]).selectOption(vv[1]);
                } else {
                    $(vv[0]).value = vv[1];
                }
            });
        }
    },

    populateProductValuesV1: function(el, optionValues) {
        if (optionValues[el.id] && optionValues[el.id].length > 0) {
            optionValues[el.id].each(function (vv) {
                // pause calculation functions to avoid potential browser crash
                $(vv[0]).stopObserving('blur');
                $(vv[0]).stopObserving('focus');

                $$("#" + vv[0] + ".form-product-custom_quantity").each(function(el){el.observe('blur', function(){isNaN(this.value) || this.value < 1 ? this.value = '0' : this.value = parseInt(this.value)})}); // Add event listeners again when re-opening the sub products
                $$("#" + vv[0] + ".form-product-custom_quantity").each(function(el){el.observe('focus', function(){this.value == 0 ? this.value = '' : this.value})});;

                if ($(vv[0]).tagName === "SELECT") {
                    if (vv[1] !== "0") {
                        $(vv[0]).selectOption(vv[1]);
                    }
                } else {
                    $(vv[0]).value = vv[1];
                }
            });
        }
    },

    handlePaymentSubProductsV1: function () {
      const selectedValues = [];
      document.querySelectorAll('.form-product-has-subproducts').forEach(function (sp) {
          sp.addEventListener('click', function () {
              const formProductItem = sp.closest(".form-product-item");
              if (sp.checked) {
                  formProductItem.classList.remove('sub_product');
                  formProductItem.classList.add('show_sub_product');
                  JotForm.populateProductValuesV1(sp, selectedValues);
              } else {
                  formProductItem.classList.remove('show_sub_product');
                  formProductItem.classList.add('sub_product');
                  selectedValues[sp.id] = [];
                  JotForm.clearProductValuesV1(sp, selectedValues);
                  if (typeof PaymentStock !== 'undefined') {
                    // eslint-disable-next-line no-undef
                    PaymentStock.handleStockManagement();
                  }
              }
              JotForm.countTotal();
          });
      });
    },

    /**
     * handles toggling of lightbox for product images
     */
    handleProductLightbox: function () {
        document.querySelectorAll('.form-product-image-with-options').forEach(function (image) {
            image.addEventListener('click', function () {
                const pid = image.closest('.form-product-item').getAttribute('pid');
                if (isIframeEmbedFormPure()) {
                    onProductImageClicked(pid, true);
                } else {
                    onProductImageClicked(pid, false);
                }
            });
        });
    },

    /*
     * sets currency formatting for payment fields
     */

    setCurrencyFormat: function (curr, useDecimal, decimalMark) {
        // currencies without decimal values
        // eslint-disable-next-line no-var
        var noDecimal = ['BIF', 'CLP', 'DJF', 'GNF', 'JPY', 'KMF', 'KRW', 'MGA', 'PYG', 'RWF', 'VUV', 'XAF', 'XOF', 'XPF'];
        // eslint-disable-next-line no-var
        var decimalPlaces = noDecimal.indexOf(curr) > -1 || !useDecimal ? 0 : 2;
        this.currencyFormat = {
            curr: curr,
            dSeparator: decimalMark == "comma" ? "," : ".",
            tSeparator: decimalMark == "comma" ? "." : ",",
            decimal: decimalPlaces,
            decimalMark: decimalMark
        };
    },

    setCustomPriceSource: function (pairKey) {
        if (pairKey) {
            const customFirstPaymentPriceData = document.querySelector(`[id="${pairKey}_custom_first_payment_price"]`);
            const customPriceSourceData = document.querySelector(`[id="${pairKey}_custom_price"]`);

            if (customFirstPaymentPriceData && customFirstPaymentPriceData.hasAttribute('data-price-source')) {
                const firstCustomPriceSourceKey = customFirstPaymentPriceData.getAttribute('data-price-source');
                if (firstCustomPriceSourceKey) {
                    const firstCustomPriceSourceInput = document.getElementById('input_' + firstCustomPriceSourceKey);
                    if (firstCustomPriceSourceInput) {
                        firstCustomPriceSourceInput.value = customFirstPaymentPriceData.value;
                    }
                }
            }

            if (customPriceSourceData && customPriceSourceData.hasAttribute('data-price-source')) {
                // eslint-disable-next-line no-var
                var customPriceSourceKey = customPriceSourceData.getAttribute('data-price-source');
                if (customPriceSourceKey) {
                    const customPriceSourceInput = document.getElementById('input_' + customPriceSourceKey);
                    if (customPriceSourceInput) {
                        customPriceSourceInput.value = customPriceSourceData.value;
                    }
                }
            }
        }
    },

    /**
     * Calculates the payment total with quantites
     * @param {Object} prices
     */
    countTotal: function (prices) {
        // eslint-disable-next-line no-var
        var prices = prices || JotForm.prices;
        // eslint-disable-next-line no-var
        var discounted = false;
        // eslint-disable-next-line no-var
        var roundAmount = function (num, decimalPlaces) {
            return parseFloat(JotForm.morePreciseToFixed(num, decimalPlaces));
        }
        // If a coupon is entered and verified
        if (Object.keys(JotForm.discounts).length > 0) {
            discounted = true;
            // if this is a discount for order total
            if (JotForm.discounts.total || JotForm.discounts.shipping) {
                // eslint-disable-next-line no-var
                var type = JotForm.discounts.type,
                    rate = JotForm.discounts.rate,
                    minimum = JotForm.discounts.minimum,
                    code = JotForm.discounts.code;

            } else {
                // If for product items
                // eslint-disable-next-line no-var
                for (var pid in prices) {
                    // eslint-disable-next-line no-var
                    for (var kkey in JotForm.discounts) {
                        if (pid.indexOf(kkey) !== -1) {
                            prices[pid].discount = JotForm.discounts[kkey];
                        }
                    }
                }
            }
        } else {
            $H(prices).each(function (p) {
                delete prices[p.key].discount;
            });
        }

        // eslint-disable-next-line no-var
        var total = 0;          // total for the whole payment field
        // eslint-disable-next-line no-var
        var totalWithoutDiscount = 0;
        // eslint-disable-next-line no-var
        var subTotal = 0;       // subTotal for all items selected, excluding shipping or taxes
        // eslint-disable-next-line no-var
        var subTotalWithoutDiscount = 0;
        // eslint-disable-next-line no-var
        var itemSubTotal = [];  // subTotal for a group of subproducts
        // eslint-disable-next-line no-var
        var shippingTotal = 0;  // total shipping cost
        // eslint-disable-next-line no-var
        var taxTotal = 0;       // total tax cost
        // eslint-disable-next-line no-var
        var taxTotalWithoutDiscount = 0;       // total tax cost
        // eslint-disable-next-line no-var
        var otherTotal = 0;     // shipping and tax total
        // eslint-disable-next-line no-var
        var otherTotalWithoutDiscount = 0;     // shipping and tax total
        // eslint-disable-next-line no-var
        var taxRate = 0;        // uniform tax rate (percentage) for the non-exempted products
        // eslint-disable-next-line no-var
        var currency = JotForm.currencyFormat.curr; // number of decimal places to use
        // eslint-disable-next-line no-var
        var decimal = JotForm.currencyFormat.decimal; // number of decimal places to use
        // eslint-disable-next-line no-var
        var dSeparator = JotForm.currencyFormat.dSeparator;
        // eslint-disable-next-line no-var
        var tSeparator = JotForm.currencyFormat.tSeparator;
        // eslint-disable-next-line no-var
        var decimalMark = JotForm.currencyFormat.decimalMark;
        // eslint-disable-next-line no-var
        var flatShipping = 0;
        // eslint-disable-next-line no-var
        var products = 0;
        // eslint-disable-next-line no-var
        var formProductItem = null;
        // eslint-disable-next-line no-var
        var firstPaymentVal = 0;
        // eslint-disable-next-line no-var
        var recurringVal = 0;
        // eslint-disable-next-line no-var
        var firstPaymentDiscount;
        // eslint-disable-next-line no-var
        var recurPaymentDiscount;

        // eslint-disable-next-line no-var
        var pricingInformations = [];     // This variable holds each item informations
        // eslint-disable-next-line no-var
        var noCostItems = [];

        //* clean discount area
        if (
            JotForm.discounts &&
            Object.keys(JotForm.discounts).length > 0 &&
            window.paymentType === 'subscription' &&
            document.querySelector('.form-payment-discount')
        ) {
            document.querySelector('.form-payment-discount').remove();
        }
        $H(prices).each(function (pair) {
            // eslint-disable-next-line no-var
            var subproduct = false;  // is this a subproduct?
            // eslint-disable-next-line no-var
            var parentProductKey;    // subproduct's parent key (see http://www.jotform.com/help/264-Create-Sub-Products-Based-on-a-Product-Option)
            // eslint-disable-next-line no-var
            var price = parseFloat(pair.value.price) || 0;   // price for the individual product
            // eslint-disable-next-line no-var
            var parsedPair = pair.key.split("_");
            // eslint-disable-next-line no-var
            var label = parsedPair[0] + '_' + parsedPair[1] + '_' + parsedPair[2];
            formProductItem = $(label) ? $(label).up('.form-product-item') : null;
            // eslint-disable-next-line no-undef
            formProductInput = formProductItem && formProductItem.down('.form-product-input');
            firstPaymentDiscount = 0;
            recurPaymentDiscount = 0;

            // get the parent product id if this is a subproduct
            if (pair.key.split('_').length === 4) {
                subproduct = true;
                // get the parent product key/id
                parentProductKey = pair.key.split('_');
                parentProductKey.pop();
                parentProductKey = parentProductKey.join("_");
                // initalize item subTotal for this subproduct group
                itemSubTotal[parentProductKey] = itemSubTotal[parentProductKey] || 0;
            } else {
                parentProductKey = pair.key;
            }

            // eslint-disable-next-line no-undef
            if ((!JotForm.couponApplied && formProductInput && !formProductInput.checked) && pair.value.specialPriceField === undefined) {
                // reset connected item subtotals if any
                if (
                    $(parentProductKey + '_item_subtotal') && !isNaN(price)
                    && JotForm.categoryConnectedProducts && Object.keys(JotForm.categoryConnectedProducts).length > 0
                    && JotForm.categoryConnectedProducts[pair.key.split('_')[2]]
                ) {
                    JotForm.categoryConnectedProducts[pair.key.split('_')[2]].forEach(pid => {
                        const itemArr = parentProductKey.split('_');
                        itemArr[2] = pid;
                        if ($(itemArr.join('_') + '_item_subtotal')) {
                            $(itemArr.join('_') + '_item_subtotal').update(parseFloat(0).formatMoney(decimal, dSeparator, tSeparator));
         